<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if (IPN_PROCESS !== true && $_SESSION['adminlogin'] === false) {
	echo 'Giveaway Not Executed!';
	exit;
}
/**
 * These variables are used from Finalize.inc.php
 * 
 * $program_id = The ID of the master program.
 * $payer_username = The username of the member doing the payment.
 */	

$selectFields = 'program_link';
$mainTable = 'program';
$where = [
    'program_id' => ['=', $program_id]
];
$show_debug = 1;

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;
	
if (!empty($buffer['program_link'])) {
	
	$linked_programs = explode(' ', $buffer['program_link']);	
	
	$selectFields = 'user.user_program_id, user.program_id, prog.program_up';
	$mainTable = ['table' => 'members', 'as' => 'memb'];
	$joinConditions = [
		['table' => 'user_program', 'as' => 'user', 'condition' => 'memb.ID = user.ID'],
		['table' => 'program', 'as' => 'prog', 'condition' => 'user.program_id = prog.program_id']
	];
	$where = [
		'memb.Username' => ['=', $payer_username],
		'user.program_id' => ['IN', array_merge([0], $linked_programs)]
	];
	$show_debug = 1;

	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);

	foreach ($result as $buffer) {

		if (!empty($buffer['program_up_order'])) $program_up_order = explode(' ', $buffer['program_up_order']);	
		else $program_up_order = array(0);

		$max_pass_up_give = max($program_up_order);
	
		$selectFields = 'sign_id';
		$mainTable = 'user_program';
		$where = [
			'sponsorid' => ['=', $buffer['sponsorid']],
			'program_id' => ['=', $buffer['program_id']]
		];
		$orderBy = 'sign_id DESC';
		$limit = 1;
		$show_debug = 1;

		$result2 = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
		$buffer2 = isset($result2[0]) ? $result2[0] : null;
		$num_rows = is_array($result2) ? count($result2) : 0;
	
		if ($buffer2['sign_id'] != 0 || $num_rows != 0) {
	 
			$max_sign_id_give = $buffer2['sign_id']+1; 
		
		} else {
			$max_sign_id_give = $buffer2['sign_id']+1; 
			// SAME EDIT NEEDED IN Sub/unpaid-upgrade.inc.php!!
			// QQQ for standard 1-up program use next line to make user qualified in child program
			//$max_sign_id_give = 2;
		}

		// QQQ PROG IS REV 1-UP 
		//$max_sign_id_give = 3;
		$timestamp = time();

		// MAKE USER COMPED IN CHILD PROGRAM(S)
		$data = [
			'user_status' => 'Comped',
			'started' => $timestamp,
			'user_signup' => $max_pass_up_give,
			'end_program' => 'N',
			'program_linked' => 'Y',
			'program_linked_to' => $program_id
		];
		$where = [
			'user_program_id' => ['=', $buffer['user_program_id']]
		];
		$show_debug = 1;

		update('user_program', $data, [], $where, 1, 1, $show_debug);
		
		
		// MAKE USER ACTIVE FOR ONE MONTH
		// ADDED FOR CASES WHERE MASTER PROGRAM IS A ONE TIME FEE, AND THUS EXPIRE TIME HAS NOT BEEN SET UP IN FINALIZE
		$expire_timestamp = strtotime('+1 month', $timestamp); // QQQ SET PER PROGRAM WHEN SUB PERIOD NOT 1 MONTH!
		
		//mysql_query("UPDATE user_program SET user_status='Active', started='{$timestamp}', expire='{$expire_timestamp}', user_signup={$max_pass_up_give}, end_program='N', program_linked='Y', program_linked_to='{$program_id}' WHERE user_program_id={$buffer['user_program_id']}") or die('Qualify.give ERROR 47'.mysql_error());		
		
		// DO NOT CHANGE SIGN ID WHERE IT ALREADY EXISTS!!	
		$data = [
			'sign_id' => $max_sign_id_give
		];
		$where = [
			'user_program_id' => ['=', $buffer['user_program_id']],
			'sign_id' => ['=', 0]
		];
		$show_debug = 1;

		update('user_program', $data, [], $where, 1, 1, $show_debug);
		
		// SHOULD WE AUTO QUALIFY THE NEW USER?
		$data = [
			'user_qualify' => $buffer['program_up'],
			'user_qualify_perm' => $buffer['program_up']
		];
		$where = [
			'user_program_id' => ['=', $buffer['user_program_id']]
		];
		$show_debug = 1;

		update('user_program', $data, [], $where, 1, 1, $show_debug);
		
		$program_up = $buffer['program_up'];

	} // END LOOP
} // END CHILD PROGRAMS NOT EMPTY


// QQQ KLUDGE
// AUTO Q EVERYONE IN THE PROGRAM THEY ARE BUYING
// EFFECTIVELY MAKING IT A 1 TIER SYSTEM UNTIL THIS IS COMMENTED
$data = [
	'user_qualify' => $program_up,
	'user_qualify_perm' => $program_up
];
$where = [
    'user_program_id' => ['=', $user_program_id]
];
$show_debug = 1;

update('user_program', $data, [], $where, 1, 1, $show_debug);

	
?>