<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// FILE BORN FROM FASTTRACK 2X2 mat_place_functions.php
// JS CREATING NEW PERSONALLY FILLED 2x10 MATRIX 12/6/22
// TWEAKED TO 3x4 MATRIX 5/28/23
// TWEAKED TO 2x12 MATRIX 8/13/23
// TWEAKING TO MODULAR FOR 3x10, AND FUTURE SUPPORT FOR 2x ALSO 10/18/23
//include './../../Sub/Config.inc.php'; // COMMENTED OUT 9/5/23 - ALREADY HAVE IN FILE THAT CALLS THIS.

if (!isset($GLOBALS['restack']) || $GLOBALS['restack'] != true) {
    $GLOBALS['restack'] = false;
}

if (!isset($_SESSION['debug'])) $_SESSION['debug'] = false;

function getUsrid_From_Username($username) {
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = ['Username' => $username];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$username.'<br>';
	return($buffer['ID']);
}

function getUsername_From_Usrid($usrid) {
    // Check if the input is null or an empty string
    if ($usrid === null || $usrid === '') {
        return $usrid;
    }	
	$selectFields = 'Username';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($_SESSION['debug'] == true) echo 'END getUsrid_From_Username: '.$buffer['Username'].'<br>';
	return($buffer['Username']);
}

///////////////////////////
// It returns sposnorcode
// If not found it returns 0 
function getsponsorusrid($usrid){
	
	if ($_SESSION['debug'] == true) echo 'BEGIN getsponsorusrid<br>';
	
	$selectFields = 'sponsorid';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;

	$sponsor_username = $buffer['sponsorid']; // THE SPONSOR'S UNAME
	
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = ['Username' => $sponsor_username];

	// Call the PHPCPR select function
	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer2 = isset($result2[0]) ? $result2[0] : null;
	
	if (isset($buffer2['ID'])) $sponsorid = $buffer2['ID'];
	else $sponsorid = 0;
	
	if ($_SESSION['debug'] == true) echo 'sponsorid is: '.$sponsorid.' END getsponsorusrid<br>';		
	return $sponsorid;
}

////////////////////////////////////////////
// return number of direct sponsees
function isCommissionQualified($usrid, $matlevel){
	//return(2); // QQQ MAKING ALL USERS QUALIFIED!! 
	$selectFields = 'COUNT(usrid) AS CNT';
	$mainTable = 'matrix';
	$where = [
			['sponsorusrid' => $usrid], 
			['matlevel' => $matlevel],
			/*['active' => 'Y']*/
			];

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	if ($result && isset($result[0]['CNT'])) {
		$num = $result[0]['CNT'];
		return $num;
	}
	return 0;
}

////////////////////////////////////////////
// return number sponsees earned or given to in matrix!
function sumyourmatrix($usrid, $matlevel) {
    $selectFields = ['count(usrid) AS CNT'];
    $mainTable = 'matrix';
	$where = [
		'OR' => [
			'sponsorusrid' => ['=', $usrid],
			'placed_under_sponsorusrid' => ['=', $usrid]
		],		
		'AND' => [
			'matlevel' => ['=', $matlevel]
		],
    ];	
    $buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
    
    if ($buffer) {
        return $buffer[0]['CNT'];
    } else {
        return 0;
    }
}

////////////////////////////////////////////
// RETURN NUMBER SPONSEES EARNED OR GIVEN TO IN MATRIX - MAX WILL ONLY EVER BE $GLOBALS['before_x'] (2 or 3)!
function sumyourdirects($usrid, $matlevel) {
    $selectFields = ['count(usrid) AS CNT'];
    $mainTable = 'matrix';
	$where = [
		'placed_under_sponsorusrid' => ['=', $usrid], 
		'matlevel' => ['=', $matlevel]
		];
    $buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
    
    if ($buffer) {
        return $buffer[0]['CNT'];
    } else {
        return 0;
    }		
}

function find_open_spot($sponsorusrid, $generations = 0, $matlevel=1) {
    $level_one_count = sumyourdirects($sponsorusrid, $matlevel);

    if ($level_one_count < $GLOBALS['before_x']) {
        return array("generations" => $generations, "level_one_count" => $level_one_count, "sponsorusrid" => $sponsorusrid);
    }

    $selectFields = ['usrid'];
    $mainTable = 'matrix';
    $where = [
        'placed_under_sponsorusrid' => ['=', $sponsorusrid], 
		'matlevel' => ['=', $matlevel]
    ];
    $orderBy = 'idx ASC';
    $limit = $GLOBALS['before_x'];

    $result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

    $bestSpot = null;

    foreach ($result as $buffer) {
		
        if ($buffer['usrid'] != '') {
            $currentResult = find_open_spot($buffer['usrid'], $generations + 1, $matlevel);
            if ($currentResult['level_one_count'] < $GLOBALS['before_x']) {
                // If no best spot found yet, or the current spot is at a lower generation level
                if (is_null($bestSpot) || $currentResult['generations'] < $bestSpot['generations']) {
                    $bestSpot = $currentResult;
                } else if ($currentResult['generations'] == $bestSpot['generations'] && $currentResult['level_one_count'] < $bestSpot['level_one_count']) {
                    // If generations are equal but the current spot has a lower frontline count
                    $bestSpot = $currentResult;
                }
                // No need to compare sponsorusrid as earlier results are assumed to be higher up in the matrix
            }
        }
    }

    return $bestSpot ?: array("generations" => $generations, "level_one_count" => $level_one_count, "sponsorusrid" => $sponsorusrid);
}



function under_where($sponsorusrid, $matlevel=1) {
		$debug = false;
		//$debug = true;
		$mat_count = sumyourdirects($sponsorusrid, $matlevel);
		if ($mat_count >= $GLOBALS['before_x']) { // 2 OR 3

			$left_leg_sponsorusrid = 0; // INI VARS
			$right_leg_sponsorusrid = 0;
			$third_leg_sponsorusrid = 0;
			
			$count_left_leg = 1000000; // INI VARS MAKE SO HIGH, WITH NEVER BE CHOSEN AS LOWEST!
			$count_right_leg = 1000000;
			$count_third_leg = 1000000;
	
			$count = 0;
			if ($_SESSION['debug'] == true) {
				$sponsor_uname = getUsername_From_Usrid($sponsorusrid);
				echo 'USER ID: '.$sponsorusrid.' (<b>'.$sponsor_uname.'</b>) MADE '.$GLOBALS["before_x"].' SALES, LOOKING DOWN LEGS!<br>';
			}
			// WE PLACE UNDER USER OF ANY STATUS - SO IT MAKES NO HOLES!			
			$selectFields = ['usrid'];
			$mainTable = 'matrix';
			$where = [
				'placed_under_sponsorusrid' => ['=', $sponsorusrid], 'matlevel' => ['=', $matlevel]
			];
			$orderBy = 'idx ASC';
			$limit = $GLOBALS['before_x'];

			$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

			foreach ($result as $buffer) {			
				$count++;			
				if ($_SESSION['debug'] == true) {
				//	echo "<pre>";
				//	print_r($buffer);
				//	echo "</pre>";
				}
					
				// WE ALWAYS HAVE >= $GLOBALS['before_x'] (2 or 3) LEGS INSIDE THIS COND!
				if ($count == 1 && $buffer['usrid'] != '') {
					$left_leg_sponsorusrid = $buffer['usrid']; // FIND LEFT LEG
					$count_left_leg = sumyourdirects($left_leg_sponsorusrid, $matlevel);// COUNT LEFT LEG'S LEVEL 1
					
				} else if ($count == 2 && $buffer['usrid'] != '') {
					$right_leg_sponsorusrid = $buffer['usrid']; // FIND RIGHT LEG 
					$count_right_leg = sumyourdirects($right_leg_sponsorusrid, $matlevel);// COUNT RIGHT LEG'S LEVEL 1
				
				} else if ($count == 3 && $buffer['usrid'] != '' && $GLOBALS['before_x'] == 3) {
					$third_leg_sponsorusrid = $buffer['usrid']; // FIND THIRD LEG
					$count_third_leg = sumyourdirects($third_leg_sponsorusrid, $matlevel); // COUNT THIRD LEG'S LEVEL 1
				}
			}
			
			if ($_SESSION['debug'] == true) {
				
				$sponsor_uname = getUsername_From_Usrid($left_leg_sponsorusrid);
				echo 'LEFT LEG '.$left_leg_sponsorusrid.' (<b>'.$sponsor_uname.'</b>) DIRECT COUNT IS: '.$count_left_leg.'<br>';
				
				$sponsor_uname = getUsername_From_Usrid($right_leg_sponsorusrid);			
				echo 'RIGHT LEG '.$right_leg_sponsorusrid.' (<b>'.$sponsor_uname.'</b>) DIRECT COUNT IS: '.$count_right_leg.'<br>';
				
				if ($GLOBALS['before_x'] == 3) {
					$sponsor_uname = getUsername_From_Usrid($third_leg_sponsorusrid);
					echo 'THIRD LEG '.$third_leg_sponsorusrid.' (<b>'.$sponsor_uname.'</b>) DIRECT COUNT IS: '.$count_third_leg.'<br>';
				}
			}
			if ($GLOBALS['before_x'] == 3) $min_leg_count = min($count_left_leg, $count_right_leg, $count_third_leg);
			else $min_leg_count = min($count_left_leg, $count_right_leg);
			
			if (!isset($min_leg_count)) $min_leg_count = 0;

			if ($min_leg_count < $GLOBALS['before_x']) {
				if ($min_leg_count == $count_left_leg && $left_leg_sponsorusrid > 0) {
					return $left_leg_sponsorusrid;
				} else if ($min_leg_count == $count_right_leg && $right_leg_sponsorusrid > 0) {
					return $right_leg_sponsorusrid;
				} else if ($min_leg_count == $count_third_leg && $third_leg_sponsorusrid > 0 && $GLOBALS['before_x'] == 3) {
					return $third_leg_sponsorusrid;
				}
			}
						
			$count_left_team = 1000000;
			$count_right_team = 1000000;
			$count_third_team = 1000000;

			if ($_SESSION['debug'] == true) echo 'ALL LEGS FULL - COUNTING GENERATIONS!<br>';			
						
			// IF WE'RE STILL HERE, ALL LEGS ARE FULL! COUNTS ARE EQUAL. NOW LET'S COUNT GENERATIONS!
			// WE START WITH ONE, SINCE THIS IS ACTUALLY GEN 1 WE'RE LOOKING AT RIGHT HERE!			

			if (isset($left_leg_sponsorusrid)) $count_left_leg = find_open_spot($left_leg_sponsorusrid, 1, $matlevel);
			if (isset($right_leg_sponsorusrid)) $count_right_leg = find_open_spot($right_leg_sponsorusrid, 1, $matlevel);
			if (isset($third_leg_sponsorusrid) && $GLOBALS['before_x'] == 3) $count_third_leg = find_open_spot($third_leg_sponsorusrid, 1, $matlevel);				
			
			
			if ($_SESSION['debug'] == true) echo 'LEFT LEG ID '.$left_leg_sponsorusrid.' GEN COUNT IS: '.$count_left_leg['generations'].'<br>';
			if ($_SESSION['debug'] == true) echo 'RIGHT LEG ID '.$right_leg_sponsorusrid.' GEN COUNT IS: '.$count_right_leg['generations'].'<br>';
			if ($_SESSION['debug'] == true && $GLOBALS['before_x'] == 3) echo 'THIRD LEG ID '.$third_leg_sponsorusrid.' GEN COUNT IS: '.$count_third_leg['generations'].'<br>';
			
			if (!isset($count_left_leg['generations'])) $count_left_leg['generations'] = 1000000;
			if (!isset($count_right_leg['generations'])) $count_right_leg['generations'] = 1000000;
			if ($GLOBALS['before_x'] == 3 && !isset($count_third_leg['generations'])) $count_third_leg['generations'] = 1000000;				

			if ($GLOBALS['before_x'] == 3) {
				$min_leg_count = min($count_left_leg['generations'], $count_right_leg['generations'], $count_third_leg['generations']);			
				
				if (!isset($min_leg_count)) $min_leg_count = 0;
							
				if ($_SESSION['debug'] == true) echo 'MIN GEN COUNT IS: '.$min_leg_count.'<br>';

				$min_frontline = min(
					$count_left_leg['level_one_count'], 
					$count_right_leg['level_one_count'], 
					$count_third_leg['level_one_count']
				);

				$counts = [
					$count_left_leg['level_one_count'], 
					$count_right_leg['level_one_count'], 
					$count_third_leg['level_one_count']
				];
			} else if ($GLOBALS['before_x'] == 2) {
				$min_leg_count = min($count_left_leg['generations'], $count_right_leg['generations']);			
				
				if (!isset($min_leg_count)) $min_leg_count = 0;
							
				if ($_SESSION['debug'] == true) echo 'MIN GEN COUNT IS: '.$min_leg_count.'<br>';

				$min_frontline = min(
					$count_left_leg['level_one_count'], 
					$count_right_leg['level_one_count']
				);

				$counts = [
					$count_left_leg['level_one_count'], 
					$count_right_leg['level_one_count']
				];
			}	

			sort($counts);

			$second_min_frontline = $counts[1]; // This is the second lowest count

			if ($_SESSION['debug'] == true) echo 'MIN FRONTLINE COUNT IS: '.$min_frontline.'<br>';
			if ($_SESSION['debug'] == true) echo '2ND MIN FRONTLINE COUNT IS: '.$second_min_frontline.'<br>';
			
			
			// FIND WINNER!
			//$fill_leg = 'left'; // INI VAR!
			if ($min_leg_count == $count_left_leg['generations'] && $min_frontline == $count_left_leg['level_one_count']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN AND MIN FRONTLINE - GOING TO LEFT LEG<br>';
				$fill_leg = 'left';
			} else if ($min_leg_count == $count_right_leg['generations'] && $min_frontline == $count_right_leg['level_one_count']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN AND MIN FRONTLINE - GOING TO RIGHT LEG<br>';				
				$fill_leg = 'right';	
			} else if ($GLOBALS['before_x'] == 3 && $min_leg_count == $count_third_leg['generations'] && $min_frontline == $count_third_leg['level_one_count']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN AND MIN FRONTLINE - GOING TO THIRD LEG<br>';				
				$fill_leg = 'third';
			} else if ($min_leg_count == $count_left_leg['generations'] && $second_min_frontline == $count_left_leg['level_one_count']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN AND 2ND MIN FRONTLINE - GOING TO LEFT LEG<br>';				
				$fill_leg = 'left';
			} else if ($min_leg_count == $count_right_leg['generations'] && $second_min_frontline == $count_right_leg['level_one_count']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN AND 2ND MIN FRONTLINE - GOING TO RIGHT LEG<br>';				
				$fill_leg = 'right';	
			} else if ($GLOBALS['before_x'] == 3 && $min_leg_count == $count_third_leg['generations'] && $second_min_frontline == $count_third_leg['level_one_count']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN AND 2ND MIN FRONTLINE - GOING TO THIRD LEG<br>';				
				$fill_leg = 'third';
			} else if ($min_leg_count == $count_left_leg['generations']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN ONLY - GOING TO LEFT LEG<br>';				
				$fill_leg = 'left';
			} else if ($min_leg_count == $count_right_leg['generations']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN ONLY - GOING TO RIGHT LEG<br>';				
				$fill_leg = 'right';	
			} else if ($GLOBALS['before_x'] == 3 && $min_leg_count == $count_third_leg['generations']) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'MIN GEN ONLY - GOING TO THIRD LEG<br>';				
				$fill_leg = 'third';
			}			
			
			
			if ($fill_leg == 'left') {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'LEFT LEG '.$left_leg_sponsorusrid.' GOING HERE!<br>';
				return under_where($left_leg_sponsorusrid, $matlevel); // THIS IS THE LEFT LEG FROM ABOVE LOOP. THIS IS CORRECT!
			
			} else if ($fill_leg == 'right') {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'RIGHT LEG '.$right_leg_sponsorusrid.' GOING HERE!<br>';
				return under_where($right_leg_sponsorusrid, $matlevel);
				
			} else if ($fill_leg == 'third' && $GLOBALS['before_x'] == 3) {
				if (isset($_SESSION['debug']) && $_SESSION['debug'] === true) echo 'RIGHT LEG '.$third_leg_sponsorusrid.' GOING HERE!<br>';	
				return under_where($third_leg_sponsorusrid, $matlevel);
			}
		
		} else { // $count is less than $GLOBALS['before_x'] - the new planet express CEO is... THAT GUY! dut du dut dut duh dada dut dut!! 
			if ($_SESSION['debug'] == true) {
				$sponsor_uname = getUsername_From_Usrid($sponsorusrid);
				echo 'ID '.$sponsorusrid.' ('.$sponsor_uname.') (PASSED IN) HAS LESS THAN 2 PEEPS - GOING UNDER HIM!'; //exit;
			}	
			
			// JS UPDATE 2/22/23 - WE GOT A PERSON PLACED ON MATRIX WITH A SPONSOR NOT ON MATRIX. SO FIXING THAT NOW.
			if (isOnMatrix($sponsorusrid, $matlevel) == 1) { 
				return $sponsorusrid;
			} else {
				$next_upline = getsponsorusrid($sponsorusrid);
				return under_where($next_upline, $matlevel);
			}	
		}	
}


function get_matrix_upline($sponsorusrid, $matlevel=1) {
	if ($_SESSION['debug'] == true) echo 'BEGIN get_matrix_upline sponsor is '.$sponsorusrid.'<br>';
	if ($sponsorusrid == 0 || $sponsorusrid == 1) return 1;	// FAILSAFE AND EXIT -- DEFAULT TO ADMIN TO STOP BAD LOOPING
		$debug = false;
		//$debug = true;
		// FIND THIS GUY IN MATRIX		
		$selectFields = ['*'];
		$mainTable = 'matrix';
		$where = [
			'usrid' => ['=', $sponsorusrid], 'matlevel' => ['=', $matlevel]
		];
		$orderBy = 'idx ASC';
		$limit = 1;

		$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
		$buffer = isset($result[0]) ? $result[0] : null;
			
		$next_upline = $buffer['placed_under_sponsorusrid'] ?? 1;
		
		if ($next_upline == '' || $next_upline == 0) return 1; // IF THIS VALUE IS EMPTY, IT MEANS THIS SPONSOR HAS NO MATRIX RECORD, SO DEFAULT TO ADMIN,
		// SO USER HAS A PLACE TO GO - THIS SHOULD NEVER HAPPEN IN REAL WORLD CASES
		
		if ($_SESSION['debug'] == true) echo 'next upline is '.$next_upline.'<br>';	
		
		// FIND NEXT UPLINE GUY
		$selectFields = ['*'];
		$mainTable = 'matrix';
		$where = [
			'usrid' => ['=', $next_upline], 'matlevel' => ['=', $matlevel]
		];
		$orderBy = 'idx ASC';
		$limit = 1;

		$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
		$buffer = isset($result[0]) ? $result[0] : null;		
		
		$got_upline = $buffer['usrid'] ?? 1;
		$next_upline = $buffer['placed_under_sponsorusrid'] ?? 1;		
		
		if ($_SESSION['debug'] == true) echo 'got upline is '.$got_upline.' active is '.$buffer['active'].'<br>';		
		
		// COMMENTED OUT 2/28/23 - JEFF BREAKEY (118) MISSED A MATCHING BONUS. THINK IT MAY BE RELATED HERE
		// WHERE THIS GETS PASSED TO, ALSO DOES IT OWNS CHECKS ON STATS
		//if ($buffer2['active'] != 'Y' && $next_upline != 0) return get_matrix_upline($next_upline);
		//else return $got_upline;
		return $got_upline;
}

function queue_email($subject, $usrid) {
	
	$data = [
		'send_next' => $subject
	];

	$where = [
		'ID' => $usrid
	];

	update('members', $data, [], $where, 1, 1, 1);
}	

// PAY MATCHING BONUS FUNCTION
function payGenBonus($matching_sponsorusrid, $matlevel, $entry, $matching_sponsor_bonus, $generation=1) {
		if ($_SESSION['debug'] == true) echo "PAYING {$generation} GEN MATCHING SPONSOR BONUS TO: {$matching_sponsorusrid}<br>";
		$task = 'pay_matching_bonus';
		global $usrid; // PASSED IN BUT NOT USED IN THIS TASK!
		if ($matching_sponsorusrid == 0 || $matching_sponsorusrid == 1) return 0; // EXIT OUT IF ADMIN, WE DO NOT PAY ADMIN
		
		// UPDATE 8/21/24 - NOW PAYING OUT INSIDE THIS FUNC, SO WE CAN TRACK THE GENERATION OF THE MATCHING PAYMENT AS WELL!
		
		$name = $GLOBALS['mat_config'].' Matrix';		
		$gen_desc = ordinal_suffix($generation);
		$datetimenow = date("Y-m-d H:i:s");
		$payoutdate = date("Y-m-d");
		$paying_username = getUsername_From_Usrid($usrid);
		
		// PAY MATCHING SPONSOR BONUS!
		if ($task == 'pay_matching_bonus' && $matching_sponsor_bonus > 0) {
			$comm_desc = $name." ".$gen_desc." GEN MATCHING SPONSOR BONUS - FROM ".strtoupper($paying_username);
			$data = [
				'usrid' => $matching_sponsorusrid,
				'amount' => $matching_sponsor_bonus,
				'description' => $comm_desc,
				'transtype' => 'COMM',
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'pay_status' => 'PAID',
				'paiddate' => $datetimenow
			];
			insert('transactions_log', $data, 1, 1);
		}		
		
		// OLD WAY!
		//payCommissions($usrid, $matching_sponsorusrid, $matlevel, $entry, $task, 0, $matching_sponsor_bonus);
		queue_email('bonus_email', $matching_sponsorusrid);
}
///////////////////////////////////////
// SEE SPONSOR AND SPONSOR'S SPONSOR - UP $GLOBALS['after_x'] LEVELS - PAYS OUT $GLOBALS['mat_config'] MATRIX COMMS AND MATCHING BONUSES!
function look_up($usrid, $sponsorusrid, $placed_under_sponsorusrid, $matlevel, $entry, $looking_up_count, $upline_sponsor_count, $exit_loop=0) {
	if ($_SESSION['debug'] == true) echo 'BEGIN look_up sponsor ID is: '.$placed_under_sponsorusrid.'<br>';
	
	if (isset($task)) $task = '';
			
	$direct_sponsorusrid = $sponsorusrid; 
	
	$qualifiedCommissions = isCommissionQualified($direct_sponsorusrid, $matlevel);
	
	if ($GLOBALS['rank_levels'] == 5 && $GLOBALS['rank5_qualifiers'] == $qualifiedCommissions) {
		$subject = strtolower($GLOBALS['rank5_name']) . '_email';
	} elseif ($GLOBALS['rank_levels'] >= 4 && $GLOBALS['rank4_qualifiers'] == $qualifiedCommissions) {
		$subject = strtolower($GLOBALS['rank4_name']) . '_email';
	} elseif ($GLOBALS['rank_levels'] >= 3 && $GLOBALS['rank3_qualifiers'] == $qualifiedCommissions) {
		$subject = strtolower($GLOBALS['rank3_name']) . '_email';
	} elseif ($GLOBALS['rank_levels'] >= 2 && $GLOBALS['rank2_qualifiers'] == $qualifiedCommissions) {
		$subject = strtolower($GLOBALS['rank2_name']) . '_email';
	} elseif ($GLOBALS['rank_levels'] >= 1 && $GLOBALS['rank1_qualifiers'] == $qualifiedCommissions) {
		$subject = strtolower($GLOBALS['rank1_name']) . '_email';
	} else {
		$subject = 'sales_email';
	}
	
	// NOW WE QUEUE THE TYPE OF EMAIL TO SEND TO DIRECT SPONSOR!
	queue_email($subject, $direct_sponsorusrid);
	
	// SET SPONSOR BONUS - HAD TO MOVE THIS SECTION UP HERE (FROM BELOW COND), AS WE HAD ERROR ABOUT SPONSOR BONUS NOT SET.
	// SPONSOR BONUS IS WHAT GETS PAID IN EACH MATRIX POSITION!
	$sponsor_bonus = $GLOBALS['mat_sponsor_bonus']; 
	if ($GLOBALS['payment_program'] == 'Y') {
		$year_sponsor_bonus = ($sponsor_bonus * 12); // TWELVE MONTHS
		$sponsor_bonus = $year_sponsor_bonus;
	}	

	// DIRECT COMMS GET PAID IN Mat.give.php! DO NOT CHANGE!
	// ONLY PAY ACTIVE, SO IT AUTO COMPRESSES OUT DEAD WOOD
	if ($looking_up_count <= $GLOBALS['after_x'] && isActiveOnMatrix($placed_under_sponsorusrid, $matlevel) == 1) {
		if ($_SESSION['debug'] == true) echo 'look_up paying '.$GLOBALS["mat_config"].' bonus<br>';
		$task = 'pay_'.$GLOBALS["mat_config"].'_bonus';

		// SPECIAL RULES
		//if ($looking_up_count == 4) $sponsor_bonus = 50;
		//else $sponsor_bonus = 5;
		if ($looking_up_count == 4 && $matlevel == 2 && $GLOBALS['payment_program'] == 'Y') {
			$sponsor_bonus = 36.00; // YR 
		} else if ($looking_up_count == 4 && $matlevel == 2 && $GLOBALS['payment_program'] == 'N') {
			$sponsor_bonus = 3.00; // MONTH
		} else {
			$sponsor_bonus = $GLOBALS['mat_sponsor_bonus'];		
		}
		// END SPECIAL RULES
		
		if ($placed_under_sponsorusrid !=0 && $placed_under_sponsorusrid != 1) {
			// THIS COND ADDED 2/17/23 - REPLACED SINGLE LINE COND - IT WAS INCREASING COUNT, EVEN WHEN COND NOT MET!!
			payCommissions($usrid, $placed_under_sponsorusrid, $matlevel, $entry, $task, $sponsor_bonus, 0);
			queue_email('bonus_email', $placed_under_sponsorusrid); // WAS USERID BY MISTAKE. FIXED 8/17/23
			$looking_up_count++;
		}

		// MOVED THIS CODE OUT OF ABOVE COND TO DOWN HERE TO PAY ADMIN COMMS IN BANK AS WELL
		// FAILED IDEA - MAYBE DUE TO PAYING 10 GENS ALSO, BUT IT HUNG UP WITH 500 ERROR
		// NOT PAYING COMMS TO ADMIN -- WE NEVER DID, AND TOO MANY COMPLICATIONS!!
		//payCommissions($usrid, $placed_under_sponsorusrid, $matlevel, $entry, $task, $sponsor_bonus, 0);
		//queue_email('bonus_email', $placed_under_sponsorusrid); // WAS USERID BY MISTAKE. FIXED 8/17/23
		
	}
	
	// GET NEXT UPLINE SPONSOR --> SPONSOR'S SPONSOR, AND MATCHING SPONSORS DOWN 10 GENERATIONS (10 LEVELS DEEP)
	if ($_SESSION['debug'] == true) echo 'GET SPONSORID OF PERSON JUST PAID AND GET 10 GENS OF UPLINE<br>';
	$matching_sponsorusrid = getsponsorusrid($placed_under_sponsorusrid); // GETTING GENS BY REFERRALS
	// FOUND AND FIXED THIS ON 8/31/24 - WRONG - IT WAS CORRECT BEFORE! REVERTED ON 9/4/24 10PM
	//$matching_sponsorusrid = getsponsorusrid($sponsorusrid); // GETTING GENS BY REFERRALS
	//$matching_sponsorusrid = get_matrix_upline($placed_under_sponsorusrid, $matlevel); // GETTING GENS BY MATRIX
		
		
	// MATCHING BONUS -- ONLY PAY ACTIVE AND QUALIFIED (THEY MADE X SALES)
	if ($upline_sponsor_count <= $GLOBALS['after_x']) {

		/* // THIS MAY BE A MORE ELEGANT SOLUTION FROM CHAT GPT - BUT NO TIME FOR TESTING THIS RIGHT NOW!
		// LOOKS PROMISING - TEST AS TIME PERMITS.
		The structure of your generations is clear and systematically progresses through each generation, applying a dynamic approach where the matching sponsor user ID is updated based on the sponsor of the previous generation. This setup accommodates the increased complexity as you delve into deeper generations. Here's an alternative way to structure this logic, which encapsulates the repetitive aspects into a loop, aiming to reduce the redundancy and potential for discrepancies
		// Assuming you've already got $matching_sponsorusrid from somewhere
		$current_sponsorusrid = $matching_sponsorusrid;	
		for ($gen = 1; $gen <= $GLOBALS['rank_levels']; $gen++) {
			if ($GLOBALS["gen{$gen}_match"] > 0) {
				if ($_SESSION['debug'] == true) echo "PAYING MATCHING SPONSOR BONUS TO: {$current_sponsorusrid}<br>";
				
				if (isActiveOnMatrix($current_sponsorusrid, $matlevel) == 1 && isCommissionQualified($current_sponsorusrid, $matlevel) >= $GLOBALS["rank{$gen}_qualifiers"]) {
					$matching_sponsor_bonus = $sponsor_bonus * $GLOBALS["gen{$gen}_match"];
					payGenBonus($current_sponsorusrid, $matlevel, $entry, $matching_sponsor_bonus);
				}
				
				// For next generation, find the sponsor of the current user, unless it's the last generation
				if ($gen < $GLOBALS['rank_levels']) {
					$current_sponsorusrid = getsponsorusrid($current_sponsorusrid);
				}
			}
		}*/
		/*
		// The check matching on generations can be confusing. 
		// At first, you may think there should only be $GLOBALS['rank_levels'] check matching commissions.
		// But you must remember, that process is running for every position inside a 2x10.
		*/
		// THIS SECTION BELONGS HERE (WITHIN THE RECURSIVE LOOP, AS NEEDED) SINCE IT APPLIES TO X GENS FOR EACH PERSON, ANYWHERE WITHIN THE $GLOBALS['after_x'] LEVELS
		
		// 1st Generation
		if ($GLOBALS['rank_levels'] >= 1 && $GLOBALS['gen1_match'] > 0) {
			if ($_SESSION['debug'] == true) echo 'PAYING MATCHING SPONSOR BONUS TO: '.$matching_sponsorusrid.'<br>';
			if (isActiveOnMatrix($matching_sponsorusrid, $matlevel) == 1 && isCommissionQualified($matching_sponsorusrid, $matlevel) >= $GLOBALS['rank1_qualifiers']) {
				$matching_sponsor_bonus = $sponsor_bonus * $GLOBALS['gen1_match'];
				payGenBonus($matching_sponsorusrid, $matlevel, $entry, $matching_sponsor_bonus, 1);
			}
		}

		// 2nd Generation
		if ($GLOBALS['rank_levels'] >= 2 && $GLOBALS['gen2_match'] > 0) {
			$matching_sponsorusrid_2x = getsponsorusrid($matching_sponsorusrid);
			//$matching_sponsorusrid_2x = get_matrix_upline($matching_sponsorusrid, $matlevel);
			if ($_SESSION['debug'] == true) echo 'PAYING MATCHING SPONSOR BONUS TO: '.$matching_sponsorusrid_2x.'<br>';
			if (isActiveOnMatrix($matching_sponsorusrid_2x, $matlevel) == 1 && isCommissionQualified($matching_sponsorusrid_2x, $matlevel) >= $GLOBALS['rank2_qualifiers']) {
				$matching_sponsor_bonus = $sponsor_bonus * $GLOBALS['gen2_match'];
				payGenBonus($matching_sponsorusrid_2x, $matlevel, $entry, $matching_sponsor_bonus, 2);
			}
		}

		// 3rd Generation
		if ($GLOBALS['rank_levels'] >= 3 && $GLOBALS['gen3_match'] > 0) {
			$matching_sponsorusrid_3x = getsponsorusrid($matching_sponsorusrid_2x);
			//$matching_sponsorusrid_3x = get_matrix_upline($matching_sponsorusrid_2x, $matlevel);			
			if ($_SESSION['debug'] == true) echo 'PAYING MATCHING SPONSOR BONUS TO: '.$matching_sponsorusrid_3x.'<br>';
			if (isActiveOnMatrix($matching_sponsorusrid_3x, $matlevel) == 1 && isCommissionQualified($matching_sponsorusrid_3x, $matlevel) >= $GLOBALS['rank3_qualifiers']) {
				$matching_sponsor_bonus = $sponsor_bonus * $GLOBALS['gen3_match'];
				payGenBonus($matching_sponsorusrid_3x, $matlevel, $entry, $matching_sponsor_bonus, 3);
			}
		}

		// 4th Generation
		if ($GLOBALS['rank_levels'] >= 4 && $GLOBALS['gen4_match'] > 0) {
			$matching_sponsorusrid_4x = getsponsorusrid($matching_sponsorusrid_3x);
			//$matching_sponsorusrid_4x = get_matrix_upline($matching_sponsorusrid_3x, $matlevel);			
			if ($_SESSION['debug'] == true) echo 'PAYING MATCHING SPONSOR BONUS TO: '.$matching_sponsorusrid_4x.'<br>';
			if (isActiveOnMatrix($matching_sponsorusrid_4x, $matlevel) == 1 && isCommissionQualified($matching_sponsorusrid_4x, $matlevel) >= $GLOBALS['rank4_qualifiers']) {
				$matching_sponsor_bonus = $sponsor_bonus * $GLOBALS['gen4_match'];
				payGenBonus($matching_sponsorusrid_4x, $matlevel, $entry, $matching_sponsor_bonus, 4);
			}
		}

		// 5th Generation
		if ($GLOBALS['rank_levels'] >= 5 && $GLOBALS['gen5_match'] > 0) {
			$matching_sponsorusrid_5x = getsponsorusrid($matching_sponsorusrid_4x);			
			//$matching_sponsorusrid_5x = get_matrix_upline($matching_sponsorusrid_4x, $matlevel);			
			if ($_SESSION['debug'] == true) echo 'PAYING MATCHING SPONSOR BONUS TO: '.$matching_sponsorusrid_5x.'<br>';
			if (isActiveOnMatrix($matching_sponsorusrid_5x, $matlevel) == 1 && isCommissionQualified($matching_sponsorusrid_5x, $matlevel) >= $GLOBALS['rank5_qualifiers']) {
				$matching_sponsor_bonus = $sponsor_bonus * $GLOBALS['gen5_match'];
				payGenBonus($matching_sponsorusrid_5x, $matlevel, $entry, $matching_sponsor_bonus, 5);
			}
		}



		$upline_sponsor_count++; // WE ONLY COUNT ACTIVE UPLINE - THIS STILL COUNTS AS A LEVEL, EVEN IF THEY ARE NOT QUALIFIED!		
	} // END UPLINE SPONSOR COUNT <= $GLOBALS['after_x']
	
	// THE ROCKET RECRUITER	
	//Pays 25% check match on my your personals requires 2 personals
	//Pays 25% check match on your 2nd generation requires 5 personals
	//pays 25% check match on your 3rd generation requires 10 personals	
	//pays 25% check match on your 4rd generation requires 25 personals	
	
	// COMMENTED OUT 10/18/23 FOR STW - NOW SHOWING BANK LOGS TO ADMIN AS WELL!
	// WE BAIL OUT IF SPONSOR IS ADMIN, AS THERE IS NO NEED TO PAY ADMIN COMMS.	
	//if ($placed_under_sponsorusrid == 0 || $placed_under_sponsorusrid == 1) return 1; 	

	if ($looking_up_count <= $GLOBALS['after_x'] || $upline_sponsor_count <= $GLOBALS['after_x']) {
		// WE ONLY LOOK UP AGAIN, WHEN THEY ARE 1 LESS THAN TOTAL LEVELS! AS THE NEXT LOOK UP COMPLETES ALL LEVELS!!
		// GET NEXT UPLINE SPONSOR IN MATRIX
		// 3X4 TWEAK - LEVEL 4 WAS NOT PAYING OUT
		//if ($looking_up_count == 3) $looking_up_count = 4;
		//if ($upline_sponsor_count == 3) $upline_sponsor_count = 4;
		// END 3X4 TWEAK
		$next_sponsorusrid = get_matrix_upline($placed_under_sponsorusrid, $matlevel);
		if ($_SESSION['debug'] == true) echo 'LOOK_UP CALLS ITSELF NEXT UP IS:'.$next_sponsorusrid.'<br>';
		

		//if ($next_sponsorusrid == 1 || $next_sponsorusrid == 0) $exit_loop = 1;
				
		// THE IDEA HERE WAS TO IMPROVE SPEED, BUT THIS IS NOT GETTING ALL COMMS TO ADMIN, SO AXING FOR NOW. - NOT TRYING TO PAY ADMIN COMMS ANYMORE - TOO MANY ISSUES!
		if (($next_sponsorusrid == 1 || $next_sponsorusrid == 0)) { // WE GOT ALL THE WAY TO ADMIN, AND PASSED HIM THRU LOOKUP ONE TIME - END NOW
			return 1;
		} else {
			if ($next_sponsorusrid == 1 || $next_sponsorusrid == 0) $exit_loop = 1;
			return look_up($usrid, $sponsorusrid, $next_sponsorusrid, $matlevel, $entry, $looking_up_count, $upline_sponsor_count, $exit_loop);
		}	
		//return look_up($usrid, $sponsorusrid, $next_sponsorusrid, $matlevel, $entry, $looking_up_count, $upline_sponsor_count);
	} else {
		if ($_SESSION['debug'] == true) echo 'END look_up!<br>';
		return 1;
	}
} // END look_up

function place_on_Matrix($usrid, $matlevel, $entry) {
	activate_user($usrid, $matlevel, 1); // FOR AUTO STACKING!!
	if ($_SESSION['debug'] == true) echo 'BEGIN place_on_Matrix<br>';
	$sponsorusrid = getsponsorusrid($usrid);
	//$sponsorusrid = 1; // QQQ FOR TESTING HOW IT STACKS ACROSS!!!
	
	if ($_SESSION['debug'] == true) echo "Sponsorusrid: ".$sponsorusrid."<br/>";

	if ($entry == 'ENTRY') { // NEW USER!	
		//if ($sponsorusrid == 1) $placed_under_sponsorusrid = new_under_where($sponsorusrid, $sponsorusrid, $matlevel, 0);
		//else $placed_under_sponsorusrid = under_where($sponsorusrid, $sponsorusrid, $matlevel, 0);
		
		// 1/22/23 - ADMIN WAS PLACING DOWN LEFT A GENERATION LOWER THAN RIGHT SIDE, AND A TEST OF THIS FUNCTION PLACED WHERE THEY WANTED.
		// SO NOW DOING ALL UNDER THIS ONE FUNCTION!
		$placed_under_sponsorusrid = under_where($sponsorusrid, $matlevel);
		
		//$result = under_where($sponsorusrid, $matlevel);
		//$placed_under_sponsorusrid = $result['sponsorusrid'];
	
	} else if ($entry == 'RENEWAL') { // GET FROM TABLE INSTEAD - OR IT PAYS HIMSELF AND DOWNLINE - WHICH IS WRONG!!
		
		$selectFields = ['*'];
		$mainTable = 'matrix';
		$where = [
			'usrid' => ['=', $usrid], 'matlevel' => ['=', $matlevel]
		];
		$orderBy = 'idx ASC';
		$limit = 1;

		$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
		$buffer = isset($result[0]) ? $result[0] : null;
		$placed_under_sponsorusrid = $buffer['placed_under_sponsorusrid'];
	}
	// TRIED PUTTING ALL THIS WAY - IMPACT WAS IT PUT NEXT USER UNDER ADMIN, SO ADMIN HAD 3 IN BINARY, WHICH WAS WRONG!
	//$placed_under_sponsorusrid = under_where($sponsorusrid, $sponsorusrid, $matlevel, 0);
	
	if ($placed_under_sponsorusrid == 0) $placed_under_sponsorusrid = 1;
	
	$date30daysfromnow = date("Y-m-d H:i:s",strtotime("+30 day"));
		
	if ($entry == 'RENEWAL') {
		if ($_SESSION['debug'] == true) echo 'DOING UPDATE NOW<br>';

		$data = [
			'active' => 'Y',
			'PaidThruDate' => $date30daysfromnow
		];
		$where = [
			'usrid' => ['=', $usrid],
			'matlevel' => ['=', $matlevel]
		];
		update('matrix', $data, [], $where, 1, 1, 1);
		$task = 'renewal';

	} else if ($entry == 'ENTRY') {
		if ($_SESSION['debug'] == true) echo 'DOING INSERT NOW<br>';
		
		$dateNow = date('Y-m-d');

		$data = [
			'active' => 'Y',
			'matlevel' => $matlevel,
			'usrid' => $usrid,
			'sponsorusrid' => $sponsorusrid,
			'placed_under_sponsorusrid' => $placed_under_sponsorusrid,
			'PaidThruDate' => $date30daysfromnow,
			'DateFirstSubscribed' => $dateNow
		];
		insert('matrix', $data, 1, 1);
		$task = 'placed_user';
	}

	// Debugging output, if needed
	if ($_SESSION['debug'] == true) {
		echo isset($data) ? json_encode($data) : 'No query executed';
	}
		
	// NOW WE DEBIT ACCOUNT IF NEEDED, AND GIVE POINTS FOR EACH PAYMENT!
	if ($_SESSION['debug'] == true) echo 'BEGIN pay comm placement or renewal<br>';
	payCommissions($usrid, $sponsorusrid, $matlevel, $entry, $task); // THIS DOES NOT PAY COMMS!
		
	// FIND $GLOBALS['after_x'] SPONSORS AND THEIR UPLINES (MATCHING BONUS) AND PAY THEM IN $GLOBALS["mat_config"] (X by X)
	if ($_SESSION['debug'] == true) echo 'CALL look_up<br>';
	look_up($usrid, $sponsorusrid, $placed_under_sponsorusrid, $matlevel, $entry, 1, 1);
	
	if ($_SESSION['debug'] == true) echo 'END place_on_Matrix<br>';
	return 0;
}

//////////////////////////////////
// Generates the apropriate commission and points records

function payCommissions($usrid, $sponsorusrid, $matlevel, $entry, $task=0, $sponsor_bonus=0, $matching_sponsor_bonus=0){ 
		if ($_SESSION['debug'] == true) echo 'BEGIN pay Commissions TASK IS: '.$task.'<br>';
		$datetimenow = date("Y-m-d H:i:s");
		$today = date("Y-m-d");
		$date30daysfromnow = date("Y-m-d H:i:s",strtotime("+30 day"));
		//$currenttimezone = date_default_timezone_get();
		//date_default_timezone_set($currenttimezone);		
		//date_default_timezone_set('America/Chicago');
		$transdate = date("Y-m-d H:i:s");
		//$transweekday = date("w");
		$transmonth = date("m");
		$transhour = date("H");
		$transyear = date("Y");

		if ($transmonth == 12) { 
			$payoutyear = $transyear + 1;
			$payoutmonth = 1;
		} else {
			$payoutyear = $transyear;
			$payoutmonth = $transmonth + 1;
		}

		if ($payoutmonth <10) $payoutdate = $payoutyear . "-0" . $payoutmonth . "-01";
		else $payoutdate = $payoutyear . "-" . $payoutmonth . "-01";
		$payoutdate = $today;

		// FOR RESTACKING MATRIX FROM PAYMENT LOGS ONLY!
		if ($GLOBALS['restack'] == true) {
			$datetimenow = $GLOBALS['datetimenow'];
			$payoutdate = $GLOBALS['payoutdate'];
		}
		
		$fee = 0;
		$points = 0;

		// ALL CUSTOM PROGRAM AMOUNTS GET SET HERE!!
		switch($matlevel) {
			case 1:
					$admin_fee = 0; // COST FOR ADMIN FEE - CHARGED ON CYCLE - MUST BE A NEGATIVE NUMBER OR 0 IF NO FEE!
					$fee = $GLOBALS['mat_fee']; // COST TO ENTER OR RENEW ON THE MATRIX - MUST A BE NEGATIVE NUMBER OR 0 IF NO FEE!
					//$sponsor_bonus = 2; //
					//$matching_sponsor_bonus = $sponsor_bonus; // PAID ONLY WHEN QUALIFIED!
					// MIGHT BE ACHIEVED VIA $GLOBALS['real_sponsor_usrid'] - SHOULD WORK, BUT NEEDS TESTING!!
					$points = $GLOBALS['mat_points']; // GIVING AD CREDITS AT 100X THE COST OF PROGRAM 
					$name = $GLOBALS['mat_config'].' Matrix';
					// NOTE! FAST START BONUS - (REF SPONSOR BONUS), ONE TIME AND RECURRING, ALWAYS COME FROM Mat.give.php!!
				break; 			
			case 2:
					$admin_fee = 0; // COST FOR ADMIN FEE - CHARGED ON CYCLE - MUST BE A NEGATIVE NUMBER OR 0 IF NO FEE!
					$fee = $GLOBALS['mat_fee']; // COST TO ENTER OR RE-ENTER THE MATRIX - MUST BE A NEGATIVE NUMBER!
					//$cycle_bonus = 2500;
					//$sponsor_bonus = 500;
					//$sponsor_bonus = 0; // SPONSOR BONUS ON CYCLE
					$points = $GLOBALS['mat_points']; // GIVING AD CREDITS AT 100X THE COST OF PROGRAM
					$name = $GLOBALS['mat_config'].' Matrix';
				break;
		}
			
		//if ($spots == 0) $entry = 'ENTRY';
		//else $entry = ordinal_suffix($spots).' RE-ENTRY';
		//$entry = 'ENTRY';
		
		
		if ($task == 'placed_user' || $task == 'renewal') {
			
			// ALWAYS PAY THE ENTRY OR RE-ENTRY FEE!
			// NEVER DONE IF $spots == 0, AS THEY PAID UPFRONT, AND THAT GETS TRACKED IN payment_logs in AWS.
			// ACTUALLY THE ONLY WAY WE CAN KNOW IF THEY PAID UPFRONT FOR THIS IS TO CHECK THE PAYMENT LOGS.
			// THIS LOGIC IS DONE TO MAKE SURE WE DON'T CREATE A DEBIT LOG FOR THEIR "BUY IN" (HANDLED BY PAYMENT LOGS), ELSE IT WOULD PUT THEIR BANK ACCOUNT IN THE NEGATIVE!!
			$payer_username = getUsername_From_Usrid($usrid);
			$buffer['payment_log_id'] = ''; // INI VAR!
			
			$selectFields = ['payment_log_id', 'timestamp']; // QQQ CONSIDER IF WE NEED TO ADD IN TIMESTAMP, FOR SUBSCRIPTIONS. I.E. TO SEE IF THEY LAST PAID TODAY? GOOD IDEA TO ADD!
			$mainTable = 'payment_log';
			$where = [
				'payer_username' => $payer_username,
				'program_id' => $matlevel
			];

			$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
			$buffer = isset($result[0]) ? $result[0] : null;
			
			
			if ($_SESSION['debug'] == true) {
				echo '<br>buffer payment_log_id: ';
				//print_r($buffer);
				echo $buffer['payment_log_id'];
				echo '<br>';
			}	
			$payment_log_exists = false; // INI VAR!
			if ($buffer['payment_log_id'] != '') $payment_log_exists = true;
			
			// PAY THE RE-ENTRY FEE!
			if ($entry == 'ENTRY' && $payment_log_exists == true && $task != 'placed_user_upgrade') {
				// DO NOTHING
			} else if ($fee !== 0 && (!defined('IPN_PROCESS') || IPN_PROCESS !== true)) {
	
				$comm_desc = $name." ".$entry;				
				$insertData = [
					'usrid' => $usrid,
					'amount' => $fee,
					'description' => $comm_desc,
					'transtype' => 'DEBIT',
					'logdate' => $datetimenow,
					'payout_date' => $payoutdate,
					'pay_status' => 'PAID',
					'paiddate' => $datetimenow
				];

				insert('transactions_log', $insertData, 1, 1);

				if ($_SESSION['debug'] == true) echo '<br>DEBITED USER!<br>';

				extend_expire_time($usrid, $matlevel); // ONLY DONE HERE WHEN IPN_PROCESS NOT TRUE! OTHERWISE, THIS TIME HAS ALREADY BEEN EXTENDED BY FINALIZE!
				if ($_SESSION['debug'] == true) echo '<br>GAVE USER TIME!<br>';
			}
			// ALWAYS ASSIGN MORE POINTS WHEN USER GETS PLACED 
			givePoints($usrid, $matlevel, $name, $points);
			if ($_SESSION['debug'] == true) echo '<br>GAVE USER POINTS!<br>';
			
			if ($_SESSION['debug'] == true) echo '<br>EXITING PAY COMM NOW!<br>';
			return 0; // WE EXIT OUT OF FUNCTION NOW!
		} // END placed user OR placed user upgrade


		//$name .= " Cycle ".$cycles_completed." - 2x".$GLOBALS['twobyX'];
		$paying_username = getUsername_From_Usrid($usrid);	

		// PAY MATRIX BONUS!
		if ($task == 'pay_'.$GLOBALS["mat_config"].'_bonus' && $sponsor_bonus > 0) {
			$comm_desc = $name." POSITION - FROM ".strtoupper($paying_username);
			$data = [
				'usrid' => $sponsorusrid,
				'amount' => $sponsor_bonus,
				'description' => $comm_desc,
				'transtype' => 'COMM',
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'pay_status' => 'PAID',
				'paiddate' => $datetimenow
			];
			insert('transactions_log', $data, 1, 1);
		}

		// PAY SPONSOR BONUS!
		if ($task == 'pay_sponsor_bonus' && $sponsor_bonus > 0) {
			$comm_desc = $name." SPONSOR BONUS - FROM ".strtoupper($paying_username);
			$data = [
				'usrid' => $sponsorusrid,
				'amount' => $sponsor_bonus,
				'description' => $comm_desc,
				'transtype' => 'COMM',
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'pay_status' => 'PAID',
				'paiddate' => $datetimenow
			];
			insert('transactions_log', $data, 1, 1);
		}

		if ($_SESSION['debug'] == true) echo 'END pay Commissions<br>';
		return 1;
}

//////////////////////////////////////////
// Given a usrid and the board,
// Returns one when there is any spot as active = 'Y'
// Otherwise zero
function isActiveOnMatrix($usrid, $matlevel=1){

	$selectFields = '*';
	$mainTable = 'matrix';
	$where = [
	['usrid' => $usrid], 
	['matlevel' => $matlevel],
	['active' => 'Y']
	];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	if ($result) return 1;
	else return 0;
}

if (!function_exists('isOnMatrix')) {
    function isOnMatrix($usrid, $matlevel = 1) {
        $selectFields = '*';
        $mainTable = 'matrix';
        $where = [
            'usrid' => ['=', $usrid],
            'matlevel' => ['=', $matlevel]
        ];

        // Call the PHPCPR select function
        $result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
        if ($result) return 1;
        else return 0;
    }
}



function activate_user($usrid, $matlevel, $real_payee_user_program_id) {
	
	$sponsor_id = getsponsorusrid($usrid);
	$sponsor_username = getUsername_From_Usrid($sponsor_id);
	
	$selectFields = 'u.sign_id, u.sponsorid, u.user_qualify, u.user_qualify_perm, m.ID, m.Username';
	$mainTable = ['table' => 'members', 'as' => 'm'];
	$joinConditions = [
		['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID'],
	];
	$where = [
			'u.sponsorid' => ['=', $sponsor_username],
			'u.program_id' => ['=', $matlevel]
	];	
	$groupBy = null;
	$orderBy = null;

	$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 1, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$sponsor_user_qualify = $buffer['user_qualify'] ?? 0;
	$sponsor_user_qualify_perm = $buffer['user_qualify_perm'] ?? 0;

	$max_user_qualify = max($sponsor_user_qualify, $sponsor_user_qualify_perm);	
	
	// GETTING SPONSOR PAID!
	$where = [
		/*'m.Username' => ['!=', 'admin'], // WE EXCLUDE ADMIN // WE NEED THIS STILL */
		'u.user_program_id' => ['=', $real_payee_user_program_id]
	];
	
	unset($result, $buffer);

	$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 1, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	// GETTING SPONSOR PAID - THE POWERLINE SPONSOR!
	$powerline_sponsor = $buffer['Username'] ?? null;
	
	// GET THE HIGHEST SIGN ID OF SPONSOR!	
	$selectFields = 'sign_id, sponsorid';
	$mainTable = 'user_program';
	$where = [
		'AND' => [
			'sponsorid' => ['=', $sponsor_username],
			'program_id' => ['=', $matlevel]
		]
	];
	$orderBy = 'sign_id DESC';
	$limit = 1;

	unset($result, $buffer);


	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$sponsor_real_id = getUsrid_From_Username($sponsor_username);
	
	if (!isset($powerline_sponsor)) $powerline_sponsor = $sponsorid;	
	
	if (isset($buffer)) {
		$new_sign_id = $buffer['sign_id'] + 1;
	} else {
		$new_sign_id = 1; // Default value if no records are found
	}
	
	// QQQ QUALIFY THE SPONSOR! - SET TO REV 1-UP!
	// COMMENTED SIGN ID, INCASE THEY SHOULD GET 2 OR MORE UPFRONT PAYMENTS, BEFORE MAKING THEIR PASS UP!
	// THIS IS THE PASS UP SALE, WE QUALIFY THEM NOW!
	// THIS IS NOT FOOLPROOF! - BUT WE TRUST IF THEY CAN ONLY PAY ADMIN FIRST (WHICH IS NOW THE CASE), THEN IT MAY BE REASONABLE, THAT THEY WILL GET MARKED PAID IN ORDER.
	$GLOBALS['up_powerline'] = 1;
	if ($max_user_qualify == 0 /*&& in_array($new_sign_id, [2])*/ && $new_sign_id > 1) {
		$user_qualify = 1; // WE ALWAYS ADD 1 QUALIFIER, REGARDLESS OF HOW MANY X-UPS
		
		$updateData = [
			'user_qualify' => ['expression' => 'user_qualify'.'+'.$user_qualify]
			/*, 'user_qualify_perm' => ['expression' => 'user_qualify_perm'.'+'.$user_qualify]*/
		];

		$where = [
			'AND' => [
				'ID' => ['=', $sponsor_real_id],
				'program_id' => ['=', $matlevel],
				'user_qualify' => ['<', $GLOBALS['up_powerline']]
			]
		];

		update('user_program', $updateData, [], $where, 1, 1, 1);
	}	

	// GET STARTED TIME OF PAYER!
	$selectFields = 'started';
	$mainTable = 'user_program';
	$where = [
		'AND' => [
			'ID' => ['=', $usrid],
			'program_id' => ['=', $matlevel]
		]
	];
	$orderBy = null;
	$limit = 1;
	unset($buffer);
	$buffer = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);	
	
	// IF WE ALREADY HAVE A STARTED TIME, WE PRESERVE IT, TO SHOW WHEN THEY STARTED THE SUB!
	if (isset($buffer[0]['started']) && $buffer[0]['started'] !== null && $buffer[0]['started'] != 0) {
    	$started_timestamp = $buffer[0]['started'];
	} else {
		$started_timestamp = time();
	}
	
	if ($GLOBALS['restack'] == true) {
		$started_timestamp = strtotime($GLOBALS['datetimenow']);
	}
	// QQQ ABOVE COND NOT WORKING! SO PUTTING HERE FOR RESTACK ONLY!

	/*$started_timestamp = strtotime($GLOBALS['datetimenow']);	
	echo $GLOBALS['datetimenow'];
	echo '<br>';
	echo $started_timestamp;
	exit;*/

	
	$updateData = [
		'user_status' => 'Active',
		'powerline_sponsor' => $powerline_sponsor,
		'sign_id' => $new_sign_id,
		'started' => $started_timestamp
	];

	$where = [
		'AND' => [
			'ID' => ['=', $usrid],
			'program_id' => ['=', $matlevel],
			'user_status' => ['NOT IN', ['Active']]
		]
	];

	update('user_program', $updateData, [], $where, 1, 1, 1);
	
	// SET MEMBERS TO PAID STATUS IN MEMBERS TABLE (CREATED POWERLINE SYSTEM, USED FOR OTHER REASONS NOW, TOO)
	$updateData = ['Status' => 'paid'];
	$whereConditions = ['ID' => $usrid];
	update('members', $updateData, [], $whereConditions, 1, 1, 1);	
	
	if ($GLOBALS['restack'] == true) {
		extend_expire_time($usrid, $matlevel);
	}
}

function extend_expire_time($usrid, $matlevel) {

	// EXTEND TIME BY 30 DAYS
	$selectFields = ['user_program_id', 'program_id', 'user_status', 'started', 'expire', 'payment_period'];
	$mainTable = 'user_program';
	$where = [
		'AND' => [
			'program_id' => ['=', $matlevel],
			'ID' => ['=', $usrid]
		]
	];
	$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	
	if (isset($buffer[0]['started']) && $buffer[0]['started'] !== null && $buffer[0]['started'] != 0 && (!isset($buffer[0]['expire']) || ($buffer[0]['expire'] == null || $buffer[0]['expire'] == 0))) {
		// EXPIRE IS NULL, WE USE STARTED TIME
		$last_expire_timestamp = $buffer[0]['started'];
	} else if (isset($buffer[0]['expire']) && $buffer[0]['expire'] != null && $buffer[0]['expire'] != 0) {
		// EXPIRE NOT NULL, WE USE THAT
		$last_expire_timestamp = $buffer[0]['expire'];
	} else {
		// FAILSAFE, USE TIME NOW
		$last_expire_timestamp = time();
	}

	if (isset($GLOBALS['payment_program']) && $GLOBALS['payment_program'] == 'Y') $duration_seconds = 365 * 24 * 60 * 60; // 365 days in seconds
	else $duration_seconds = 30 * 24 * 60 * 60; // 30 days in seconds

	$new_expire_timestamp = $last_expire_timestamp + $duration_seconds;
	//echo date('Y-m-d H:i:s', $expire_timestamp); // Outputs the expiration date in a human-readable format
	// WE SET user_status='Active' HERE, SINCE THEY MAY BE SUSPENDED OR CANCELLED, AND WE NEED TO UPDATE THEM
	// THIS FUNCTION IS ONLY CALLED WHEN IPN_PROCESS IS FALSE (AND FROM REBILL CRON)! - (WHEN FINALIZE IS NOT CALLED TO DO THIS, AS NORMAL)
	$data = [
		'user_status' => 'Active', 
		'payment_period' => ['expression' => 'payment_period + 1'], 
		'expire' => $new_expire_timestamp
	];

	$where = [
		'ID' => ['=', $usrid], 
		'program_id' => ['=', $matlevel]
	];

	update('user_program', $data, [], $where, 1, 1, 1);
}


function givePoints($usrid, $matlevel, $name, $points = 0) {
    if ($_SESSION['debug'] == true) echo 'BEGIN give Points<br>';
	if ($points == 0) return; // IF NO POINTS TO GIVE, WE DO NOT CREATE CREDIT LOGS!
/* // FOR FUTURE DEV WORK - IF POINTS GET STORED IN THIS TABLE, WE'LL FIND THEM THERE INSTEAD!	
	$selectFields = ['ccvalue'];
	$mainTable = 'creditsystemconfig';
	$where = [
		'ccvarname' => 'credit_value',
		'program_id' => $program_id
	];

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	if ($result) {
	$credit_value = isset($buffer['ccvalue']) ? $buffer['ccvalue'] : 0;
*/ 

    // Update user credits in the members table
	$data = [
		'user_credits' => ['expression' => 'user_credits'.'+'.$points]
	];

    $where = [
        'ID' => $usrid
    ];

	update('members', $data, [], $where, 1, 1, 1);	

    $datetime = date("Y-m-d H:i:s");
	
	// LOG THE AD CREDIT ASSIGNMENT!
    // Insert log into credit_log table
    $data_clog = [
        'campid' => '0', 
        'type' => 'buy', 
        'ID' => $usrid, 
        'program' => $matlevel, 
        'credits_assigned' => $points, 
        'date' => $datetime
    ];

    insert('credit_log', $data_clog, 1, 1);
}

function ordinal_suffix($number) {
	$ends = array('th','st','nd','rd','th','th','th','th','th','th');
	if (($number %100) >= 11 && ($number%100) <= 13) $suffix = 'th';
	else $suffix = $ends[$number % 10];
	return($number.$suffix);
}
?>