<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
$name = 'bank_was_verified';
$alert_to_show = $name;
// THIS ALERT WILL SHOW ALERTS TO THOSE GOT MICRO PAYMENTS TO THEIR BANK ACCOUNT, TO VERIFY THE AMOUNTS

$skip = true; // INI VAR

if (!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] == false) {

	$ID = $_SESSION['UserID'];

	$selectFields = '*';
	$mainTable = 'bank_account';
	$where = [
		'ID' => ['=', $ID]
	];
	$orderBy = 'idx DESC';
	$limit = 1;
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	// Decrypt bank account number or use a default of an empty string if not available.
	$bank_account = isset($buffer['bank_account']) ? decrypt($buffer['bank_account']) : '';

	// Ensure that the bank account number has enough characters before truncating.
	if (strlen($bank_account) >= 4) {
		$bank_account = substr($bank_account, -4);
	} else {
		// Handle the error or set a default behavior if the account number is too short.
		$bank_account = '****'; // Placeholder or other default value
	}

	// Decrypt bank routing number or use a default of an empty string if not available.
	$bank_routing = isset($buffer['bank_routing']) ? decrypt($buffer['bank_routing']) : '';

	if (isset($buffer['verified']) && $buffer['verified'] == 'Y') $skip = false;

}

if ($skip == false) {
			
	$html_desc .= '<h2>[FIRSTNAME], you\'ve got a verified bank account!</h2><hr>';

	$html_desc .= 'Hi [FIRSTNAME],

	Our records now show that you have verified the correct micro payment to your<br> 
	bank account ending in '.$bank_account.', with the bank routing number of '.$bank_routing.'.
	<br/><br/>
	You are now eligible to receive direct deposits to this account!		
	<br/><br/> 
	If you have any current withdrawals pending, they should be processed shortly.
	<br/><br/>';


	//$hide_thank_you = true;
	$debug_text .= '<br>we have a '.$name.' alert to show ';
	$skip = false;
	$debug_text .= '<br>skip is false ';
} else {
	$debug_text .= '<br>we have NO '.$name.' alert to show ';
	$skip = true;
	$shut_off = true;		
	$debug_text .= '<br>skip is true ';	
}

function decrypt($input) {
    // Check if the input is null or an empty string
    if ($input === null || $input === '') {
        return $input;
    }

    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];    
    $method = 'AES-256-CBC';
    $data = base64_decode($input);
    $ivLength = openssl_cipher_iv_length($method);
    $iv = substr($data, 0, $ivLength);
    $encryptedData = substr($data, $ivLength);
    return openssl_decrypt($encryptedData, $method, $key, OPENSSL_RAW_DATA, $iv);
}		
?>