<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
$name = 'find_bank_to_verify';
$alert_to_show = $name;
// THIS ALERT WILL SHOW ALERTS TO THOSE GOT MICRO PAYMENTS TO THEIR BANK ACCOUNT, TO VERIFY THE AMOUNTS

$ID = $_SESSION['UserID'];

if (!function_exists('decrypt')) {
    function decrypt($input) {
        // Check if the input is null or an empty string
        if ($input === null || $input === '') {
            return $input;
        }

        global $GLOBALS;
        $key = $GLOBALS['member_taxid_algorythm_key'];    
        $method = 'AES-256-CBC';
        $data = base64_decode($input);
        $ivLength = openssl_cipher_iv_length($method);
        $iv = substr($data, 0, $ivLength);
        $encryptedData = substr($data, $ivLength);
        return openssl_decrypt($encryptedData, $method, $key, OPENSSL_RAW_DATA, $iv);
    }
}

if (!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] == false) {
	// ADMIN HAD MARKED THIS MICRO WITHDRAWAL PAYMENT PAID, SO THAT MEANS IT IS OR WILL BE DEPOSITED INTO THEIR BANK ACCOUNT SOON
	$selectFields = '*';
	$mainTable = 'transactions_log';
	$where = [
		'usrid' => ['=', $ID],
		'description' => ['=', 'BANK DEPOSIT VERIFICATION'],
		'pay_status' => ['=', 'PAID']
	];
	$orderBy = 'id DESC'; // IN THIS TABLE, 'id' IS THE INDEX!
	$limit = 1; // the latest record based on `id`
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$bank_log_id = $buffer['id'] ?? '';
}

if (!empty($bank_log_id) && (!isset($_SESSION['admin_login']) || $_SESSION['admin_login'] == false)) {

	$selectFields = 'amount_sent, bank_account, bank_routing, verify_attempt';
	$mainTable = 'bank_account';
	$where = [
		'ID' => ['=', $ID]
	];
	$orderBy = 'idx DESC';
	$limit = 1; // the most recent record based on `idx`
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$verify_attempt = $buffer['verify_attempt'] ?? 0;

	$attempts_left = 3 - $verify_attempt;
	if ($attempts_left > 1) $plural = 's';
	else $plural = '';
	
	if ($attempts_left < 3) $warning = '<div class="alert alert-danger" role="alert">You have '.$attempts_left.' attempt'.$plural.' left!</div>';
	else $warning = '';

	$bank_account = decrypt($buffer['bank_account']);
	$bank_account = substr($bank_account, -4);
	$bank_routing = decrypt($buffer['bank_routing']);

		
	$html_desc .= '<h2>[FIRSTNAME], action required to verify your bank account!</h2><hr>';

	$html_desc .= 'Hi [FIRSTNAME],

	Our records show admin has processed or is about to process a micro payment to verify your<br>
	bank account ending in '.$bank_account.', with a bank routing number of '.$bank_routing.'.
	<br/><br/>
	If you have already received this payment, please enter the amount below, to verify your account.		
	<br/><br/> 
	If you have not received this payment yet, please simply ignore this alert for now.
	<br/><br/>
	This alert will show each day, as needed.
	<br/><br/>';

	$html_desc .= '<div style="text-align:center">
		<div class="col-md-4 col-xs-2">
		&nbsp;
		</div>

		<div class="col-md-4 col-xs-8" style="text-align:center; margin: 0 auto;">
		
		<h1>Confirm Your Bank Account Deposit</h1>
		
		'.$warning.'
			
		<br/>	<br/>
		<form method="post" action="/Members/alerts/index.php">
		
<div style="display: flex; align-items: center;">
  <span style="margin-right: 5px;">$</span>
  <input class="form-control" style="margin: 0 auto;" onMouseover="this.focus()" size="10" name="amount_answer" value="" placeholder="Enter Amount Deposited Into Your Actual Bank Account">
</div>
		

		<br/><br/>	

		<input type="hidden" name="verify_bank" value="Y">
		<input type="hidden" name="bank_log_id" value="'.$bank_log_id.'">		
		
		<input type="submit" name="Confirm" class="btn btn-info btn-default">
		</form>
			
		</div>
		
		<div class="col-md-4 col-xs-2">
		&nbsp;
		</div>	
		
		<div class="clearfix"></div>	
	</div>';



	//$hide_thank_you = true;
	$debug_text .= '<br>we have a '.$name.' alert to show ';
	$skip = false;
	$debug_text .= '<br>skip is false ';
} else {
	$debug_text .= '<br>we have NO '.$name.' alert to show ';
	$skip = true;		
	$debug_text .= '<br>skip is true ';	
}		
?>