<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
$start_timeframe = strtotime('-30 days');
$end_timeframe = strtotime('-1 day');

$p_username = $_SESSION['loggedin'];
$records = false;
$html_desc = '';

$selectFields = 'prog.program_name, mp.*, u.program_id, p.payment_complete, p.noted_as_paid, p.payer_username, p.user_payment_plan_id';
$mainTable = ['table' => 'payment_plan', 'as' => 'p'];
$joinConditions = [
    ['table' => 'mark_payment', 'as' => 'mp', 'condition' => 'p.payment_plan_id = mp.payment_plan_id'],
    ['table' => 'user_payment_plan', 'as' => 'upp', 'condition' => 'p.user_payment_plan_id = upp.user_payment_plan_id'],
    ['table' => 'user_program', 'as' => 'u', 'condition' => 'upp.user_program_id = u.user_program_id'],
    ['table' => 'program', 'as' => 'prog', 'condition' => 'u.program_id = prog.program_id']
];
$where = [
    'p.payment_complete' => ['!=', 'Y'],
    'p.noted_as_paid' => ['=', 'Y'],
    'p.username' => ['=', $p_username]
];
$orderBy = 'timestamp DESC';
$limit = 0; // GET ALL ROWS
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);

$rows = is_array($result) ? count($result) : 0;
if ($rows > 0) {
    foreach ($result as $buffer) {
	
		if ($buffer['noted_as_paid'] != '') {
			$records = true;

			$html_desc .= '<h2>[FIRSTNAME], Great News for your '.$buffer['program_name'].' program!</h2><hr>';

			$html_desc .= 'Hi [FIRSTNAME],

			'.$buffer['payer_username'].' has noted they have sent your payment for '.$buffer['program_name'].' on [SITENAME].
			<br/><br/>
			Date Paid: '.htmlentities($buffer['paid_date']).' Courier: '.htmlentities($buffer['courier']).' 

			Tracking Number: '.htmlentities($buffer['tracking']).'

			Comments: '.nl2br(htmlentities($buffer['comments'])).'

			<br/><br/>

			If you have received this payment, please mark this person paid now.<br/>Otherwise, we\'ll remind you each day you login, until you choose "Remove This Notice", or mark the user paid.<br/><br/>';

			// BUTTON TO MARK USER PAID - WORKS!
			//echo 'plan id: '.$paymentplan_id.' upp: '.$user_paymentplan_id; 
			$markid = urlencode(base64_encode($buffer['payment_plan_id'].':#:'.$buffer['user_payment_plan_id']));
			
			$html_desc .=  "<div style='text-align:center'><form method='post' action='/apay/processmember.php?userid={$markid}&remove_note=Y&rid={$buffer['id']}'><button type='submit' class='btn btn-danger btn-lg' title='' name='submit' style='display: block; width: 100%'> Remove This Notice From {$buffer['payer_username']}</button></form></div><br/>";		

			$html_desc .=  "<div style='text-align:center'><form method='post' action='/apay/processmember.php?program={$buffer['program_id']}&userid={$markid}'><button type='submit' class='btn btn-info btn-lg' title='' name='submit' style='display: block; width: 100%'> Mark User {$buffer['payer_username']} Paid</button></form></div><hr>";

			//$html_desc .= 'Thank you!<br/><br/>Regards,<br/>'.$Global['webpage_name'].' Support Bot<br/>Thoughtfully programmed for your success!';

		} else { // END WE GOT RESULTS
			$skip = true;
		}	
	} // END LOOP!
} // END WE HAVE ROWS

$name = 'find_marked_payments';
$alert_to_show = $name;

if ($records == true) {
		//$hide_thank_you = true;
		$debug_text .= '<br>we have a '.$name.' alert to show ';
		$skip = false;
		$debug_text .= '<br>skip is false ';
} else if ($_GET['show_alert'] != '') { //user is accessing this alert, so we must show them something.
		$html_desc .= '<h2>[FIRSTNAME], you have no payments marked as sent from your team at this time.</h2><hr>';
		//$hide_thank_you = true;
		$debug_text .= '<br>we have no '.$name.' alert to show, but user is accessing this alert, so we must show them something. ';
		$skip = false;
		$debug_text .= '<br>skip is false ';
} else {
		$debug_text .= '<br>we have NO '.$name.' alert to show ';
		$skip = true;
		$debug_text .= '<br>skip is true ';	
}	
?>