<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
// THIS ALERT WILL SHOW THE USER ALL SUBSCRIPTION PROGRAMS THEY ARE SUSPENDED OR CANCELLED IN, WITH A LINK TO RENEW
// IF A PROGRAM ID IS PRESENT, IT WILL ONLY CHECK THAT ONE PROGRAM - THIS WAS ADDED, SO USERS COULD CANCEL ALERTS BY PROGRAM, AND STILL BE ALERTED TO BEING SUSPENDED / CANCELLED IN OTHER PROGRAMS THEY CARE ABOUT!

$records = false;
$html_desc = '';
	
$selectFields = 'u.ID, u.user_status, u.program_id, p.program_name';
$mainTable = ['table' => 'user_program', 'as' => 'u'];
$joinConditions = ['table' => 'program', 'as' => 'p', 'condition' => 'u.program_id = p.program_id'];
$where = [
	'u.ID' => ['=', $_SESSION['UserID']],
	'u.user_status' => ['IN', ['Suspended', 'Cancelled']],
	'p.program_type' => ['=', 'S'],
	'p.program_setup_type' => ['=', 'N'],
	'p.program_approved' => ['=', 'Y']
];
if (isset($program_id) && $program_id != 0) $where['u.program_id'] = ['=', $program_id];
$orderBy = 'p.program_id ASC';
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;
$rows = is_array($result) ? count($result) : 0;

if ($rows > 0) {
	foreach ($result as $buffer) {
		
		if (isset($buffer['ID'])) {
			$records = true;

			$html_desc .= '<h2>[FIRSTNAME], action required for your '.$buffer['program_name'].' program!</h2><hr>';

			$html_desc .= 'Hi [FIRSTNAME],

			Your payment has lapsed and your status is currently '.$buffer['user_status'].' in '.$buffer['program_name'].' on [SITENAME].
			<br/><br/>
			To take advantage of the program benefits, please renew your subscription now: 
			<a href="'.$Global['webpage_url'].'apay/pay.php?program='.$buffer['program_id'].'">Renew My Membership</a>
			<br/><br/>';

		} else { // END WE GOT RESULTS
			$skip = true;
		}	
	} // END LOOP!
}
//$name = 'find_suspended_cancelled';
//$alert_to_show = $name;

if ($records == true) {
		//$hide_thank_you = true;
		$debug_text .= '<br>we have a '.$name.' alert to show ';
		$skip = false;
		$debug_text .= '<br>skip is false ';
} else {
		$debug_text .= '<br>we have NO '.$name.' alert to show ';
		$skip = true;
		$debug_text .= '<br>skip is true ';	
}		
?>