<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../logincheck.php';
$pageName = ''; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-bullhorn'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES
include '../../Sub/tpl/header_tpl.php';

$ID = $_SESSION['UserID'];

$live = 1;
$limit = 1;
$show_debug = 1;

if (isset($_POST['verify_bank']) && $_POST['verify_bank'] == 'Y' && isset($_POST['amount_answer'])) {

	$selectFields = 'amount_sent, verify_attempt';
	$mainTable = 'bank_account';
	$where = [
		'ID' => ['=', $ID]
	];
	$orderBy = 'idx DESC';

	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	if (isset($buffer['verify_attempt']) && ($buffer['verify_attempt'] + 1 >= 3)) $stop_verification_alerts = true;
	else $stop_verification_alerts = false;

	$data = [
		'verify_attempt' => ['expression' => 'verify_attempt'.'+'.'1']
	];
	$where = [
		'ID' => ['=', $ID]
	];

	update('bank_account', $data, [], $where, $live, 1, $show_debug);

	
	if ($_POST['amount_answer'] == abs($buffer['amount_sent'])) {
		// VERIFY BANK ACCOUNT
		$data = [
			'verified' => 'Y'
		];
		$where = [
			'ID' => ['=', $ID]
		];
		update('bank_account', $data, [], $where, $live, 1, $show_debug);

		$bank_log_id = intval($_POST['bank_log_id']);

		// UPDATE BANK LOG, SO USER CAN NOW SEE THIS DEBIT - AND ADMIN CAN RECOUP THE COST
		$data = [
			'description' => 'BANK DEPOSIT VERIFIED'
		];
		$where = [
			'id' => ['=', $bank_log_id],
			'usrid' => ['=', $ID]
		];

		update('transactions_log', $data, [], $where, $live, 1, $show_debug);

		// SHUT OFF THE ALERT FOR GOOD FOR THIS USER
		$data = [
			'status' => 'off'
		];
		$where = [
			'ID' => ['=', $ID],
			'name' => ['=', 'find_bank_to_verify']
		];

		update('alert_member', $data, [], $where, $live, 1, $show_debug);
		
		
	} else { // THEY MAKE A MISTAKE - RESET RELATED ALERTS!
	
		if ($stop_verification_alerts == false) {
			// DELETE ALERT ENTRIES IF VERIFICATION HAS NOT EXCEEDED LIMITS
			$where = [
				'ID' => ['=', $ID],
				'name' => ['=', 'find_bank_to_verify']
			];			
			delete('alert_member', [], $where, null, $live, 1, $show_debug);

			$where = [
				'ID' => ['=', $ID],
				'name' => ['=', 'bank_was_verified']
			];

			delete('alert_member', [], $where, null, $live, 1, $show_debug);
		} else { // THEY EXCEED 3 ATTEMPTS - WE SHUT DOWN THE ALERTS TO VERIFY BANK
			// SHUT OFF THE ALERT FOR GOOD FOR THIS USER
			$data = [
				'status' => 'off'
			];
			$where = [
				'ID' => ['=', $ID],
				'name' => ['=', 'find_bank_to_verify']
			];

			update('alert_member', $data, [], $where, $live, 1, $show_debug);
			echo '<h2>You have exceeded the bank account confirmation limit.</h2>';
		}
		
	}
	unset($_POST);
} // END VERIFY BANK POST DATA

include '../../Sub/tpl/footer_tpl.php';
?>