<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
$start_timeframe = strtotime('-30 days');
$end_timeframe = strtotime('-1 day');

$records = false;
$html_desc = '';

$selectFields = 'DISTINCT memb.ID, memb.Username, memb.First_Name, memb.Last_Name, memb.email, memb.language, memb.unsubscribe_id, prog.program_id, prg.program_name';
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    ['table' => 'members', 'as' => 'memb', 'condition' => 'log.payer_username = memb.Username'],
    ['table' => 'user_program', 'as' => 'prog', 'condition' => 'log.program_id = prog.program_id AND prog.ID = memb.ID'],
    ['table' => 'program', 'as' => 'prg', 'condition' => 'prg.program_id = prog.program_id'],
    ['table' => 'user_payment_plan', 'as' => 'upp', 'condition' => 'upp.user_program_id = prog.user_program_id']
];
$where = [
    'memb.Username' => ['!=', 'DELETED'],
    'log.amount' => ['!=', 0],
    'upp.valid_plan' => ['=', 'S'],
    'prog.user_status' => ['=', 'Unpaid'],
    'memb.Username' => ['=', $_SESSION['loggedin']]
];
$orderBy = 'upp.timestamp_started DESC';
$limit = 3; // Limiting the results to 3
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);
foreach ($result as $row) {

	
	if ($row['ID'] != '') {
		$records = true;

$html_desc .= '<h2>[FIRSTNAME], action required for your '.$row['program_name'].' program!</h2><hr>';

$html_desc .= 'Hi [FIRSTNAME],

We have received part of your payment for '.$row['program_name'].' on [SITENAME].
<br/><br/>
Please click finish your payments to take advantage of the program benefits: 
<a href="'.$Global['webpage_url'].'apay/pay.php?program='.$row['program_id'].'">Complete My Membership</a>
<br/><br/>';

//$html_desc .= 'Thank you!<br/><br/>Regards,<br/>'.$Global['webpage_name'].' Support Bot<br/>Thoughtfully programmed for your success!';

	} else { // END WE GOT RESULTS
		$skip = true;
	}	
} // END LOOP!

$name = 'started_plan';
$alert_to_show = $name;

if ($records == true) {
		//$hide_thank_you = true;
		$debug_text .= '<br>we have a '.$name.' alert to show ';
		$skip = false;
		$debug_text .= '<br>skip is false ';
} else {
		$debug_text .= '<br>we have NO '.$name.' alert to show ';
		$skip = true;
		$debug_text .= '<br>skip is true ';	
}		
?>