<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------

exit;

/*
debug_stmt($debug_statement, $style=0)
sanitize($data, $fieldName = '')
function insert($table, $data, $live = 0, $show_debug = 0) 
function insertSelect($insertIntoTable, $columns, $selectColumns, $fromTable, $additionalConditions = '', $live = 0, $show_debug = 0)
function select($selectFields, $mainTable, $joinConditions = [], $where = [], $groupBy = null, $having = null, $orderBy = null, $limit = 0, $show_debug = 0)
function update($table, $data, $joinConditions = [], $where = [], $live = 0, $limit = 1, $show_debug = 0)
function delete($table, $joinConditions = [], $where = [], $orderBy = null, $live = 0, $limit = 1, $show_debug = 0)

$url = $buffer['redirect'] ?? ''; // SET TO SELF OR ''

$selectFields = '*'; // ALL
$selectFields = 'payment_collected_by, payout_method';
$mainTable = 'members'; // IF ONLY ONE TABLE, WITH NO JOIN CONDITION
$mainTable = ['table' => 'members', 'as' => 'memb'];
$joinConditions = [
    ['table' => 'user_program', 'as' => 'user', 'condition' => 'memb.ID = user.ID'],
    ['table' => 'program', 'as' => 'prog', 'condition' => 'user.program_id = prog.program_id']
];
$where = [
    'prog.program_approved' => ['=', 'Y'],
    'memb.Username' => ['=', $_SESSION['loggedin']],
    'program_setup_type' => ['!=', 'S']
];
$groupBy = 'Username';
$orderBy = 'totamt DESC';
$limit = 0; // GET ALL ROWS
$offset = ($page - 1) * $results_per_page;

	$limit = [
		'offset' => $offset,	
		'count' => $results_per_page
	];
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);
$buffer = isset($result[0]) ? $result[0] : '';
$rows = is_array($result) ? count($result) : 0;
	
if ($result && count($result) > 0) {
    foreach ($result as $buffer) {

	
// TRICK TO USE SAME FIELD TWICE IN WHERE CLAUSE - JUST USE TABLE NAME, IN ONE INSTANCE!
		$where = [
			'description' => ['LIKE', '%' . $username]
		];
		$where['transactions_log.description'] = ['LIKE', '%' . $GLOBALS['mat_config'] . '%'];
		
// AND ONE OTHER WAY TO DO IT!
$where = [
    'AND' => [
		['log.timestamp' => ['>=', $timestamp]],
		'log.timestamp' => ['<=', $timestamp2],
        'm.Username' => ['=', 'admin']
    ]
];
// ONE MORE EXAMPLE!
$where = [
    'AND' => [
        'type' => '1day',
        ['enddate' => ['LIKE', "%{$endday}%"]],
        ['enddate' => ['>', $endday]],
        ['enddate' => ['!=', $enddate]]
    ]
];		
	
	
*/	
if(session_status() == PHP_SESSION_NONE) {
    session_start();
}
//session_start();
include './logincheck.php';

if ($_SESSION['admin_login'] != true) exit;

//include './../Sub/Config.inc.php';
//include './../phpcpr.php';

$GLOBALS['debug'] = true;
echo $GLOBALS['webpage_name'];

$_SESSION['loggedin'] = 'demo';
$p_username = 'demo';
$_SESSION['UserID'] = 2;
$program_id = 1;
$Global['program'] = 1;
$timestamp =1;

//$barf = barf(1);

$loggedin = $_SESSION['loggedin'];

$loggedinUser = $_SESSION['loggedin'];
$ID = 1;

$date30 = date("Y-m-d",strtotime("-30 day", $timestamp));

//$date30 = sanitize($date30, 'date30');

$selectFields = ['idx'];
$mainTable = 'leaderboard_earnings';

$where = [
    'date' => ['=', "$date30"],
    'totamt' => ['>', 0]
];

$orderBy = 'idx ASC';
$limit = 1;
$show_debug = 1;

// Replace mysql_query and mysql_fetch_assoc
$buffer = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
if ($debug) {
    echo '<br>'.print_r($buffer, true).'<br>';
}

$daysago30 = '1248';

$selectFields = 'memb.Username, memb.First_Name, memb.Last_Name, SUM(log.amount) as totamt';
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'members',
        'as' => 'memb',
        'condition' => 'log.usrid = memb.ID'
    ]
];
$where = [
    'memb.ID' => ['!=', 1],
    'log.amount' => ['>', 0],
    'log.logdate' => ['>', $daysago30]
];
$groupBy = 'log.usrid';
$orderBy = 'totamt DESC';
$limit = 15;
$show_debug = 1;
$topdownlines = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);

if ($debug) {
    echo debug_stmt($topdownlines);
}

// Process $topdownlines as per your requirement

// Setting test values for the $downliners array
$downliners = [
    'Username' => 'testuser',
    'First_Name' => 'John',
    'Last_Name' => 'Doe',
    'totamt' => 150.00, // Example total amount
];

// Assuming $program_id and $date30 are already set
$program_id = 1; // Example program ID
$date30 = '2024-01-01'; // Example date

if ($program_id != 0) {
    $table = 'leaderboard_earnings';
    $data = [
        'program_id' => $program_id,
        'Username' => $downliners['Username'],
        'First_Name' => $downliners['First_Name'],
        'Last_Name' => $downliners['Last_Name'],
        'totamt' => $downliners['totamt'],
        'date' => $date30
    ];
    $live = 1; // Assuming you want to execute the query live
    $show_debug = $debug; // Assuming $debug is a boolean that controls debugging

    $result = insert($table, $data, $live, $show_debug);

    if ($show_debug) {
        echo debug_stmt($result);
    }

    // Additional code to handle $result
}


// Assuming $date30 is already set and properly sanitized
$date30 = '2024-01-01'; // Example date, adjust as necessary

$selectFields = '*';
$mainTable = 'leaderboard_earnings';
$where = [
    'date' => ['=', $date30]
];
$groupBy = 'Username';
$orderBy = 'totamt DESC';
$limit = 15;
$show_debug = 1;

$result = select($selectFields, $mainTable, [], $where, $groupBy, null, $orderBy, $limit, $show_debug);

if ($debug) {
    echo debug_stmt($result);
}

// Process the result


// Assuming $_SESSION['UserID'] and $today are already set and properly sanitized
$userId = $_SESSION['UserID'];
$today = '2024-01-01'; // Example date, adjust as necessary

$selectFields = ['SUM(amount) as balance'];
$mainTable = 'transactions_log';
$where = [
    'usrid' => ['=', $userId],
    'transtype' => ['IN', ['DEPOSIT', 'COMM']],
    'payout_date' => ['<=', $today],
    'description' => ['NOT IN', ['CHARGEBACKW', 'BANK DEPOSIT VERIFICATION']]
];
$groupBy = null;
$orderBy = null;
$limit = 0;
$show_debug = 1;

$result_comm = select($selectFields, $mainTable, [], $where, $groupBy, null, $orderBy, $limit, $show_debug);

if ($show_debug) {
    echo debug_stmt($result_comm);
}

// Assuming $result_comm returns an associative array
$buffer_comm = $result_comm ? reset($result_comm) : null;

$today = date("Y-m-d");


// Define the select fields
$selectFields = ['SUM(amount) AS balance'];

// Define the main table
$mainTable = 'transactions_log';

// Define the where conditions using the correct format for PHPCPR
$where = [
    'usrid' => ['=', "{$_SESSION['UserID']}"],
    'payout_date' => ['>', $today],
    'description' => ['NOT IN', ['CHARGEBACKW', 'BANK DEPOSIT VERIFICATION']]
];

// Call the select function from PHPCPR
$result_pending = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Assuming the select function returns an associative array of results
$buffer_pending = $result_pending[0];


// Define the select fields
$selectFields = ['SUM(amount) AS balance'];

// Define the main table
$mainTable = 'transactions_log';

// Define the where conditions using the correct format for PHPCPR
$where = [
    'usrid' => ['=', "{$_SESSION['UserID']}"],
    'description' => ['NOT IN', ['CHARGEBACKW', 'BANK DEPOSIT VERIFICATION']]
];

// Call the select function from PHPCPR
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Assuming the select function returns an associative array of results
$buffer = $result ? reset($result) : '';

$buffer['user_program_id'] = 2;

// First query to get user_program_id
$selectFields = ['user_program_id'];
$mainTable = 'user_program';
$where = ['ID' => ['=', "{$_SESSION['UserID']}"]];

// Call the select function from PHPCPR for the first query
$results = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

$total_earned = 0;

foreach ($results as $buffer) {
    // Inner query to calculate the sum
    $selectFields2 = ['SUM(log.amount) AS amt'];
    $mainTable2 = ['table' => 'payment_log', 'as' => 'log'];

	$joinConditions2 = [
		[
			'table' => 'user_program',
			'as' => 'u',
			'condition' => 'log.user_program_id = u.user_program_id'
		]];
    $where2 = [
        'log.user_program_id' => ['=', $buffer['user_program_id']],
        'log.cc_pending' => ['=', 'Y'],
        'log.payment_processor' => ['!=', 'VC']
    ];

    // Call the select function from PHPCPR for the inner query
    $result2 = select($selectFields2, $mainTable2, $joinConditions2, $where2, null, null, null, 0, 1);

    // Assuming the select function returns an associative array of results
    $buffer2 = $result2 ? reset($result2) : null;

    $total_earned += $buffer2 ? $buffer2['amt'] : 0;
}

$user_id = 2;

if (!isset($_SESSION['upidlist'])) {
    $_SESSION['upidlist'] = array(); // Initialize it as an empty array if it's not set
}

//array_push($_SESSION['upidlist'], 1); 
//array_push($_SESSION['upidlist'], 2); 

// First query to count deposits and commissions
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['IN', ['DEPOSIT', 'COMM']]
];

// Call the select function from PHPCPR for counting deposits and commissions
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$records = count($result);
$deposits = 'Total Deposits: ' . $records;

$buffer = ['amt' => 0]; // Default value

if ($records > 0) {
    // Second query to sum amounts for deposits and commissions
    $selectFields2 = ['SUM(log.amount) AS amt'];
    $where2 = [
        'log.usrid' => ['=', $user_id],
        'transtype' => ['IN', ['DEPOSIT', 'COMM']],
        'payout_date' => ['<=', $today]
    ];

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where2, null, null, null, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

$sum_deposits = 'Sum Total Commission Deposits: $' . $buffer['amt'];
$tot_deposits = $buffer['amt'];

// Third query to count debits
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['=', 'DEBIT']
];

// Call the select function from PHPCPR for counting debits
$resultsDebit = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$recordsDebit = count($resultsDebit);
$debits = 'Total Debits: ' . $recordsDebit;

$bufferDebit = ['amt' => 0]; // Default value

if ($recordsDebit > 0) {
    // Fourth query to sum amounts for debits
    $selectFieldsDebit = ['SUM(log.amount) AS amt'];
    $resultDebit = select($selectFieldsDebit, $mainTable, [], $where, null, null, null, 0, 1);
    $bufferDebit = $resultDebit ? reset($resultDebit) : ['amt' => 0];
}

// Processing the results for debits
$sum_debits = 'Sum Total Debits: $' . $bufferDebit['amt'];
$tot_debits = $bufferDebit['amt'];


// First query to count pending withdrawals
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['=', 'WITHDRAWAL'],
    'pay_status' => ['=', 'PENDING']
];

// Call the select function from PHPCPR for counting pending withdrawals
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$records = count($result);
$withdrawals = 'Total Withdrawals Pending: ' . $records;

$buffer = ['amt' => 0]; // Default value

if ($records > 0) {
    // Second query to sum amounts for pending withdrawals
    $selectFields2 = ['SUM(log.amount) AS amt'];
    $where2 = [
        'log.usrid' => ['=', $user_id],
        'transtype' => ['=', 'WITHDRAWAL'],
        'pay_status' => ['=', 'PENDING']
    ];
    $orderBy = ['log.id' => 'DESC'];

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where2, null, null, $orderBy, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

$sum_withdrawals = 'Sum Total Withdrawals Pending (Net Amount Due): $' . abs($buffer['amt']);


// First query to count transactions for deposits and commissions
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['IN', ['DEPOSIT', 'COMM']],
    'payout_date' => ['>', $today]
];

// Call the select function from PHPCPR for counting transactions
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$trans_comms = count($result);

$buffer = ['amt' => 0]; // Default value

if ($trans_comms > 0) {
    // Second query to sum amounts for deposits and commissions
    $selectFields2 = ['SUM(log.amount) AS amt'];

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where, null, null, null, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

// Third query to get payment log records
$selectFields3 = ['log.*'];
$mainTable3 = ['table' => 'payment_log', 'as' => 'log'];

$where3 = [
    'log.user_program_id' => is_array($_SESSION['upidlist']) ? ['IN', $_SESSION['upidlist']] : ['=', $_SESSION['upidlist']],
    'cc_pending' => ['=', 'Y'],
    'collected_by' => ['=', 'admin']
];

$orderBy3 = ['payment_log_id DESC'];

// Call the select function from PHPCPR for payment log records
$result3 = select($selectFields3, $mainTable3, [], $where3, null, null, $orderBy3, 0, 1);
$records = count($result3);


//////////////

// First query to count paid out withdrawals
$selectFields = ['log.id'];
$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
$where = [
    'log.usrid' => ['=', $user_id],
    'transtype' => ['=', 'WITHDRAWAL'],
    'pay_status' => ['=', 'PAID']
];


// Call the select function from PHPCPR for counting paid out withdrawals
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$records = count($result);
$withdrawals_paid = 'Total Withdrawals Paid Out: ' . $records;

$buffer = ['amt' => 0]; // Default value

if ($records > 0) {
    // Second query to sum amounts for paid out withdrawals
    $selectFields2 = ['SUM(log.amount) AS amt'];

    // Call the select function from PHPCPR for summing amounts
    $result2 = select($selectFields2, $mainTable, [], $where, null, null, null, 0, 1);
    $buffer = $result2 ? reset($result2) : ['amt' => 0];
}

// $buffer now contains the sum of amounts for paid out withdrawals


// Define the select fields and main table
$selectFields2 = ['*']; // Select all fields
$mainTable2 = ['table' => 'transactions_log', 'as' => 'log'];

// Define the where conditions
$where2 = [
    'transtype' => ['IN', ['WITHDRAWAL', 'DEBIT']],
    'description' => ['!=', 'BANK DEPOSIT VERIFICATION'],
    'log.usrid' => ['=', $user_id]
];

// Define order by
$orderBy2 = ['log.logdate DESC'];


// Call the select function from PHPCPR
$result2 = select($selectFields2, $mainTable2, [], $where2, null, null, $orderBy2, 0, 1);

$master = array();
$nr = 1;
$color_ctr = 1; // start with white

// Process each row in the result
foreach ($result2 as $buffer2) {
    // Your processing code goes here
    // Example: $master[] = $buffer
}


// Define the select fields and main table
$selectFields = ['COUNT(DISTINCT ID) AS cnt'];
$mainTable = 'transactions_log';

// Define the where conditions
$where = [
    'transtype' => ['IN', ['DEPOSIT', 'COMM']],
    'usrid' => ['=', $user_id]
];

// Call the select function from PHPCPR
$results = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Fetch the result - assuming the select function returns an associative array of results
$buffer = $results ? reset($results) : null;

$results_per_page = 3;

// Define the base query for transactions log
$selectFields = ['*']; // Select all fields
$mainTable = 'transactions_log';

// Define the where conditions
$where = [
    'transtype' => ['IN', ['DEPOSIT', 'COMM']],
    'usrid' => ['=', $user_id]
];

// Call the select function from PHPCPR for the row count query
$result_rows = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$rows = count($result_rows);

$page = 1;

// Define the query with ORDER BY and LIMIT
$offset = ($page - 1) * $results_per_page;

	$limit = [
		'offset' => $offset,	
		'count' => $results_per_page
	];

$orderBy = ['logdate DESC'];

// Call the select function from PHPCPR for the main query
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

$taxid = 7700;
$_POST['debitcard'] = '333';

		// Using PHPCPR for database update
		$updateData = ['tax_id' => $taxid];
		$where = ['ID' => ['=', $_SESSION['UserID']]];
		update('member_link', $updateData, [], $where, 1, 1, 1);


if ($_POST['debitcard'] != '') { // ADD DEBIT CARD
	// Using PHPCPR for database update
	$updateData = ['debitcard' => $_POST['debitcard']];
	$where = ['ID' => ['=', $_SESSION['UserID']]];
	update('members', $updateData, [], $where, 1, 1, 1);
}

$selectFields = 'SUM(amount) as balance';
$mainTable = 'transactions_log';
$where = [
    'usrid' => ['=', $_SESSION['UserID']],
    'payout_date' => ['<=', $today],
    'description' => ['!=', 'CHARGEBACKW']
];
$balanceResult = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$balance = $balanceResult[0]['balance'];

// Get Pending Balance
$mainTable = 'user_program';
$where = ['ID' => ['=', $_SESSION['UserID']]];
$userProgramResult = select('user_program_id', $mainTable, [], $where, null, null, null, 0, 1);

$total_earned = 0;

foreach ($userProgramResult as $buffer) {
    $subSelectFields = 'SUM(log.amount) as amt';
	
	$subJoinConditions = [
        ['table' => 'user_program', 'as' => 'u', 'condition' => 'log.user_program_id = u.user_program_id']
    ];
	
    $subMainTable = ['table' => 'payment_log', 'as' => 'log'];
	
    $subWhere = [
        'log.user_program_id' => ['=', $buffer['user_program_id']],
        'log.cc_pending' => ['=', 'Y']
    ];
    $pendingResult = select($subSelectFields, $subMainTable, $subJoinConditions, $subWhere, null, null, null, 0, 1);
    
    if (!empty($pendingResult) && isset($pendingResult[0]['amt'])) {
        $total_earned += $pendingResult[0]['amt'];
    }
}
	
	
// Find out if member is collecting their own payments
$selectFields = 'payment_collected_by, payout_method';
$mainTable = 'members';
$where = ['ID' => ['=', $_SESSION['UserID']]];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result[0];

// Get Tax ID
$selectFieldsML = 'country, tax_id';
$mainTableML = 'member_link';
$whereML = ['ID' => ['=', $_SESSION['UserID']]];
$resultML = select($selectFieldsML, $mainTableML, [], $whereML, null, null, null, 0, 1);
$bufferML = $resultML[0];

$selectFields = 'COUNT(user_program_id) AS cnt';
$mainTable = 'user_program';
$where = [
    'powerline_sponsor' => ['=', $_SESSION['loggedin']],
    'user_status' => ['IN', ['Active', 'Comped']],
    'program_id' => ['=', '1']
];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result[0];
$recruiter_count = $buffer['cnt']; // Total Active in P1

$user = 'aaa';

$selectFields = 'ID, Username';
$mainTable = 'members';
$where = [
    'Username' => ['=', $user]
];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
//$buffer = $result[0];





// Dummy variables for testing
$usrid = '12345'; // Fake user ID
$amt = '100.00'; // Fake amount
$desc = 'Test Transaction'; // Fake description
$trans = 'CREDIT'; // Fake transaction type
$datetimenow = date('Y-m-d H:i:s'); // Current datetime
$payoutdate = '2024-01-10'; // Fake payout date
$withdrawal_fee = '5.00'; // Fake withdrawal fee
$amtnegative = '-50.00'; // Fake negative amount for transfer
$descdebit = 'Transfer Debit'; // Fake description for debit
$amount = '75.00'; // Fake amount for bank balance update
$_REQUEST['type'] = 'transfer';

			// Insert into `transactions_log`
			$insertData1 = [
				'usrid' => $usrid,
				'amount' => $amt,
				'description' => $desc,
				'transtype' => $trans,
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'pay_status' => 'PENDING'
			];
			insert('transactions_log', $insertData1, 1, 1);

			$insertData2 = [
				'usrid' => $usrid,
				'amount' => $withdrawal_fee,
				'description' => 'Withdrawal Fee',
				'transtype' => 'DEBIT',
				'logdate' => $datetimenow,
				'payout_date' => $payoutdate,
				'pay_status' => 'PAID'
			];
			insert('transactions_log', $insertData2, 1, 1);

			if ($_REQUEST['type'] == 'transfer') { // DEBIT AS WELL ON TRANSFERS!!
				$insertData3 = [
					'usrid' => $_SESSION['UserID'],
					'amount' => $amtnegative,
					'description' => $descdebit,
					'transtype' => 'TRANSDEBIT',
					'logdate' => $datetimenow,
					'payout_date' => $datetimenow,
					'pay_status' => 'PAID'
				];
				insert('transactions_log', $insertData3, 1, 1);
			}

			// DEBIT BANK BALANCE!!
			$updateData = [
				'bank_balance' => ['expression' => 'bank_balance'.'-'. $amount]
			];
			$where = ['ID' => ['=', $_SESSION['UserID']]];
			update('members', $updateData, [], $where, 1, 1, 1);
	
	
// Select all programs
$selectFields = 'memb.unsubscribe_id, user.*, prog.*';
$mainTable = ['table' => 'members', 'as' => 'memb'];
$joinConditions = [
    ['table' => 'user_program', 'as' => 'user', 'condition' => 'memb.ID = user.ID'],
    ['table' => 'program', 'as' => 'prog', 'condition' => 'user.program_id = prog.program_id']
];
$where = [
    'prog.program_approved' => ['=', 'Y'],
    'memb.Username' => ['=', $_SESSION['loggedin']],
    'program_setup_type' => ['!=', 'S']
];
$groupBy = 'prog.program_id';
$orderBy = 'prog.program_id ASC';

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 0, 1);

$selected_program = '';
$programs_text = '';

foreach ($result as $buffer) {
    $prog_id = $buffer['program_id'];
    $qrySelectFields = 'program_id';
    $qryMainTable = 'program';
    $qryWhere = [
        'program_id' => ['=', $prog_id]
    ];
    $result2 = select($qrySelectFields, $qryMainTable, [], $qryWhere, null, null, null, 0, 1);
    $buffer2 = $result2[0];

    // ... Rest of your logic
}

$selectFields = 'SUM(amount) as total';
$mainTable = 'payment_log';
$where = [
    'user_program_id' => ['=', $buffer['user_program_id']],
    'program_id' => ['=', $buffer['program_id']],
    'chargeback' => ['=', 'N'],
    'cc_pending' => ['=', 'Y']
];

$result_cc = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$total = $result_cc[0]['total'];


$selectFields = 'payment_processor, SUM(amount) as amount';
$mainTable = 'payment_log';
$where = [
    'user_program_id' => ['=', $buffer['user_program_id']],
    'chargeback' => ['=', 'N'],
    'cc_pending' => ['=', 'N']
];
$groupBy = 'payment_processor';

$payment_info = select($selectFields, $mainTable, [], $where, $groupBy, null, null, 0, 1);

$payments = array();

foreach ($payment_info as $payment_buffer) {
    // Your logic with $payment_buffer
}
$ID = $_SESSION['UserID'];
$datetime = date("Y-m-d H:i:s");
	$updateData = [
		'end_program' => 'Y',
		'user_status' => 'Cancelled',
		'cancelled_by' => 'member',
		'date_cancelled' => $datetime
	];
	// NOTE TO JOIN 2 CLUASES HERE IN WHERE, COULD NOT USE SESSION - HAD TO BE $ID
	$where = ['ID' => ['=', $ID], 'user_status' => ['!=', 'Unpaid']];
	update('user_program', $updateData, [], $where, 1, 1, 1);	
	
	$email = 'eeed';
	
	$selectFields = ['ID', 'Username', 'email'];
	$mainTable = 'members';
	$where = [
			'Username' => ['=', $email],
			'email' => ['=', $email],
			'bounced_email' => ['=', $email]
	];
	$limit = 1; // Expecting a single result
	$show_debug = 1; // Set to 1 to enable debugging, or 0 to disable

	// Execute the query using PHPCPR's select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);	

//	
	
	if ($email != '') {	
	$selectFields = ['ID', 'Username', 'email'];
	$mainTable = 'members';
	$where = [
		'OR' => [
			'Username' => $email,
			'email' => $email,
			'bounced_email' => $email
		]
	];
		
	
	$limit = 1; // Expecting a single result
	$show_debug = 1; // Set to 1 to enable debugging, or 0 to disable

	// Execute the query using PHPCPR's select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);

	// Fetch the result
	if ($result) {
		foreach ($result as $row) {
			$vars = create_vars($row);
			//show_array($vars);
			show_vars($vars);   // This will print the variables created from create_vars.
		}
		echo 'ID: ' . $row['ID'] . ' Username: ' . $row['Username'] . ' Email: ' . $row['email'] . '<br>';
	}
}


	if ($email != '') {	
	$selectFields = ['ID', 'Username', 'email'];
	$mainTable = 'members';
	$where = [
		'OR' => [
			'Username' => ['=', $email],
			'email' => ['=', $email],
			'bounced_email' => ['=', $email]
		],
		'AND' => [
			'Status' => ['!=', 'Cancelled'],
			'cellphone' => ['IS NULL']
		],
	];
	$limit = 1; // Expecting a single result
	$show_debug = 1; // Set to 1 to enable debugging, or 0 to disable

	// Execute the query using PHPCPR's select function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);

	// Fetch the result
	if ($result) {
		foreach ($result as $row) {
			$vars = create_vars($row);
			//show_array($vars);
			show_vars($vars);   // This will print the variables created from create_vars.
		}
		echo 'ID: ' . $row['ID'] . ' Username: ' . $row['Username'] . ' Email: ' . $row['email'] . '<br>';
	}
}

$check_id = 1;
	$selectFields = '*';
	$mainTable = 'matrix';
	$where = ['usrid' => $check_id]; // Add more conditions if needed

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
	$check_uname = 'demo';
	
$selectFields = 'ID, First_Name, Last_Name, Username, sponsorid';
$mainTable = 'members';
$where = ['Username' => $check_uname];

// Call the PHPCPR select function
$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Check if result is not false or empty, then proceed with your logic
$buffer2 = isset($result2[0]) ? $result2[0] : null;

$top_id = 3;

$selectFields = 'sponsorid';
$mainTable = 'members';
$where = ['ID' => $top_id];

// Call the PHPCPR select function
$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

// Check if result is not false or empty, then proceed with your logic
$buffer2 = isset($result2[0]) ? $result2[0] : null;	


	$selectFields = 'sponsorid';
	$mainTable = 'members';
	$where = ['ID' => $usrid];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;
	
$sponsor_username = 'test';

	$selectFields = 'ID';
	$mainTable = 'members';
	$where = ['Username' => $sponsor_username];

	// Call the PHPCPR select function
	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Check if result is not false or empty, then proceed with your logic
	$buffer2 = isset($result2[0]) ? $result2[0] : null;	
	
$sponsorusrid = 1;

	
	
	$selectFields = 'usrid';
	$mainTable = 'matrix';
	$where = [
	['placed_under_sponsorusrid' => $sponsorusrid]
	];

	// Call the PHPCPR select function	
	$result = select($selectFields, $mainTable, [], $where, null, null, 'idx ASC', $GLOBALS['before_x'], 1);
	$buffer = isset($result[0]) ? $result[0] : null;	
	
	
	
// Assuming $ID, $ar_list, and $loggedin_user_is_closer are already defined and sanitized
$ar_list = 1;
$selectFields = 'ar.*, m.Username';
$mainTable = ['table' => 'ar_leads', 'as' => 'ar'];
$joinConditions = [
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'ar.ID = m.ID'
    ]
];

// Initial $where array
$where = [
    'AND' => [
        'ar.ar_leads_status' => ['IN', [1, 4]],
        'm.ID' => ['=', $ID],
        'ar.ar' => ['=', $ar_list]
    ],
];
//JJ
$whereMain = []; // Initialize the where condition array
// Conditionally modify the $where array
if ($_REQUEST['optin_only_leads'] != '' || $_GET['optin_only_leads'] != '') {
    $where['AND']['ar.found'] = ['!=', 'bought'];
} else {
    $where['AND']['ar.found'] = ['=', 'bought'];
}
/*The challenge here is ensuring that multiple conditions for the same field, such as m.Signdate, don't overwrite each other. A common solution to this problem in SQL query construction is to use more specific keys or an array structure that inherently supports multiple conditions for the same field.

However, without changing the fundamental structure of your input or significantly reworking your code logic beyond the provided snippet, we must focus on a direct solution to allow both conditions to coexist. The core issue is the array key collision in the $whereMain array. Since PHP arrays cannot have duplicate keys, setting the same key twice overwrites the first with the second.

Given the limitations and focusing on the lines to change, let's propose a simplified adjustment. This approach modifies how you set conditions for m.Signdate to avoid overwriting:
*/ // WORKS!!
if ($start_date !== '') {
	$whereMain['AND'][]['m.Signdate'] = ['>=', $start_date];
}
if ($end_date !== '') {
	$whereMain['AND'][]['m.Signdate'] = ['<=', $end_date];
}

// $where is now ready to be used in your query

		
$groupBy = 'ar_leads_id, ar_leads_email'; // Group by fields
$orderBy = 'ar.ar_leads_id DESC'; // Order by fields

// Call the PHPCPR select function
$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 0, 1);

// Process the result as needed
	
	
	
	
// Simulating the $_REQUEST superglobal with fake data
$_REQUEST = [
    'timetocall' => '14:00',  // Example value, you can change it
    'interest' => 'coding',   // Example value, you can change it
    'timezone' => 'EST',     // Example value, uncomment to test
    'country' => 'USA'        // Example value, you can change it
];	
// Initialize $surv_where array
$surv_where = ['AND' => []];

	if ($_REQUEST['timetocall'] != '') $surv_where['AND']['al.timetocall'] = ['=', $_REQUEST['timetocall']];
		
	if ($_REQUEST['interest'] != '') $surv_where['AND']['al.interest'] = ['=', $_REQUEST['interest']];
	
	if ($_REQUEST['timezone'] != '') $surv_where['AND']['al.timezone'] = ['=', $_REQUEST['timezone']];
	
	if ($_REQUEST['country'] != '') $surv_where['AND']['al.country'] = ['=', $_REQUEST['country']];

// Print the resulting array for demonstration
echo '<pre>';
print_r($surv_where);
echo '</pre>';

	// GET TOTAL COUNT -> INCLUDE SURVEY TABLE IN SEARCH
	
	$selectFields = 'COUNT(DISTINCT al.ar_leads_id) AS cnt';
	$mainTable = ['table' => 'ar_leads', 'as' => 'al'];
	$joinConditions = [
		[
			'table' => 'ar_survey',
			'as' => 'ars',
			'condition' => 'al.ar_leads_id = ars.ar_leads_id'
		]
	];

	$where = [
		'AND' => [
			'al.ar_leads_status' => ['IN', [1, 4]],
			'al.ar' => ['=', $ar_list]
		],
	];

/* // QQQ FOR LAC !!
// Conditionally modify the $where array
if ($_REQUEST['optin_only_leads'] != '' || $_GET['optin_only_leads'] != '') {
    $where['AND']['ar.found'] = ['!=', 'bought'];
} else {
    $where['AND']['ar.found'] = ['=', 'bought'];
}*/
		
	//$search_where = array_merge($surv_where, $where);
	$search_where = ['AND' => array_merge($surv_where['AND'], $where['AND'])];

	$groupBy = null;
	$orderBy = null;

	// Call the PHPCPR select function
	$result = select($selectFields, $mainTable, $joinConditions, $search_where, $groupBy, null, $orderBy, 0, 1);	
	
	$idx = 1;
	$unique_clicks = 2;
	$buffer_ip['id'] = 6;
	
	if ($buffer_ip['id'] == '' || $unique_clicks == 0) {
		// REGISTER UNIQUE AND TOTAL CLICKS
		$data = [
			'unique_clicks' => ['expression' => 'unique_clicks'.'+'.'1'],
			'total_clicks' => ['expression' => 'total_clicks'.'+'.'1']
		];
		$where = [
			'idx' => $idx,
			'status' => ['>', 0]
		];
		update('campaigns', $data, [], $where, 1, 1, 1);
	} else {
		// IP EXISTS FOR DAY, NOT UNIQUE - JUST UPDATE TOTAL CLICKS
		$data = [
			'total_clicks' => ['expression' => 'total_clicks'.'+'.'1']
		];
		$where = [
			'idx' => $idx,
			'status' => ['>', 0]
		];
		update('campaigns', $data, [], $where, 1, 1, 1);
	}	
	

$todayDate = date("Y-m-d");

$selectFields = [
    'm.email',
    'm.First_Name',
    'm.Last_Name',
    'm.Username',
    'm.unsubscribe_id',
    'ml.phone',
    'ald.*'
];

$mainTable = ['table' => 'ar_leads', 'as' => 'ald'];
$joinConditions = [
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'm.ID = ald.ID'
    ],
    [
        'table' => 'member_link',
        'as' => 'ml',
        'condition' => 'm.ID = ml.ID'
    ]	
];

$where = [
    'ald.followupdate' => ['<=', $todayDate],
    'ald.followupdate' => ['!=', '0000-00-00'],
    'ald.followup_emailsent' => ['=', 0],
    'ald.expire_date' => ['>=', $todayDate]
];
$orderBy = 'ar_leads_id';

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, 1);
	
	
		$closer_id = 3698;
		
		$selectFields = ['email', 'First_Name', 'Last_Name'];
		$mainTable = ['table' => 'members'];
		$where = ['ID' => ['=', $closer_id]];
		$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);	

$buffercron['idx'] = 2;
		
$updateData = ['handshake' => 'T'];
$where = ['idx' => ['=', $buffercron['idx']]];
update('cron_run', $updateData, [], $where, 1, 1, 1);	

$selectFields = ['*'];
$mainTable = 'latest_stats';
$where = ['type' => '1day'];
$orderBy = ['enddate DESC', 'idx DESC'];
$limit = 1;

$buffer = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

$found_single_day_stats = false; // INITIALIZE VAR

if ($buffer) {
    foreach ($buffer as $row) {
        // Your logic here
    }
} else {
    echo 'No records found.';
}

$datetime_completed = '2021-01-01 00:00:00';

$startdate = '2021-01-01 00:00:08';
$enddate = '2021-01-01 00:00:12';

$table = 'cron_run';
$data = [
    'locked' => 'N', 
    'completed' => $datetime_completed, 
    'handshake' => 'T'
];
$where = ['idx' => $buffercron['idx']];

update($table, $data, [], $where, 1, 0, 1);

$selectFields = ['COUNT(ID) AS cnt'];
$mainTable = 'members';
$where = [
		'AND' => [
			['SignDate' => ['>=', $startdate]],
			'SignDate' => ['<=', $enddate]
			]
		];

$bufferj = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

if (!$bufferj) {
    die('Query failed');
}

	
$timestamp = 77;
$timestamp2 = 88;

$selectFields = ['SUM(log.amount) AS tot_earned'];
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'log.user_program_id = u.user_program_id'
    ],
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'u.ID = m.ID'
    ]
];
$where = [
    'AND' => [
		['log.timestamp' => ['>=', $timestamp]],
		'log.timestamp' => ['<=', $timestamp2],
        'm.Username' => ['!=', 'admin'],
        'log.payment_processor' => ['=', 'E4']
    ]
];

$buffer_earnings = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
	
	$selectFields = ['SUM(log.amount) AS tot_earned'];
	$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
	$where = [
		'AND' => [
			'log.usrid' => ['!=', 1],
			['log.logdate' => ['>=', $startdate]],
			'log.logdate' => ['<=', $enddate]
		]
	];

	$buffer_earnings = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);	

$endday =79;
$enddate =555;	
	
$where = [
    'AND' => [
        'type' => '1day',
        ['enddate' => ['LIKE', "%{$endday}%"]],
        ['enddate' => ['>', $endday]],
        ['enddate' => ['!=', $enddate]]
    ]
];

$result_mem = delete('latest_stats', [], $where, 'idx ASC', 1, 1, 1);	

$payer_username = 'test';
$Global['program'] =1;

$selectFields = ['u.*'];
$mainTable = ['table' => 'members', 'as' => 'm'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'm.ID = u.ID'
    ]
];
$where = [
    'AND' => [
        'm.Username' => ['=', $payer_username],
        'u.program_id' => ['=', $Global['program']]
    ]
];
$result_uprog = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer_uprog = isset($result_uprog[0]) ? $result_uprog[0] : null;
$nr = count($result_uprog);
echo 'JIM NR: '.$nr;

$user_program_id = 3;

// First, delete from `user_payment_plan`
$joinConditions = [
    [
        'table' => 'payment_plan',
        'as' => 'pp',
        'condition' => 'pp.user_payment_plan_id = upp.user_payment_plan_id'
    ]
];
$where = [
    'AND' => [
        'upp.user_program_id' => ['=', $user_program_id],
        'upp.valid_plan' => ['=', 'N'],
        'pp.payment_complete' => ['=', 'N']
    ]
];
// TROUBLE WITH THIS ...
//delete(['table' => 'user_payment_plan', 'as' => 'upp'], $joinConditions, $where, null, 1, 1, 1);
//delete('user_payment_plan', $joinConditions, $where, null, 1, 1, 1);


$ID = 1;

delete('status_log', [], ['ID' => $ID], null, 1, 1, 1);

// QUERY TO FIND ALL TEST USERS (test1, test2, test3, etc..)
$selectFields = ['ID', 'Username'];
$mainTable = 'members';
//$where = ['Username' => ['!=', 'admin'], 'Username' => ['!=', 'demo'], 'Username' => ['!=', 'test2'], 'ID' => ['>', 2], 
$where = ['ID' => ['>', 3], 'Username' => ['LIKE', 'test%']];
$orderBy = null;
$limit = 0;

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$buffer = $result ? reset($result) : null;

//exit;
///////////

$selectFields = 'm.ID as ID, u.user_program_id, u.program_id, u.program_id as exclude_prog_id, m.Username, m.First_Name, m.Last_Name, m.email, m.Status, m.sponsorid as msponsorid, u.sponsorid as usponsorid, u.user_status, u.sign_id, u.user_qualify_perm, u.user_signup, m.Signdate, u.started, u.expire, u.end_program, m.payment_collected_by, m.e4gatewayID';

// Define the main table and join conditions
//$mainTable = 'members as m';
$mainTable = ['table' => 'members', 'as' => 'm'];

$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'm.ID = u.ID'
    ]
];
$where = [
    'AND' => ['m.ID' => ['!=', 'NULL']]
	];

$Global['program_restrict'] = array(7);
$_REQUEST['status'] = 'Unpaid';
$bystatus = 1;
$_REQUEST['program'] = 1;


if (isset($_GET['browse']) && $_GET['browse'] == 'Y') {
    $bystatus = '';
    $program = '';
    $search_way = '';
}

if (isset($_GET['browse'], $_REQUEST['program']) && $_GET['browse'] == 'Y' && $_REQUEST['program'] != '') {
    $program = $_REQUEST['program'];
    $alert = true;
}


if (isset($Global['program_restrict']) && $Global['program_restrict'] != '') {
    $where['AND']['u.program_id'] = ['NOT IN', $Global['program_restrict']];
}

if (isset($bystatus) && $bystatus != '') {
    $where['AND']['u.user_status'] = ['=', $_REQUEST['status']];
}

if (isset($_REQUEST['program']) && $_REQUEST['program'] != 0 && $_REQUEST['program'] != '') {
	// NOT USING u.program_id BELOW, DUE TO CURRENT LIMITATION IN PHP CPR, IT WOULD OVERWRITE THE EARLIER QRY USE!
	// THIS IS FINE, AS FIELD NOT AMBIGUOUS!
    $where['AND']['program_id'] = ['=', $_REQUEST['program']];
}

$_POST['way'] = 2;
$colname = 'Username';
$find = 'demo';

	if ($_POST['way'] == 1 && $colname!='' && $find!='') {
	$where['AND']["$colname"] = ['=', $find];
	} else if ($colname!='' && $find!='') { 
	$where['AND']["$colname"] = ['LIKE', "%$find%"];
	}
	
if ($_GET['order'] == 'desc' || ($_POST['find'] != '' && $_POST['colname'] == 5)) { 
	$order_by_clause = "m.ID DESC, u.program_id ASC";
	$btitle = 'Latest';	
} else { 
	$order_by_clause = "m.ID ASC, u.program_id ASC";
	$btitle = 'Earliest';
}

if ($_GET['browse'] == 'Y' && $_REQUEST['program'] != '') {
	$limit = '1000';
} else if ($_GET['browse'] == 'Y' && $_REQUEST['program'] == '') {
	$limit = '500';
} else {
	$limit = 0;
}	

// Execute the select query using PHPCPR
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $order_by_clause, $limit, 1);

$buffer = isset($result[0]) ? $result[0] : null;

print_r($buffer);

$selectFields = ['ID', 'Username', 'First_name', 'Last_name'];
$mainTable = 'members';
$joinConditions = [
    [
        'table' => 'user_permission',
        'as' => 'u',
        'condition' => 'members.ID = u.user_id'
    ]
];
$where = ['1'];
$groupBy = 'u.user_id';
$having = null;
$orderBy = null;
$limit = 0;
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);


if ($Global['program'] > 0) { // FIND THE PROGRAM! WORKS!			
	// Define the fields to select
	$selectFields = ['program_id', 'header_file', 'footer_file', 'program_name'];

	// Specify the main table
	$mainTable = ['table' => 'program', 'as' => 'p'];

	// Define the WHERE conditions
	$where = [
		'p.program_approved' => ['=', 'Y'],
		'p.program_id' => ['=', sanitize($Global['program'], 'int')]
	];

	// Execute the query using the PHPCPR 'select' function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
}
// Check if the result is not empty and assign the first record to $buffer
if (!empty($result)) {
    $buffer = $result[0];
} else {
    // Handle the case where no results are found
    $buffer = null;
}

$selectFields = 'm.ID, m.Username, m.First_Name, m.Last_Name, m.email, m.unsubscribe_id, u.user_status';
$mainTable = ['table' => 'members', 'as' => 'm'];
$joinConditions = [
    [
        'type' => 'INNER JOIN',
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'm.ID = u.ID'
    ]
];
$where = [
    'AND' => [
        'm.email' => ['!=', ''],
        'm.Status' => ['!=', 'Cancelled'],
        'm.Username' => ['!=', 'DELETED'],
        'u.user_status' => ['=', 'Active']
    ]
];
$activeMembers = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);

print_r($activeMembers[0]);

if (is_array($activeMembers)) {
    $_SESSION['total_active'] = count($activeMembers);
} else {
    $_SESSION['total_active'] = 0;
}


//$where = []; // Initialize the where condition array


	unset($where['AND']['u.user_status']);


//Select all programs
$where = ['AND' => ['program_approved' => 'Y']];
if (isset($Global['program_restrict']) && $Global['program_restrict'] != '') {
    $where['AND']['program_id'] = ['NOT IN', $Global['program_restrict']];
}

$orderBy = 'program_up_pay ASC';
$programs = select('program_id, program_name', 'program', [], $where, null, null, $orderBy, 0, 1);

$program_info = '<option value="-1">Select a program</option>';
if ($program_id == 0) {
    $program_info .= '<option value="0" selected>All Programs</option>';
} else {
    $program_info .= '<option value="0">All Programs</option>';
}

if (is_array($programs)) {
    foreach ($programs as $buffer) {
        $selected = ($program_id == $buffer['program_id']) ? ' selected' : '';
        $program_info .= '<option value="'.$buffer['program_id'].'"'.$selected.'>'.htmlentities($buffer['program_name']).'</option>';
    }
}



echo 'now here';