<?php 
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include 'logincheck.php'; 
$pageName = 'Cancellation Page';
$pageDesc = 'Cancel a subscription or cancel your acount';
$pageIcon = 'icon-credit-card';
$pageAlign = 'center';
$pageClass = '';
$errormsg = '';
$successmsg = '';
$noactive = false;
$datetime = date("Y-m-d H:i:s");
$ID = $_SESSION['UserID'];
/*
ini_set('error_reporting', E_ALL);
ini_set('display_errors', 'On');  //On or Off
ini_set('html_errors', 0);
error_reporting(-1);
*/
// CREATE SIMPLE RANDOM CAPTCHA NUMBERS
if (empty($_SESSION['captcha'])) {
	$_SESSION['captcha'] = rand(111,999);
	if ($_SESSION['captcha'] == 665 + 1) $_SESSION['captcha'] = 777;
	$captcha_password = $_SESSION['captcha'];
} else {
	$captcha_password = $_SESSION['captcha'];
}

if (isset($_GET['c']) && $_GET['c'] != '') $_SESSION['cancel'] = $_GET['c']; // VALUES: sub, all // keepstatus, cancelstatus, alldone
if (isset($_GET['c']) && $_GET['c'] == 'live') {	
	if (isset($_SESSION['cancel'])) {
		unset($_SESSION['cancel']);
	}

	if (isset($_SESSION['captcha'])) {
		unset($_SESSION['captcha']);
	}

	if (isset($_SESSION['captchabypass'])) {
		unset($_SESSION['captchabypass']);
	}

//	header("Location: ./profile-check.php");
//	exit;
}
include 'header.php'; 

$has_active_level = false;

for ($i = 1; $i <= 10; $i++) {
    if (isset($_SESSION['p'.$i.'_status']) && ($_SESSION['p'.$i.'_status'] == 'Active' || $_SESSION['p'.$i.'_status'] == 'Comped' || $_SESSION['p'.$i.'_status'] == 'Suspended')) {
        $has_active_level = true;
        break; // Exit the loop as soon as one active or comped status is found
    }
}

$selectFields = 'Status, unsubscribe_id';
$mainTable = 'members';
$where = [
    'ID' => ['=', $ID]
];
$result_unsub = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer_unsub = $result_unsub[0];


if ($has_active_level == false) {
	$nothing_to_cancel = true;
?>	
	<form method="post" action="index.php">
	<button class="btn btn-lg btn-info" title=""><h2 class="btn-info">You are not active in any program level. There is nothing to cancel.</h2></button>
	</form>
<?php
	if ($buffer_unsub['unsubscribe_id'] != '') {

		echo '<br /><br /><a href="'.$Global['webpage_url'].'leave.php?id='.$buffer_unsub['unsubscribe_id'].'">Click here to completely cancel your membership</a><br /><br />';

	}
	include 'footer.php';
	exit;
}


if (!isset($_SESSION['cancel']) || $_SESSION['cancel'] == '') $_SESSION['captchabypass'] = false;

if (!isset($_POST['captcha'])) $_POST['captcha'] = '';

if ($_POST['captcha'] != $captcha_password && $successmsg == '' && isset($_SESSION['captchabypass']) && $_SESSION['captchabypass'] == false) {
	echo "<h2 style='text-align:center'>Cancel Recurring Subscription</h2>";
} else {
	$_SESSION['captchabypass'] = true;
}	

if (isset($_SESSION['debug']) && $_SESSION['debug'] == true) {
	echo 'session cancel: '.$_SESSION['cancel'];
	echo '<br/>session captcha: '.$_SESSION['captcha'];
	echo '<br/>session captcha bypass: '.$_SESSION['captchabypass'];
}

// BUTTON CHOICES PAGE 1 - SHOWN IF SESSIONS NOT PRESENT - JS UPDATE 9/14/15
if (!isset($_SESSION['cancel']) || $_SESSION['cancel'] == '') {
	?>
	<h3>Please choose one option to begin.</h3><p>	&nbsp; &nbsp; &nbsp;</p>
	<div style="display: inline-block">
	<form method="post" action="cancel.php?c=sub">
	<button class="btn btn-lg btn-info" title="Choose this option if you wish to resubscribe, or if you wish to cancel only one program.">Cancel Only One Subscription</button>
	</form>
	&nbsp; &nbsp; &nbsp;
	<form method="post" action="cancel.php?c=all">
	<button href="cancel.php?c=all" class="btn btn-lg btn-danger" title="Choose this option if you wish to cancel your entire <?php echo $Global['webpage_name']; ?> membership.">Cancel My Account (All Programs)</button>
	</form>
	<!--
	&nbsp; &nbsp; &nbsp;
	<form method="post" action="index.php">
	<button class="btn btn-lg btn-success" title="Choose this option if you wish to return to the members home page.">Do NOT Cancel Anything</button>
	</form>
	-->
	</div> &nbsp; &nbsp; &nbsp;
	<?php
	include 'footer.php';
	exit;

// BUTTON CHOICES PAGE 2	
} else if (isset($_SESSION['cancel']) && $_SESSION['cancel'] == 'sub') {
	?>
	<h3>Do you wish to keep your current program status?</h3> 	&nbsp; &nbsp; &nbsp;
	<div style="display: inline-block">
	<form method="post" action="cancel.php?c=keepstatus">
	<button class="btn btn-lg btn-info" title="Choose this option if you wish to resubscribe by making a new payment, or simply remain Active until your current period expires.">Do Not Change My Status</button>
	</form>&nbsp; &nbsp; &nbsp;
	<form method="post" action="cancel.php?c=cancelstatus">
	<button href="cancel.php?c=cancelstatus" class="btn btn-lg btn-danger" title="Choose this option to make your status cancelled, effective immediately.">Change My Status To Cancelled</button>
	</form></div> &nbsp; &nbsp; &nbsp;
	<?php
	include 'footer.php';
	exit;

// BUTTON CHOICES PAGE 2	
} else if (isset($_SESSION['cancel']) && $_SESSION['cancel'] == 'all') {
	?>
	<h3 style="color:red">LAST CHANCE! Are You Sure You Want To Cancel</h3> <h3>Your Entire <?php echo $Global['webpage_name']; ?> Membership?</h3> 	&nbsp; &nbsp; 	
	<h4 style="color:red; text-decoration:underline">NOTE: This action will cancel all subscriptions being paid by you as well as to you! </h4><p> 	&nbsp; &nbsp; &nbsp;</p>
	
	<div style="display: inline-block">
	<form method="post" action="cancel.php?c=alldone"> 
	<button type="submit" class="btn btn-lg btn-info" title="">Yes, Cancel My Membership!</button>
	</form>
	<!--
	&nbsp; &nbsp; &nbsp;
	<form method="post" action="cancel.php?c=live">
	<button class="btn btn-lg btn-danger" title="">No, Do NOT Cancel My Membership!</button>
	</form>
	-->
	</div>	&nbsp; &nbsp; &nbsp;
	<?php
	include 'footer.php';
	exit;	
} // END BUTTON CHOICES

if (isset($_SESSION['cancel']) && $_SESSION['cancel'] == 'keepstatus') {
	
	$selectFields = 'e4_arb_id';
	$mainTable = 'e4_arb';
	$where = [
		'id_paying' => ['=', $ID],
		'active' => ['=', 'Y']
	];

	$result_e4 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffere4 = isset($result_e4[0]) ? $result_e4[0] : null;
	
	$selectFields = 'stripe_customer_id, customerProfileId';
	$mainTable = 'members';
	$where = ['ID' => ['=', $ID]];

	$result_auth = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$bufferauth = isset($result_auth[0]) ? $result_auth[0] : null;
	
		
	if (!isset($buffere4['e4_arb_id']) && $bufferauth['stripe_customer_id'] == '' && $bufferstr['customerProfileId'] == 0) {
	?>
	<button type="button" class="btn btn-lg btn-transparent btn-danger" data-original-title="">You have no current credit card subscriptions.</button>  
	<?php
	echo "&nbsp; &nbsp; &nbsp;";
	if ($buffer_unsub['unsubscribe_id'] != '') {

		echo '<br /><br /><a href="'.$Global['webpage_url'].'leave.php?id='.$buffer_unsub['unsubscribe_id'].'">Click here to completely cancel your membership</a><br /><br />';

	}
	include 'footer.php';
	unset($_SESSION['cancel']);
	exit;
	}
}

// HUMAN TEST PAGE 3
if (isset($_SESSION['cancel']) && $_SESSION['cancel'] != '' && ($_SESSION['captchabypass'] == false && trim($_POST['captcha']) != $captcha_password)) { // DID NOT PASS CAPTCHA!
	echo "<div style=\"display: inline-block\">";
	echo "<h4>Please Enter This Code Number In The<br/>Form Field, To Prove You Are Human:</h4>";
	echo "<h1 style=\"color:red\"><strong>{$captcha_password}</strong></h1>"; 
	echo "<form method=\"post\" action=\"cancel.php\">";
	echo "<input class=\"form-control\" onMouseover=\"this.focus()\" size=\"25\" name=\"captcha\" value=\"".((!empty($_POST['captcha']))?$_POST['captcha']:'')."\" title=\"Enter the number you see, here.\">";
	echo "<button class=\"btn btn-lg btn-danger\" title=\"\">Continue With My Cancellation Request</button>";
	echo "</form></div>&nbsp; &nbsp; &nbsp;";
	include 'footer.php';
	exit;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// CANCEL USERS BELOW!!

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

if (isset($_GET['upid'])) {
	$targeted_user_program_id = $_GET['upid'] + 0;
} else {
	$targeted_user_program_id = 0;
}
	
if ($_SESSION['debug'] == true) echo 'targeted_user_program_id: '.$targeted_user_program_id.'<br>';

$query = "";

// MUST UPDATE THIS FILE, THE OLD PROCESS HAD ISSUES, NOT ALWAYS CANCELLING THE MEMBER!
// SO FOR NOW, CANCELLING IN ALL PROGRAMS, IF THEY CANCEL ANYTHING!!
	
if (/*$targeted_user_program_id != 0 && */$_SESSION['cancel'] == 'cancelstatus') { // JUST CANCEL ONE PROGRAM
		
	$updateData = [
		'end_program' => 'Y',
		'user_status' => 'Cancelled',
		'cancelled_by' => 'member',
		'date_cancelled' => $datetime
	];
	$where = [
		'ID' => ['=', $ID],
		'user_program_id' => ['=', $targeted_user_program_id]
	];
	update('user_program', $updateData, [], $where, 1, 1, 1);
			
	if ($Global['use_E4'] === true) {
		$selectFields = 'program_id';
		$mainTable = 'user_program';
		$where = ['user_program_id' => ['=', $targeted_user_program_id]];

		$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
		$bufferu = $result[0] ?? null;

		// Update e4_arb for id_paying and id_receiving
		$updateData = ['active' => 'N'];
		$wherePaying = [
			'program_id' => ['=', $bufferu['program_id']],
			'id_paying' => ['=', $ID]
		];
		update('e4_arb', $updateData, [], $wherePaying, 1, 1, 1);

		$whereReceiving = [
			'program_id' => ['=', $bufferu['program_id']],
			'id_receiving' => ['=', $ID]
		];
		update('e4_arb', $updateData, [], $whereReceiving, 1, 1, 1);
	}
		
	// ONLY CANCELLING ONE PROGRAM, SO DON'T KILL REBILLING INFO!	
	/*$updateData = [
		'stripe_customer_id' => '',
		'stripe_payment_method' => '',
		'customerProfileId' => '',
		'customerPaymentProfileId' => ''
	];
	$where = ['ID' => ['=', $ID]];
	update('members', $updateData, [], $where, 1, 1, 1);*/
	
	unset($_SESSION['cancel']);
	$successmsg = "This program has been cancelled!";
	
	// CANCEL USER IN MATRIX
	$updateData = ['active' => 'N', 'matlevel' => $bufferu['program_id']];
	$where = ['usrid' => ['=', $ID]];
	update('matrix', $updateData, [], $where, 1, 0, 1);
	
} else if (isset($_SESSION['cancel']) && $_SESSION['cancel'] == 'alldone') { // CANCEL ALL PROGRAMS

	$updateData = [
		'end_program' => 'Y',
		'user_status' => 'Cancelled',
		'cancelled_by' => 'member',
		'date_cancelled' => $datetime
	];
	$where = ['ID' => ['=', $ID], 'user_status' => ['!=', 'Unpaid']];
	update('user_program', $updateData, [], $where, 1, 1, 1);
		
	if ($Global['use_E4'] === true) {
		$selectFields = 'program_id';
		$mainTable = 'user_program';
		$where = ['user_program_id' => ['=', $targeted_user_program_id]];

		$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
		$bufferu = $result[0];

		// Update e4_arb for id_paying and id_receiving
		$updateData = ['active' => 'N'];
		$wherePaying = [
			'id_paying' => ['=', $ID]
		];
		update('e4_arb', $updateData, [], $wherePaying, 1, 1, 1);

		$whereReceiving = [
			'id_receiving' => ['=', $ID]
		];
		update('e4_arb', $updateData, [], $whereReceiving, 1, 1, 1);
	}
	$updateData = [
		'Status' => 'Cancelled',	
		'stripe_customer_id' => '',
		'stripe_payment_method' => '',
		'customerProfileId' => '',
		'customerPaymentProfileId' => ''
	];
	$where = ['ID' => ['=', $ID]];
	update('members', $updateData, [], $where, 1, 1, 1);
		
	// CANCEL USER IN MATRIX
	$updateData = ['active' => 'N'];
	$where = ['usrid' => ['=', $ID]];
	update('matrix', $updateData, [], $where, 1, 0, 1);
		
	if (isset($_SESSION['cancel'])) {
		unset($_SESSION['cancel']);
	}

	if (isset($_SESSION['captcha'])) {
		unset($_SESSION['captcha']);
	}

	if (isset($_SESSION['captchabypass'])) {
		unset($_SESSION['captchabypass']);
	}		
	$successmsg = "All programs have been cancelled!";

} else if (isset($_SESSION['cancel']) && $_SESSION['cancel'] == 'keepstatus' && $targeted_user_program_id != 0) { // KILL ONLY PAYING ARB RECORD!
	// CANCEL E4 REBILLING IN ONE PROGRAM
	
	$updateData = [
		'stripe_customer_id' => '',
		'stripe_payment_method' => '',
		'customerProfileId' => '',
		'customerPaymentProfileId' => ''
	];
	$where = ['ID' => ['=', $ID]];
	update('members', $updateData, [], $where, 1, 1, 1);	
		
	if ($Global['use_E4'] === true) {
		$selectFields = 'program_id';
		$mainTable = 'user_program';
		$where = ['user_program_id' => $targeted_user_program_id];

		$result_u = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
		if (!empty($result_u)) {
			$bufferu = $result_u[0];

			// Update `e4_arb` table
			$updateDataE4 = ['active' => 'N'];
			$whereE4 = [
				'active' => ['=', 'Y'],	
				'program_id' => ['=', $bufferu['program_id']],
				'id_paying' => ['=', $ID]
			];
			update('e4_arb', $updateDataE4, [], $whereE4, 1, 1, 1);
		} else {
			die('no program found');
		}
	}
		

	if (isset($_SESSION['cancel'])) {
		unset($_SESSION['cancel']);
	}

	if (isset($_SESSION['captcha'])) {
		unset($_SESSION['captcha']);
	}

	if (isset($_SESSION['captchabypass'])) {
		unset($_SESSION['captchabypass']);
	}		
	
	$successmsg = "The subsciption billing for this program was cancelled!";
}


$moretogo = false;


if ($has_active_level === false) $nothing_to_cancel = true;
else $nothing_to_cancel = false;

if ($nothing_to_cancel == true) {
// DO NOTHING
} /*else if (isset($_SESSION['cancel']) && $_SESSION['cancel'] != 'alldone') {
	$moretogo = true;	
	if ($successmsg == '') {

		$querye4 = "SELECT e4_arb_id FROM e4_arb WHERE id_paying='".$ID."' AND active='Y'";
		$resulte4 = mysql_query($querye4);
		$buffere4 = mysql_fetch_assoc($resulte4);
				if ($buffere4['e4_arb_id']!='') {*/
	/*	
	$querye4 = "SELECT stripe_customer_id FROM members WHERE ID='".$ID."'";
	$resulte4 = mysql_query($querye4);
	$buffere4 = mysql_fetch_assoc($resulte4);*/
/*		
	if ($buffere4['stripe_customer_id']!='') {		
		
	?>
	<button type="button" class="btn btn-lg btn-transparent btn-danger" data-original-title="">Please click on the subscription you wish to cancel.</button>  

	<p>&nbsp;</p>
	<?php
		} else { 
		$noactive = true;
		?>
		<button type="button" class="btn btn-lg btn-transparent btn-danger" data-original-title="">You have no active credit card subscriptions...</button>  

	<p>&nbsp;</p>	
	<?php
		}	
	}
}

if ($rowsaffected <= 0) {
//	$errormsg = "YOU ARE NOT SUBSCRIBED TO THAT PROGRAM - NO CHANGES MADE";
} else {
//	$successmsg = "SUCCESS!";

	// ADDING IPAYOUT CANCELLATIONS
	if ($Global['use_ipayout_to_collect'] === true) {

		$MerchantGUID = $Global['ipayout_merchantGUID']; // the Merchant GUID from iPayout
		$MerchantPassword = $Global['ipayout_MerchantPassword']; // production password
		//$eWalletAPIURL = "https://testewallet.com/eWalletWS/ws_Adapter.aspx";			// TEST EWALLET URL
		$eWalletAPIURL = "https://www.i-payout.net/eWalletWS/ws_Adapter.aspx";		// PRODUCTION EWALLET URL

	$deleted_plans = 0;
	$result = mysql_query("SELECT pp.payment_plan_id, m.Username FROM user_program as prog JOIN members as m JOIN user_payment_plan as upp JOIN payment_plan as pp WHERE m.ID=prog.ID AND upp.user_program_id=prog.user_program_id AND pp.user_payment_plan_id=upp.user_payment_plan_id AND prog.user_program_id={$targeted_user_program_id} ORDER BY m.Username, pp.payment_plan_id");
	while ($buffer = mysql_fetch_assoc($result)) {
		
		$payment_plan_id = $buffer['payment_plan_id'];
		$username = $buffer['Username'];

		// prepare parameters for eWallet HTTP adapter

		$params = array(
			'fn'    			=> 'eWallet_RemoveUserRecurringPayin',
			'MerchantGUID'		=> $MerchantGUID,
			'MerchantPassword'	=> $MerchantPassword,
			'UserName'	=> $username,
			'PayinID' => 0,
			'MerchantReferenceID' => $payment_plan_id,
		);
	//print_r($params);
		// make a POST request to eWallet HTTP adapter
		/*$ch = curl_init($eWalletAPIURL);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		$ips_response = curl_exec($ch);
		curl_close($ch);*/

	/*
		// parse return
		parse_str($ips_response);
		//echo $ips_response."<br>";
		parse_str($Resp);

					echo "<br>".$username . " " .$payment_plan_id." ";
					if ($m_Code != "") echo "  m_Code = " . $m_Code . " "; // if success, it should be NO_ERROR
					if ($m_Text != "") echo "  m_Text = " . $m_Text . " "; // if error, it will contain error description
					if ($m_Text == "OK") $deleted_plans++;	
		//var_dump($Payins);
		//mysql_query("UPDATE 0_0cancelplans SET status='DONE' WHERE idx='{$idx}'");
	
	}
	//echo "<br><br>********************<br>Done. ".$deleted_plans." Plans Deleted.  MAX record: ".$idx;
	} // END ADDING IPAYOUT CANCELLATIONS

} // END ROWS AFFECTED LESS THAN OR ZERO
*/

$program_info = [];

$selectFields = 'up.user_status, up.end_program, up.expire, p.program_id, p.program_name, up.user_program_id, up.started';
$mainTable = ['table' => 'user_program', 'as' => 'up'];
$joinConditions = [
    ['table' => 'program', 'as' => 'p', 'condition' => 'up.program_id = p.program_id'],
    ['table' => 'members', 'as' => 'm', 'condition' => 'm.ID = up.ID']
];
$where = [
    'm.ID' => ['=', $ID],
    'p.program_type' => ['=', 'S'],
    'p.program_approved' => ['=', 'Y'],
    'up.user_status' => ['IN', ['Active', 'Comped', 'TempComp', 'FreeTrial', 'Suspended']]
];
$orderBy = 'p.program_id ASC';
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, $show_debug);

$rowcounter = 0;

foreach ($result as $row) {
    $rowcounter++;
    $program_info[$rowcounter] = [
        'program_id' => $row['program_id'],
        'program_name' => $row['program_name'],
        'user_status' => $row['user_status'],
        'end_program' => $row['end_program'],
        'expire' => $row['expire'],
        'user_program_id' => $row['user_program_id'],
        'started' => $row['started']
    ];
}
	

echo '<p>&nbsp;</p>';
if ($errormsg != "") {
	echo '<h3>'.$errormsg.'</h3>';
}
if ($successmsg != "") { 
	echo '<div class="btn-success"><h1 style="color:#fff">'.$successmsg.'</h1>
	<h2 style="color:#fff"><strong>Your request has been successfully processed. Thank you.</strong></h2>
	</div><hr>';

//} else if ($noactive == true && $_SESSION['cancel'] != 'keepstatus') { 
} else {

if ($rowcounter > 0) {
	for ($i = 1; $i <= $rowcounter; $i++) { 
		if ($program_info[$i]['expire'] == 0) {
			$exp_message1 = " currently Active.";
			$exp_message2 = " FREE TRIAL is Active.";
			$exp_message3 = " FREE TRIAL.  You will NOT be charged.";
			$exp_message4 = " You will NOT be charged further.";
			$exp_message5 = " You are currently Suspended. Click here to cancel.";
		} else {
			$exp_message1 = " Expiration: ". date("M d, Y",$program_info[$i]['expire']) . "";
			$exp_message2 = " FREE TRIAL. Expiration: ". date("M d, Y",$program_info[$i]['expire']) . ".";
			$exp_message3 = " FREE TRIAL Will End ". date("M d, Y",$program_info[$i]['expire']) . ". You will NOT be charged.";
			$exp_message4 = " Expiration: ". date("M d, Y",$program_info[$i]['expire']) . ". You will NOT be charged further.";
			$exp_message5 = " You are currently Suspended. Click here to cancel.";			
		}
	}
}	
?>
    
<?php if ($program_info[$i]['user_status'] == "Active" && $program_info[$i]['end_program'] == 'N') { ?>

	<form method="post" action="cancel.php?upid=<?php echo $program_info[$i]['user_program_id']; ?>">
	<button type="submit" class="btn btn-lg btn-danger" title="Cancel this program.">
	CANCEL >>> <?php echo $program_info[$i]['program_name'] . $exp_message1; ?></button></a>
	</form>
	<p>&nbsp;</p>
	<?php if ($_SESSION['cancel'] == 'keepstatus') { ?>
	This action will only cancel any current rebilling subscriptions, if any.<br/><hr>
	<?php } ?>

<?php } else if (($program_info[$i]['user_status'] == "FreeTrial") && $program_info[$i]['end_program'] == 'N') { ?>

	<form method="post" action="cancel.php?upid=<?php echo $program_info[$i]['user_program_id']; ?>">
	<button type="submit" class="btn btn-lg btn-danger" title="Cancel this program.">
	CANCEL >>> <?php echo $program_info[$i]['program_name'] . $exp_message2; ?></button>
	</form>
	<p>&nbsp;</p>
	
<?php } else if (($program_info[$i]['user_status'] == "Suspended" && $program_info[$rowcounter]['e4'] == 'Y')) { ?>

	<form method="post" action="cancel.php?upid=<?php echo $program_info[$i]['user_program_id']; ?>">
	<button type="submit" class="btn btn-lg btn-danger" title="Cancel this program.">
	CANCEL >>> <?php echo $program_info[$i]['program_name'] . $exp_message5; ?></button>
	</form>
	<p>&nbsp;</p>	

<?php } else if (($program_info[$i]['user_status'] == "FreeTrial") && $program_info[$i]['end_program'] == 'Y') { ?>
<!--
	<form method="post" action="program.php?program=<?php echo $program_info[$rowcounter]['program_id']; ?>">
	<button type="submit" class="btn btn-lg btn-success" title="Click here to rejoin this program.">
	CANCELLED <?php echo $program_info[$i]['program_name'] . $exp_message3; ?></button>
	</form>
	<p>&nbsp;</p>
-->
<?php } else if (($program_info[$i]['user_status'] == "Active") && $program_info[$i]['end_program'] == 'Y') { ?>
<!--
	<form method="post" action="program.php?program=<?php echo $program_info[$rowcounter]['program_id']; ?>">
	<button type="submit" class="btn btn-lg btn-success" title="Click here to rejoin this program.">
	CANCELLED <?php echo $program_info[$i]['program_name'] . $exp_message4; ?></button>
	</form>
	<p>&nbsp;</p>
-->
<?php } else if ($program_info[$i]['user_status'] == "Comped" || $program_info[$i]['user_status'] == "TempComp") { ?>

	<button class="btn btn-lg btn-success" title="You are comped in this program. Comped members are not charged a fee.">
	COMPED <?php echo $program_info[$i]['program_name']; ?></button>
	<p>&nbsp;</p>

<?php } 
}?>


<?php 
$processor_list = "";
if ($Global['use_paypal'] == true) $processor_list .= "PayPal";
if ($Global['use_dwolla'] == true) if ($processor_list != "") $processor_list .= " or Dwolla"; else $processor_list .= "Dwolla";
if ($Global['use_gc'] == true) if ($processor_list != "") $processor_list .= " or Google Checkout"; else $processor_list .= "Google Checkout";
if ($processor_list != "") { ?>
<button type="button" class="btn btn-danger btn-block" data-original-title="" title="">
<i class="fa fa-spinner"></i>
<strong><h2 style="color:#fff">IMPORTANT:</h2></strong>
<div style="text-align:center">
<h4><strong> If you are paying using <?php echo $processor_list; ?>, you must log in to your account there<br/>to cancel your subscription to prevent further charges! Thank you.</strong></h4>
</div>

</button>
<?php } 
if ($moretogo == true && $successmsg != '') { ?>
<hr>
	<a href="cancel.php" class="btn btn-lg btn-danger" title="Click here to cancel another program.">
	Click here to cancel another program.</a>
	<p>&nbsp;</p>

<?php
}
?>

<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>
<?php 
if ($_SESSION['debug'] == true) {
echo 'session cancel: '.$_SESSION['cancel'];
echo '<br/>session captcha: '.$_SESSION['captcha'];
echo '<br/>session captcha bypass: '.$_SESSION['captchabypass'];
}


$selectFields = 'Status, unsubscribe_id';
$mainTable = 'members';
$where = [
    'ID' => ['=', $ID],
    'Status' => ['!=', 'Cancelled']
];

$result_unsub = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer_unsub = $result_unsub[0] ?? '';


if (isset($buffer_unsub['unsubscribe_id'])) {

	echo '<br /><br /><a href="'.$Global['webpage_url'].'leave.php?id='.$buffer_unsub['unsubscribe_id'].'">Click here to completely cancel your membership</a><br /><br />';

}
include 'footer.php'; ?>