<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php'; 
$pageName = ''; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-trash-o'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES
$date = date("Y-m-d");

/*
if (!empty($_GET['dev']) || !empty($_SESSION['dev'])) {
	// DO NOTHING
	$_SESSION['dev'] = true;
} else {
	echo 'Locked for dev use';
	exit;
}
*/

if ($_POST == '' && $_GET['id'] == '') {
	header("Location: ./leads.php");
	exit;
} else {
	$_SESSION['lead_edit_md5_trash'] = $_GET['id'];
}
$md5 = $_SESSION['lead_edit_md5_trash'];

$ID = $_SESSION['UserID'];
//SHOW ALL ERRORS
//error_reporting(-1);
//error_reporting = E_ALL;


$selectFields = ['Status'];
$mainTable = 'members';
$where = ['ID' => $ID];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result ? reset($result) : null;

//print_r($buffer);
//echo 'Status';
//echo $buffer['Status'];
//exit;
$loggedin_user_is_closer = false; // INITIALIZE VAR

//  DEFINE CLOSER ACCOUNTS
if ($buffer['Status'] == 'closer') {
	$loggedin_user_is_closer = true;
}

$selectFields = ['*']; // Assuming you want to select all fields
$mainTable = 'ar_leads';
$orderBy = 'ar_leads_id ASC';
$limit = 1;

if ($loggedin_user_is_closer == false) {
    $where = [
        'ID' => $ID,
        'ar_leads_md5' => $md5
    ];
} else if ($loggedin_user_is_closer == true) {
    $where = [
        'status' => 'closer',
        'closer_id' => $ID,
        'ar_leads_md5' => $md5
    ];
}

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$buffer_lead = $result ? reset($result) : null;

$lead_status = array(1=>'Enabled', 2=>'Blacklisted', 3=>'Unsubscribed', 4=>'Unconfirmed');

if ($buffer_lead['ar_leads_id'] == '' || $buffer_lead['ar_leads_md5'] != $md5) {
	echo 'INVALID REQUEST';
	exit;
}

$ar_leads_id = $buffer_lead['ar_leads_id'];
$md5_confirmed = $buffer_lead['ar_leads_md5'];

//if the user submited the form
if (!empty($_POST)) {
	
	// Retrieving ar_member_master_id
	$selectFields = array('ar_member_master_id');
	$mainTable = 'ar_link';
	$where = array('ar_leads_id' => $ar_leads_id);
	$result_del = select($selectFields, $mainTable, array(), $where, null, null, null, 0, 1);
	$buffer_del = current($result_del); // Assuming select returns an array of results

	$ar_member_master_id = $buffer_del['ar_member_master_id'];

	// Deletion operations
	$deletionTables = [
		'ar_leads' => ['ar_leads_md5' => $md5_confirmed],
		'ar_link' => ['ar_leads_id' => $ar_leads_id],
		'ar_member_email' => ['ar_member_master_id' => $ar_member_master_id],
		'ar_member_master' => ['ar_member_master_id' => $ar_member_master_id],
		'ar_survey' => ['ar_leads_id' => $ar_leads_id],
		'ar_personal_followups' => ['ar_leads_id' => $ar_leads_id]
	];

	foreach ($deletionTables as $table => $whereConditions) {
		delete($table, [], $whereConditions, null, 1, 1, 1);
	}
	
	
	header('location: leads.php?deleted=yes');
	exit;
}

include_once './header.php';

//print_r($buffer_lead);

$closer = false;
//$closer = true; // FOR TESTING ONLY!
if ($buffer_lead['status'] == 'closer' && $loggedin_user_is_closer == false) $closer = true;

if ($closer == true) {
	$lastname = substr($buffer_lead['ar_leads_lastname'], 0, 3).'...';
	$email = substr($buffer_lead['ar_leads_email'], 0, 4).'... (Closer Lead)';
} else {
	$lastname = $buffer_lead['ar_leads_lastname'];
	$email = $buffer_lead['ar_leads_email'];
}
?>

<div class="row">
        <div class="col-xs-12 col-sm-3">
            <p>&nbsp;</p>
        </div>

      <div class="col-xs-12 col-sm-6">
	<h2>Delete Lead?</h2><br/>
<div class="table-responsive" style="text-align:left">
  <table class="table">
		<tr>
			<td><strong>First Name:</strong></td>
			<td><?php echo $buffer_lead['ar_leads_firstname']; ?></td>
		</tr>
		<tr>
			<td><strong>Last Name:</strong></td>
			<td><?php echo $lastname; ?></td>
		</tr>
		<tr>
			<td><strong>E-mail:</strong></td>
			<td><?php echo $email; ?></td>
		</tr>
		<tr>
			<td><strong>Phone:</strong></td>
	<?php
	$phone = '';
	$phone = $buffer_lead['ar_leads_phone'];
	$phone = preg_replace("/^1?(?:[- .])?(\d{3})(?:[- .])?(\d{3})(?:[- .])?(\d{4})$/", "($1) $2-$3", $phone);
	
	if ($closer == true && $phone != '') {
		$phone = '(***) ***-****';	
		//echo $phone;
	} else {
		//echo '<a href="tel:+1-'.$buffer_lead['ar_leads_phone'].'">'.$phone.'</a>';
	}
?>			
			<td><?php echo $phone; ?></td>
		</tr>
		<tr>
			<td><strong>Date joined:</strong></td>
			<td><?php echo date('m/d/Y H:i:s', strtotime($buffer_lead['ar_leads_date'])); ?></td>
		</tr>
		<tr>
			<td><strong>Status:</strong></td>
			<td><?php echo $lead_status[$buffer_lead['ar_leads_status']]; ?></td>
		</tr>
	<form method="post" action="lead_delete.php?id=<?php echo $buffer_lead['ar_leads_md5']; ?>">
	<!--
		<input type="submit" name="submit" value="Delete" /> <input type="button" value="Cancel" onclick="window.location.href='leads.php?ar=<?php echo (int)$_GET['ar']; ?>'" />
	-->
	<!--
	<tr><td rowspan="2" style="float: none; margin: 0 auto">
	<div class="btn-group" role="group" aria-label="Basic example">
	<input type="submit" class="btn btn-danger" name="submit" value="Delete" /> <input type="button" class="btn btn-default" value="Cancel" onclick="window.location.href='leads.php'" />
	</div>
	</td></tr>
	-->
  </table>
</div>

	<div class="btn-group" role="group" aria-label="Basic example">
	<input type="submit" class="btn btn-danger" name="submit" value="Delete" /> <input type="button" class="btn btn-default" value="Cancel" onclick="window.location.href='leads.php'" />
	</div>
</form>
</div>
<div class="col-xs-12 col-sm-3">
  <p>&nbsp;</p>
</div>
</div>

<?php include_once './footer.php';