<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php';
$pageName = "leaderboard";
// FILE BUILT FROM leader_earnings.php - but that file uses payment logs
// This file uses transaction_logs - for use with matrix systems

//$debug = true;

// QQQ SET PER PROGRAM - LIST IDS TO EXCLUDE, SEPARATED BY COMMAS
//$exclude_ids = [0, 1]; // DEFAULT - ONLY ADMIN IS EXCLUDED
$exclude_ids = [0, 1]; // QQQ CUSTOM PER CLIENT

 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//$_SESSION['UserID'] = 81; // FOR TESTING ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */

/*if (!isset($_GET['program'])) {

	// THEY MUST CHOOSE WHICH TO VIEW NOW!
	$pageName = 'Choose Leaderboard To View';
	include './header.php';
	?>
	<a href="leaderboard_stats.php?program=1" class="btn btn-info btn-lg" title="" name="submit" style="width: 30%; font-size:14pt;" data-original-title="">
			2x12 Leaderboard &nbsp;<i class="fa fa-sitemap" style="margin-left: 10px; margin-bottom:0px;">
			</i></a>	
			
	<a href="leaderboard_stats.php?program=2" class="btn btn-info btn-lg" title="" name="submit" style="width: 30%; font-size:14pt;" data-original-title="">
			3x4 Leaderboard &nbsp;<i class="fa fa-sitemap" style="margin-left: 10px; margin-bottom:0px;">
			</i></a>			
		
		
	<?php
	include './footer.php';
	exit;	
}*/
 
$contest_link = '<a href="leaderboard_contest.php" class="btn btn-default btn-xs">Contest Places</a>';

$contest_link = ''; // NOT USING CONTEST YET
 
//if ($_SESSION['UserID'] < 3) $debug = true; 
 
if (empty($Global['program_restrict'])) $Global['program_restrict'] = '';

// DISALLOW MANUALLY MARKED PAYMENTS IN LEADERBOARD EARNINGS
//$manual = " AND log.payment_processor != 'C' ";
// 4/30/20 UPDATE - WE NOW MAKE SURE PAYER IS ACTIVE, SO IT DOES NOT MATTER IF THEY PAID WITH A CUSTOM METHOD OR NOT.
// IF THEY ARE ACTIVE, WE KNOW ADMIN MARKED THE ADMIN PAYMENT PAID, SO WE INCLUDE THEM. CHEATING WITH FAKE CUSTOM PAYMENTS IS NOW IMPOSSIBLE!

// ALLOW MANUALLY MARKED PAYMENTS IN LEADERBOARD EARNINGS
$manual = "";

$today = date("Y-m-d");

$timestamp = time();
$daysago30 = strtotime("-30 day");
$daysago90 = strtotime("-90 day");
$daysago180 = strtotime("-180 day");
$daysago365 = strtotime("-365 day");

$daysago30 = date('Y-m-d', strtotime("-30 day"));
$daysago90 = date('Y-m-d', strtotime("-90 day"));
$daysago180 = date('Y-m-d', strtotime("-180 day"));
$daysago365 = date('Y-m-d', strtotime("-365 day"));


$date30 = date("Y-m-d",strtotime("-30 day", $timestamp));
$date90 = date("Y-m-d",strtotime("-90 day", $timestamp));
$date180 = date("Y-m-d",strtotime("-180 day", $timestamp));
$date365 = date("Y-m-d",strtotime("-365 day", $timestamp));

//$program_id = 1; // INI VAR

//Select the correct program	
if (!empty($_GET['program']) && intval($_GET['program']) > 0) $Global['program'] = intval($_GET['program']);
elseif (!empty($_SESSION['program']) && intval($_SESSION['program']) > 0) $Global['program'] = intval($_SESSION['program']);
else $Global['program'] = $Global['default_program'];

$_SESSION['program'] = $Global['program'];

$program_id = $Global['program'];

if (!isset($Global['program'])) {
	echo 'Program does not exist!';
	exit;
}

if ($Global['program'] > 0) { // FIND THE PROGRAM!		
	// Define the fields to select
	$selectFields = ['program_id', 'header_file', 'footer_file', 'program_name', 'giveaway_file'];

	// Specify the main table
	$mainTable = ['table' => 'program', 'as' => 'p'];

	// Define the WHERE conditions
	$where = [
		'p.program_approved' => ['=', 'Y'],
		'p.program_id' => ['=', sanitize($Global['program'], 'int')]
	];

	// Execute the query using the PHPCPR 'select' function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = isset($result[0]) ? $result[0] : null;

	//if the program does not exist, send the user back
	if (empty($buffer['program_name'])) {
		echo 'Program does not exist!';
		exit;
	}	
	
	$program_name = $buffer['program_name'];

	if ($buffer['giveaway_file'] == 'Mat.give.php') $program_is_matrix = true;
	else $program_is_matrix = false;

	if ($program_is_matrix == true) { 
		//echo 'prog is mat'; exit;
		// PROGRAM IS MATRIX - NOW WE GET ALL CUSTOM MATRIX SETTINGS
		include ''.$_SERVER['DOCUMENT_ROOT'].'/Ipn/Give/Mat.config.inc.php';
	}	
}

$Global['program_name'] = $buffer['program_name'];		
	
if ($debug == true) echo 'Program ID: '.$program_id;	
	
//$Global['header'] = $buffer['header_file'];
//$Global['footer'] = $buffer['footer_file'];
$Global['header'] = 'header_tpl.php';
$Global['footer'] = 'footer_tpl.php';

//if ($program_id != 0) $prog_master = "AND program_id='{$program_id}' {$Global['program_restrict']}"; 
//else $prog_master = "";
if ($program_id != 0) $prog_master = ['program_id' => ['=', $program_id]];
else $prog_master = '';

/*$where = [
	$prog_master,
    "date = '{$date30}'",
    'totamt > 0',
    "program_id = '{$program_id}'"
];*/

if (isset($_GET['reset']) && $_GET['reset'] != '') {
    $table = 'leaderboard_earnings';
    //$where = ['1'];
	$where = $prog_master;
    delete($table, [], $where, null, 1, 0, 1);		
}

//THE LEADERBOARD STATS ARE POPULATED EVERY 24 HOURS, BY THE FIRST PERSON TO ACCESS THE PAGE / PROGRAM EACH DAY.

// Assuming $date30 is already defined and sanitized earlier in your script
//$date30 = sanitize($date30, 'date30');

$selectFields = ['idx'];
$mainTable = 'leaderboard_earnings';

$where = [
    'date' => ['=', "$date30"],
    'totamt' => ['>', 0]
];
// Only merge $prog_master if it's an array
if (is_array($prog_master) && !empty($prog_master)) {
	$where += $prog_master;
}

$orderBy = 'idx ASC';
$limit = 1;
$show_debug = 1;

// Replace mysql_query and mysql_fetch_assoc
$buffer = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
if ($debug) {
    echo '<br>'.print_r($buffer, true).'<br>';
}


if ($program_id != 0 && empty($buffer['idx'])) { // WE HAVE A PROGRAM ID, AND NO SALES FROM 30 DAYS AGO YET!
// THERE MAY OR MAY NOT BE SALES TODAY, BUT WE WILL WIPE THE TABLE ANYWAY AND START FRESH
// IF PROGRAM IS HOPPING THERE WILL ALWAYS BE SALES EACH DAY. THIS PAGE WILL STORE RESULTS IN TABLE FOR SPEED
// IF PROGRAM IS NOT HOPPING, THEN THIS ACTION MAY RE-CREATE THE TABLES ON THE FLY EACH DAY UNTIL THERE ARE SALES
// BUT IF THE PROGRAM IS THAT SLOW, PERFORMANCE ON THIS PROCESS IS NOT GOING TO BE AN ISSUE ANYWAY.
	if ($debug == true) echo 'WIPED TABLE - UPDATE IS TRUE!';
	
	$table = 'leaderboard_earnings';
    $where = ['program_id' => ['=', $program_id]];
    delete($table, [], $where, null, 1, 0, 1);	
	
	$update = true;
	
} else if ($program_id == 0) { // DO NOT UPDATE IF NO PROGRAM - WILL SCREW UP THE INSERTS - AND MAKE ENTRIES WITH PROGRAM ID 0, WHICH WOULD BE VERY BAD
	// ALSO WE NEVER WIPE OUT ALL PROGRAMS, AS THERE WILL BE NOTHING TO SHOW!
	if ($debug == true) echo 'PROGRAM IS 0 - DID NOT WIPE TABLE - UPDATE IS FALSE!';	
	$update = false; 
}

$pageName = 'Leaderboard (By Earnings)';
$pageDesc = $Global['program_name'].' Leaderboard (By Earnings)';
$pageIcon = 'fa fa-sitemap';
$pageAlign = 'center';
$pageClass = '';
if ($debug != true) include './../Sub/tpl/'.$Global['header'];

//echo $date30 .' UPDATE: '.$update;
//echo $program_id;
//echo '<h2>'.$Global['program_name'].' Leaderboard</h2>';
// QUERIES ARE FOR PAID ACCOUNTS ONLY	
echo '<h2>Top Earning Sponsors '.$contest_link.'</h2>';

/*
echo <<<EOD
<form enctype="multipart/form-data" method="get" action="leaderboard_earnings.php">
<input type="submit" value="View Top Leaders" name="submit" class="btn btn-info btn-default">
</form>
EOD;
*/
	
?>

            <div class="panel-body">
              <div class="row show-grid">
                

<?php
if ($update == true) { // 30 DAYS

					// ADDED AND log.amount > 0 AS WITHDRAWALS CAUSED PEEPS TO GET KICKED OFF LEADERBOARD! 	
		$selectFields = 'memb.Username, memb.First_Name, memb.Last_Name, SUM(log.amount) as totamt';
		$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
		$joinConditions = [
			[
				'table' => 'members',
				'as' => 'memb',
				'condition' => 'log.usrid = memb.ID'
			]
		];
		$where = [
			'memb.ID' => ['NOT IN', $exclude_ids],
			'log.amount' => ['>', 0],
			'log.logdate' => ['>', $daysago30]
		];
		$where['log.description'] = ['LIKE', '%' . $GLOBALS['mat_config'] . '%'];
		$groupBy = 'log.usrid';
		$orderBy = ['totamt DESC', 'memb.ID ASC'];
		$limit = 15;
		$show_debug = 1;
		$topdownlines = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);					

					echo '<div class="col-xs-6 col-sm-3" ><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last 30 Days</div></h4><ol>';	
					foreach ($topdownlines as $downliners) {
						
						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
						
						if ($program_id != 0) {
							$table = 'leaderboard_earnings';
							$data = [
								'program_id' => $program_id,
								'Username' => $downliners['Username'],
								'First_Name' => $downliners['First_Name'],
								'Last_Name' => $downliners['Last_Name'],
								'totamt' => $downliners['totamt'],
								'date' => $date30
							];
							$live = 1; // Assuming you want to execute the query live
							$show_debug = $debug; // Assuming $debug is a boolean that controls debugging

							$result = insert($table, $data, $live, $show_debug);

							if ($show_debug) {
								echo debug_stmt($result);
							}

							// Additional code to handle $result
						}	
					}
					echo '</ol></div></span></div>';
} else { // UPDATE IS FALSE					
					echo '<div class="col-xs-6 col-sm-3"><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last 30 Days</div></h4><ol>';	
					
					// KEEPING TO SHOW THIS USED TO SUM(totamt) as totamt - REMOVED FOR SIMPLICITY IN phpcpr, and should not be needed anyway, since leaders are already tallied by amounts when they are placed in the leaderboard for the day!
					//$qry = "SELECT *, SUM(totamt) as totamt FROM leaderboard_earnings WHERE date='{$date30}' {$prog_master} GROUP BY Username ORDER BY totamt DESC LIMIT 15";

				$selectFields = '*';
				$mainTable = 'leaderboard_earnings';
				$where = [
					'date' => ['=', $date30],
					'program_id' => ['=', $program_id]
				];

				$groupBy = 'Username';
				$orderBy = 'totamt DESC';
				$limit = 15;
				$show_debug = 1;

				$result = select($selectFields, $mainTable, [], $where, $groupBy, null, $orderBy, $limit, $show_debug);
					
					foreach ($result as $downliners) {

						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
					}
					echo '</ol></div></span></div>';
} // END LAST 30 DAYS						

// 90 DAYS
if ($update == true) { // 90 DAYS

					// ADDED AND log.amount > 0 AS WITHDRAWALS CAUSED PEEPS TO GET KICKED OFF LEADERBOARD! 	
		$selectFields = 'memb.Username, memb.First_Name, memb.Last_Name, SUM(log.amount) as totamt';
		$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
		$joinConditions = [
			[
				'table' => 'members',
				'as' => 'memb',
				'condition' => 'log.usrid = memb.ID'
			]
		];
		$where = [
			'memb.ID' => ['NOT IN', $exclude_ids],
			'log.amount' => ['>', 0],
			'log.logdate' => ['>', $daysago90]
		];
		$where['log.description'] = ['LIKE', '%' . $GLOBALS['mat_config'] . '%'];
		$groupBy = 'log.usrid';
		$orderBy = ['totamt DESC', 'memb.ID ASC'];
		$limit = 15;
		$show_debug = 1;
		$topdownlines = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);					

					echo '<div class="col-xs-6 col-sm-3" ><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last 90 Days</div></h4><ol>';	
					foreach ($topdownlines as $downliners) {
						
						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
						
						if ($program_id != 0) {
							$table = 'leaderboard_earnings';
							$data = [
								'program_id' => $program_id,
								'Username' => $downliners['Username'],
								'First_Name' => $downliners['First_Name'],
								'Last_Name' => $downliners['Last_Name'],
								'totamt' => $downliners['totamt'],
								'date' => $date90
							];
							$live = 1; // Assuming you want to execute the query live
							$show_debug = $debug; // Assuming $debug is a boolean that controls debugging

							$result = insert($table, $data, $live, $show_debug);

							if ($show_debug) {
								echo debug_stmt($result);
							}

							// Additional code to handle $result
						}	
					}
					echo '</ol></div></span></div>';
} else { // UPDATE IS FALSE					
					echo '<div class="col-xs-6 col-sm-3"><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last 90 Days</div></h4><ol>';	
					
					// KEEPING TO SHOW THIS USED TO SUM(totamt) as totamt - REMOVED FOR SIMPLICITY IN phpcpr, and should not be needed anyway, since leaders are already tallied by amounts when they are placed in the leaderboard for the day!
					//$qry = "SELECT *, SUM(totamt) as totamt FROM leaderboard_earnings WHERE date='{$date30}' {$prog_master} GROUP BY Username ORDER BY totamt DESC LIMIT 15";

				$selectFields = '*';
				$mainTable = 'leaderboard_earnings';
				$where = [
					'date' => ['=', $date90],
					'program_id' => ['=', $program_id]
				];
				$groupBy = 'Username';
				$orderBy = 'totamt DESC';
				$limit = 15;
				$show_debug = 1;

				$result = select($selectFields, $mainTable, [], $where, $groupBy, null, $orderBy, $limit, $show_debug);
					
					foreach ($result as $downliners) {

						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
					}
					echo '</ol></div></span></div>';

} // END LAST 90 DAYS
?>
                <!-- Add the extra clearfix for only the required viewport -->
                <div class="clearfix visible-xs"></div>
<?php				

// LAST 6 MONTHS
if ($update == true) { // 180 DAYS

					// ADDED AND log.amount > 0 AS WITHDRAWALS CAUSED PEEPS TO GET KICKED OFF LEADERBOARD! 	
		$selectFields = 'memb.Username, memb.First_Name, memb.Last_Name, SUM(log.amount) as totamt';
		$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
		$joinConditions = [
			[
				'table' => 'members',
				'as' => 'memb',
				'condition' => 'log.usrid = memb.ID'
			]
		];
		$where = [
			'memb.ID' => ['NOT IN', $exclude_ids],
			'log.amount' => ['>', 0],
			'log.logdate' => ['>', $daysago180]
		];
		$where['log.description'] = ['LIKE', '%' . $GLOBALS['mat_config'] . '%'];
		$groupBy = 'log.usrid';
		$orderBy = ['totamt DESC', 'memb.ID ASC'];
		$limit = 15;
		$show_debug = 1;
		$topdownlines = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);					

					echo '<div class="col-xs-6 col-sm-3" ><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last 6 Months</div></h4><ol>';	
					foreach ($topdownlines as $downliners) {
						
						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
						
						if ($program_id != 0) {
							$table = 'leaderboard_earnings';
							$data = [
								'program_id' => $program_id,
								'Username' => $downliners['Username'],
								'First_Name' => $downliners['First_Name'],
								'Last_Name' => $downliners['Last_Name'],
								'totamt' => $downliners['totamt'],
								'date' => $date180
							];
							$live = 1; // Assuming you want to execute the query live
							$show_debug = $debug; // Assuming $debug is a boolean that controls debugging

							$result = insert($table, $data, $live, $show_debug);

							if ($show_debug) {
								echo debug_stmt($result);
							}

							// Additional code to handle $result
						}	
					}
					echo '</ol></div></span></div>';
} else { // UPDATE IS FALSE					
					echo '<div class="col-xs-6 col-sm-3"><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last 6 Months</div></h4><ol>';	
					
					// KEEPING TO SHOW THIS USED TO SUM(totamt) as totamt - REMOVED FOR SIMPLICITY IN phpcpr, and should not be needed anyway, since leaders are already tallied by amounts when they are placed in the leaderboard for the day!
					//$qry = "SELECT *, SUM(totamt) as totamt FROM leaderboard_earnings WHERE date='{$date30}' {$prog_master} GROUP BY Username ORDER BY totamt DESC LIMIT 15";

				$selectFields = '*';
				$mainTable = 'leaderboard_earnings';
				$where = [
					'date' => ['=', $date180],
					'program_id' => ['=', $program_id]
				];

				$groupBy = 'Username';
				$orderBy = 'totamt DESC';
				$limit = 15;
				$show_debug = 1;

				$result = select($selectFields, $mainTable, [], $where, $groupBy, null, $orderBy, $limit, $show_debug);
					
					foreach ($result as $downliners) {

						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
					}
					echo '</ol></div></span></div>';

} // END LAST 180 DAYS

// LAST YEAR
if ($update == true) { // 365 DAYS

		// ADDED AND log.amount > 0 AS WITHDRAWALS CAUSED PEEPS TO GET KICKED OFF LEADERBOARD! 	
		$selectFields = 'memb.Username, memb.First_Name, memb.Last_Name, SUM(log.amount) as totamt';
		$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
		$joinConditions = [
			[
				'table' => 'members',
				'as' => 'memb',
				'condition' => 'log.usrid = memb.ID'
			]
		];
		$where = [
			'memb.ID' => ['NOT IN', $exclude_ids],
			'log.amount' => ['>', 0],
			'log.logdate' => ['>', $daysago365]
		];
		$where['log.description'] = ['LIKE', '%' . $GLOBALS['mat_config'] . '%'];
		$groupBy = 'log.usrid';
		$orderBy = ['totamt DESC', 'memb.ID ASC'];
		$limit = 15;
		$show_debug = 1;
		$topdownlines = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);					

					echo '<div class="col-xs-6 col-sm-3" ><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last Year</div></h4><ol>';	
					foreach ($topdownlines as $downliners) {
						
						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
						
						if ($program_id != 0) {
							$table = 'leaderboard_earnings';
							$data = [
								'program_id' => $program_id,
								'Username' => $downliners['Username'],
								'First_Name' => $downliners['First_Name'],
								'Last_Name' => $downliners['Last_Name'],
								'totamt' => $downliners['totamt'],
								'date' => $date365
							];
							$live = 1; // Assuming you want to execute the query live
							$show_debug = $debug; // Assuming $debug is a boolean that controls debugging

							$result = insert($table, $data, $live, $show_debug);

							if ($show_debug) {
								echo debug_stmt($result);
							}

							// Additional code to handle $result
						}	
					}
					echo '</ol></div></span></div>';
} else { // UPDATE IS FALSE					
					echo '<div class="col-xs-6 col-sm-3"><span><div style="text-align:left; line-height:170%; padding: 20px; background-color:#f5f5f5"><h4><div style="margin-left: 23px; text-decoration:bold; color:#3784b1;">Last Year</div></h4><ol>';	
					
					// KEEPING TO SHOW THIS USED TO SUM(totamt) as totamt - REMOVED FOR SIMPLICITY IN phpcpr, and should not be needed anyway, since leaders are already tallied by amounts when they are placed in the leaderboard for the day!
					//$qry = "SELECT *, SUM(totamt) as totamt FROM leaderboard_earnings WHERE date='{$date30}' {$prog_master} GROUP BY Username ORDER BY totamt DESC LIMIT 15";

				$selectFields = '*';
				$mainTable = 'leaderboard_earnings';
				$where = [
					'date' => ['=', $date365],
					'program_id' => ['=', $program_id]
				];
				$groupBy = 'Username';
				$orderBy = 'totamt DESC';
				$limit = 15;
				$show_debug = 1;

				$result = select($selectFields, $mainTable, [], $where, $groupBy, null, $orderBy, $limit, $show_debug);
					
					foreach ($result as $downliners) {

						echo "<li>{$downliners['First_Name']} {$downliners['Last_Name']}&nbsp;";
						
						if ($_SESSION['admin_session_view'] == true) echo '<a href="../admin/Sub/Finduser.php?username='.$downliners['Username'].'&prog='.$program_id.'" target="_blank">'.$downliners['Username'] .'</a>&nbsp;$'. number_format($downliners['totamt'],0);
						
						echo "</li>";
					}
					echo '</ol></div></span></div>';
} // END LAST YEAR	




echo '</div></div>';


 
	
/*echo <<<EOD
<div class="row ">
<div class="col-md-6 col-sm-6" style="text-align:right;">
<form enctype="multipart/form-data" method="get" action="leaderboard_earnings.php">
<select name="program" class="form-control">{$program_info}</select>
</div>

<div class="col-md-6 col-sm-6" style="text-align:left;">
<input type="submit" value="View Top Earners By Program" name="submit" class="btn btn-info btn-default">
</form>
</div>
</div>
EOD;
*/

?>
<br><br>
*NOTE For Performance Reasons, Leaderboard Stats Are Updated Once Per Day.
<?php
include 'footer.php'; 
?>