<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php';
$pageName = ''; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-bullhorn'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES
$date = date("Y-m-d");

$use_campaigns = false;
//$use_campaigns = true;

//UPDATE  `ar_leads` SET rating =  'none' WHERE  `rating` =  'None'

if ($_POST == '' && $_GET['id'] == '' && $_GET['delete_followup'] != '') {
	header("Location: ./leads.php");
	exit;
}

$ID = $_SESSION['UserID'];
//SHOW ALL ERRORS
//error_reporting(-1);
//error_reporting = E_ALL;

$ID = sanitize($ID, 'ID'); // Sanitize the ID

$selectFields = ['Status'];
$mainTable = 'members';
$where = ['ID' => $ID];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = $result ? reset($result) : null;

//print_r($buffer);
//echo 'Status';
//echo $buffer['Status'];
//exit;
$loggedin_user_is_closer = false; // INITIALIZE VAR

//  DEFINE CLOSER ACCOUNTS
if (isset($buffer['Status']) && $buffer['Status'] == 'closer') {
    $loggedin_user_is_closer = true;
}

/*
if (!empty($_GET['dev']) || !empty($_SESSION['dev'])) {
	// DO NOTHING
	$_SESSION['dev'] = true;
} else {
	echo 'Locked for dev use';
	exit;
}
*/

include './header.php';

if ($_GET['id'] != '') {
	$md5 = $_GET['id']; 
} else if (isset($_POST['md5'])) {
	$md5 = $_POST['md5'];
}


//$md5 = sanitize($md5, 'md5'); // Sanitize $md5 using PHPCPR system

$lead_status = array(1=>'Enabled', 2=>'Blacklisted', 3=>'Unsubscribed', 4=>'Unconfirmed');

$selectFields = ['*']; // Assuming you want to select all fields
$mainTable = 'ar_leads';
$orderBy = 'ar_leads_id ASC';
$limit = 1;

if ($loggedin_user_is_closer == false) {
    $where = [
        'ID' => $ID,
        'ar_leads_md5' => $md5
    ];
} else if ($loggedin_user_is_closer == true) {
    $where = [
        'status' => 'closer',
        'closer_id' => $ID,
        'ar_leads_md5' => $md5
    ];
}

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$buffer = $result ? reset($result) : null;

//echo '<br/><br/>';
//print_r($buffer);

$ar_leads_id = $buffer['ar_leads_id'];

if ($buffer['ar_leads_id'] == '') {
	echo 'No record found!';
	include_once './footer.php';
	exit;
}	

$phone = '';
$phone = $buffer['ar_leads_phone'];

if ($phone == '') $phone = $buffer['cellphone'];

if (!empty($_REQUEST) && !empty($_REQUEST['leads_update'])) {
		
	/*
		CREATE TABLE ar_survey (
	  idx INTEGER(10) UNSIGNED NOT NULL AUTO_INCREMENT,
	  survey_name varchar(25) NOT NULL,
	  ar_leads_id INT(11) NOT NULL,
	  email VARCHAR(100) NOT NULL,  
	  first_name VARCHAR(100) NOT NULL,
	  last_name VARCHAR(100) NOT NULL,
	  phone VARCHAR(50) NOT NULL,
	  sponsor varchar(50) NOT NULL,
	  ip varchar(50) NOT NULL,
	  started_date DATETIME NULL,
	  completed_date DATETIME NULL,
	  last_page_completed VARCHAR(50) NOT NULL,
	  q1 VARCHAR(50) NOT NULL,
	  q2 VARCHAR(50) NOT NULL,
	  q3 VARCHAR(50) NOT NULL,
	  q4 VARCHAR(50) NOT NULL,
	  q5 VARCHAR(50) NOT NULL,
	  survey_score INT(10) NOT NULL DEFAULT 0,
	  analysis VARCHAR(50) NOT NULL,
	  converted_date DATETIME NULL,
	  PRIMARY KEY(idx));
	*/ 

	/*	echo '<pre>';
		print_r($_POST);
		echo '</pre>';
	*/	
		
	if ($_POST['new_rating'] == '') { 
		$_POST['new_rating'] = $_POST['rating'];
	} else if ($_POST['new_rating'] != '') {
		$_POST['rating'] = $_POST['new_rating'];
	}	
	

	// USED TO SHOW LEAD LAST EDITED ON leads.php
	$_SESSION['lead_last_edited'] = sanitize($ar_leads_id, 'ar_leads_id');

	// Preparing data for update in ar_leads
	$updateData = [];
	$columnsToUpdate = [
		'business_name', 'business_url', 'business_time', 'business_satisfaction', 
		'ar_leads_firstname', 'ar_leads_lastname', 'nickname', 'ar_leads_phone', 
		'cellphone', 'sms_preference', 'timezone', 'timetocall', 
		'preferred_contact_method', 'interest', 'found', 'rating', 'notes', 
		'followupdate', 'recurring_days', 'expire_date', 'painpoints', 
		'talkingpoints', 'edited'
	];

	foreach ($columnsToUpdate as $column) {
		if (isset($_POST[$column])) {
			//$updateData[$column] = sanitize($_POST[$column], $column);
			$updateData[$column] = $_POST[$column]; // POST IS ALREADY SANITIZED!
		}
	}

	// Debugging - Check if updateData has contents
	debug_stmt(print_r($updateData, true), 1);

	// Updating ar_leads table
	if (!empty($updateData)) {
		$where = ['ar_leads_id' => $ar_leads_id];
		$updateResult = update('ar_leads', $updateData, [], $where, 1, 1, 1);

		// Debugging - Check the result of the update operation
		debug_stmt(print_r($updateResult, true), 1);
	} else {
		debug_stmt('No data to update', 1);
	}


	// Additional code for the first conditional update
	if (isset($_POST['followedupdate']) && $_POST['followedupdate'] != '00-00-00 00:00:00' && $_POST['followedupdate'] != '') {
		// Prepare data for insert into ar_personal_followups
		$insertData = [];
		foreach ($_POST as $key => $value) {
			if (in_array($key, ['ar_leads_id', 'followedupdate', 'followed_up_method', 'engagement', 'new_rating', 'followupnotes'])) {
				$insertData[$key] = sanitize($value, $key);
			}
		}

		// Insert into ar_personal_followups table
		if (!empty($insertData)) {
			insert('ar_personal_followups', $insertData, 1, 1);
		}
	}
			
	if ($_SERVER['REQUEST_METHOD'] == 'POST' && ($buffer['followupdate'] != $_POST['followupdate'] || $buffer['recurring_days'] != $_POST['recurring_days'] || $buffer['expire_date'] != $_POST['expire_date'])) {
		
		// Prepare the data for updating
		$data = array('followup_emailsent' => 0);
		$where = array('ar_leads_id' => sanitize($ar_leads_id));
		
		// Call the update function from PHPCPR
		update('ar_leads', $data, [], $where, 1, 1, 1);  
		
	}
	
	echo '<h2>Update complete!</h2><br/>
	<a href="leads_edit.php?id='.$md5.'" class="btn btn-lg btn-info">Review Changes</a>
	<br/><br/><a href="leads.php" class="btn btn-lg btn-info">Return to Leads</a>';
	include_once './footer.php';
	exit;
	
} // END LEADS UPDATE!

if ($_GET['delete_followup'] != '') {
	
	$idx_del = ($_GET['delete_followup'] / 55555);
	//echo $idx_del;

	// Define the where conditions for deletion
	$where = array(
		'idx' => sanitize($idx_del),
		'ar_leads_id' => sanitize($ar_leads_id)
	);

	// Call the delete function from PHPCPR
	delete('ar_personal_followups', [], $where, 1, 1);

	echo '<h2>Update complete!</h2><br/>
	<a href="leads_edit.php?id='.$md5.'" class="btn btn-lg btn-info">Review Changes</a>
	<br/><br/><a href="leads.php" class="btn btn-lg btn-info">Return to Leads</a>';
	include_once './footer.php';
	exit;
	
}


// FIND OUT IF THE LEAD IS NOW A MEMBER
$selectFields = '*';
$mainTable = 'members';
$where = array('email' => sanitize($buffer['ar_leads_email']));

// Call the select function from PHPCPR for finding member status
$result = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
//$buffer = $result ? reset($result) : null;

if ($result) {
	$member_status = 'This lead is now a member. Great job!';
} else {
	$member_status = 'Not a member yet';
}

// FIND OUT THE REF SPONSOR INFO WHO REFERRED THE LEAD
$ref_ID = $buffer['ID'];
$where = array('ID' => sanitize($ref_ID));
$result = select('Username', $mainTable, [], $where, null, null, null, 1, 1);
$buffer_sp = $result ? reset($result) : null;

if ($buffer_sp['status'] == 'closer' && $loggedin_user_is_closer == false) {
	$hide_details = true;
	$buffer['ar_leads_firstname'] = 'Closer';
	$buffer['ar_leads_lastname'] = 'Lead'; 	
}

// IF POST IS EMPTY, SET POST TO BUFFER (DATABASE VALUES)!
if (empty($_POST) && empty($_POST['leads_update'])) $_POST = $buffer;
//print_r($_POST);


?>
<form action="leads_edit.php" method="POST">

<h2>Lead Details for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?></h2>

<?php if ($loggedin_user_is_closer == true) { ?>
<h4>Sign Up Link: <?php echo $Global['webpage_url'].'?id='.$buffer_sp['Username'];?>
</h4>
<?php } ?>

<div class="cover">
	<div class="text-left" id="slider_1">
	<h4><button type="button" class="btn btn-primary btn-lg" data-target="#personal, #biz, #contact, #notes, #followup, #followedup, #followedup_entries" data-toggle="collapse">
	<!--
	<sub><small><small>
	<div class="fs1 icon-ok icon-3x" aria-hidden="true"></div>
	</small></small></sub>
	-->
	>> Show All Options
	</button></h4>
	 </div>
</div>	
	  
<?php if ($hide_details == false) { ?>
			<div class="panel panel-primary panel-master">
				<a href="#personal" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs1 icon-user icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  Personal Info for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?></h4>
					</div>
				</a>
                <div id="personal" class="panel-body collapse">


<div class="col-md-4 text-left">
<div class="form-group">
<label for="Email">
Contact Email:</label>	
<?php 
if ($buffer['ar_leads_firstname'] != '') $string = "+".$buffer['ar_leads_firstname'];
if ($buffer['ar_leads_lastname'] != '') $string .= "+".$buffer['ar_leads_lastname'];
if ($buffer['ar_leads_phone'] != '') $string .= "+".$buffer['ar_leads_phone'];
?>

<a href="https://www.google.com/search?q=<?php echo $buffer['ar_leads_email'];?><?php echo $string;?>" target="_blank">Research Lead</a>

<input class="form-control" size="50%" name="ar_leads_email" placeholder="Email" title="Email" value="<?php echo ((!empty($_POST['ar_leads_email']))?$buffer['ar_leads_email']:'');?>" readonly>
</div></div>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="Opt-in Date">
Opt-in Date:</label>	<input class="form-control" size="50%" name="date" placeholder="Opt-in Date" title="Opt-in Date" value="<?php echo date('m/d/Y', strtotime($buffer['stdate']));?>" disabled><!-- QQQ ADD X Days Ago -->
</div></div>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="IP Adress">
IP Address:</label>	
<a href="https://whatismyipaddress.com/ip/<?php echo $buffer['ip'];?>" target="_blank">Research IP Address</a>
<input class="form-control" size="50%" name="ip" placeholder="IP Address" title="IP Address" value="<?php echo $buffer['ip'];?>" disabled>
</div></div>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="First Name">
First Name:</label>	<input class="form-control" size="50%" name="ar_leads_firstname" placeholder="First Name" title="First Name" value="<?php echo ((!empty($_POST['ar_leads_firstname']))?$buffer['ar_leads_firstname']:'');?>">
</div></div>
<div class="col-md-4 text-left">
<div class="form-group">
<label for="Last Name">
Last Name:</label>	<input class="form-control" size="50%" name="ar_leads_lastname" placeholder="Last Name" title="Last Name" value="<?php echo ((!empty($_POST['ar_leads_lastname']))?$buffer['ar_leads_lastname']:'');?>">
</div></div>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="Display Name">
Nickname:</label>&nbsp;&nbsp; (for your reference only)	<input class="form-control" size="50%" name="nickname" placeholder="Nickname" title="Nickname" value="<?php echo ((!empty($_POST['nickname']))?$buffer['nickname']:'');?>">
</div></div>

	<?php
	$phone = '';
	$phone = $buffer['ar_leads_phone'];
	$phone = preg_replace("/^1?(?:[- .])?(\d{3})(?:[- .])?(\d{3})(?:[- .])?(\d{4})$/", "($1) $2-$3", $phone);
	//echo $phone; 
	?>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="Phone">
Phone:</label>	<input class="form-control" size="50%" name="phone" placeholder="Phone" title="Phone" value="<?php echo ((!empty($_POST['ar_leads_phone']))?$phone:'');?>">
</div></div>

	<?php
	$cellphone = '';
	$cellphone = $buffer['cellphone'];
	$cellphone = preg_replace("/^1?(?:[- .])?(\d{3})(?:[- .])?(\d{3})(?:[- .])?(\d{4})$/", "($1) $2-$3", $cellphone);
	//echo $cellphone; 
	?>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="Cell Phone">
CellPhone:</label>	<input class="form-control" size="50%" name="cellphone" placeholder="Cell Phone" title="Cell Phone" value="<?php echo ((!empty($_POST['cellphone']))?$cellphone:'');?>">
</div></div>
<!--
<div class="col-md-4 text-left">
<div class="form-group">

<input type="checkbox" name="sms_check" title="SMS Opt-in" value="yes" <?php if (!empty($buffer['sms_alert'])) echo ' checked';?>> 
<small>
If checked, the lead has indicated he/she has opted-in to receive SMS Text Alerts to their cellphone number from <?php echo $Global['webpage_name']; ?> You may also turn this setting on / off at any time by checking or unchecking this box, and clicking the button "Update Lead Details", below.
</small>
</div></div>
-->
<div class="col-md-4 text-left">
<div class="form-group">
<label for="Preferred Contact">
SMS Text Alerts Preference:</label>
<br/>
<label class="btn btn-circle btn-sm btn-warning">
<input type="radio" name="sms_preference" value="yes" <?php if ($_POST['sms_preference'] == 'yes') echo" checked";?> disabled>
&nbsp;Yeah, HOT DOGGIE!
</label>
<label class="btn btn-circle btn-sm btn-success">
<input type="radio" name="sms_preference" value="no" <?php if ($_POST['sms_preference'] == 'no' || $_POST['sms_preference'] == '') echo" checked";?>>&nbsp;Nope	
</label>


<a href="#" data-toggle="modal" data-target="#sms_info" class="btn btn-circle btn-sm btn-info">&nbsp;Info</a>

</div></div>

</div>
</div>
<!-- END 1ST ROW -->

  <!-- Modal -->
  <div class="modal fade" id="sms_info" tabindex="-1" role="dialog" data-backdrop="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title"><i class="fa fa-send-o" style="color:lightgray"></i>&nbsp;&nbsp;SMS Text Alerts Preference</h4>
      </div>
      <div class="modal-body">  
		You may disable SMS Text Alerts upon request of the lead. Only the lead may enable SMS Text Alerts.
	
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- End Modal -->

			<div class="panel panel-primary panel-master">
				<a href="#contact" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs fa-send-o icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  Contact Info for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?></h4>
					</div>
				</a>
                <div id="contact" class="panel-body collapse">
<!--				
<div class="col-md-6 text-left">
<div class="form-group">
<label for="address">Address:</label>
<input class="form-control" size="50%" name="address" placeholder="Address" title="Address" value="<?php echo ((!empty($buffer['address']))?$buffer['address']:'');?>">

</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="city">
City:</label>
<input class="form-control" size="50%" name="city" placeholder="City" title="City" value="<?php echo ((!empty($buffer['city']))?$buffer['city']:'');?>">
</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="state">State:</label>
<input class="form-control" size="50%" name="state" placeholder="State" title="State" value="<?php echo ((!empty($buffer['state']))?$buffer['state']:'');?>">
</div></div>					

<div class="col-md-6 text-left">
<div class="form-group">
<label for="zip">Zip:</label>
<input class="form-control" size="50%" name="zip" placeholder="Zip" title="Zip" value="<?php echo ((!empty($buffer['zip']))?$buffer['zip']:'');?>">
</div></div>					
-->
				
<div class="col-md-6 text-left">
<div class="form-group">
<label for="Time Zone">
Time Zone:</label>	

<select name="timezone" class="form-control">
<option value="">Select</option>
<option value="Atlantic"  <?php if($buffer['timezone']=='Atlantic')echo"selected";?>>Atlantic</option>
<option value="Eastern" <?php if($buffer['timezone']=='Eastern')echo"selected";?>>Eastern</option>
<option value="Central" <?php if($buffer['timezone']=='Central')echo"selected";?>>Central</option>
<option value="Mountain" <?php if($buffer['timezone']=='Mountain')echo"selected";?>>Mountain</option>
<option value="Pacific" <?php if($buffer['timezone']=='Pacific')echo"selected";?>>Pacific</option>
<option value="Hawaii" <?php if($buffer['timezone']=='Hawaii')echo"selected";?>>Hawaii</option>
<option value="Alaska" <?php if($buffer['timezone']=='Alaska')echo"selected";?>>Alaska</option>
<option value="None" <?php if($buffer['timezone']=='None')echo"selected";?>>None of the Above</option>
</select>

</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Best Time to Call">
Best Time to Call:</label>
<select name="timetocall" class="form-control">
<option value="Morning" <?php if($_POST['timetocall']=='Morning')echo"selected";?>>Mornings (9am - 12pm)</option>
<option value="Afternoon" <?php if($_POST['timetocall']=='Afternoon')echo"selected";?>>Afternoons (12pm - 3pm)</option>
<option value="Evening" <?php if($_POST['timetocall']=='Evening')echo"selected";?>>Evenings (3pm - 6pm)</option>
<option value="Late Evening" <?php if($_POST['timetocall']=='Late Evening')echo"selected";?>>Late Evenings (6pm - 9pm)</option>
<option value="9am - 5pm" <?php if($_POST['timetocall']=='9am - 5pm')echo"selected";?>>Business Hours (9am - 5pm)</option>
</select>
</div></div>


<div class="col-md-6 text-left">
<div class="form-group">

<label for="Country">
Country:</label>

	<select class="form-control" onMouseover="this.focus()" name="country" >

		<option value="US" <?php if ($_POST['country'] == 'US') echo 'selected'; ?>>United States</option>
		<option value="AF" <?php if ($_POST['country'] == 'AF') echo 'selected'; ?>>Afghanistan</option>
		<option value="AX" <?php if ($_POST['country'] == 'AX') echo 'selected'; ?>>Aland Islands</option>
		<option value="AL" <?php if ($_POST['country'] == 'AL') echo 'selected'; ?>>Albania</option>
		<option value="DZ" <?php if ($_POST['country'] == 'DZ') echo 'selected'; ?>>Algeria</option>
		<option value="AS" <?php if ($_POST['country'] == 'AS') echo 'selected'; ?>>American Samoa</option>
		<option value="AD" <?php if ($_POST['country'] == 'AD') echo 'selected'; ?>>Andorra</option>
		<option value="AO" <?php if ($_POST['country'] == 'AO') echo 'selected'; ?>>Angola</option>
		<option value="AI" <?php if ($_POST['country'] == 'AI') echo 'selected'; ?>>Anguilla</option>
		<option value="AQ" <?php if ($_POST['country'] == 'AQ') echo 'selected'; ?>>Antarctica</option>
		<option value="AG" <?php if ($_POST['country'] == 'AG') echo 'selected'; ?>>Antigua and Barbuda</option>
		<option value="AR" <?php if ($_POST['country'] == 'AR') echo 'selected'; ?>>Argentina</option>
		<option value="AM" <?php if ($_POST['country'] == 'AM') echo 'selected'; ?>>Armenia</option>
		<option value="AW" <?php if ($_POST['country'] == 'AW') echo 'selected'; ?>>Aruba</option>
		<option value="AU" <?php if ($_POST['country'] == 'AU') echo 'selected'; ?>>Australia</option>
		<option value="AT" <?php if ($_POST['country'] == 'AT') echo 'selected'; ?>>Austria</option>
		<option value="AZ" <?php if ($_POST['country'] == 'AZ') echo 'selected'; ?>>Azerbaijan</option>
		<option value="BS" <?php if ($_POST['country'] == 'BS') echo 'selected'; ?>>Bahamas</option>
		<option value="BH" <?php if ($_POST['country'] == 'BH') echo 'selected'; ?>>Bahrain</option>
		<option value="BD" <?php if ($_POST['country'] == 'BD') echo 'selected'; ?>>Bangladesh</option>
		<option value="BB" <?php if ($_POST['country'] == 'BB') echo 'selected'; ?>>Barbados</option>
		<option value="BY" <?php if ($_POST['country'] == 'BY') echo 'selected'; ?>>Belarus</option>
		<option value="BE" <?php if ($_POST['country'] == 'BE') echo 'selected'; ?>>Belgium</option>
		<option value="BZ" <?php if ($_POST['country'] == 'BZ') echo 'selected'; ?>>Belize</option>
		<option value="BJ" <?php if ($_POST['country'] == 'BJ') echo 'selected'; ?>>Benin</option>
		<option value="BM" <?php if ($_POST['country'] == 'BM') echo 'selected'; ?>>Bermuda</option>
		<option value="BT" <?php if ($_POST['country'] == 'BT') echo 'selected'; ?>>Bhutan</option>
		<option value="BO" <?php if ($_POST['country'] == 'BO') echo 'selected'; ?>>Bolivia</option>
		<option value="BA" <?php if ($_POST['country'] == 'BA') echo 'selected'; ?>>Bosnia and Herzegovina</option>
		<option value="BW" <?php if ($_POST['country'] == 'BW') echo 'selected'; ?>>Botswana</option>
		<option value="BV" <?php if ($_POST['country'] == 'BV') echo 'selected'; ?>>Bouvet Island</option>
		<option value="BR" <?php if ($_POST['country'] == 'BR') echo 'selected'; ?>>Brazil</option>
		<option value="IO" <?php if ($_POST['country'] == 'IO') echo 'selected'; ?>>British Indian Ocean Territory</option>
		<option value="BN" <?php if ($_POST['country'] == 'BN') echo 'selected'; ?>>Brunei Darussalam</option>
		<option value="BG" <?php if ($_POST['country'] == 'BG') echo 'selected'; ?>>Bulgaria</option>
		<option value="BF" <?php if ($_POST['country'] == 'BF') echo 'selected'; ?>>Burkina Faso</option>
		<option value="BI" <?php if ($_POST['country'] == 'BI') echo 'selected'; ?>>Burundi</option>
		<option value="KH" <?php if ($_POST['country'] == 'KH') echo 'selected'; ?>>Cambodia</option>
		<option value="CM" <?php if ($_POST['country'] == 'CM') echo 'selected'; ?>>Cameroon</option>
		<option value="CA" <?php if ($_POST['country'] == 'CA') echo 'selected'; ?>>Canada</option>
		<option value="CV" <?php if ($_POST['country'] == 'CV') echo 'selected'; ?>>Cape Verde</option>
		<option value="KY" <?php if ($_POST['country'] == 'KY') echo 'selected'; ?>>Cayman Islands</option>
		<option value="CF" <?php if ($_POST['country'] == 'CF') echo 'selected'; ?>>Central African Republic</option>
		<option value="TD" <?php if ($_POST['country'] == 'TD') echo 'selected'; ?>>Chad</option>
		<option value="CL" <?php if ($_POST['country'] == 'CL') echo 'selected'; ?>>Chile</option>
		<option value="CN" <?php if ($_POST['country'] == 'CN') echo 'selected'; ?>>China</option>
		<option value="CX" <?php if ($_POST['country'] == 'CX') echo 'selected'; ?>>Christmas Island</option>
		<option value="CC" <?php if ($_POST['country'] == 'CC') echo 'selected'; ?>>Cocos (Keeling) Islands</option>
		<option value="CO" <?php if ($_POST['country'] == 'CO') echo 'selected'; ?>>Colombia</option>
		<option value="KM" <?php if ($_POST['country'] == 'KM') echo 'selected'; ?>>Comoros</option>
		<option value="CG" <?php if ($_POST['country'] == 'CG') echo 'selected'; ?>>Congo</option>
		<option value="CD" <?php if ($_POST['country'] == 'CD') echo 'selected'; ?>>Congo, The Democratic Republic of The</option>
		<option value="CK" <?php if ($_POST['country'] == 'CK') echo 'selected'; ?>>Cook Islands</option>
		<option value="CR" <?php if ($_POST['country'] == 'CR') echo 'selected'; ?>>Costa Rica</option>
		<option value="CI" <?php if ($_POST['country'] == 'CT') echo 'selected'; ?>>Cote D'ivoire</option>
		<option value="HR" <?php if ($_POST['country'] == 'HR') echo 'selected'; ?>>Croatia</option>
		<option value="CU" <?php if ($_POST['country'] == 'CU') echo 'selected'; ?>>Cuba</option>
		<option value="CY" <?php if ($_POST['country'] == 'CY') echo 'selected'; ?>>Cyprus</option>
		<option value="CZ" <?php if ($_POST['country'] == 'CE') echo 'selected'; ?>>Czech Republic</option>
		<option value="DK" <?php if ($_POST['country'] == 'DK') echo 'selected'; ?>>Denmark</option>
		<option value="DJ" <?php if ($_POST['country'] == 'DJ') echo 'selected'; ?>>Djibouti</option>
		<option value="DM" <?php if ($_POST['country'] == 'DM') echo 'selected'; ?>>Dominica</option>
		<option value="DO" <?php if ($_POST['country'] == 'DO') echo 'selected'; ?>>Dominican Republic</option>
		<option value="EC" <?php if ($_POST['country'] == 'EC') echo 'selected'; ?>>Ecuador</option>
		<option value="EG" <?php if ($_POST['country'] == 'EG') echo 'selected'; ?>>Egypt</option>
		<option value="SV" <?php if ($_POST['country'] == 'SV') echo 'selected'; ?>>El Salvador</option>
		<option value="GQ" <?php if ($_POST['country'] == 'GQ') echo 'selected'; ?>>Equatorial Guinea</option>
		<option value="ER" <?php if ($_POST['country'] == 'ER') echo 'selected'; ?>>Eritrea</option>
		<option value="EE" <?php if ($_POST['country'] == 'EE') echo 'selected'; ?>>Estonia</option>
		<option value="ET" <?php if ($_POST['country'] == 'ET') echo 'selected'; ?>>Ethiopia</option>
		<option value="FK" <?php if ($_POST['country'] == 'FK') echo 'selected'; ?>>Falkland Islands (Malvinas)</option>
		<option value="FO" <?php if ($_POST['country'] == 'FO') echo 'selected'; ?>>Faroe Islands</option>
		<option value="FJ" <?php if ($_POST['country'] == 'FJ') echo 'selected'; ?>>Fiji</option>
		<option value="FI" <?php if ($_POST['country'] == 'FI') echo 'selected'; ?>>Finland</option>
		<option value="FR" <?php if ($_POST['country'] == 'FR') echo 'selected'; ?>>France</option>
		<option value="GF" <?php if ($_POST['country'] == 'GF') echo 'selected'; ?>>French Guiana</option>
		<option value="PF" <?php if ($_POST['country'] == 'PF') echo 'selected'; ?>>French Polynesia</option>
		<option value="TF" <?php if ($_POST['country'] == 'TF') echo 'selected'; ?>>French Southern Territories</option>
		<option value="GA" <?php if ($_POST['country'] == 'GA') echo 'selected'; ?>>Gabon</option>
		<option value="GM" <?php if ($_POST['country'] == 'GM') echo 'selected'; ?>>Gambia</option>
		<option value="GE" <?php if ($_POST['country'] == 'GE') echo 'selected'; ?>>Georgia</option>
		<option value="DE" <?php if ($_POST['country'] == 'DE') echo 'selected'; ?>>Germany</option>
		<option value="GH" <?php if ($_POST['country'] == 'GH') echo 'selected'; ?>>Ghana</option>
		<option value="GI" <?php if ($_POST['country'] == 'GI') echo 'selected'; ?>>Gibraltar</option>
		<option value="GR" <?php if ($_POST['country'] == 'GR') echo 'selected'; ?>>Greece</option>
		<option value="GL" <?php if ($_POST['country'] == 'GL') echo 'selected'; ?>>Greenland</option>
		<option value="GD" <?php if ($_POST['country'] == 'GD') echo 'selected'; ?>>Grenada</option>
		<option value="GP" <?php if ($_POST['country'] == 'GP') echo 'selected'; ?>>Guadeloupe</option>
		<option value="GU" <?php if ($_POST['country'] == 'GU') echo 'selected'; ?>>Guam</option>
		<option value="GT" <?php if ($_POST['country'] == 'GT') echo 'selected'; ?>>Guatemala</option>
		<option value="GG" <?php if ($_POST['country'] == 'GG') echo 'selected'; ?>>Guernsey</option>
		<option value="GN" <?php if ($_POST['country'] == 'GN') echo 'selected'; ?>>Guinea</option>
		<option value="GW" <?php if ($_POST['country'] == 'GW') echo 'selected'; ?>>Guinea-bissau</option>
		<option value="GY" <?php if ($_POST['country'] == 'GY') echo 'selected'; ?>>Guyana</option>
		<option value="HT" <?php if ($_POST['country'] == 'HT') echo 'selected'; ?>>Haiti</option>
		<option value="HM" <?php if ($_POST['country'] == 'HM') echo 'selected'; ?>>Heard Island and Mcdonald Islands</option>
		<option value="VA" <?php if ($_POST['country'] == 'VA') echo 'selected'; ?>>Holy See (Vatican City State)</option>
		<option value="HN" <?php if ($_POST['country'] == 'HN') echo 'selected'; ?>>Honduras</option>
		<option value="HK" <?php if ($_POST['country'] == 'HK') echo 'selected'; ?>>Hong Kong</option>
		<option value="HU" <?php if ($_POST['country'] == 'HU') echo 'selected'; ?>>Hungary</option>
		<option value="IS" <?php if ($_POST['country'] == 'IS') echo 'selected'; ?>>Iceland</option>
		<option value="IN" <?php if ($_POST['country'] == 'IN') echo 'selected'; ?>>India</option>
		<option value="ID" <?php if ($_POST['country'] == 'ID') echo 'selected'; ?>>Indonesia</option>
		<option value="IR" <?php if ($_POST['country'] == 'IR') echo 'selected'; ?>>Iran, Islamic Republic of</option>
		<option value="IQ" <?php if ($_POST['country'] == 'IQ') echo 'selected'; ?>>Iraq</option>
		<option value="IE" <?php if ($_POST['country'] == 'IE') echo 'selected'; ?>>Ireland</option>
		<option value="IM" <?php if ($_POST['country'] == 'IM') echo 'selected'; ?>>Isle of Man</option>
		<option value="IL" <?php if ($_POST['country'] == 'IL') echo 'selected'; ?>>Israel</option>
		<option value="IT" <?php if ($_POST['country'] == 'IT') echo 'selected'; ?>>Italy</option>
		<option value="JM" <?php if ($_POST['country'] == 'JM') echo 'selected'; ?>>Jamaica</option>
		<option value="JP" <?php if ($_POST['country'] == 'JP') echo 'selected'; ?>>Japan</option>
		<option value="JE" <?php if ($_POST['country'] == 'JE') echo 'selected'; ?>>Jersey</option>
		<option value="JO" <?php if ($_POST['country'] == 'JO') echo 'selected'; ?>>Jordan</option>
		<option value="KZ" <?php if ($_POST['country'] == 'KZ') echo 'selected'; ?>>Kazakhstan</option>
		<option value="KE" <?php if ($_POST['country'] == 'KE') echo 'selected'; ?>>Kenya</option>
		<option value="KI" <?php if ($_POST['country'] == 'KI') echo 'selected'; ?>>Kiribati</option>
		<option value="KP" <?php if ($_POST['country'] == 'KP') echo 'selected'; ?>>Korea, Democratic People's Republic of</option>
		<option value="KR" <?php if ($_POST['country'] == 'KR') echo 'selected'; ?>>Korea, Republic of</option>
		<option value="KW" <?php if ($_POST['country'] == 'KW') echo 'selected'; ?>>Kuwait</option>
		<option value="KG" <?php if ($_POST['country'] == 'KG') echo 'selected'; ?>>Kyrgyzstan</option>
		<option value="LA" <?php if ($_POST['country'] == 'LA') echo 'selected'; ?>>Lao People's Democratic Republic</option>
		<option value="LV" <?php if ($_POST['country'] == 'LV') echo 'selected'; ?>>Latvia</option>
		<option value="LB" <?php if ($_POST['country'] == 'LB') echo 'selected'; ?>>Lebanon</option>
		<option value="LS" <?php if ($_POST['country'] == 'LS') echo 'selected'; ?>>Lesotho</option>
		<option value="LR" <?php if ($_POST['country'] == 'LR') echo 'selected'; ?>>Liberia</option>
		<option value="LY" <?php if ($_POST['country'] == 'LY') echo 'selected'; ?>>Libyan Arab Jamahiriya</option>
		<option value="LI" <?php if ($_POST['country'] == 'LI') echo 'selected'; ?>>Liechtenstein</option>
		<option value="LT" <?php if ($_POST['country'] == 'LT') echo 'selected'; ?>>Lithuania</option>
		<option value="LU" <?php if ($_POST['country'] == 'LU') echo 'selected'; ?>>Luxembourg</option>
		<option value="MO" <?php if ($_POST['country'] == 'MO') echo 'selected'; ?>>Macao</option>
		<option value="MK" <?php if ($_POST['country'] == 'MK') echo 'selected'; ?>>Macedonia, The Former Yugoslav Republic of</option>
		<option value="MG" <?php if ($_POST['country'] == 'MG') echo 'selected'; ?>>Madagascar</option>
		<option value="MW" <?php if ($_POST['country'] == 'MW') echo 'selected'; ?>>Malawi</option>
		<option value="MY" <?php if ($_POST['country'] == 'MY') echo 'selected'; ?>>Malaysia</option>
		<option value="MV" <?php if ($_POST['country'] == 'MV') echo 'selected'; ?>>Maldives</option>
		<option value="ML" <?php if ($_POST['country'] == 'ML') echo 'selected'; ?>>Mali</option>
		<option value="MT" <?php if ($_POST['country'] == 'MT') echo 'selected'; ?>>Malta</option>
		<option value="MH" <?php if ($_POST['country'] == 'MH') echo 'selected'; ?>>Marshall Islands</option>
		<option value="MQ" <?php if ($_POST['country'] == 'MQ') echo 'selected'; ?>>Martinique</option>
		<option value="MR" <?php if ($_POST['country'] == 'MR') echo 'selected'; ?>>Mauritania</option>
		<option value="MU" <?php if ($_POST['country'] == 'MU') echo 'selected'; ?>>Mauritius</option>
		<option value="YT" <?php if ($_POST['country'] == 'YT') echo 'selected'; ?>>Mayotte</option>
		<option value="MX" <?php if ($_POST['country'] == 'MX') echo 'selected'; ?>>Mexico</option>
		<option value="FM" <?php if ($_POST['country'] == 'FM') echo 'selected'; ?>>Micronesia, Federated States of</option>
		<option value="MD" <?php if ($_POST['country'] == 'MD') echo 'selected'; ?>>Moldova, Republic of</option>
		<option value="MC" <?php if ($_POST['country'] == 'MC') echo 'selected'; ?>>Monaco</option>
		<option value="MN" <?php if ($_POST['country'] == 'MN') echo 'selected'; ?>>Mongolia</option>
		<option value="ME" <?php if ($_POST['country'] == 'ME') echo 'selected'; ?>>Montenegro</option>
		<option value="MS" <?php if ($_POST['country'] == 'MS') echo 'selected'; ?>>Montserrat</option>
		<option value="MA" <?php if ($_POST['country'] == 'MA') echo 'selected'; ?>>Morocco</option>
		<option value="MZ" <?php if ($_POST['country'] == 'MZ') echo 'selected'; ?>>Mozambique</option>
		<option value="MM" <?php if ($_POST['country'] == 'MM') echo 'selected'; ?>>Myanmar</option>
		<option value="NA" <?php if ($_POST['country'] == 'NA') echo 'selected'; ?>>Namibia</option>
		<option value="NR" <?php if ($_POST['country'] == 'NR') echo 'selected'; ?>>Nauru</option>
		<option value="NP" <?php if ($_POST['country'] == 'NP') echo 'selected'; ?>>Nepal</option>
		<option value="NL" <?php if ($_POST['country'] == 'NL') echo 'selected'; ?>>Netherlands</option>
		<option value="AN" <?php if ($_POST['country'] == 'AN') echo 'selected'; ?>>Netherlands Antilles</option>
		<option value="NC" <?php if ($_POST['country'] == 'NC') echo 'selected'; ?>>New Caledonia</option>
		<option value="NZ" <?php if ($_POST['country'] == 'NZ') echo 'selected'; ?>>New Zealand</option>
		<option value="NI" <?php if ($_POST['country'] == 'NI') echo 'selected'; ?>>Nicaragua</option>
		<option value="NE" <?php if ($_POST['country'] == 'NE') echo 'selected'; ?>>Niger</option>
		<option value="NG" <?php if ($_POST['country'] == 'NG') echo 'selected'; ?>>Nigeria</option>
		<option value="NU" <?php if ($_POST['country'] == 'NU') echo 'selected'; ?>>Niue</option>
		<option value="NF" <?php if ($_POST['country'] == 'NF') echo 'selected'; ?>>Norfolk Island</option>
		<option value="MP" <?php if ($_POST['country'] == 'MP') echo 'selected'; ?>>Northern Mariana Islands</option>
		<option value="NO" <?php if ($_POST['country'] == 'NO') echo 'selected'; ?>>Norway</option>
		<option value="OM" <?php if ($_POST['country'] == 'OM') echo 'selected'; ?>>Oman</option>
		<option value="PK" <?php if ($_POST['country'] == 'PK') echo 'selected'; ?>>Pakistan</option>
		<option value="PW" <?php if ($_POST['country'] == 'PW') echo 'selected'; ?>>Palau</option>
		<option value="PS" <?php if ($_POST['country'] == 'PS') echo 'selected'; ?>>Palestinian Territory, Occupied</option>
		<option value="PA" <?php if ($_POST['country'] == 'PA') echo 'selected'; ?>>Panama</option>
		<option value="PG" <?php if ($_POST['country'] == 'PG') echo 'selected'; ?>>Papua New Guinea</option>
		<option value="PY" <?php if ($_POST['country'] == 'PY') echo 'selected'; ?>>Paraguay</option>
		<option value="PE" <?php if ($_POST['country'] == 'PE') echo 'selected'; ?>>Peru</option>
		<option value="PH" <?php if ($_POST['country'] == 'PH') echo 'selected'; ?>>Philippines</option>
		<option value="PN" <?php if ($_POST['country'] == 'PN') echo 'selected'; ?>>Pitcairn</option>
		<option value="PL" <?php if ($_POST['country'] == 'PL') echo 'selected'; ?>>Poland</option>
		<option value="PT" <?php if ($_POST['country'] == 'PT') echo 'selected'; ?>>Portugal</option>
		<option value="PR" <?php if ($_POST['country'] == 'PR') echo 'selected'; ?>>Puerto Rico</option>
		<option value="QA" <?php if ($_POST['country'] == 'QA') echo 'selected'; ?>>Qatar</option>
		<option value="RE" <?php if ($_POST['country'] == 'RE') echo 'selected'; ?>>Reunion</option>
		<option value="RO" <?php if ($_POST['country'] == 'RO') echo 'selected'; ?>>Romania</option>
		<option value="RU" <?php if ($_POST['country'] == 'RU') echo 'selected'; ?>>Russian Federation</option>
		<option value="RW" <?php if ($_POST['country'] == 'RW') echo 'selected'; ?>>Rwanda</option>
		<option value="SH" <?php if ($_POST['country'] == 'SH') echo 'selected'; ?>>Saint Helena</option>
		<option value="KN" <?php if ($_POST['country'] == 'KN') echo 'selected'; ?>>Saint Kitts and Nevis</option>
		<option value="LC" <?php if ($_POST['country'] == 'LC') echo 'selected'; ?>>Saint Lucia</option>
		<option value="PM" <?php if ($_POST['country'] == 'PM') echo 'selected'; ?>>Saint Pierre and Miquelon</option>
		<option value="VC" <?php if ($_POST['country'] == 'VC') echo 'selected'; ?>>Saint Vincent and The Grenadines</option>
		<option value="WS" <?php if ($_POST['country'] == 'WS') echo 'selected'; ?>>Samoa</option>
		<option value="SM" <?php if ($_POST['country'] == 'SM') echo 'selected'; ?>>San Marino</option>
		<option value="ST" <?php if ($_POST['country'] == 'ST') echo 'selected'; ?>>Sao Tome and Principe</option>
		<option value="SA" <?php if ($_POST['country'] == 'SA') echo 'selected'; ?>>Saudi Arabia</option>
		<option value="SN" <?php if ($_POST['country'] == 'SN') echo 'selected'; ?>>Senegal</option>
		<option value="RS" <?php if ($_POST['country'] == 'RS') echo 'selected'; ?>>Serbia</option>
		<option value="SC" <?php if ($_POST['country'] == 'SC') echo 'selected'; ?>>Seychelles</option>
		<option value="SL" <?php if ($_POST['country'] == 'SL') echo 'selected'; ?>>Sierra Leone</option>
		<option value="SG" <?php if ($_POST['country'] == 'SG') echo 'selected'; ?>>Singapore</option>
		<option value="SK" <?php if ($_POST['country'] == 'SK') echo 'selected'; ?>>Slovakia</option>
		<option value="SI" <?php if ($_POST['country'] == 'SI') echo 'selected'; ?>>Slovenia</option>
		<option value="SB" <?php if ($_POST['country'] == 'SB') echo 'selected'; ?>>Solomon Islands</option>
		<option value="SO" <?php if ($_POST['country'] == 'SO') echo 'selected'; ?>>Somalia</option>
		<option value="ZA" <?php if ($_POST['country'] == 'ZA') echo 'selected'; ?>>South Africa</option>
		<option value="GS" <?php if ($_POST['country'] == 'GS') echo 'selected'; ?>>South Georgia and The South Sandwich Islands</option>
		<option value="ES" <?php if ($_POST['country'] == 'ES') echo 'selected'; ?>>Spain</option>
		<option value="LK" <?php if ($_POST['country'] == 'LK') echo 'selected'; ?>>Sri Lanka</option>
		<option value="SD" <?php if ($_POST['country'] == 'SD') echo 'selected'; ?>>Sudan</option>
		<option value="SR" <?php if ($_POST['country'] == 'SR') echo 'selected'; ?>>Suriname</option>
		<option value="SJ" <?php if ($_POST['country'] == 'SJ') echo 'selected'; ?>>Svalbard and Jan Mayen</option>
		<option value="SZ" <?php if ($_POST['country'] == 'SZ') echo 'selected'; ?>>Swaziland</option>
		<option value="SE" <?php if ($_POST['country'] == 'SE') echo 'selected'; ?>>Sweden</option>
		<option value="CH" <?php if ($_POST['country'] == 'CH') echo 'selected'; ?>>Switzerland</option>
		<option value="SY" <?php if ($_POST['country'] == 'SY') echo 'selected'; ?>>Syrian Arab Republic</option>
		<option value="TW" <?php if ($_POST['country'] == 'TW') echo 'selected'; ?>>Taiwan, Province of China</option>
		<option value="TJ" <?php if ($_POST['country'] == 'TJ') echo 'selected'; ?>>Tajikistan</option>
		<option value="TZ" <?php if ($_POST['country'] == 'TZ') echo 'selected'; ?>>Tanzania, United Republic of</option>
		<option value="TH" <?php if ($_POST['country'] == 'TH') echo 'selected'; ?>>Thailand</option>
		<option value="TL" <?php if ($_POST['country'] == 'TL') echo 'selected'; ?>>Timor-leste</option>
		<option value="TG" <?php if ($_POST['country'] == 'TG') echo 'selected'; ?>>Togo</option>
		<option value="TK" <?php if ($_POST['country'] == 'TK') echo 'selected'; ?>>Tokelau</option>
		<option value="TO" <?php if ($_POST['country'] == 'TO') echo 'selected'; ?>>Tonga</option>
		<option value="TT" <?php if ($_POST['country'] == 'TT') echo 'selected'; ?>>Trinidad and Tobago</option>
		<option value="TN" <?php if ($_POST['country'] == 'TN') echo 'selected'; ?>>Tunisia</option>
		<option value="TR" <?php if ($_POST['country'] == 'TR') echo 'selected'; ?>>Turkey</option>
		<option value="TM" <?php if ($_POST['country'] == 'TM') echo 'selected'; ?>>Turkmenistan</option>
		<option value="TC" <?php if ($_POST['country'] == 'TC') echo 'selected'; ?>>Turks and Caicos Islands</option>
		<option value="TV" <?php if ($_POST['country'] == 'TV') echo 'selected'; ?>>Tuvalu</option>
		<option value="UG" <?php if ($_POST['country'] == 'UG') echo 'selected'; ?>>Uganda</option>
		<option value="UA" <?php if ($_POST['country'] == 'UA') echo 'selected'; ?>>Ukraine</option>
		<option value="AE" <?php if ($_POST['country'] == 'AE') echo 'selected'; ?>>United Arab Emirates</option>
		<option value="GB" <?php if ($_POST['country'] == 'GB') echo 'selected'; ?>>United Kingdom</option>
		<option value="US" <?php if ($_POST['country'] == 'US') echo 'selected'; ?>>United States</option>
		<option value="UM" <?php if ($_POST['country'] == 'UM') echo 'selected'; ?>>United States Minor Outlying Islands</option>
		<option value="UY" <?php if ($_POST['country'] == 'UY') echo 'selected'; ?>>Uruguay</option>
		<option value="UZ" <?php if ($_POST['country'] == 'UZ') echo 'selected'; ?>>Uzbekistan</option>
		<option value="VU" <?php if ($_POST['country'] == 'VU') echo 'selected'; ?>>Vanuatu</option>
		<option value="VE" <?php if ($_POST['country'] == 'VE') echo 'selected'; ?>>Venezuela</option>
		<option value="VN" <?php if ($_POST['country'] == 'VN') echo 'selected'; ?>>Viet Nam</option>
		<option value="VG" <?php if ($_POST['country'] == 'VG') echo 'selected'; ?>>Virgin Islands, British</option>
		<option value="VI" <?php if ($_POST['country'] == 'VI') echo 'selected'; ?>>Virgin Islands, U.S.</option>
		<option value="WF" <?php if ($_POST['country'] == 'WF') echo 'selected'; ?>>Wallis and Futuna</option>
		<option value="EH" <?php if ($_POST['country'] == 'EH') echo 'selected'; ?>>Western Sahara</option>
		<option value="YE" <?php if ($_POST['country'] == 'YE') echo 'selected'; ?>>Yemen</option>
		<option value="ZM" <?php if ($_POST['country'] == 'ZM') echo 'selected'; ?>>Zambia</option>
		<option value="ZW" <?php if ($_POST['country'] == 'ZW') echo 'selected'; ?>>Zimbabwe</option>
		</select>
</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Level of Interest">
Level of Interest (Given By Lead):</label>	
<select name="interest" class="form-control">  <option value="Casual Question" <?php if($buffer['interest']=='Casual Question')echo"selected";?>>Casual Question</option>  <option value="Considering" <?php if($buffer['interest']=='Considering')echo"selected";?>>Considering</option>  <option  value="Seriously Interested" <?php if($_POST['interest']=='Seriously Interested')echo"selected";?>>Seriously Interested</option>
</select>
</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Preferred Contact">
Preferred Contact:</label>
<br/>
<?php if ($buffer['preferred_contact_method'] == '' && $buffer['ar_leads_phone'] == '') $buffer['preferred_contact_method'] = 'Email'; 
if ($buffer['preferred_contact_method'] == '' && $buffer['ar_leads_phone'] != '') $buffer['preferred_contact_method'] = 'Phone'; 
?>
<label class="btn btn-default btn-circle btn-sm btn-warning">
<input type="radio" name="preferred_contact_method" value="Email" <?php if ($buffer['preferred_contact_method']=='Email') echo "checked";?>>
&nbsp;Email
</label>
<label class="btn btn-default btn-circle btn-sm btn-success">
<input type="radio" name="preferred_contact_method" value="Phone" <?php if ($buffer['preferred_contact_method']=='Phone') echo "checked";?>>&nbsp;Phone	
</label>
<b>

	<i class="fa fa-arrow-right" aria-hidden="true"></i>

<?php if ($buffer['preferred_contact_method']=='Phone') { ?> 
<a href="tel:+1-<?php echo $buffer['ar_leads_phone']; ?>"><?php echo $phone; ?></a>

<?php } else if ($buffer['preferred_contact_method']=='Email') {
	echo '<a href="mailto:'.$buffer['email'].'?subject='.$Global['webpage_name'].'%20Follow%20Up%20For%20'.$buffer['ar_leads_firstname'].'&body=Hey%20'.$buffer['ar_leads_firstname'].',%0D%0A%0D%0A

Have you taken the time to really check out the '.$Global['webpage_name'].' program?%0D%0A%0D%0A

Let me show you how to work this amazing business. Explore, and sign up now: '.$Global['webpage_url'].'?id='.$buffer_sp['Username'].'%0D%0A%0D%0A

Take action now and make a change!%0D%0A%0D%0A
  
Sincerely,
%0D%0A'.$_SESSION['Firstname_loggedin'].'%0D%0A'.$_SESSION['Phone_loggedin'].'">'; ?>
<?php echo $buffer['ar_leads_email']; ?>
</a>
<?php } ?>
</b>
</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Lead Rating">
Lead Rating:</label><br/>	

<label class="btn btn-default btn-circle btn-sm btn-default">
<input type="radio" name="rating" value="none" <?php if ($buffer['rating']=='' || $buffer['rating']=='none') echo "checked";?>>&nbsp;None	
</label>
<label class="btn btn-default btn-circle btn-sm" style="background-color:lightgray">
<input type="radio" name="rating" value="done" <?php if ($buffer['rating']=='done') echo "checked";?>>&nbsp;Done	
</label>

<label class="btn btn-default btn-circle btn-sm btn-info">
<input type="radio" name="rating" value="cold" <?php if ($buffer['rating']=='cold') echo "checked";?>>
&nbsp;Cold
</label>
<label class="btn btn-default btn-circle btn-sm btn-warning">
<input type="radio" name="rating" value="warm" <?php if($buffer['rating']=='warm') echo "checked";?>>&nbsp;Warm
</label>
<label class="btn btn-default btn-circle btn-sm btn-danger">
<input type="radio" name="rating" value="hot" <?php if ($buffer['rating']=='hot') echo "checked";?>>
&nbsp;Hot
</label>
<label class="btn btn-default btn-circle btn-sm btn-success">
<input type="radio" name="rating" value="closed" <?php if ($buffer['rating']=='closed') echo "checked";?>>
&nbsp;Closed
</label>

</div></div>
<?php if ($use_campaigns == true) { ?>
<div class="col-md-6 text-left">
<div class="form-group">
<label for="Campaign Link">
Campaign Link:</label>	<input class="form-control" size="50%" name="clink" placeholder="" title="" value="<?php echo ((!empty($buffer['']))?$buffer['']:'');?>">
</div></div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Campaign Stats">
Campaign Stats:</label>	<input class="form-control" size="50%" name="cstats" placeholder="" title="" value="<?php echo ((!empty($buffer['']))?$buffer['']:'');?>">
</div></div>
<?php } ?>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="How You Found Us">
How You Found Us:</label>	<input class="form-control" size="50%" name="found" placeholder="How Found" title="How Found" value="<?php echo ((!empty($buffer['found']))?$buffer['found']:'');?>">
</div></div>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="Lead Status">
Lead Status:</label>	<input class="form-control" disabled size="50%" name="lead_status" placeholder="" title="" value="<?php echo $lead_status[$buffer['ar_leads_status']];?>">
</div></div>

<div class="col-md-4 text-left">
<div class="form-group">
<label for="Member Status">
Member Status:</label>	<input class="form-control" disabled size="50%" name="member_status" placeholder="" title="" value="<?php echo $member_status;?>">
</div></div>



</div>
</div>
<!-- END 2nd ROW -->
<?php } ?>
			<div class="panel panel-primary panel-master">
				<a href="#biz" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs1 icon-briefcase icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  Business Info for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?></h4>
					</div>
				</a>
                <div id="biz" class="panel-body collapse">
	
<div class="col-md-6 text-left">
<div class="form-group">
<label for="Business Name">
Business Name:</label>	<input class="form-control" size="50%" name="business_name" placeholder="Business Name" title="Business Name" value="<?php echo ((!empty($_POST['business_name']))?$buffer['business_name']:'');?>">
</div>
</div>



<div class="col-md-6 text-left">
<div class="form-group">
<label for="Business URL">
Business Url:</label>	<input class="form-control" size="50%" name="business_url" placeholder="Business URL" title="Business URL" value="<?php echo ((!empty($_POST['business_url']))?$buffer['business_url']:'');?>">
</div>
</div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Business Name">
Time at Business:</label>	<input class="form-control" size="50%" name="business_time" placeholder="Time at Business" title="Time at Business" value="<?php echo ((!empty($_POST['business_time']))?$buffer['business_time']:'');?>">
</div>
</div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Business Name">
Satisfaction with Business:</label>	<input class="form-control" size="50%" name="business_satisfaction" placeholder="Business Satisfaction" title="Business Satisfaction" value="<?php echo ((!empty($_POST['business_satisfaction']))?$buffer['business_satisfaction']:'');?>">
</div>
</div>

<div class="col-md-6 text-left">
<div class="form-group">
<label for="Lead Comments">
Pain Points:</label>	
<textarea class="form-control" rows="5" cols="50" name="painpoints" placeholder="List known pain points here... what they struggle with, what they want to be different."><?php echo ((!empty($buffer['painpoints']))?$buffer['painpoints']:'');?>
</textarea>
</div></div>
<div class="col-md-6 text-left">
<div class="form-group">
<label for="My Lead Notes">
Talking Points:</label>
<textarea class="form-control" rows="5" cols="50" name="talkingpoints" placeholder="Ideas that break the ice on how you can help allieviate their pain points, using the power of <?php echo $Global['webpage_name']; ?>. Also think of these as Freedom Points." title="My Talking Points"><?php echo ((!empty($buffer['talkingpoints']))?$buffer['talkingpoints']:'');?>
</textarea>
</div></div>

</div>
</div>

<!-- END 1ST ROW -->

<?php
$selectFields = '*';
$mainTable = 'ar_survey';
$where = array('ar_leads_id' => sanitize($buffer['ar_leads_id']));

// Call the select function from PHPCPR
$result_surv = select($selectFields, $mainTable, array(), $where, null, null, null, 0, 1);

if ($result_surv) {
    $buffer_surv = current($result_surv); // Assuming select returns an array of results
}

?>

			<div class="panel panel-primary panel-master">
				<a href="#notes" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs fa-edit icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  Lead's Comments / Survey Answers</h4>
					</div>
				</a>
                <div id="notes" class="panel-body collapse">


<div class="col-xs-12 col-md-12 text-left">
<div class="form-group">
<label for="Lead Comments">
Info <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?> Submitted:</label>	
<?php if (!empty($buffer_surv['comments'])) {
	//echo $buffer_surv['comments'];
} else {
	echo '(If the lead had submitted any comments or survey answers, they would show here.)';
}

if ($buffer_surv['comments'] != '') echo '<hr><h5>Q: '.$buffer_surv['comments_desc'].'</h5><h5>A: '.$buffer_surv['comments'].'</h5>';

if ($buffer_surv['q1'] != '') echo '<hr><h5>Q: '.$buffer_surv['q1'].'</h5><h5>A: '.$buffer_surv['a1'].'</h5>';

if ($buffer_surv['q2'] != '') echo '<hr><h5>Q: '.$buffer_surv['q2'].'</h5><h5>A: '.$buffer_surv['a2'].'</h5>';

if ($buffer_surv['q3'] != '') echo '<hr><h5>Q: '.$buffer_surv['q3'].'</h5><h5>A: '.$buffer_surv['a3'].'</h5>';

if ($buffer_surv['q4'] != '') echo '<hr><h5>Q: '.$buffer_surv['q4'].'</h5><h5>A: '.$buffer_surv['a4'].'</h5>';

if ($buffer_surv['q5'] != '') echo '<hr><h5>Q: '.$buffer_surv['q5'].'</h5><h5>A: '.$buffer_surv['a5'].'</h5>';
?>
</div></div>

</div>
</div>
<!-- END ROW -->

<?php if ($hide_details == false) { 
	$who = 'My';
} else {
	$who = 'Closer';
}
?>

			<div class="panel panel-primary panel-master">
				<a href="#followedup_entries" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs fa-mail-forward icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  <?php echo $who; ?> Followed-up Entries / Lead Notes</h4>
					</div>
				</a>
                <div id="followedup_entries" class="panel-body collapse">

<div class="col-xs-12 col-md-12 text-left">
<div class="form-group">
<label for="Followed-up Entries for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?>">
<?php echo $who; ?> Followed-up Entries for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?>:</label>

<?php 
$selectFields = '*';
$mainTable = 'ar_personal_followups';
$where = array('ar_leads_id' => sanitize($ar_leads_id));
$orderBy = 'idx DESC';
$limit = 50;

// Call the select function from PHPCPR
$resultu = select($selectFields, $mainTable, array(), $where, null, null, $orderBy, $limit, 1);


/*
CREATE TABLE IF NOT EXISTS `ar_personal_followups` (
  `idx` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `ar_leads_id` int(11) NOT NULL,
  `followedupdate` datetime DEFAULT NULL,
  `followed_up_method` varchar(20) NOT NULL,
  `engagement` varchar(30) NOT NULL,
  `new_rating` varchar(10) NOT NULL,
  `followupnotes` text NOT NULL,
  PRIMARY KEY (`idx`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;	

*/

// THIS WHILE LOOP IS TO SHOW FOLLOWED UP NOTES ONLY!!
 foreach ($resultu as $bufferu) {

	if ($bufferu['idx'] != '') {
		$idx_display = ($bufferu['idx'] * 55555);
		echo '<hr><h5>Followedup Date: '.date('m/d/Y', strtotime($bufferu['followedupdate']));
		echo '&nbsp;&nbsp; Method: '.$bufferu['followed_up_method'];
		echo '&nbsp;&nbsp; Engagement: '.$bufferu['engagement'];
		echo '&nbsp;&nbsp; New Rating: '.$bufferu['new_rating'].'</h5>';
		echo '<h5>Notes: '.$bufferu['followupnotes'].'</h5>';
		//echo '<a href="leads_edit.php?edit_followup='.$idx_display.'" class="btn btn-info btn-xs"><i class="fs fa-edit icon-1x"></i>Edit</a>';
		
		echo '<a href="#" data-toggle="modal" data-target="#followup_info" class="btn btn-info btn-xs"><i class="fs fa-edit icon-1x"></i>&nbsp;Edit</a>&nbsp;';
		echo '<a href="leads_edit.php?delete_followup='.$idx_display.'" class="btn btn-danger btn-xs"><i class="fs fa-trash-o icon-1x"></i>&nbsp;Delete</a>&nbsp;&nbsp;';		
	} else {
		echo 'All documented "followed up" contacts with this lead will show up here.)';
	}
} ?>

  <!-- Modal -->
  <div class="modal fade" id="followup_info" tabindex="-1" role="dialog" data-backdrop="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title"><i class="fa fa-edit" style="color:lightgray"></i>&nbsp;&nbsp;How To "Edit" Followedup Memos</h4>
      </div>
      <div class="modal-body">  
		Made a boo boo, or forgot to add some details? Or have new details to add on the same date?
		<br/>
		<hr>
		Simply make a new entry with the new corrected info, and then delete the old one.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- End Modal -->

<hr>

<label for="Lead Notes for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?>">
<?php echo $who; ?> Lead Notes Summary for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?>:</label>&nbsp;(this section may be edited at any time) NOTE: Only this section is later searchable for your notes, so be sure to add all important notes in this section, as well. This way you can search for these notes at any time in the future, by searching for "My Notes".
<textarea class="form-control" rows="7" cols="50" name="notes" placeholder="My notes about this lead go here. They will show up in the section above." title="My Notes"><?php echo ((!empty($buffer['notes']))?$buffer['notes']:'');?>
</textarea>
</div></div>


</div>
</div>
<!-- END ROW -->

<?php if ($hide_details == false) { ?>
			<div class="panel panel-primary panel-master">
				<a href="#followedup" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs fa-thumbs-o-up icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  Add New Followed-up entry for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?></h4>
					</div>
				</a>
                <div id="followedup" class="panel-body collapse">

<div class="col-md-3 text-left">
<div class="form-group">
<label for="Followed Up Date">
Followed-up Date:</label>
<!--Date formats: yyyy-mm-dd, yyyymmdd, dd-mm-yyyy, dd/mm/yyyy, ddmmyyyyy
-->
  <br />
                <div class='input-group date' id='datetimepicker'>
				
				<?php if ($buffer['followupdate'] == '0000-00-00') $buffer['followupdate'] = ''; ?> 
           
					<input type="text" class="form-control" placeholder="Follow up Date" title="Follow up Date" name="followedupdate" value="<?php echo $buffer['followedupdate'];?>">

                    <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
                    </span>
                </div>
            </div>
</div>
								
<div class="col-md-3 text-left">
<div class="form-group">
<label for="Follow Up Method">
Followed-up Method:</label>

<select name="followed_up_method" class="form-control">
<option value="phone">Phone Call</option>
<option value="skype">Skype Call</option>
<option value="skype">Skype Chat</option>
<option value="email">Email</option>
<option value="in_person">In Person</option>
<option value="phone">SMS Text Message</option>
<option value="other">Other</option>
</select>
</div></div>		

<div class="col-md-3 text-left">
<div class="form-group">
<label for="Follow Up Method">
Engagement Success:</label>

<select name="engagement" class="form-control">
<option value="Spoke with lead">I spoke with the lead</option>
<option value="Left a voicemail">I left a voicemail message for the lead</option>
<option value="Left a Skype Message">I left a skype message for the lead</option>
<option value="Sent an email">I sent an email to the lead</option>
<option value="Sent SMS Text Message">I sent an SMS text message to the lead</option>
<option value="other">Other</option>
</select>
</div></div>	

<div class="col-md-3 text-left">
<div class="form-group">
<label for="Follow Up Method">
New Lead Rating:</label>

<select name="new_rating" class="form-control">
<option value="">No Change</option>
<option value="none">None</option>
<option value="closed">Closed</option>
<option value="hot">Hot</option>
<option value="warm">Warm</option>
<option value="cold">Cold</option>
<option value="done">Done</option>
</select>
</div></div>	
				
				
<div class="col-xs-12 col-md-12 text-left">
<div class="form-group">
<label for="My Follow Up Notes for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?>">
My New Followed-up Notes for <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?>:</label>
<textarea class="form-control" rows="7" cols="50" name="followupnotes" placeholder="My notes about this latest encounter go here." title="My Notes"><?php echo ((!empty($buffer['followupnotes']))?$buffer['followupnotes']:'');?>
</textarea>
</div></div>			
	
</div>
</div>
<!-- END 5TH ROW -->



			<div class="panel panel-primary panel-master">
				<a href="#followup" data-toggle="collapse" style="text-decoration:none;">
					<div class="panel-heading text-left">
                          <h4><sub><small><small><div class="fs fa-hand-o-right icon-3x" style="color:#697f9c" aria-hidden="true"></div></small></small></sub>
						  Send Me Email Reminders to Follow up with <?php echo $buffer['ar_leads_firstname']; ?> <?php echo $buffer['ar_leads_lastname']; ?></h4>
					</div>
				</a>
                <div id="followup" class="panel-body collapse">

<div class="col-md-4 text-left">
<div class="form-group">
<label for="Schedule Follow Up">
Schedule Follow Up:</label>
<!--Date formats: yyyy-mm-dd, yyyymmdd, dd-mm-yyyy, dd/mm/yyyy, ddmmyyyyy
-->
  <br />
                <div class='input-group date' id='datetimepicker'>
				
				<?php if ($buffer['followupdate'] == '0000-00-00') $buffer['followupdate'] = ''; ?> 
           
					<input type="text" class="form-control" placeholder="Follow up Date" title="Follow up Date" name="followupdate" value="<?php echo $buffer['followupdate'];?>">

                    <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
                    </span>
                </div>
            </div>
</div>
								
<div class="col-md-4 text-left">
<div class="form-group">
<label for="Make Follow Up Reminder Recurring">
Make Follow Up Reminder Recurring:</label>

<select name="recurring_days" class="form-control">
<option value="0" <?php if($buffer['recurring_days'] == '0') echo 'selected'; ?>>Never</option>
<option value="1" <?php if($buffer['recurring_days'] == '1') echo 'selected'; ?>>Every Day</option>
<option value="2" <?php if($buffer['recurring_days'] == '2') echo 'selected'; ?>>Every 2 Days</option>
<option value="3" <?php if($buffer['recurring_days'] == '3') echo 'selected'; ?>>Every 3 Days</option>
<option value="7" <?php if($buffer['recurring_days'] == '7') echo 'selected'; ?>>Every Week</option>
<option value="14" <?php if($buffer['recurring_days'] == '14') echo 'selected'; ?>>Every 2 Weeks</option>
<option value="30" <?php if($buffer['recurring_days'] == '30') echo 'selected'; ?>>Every 30 Days</option>
<option value="60" <?php if($buffer['recurring_days'] == '60') echo 'selected'; ?>>Every 60 Days</option>
</select>

</div></div>				
				
				
<div class="col-md-4 text-left">
<div class="form-group">
<label for="Expire Follow Up Reminder">
Expire Follow Up Reminder:</label>



                <div class='input-group date' id='datetimepicker'>
				
				<?php if ($buffer['expire_date'] == '0000-00-00') $buffer['expire_date'] = ''; ?> 
           
					<input type="text" class="form-control" placeholder="Follow up Expire Date" title="Follow up Expire Date" name="expire_date" value="<?php echo $buffer['expire_date'];?>">

                    <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
                    </span>
                </div>
 
</div></div>				
	
</div>
</div>
<!-- END 6TH ROW -->				
<input type="hidden" name="md5" value="<?php echo $md5; ?>">
<input type="hidden" name="ar_leads_id" value="<?php echo $ar_leads_id; ?>">
<input type="hidden" name="leads_update" value="1">
<input class="btn btn-primary" type="submit" value="Update Details" name="submit">
</form>

<br/><br/>

<form action="leads.php" method="POST">
<input class="btn btn-danger" type="submit" value="Skip Update & Return To Leads" name="submit">
</form>	  
<?php } else { ?>

<a href="leads.php" class="btn btn-danger">Return To Leads</a>
 	
	
<?php } ?>



  <script>
     $(function () {
   var bindDatePicker = function() {
		$(".date").datetimepicker({
        format:'YYYY-MM-DD',
			icons: {
				time: "fa fa-clock-o",
				date: "fa fa-calendar",
				up: "fa fa-arrow-up",
				down: "fa fa-arrow-down"
			}
		}).find('input:first').on("blur",function () {
			// check if the date is correct. We can accept dd-mm-yyyy and yyyy-mm-dd.
			// update the format if it's yyyy-mm-dd
			var date = parseDate($(this).val());

			if (! isValidDate(date)) {
				//create date based on momentjs (we have that)
				date = moment().format('YYYY-MM-DD');
			}

			$(this).val(date);
		});
	}
   
   var isValidDate = function(value, format) {
		format = format || false;
		// lets parse the date to the best of our knowledge
		if (format) {
			value = parseDate(value);
		}

		var timestamp = Date.parse(value);

		return isNaN(timestamp) == false;
   }
   
   var parseDate = function(value) {
		var m = value.match(/^(\d{1,2})(\/|-)?(\d{1,2})(\/|-)?(\d{4})$/);
		if (m)
			value = m[5] + '-' + ("00" + m[3]).slice(-2) + '-' + ("00" + m[1]).slice(-2);

		return value;
   }
   
   bindDatePicker();
 });
  //# sourceURL=pen.js
  </script>
<?php
include_once './footer.php';