<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
session_start(); 

if (isset($_SESSION['loggedin'])) $logoutusername = $_SESSION['loggedin'];

if (isset($_SESSION['googleid']) && $_SESSION['googleid']['username'] != '') { 
    // if logged in via Google, go to main page to avoid immediate re-login
    unset($_SESSION['googleid']);
    header("Location: /?id=$logoutusername");
    session_destroy();
    exit;
}

// Check if 'p1_status' is set in the session before comparing its value
if (isset($_SESSION['p1_status']) && isset($_SESSION['loggedin']) && $_SESSION['p1_status'] != 'Unpaid') { 
    // THEY HAVE PAID, SHOW THEIR AFF LINK!
    header("Location: /login.php?id=$logoutusername");
} else { 
    // USER IS UNPAID -- DO NOT CHANGE SPONSOR ON PUBLIC PAGE (SO THEY CAN SEE THEIR SPONSOR'S INFO STILL)!
    header("Location: /login.php");
}

session_destroy();

?>
