<?php 
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
$program_id = 1;
$program_id_array = array(1); // PROGRAM YOU MUST BE IN TO SEE THIS PAGE!
$allow_any_program = false; 
$allowed_status = array('Active','Comped','TempComp'); 
$disallow_grace_period_access = true;
$redirect = true;
include './../access_check.php';

$pageName = 'Shopping Boss Access'; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-coupon'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
//$pageClass = 'index'; // FOR CUSTOM PROGRAMMING USES
//$thispage = $program_id.'.php';
include './../../Sub/tpl/header_tpl.php';

/*
SELECT c.ID FROM `coupon` AS c
JOIN user_program AS u 
WHERE c.ID = u.ID
AND c.ID > 0
AND c.valid = 'Y' 
AND u.program_id = 1
AND u.user_status = 'Active'

SELECT c.ID FROM `coupon` AS c
JOIN user_program AS u 
WHERE c.ID = u.ID
AND c.ID > 0
AND c.valid = 'Y' 
AND u.program_id = 1
AND u.user_status = 'Cancelled'

// THIS IS DONE AUTOMATICALLY NOW, UPON EXPORTS IN ADMIN PANEL!
UPDATE coupon AS c
JOIN user_program AS u ON c.ID = u.ID
SET c.valid = 'N'
WHERE c.ID > 0
AND c.valid = 'Y'
AND u.program_id = 1
AND u.user_status = 'Cancelled';

SELECT couponcode FROM `coupon`
WHERE 
ID > 0
AND valid = 'N'
*/

if (!isset($_GET['getcode'])) { // WE DON'T WASTE CODES ON INT USERS WHO CAN'T USE THEM! ?>
	<div class="panel-heading">
		<h4><?php echo $pageName; ?> &nbsp; <i class="icon-user icon-1x" STYLE="margin-top: -20pt"></i></h4>
	</div>

	<h2>Shopping Boss can only be used in the USA!</h2>
	<br><br><br>
	I can shop in the USA. <a href="coupon_access.php?getcode=Y">Get my code</a>
	<br><br>
	I cannot shop in the USA. <a href="javascript:history.back()" style="font-size: 14px;">Go Back</a>
	<?php
	include './../../Sub/tpl/footer_tpl.php';
    exit;
}
	

$datetime = date('Y-m-d H:i:s');
$error_msg = '';

// PHPCPR setup for selecting the member's latest valid coupon
$selectFields = '*';
$mainTable = ['table' => 'coupon', 'as' => 'c'];
$joinConditions = [];
$where = [
    'c.ID' => ['=', $_SESSION['UserID']],
    'valid' => ['=', 'Y']
];
$orderBy = 'idx DESC';
$limit = 1;
$show_debug = 1;

// Check if the member already has a coupon
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;

if (count($result) < 1) { // If no coupon, try to assign one
    $where = [
        'ID' => ['=', '0'],
        'date_redeemed' => ['=', '0000-00-00 00:00:00']
    ];
    $orderBy = 'idx ASC';
    $result2 = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);
    $buffer2 = isset($result2[0]) ? $result2[0] : null;

    if (count($result2) < 1) { // If no available coupon
        $error_msg = 'There are no coupons available to redeem. Please contact the administrator.';
    } else { // Assign the coupon to the member
        $data = [
            'ID' => $_SESSION['UserID'],
            'date_redeemed' => $datetime
        ];
        $where = ['idx' => ['=', $buffer2['idx']]];
        update('coupon', $data, [], $where, 1, 1, $show_debug);
    }
}

// Display error message if any
if ($error_msg != '') {
    echo '<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>';
    echo '<div style="text-align:center">' . htmlentities($error_msg) . '</div>';
    echo '<p>&nbsp;</p><p>&nbsp;</p><p>&nbsp;</p>';
    include './../../Sub/tpl/footer_tpl.php';
    exit;
}

// If no error, re-select to show the member's coupon code
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;
$coupon = $buffer['couponcode'];
?>


<div class="panel-heading">
	<h4><?php echo $pageName; ?> &nbsp; <i class="icon-user icon-1x" STYLE="margin-top: -20pt"></i></h4>
</div>


<h2>Shopping Boss Invitation Code:
    <span id="couponCode" style="background-color: #FFFF99; padding: 5px;"><?php echo htmlspecialchars($coupon); ?></span>
    <button onclick="copyCouponCode()" class="btn btn-xs btn-primary" style="padding: 2px 5px; font-size: 12px; margin-left: 10px; vertical-align: middle;">Copy Code</button>
</h2>

<script>
function copyCouponCode() {
  // Get the text from the element containing the coupon code
  var couponCode = document.getElementById('couponCode').innerText;
  
  // Create a temporary input element to hold the text to be copied
  var tempInput = document.createElement('input');
  
  // Append it to the body
  document.body.appendChild(tempInput);
  
  // Set its value to the coupon code
  tempInput.value = couponCode;
  
  // Select the content of the input
  tempInput.select();
  tempInput.setSelectionRange(0, 99999); // For mobile devices
  
  // Copy the text inside the input field
  document.execCommand('copy');
  
  // Remove the temporary input from the document
  document.body.removeChild(tempInput);
  
  // Alert or some visual feedback that the text was copied
  alert('Coupon code copied to clipboard!');
}
</script>


<div style='clear:both'></div>
<hr>

<div class="col-md-12" style="text-align:center">  
<br><br>
<a href="https://members.shoppingboss.com/site/register" target="_blank" class="btn btn-success btn-lg"><img src="" class="img-responsive">Register At Shopping Boss</a>
</div>

&nbsp;
<?php
include './../../Sub/tpl/footer_tpl.php';
?>