<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php';

$pageName = 'Program Stats'; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = $Global['webpage_name'].' Programs & Comp Plans  &nbsp;<i class="fa fa-binoculars icon-1x" STYLE="margin-top: -0pt; color:#adadad"></i>'; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-binoculars'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES	

//$pageDesc = 'Available Balance: $'.number_format($balance,2) .' &nbsp;<i class="icon-wallet"></i> &nbsp; &nbsp;Net Commissions Pending: $'.$pending_minus_fees.' &nbsp;<span style="display:inline-block; vertical-align: middle; margin-top:-6px; font-size:10pt;"><i class="fa fa-hourglass-half"></i></span>';


//If they want to see a specific program, show it
if (!empty($_GET['program']) && intval($_GET['program']) > 0) $Global['program'] = intval($_GET['program']);
elseif (!empty($_SESSION['program']) && intval($_SESSION['program']) > 0) $Global['program'] = intval($_SESSION['program']);
else $Global['program'] = $Global['default_program'];

$_SESSION['program'] = $Global['program'];

// QQQ FORCE 
$Global['program'] = 1;

if ($Global['program'] > 0) { // FIND THE PROGRAM! WORKS!			
	// Define the fields to select
	$selectFields = ['program_id', 'header_file', 'footer_file', 'program_name'];

	// Specify the main table
	$mainTable = ['table' => 'program', 'as' => 'p'];

	// Define the WHERE conditions
	$where = [
		'p.program_approved' => ['=', 'Y'],
		'p.program_id' => ['=', sanitize($Global['program'], 'int')]
	];

	// Execute the query using the PHPCPR 'select' function
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
}
// Check if the result is not empty and assign the first record to $buffer
if (!empty($result)) {
    $buffer = $result[0];
} else {
    // Handle the case where no results are found
    $buffer = null;
}
			
if (!empty($buffer['program_id'])) {
	$Global['header'] = './../Sub/tpl/'.$buffer['header_file'];
	$Global['footer'] = './../Sub/tpl/'.$buffer['footer_file'];
	}
else {
	$Global['header'] = './real_header.php';
	$Global['footer'] = './footer.php';
	}

	
include $Global['header'];

if (false && $_SESSION['admin_session_view'] == false) {
?><div class="QQpanel">					
	<div class="QQpanel-heading" style="text-align:left">
		<h4><?php echo $Global['webpage_name']; ?> Programs & Comp Plans &nbsp; <i class="fa fa-binoculars icon-1x" STYLE="margin-top: -0pt; color:#adadad"></i></h4>
	</div>
</div>		
<?php }




// Select all programs
$selectFields = 'memb.unsubscribe_id, user.*, prog.*';
$mainTable = ['table' => 'members', 'as' => 'memb'];
$joinConditions = [
    ['table' => 'user_program', 'as' => 'user', 'condition' => 'memb.ID = user.ID'],
    ['table' => 'program', 'as' => 'prog', 'condition' => 'user.program_id = prog.program_id']
];
$where = [
    'prog.program_approved' => ['=', 'Y'],
    'memb.Username' => ['=', $_SESSION['loggedin']],
    'prog.program_setup_type' => ['!=', 'S'],
	'prog.program_id' => ['NOT IN', $GLOBALS['program_restrict']]
];
$groupBy = 'prog.program_id';
$orderBy = 'prog.program_id ASC';

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 0, 1);

$selected_program = '';
$programs_text = '';

foreach ($result as $buffer) {
    $prog_id = $buffer['program_id'];
    /*$qrySelectFields = 'program_id';
    $qryMainTable = 'program';
    $qryWhere = [
        'program_id' => ['IN', $GLOBALS['program_restrict']]
    ];
    $result2 = select($qrySelectFields, $qryMainTable, [], $qryWhere, null, null, null, 0, 1);
    $buffer2 = $result2[0];

	// ADDED THIS ABOVE INSTEAD!
	if ($buffer2['program_id'] == '') continue; // PROGRAM IS IN RESTICTED LIST, SO SKIP THIS ONE IN LOOP!	*/
		
	$temp_text = '';
	
	//Decide what program type this is
	if ($buffer['program_type'] == 'S') {
		$program_type = 'Subscription';
		$program_duration = 'Subscription Period: '.$buffer['program_sub_period'].' days<br />';
		}
	else {
		$program_type = 'One Time Payment';
		$program_duration = '';
		}
	
	//See if we should display tier info
	
	if ($buffer['program_tier'] > 0) {
		$tier_pay = null;
		$tier_nr = 0;		

		if ($buffer['program_tier_pay'] > 0) {
			$tier_pay .= 'Tier 1: $'.number_format($buffer['program_tier_pay'], 2).'<br />';
			++$tier_nr;
			}
		if ($buffer['program_tier_pay2'] > 0) {
			$tier_pay .= 'Tier 2: $'.number_format($buffer['program_tier_pay2'], 2).'<br />';
			++$tier_nr;
			}
		if ($buffer['program_tier_pay3'] > 0) {
			$tier_pay .= 'Tier 3: $'.number_format($buffer['program_tier_pay3'], 2).'<br />';
			++$tier_nr;
			}
		if ($buffer['program_tier_pay4'] > 0) {
			$tier_pay .= 'Tier 4: $'.number_format($buffer['program_tier_pay4'], 2).'<br />';
			++$tier_nr;
			}
		if ($buffer['program_tier_pay5'] > 0) {
			$tier_pay .= 'Tier 5: $'.number_format($buffer['program_tier_pay5'], 2).'<br />';
			++$tier_nr;
			}

		$tier_line = 'Tiers: '.$tier_nr.'<br />';
		}	
	else {
		$tier_line = '';
		$tier_pay = '';
		}
	
	//See if we should display powerline info
	if ($buffer['program_up'] > 0) {
		//$power_line = 'Powerlines: '.$buffer['program_up'].'<br />';
		$power_line = 'Powerlines: '.$buffer['program_up'];
		
		if ($buffer['every_nth'] > 0) $power_line .= ' Pass Up Every '.$buffer['every_nth'].'th Sale';
		
		$power_line .= '<br />';
		 
		$power_pay = 'Powerline Commission: $'.number_format($buffer['program_up_pay'], 2).'<br />';
		}
	else {
		$power_line = '';
		$power_pay = '';
		}
		

	//See if we should display admin fee
	if ($buffer['program_admin_pay'] > 0) {
		$admin_pay = 'Subscription Fee: $'.number_format($buffer['program_admin_pay'], 2).'<br />';
		$admin_pay = 'Admin Fee: $'.number_format($buffer['program_admin_pay'], 2).'<br />';
		}	
	else {
		$admin_pay = '';
		}
		
if ($buffer['program_admin2_pay'] > 0) $admin_pay .= 'Setup Fee: $'.number_format($buffer['program_admin2_pay'], 2).'<br />';

		
/*
	// QQQ TEMP KLUDGE FOR DEMO SITE!!	
	if ($buffer['program_id'] == 1) {
		$power_line = 'Binary Matrix<br />';
		$power_pay = 'Binary Commission: $10.00<br />';
		$power_pay .= 'For Each Position on Weakest Leg<br />';
		$power_pay .= 'Fast Start Bonus: $5.00<br />';
		$admin_pay = '';
	} else if ($buffer['program_id'] == 2) {
		$power_line = '2x2 Forced Splitting Matrix<br />';
		$power_pay = 'Matrix Cycle Commission: $70.00<br />';
		$admin_pay = '';
	} else if ($buffer['program_id'] == 3) {
		$power_line = '2x3 Forced Splitting Matrix<br />';
		$power_pay = 'Matrix Cycle Commission: $340.00<br />';
		$admin_pay = '';
	}
	// END KLUDGE		
*/	
		
	$complete_payment	= number_format((($buffer['program_tier_pay']) + $buffer['program_tier_pay2'] + $buffer['program_tier_pay3'] + $buffer['program_tier_pay4'] + $buffer['program_tier_pay5'] + $buffer['program_up_pay'] + $buffer['program_admin_pay'] + $buffer['program_admin2_pay']), 2);
		
	//Find out how much the user has earned
	$total_earned = number_format($buffer['earned_amount'], 2);
	
	//This will display the cc info if required
	if (false /*$Global['use_cc'] === true*/) {
	$selectFields = 'SUM(amount) as total';
	$mainTable = 'payment_log';
	$where = [
		'user_program_id' => ['=', $buffer['user_program_id']],
		'program_id' => ['=', $buffer['program_id']],
		'chargeback' => ['=', 'N'],
		'cc_pending' => ['=', 'Y']
	];

	$result_cc = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	//$total = $result_cc[0]['total'];

	$buffer_cc = isset($result_cc[0]) ? $result_cc[0] : '';
		
		//this will search the grace table to see if there is pending payments
		$total_awaiting_grace = 'Total Pending Holding Period: $'.number_format($buffer_cc['total'], 2).'<br />';
		
		$total_unpaid = 'Total Pending Payment: $'.number_format($buffer['amount'], 2).'<br />';
		}	
	else {
		$total_awaiting_grace = '';
		$total_unpaid = '';
		}
		//$total_unpaid = '';
	
	//Display the info

// DON'T SHOW TOTAL EARNED ON PROGRAMS WITHOUT COMP PLANS
// LIST THE PROGRAM ID HERE
if ($buffer['program_id'] ==30) {
	
	$temp_text .= '
<strong><h2>'.$buffer['program_name'].'</h2></strong>
<span style="font-size:0.9em">Program Type: '.$program_type.'<br />'.$program_duration.$tier_line.$power_line.$tier_pay.$power_pay.$admin_pay.'
Complete Payment: $'.$complete_payment.'<br /></span><br />';

} else {

	$temp_text .= '
<strong><h2>'.$buffer['program_name'].'</h2></strong>
<span style="font-size:0.9em">Program Type: '.$program_type.'<br />'.$program_duration.$tier_line.$power_line.$tier_pay.$power_pay.$admin_pay.'
Complete Payment: $'.$complete_payment.'<br /><br /></span>';

if ($_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] == true) $temp_text .= $total_awaiting_grace.$total_unpaid.'Total Earned: $'.$total_earned.'<br /><br />';
		
} // END DON'T SHOW TOTAL EARNED ON PROGRAMS WITHOUT COMP PLANS
		
	$selectFields = 'payment_processor, SUM(amount) as amount';
	$mainTable = 'payment_log';
	$where = [
		'user_program_id' => ['=', $buffer['user_program_id']],
		'chargeback' => ['=', 'N'],
		'cc_pending' => ['=', 'N']
	];
	$groupBy = 'payment_processor';

	$payment_info = select($selectFields, $mainTable, [], $where, $groupBy, null, null, 0, 1);

	$payments = array();

	foreach ($payment_info as $payment_buffer) {
			
		//$temp_text .= 'Paid by '.$Global['processor_info'][$payment_buffer['payment_processor']].': $'.number_format($payment_buffer['amount'], 2).'<br /><br />';
		}
		
	if ($buffer['program_type'] == 'S' && in_array($buffer['user_status'], $Global['good_status']) && $buffer['program_life'] == 'N') {
		if ($buffer['program_linked'] == 'N' && $buffer['user_status'] != 'Comped') {
			$renewal_payments = '<a href="program.php?program='.$buffer['program_id'].'&renew=yes">Click here to make renewal payments</a><br />';	
			
			if (!empty($buffer['program_link']) && $buffer['program_linked'] == 'N') $downgrade_program = '<br /><a href="downgrade.php?program='.$buffer['program_id'].'">Click here to downgrade your program</a>';
			else $downgrade_program = '';
			
			
			if ($buffer['end_program'] == 'N' && in_array($buffer['user_status'], $Global['good_status'])) $end_subscription = '<br /><a href="./cancel.php?program='.$buffer['program_id'].'">Click here to cancel your credit card subscription</a><br />

<!-- //commented out below, as it may be too confusing to most people who just want to leave the program.
<a href="subend.php?program='.$buffer['program_id'].'&action=End">Click here to cancel subscription expiration notification emails</a><br />
-->

';

			elseif (in_array($buffer['user_status'], $Global['good_status'])) $end_subscription = '<br /><a href="subend.php?program='.$buffer['program_id'].'&action=Enable">Click here to re-enable the subscription</a><br />';
			else $end_subscription = '';
			}
		else {
			$renewal_payments = '';
			$end_subscription = '';
			$downgrade_program = '';
			}
		}
	elseif (true) {

/*COMMENTING OUT JOIN OPTIONS FOR FORCED STAIRSTEPPING INTO PROGRAMS	    
	  if ($buffer['upgrade_program'] == 'Y' && $upgrade_allowed === true) {
	    $renewal_payments = '<a href="paid/program_access_'.$buffer['program_id'].'.php">Click here to upgrade to this program</a><br />';	
  		$end_subscription = '';
  		$downgrade_program = '';
	    }
	  else {
  		$renewal_payments = '<a href="paid/program_access_'.$buffer['program_id'].'.php">Click here to join this program</a><br />';	
  		$end_subscription = '';
  		$downgrade_program = '';
	    }*/
		}
	else {
		$downgrade_program = '';
		$renewal_payments = '';
		$end_subscription = '';
		}
	

	//Added the code which will allow the users to leave the entire site here. At the moment the code is added to every
	//program, perhaps making users believe they would only leave that specific program. If this happen, the placement of the link
	//should perhaps be reconsidered.

	//$leave_site = '<a href="'.$Global['webpage_url'].'leave.php?id='.$buffer['unsubscribe_id'].'">Click here to be removed from the database</a><br />';
	$leave_site = '';
	
//We display the final links
// START COMMENT HERE TO HIDE LINKS

if ($buffer['user_status'] != 'Unpaid' && $buffer['user_status'] != 'Suspended' && $buffer['user_status'] != 'Cancelled') {
//if ($buffer['user_status'] (in_array('Active', 'Comped', 'TempComp'))) {

	if ($buffer['end_program'] == 'Y') { 
		$canceled = '(Time Remaining) - <span style="color:red">Membership Canceled</span>';
	} else {
		$canceled = '';
	}


if ($buffer['user_status'] == 'Active' || $buffer['user_status'] == 'Comped' || $buffer['user_status'] == 'TempComp') { 
$status = '<span style="color:#006600"> '.$buffer['user_status'].' </span> ';

	if ($buffer['user_status'] == 'Comped' || $buffer['user_status'] == 'TempComp') { 
	$active_status = '';
	} else 
	if ($buffer['program_type'] == 'S') {
	$active_status = 'Your Subscription Due Date Is: '.date("F j, Y",$buffer['expire']).'<br/>';
	} else {
		$active_status = '';
	}	

} else {
$status = $buffer['user_status'];
$active_status = '';
}


	$temp_text .= '
Your Status Is: '.$status.' '.$canceled.'<br />
'.$active_status.'<br/>';


if ($buffer['program_type'] == 'S' && ($buffer['user_status'] == 'Active' || $buffer['user_status'] == 'Suspended') && $buffer['program_life'] == 'N') $temp_text .= '<a href="../apay/pay.php?program='.$buffer['program_id'].'">Click here to make renewal payments</a><br/>';

if ($_SESSION['a'.$_SESSION['UserID']]['affiliate_status'] == true) $temp_text .= '

<!--
<a href="viewdownline.php?program='.$buffer['program_id'].'">Click here to view your team</a><br />
<a href="emaildownline.php?program='.$buffer['program_id'].'">Click here to email your team</a><br />

<a href="bankledger.php?program='.$buffer['program_id'].'">Click here to view payments earned</a><br/>

<a href="viewpayment.php?program='.$buffer['program_id'].'">Click here to view payments earned</a><br/>
-->
<!--
<a href="viewdirectpayment.php?program='.$buffer['program_id'].'">Click here to view your direct payment log</a><br />
-->
';

//.$end_subscription.$leave_site;

// OLD CODE '.$downgrade_program.$end_subscription.$leave_site;

} else { // END STATUS IS NOT UNPAID

	if ($buffer['program_setup_type'] != 'S') {

		$temp_text .= 'Your Status Is:<span style="color:red"> '.$buffer['user_status'].' </span><br/><br />';
		//$temp_text .= '<a href="paid/program_access_'.$buffer['program_id'].'.php">Click here to activate this program</a>';
		$temp_text .= '<a href="../apay/pay.php?program='.$buffer['program_id'].'">Click here to activate this program</a>';
	}
}
// END COMMENT HERE FOR HIDING LINKS

$temp_text .= '<br /><br />';

	if ($Global['program'] > 0 && $Global['program'] == $buffer['program_id']) $selected_program .= $temp_text;
	else $programs_text .= $temp_text;
	}

echo $selected_program,$programs_text.'</td></tr></table>';

include $Global['footer'];
?>