<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php'; 
$pageName = 'Upload Tax Form'; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = ''; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES
$do_not_display_ads = true; // STOPS FILE FROM BEING INCLUDED FROM B.O. HEADER
include $Global['path'].'Sub/tpl/header_tpl.php';
//$GLOBALS['debug'] = true;
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!

echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
*/
// RELIES ON exec - security risk, so not using
/*function checkPDFFields($upload_path, $pdf_path, &$error_msg) { // ALLOWS $error_msg to be changed inside function
    // Generate a unique output file name based on the logged-in user
    $output_file = "output_" . $_SESSION['loggedin'] . ".html";
    // Correctly form the command string
    $command = "pdftohtml -noframes '" . $pdf_path . "' '" . $upload_path . $output_file . "'";
    exec($command, $output, $return_var);

    if ($return_var != 0) {
        $error_msg = "PDF to HTML conversion failed. ";
        return false;
    }

    if (!file_exists($upload_path . $output_file)) {
        $error_msg = "HTML file not found. ";
        return false;
    }

    // Load the HTML
    $htmlContent = file_get_contents($upload_path . $output_file);

    // Define the required fields
    $required_fields = ['Name:', 'Business name:', 'Taxpayer Identification Number:'];

    foreach ($required_fields as $field) {
        if (strpos($htmlContent, $field) === false) {
            $error_msg .= "Field $field is not found in the form.\n";
            unlink($upload_path . $output_file); // Clean up
            return false;
        }
    }

    // If all checks pass, clean up and set a success message
    unlink($upload_path . $output_file);
    $error_msg = "All required fields are filled.";
    return true;
}*/
// Function to perform basic checks on the PDF file

// PSF SIZE DOES NOT CHANGE WHEN FILLED, SO THIS IS USELESS
function basicPDFCheck($filePath, &$error_msg) {
    // Check if the file size is more than a few bytes to ensure it's not empty
    if (filesize($filePath) <= 218584) { // Example threshold, adjust based on needs
        $error_msg = "The PDF file seems to be empty.";
        return false;
    }

    // Further checks can be added here, like checking for a minimum file size,
    // or if integrating with a PDF library, checking for content.

    return true; // Assuming basic checks passed
}

?>

<h2>Tax Form Instructions</h2>


<br>
<div class="alert alert-info" role="alert">
<i class="fa fa-hand-o-right"></i>
FIRST - Make sure your <a href="profile.php" class="btn btn-warning btn-xs" target="_blank">profile</a> address section is complete, and your country is correct.
</div>
Download the appropriate tax form, below. Fill it out completely.
<br><br>
IT MUST BE COMPLETE AND SIGNED. To add your digital signature and date, simply right click over these areas,<br>
and click "Add text" -- then type your name, and hit "Esc" to exit that function. Do the same for date, and then save it. 
<br><br>
Once finished, upload the pdf back to the server. PDF is preferred. We also accept scans. 
<br><br>
Once admin has approved your tax form, you will be eligible for withdrawals.
<br><br>
<b>Supported scanned file types are: "pdf", "jpg", "jpeg", "gif", "png"</b>
<br><br>

<a href="/Members/pdf/fw8ben.pdf" download class="btn btn-primary">International Users Download W8</a>

<a href="/Members/pdf/fw9.pdf" download class="btn btn-primary">U.S. Users Download W9</a>

<br><br>

<?php
$ID = $_SESSION['UserID'];
$uname = $_SESSION['loggedin'];

// Allowed image file types
$allowed_types = array("pdf", "jpg", "jpeg", "gif", "png");

// Upload path
$upload_path = $_SERVER['DOCUMENT_ROOT'] . '/Members/pdf/';

$success = false; // INI VAR
$error_msg = '';

// Check for form submission and action type
if (isset($_REQUEST['action']) && $_REQUEST['action'] == 'save') {
	if (isset($_FILES['pdf']['name']) && !empty($_FILES['pdf']['name'])) { // Check if a file was uploaded
	
		// Sanitize the uploaded file name
		$_FILES['pdf']['name'] = preg_replace("([^\w\s\d\-_~,;\[\]\(\).])", '', $_FILES['pdf']['name']);
		$_FILES['pdf']['name'] = preg_replace("([\.]{2,})", '', $_FILES['pdf']['name']);
	
		$file_info = pathinfo($_FILES['pdf']['name']); // Get the file extension
		$ext = strtolower($file_info['extension']);
		
/*		// Get the maximum file size allowed in bytes
		$maxFileSize = ini_get('upload_max_filesize');
		$maxFileSizeInBytes = return_bytes($maxFileSize);

		if (isset($maxFileSizeInBytes) && $_FILES['pdf']['size'] > $maxFileSizeInBytes) {
			$error_msg = "File size is too large. Maximum allowed size is " . $maxFileSize . ".";
		}

		// Function to convert php.ini size to bytes
		function return_bytes($val) {
			$val = trim($val);
			$last = strtolower($val[strlen($val) - 1]);
			switch ($last) {
				case 'g':
					$val *= 1024;
				case 'm':
					$val *= 1024;
				case 'k':
					$val *= 1024;
			}
			return $val;
		}
*/

		// Check if the file type is allowed
		if (in_array($ext, $allowed_types)) {
			$pdfname = preg_replace("/[^A-Za-z0-9_.-]+/", "", $_FILES['pdf']['name']);
					
		/*	// ALLOW RE-UPLOADS!  - THIS WORKED FINE, BUT PEOPLE CANNOT RENAME SCREENSHOTS, SO GOING TO GET COUNTRY FROM PROFILE NOW!
			$first3 = substr($pdfname, 0, 3); // GET FIRST CHARS
			$first3 = strtolower($first3);
			if ($first3 == 'fw9') $pdfname = 'fw9_'.$ID.'.'.$ext;
			if ($first3 == 'fw8') $pdfname = 'fw8ben_'.$ID.'.'.$ext;
		*/	
			
			// GET COUNTRY FROM PROFILE
			$selectFields = 'country';
			$mainTable = 'member_link';
			$where = [
				'ID' => ['=', $ID]
			];
			$show_debug = 1;
			$live = 1; // Assuming you want this operation to be executed live

			$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
			$buffer = isset($result[0]) ? $result[0] : null;

			if ($buffer['country'] == 'US') $pdfname = 'fw9_'.$ID.'.'.$ext;
			else $pdfname = 'fw8ben_'.$ID.'.'.$ext;
			$first3Chars = substr($pdfname, 0, 3);
	
			
			// COMMENTED COND, TO ALLOW CHANGED FILE TYPES - THEY FIRST TRIED PDF, THEN A PNG, ETC..
			//if(is_file($upload_path.$pdfname)) { // DELETE EARLIER RECORDS, WHEN THEY DO NEW UPLOAD!

			// DELETE ALL OLD W8, W9 FILES FOR THIS USER WHEN THEY UPLOAD A NEW ONE!
			foreach (glob($upload_path . 'fw9_'.$ID.'.*') as $file) {
				unlink($file);
			}
			foreach (glob($upload_path . 'fw8ben_'.$ID.'.*') as $file) {
				unlink($file);
			}				
			
			$table = 'pdf_files';
			$where = [
				'ID' => ['=', $ID]
			];
			$show_debug = 1;
			$live = 1; 
			$result = delete($table, [], $where, null, $live, 1, $show_debug);
				
			//}			
			/* // MY OLD
			// Move the uploaded file to the specified location		
			move_uploaded_file($_FILES['pdf']['tmp_name'], $upload_path.$pdfname);

			// Escape the pdf name for security
			$pdfname = htmlspecialchars($pdfname, ENT_QUOTES);

			// Insert the data into the database
			// IF REVERTING TO THIS SECTION USE SAME INSERT AS BELOW!
			$success = true;
		*/
			// Move the uploaded file to the specified location		
			move_uploaded_file($_FILES['pdf']['tmp_name'], $upload_path.$pdfname);

			// Check the uploaded PDF for required fields
			$error_msg = ''; // Ensure this variable is defined before the function call
			//$check_result = checkPDFFields($upload_path, $upload_path . $pdfname, $error_msg);
			$check_result = basicPDFCheck($upload_path, $error_msg);
			if (true || $check_result === true) {
				// inserting into database
				$table = 'pdf_files';
				$data = [
					'ID' => $ID,
					'username' => $uname,
					'type' => $first3Chars,
					'name' => $pdfname
				];
				$live = 1; // Assuming you want this operation to be executed live
				$show_debug = 1;

				$result_ins = insert($table, $data, $live, $show_debug);
				$success = true;
			}
		
		} else {
			$error_msg = "Error: unsupported file extension!";
		}
	} else {
		$error_msg = "Please choose a file to upload.";
	}
}

$selectFields = '*';
$mainTable = 'pdf_files';
$where = [
    'ID' => ['=', $ID]
];
$show_debug = 1;
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;

if ($buffer['auth_date'] == '0000-00-00') $status_msg = "Your file has been received, and is pending review.";
else if ($buffer['ID'] != '') $status_msg = "Your file has been received and approved!"; 

if ($success == true) { 
?>

<div class="alert alert-success" role="alert">
  <h1>File Uploaded Successfully!</h1>
  Do not reload this page.
</div>

<a href="tax_man.php" class="btn btn-info" target="_blank">Reset Form</a>

<a href="bankledger.php" class="btn btn-info" target="_blank">Return to Bank</a>

<?php
} else { // SHOW ERRORS IF ANY, AND FORM

	if ($status_msg != '') { ?>

	<div class="alert alert-success" role="alert">
	  <h1><?php echo $status_msg; ?></h1><h4>If you made an error, you may simply upload a new file.</h4><br>
	</div>

	<?php
	} 	
	if ($error_msg != '') { ?>

	<div class="alert alert-danger" role="alert">
	  <h1><?php echo $error_msg; ?></h1><br>
	</div>

	<?php
	} 	
	?>

<table style="width:600px; margin: auto;">
<tr>
<td>
<form action="<?php echo htmlspecialchars($_SERVER['PHP_SELF']); ?>" method="post" ENCTYPE="multipart/form-data">
<input type="hidden" name="action" value="save">

Add File:</td>
<td> <input name="pdf" type="file" class="form-control" size="35" id="pdf">
</td>
<td><input type="submit" value="Upload">
</form>
</td>
</tr>
</table> 
 
<br/><br/>
<a href="https://helpx.adobe.com/acrobat/using/signing-pdfs.html" class="btn btn-warning" target="_blank">More Info -- Sign PDF documents</a>

<a href="https://support.apple.com/lt-lt/guide/preview/prvw35725/mac#:~:text=Fill%20out%20a%20PDF%20form,form%2C%20then%20type%20your%20text." class="btn btn-warning" target="_blank">Fill out and sign a PDF form in Preview on Mac</a>


<?php 
} // END SUCCESS NOT TRUE
include $Global['path'].'Sub/tpl/footer_tpl.php'; ?>