<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php'; 
$pageName = ''; // THIS IS SHOWN AS A BREADCRUMB UNDER THE MENU, AND IS ALSO USED AS THE PAGE TITLE, IF $pageDesc IS LEFT EMPTY.
$pageDesc = ''; // IF USED, THIS IS SHOWN AS THE TITLE IN THE PAGE (BLUE BAR SECTION, END OF HEADER), REPLACING $pageName.
$pageIcon = 'fa fa-bullhorn'; // THE ICON USED IN THE PAGE
$pageAlign = 'center'; // HOW YOU WANT TO ALIGN THE PAGE CONTENT
$pageClass = ''; // FOR CUSTOM PROGRAMMING USES
$_SESSION['Returning'] = false; // DO NOT SHOW MENU TO NEW USERS
$paychain = true;

//$GLOBALS['debug'] = true;

if (is_email($_SESSION['loggedin'])) {
    //echo "$email1 is a valid email address.";
	// DO NOTHING, THEY CAN STAY
} else if ($_SESSION['loggedin'] != 'QQdemo' && $_SESSION['loggedin'] != 'testjim2') {
    //echo "$email1 is NOT a valid email address.";
	// LOG THEM OUT NOW!
	$url = 'logout.php';
	echo '<meta http-equiv="refresh" content="0; url='.$url.'">';
	exit;	
}



function password_strength($password) {
    $strength = 0;
    $length = strlen($password);
    $error_msg = "";

    // Check password length
    if ($length < 8) {
        $error_msg .= "Password must be at least 8 characters long.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains both upper and lower case characters
	if (!preg_match("/^(?=.*[a-z])(?=.*[A-Z])\S+$/", $password)) {
	//if (!preg_match("/^(?=.*[a-z])(?=.*[A-Z]).+$/", $password)) { // OLD WAY - ALLOWED SPACES
        $error_msg .= "Password must contain both uppercase and lowercase characters.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains numbers
    if (!preg_match("/^(?=.*\d).+$/", $password)) {
        $error_msg .= "Password must contain numbers.<br> ";
    } else {
        $strength += 1;
    }

    // Check if password contains symbols
    if (!preg_match("/^(?=.*[^a-zA-Z\d]).+$/", $password)) {
        $error_msg .= "Password must contain symbols.<br> ";
    } else {
        $strength += 1;
    }

    // Return password strength score and error message if any
    return array("strength" => $strength, "error_msg" => $error_msg);
}


$user_id = $_SESSION['UserID'];

$error_msg = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
	
	$result = password_strength($_POST['password']);
	
	// NOW CHECK TO MAKE SURE THIS REQUESTED USERNAME IS NOT SOMEONE ELSE'S USERNAME!
	$postUsername = isset($_POST['username']) ? $_POST['username'] : '';
	$selectFields = ['short'];
	$mainTable = 'campaigns';
	$where = ['short' => ['=', $postUsername]];
	$limit = 1;

	$resultmem = select($selectFields, $mainTable, [], $where, null, null, null, $limit, 1);
	$buffermem = $resultmem ? reset($resultmem) : null;
	
		
	if (isset($buffermem['short'])) $short_username = strtolower($buffermem['short']);
	else $short_username = '';
	
	$username = strtolower($_POST['username']);
	
	if (!empty($short_username) && $short_username == $username) { // WANTED USERNAME IS A SHORT URL!
		$error_msg = 'We\'re sorry, but your chosen username is not available.<br/>Please choose a new username.';
		} 
	elseif (empty($_POST['username'])) {
		$error_msg = 'Please choose a username.';
		}
	elseif (strlen($_POST['username']) > 20) {
		$error_msg = 'Username must be 20 characters or less.';
	}		
	elseif ($_POST['username'] != (preg_replace("/[^A-Za-z0-9]/", '', $_POST['username']))) {
		$error_msg = 'Please choose a valid username.<br>Only alphanumeric (letters and numbers) are allowed.';
		}
	elseif (empty($_POST['password'])) {
		$error_msg = 'Please choose a password.';
		}
	elseif (!empty($_POST['password']) && $result["strength"] === 4) {
		//echo "Password is strong!";
		} 
	elseif (!empty($_POST['password'])) {
		$error_msg = "Password is weak. Please correct the following issues:<br>" . $result["error_msg"];
	}
	elseif (strlen($_POST['password']) > 100) {
		$error_msg = 'Password must be 100 characters or less.';
	}	
	
		
	if ($error_msg == '' && $_POST['username'] != '') {
		
		$uname = htmlspecialchars($_POST['username']);
		//$lwr_uname = strtolower($uname); - uname may already be case sensitive
				
		$selectFields = ['Username'];
		$mainTable = 'members';
		$where = ['Username' => ['=', $uname]];

		$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
		if (isset($buffer)) unset($buffer);
		$buffer = $result ? reset($result) : null;
		
		
		if (!empty($buffer['Username'])) {
			$error_msg = 'Sorry that username already exists!<br>Please use a different username.';
		} else {		
		
			$hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);
			// Now you can use $hashedPassword for storing in the database
		
			$loggedInUser = isset($_SESSION['loggedin']) ? $_SESSION['loggedin'] : '';

			$dataToUpdate = [
				'Username' => $uname,
				'password' => $hashedPassword
			];
			$whereCondition = ['Username' => ['=', $loggedInUser]];

			update('members', $dataToUpdate, [], $whereCondition, 1, 1, 1);
			
			
			$sponsorIdData = ['sponsorid' => $uname];
			$whereSponsorId = ['sponsorid' => ['=', $loggedInUser]];

			update('members', $sponsorIdData, [], $whereSponsorId, 1, 1, 1);
			
			// CREATE NEW CAMPAIGN FOR NEW USER'S AFF SHORT URL			
			$postUsername = isset($_POST['username']) ? $_POST['username'] : '';
			$campCreateUrl = $Global['webpage_url_ssl'] . 'lc.php?id=' . $postUsername;

			$campaignData = [
				'status' => 1,
				'name' => 'My Affiliate Link',
				'url' => $campCreateUrl,
				'short' => $postUsername,
				'adtype' => 'url',
				'ID' => $user_id
			];
			// URL, name, subject, body, banners, ad_source cannot have DEFAULT values IN MYSQL due to their types, so they must be set here!
			$campaignData = [
				'status' => 1,
				'name' => 'My Affiliate Link',
				'url' => $campCreateUrl,
				'short' => $postUsername,
				'adtype' => 'url',
				'ID' => $user_id,
				// Ensure the specified fields have '' as default if missing
				'subject' => '',
				'body' => '',
				'banners' => '',
				'ad_source' => ''
			];
			

			insert('campaigns', $campaignData, 1, 1);
			
			
			// NEXT VAR SET UP FOR LOGOUT FILE
			$_SESSION['loggedin'] = $uname; 
			// LOG THEM OUT NOW!
			//unset($_SESSION);
			
			///////////////////////////////////////////////////////////			
			// 	CHANGE LOGIN SESSION NOW AND REDIRECT THEM TO PAY PAGE!
			///////////////////////////////////////////////////////////
			
			// GET THEIR NEW PROFILE INFO	
			$selectFields = '*';
			$mainTable = 'members';
			$where = ['Username' => ['=', $uname]];

			$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
			$buffer = isset($result[0]) ? $result[0] : null;			
				
			// NOW WE LOGIN THE MEMBER, AND SET UP THEIR SESSION VARS!
			// Fetching member_link information
			$selectFields = '*';
			$mainTable = 'member_link';
			$where = ['ID' => ['=', $buffer['ID']]];
			$mlnkinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
			$mlnkinfo = isset($mlnkinfoResult[0]) ? $mlnkinfoResult[0] : null;

			// Fetching sponsor's information from members
			//echo $buffer['sponsorid'];
			$mainTable = 'members';
						/*"Status != 'Cancelled'",*/
			$where = ['Username' => ['=', $buffer['sponsorid']]];
			$spnsinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
			$spnsinfo = isset($spnsinfoResult[0]) ? $spnsinfoResult[0] : null;

			// Fetching sponsor's member_link information
			$mainTable = 'member_link';
			$where = ['ID' => ['=', $spnsinfo['ID']]];
			$smlnkinfoResult = select($selectFields, $mainTable, [], $where, null, null, null, 1, 1);
			$smlnkinfo = isset($smlnkinfoResult[0]) ? $smlnkinfoResult[0] : null;

			//if (isset($_SESSION['status_check'])) unset($_SESSION['status_check']);
			//unset($_SESSION['captcha']);

			$_SESSION['loggedin'] = $buffer['Username'];
			//$_SESSION['password'] = $buffer['Password'];

			$_SESSION['Firstname_loggedin'] = $buffer['First_Name'];
			$_SESSION['Lastname_loggedin'] = $buffer['Last_Name'];
			//$_SESSION['SponsorID'] = $buffer['Username'];
			$_SESSION['UserID'] = $buffer['ID'];
			$_SESSION['Email_loggedin'] = $buffer['email'];
			$_SESSION['Phone_loggedin'] = $mlnkinfo['phone'];

			//Used for JV status only
			//$_SESSION['Status'] = $buffer['Status'];

			// MAYBE OVERKILL, LEAVING OUT FOR NOW!
			/*$_SESSION['affiliate_status'] = $buffer['affiliate_status'];
			$_SESSION['customer_status'] = $buffer['customer_status'];

			$_SESSION['Address'] =  $mlnkinfo['address'];
			$_SESSION['Address2'] =  $mlnkinfo['address2'];
			$_SESSION['City'] =  $mlnkinfo['city'];
			$_SESSION['State'] =  $mlnkinfo['state'];
			$_SESSION['Province'] = $buffer['province'];
			$_SESSION['Zip'] =  $mlnkinfo['zip'];
			$_SESSION['Country'] =  $mlnkinfo['country'];*/

			$_SESSION['RefFirstname'] = $spnsinfo['First_Name'];
			$_SESSION['RefLastname'] = $spnsinfo['Last_Name'];
			$_SESSION['RefSponsorID'] = $spnsinfo['Username'];
			$_SESSION['RefUserID'] = $spnsinfo['ID'];
			$_SESSION['RefEmail'] = $spnsinfo['email'];
			$_SESSION['RefPhone'] = $smlnkinfo['phone'];

			$_SESSION['ulogin'] = 1; // NOT SURE THIS IS NEEDED? IF NOT, AX IT.
			// ALREADY DONE ON login-check-enrollee.php
			//log_login($_POST['login'], true, $buffer);

			//Anyone logging in from this page is NOT returning!
			//$_SESSION['Returning'] = true;

			// ADVANCE TO PAY PAGE!
			header("Location: " . $GLOBALS['webpage_url_ssl'] . "apay/pay.php?program=1");
			exit;
		} // END UPDATE
	} // END NO ERROR
} // END POST


include './header.php';
echo '<div class="clearfix"></div>';
//print_r($_SESSION);
?>
<div class="row">
<div class="col-md-2" style="background-color: #;">
&nbsp;
</div>
		
		<div class="col-xs-12 col-md-8" style="background-color: #ffffff; text-align:center; margin: 10 auto;">
		<p>&nbsp;</p>	
		<h3>Pick A Username / Password</h3>
		
		<h4>Your username will be shown in your affiliate link, so choose wisely.</h4>

		<h4>Your password must be at least 8 characters long, and contain both uppercase and lowercase characters, numbers and symbols. Spaces are not allowed.</h4>

		<h3 style="color:red">Please make note of your new username and password right now!</h3>
		
	<?php if ($error_msg != '') { ?>
    <div class="alert alert-danger" role="alert">
        <h3><?php echo $error_msg; ?></h3>
    </div>
	<?php } ?>		
		
		<p>&nbsp;</p>

<form method="POST" action="username-setup.php" name="myForm">					

Username
<input class="form-control" size="50" name="username" id="username" placeholder="My Username" value="<?php echo isset($_POST['username']) ? htmlspecialchars($_POST['username']) : ''; ?>">
<p></p>

Password
<input class="form-control" size="50" type="password" name="password" id="passwordField" placeholder="My Password" value="<?php echo isset($_POST['password']) ? htmlspecialchars($_POST['password']) : ''; ?>">

		<div class="input-group-append">
			<span class="input-group-text">
				<input type="checkbox" id="showPasswordCheckbox"/>&nbsp; <a href="#" id="showPasswordLink">Show</a>
			</span>
		</div>

<p>&nbsp;</p>
<input type="submit" value="Finish Set Up" name="Update Settings" id="submit" class="btn btn-info btn-default">
</form>

<p></p>

</div>

<!-- MUST LEAVE OUT OR IT DOES NOT WORK IN MOBILE!!!!
<div class="col-md-2" style="background-color: #ffffff;">
&nbsp;
</div>
-->
</div>

<script>
    const showPasswordLink = document.getElementById('showPasswordLink');
    const showPasswordCheckbox = document.getElementById('showPasswordCheckbox');
    
    showPasswordLink.addEventListener('click', function(event) {
        event.preventDefault(); // Prevent anchor from navigating
        
        showPasswordCheckbox.checked = !showPasswordCheckbox.checked; // Toggle checkbox
        updatePasswordFieldVisibility();
    });
    
    showPasswordCheckbox.addEventListener('change', function() {
        updatePasswordFieldVisibility();
    });
    
    function updatePasswordFieldVisibility() {
        const passwordField = document.getElementById('passwordField');
        
        if (showPasswordCheckbox.checked) {
            passwordField.type = 'text'; // Show password
        } else {
            passwordField.type = 'password'; // Hide password
        }
    }
</script>
<?php 
include './footer.php';
?>