<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './logincheck.php';

$hide_type_column_on_viewpayment = true;
	
$pageName = 'View Earnings';
$pageDesc = '';
$pageIcon = 'fa fa-money';
$pageAlign = 'center';
$pageClass = '';
	
//Select the correct program	
if (!empty($_GET['program']) && intval($_GET['program']) > 0) $Global['program'] = intval($_GET['program']);
elseif (!empty($_SESSION['program']) && intval($_SESSION['program']) > 0) $Global['program'] = intval($_SESSION['program']);
else $Global['program'] = $Global['default_program'];
	
$_SESSION['program'] = $Global['program'];

//make sure they have a program they want to view
if (!isset($Global['program']) || intval($Global['program']) < 1) {
	header("Location: ./programview.php");
	exit;
}

// IF THIS PROGRAM IS DEFINED AS A MATRIX, WE WILL SHOW MATRIX QUERIES
if (in_array($Global['program'], $Global['matrix_program_id_array'])) {
	$use_transactions_log = true;
}
	
//Get the program info
$selectFields = '*';
$mainTable = 'program';
$where = [
    'program_id' => ['=', $Global['program']],
    'program_approved' => ['=', 'Y'],
    'program_id' => ['NOT IN', $Global['program_restrict']] 
];
$show_debug = 1;

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;


//if the program does not exist, send the user back
if (empty($buffer['program_id'])) {
	header("Location: ./programview.php");
	exit;
}

$Global['program_name'] = $buffer['program_name'];	
$Global['header'] = $buffer['header_file'];
$Global['footer'] = $buffer['footer_file'];

if ($buffer['program_collect'] == 'A') $admin_collects = true;
else $admin_collects = false;

//Select the user ID of the loggedin user
$selectFields = 'prog.user_program_id';
$mainTable = ['table' => 'members', 'as' => 'memb'];
$joinConditions = [
    ['table' => 'user_program', 'as' => 'prog', 'condition' => 'memb.ID = prog.ID']
];
$where = [
    'memb.Username' => ['=', $_SESSION['loggedin']],
    'prog.program_id' => ['=', $Global['program']]
];
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;
$user_program_id = $buffer['user_program_id'];

include './../Sub/tpl/'.$Global['header'];

///*
$cc_fee = substr($Global['cc_fee_rate'], 2);

if ($Global['use_bank'] == true && $cc_fee > .01) {
echo '<div style="font-size:14pt; color: red"><i>
*Please note that all commissions processed by Admin will reflect the '.$cc_fee.'0% processing fee
<br/>and be released into your ',$Global['webpage_name'].' "bank" after '.$Global['cc_grace'].' days.
</div></i>';
}
//*/
echo '<h2>'.$Global['program_name'].' Commissions Earned</h2><br/>';

//Select all programs 
$selectFields = '*';
$mainTable = 'program';
$where = [
    'program_approved' => ['=', 'Y'],
    'program_id' => ['NOT IN', $Global['program_restrict']]
];
$orderBy = 'program_id ASC';
$show_debug = 1;

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, $show_debug);

$program_info = '<option value="0">Select A Program Below</option>';

foreach ($result as $buffer) {
	if (!empty($Global['program']) && $Global['program'] == $buffer['program_id']) $selected = ' selected';
	elseif (!empty($Global['program']) && intval($Global['program']) == $buffer['program_id']) $selected = ' selected';
	else $selected = '';
		
	//$program_info .= '<option value="'.$buffer['program_id'].'"'.$selected.'>'.$buffer['program_name'].'</option>';

	// QQQ PROGRAM SELECT NAME COMBINED FOR TRANSACTIONS LOGS PROGRAMS, SINCE THAT TABLE DOES NOT USE PROGRAM ID
	if (in_array($buffer['program_id'], $Global['matrix_program_id_array'])) continue;
	else $program_info .= '<option value="'.$buffer['program_id'].'"'.$selected.'>'.$buffer['program_name'].'</option>';
}
	
echo '<div class="row">';
echo '<!--';
echo '<div class="col-md-3 col-sm-3">&nbsp;</div>';
echo '-->';
echo '<div class="col-md-6 col-sm-6" style="text-align:right; margin-left:-30px">';
echo '<form enctype="multipart/form-data" method="get" action="viewpayment.php">';
echo '<select name="program" class="form-control">' . $program_info . '</select>';
echo '</div>';

echo '<div class="col-md-3 col-sm-3" style="text-align:left;">';
echo '<input type="submit" value="View Program" name="submit" class="form-control btn btn-info">';
echo '</form>';
echo '</div>';

echo '<div class="col-md-3 col-sm-3">&nbsp;</div>';
echo '</div>';
echo '<br/>';


if ($admin_collects === false) {
    echo '<table class="table table-bordered">';
    echo '<thead><tr>';
    echo '<th class="smallheader" style="text-align: center; width: 110px;"><strong>Status:</strong></th>';
    echo '<th class="smallheader" style="text-align: center; width: 170px;"><strong>Payment Date:</strong></th>';
    echo '<th class="smallheader" style="text-align: center; width: 150px;"><strong>Collection Method:</strong></th>';
    echo '<th class="smallheader" style="text-align: center; width: 80px;"><strong>Amount:</strong></th>';
    echo '<th class="smallheader" style="text-align: center; width: 150px;"><strong>Paid by:</strong></th>';
    echo '</tr></thead><tbody>';
} else {
    if ($use_transactions_log == false) {
        echo '<table class="table table-bordered" style="width: 100%;">';
        echo '<thead><tr>';
        echo '<th class="smallheader" style="text-align: center; width: 110px;"><strong>Status:</strong></th>';
        echo '<th class="smallheader" style="text-align: center; width: 170px;"><strong>Member Payment Date:</strong></th>';
        echo '<th class="smallheader" style="text-align: center; width: 80px;"><strong>Amount:</strong></th>';
        echo '<th class="smallheader" style="text-align: center; width: 150px;"><strong>Paid by:</strong></th>';
        echo '</tr></thead><tbody>';
    } else {
        echo '<table class="table table-bordered">';
        echo '<thead><tr>';
        echo '<th class="smallheader" style="text-align: center; width: 110px;"><strong>Status:</strong></th>';
        echo '<th class="smallheader" style="text-align: center; width: 110px;"><strong>Earned Date:</strong></th>';
        echo '<th class="smallheader" style="text-align: center; width: 80px;"><strong>Amount:</strong></th>';
        echo '<th class="smallheader" style="text-align: center; width: 250px;"><strong>Description:</strong></th>';
        echo '</tr></thead><tbody>';
    }
}





if ($hide_type_column_on_viewpayment == false) echo '<td align="center" width="200px" class="smallheader"><strong>Type:</strong></td>';
echo '</tr>';

if ($use_transactions_log == true) {
	$selectFields = '*';
	$mainTable = 'transactions_log';
	$where = [
		'transtype' => ['=', 'COMM'],
		'usrid' => ['=', $_SESSION['UserID']]
	];
	$orderBy = 'logdate DESC';
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, $show_debug);

	foreach ($result as $buffer) {
		$logdate = date('F, jS Y',strtotime($buffer['logdate']));
		$amount = number_format($buffer['amount'],2);
		echo '<tr><td align="center">' . $buffer['pay_status'] . '</td><td align="center">' . $logdate . '</td><td align="center">$' . $amount . '</td><td align="left">' . $buffer['description'] . '</td></tr>';
	}

	echo '</table><br /><br />';	
	include './../Sub/tpl/'.$Global['footer'];
	exit;	
} // END IF BINARY OR MATRIX

//Select all programs 
if (isset($Global['program_to_store'][$Global['program']])) {
    $selectFields = 'log.*, plan.payment_type, plan.payment_tier_level, master.order_id';
    $mainTable = ['table' => 'payment_log', 'as' => 'log'];
    $joinConditions = [
        ['table' => 'payment_plan', 'as' => 'plan', 'condition' => 'log.payment_plan_id = plan.payment_plan_id'],
        ['table' => 'user_payment_plan', 'as' => 'master', 'condition' => 'plan.user_payment_plan_id = master.user_payment_plan_id']
    ];
    $where = [
        'log.user_program_id' => ['=', $user_program_id]
    ];
    $orderBy = 'payment_log_id DESC';
    $show_debug = 1;

    $result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, $show_debug);
} else {
    $selectFields = 'log.*, plan.payment_type, plan.payment_tier_level';
    $mainTable = ['table' => 'payment_log', 'as' => 'log'];
    $joinConditions = [
        ['table' => 'payment_plan', 'as' => 'plan', 'condition' => 'log.payment_plan_id = plan.payment_plan_id']
    ];
    $where = [
        'log.user_program_id' => ['=', $user_program_id],
        'log.cc_pending' => ['!=', 'Z']
    ];
    $orderBy = 'timestamp DESC';
    $show_debug = 1;

    $result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, $show_debug);
}


foreach ($result as $buffer) {
	//The status of the payment
	if ($buffer['chargeback'] == 'Y') $status = '<font color="red">Refunded</font>'; 
	elseif ($buffer['cc_pending'] == 'Y') $status = '<font color="blue">Pending Period</font>'; 

	elseif ($buffer['cc_pending'] == 'A') $status = '<font color="blue">Awaiting Payout</font>'; 

	elseif ($buffer['cc_pending'] == 'N') $status = '<font color="green">Received</font>';

	$payment_date = date('F, jS Y', $buffer['timestamp']);
	
	$payment_processor = $buffer['payment_processor'] ?? '';

	if ($payment_processor == 'E4') $payment_processor = 'First Data';
	if ($payment_processor == '' || $payment_processor == 'C') $payment_processor = 'Funds Received Outside Program';
	
	if ($buffer['payment_processor'] == 'BK') $bank = 'Bank';
	else $bank = '';

	if ($buffer['collected_by'] == 'admin') $payment_processor = '<span style="color:green">'.$Global['webpage_name'].' '.$bank.'</span>';
	
	$amount = number_format($buffer['amount'], 2);
	
	if ($buffer['payment_type'] == 'PT') $type = 'Powerline and Tier Level '.$buffer['payment_tier_level'];
	elseif ($buffer['payment_type'] == 'P') $type = 'Powerline';
	elseif ($buffer['payment_type'] == 'T') $type = 'Tier Level '.$buffer['payment_tier_level'];
	else $type = 'Administrator Fee';
	
	$selectFields = 'First_Name, Last_Name';
	$mainTable = 'members';
	$where = [
		'Username' => ['=', $buffer['payer_username']]
	];
	$show_debug = 1;

	$result_name = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
	$buffer_name = isset($result_name[0]) ? $result_name[0] : null;
	
	//Display the payment information
	if ($admin_collects === false) {
		echo '<tr><td align="center">' . $status . '</td><td align="center">' . $payment_date . '</td><td align="center">' . $payment_processor . '</td><td align="center">$' . $amount . '</td><td align="center">' . $buffer_name['First_Name'] . ' ' . $buffer_name['Last_Name'] . ' (' . $buffer['payer_username'] . ')</td></tr>';
	} else {
		echo '<tr><td align="center">' . $status . '</td><td align="center">' . $payment_date . '</td><td align="center">$' . $amount . '</td><td align="center">' . $buffer_name['First_Name'] . ' ' . $buffer_name['Last_Name'] . ' (' . $buffer['payer_username'] . ')</td></tr>';
	}


	if ($hide_type_column_on_viewpayment == false) echo '<td align="center">'.$type.'</td>';
	echo '</tr>';

	if (isset($Global['program_to_store'][$Global['program']])) {
				
		echo '<tr><td colspan="4">&nbsp;</td></tr>';
		
		$selectFields = 'link.order_amount, link.product_name';
		$mainTable = ['table' => 'order_link', 'as' => 'link'];
		$joinConditions = [
			['table' => 'product', 'as' => 'prod', 'condition' => 'link.product_id = prod.product_id']
		];
		$where = [
			'link.orders_id' => ['=', $buffer['order_id']]
		];
		$show_debug = 1;
		$result_order = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);

		foreach ($result_order as $order_buffer) {
			echo '<tr><td align="center" colspan="2">Product: ' . $order_buffer['product_name'] . '</td><td align="center" colspan="2">Units Purchased: ' . $order_buffer['order_amount'] . '</td></tr>';
		}

		echo '<tr><td colspan="4">&nbsp;</td></tr>';
	}
} // END FOREACH

echo '</table><br /><br />';
	
include './../Sub/tpl/'.$Global['footer'];
?>