<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
/*
// UPDATE CONFIG FILE SET THIS TO true!!!!!!!!
$allow_mark_payments = $Global['allow_mark_payments']; 
$Global['allow_unqualified_markers'] == true -- make sure this is set!!!!!!
*/

/*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//$_SESSION['UserID'] = 81; // FOR TESTING ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
*/
include 'logincheck.php';
include $Global['path'].'Pagination.function.php';
//include './../Pagination.function.php';
$pageName = 'View Team';
$pageDesc = 'View Team / Search Team';
$pageIcon = 'fa fa-sitemap';
$pageAlign = 'center';
$pageClass = 'leads'; // UPDATE THIS AND HEADER FOR DATE PICKER!! (DEFINE NEW CLASS NAME 'datepicker')
//include 'header.php';
$ID = $_SESSION['UserID'];

if (isset($_GET['program'])) $program_id = $_GET['program'];
else $program_id = 1;

$selectFields = 'giveaway_file';
$mainTable = ['table' => 'program', 'as' => 'p'];
$where = [
    'p.program_id' => ['=', $program_id]
];
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$buffer = isset($result[0]) ? $result[0] : '';

if ($buffer['giveaway_file'] == 'Mat.give.php') $program_is_matrix = true;
else $program_is_matrix = false;

//OLD WAY
//$program_is_matrix = true;
//$program_is_matrix = false;

if ($_SERVER['REQUEST_METHOD'] != 'POST') {
	$_SERVER['REQUEST_METHOD'] = 'POST';
	$_REQUEST['program'] = 1;
}	

$bypass_teamview = false; // INITIALIZE VAR
//$debug = false;
//$debug = true;

//if ($_SESSION['loggedin'] == 'brandon4nwc') $debug = true;

$allow_mark_payments = $Global['allow_mark_payments']; // SEE BELOW FOR ADDT'L SETTINGS. IF NOT QUALIFIED, THIS IS RESET TO FALSE
	
if (!isset($_REQUEST['rating'])) $_REQUEST['rating'] = "all";
if (!isset($_REQUEST['dateway'])) $_REQUEST['dateway'] = "all";
if (!isset($_REQUEST['start_date'])) $_REQUEST['start_date'] = '';
if (!isset($_REQUEST['end_date'])) $_REQUEST['end_date'] = '';
if (!isset($_REQUEST['timetocall'])) $_REQUEST['timetocall'] = '';

$_REQUEST['powerlines'] = $_REQUEST['powerlines'] ?? '';
$_REQUEST['aboutme'] = $_REQUEST['aboutme'] ?? '';
$_REQUEST['address'] = $_REQUEST['address'] ?? '';
$_REQUEST['Username'] = $_REQUEST['Username'] ?? '';
$_REQUEST['find'] = $_REQUEST['find'] ?? '';
$find = $find ?? '';
$_REQUEST['way'] = $_REQUEST['way'] ?? '';
$_REQUEST['colname'] = $_REQUEST['colname'] ?? '';
$_REQUEST['markedpaid'] = $_REQUEST['markedpaid'] ?? '';
$_REQUEST['interest'] = $_REQUEST['interest'] ?? '';
$_REQUEST['timezone'] = $_REQUEST['timezone'] ?? '';
$_REQUEST['country'] = $_REQUEST['country'] ?? '';

$way = $_REQUEST['way'] ?? '';
$colname = $_REQUEST['colname'] ?? '';

$cp_headline = $cp_headline ?? '';
$awaiting_payment_headline = $awaiting_payment_headline ?? '';


$whereMain['AND'] = '';	

	// QQQ EXPAND SEARCH
	if ($colname == 'address') {
		// CREATE OPTIONS TO SEARCH ALL RELATED ADDRESS FIELDS
	}

	$whereMain = []; // Initialize the where condition array	
	//if ($colname == 'choose') $colname = 'ip';
	
	// Condition when 'way' is 1, specific column and find value are provided
	if ($way == 1 && $colname != '' && $find != '') {
		if ($colname != 'choose') $whereMain['AND'][$colname] = ['=', $find];

	} else if ($colname != '' && $find != '') {
		if ($colname != 'choose') $whereMain['AND'][$colname] = ['LIKE', "%$find%"];
	} 	

	$start_date = isset($_REQUEST['start_date']) ? $_REQUEST['start_date'] : '';
	$end_date = isset($_REQUEST['end_date']) ? $_REQUEST['end_date'] : '';
	
	//print_r($_REQUEST); exit;

	// DEFINE START DATES & DATE SEARCH TYPES
	if (isset($_REQUEST['dateway']) && $_REQUEST['dateway'] == 'on') {
		// WILL NOT WORK ON = Signdate - as it is a datetime (not date) field!!
		$date_type = 'm.Signdate';
		if ($end_date !== '') {
			$whereMain['AND']['m.Signdate'] = ['<=', $end_date];
		}
	} else if (isset($_REQUEST['dateway']) && $_REQUEST['dateway'] == 'from') {
		$date_type = 'm.Signdate';
		if ($start_date !== '') {
			$whereMain['AND'][]['m.Signdate'] = ['>=', $start_date];
		}
		if ($end_date !== '') {
			$whereMain['AND'][]['m.Signdate'] = ['<=', $end_date];
		}
	}
	//
	//$whereMain = array_merge($whereMain, $whereMain2);
	
//echo 'STATUS!';
//echo $bystatus;
//print_r($_REQUEST);
//print_r($whereMain); exit;
////////////////////////////////////////////////////////////////////////
// END SEARCH FEATURES
////////////////////////////////////////////////////////////////////////

//Select all programs
$where = ['AND' => ['program_approved' => 'Y']];
if (isset($Global['program_restrict']) && $Global['program_restrict'] != '') {
    $where['AND']['program_id'] = ['NOT IN', $Global['program_restrict']];
}

$orderBy = 'program_up_pay ASC';
$programs = select('program_id, program_name', 'program', [], $where, null, null, $orderBy, 0, 1);

$program_info = '<option value="-1">Select a program</option>';
if ($program_id == 0) {
    $program_info .= '<option value="0" selected>All Programs</option>';
} else {
    $program_info .= '<option value="0">All Programs</option>';
}

if (is_array($programs)) {
    foreach ($programs as $buffer) {
        $selected = ($program_id == $buffer['program_id']) ? ' selected' : '';
        $program_info .= '<option value="'.$buffer['program_id'].'"'.$selected.'>'.htmlentities($buffer['program_name']).'</option>';
    }
}

//SHOW MEMBERS BY STATUS
if (!empty($_REQUEST['status'])) $selected = ' selected';
else $selected = '';
$options = '<option value="All"'.((!empty($selected) && $_REQUEST['status'] == 'All')?$selected:'').'>All Status Types</option>';
$options .= '<option value="Active"'.((!empty($selected) && $_REQUEST['status'] == 'Active')?$selected:'').'>Active</option>';
$options .= '<option value="Unpaid"'.((!empty($selected) && $_REQUEST['status'] == 'Unpaid')?$selected:'').'>Unpaid</option>';
$options .= '<option value="Suspended"'.((!empty($selected) && $_REQUEST['status'] == 'Suspended')?$selected:'').'>Suspended</option>';
$options .= '<option value="Cancelled"'.((!empty($selected) && $_REQUEST['status'] == 'Cancelled')?$selected:'').'>Cancelled</option>';
$options .= '<option value="Comped"'.((!empty($selected) && $_REQUEST['status'] == 'Comped')?$selected:'').'>Comped</option>';


if (isset($_REQUEST['powerlines'])) {
	// FORCE A PROGRAM FOR POWERLINES
	if (!isset($_REQUEST['program']) || $_REQUEST['program'] == 0) $_REQUEST['program'] = 1;
}
//Select the correct program
if (isset($_REQUEST['program'])) {
	if ($_REQUEST['program'] == 'All') $Global['program'] = 1;
	else $Global['program'] = $_REQUEST['program'];
//} else if (!empty($_SESSION['program'])) {
	//$Global['program'] = $_SESSION['program'];
} else {
	$Global['program'] = 1;
}
$_SESSION['program'] = $Global['program'];

if (in_array($Global['program'], $Global['program_restrict'])) {
    $Global['program'] = 1;
}

if (is_numeric($Global['program']) && $Global['program'] > 0) {
	//Get the program info
	$where = [
		'program_id' => ['=', $Global['program']],
		'program_approved' => ['=', 'Y']
	];

	$result = select('*', 'program', [], $where, null, null, null, 0, 1);
	$buffer = !empty($result) ? $result[0] : null;
	
	$Global['program_type'] = $buffer['program_type'];
	$Global['program_name'] = $buffer['program_name'];
	$Global['up_powerline'] = $buffer['program_up'];
	$powerline_order_comma_sep = $buffer['program_up_order'];
	$Global['powerline_order'] = explode(',', $buffer['program_up_order']);
	$Global['require_pass_ups_to_admin'] = $buffer['require_pass_ups_to_admin'];
	$Global['pass_ups_to_admin'] = explode(',', $buffer['pass_ups_to_admin']);
	$Global['tier_level'] = $buffer['program_tier'];
	$Global['pass_up_every_nth'] = $buffer['pass_up_every_nth'];

	if (empty($Global['powerline_order'])) $Global['powerline_order'] = [0];

	//Find out if you have an active subscription to this program
	$selectFields = 'prog.user_status, prog.user_qualify, prog.user_qualify_perm';
	$mainTable = ['table' => 'user_program', 'as' => 'prog'];
	$joinConditions = [
		['table' => 'members', 'as' => 'memb', 'condition' => 'memb.ID = prog.ID']
	];
	$where = [
		'memb.Username' => ['=', $_SESSION['loggedin']],
		'prog.program_id' => ['=', $Global['program']]
	];
	$show_debug = 1;
	$live = 1;

	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);
	$bufferq = isset($result[0]) ? $result[0] : null;
	
	if ($Global['up_powerline'] > 0) {
		
		$selectFields = 'sign_id';
		$mainTable = 'user_program';
		$where = [
			'sponsorid' => ['=', $_SESSION['loggedin']],
			'user_status' => ['NOT IN', ['Cancelled', 'Unpaid']],
			'program_id' => ['=', $Global['program']],
			'sign_id' => ['IN', explode(',', $powerline_order_comma_sep)]
		];
		$show_debug = 1;

		$verify_qualify_result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);

		$member_qualify = min($Global['up_powerline'], count($verify_qualify_result) + max(0, $bufferq['user_qualify_perm']));
		
		//echo 'Q'.$member_qualify; exit;
		
	} else {
		$member_qualify = 0;
	}

	// IF A REVERSE PASS UP SYSTEM, WE DISABLE ABILITY TO MARK PAYMENTS UNTIL QUALIFIED, TO STOP USERS STACKING ACCOUNTS TO BYPASS PASSING UP SALES!
	if ($member_qualify !=0 && $member_qualify < $Global['up_powerline'] && ($_SESSION['admin_session_view'] != true && $_SESSION['loggedin'] != 'admin')) $allow_mark_payments = false;
	
	// MATRIX ONLY - DO NOT ALLOW MARK PAYMENTS
	if ($program_is_matrix == true) $allow_mark_payments = false;
	
	if ($member_qualify >= $Global['up_powerline']) $qualify_text = '<span style="color: green;">You are fully qualified.</span>';
	else if ($member_qualify > 0)	$qualify_text = '<span style="color: #F00;">You need to pass up '.($Global['up_powerline'] - $member_qualify) .' more sale(s).</span>';
	else $qualify_text = '<span style="color: #F00;">You need to pass up '.$Global['up_powerline'] .' sale(s).</span>';

	if ($member_qualify >= $Global['up_powerline']) $loggedin_user_can_qualify_team = true;
	else $loggedin_user_can_qualify_team = false;

	//if ($Global['pass_up_every_nth'] > 0) $qualify_text = ""; // DO NOT PRINT QUALIFY STATUS IF REQUIRE UNLIMITED PASSUPS
	//else if ($member_qualify < $Global['up_powerline']) $qualify_text .= " NOTE: Cancelled Passups Do Not Count Toward The Passup Requirement."; // ONLY SHOW IF PASS UP EVERY NTH IS 0 AND NOT QUALIFIED

	// MATRIX KLUDGE - DO NOT SHOW $qualify_text
	if ($program_is_matrix == true) $qualify_text = '';

	// HIDING FOR MATRIX PROGRAM
	if ($program_is_matrix != true) {
		if ($bufferq['user_status'] == 'Cancelled' || $bufferq['user_status'] == 'Suspended' || $bufferq['user_status'] == 'Unpaid') {
			$qualify_text = '<span style="color: #F00;">You are currently '.$bufferq['user_status'].' in this program!<br/><a href="../apay/pay.php?program='.$Global['program'].'">Make payment now to Activate your account</a></span>';
		}
	}

} else {
	$Global['program_name'] = 'All Programs';
}


// OVERRIDE SETTING - ALWAYS LEAVE TRUE (IF USING) - TOO MANY COMPLICATIONS OTHERWISE. ANYWAY IT DOES NOT MATTER SINCE THE PAY PAGE HAS IT'S OWN CHECKS IN PLACE, TO ENSURE USERS CANNOT MARK THEIR UPLINES PAY PLANS - THEY CAN ONLY MARK THEIR OWN
$allow_mark_payments = false;

// OVERRIDE SETTING, NOW IF NEEDED
if ($Global['allow_unqualified_markers'] == true) {
	$allow_mark_payments = true;
}
// QQQ ALWAYS LEAVE TRUE
$allow_mark_payments = true;

// MATRIX SYSTEM
if ($program_is_matrix == true) $allow_mark_payments = false;

if ($allow_mark_payments == true && $_GET['markpaid'] != '') {
	include './../Sub/tpl/header_tpl.php';
	
	echo '<br/><h1 style="color:red">Before You Continue...<h1><h3>
	NOTE: <span style="color:gray;">Only mark "custom payments" received, -- 
	<br/>payments which you collected outside of our website
	</br>(cash, check, money order, etc.)<br/>';

	if ($Global['program_type'] == 'S') echo '<br/>Each time you mark a payment received, you extend that member\'s subscription by another 30 days.<br/>';

	echo '</span></h3><br/>';
	
	$program = urlencode($_GET['program']);
	$userid = urlencode($_GET['userid']);
	$markpaid = urlencode($_GET['markpaid']);
	$program_name = htmlspecialchars($Global['program_name'], ENT_QUOTES, 'UTF-8');

	// 5.6 way
	//echo '<a href="../apay/pay.php?program=' . $program . '&userid=' . $userid . '" class="btn btn-success">Continue the process to mark ' . $markpaid . ' paid in ' . $program_name . '</a>';
	
	echo '<a href="../apay/pay.php?program=' . $program . '&uname=' . $markpaid . '" class="btn btn-success">Continue the process to mark ' . $markpaid . ' paid in ' . $program_name . '</a>';	
		
	echo '<br/><br/><a href="javascript:window.close();">Close this window to return to my team view</a>';	
	
	//Awaiting Admin Payment
	
	include './../Sub/tpl/footer_tpl.php';
	exit;
}


///////////////////////
// MARKING UNPAID!!!!!!
////////////////////////
/*
if ($allow_mark_payments == true && $_GET['markunpaid'] != '') {
	include './../Sub/tpl/header_tpl.php';
	
	// GET USER PROG ID OF THE PERSON WE WANT TO MARK UNPAID
	$selectFields = 'user_program_id';
	$mainTable = ['table' => 'user_program', 'as' => 'u'];
	$joinConditions = [
		['table' => 'members', 'as' => 'm', 'condition' => 'm.ID = u.ID']
	];
	$where = [
		'm.Username' => ['=', $_GET['markunpaid']],
		'u.program_id' => ['=', $_GET['program']]
	];
	$show_debug = 1;

	$result_dl_uprog = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);
	$buffer_dl_uprog = isset($result_dl_uprog[0]) ? $result_dl_uprog[0] : null;
	
	$user_program_id = $buffer_dl_uprog['user_program_id'];
	
	if ($debug == true) { 
		echo '<br>PRINT R BUFFER: ';
		print_r($buffer_dl_uprog);
		echo '<br>';
	}	
	
	// SELECT THE USER PAYMENT PLAN ///////////////////////////////////////////////////////////////////
	$result_upp = mysql_query("SELECT user_payment_plan_id, valid_plan, real_sponsorid FROM user_payment_plan WHERE user_program_id='{$user_program_id}' AND valid_plan!='H' ORDER BY valid_plan ASC, user_payment_plan_id DESC LIMIT 1") or die(mysql_error());
	$buffer_upp = mysql_fetch_assoc($result_upp);
	
	if ($debug == true) { 
		echo '<br>PRINT R BUFFER: ';
		print_r($buffer_upp);
		echo '<br>';
	}

	$valid_plan = $buffer_upp['valid_plan'];
	$user_payment_plan_id = $buffer_upp['user_payment_plan_id'];


	// SELECT THE PAYMENT PLAN PAYING THE LOGGEDIN USER /////////////////////////////////////////////////////////////
	$qry_pp = "SELECT pp.*,m.payment_collected_by FROM payment_plan as pp JOIN members as m ON (pp.username=m.Username) WHERE pp.user_payment_plan_id='{$user_payment_plan_id}' AND m.Username='".$_SESSION['loggedin']."' ORDER BY pp.payment_plan_id ASC";
	//echo "<br/>".$qry."<br/>";
	$result_pp = mysql_query($qry_pp) or die($qry_pp.' '.mysql_error());
	$buffer_pp = mysql_fetch_assoc($result_pp);	
	if ($debug == true) { 
		echo '<br>PRINT R BUFFER: ';
		print_r($buffer_pp);
		echo '<br>';
	}
	$payment_plan_id = $buffer_pp['payment_plan_id'];
	
	//if ($valid_plan == 'S' && $buffer['payment_complete'] == 'Y') {
	//}

	// NOW CHECK CUSTOM PLANS
	$qry_cp = "SELECT 
	ucp.*,
	FROM_UNIXTIME(master.timestamp_started) as started,
	FROM_UNIXTIME(ucp.last_payment) as last,
	FROM_UNIXTIME(ucp.next_payment) as next
	FROM payment_plan as pp
	JOIN user_custom_plan as ucp 
	JOIN user_payment_plan as master 
	WHERE pp.user_payment_plan_id=master.user_payment_plan_id 
	AND pp.username='".mysql_real_escape_string($_SESSION['loggedin']."'
	AND ucp.payment_plan_id=pp.payment_plan_id
	AND ucp.subscription_initiated='Y'
	AND pp.payment_plan_id='{$payment_plan_id}'";
	//echo "<br/>".$qry."<br/>";
	$result_cp = mysql_query($qry_cp) or die($qry_cp.' '.mysql_error());
	$buffer_cp = mysql_fetch_assoc($result_cp);

	if ($debug == true) { 
		echo '<br>PRINT R BUFFER: ';
		print_r($buffer_cp);
		echo '<br>';
	}	
	
	if ($_GET['confirmed'] == 'yes' && $buffer_cp['user_custom_plan_id'] != '') {
		
	// DISABLE CUSTOM SUBSCRIPTION PLAN
	$qry = "UPDATE user_custom_plan SET subscription_initiated='N'
	WHERE user_custom_plan_id='".$buffer_cp['user_custom_plan_id']."'";
	//echo "<br/>".$qry."<br/>";
	$result = mysql_query($qry) or die($qry.' '.mysql_error());
	
	$mu_text = 'This custom subscription payment plan has been cancelled.';	
	
	} else if ($buffer_cp['payment_plan_id'] != '') {
		$mu_headline = 'You currently have this user set to "Auto Renew"';
		$mu_text = 'You have chosen to have '.$_GET['markunpaid'].'\'s subscription automatically renew in '.$Global['program_name'].'.';
		
		$mu_text .= '<br/><br/>This feature was designed for situations where you accept "custom payments" --
		<br/>payments which you collected outside of our website (cash, check, money order, etc.).';
		
		$started_date_unix = strtotime($buffer_cp['started']);
		$started = date('F, jS Y', $started_date_unix);	
		$last_date_unix = strtotime($buffer_cp['last']);
		$last = date('F, jS Y', $last_date_unix);
		$next_date_unix = strtotime($buffer_cp['next']);
		$next = date('F, jS Y', $next_date_unix);		
		
		$mu_text .= '<br/><br/>Subsciption created: '.$started;
		if ($started != $last) $mu_text .= '<br/>Last processed: '.$last;
		$mu_text .= ' Will process next: '.$next;  
		
		$mu_text .= '<br/><br/>';
		
		$mu_text .= '<a class="btn btn-danger btn-lg" href="viewteam.php?markunpaid='.$_GET['markunpaid'].'&program='.$_GET['program'].'&userid='.$_GET['userid'].'&confirmed=yes"><span class="fa fa-trash"></span> Cancel Custom Subscription Payment</a>';
		
	} else {
		$mu_headline = 'Subscription not found';
		$mu_text = 'No custom subscription payment exists for this user in this program.';	
	}	
	
	echo '<br/><h1 style="color:red">Marking Unpaid<h1>
	<h2><span style="color:gray;">'.$mu_headline.'<br/></h2><h3>';

	echo $mu_text.'<br/>';

	echo '</span></h3><br/>';
	
	
	echo '<br/><br/><a href="javascript:window.close();">Close this window to return to my team view</a>';	
	
	//Awaiting Admin Payment
	
	include './../Sub/tpl/footer_tpl.php';
	exit;
}*/

$too_old_date_cancelled = date("Y-m-d", strtotime("-90 days"));
//$too_old_date_cancelled = 0; // TO DISABLE FOR TESTING
//echo $too_old_date_cancelled;
//exit;

// EXTRACT THE LEADS
if (isset($_POST['action'], $_POST['program']) && $_POST['action'] == 'extract' && $_POST['program'] != '') {
		
	$program_id = $_REQUEST['program'];
	$program_name = $Global['program_name'];

	$wrapper = chr(34);
	$separator = chr(15);
	$separator = ",";
	$esc = chr(92);	
	header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	header("Pragma: public");
	header("Content-Type: application/octet-stream");
	header("Content-Transfer-Encoding: binary");
	header("Accept-Ranges: bytes");
	header('Content-Disposition: attachment; filename="'.$Global['webpage_name'].'_'.$program_name.'_Team.csv"');
	header("Connection: close");
			
	echo 'Username'.$separator.'First Name'.$separator.'Last Name'.$separator.'E-mail'.$separator.'Phone'.$separator.'Program'.
	$separator.'Status'.$separator.'Date Joined'.
	
	"\r\n";

//$query = $_SESSION['viewteam_qry']; // QQQ
	//$result = mysql_query($query) or die(mysql_error());
	//while ($buffer = mysql_fetch_assoc($result)) {

		$date = ''; // MUST INITIALIZE FOR NEXT USE!
		//$date = $buffer['stdate']; // DAY ONLY NOT TIME
		$date = substr($buffer['Signdate'], 0, -9);// GIVE DAY AND NOT TIME
		
		//if ($buffer['status'] == '') $buffer['status'] = 'personal';

		echo (strpos($buffer['Username'], $separator) === false ? $buffer['Username'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['Username']).$wrapper.$separator)

		. (strpos($buffer['First_Name'], $separator) === false ? $buffer['First_Name'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['First_Name']).$wrapper.$separator)

		. (strpos($buffer['Last_Name'], $separator) === false ? $buffer['Last_Name'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['Last_Name']).$wrapper.$separator)

		. (strpos($buffer['email'], $separator) === false ? $buffer['email'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['email']).$wrapper.$separator)

		. (strpos($buffer['phone'], $separator) === false ? $buffer['phone'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['phone']).$wrapper.$separator)
		
		. (strpos($program_name, $separator) === false ? $program_name.$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $program_name).$wrapper.$separator)			
		
		. (strpos($buffer['user_status'], $separator) === false ? $buffer['user_status'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['user_status']).$wrapper.$separator)	

		. (strpos($date, $separator) === false ? $date.$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $date).$wrapper)."\r\n";				

	//} // END WHILE LOOP	
	exit;						
} // END EXTRACT

include './../Sub/tpl/header_tpl.php';


///////////////////////////////////////////////////////////////////////////////
// SEARCH FEATURES
///////////////////////////////////////////////////////////////////////////////
?>



<div class="row">
<div class="col-xs-12 col-sm-3">
<div class="form-group">
<i class="fa fa-search" style="color:gray"></i>&nbsp;
<a href="#" data-toggle="modal" data-target="#instructions" class="btn btn-success btn-xs">How To Use</a>&nbsp; <i class="fa fa-mail-forward" style="color:#5bc0de" aria-hidden="true"></i>

  <!-- Modal -->
  <div class="modal fade" id="instructions" tabindex="-1" role="dialog" data-backdrop="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title"><i class="fa fa-search" style="color:lightgray"></i>&nbsp;&nbsp;Search Overview</h4>
      </div>
      <div class="modal-body">  
		You may leave any fields blank, but if you choose to enter a search value, then you must also select a search field.
		<hr><!-- HIDE THIS SECTION FOR MATRIX ONLY-->
		<?php if ($program_is_matrix != true) { ?>
		To show only your powerlines (sales passed up to you), click the drop down from "Show My Direct Team" and switch it to "Show Only Pass Ups To Me" and then click "View Members"
		<hr> <?php } ?>
		To search leads between dates, select a "From" condition, and add a Start Date and an End Date (optional).<br/>
		Example: Who Opted-In From (Start Date) and (End Date)
		<hr>
		<!--NOTE: Cancelled users are only displayed for the last 90 days.
		<hr>-->
		The "CLEAR" button resets the search value.
		<hr>
		The "RESET" button resets all form fields.
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- End Modal -->


<form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" target="_self">
&nbsp;<input type="button"  class="btn btn-danger btn-xs" NAME="blank" VALUE="RESET" SIZE="" onClick="this.form.find.value='';this.form.status.value='All';this.form.way.value=('2');this.form.colname.value='choose';this.form.program.value='0';this.form.dateway.value='all';this.form.start_date.value='';this.form.end_date.value='';this.form.country.value='';this.form.powerlines.value='';this.form.markedpaid.value='';">
&nbsp;
<input type="button"  class="btn btn-info btn-xs" NAME="blank" VALUE="CLEAR" SIZE="" onClick="this.form.find.value=''">

</div>
</div>


<?php
if (isset($_GET['email'])) {
			$condition = $_GET['email'];
			$_REQUEST['way'] = 1;
			$_REQUEST['colname'] = 4;
			$_REQUEST['limit'] = 100;
			$_REQUEST['find'] = $_GET['email'];
			//$_REQUEST['submit'] = "SEARCH";
?>

<div class="col-xs-12 col-sm-3">
<div class="form-group">
<input type="text" class="form-control" name="find" value="<?php echo $condition;?>" placeholder="Enter Search Value" onMouseover="this.focus()"> 
</div>
</div>


<div class="col-xs-12 col-sm-3">
<div class="form-group">
<select name="way" class="form-control">
<option value="1" <?php if ($true = true) echo 'selected';?>>Exact Match</option>
</select>			
</div>
</div>

			
<?php		
		} else { // SEARCH THE NORMAL WAY 
?>

<div class="col-xs-12 col-sm-3">
<div class="form-group">

<input type="text" class="form-control" name="find" value="<?php if (isset($_REQUEST['find'])) echo $_REQUEST['find'];?>" placeholder="Enter Search Value" onMouseover="this.focus()"> 

</div>
</div>


<div class="col-xs-12 col-sm-3">
<div class="form-group">
<select name="way" class="form-control">
<option value="2" <?php if (isset($_REQUEST['way']) && $_REQUEST['way'] == '2') echo 'selected';?>>Contains</option>
<option value="1" <?php if (isset($_REQUEST['way']) && $_REQUEST['way'] == '1') echo 'selected';?>>Exact Match</option>
</select>
</div>
</div>

<?php } // END AUTO SUBMIT SEARCH FOR EMAIL, WHEN PRESENT IN URL
?>

<div class="col-xs-12 col-sm-3">
<div class="form-group">

<select name="colname" class="form-control">
<option value="choose" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == 1) echo 'selected';?>>Select Search Field</option>
<option value="Username" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "Username") echo 'selected';?>>Username</option>

<option value="First_Name" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "First_Name") echo 'selected';?>>First Name</option>
<option value="Last_Name" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "Last_Name") echo 'selected';?>>Last Name</option>
<!--
<option value="notes" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "notes") echo 'selected';?>>My Notes</option>
-->
<option value="email" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "email") echo 'selected';?>>Email</option>

<!--
<option value="phone" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "phone") echo 'selected';?>>Phone</option>
-->

<?php if ($use_campaigns == true) { ?>
<option value="short" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "short") echo 'selected';?>>Campaign URL</option>
<?php } ?>
<!--
<option value="ip" <?php if (isset($_REQUEST['colname']) && $_REQUEST['colname'] == "ip") echo 'selected';?>>IP Address</option>
-->
</select>
 
</div>
</div>
</div>


<style type="text/css">
    .box{
        color: #fff;
        padding: 20px;
        display: show;
        margin-top: 20px;
    }
    .red{ background: #ff0000; }
    .green{ background: #228B22; }
    .blue{ background: #5bc0de; }
    label{ margin-right: 15px; }
</style>
<!--
<script type="text/javascript">
$(document).ready(function(){
    $('input[type="checkbox"]').click(function(){
        var inputValue = $(this).attr("value");
        $("." + inputValue).toggle();
    });
});
</script>
-->

<div class="blue box" style="margin-top:-7px">

<div class="row">
<div class="col-xs-12 col-sm-3">
<div class="form-group">

<select name="program" class="form-control block"><?php echo $program_info; ?></select>

</div>
</div>

<div class="col-xs-12 col-sm-3">
<div class="form-group">

<select name="status" class="form-control"><?php echo $options; ?></select>

</div>
</div>

<div class="col-xs-12 col-sm-3">
<div class="form-group">

<!--
<div class="checkbox">
  <label><input type="checkbox" name="powerlines" <?php if (isset($_REQUEST['powerlines'])) echo 'checked';?>>&nbsp; Show Only Pass Ups</label>
</div>
-->
<select name="powerlines" class="form-control block">
<option value="" <?php if (isset($_REQUEST['powerlines'])) echo ' selected';?>>Show My Direct Team</option>

<?php if ($program_is_matrix != true) { ?>
<option value="passed_up" <?php if (isset($_REQUEST['powerlines']) && $_REQUEST['powerlines'] == 'passed_up') echo ' selected';?>>Show Only My Pass Ups</option>

<!-- HIDE FOR MATRIX ONLY SYSTEMS -->
 
<option value="passed_to" <?php if (isset($_REQUEST['powerlines']) && $_REQUEST['powerlines'] == 'passed_to') echo ' selected';?>>Show Only Pass Ups To Me</option>
<?php } ?>
</select>

</div>
</div>


<div class="col-xs-12 col-sm-3">
<div class="form-group">

<!-- HIDE FOR MATRIX ONLY SYSTEMS -->
<?php if ($program_is_matrix != true) { ?>
<div class="checkbox">
  <label><input type="checkbox" name="markedpaid" <?php if (isset($_REQUEST['markedpaid']) && $_REQUEST['markedpaid'] != '') echo 'checked';?>>&nbsp; Show Only Marked Paid</label>
</div>
<?php } ?>
<!-- END HIDE FOR MATRIX ONLY SYSTEMS -->
</div>
</div>

</div>


<div class="row">

<div class="col-xs-12 col-md-3 text-left">
<div class="form-group">

<?php if (!isset($_REQUEST['country'])) $_GET['country'] = ''; ?> 

	<select class="form-control" onMouseover="this.focus()" name="country">
		<option value="" <?php if ($_REQUEST['country'] == '') echo 'selected'; ?>>Any Country</option>
		<option value="US" <?php if ($_REQUEST['country'] == 'US') echo 'selected'; ?>>United States</option>
		<option value="AF" <?php if ($_REQUEST['country'] == 'AF') echo 'selected'; ?>>Afghanistan</option>
		<option value="AX" <?php if ($_REQUEST['country'] == 'AX') echo 'selected'; ?>>Aland Islands</option>
		<option value="AL" <?php if ($_REQUEST['country'] == 'AL') echo 'selected'; ?>>Albania</option>
		<option value="DZ" <?php if ($_REQUEST['country'] == 'DZ') echo 'selected'; ?>>Algeria</option>
		<option value="AS" <?php if ($_REQUEST['country'] == 'AS') echo 'selected'; ?>>American Samoa</option>
		<option value="AD" <?php if ($_REQUEST['country'] == 'AD') echo 'selected'; ?>>Andorra</option>
		<option value="AO" <?php if ($_REQUEST['country'] == 'AO') echo 'selected'; ?>>Angola</option>
		<option value="AI" <?php if ($_REQUEST['country'] == 'AI') echo 'selected'; ?>>Anguilla</option>
		<option value="AQ" <?php if ($_REQUEST['country'] == 'AQ') echo 'selected'; ?>>Antarctica</option>
		<option value="AG" <?php if ($_REQUEST['country'] == 'AG') echo 'selected'; ?>>Antigua and Barbuda</option>
		<option value="AR" <?php if ($_REQUEST['country'] == 'AR') echo 'selected'; ?>>Argentina</option>
		<option value="AM" <?php if ($_REQUEST['country'] == 'AM') echo 'selected'; ?>>Armenia</option>
		<option value="AW" <?php if ($_REQUEST['country'] == 'AW') echo 'selected'; ?>>Aruba</option>
		<option value="AU" <?php if ($_REQUEST['country'] == 'AU') echo 'selected'; ?>>Australia</option>
		<option value="AT" <?php if ($_REQUEST['country'] == 'AT') echo 'selected'; ?>>Austria</option>
		<option value="AZ" <?php if ($_REQUEST['country'] == 'AZ') echo 'selected'; ?>>Azerbaijan</option>
		<option value="BS" <?php if ($_REQUEST['country'] == 'BS') echo 'selected'; ?>>Bahamas</option>
		<option value="BH" <?php if ($_REQUEST['country'] == 'BH') echo 'selected'; ?>>Bahrain</option>
		<option value="BD" <?php if ($_REQUEST['country'] == 'BD') echo 'selected'; ?>>Bangladesh</option>
		<option value="BB" <?php if ($_REQUEST['country'] == 'BB') echo 'selected'; ?>>Barbados</option>
		<option value="BY" <?php if ($_REQUEST['country'] == 'BY') echo 'selected'; ?>>Belarus</option>
		<option value="BE" <?php if ($_REQUEST['country'] == 'BE') echo 'selected'; ?>>Belgium</option>
		<option value="BZ" <?php if ($_REQUEST['country'] == 'BZ') echo 'selected'; ?>>Belize</option>
		<option value="BJ" <?php if ($_REQUEST['country'] == 'BJ') echo 'selected'; ?>>Benin</option>
		<option value="BM" <?php if ($_REQUEST['country'] == 'BM') echo 'selected'; ?>>Bermuda</option>
		<option value="BT" <?php if ($_REQUEST['country'] == 'BT') echo 'selected'; ?>>Bhutan</option>
		<option value="BO" <?php if ($_REQUEST['country'] == 'BO') echo 'selected'; ?>>Bolivia</option>
		<option value="BA" <?php if ($_REQUEST['country'] == 'BA') echo 'selected'; ?>>Bosnia and Herzegovina</option>
		<option value="BW" <?php if ($_REQUEST['country'] == 'BW') echo 'selected'; ?>>Botswana</option>
		<option value="BV" <?php if ($_REQUEST['country'] == 'BV') echo 'selected'; ?>>Bouvet Island</option>
		<option value="BR" <?php if ($_REQUEST['country'] == 'BR') echo 'selected'; ?>>Brazil</option>
		<option value="IO" <?php if ($_REQUEST['country'] == 'IO') echo 'selected'; ?>>British Indian Ocean Territory</option>
		<option value="BN" <?php if ($_REQUEST['country'] == 'BN') echo 'selected'; ?>>Brunei Darussalam</option>
		<option value="BG" <?php if ($_REQUEST['country'] == 'BG') echo 'selected'; ?>>Bulgaria</option>
		<option value="BF" <?php if ($_REQUEST['country'] == 'BF') echo 'selected'; ?>>Burkina Faso</option>
		<option value="BI" <?php if ($_REQUEST['country'] == 'BI') echo 'selected'; ?>>Burundi</option>
		<option value="KH" <?php if ($_REQUEST['country'] == 'KH') echo 'selected'; ?>>Cambodia</option>
		<option value="CM" <?php if ($_REQUEST['country'] == 'CM') echo 'selected'; ?>>Cameroon</option>
		<option value="CA" <?php if ($_REQUEST['country'] == 'CA') echo 'selected'; ?>>Canada</option>
		<option value="CV" <?php if ($_REQUEST['country'] == 'CV') echo 'selected'; ?>>Cape Verde</option>
		<option value="KY" <?php if ($_REQUEST['country'] == 'KY') echo 'selected'; ?>>Cayman Islands</option>
		<option value="CF" <?php if ($_REQUEST['country'] == 'CF') echo 'selected'; ?>>Central African Republic</option>
		<option value="TD" <?php if ($_REQUEST['country'] == 'TD') echo 'selected'; ?>>Chad</option>
		<option value="CL" <?php if ($_REQUEST['country'] == 'CL') echo 'selected'; ?>>Chile</option>
		<option value="CN" <?php if ($_REQUEST['country'] == 'CN') echo 'selected'; ?>>China</option>
		<option value="CX" <?php if ($_REQUEST['country'] == 'CX') echo 'selected'; ?>>Christmas Island</option>
		<option value="CC" <?php if ($_REQUEST['country'] == 'CC') echo 'selected'; ?>>Cocos (Keeling) Islands</option>
		<option value="CO" <?php if ($_REQUEST['country'] == 'CO') echo 'selected'; ?>>Colombia</option>
		<option value="KM" <?php if ($_REQUEST['country'] == 'KM') echo 'selected'; ?>>Comoros</option>
		<option value="CG" <?php if ($_REQUEST['country'] == 'CG') echo 'selected'; ?>>Congo</option>
		<option value="CD" <?php if ($_REQUEST['country'] == 'CD') echo 'selected'; ?>>Congo, The Democratic Republic of The</option>
		<option value="CK" <?php if ($_REQUEST['country'] == 'CK') echo 'selected'; ?>>Cook Islands</option>
		<option value="CR" <?php if ($_REQUEST['country'] == 'CR') echo 'selected'; ?>>Costa Rica</option>
		<option value="CI" <?php if ($_REQUEST['country'] == 'CT') echo 'selected'; ?>>Cote D'ivoire</option>
		<option value="HR" <?php if ($_REQUEST['country'] == 'HR') echo 'selected'; ?>>Croatia</option>
		<option value="CU" <?php if ($_REQUEST['country'] == 'CU') echo 'selected'; ?>>Cuba</option>
		<option value="CY" <?php if ($_REQUEST['country'] == 'CY') echo 'selected'; ?>>Cyprus</option>
		<option value="CZ" <?php if ($_REQUEST['country'] == 'CE') echo 'selected'; ?>>Czech Republic</option>
		<option value="DK" <?php if ($_REQUEST['country'] == 'DK') echo 'selected'; ?>>Denmark</option>
		<option value="DJ" <?php if ($_REQUEST['country'] == 'DJ') echo 'selected'; ?>>Djibouti</option>
		<option value="DM" <?php if ($_REQUEST['country'] == 'DM') echo 'selected'; ?>>Dominica</option>
		<option value="DO" <?php if ($_REQUEST['country'] == 'DO') echo 'selected'; ?>>Dominican Republic</option>
		<option value="EC" <?php if ($_REQUEST['country'] == 'EC') echo 'selected'; ?>>Ecuador</option>
		<option value="EG" <?php if ($_REQUEST['country'] == 'EG') echo 'selected'; ?>>Egypt</option>
		<option value="SV" <?php if ($_REQUEST['country'] == 'SV') echo 'selected'; ?>>El Salvador</option>
		<option value="GQ" <?php if ($_REQUEST['country'] == 'GQ') echo 'selected'; ?>>Equatorial Guinea</option>
		<option value="ER" <?php if ($_REQUEST['country'] == 'ER') echo 'selected'; ?>>Eritrea</option>
		<option value="EE" <?php if ($_REQUEST['country'] == 'EE') echo 'selected'; ?>>Estonia</option>
		<option value="ET" <?php if ($_REQUEST['country'] == 'ET') echo 'selected'; ?>>Ethiopia</option>
		<option value="FK" <?php if ($_REQUEST['country'] == 'FK') echo 'selected'; ?>>Falkland Islands (Malvinas)</option>
		<option value="FO" <?php if ($_REQUEST['country'] == 'FO') echo 'selected'; ?>>Faroe Islands</option>
		<option value="FJ" <?php if ($_REQUEST['country'] == 'FJ') echo 'selected'; ?>>Fiji</option>
		<option value="FI" <?php if ($_REQUEST['country'] == 'FI') echo 'selected'; ?>>Finland</option>
		<option value="FR" <?php if ($_REQUEST['country'] == 'FR') echo 'selected'; ?>>France</option>
		<option value="GF" <?php if ($_REQUEST['country'] == 'GF') echo 'selected'; ?>>French Guiana</option>
		<option value="PF" <?php if ($_REQUEST['country'] == 'PF') echo 'selected'; ?>>French Polynesia</option>
		<option value="TF" <?php if ($_REQUEST['country'] == 'TF') echo 'selected'; ?>>French Southern Territories</option>
		<option value="GA" <?php if ($_REQUEST['country'] == 'GA') echo 'selected'; ?>>Gabon</option>
		<option value="GM" <?php if ($_REQUEST['country'] == 'GM') echo 'selected'; ?>>Gambia</option>
		<option value="GE" <?php if ($_REQUEST['country'] == 'GE') echo 'selected'; ?>>Georgia</option>
		<option value="DE" <?php if ($_REQUEST['country'] == 'DE') echo 'selected'; ?>>Germany</option>
		<option value="GH" <?php if ($_REQUEST['country'] == 'GH') echo 'selected'; ?>>Ghana</option>
		<option value="GI" <?php if ($_REQUEST['country'] == 'GI') echo 'selected'; ?>>Gibraltar</option>
		<option value="GR" <?php if ($_REQUEST['country'] == 'GR') echo 'selected'; ?>>Greece</option>
		<option value="GL" <?php if ($_REQUEST['country'] == 'GL') echo 'selected'; ?>>Greenland</option>
		<option value="GD" <?php if ($_REQUEST['country'] == 'GD') echo 'selected'; ?>>Grenada</option>
		<option value="GP" <?php if ($_REQUEST['country'] == 'GP') echo 'selected'; ?>>Guadeloupe</option>
		<option value="GU" <?php if ($_REQUEST['country'] == 'GU') echo 'selected'; ?>>Guam</option>
		<option value="GT" <?php if ($_REQUEST['country'] == 'GT') echo 'selected'; ?>>Guatemala</option>
		<option value="GG" <?php if ($_REQUEST['country'] == 'GG') echo 'selected'; ?>>Guernsey</option>
		<option value="GN" <?php if ($_REQUEST['country'] == 'GN') echo 'selected'; ?>>Guinea</option>
		<option value="GW" <?php if ($_REQUEST['country'] == 'GW') echo 'selected'; ?>>Guinea-bissau</option>
		<option value="GY" <?php if ($_REQUEST['country'] == 'GY') echo 'selected'; ?>>Guyana</option>
		<option value="HT" <?php if ($_REQUEST['country'] == 'HT') echo 'selected'; ?>>Haiti</option>
		<option value="HM" <?php if ($_REQUEST['country'] == 'HM') echo 'selected'; ?>>Heard Island and Mcdonald Islands</option>
		<option value="VA" <?php if ($_REQUEST['country'] == 'VA') echo 'selected'; ?>>Holy See (Vatican City State)</option>
		<option value="HN" <?php if ($_REQUEST['country'] == 'HN') echo 'selected'; ?>>Honduras</option>
		<option value="HK" <?php if ($_REQUEST['country'] == 'HK') echo 'selected'; ?>>Hong Kong</option>
		<option value="HU" <?php if ($_REQUEST['country'] == 'HU') echo 'selected'; ?>>Hungary</option>
		<option value="IS" <?php if ($_REQUEST['country'] == 'IS') echo 'selected'; ?>>Iceland</option>
		<option value="IN" <?php if ($_REQUEST['country'] == 'IN') echo 'selected'; ?>>India</option>
		<option value="ID" <?php if ($_REQUEST['country'] == 'ID') echo 'selected'; ?>>Indonesia</option>
		<option value="IR" <?php if ($_REQUEST['country'] == 'IR') echo 'selected'; ?>>Iran, Islamic Republic of</option>
		<option value="IQ" <?php if ($_REQUEST['country'] == 'IQ') echo 'selected'; ?>>Iraq</option>
		<option value="IE" <?php if ($_REQUEST['country'] == 'IE') echo 'selected'; ?>>Ireland</option>
		<option value="IM" <?php if ($_REQUEST['country'] == 'IM') echo 'selected'; ?>>Isle of Man</option>
		<option value="IL" <?php if ($_REQUEST['country'] == 'IL') echo 'selected'; ?>>Israel</option>
		<option value="IT" <?php if ($_REQUEST['country'] == 'IT') echo 'selected'; ?>>Italy</option>
		<option value="JM" <?php if ($_REQUEST['country'] == 'JM') echo 'selected'; ?>>Jamaica</option>
		<option value="JP" <?php if ($_REQUEST['country'] == 'JP') echo 'selected'; ?>>Japan</option>
		<option value="JE" <?php if ($_REQUEST['country'] == 'JE') echo 'selected'; ?>>Jersey</option>
		<option value="JO" <?php if ($_REQUEST['country'] == 'JO') echo 'selected'; ?>>Jordan</option>
		<option value="KZ" <?php if ($_REQUEST['country'] == 'KZ') echo 'selected'; ?>>Kazakhstan</option>
		<option value="KE" <?php if ($_REQUEST['country'] == 'KE') echo 'selected'; ?>>Kenya</option>
		<option value="KI" <?php if ($_REQUEST['country'] == 'KI') echo 'selected'; ?>>Kiribati</option>
		<option value="KP" <?php if ($_REQUEST['country'] == 'KP') echo 'selected'; ?>>Korea, Democratic People's Republic of</option>
		<option value="KR" <?php if ($_REQUEST['country'] == 'KR') echo 'selected'; ?>>Korea, Republic of</option>
		<option value="KW" <?php if ($_REQUEST['country'] == 'KW') echo 'selected'; ?>>Kuwait</option>
		<option value="KG" <?php if ($_REQUEST['country'] == 'KG') echo 'selected'; ?>>Kyrgyzstan</option>
		<option value="LA" <?php if ($_REQUEST['country'] == 'LA') echo 'selected'; ?>>Lao People's Democratic Republic</option>
		<option value="LV" <?php if ($_REQUEST['country'] == 'LV') echo 'selected'; ?>>Latvia</option>
		<option value="LB" <?php if ($_REQUEST['country'] == 'LB') echo 'selected'; ?>>Lebanon</option>
		<option value="LS" <?php if ($_REQUEST['country'] == 'LS') echo 'selected'; ?>>Lesotho</option>
		<option value="LR" <?php if ($_REQUEST['country'] == 'LR') echo 'selected'; ?>>Liberia</option>
		<option value="LY" <?php if ($_REQUEST['country'] == 'LY') echo 'selected'; ?>>Libyan Arab Jamahiriya</option>
		<option value="LI" <?php if ($_REQUEST['country'] == 'LI') echo 'selected'; ?>>Liechtenstein</option>
		<option value="LT" <?php if ($_REQUEST['country'] == 'LT') echo 'selected'; ?>>Lithuania</option>
		<option value="LU" <?php if ($_REQUEST['country'] == 'LU') echo 'selected'; ?>>Luxembourg</option>
		<option value="MO" <?php if ($_REQUEST['country'] == 'MO') echo 'selected'; ?>>Macao</option>
		<option value="MK" <?php if ($_REQUEST['country'] == 'MK') echo 'selected'; ?>>Macedonia, The Former Yugoslav Republic of</option>
		<option value="MG" <?php if ($_REQUEST['country'] == 'MG') echo 'selected'; ?>>Madagascar</option>
		<option value="MW" <?php if ($_REQUEST['country'] == 'MW') echo 'selected'; ?>>Malawi</option>
		<option value="MY" <?php if ($_REQUEST['country'] == 'MY') echo 'selected'; ?>>Malaysia</option>
		<option value="MV" <?php if ($_REQUEST['country'] == 'MV') echo 'selected'; ?>>Maldives</option>
		<option value="ML" <?php if ($_REQUEST['country'] == 'ML') echo 'selected'; ?>>Mali</option>
		<option value="MT" <?php if ($_REQUEST['country'] == 'MT') echo 'selected'; ?>>Malta</option>
		<option value="MH" <?php if ($_REQUEST['country'] == 'MH') echo 'selected'; ?>>Marshall Islands</option>
		<option value="MQ" <?php if ($_REQUEST['country'] == 'MQ') echo 'selected'; ?>>Martinique</option>
		<option value="MR" <?php if ($_REQUEST['country'] == 'MR') echo 'selected'; ?>>Mauritania</option>
		<option value="MU" <?php if ($_REQUEST['country'] == 'MU') echo 'selected'; ?>>Mauritius</option>
		<option value="YT" <?php if ($_REQUEST['country'] == 'YT') echo 'selected'; ?>>Mayotte</option>
		<option value="MX" <?php if ($_REQUEST['country'] == 'MX') echo 'selected'; ?>>Mexico</option>
		<option value="FM" <?php if ($_REQUEST['country'] == 'FM') echo 'selected'; ?>>Micronesia, Federated States of</option>
		<option value="MD" <?php if ($_REQUEST['country'] == 'MD') echo 'selected'; ?>>Moldova, Republic of</option>
		<option value="MC" <?php if ($_REQUEST['country'] == 'MC') echo 'selected'; ?>>Monaco</option>
		<option value="MN" <?php if ($_REQUEST['country'] == 'MN') echo 'selected'; ?>>Mongolia</option>
		<option value="ME" <?php if ($_REQUEST['country'] == 'ME') echo 'selected'; ?>>Montenegro</option>
		<option value="MS" <?php if ($_REQUEST['country'] == 'MS') echo 'selected'; ?>>Montserrat</option>
		<option value="MA" <?php if ($_REQUEST['country'] == 'MA') echo 'selected'; ?>>Morocco</option>
		<option value="MZ" <?php if ($_REQUEST['country'] == 'MZ') echo 'selected'; ?>>Mozambique</option>
		<option value="MM" <?php if ($_REQUEST['country'] == 'MM') echo 'selected'; ?>>Myanmar</option>
		<option value="NA" <?php if ($_REQUEST['country'] == 'NA') echo 'selected'; ?>>Namibia</option>
		<option value="NR" <?php if ($_REQUEST['country'] == 'NR') echo 'selected'; ?>>Nauru</option>
		<option value="NP" <?php if ($_REQUEST['country'] == 'NP') echo 'selected'; ?>>Nepal</option>
		<option value="NL" <?php if ($_REQUEST['country'] == 'NL') echo 'selected'; ?>>Netherlands</option>
		<option value="AN" <?php if ($_REQUEST['country'] == 'AN') echo 'selected'; ?>>Netherlands Antilles</option>
		<option value="NC" <?php if ($_REQUEST['country'] == 'NC') echo 'selected'; ?>>New Caledonia</option>
		<option value="NZ" <?php if ($_REQUEST['country'] == 'NZ') echo 'selected'; ?>>New Zealand</option>
		<option value="NI" <?php if ($_REQUEST['country'] == 'NI') echo 'selected'; ?>>Nicaragua</option>
		<option value="NE" <?php if ($_REQUEST['country'] == 'NE') echo 'selected'; ?>>Niger</option>
		<option value="NG" <?php if ($_REQUEST['country'] == 'NG') echo 'selected'; ?>>Nigeria</option>
		<option value="NU" <?php if ($_REQUEST['country'] == 'NU') echo 'selected'; ?>>Niue</option>
		<option value="NF" <?php if ($_REQUEST['country'] == 'NF') echo 'selected'; ?>>Norfolk Island</option>
		<option value="MP" <?php if ($_REQUEST['country'] == 'MP') echo 'selected'; ?>>Northern Mariana Islands</option>
		<option value="NO" <?php if ($_REQUEST['country'] == 'NO') echo 'selected'; ?>>Norway</option>
		<option value="OM" <?php if ($_REQUEST['country'] == 'OM') echo 'selected'; ?>>Oman</option>
		<option value="PK" <?php if ($_REQUEST['country'] == 'PK') echo 'selected'; ?>>Pakistan</option>
		<option value="PW" <?php if ($_REQUEST['country'] == 'PW') echo 'selected'; ?>>Palau</option>
		<option value="PS" <?php if ($_REQUEST['country'] == 'PS') echo 'selected'; ?>>Palestinian Territory, Occupied</option>
		<option value="PA" <?php if ($_REQUEST['country'] == 'PA') echo 'selected'; ?>>Panama</option>
		<option value="PG" <?php if ($_REQUEST['country'] == 'PG') echo 'selected'; ?>>Papua New Guinea</option>
		<option value="PY" <?php if ($_REQUEST['country'] == 'PY') echo 'selected'; ?>>Paraguay</option>
		<option value="PE" <?php if ($_REQUEST['country'] == 'PE') echo 'selected'; ?>>Peru</option>
		<option value="PH" <?php if ($_REQUEST['country'] == 'PH') echo 'selected'; ?>>Philippines</option>
		<option value="PN" <?php if ($_REQUEST['country'] == 'PN') echo 'selected'; ?>>Pitcairn</option>
		<option value="PL" <?php if ($_REQUEST['country'] == 'PL') echo 'selected'; ?>>Poland</option>
		<option value="PT" <?php if ($_REQUEST['country'] == 'PT') echo 'selected'; ?>>Portugal</option>
		<option value="PR" <?php if ($_REQUEST['country'] == 'PR') echo 'selected'; ?>>Puerto Rico</option>
		<option value="QA" <?php if ($_REQUEST['country'] == 'QA') echo 'selected'; ?>>Qatar</option>
		<option value="RE" <?php if ($_REQUEST['country'] == 'RE') echo 'selected'; ?>>Reunion</option>
		<option value="RO" <?php if ($_REQUEST['country'] == 'RO') echo 'selected'; ?>>Romania</option>
		<option value="RU" <?php if ($_REQUEST['country'] == 'RU') echo 'selected'; ?>>Russian Federation</option>
		<option value="RW" <?php if ($_REQUEST['country'] == 'RW') echo 'selected'; ?>>Rwanda</option>
		<option value="SH" <?php if ($_REQUEST['country'] == 'SH') echo 'selected'; ?>>Saint Helena</option>
		<option value="KN" <?php if ($_REQUEST['country'] == 'KN') echo 'selected'; ?>>Saint Kitts and Nevis</option>
		<option value="LC" <?php if ($_REQUEST['country'] == 'LC') echo 'selected'; ?>>Saint Lucia</option>
		<option value="PM" <?php if ($_REQUEST['country'] == 'PM') echo 'selected'; ?>>Saint Pierre and Miquelon</option>
		<option value="VC" <?php if ($_REQUEST['country'] == 'VC') echo 'selected'; ?>>Saint Vincent and The Grenadines</option>
		<option value="WS" <?php if ($_REQUEST['country'] == 'WS') echo 'selected'; ?>>Samoa</option>
		<option value="SM" <?php if ($_REQUEST['country'] == 'SM') echo 'selected'; ?>>San Marino</option>
		<option value="ST" <?php if ($_REQUEST['country'] == 'ST') echo 'selected'; ?>>Sao Tome and Principe</option>
		<option value="SA" <?php if ($_REQUEST['country'] == 'SA') echo 'selected'; ?>>Saudi Arabia</option>
		<option value="SN" <?php if ($_REQUEST['country'] == 'SN') echo 'selected'; ?>>Senegal</option>
		<option value="RS" <?php if ($_REQUEST['country'] == 'RS') echo 'selected'; ?>>Serbia</option>
		<option value="SC" <?php if ($_REQUEST['country'] == 'SC') echo 'selected'; ?>>Seychelles</option>
		<option value="SL" <?php if ($_REQUEST['country'] == 'SL') echo 'selected'; ?>>Sierra Leone</option>
		<option value="SG" <?php if ($_REQUEST['country'] == 'SG') echo 'selected'; ?>>Singapore</option>
		<option value="SK" <?php if ($_REQUEST['country'] == 'SK') echo 'selected'; ?>>Slovakia</option>
		<option value="SI" <?php if ($_REQUEST['country'] == 'SI') echo 'selected'; ?>>Slovenia</option>
		<option value="SB" <?php if ($_REQUEST['country'] == 'SB') echo 'selected'; ?>>Solomon Islands</option>
		<option value="SO" <?php if ($_REQUEST['country'] == 'SO') echo 'selected'; ?>>Somalia</option>
		<option value="ZA" <?php if ($_REQUEST['country'] == 'ZA') echo 'selected'; ?>>South Africa</option>
		<option value="GS" <?php if ($_REQUEST['country'] == 'GS') echo 'selected'; ?>>South Georgia and The South Sandwich Islands</option>
		<option value="ES" <?php if ($_REQUEST['country'] == 'ES') echo 'selected'; ?>>Spain</option>
		<option value="LK" <?php if ($_REQUEST['country'] == 'LK') echo 'selected'; ?>>Sri Lanka</option>
		<option value="SD" <?php if ($_REQUEST['country'] == 'SD') echo 'selected'; ?>>Sudan</option>
		<option value="SR" <?php if ($_REQUEST['country'] == 'SR') echo 'selected'; ?>>Suriname</option>
		<option value="SJ" <?php if ($_REQUEST['country'] == 'SJ') echo 'selected'; ?>>Svalbard and Jan Mayen</option>
		<option value="SZ" <?php if ($_REQUEST['country'] == 'SZ') echo 'selected'; ?>>Swaziland</option>
		<option value="SE" <?php if ($_REQUEST['country'] == 'SE') echo 'selected'; ?>>Sweden</option>
		<option value="CH" <?php if ($_REQUEST['country'] == 'CH') echo 'selected'; ?>>Switzerland</option>
		<option value="SY" <?php if ($_REQUEST['country'] == 'SY') echo 'selected'; ?>>Syrian Arab Republic</option>
		<option value="TW" <?php if ($_REQUEST['country'] == 'TW') echo 'selected'; ?>>Taiwan, Province of China</option>
		<option value="TJ" <?php if ($_REQUEST['country'] == 'TJ') echo 'selected'; ?>>Tajikistan</option>
		<option value="TZ" <?php if ($_REQUEST['country'] == 'TZ') echo 'selected'; ?>>Tanzania, United Republic of</option>
		<option value="TH" <?php if ($_REQUEST['country'] == 'TH') echo 'selected'; ?>>Thailand</option>
		<option value="TL" <?php if ($_REQUEST['country'] == 'TL') echo 'selected'; ?>>Timor-leste</option>
		<option value="TG" <?php if ($_REQUEST['country'] == 'TG') echo 'selected'; ?>>Togo</option>
		<option value="TK" <?php if ($_REQUEST['country'] == 'TK') echo 'selected'; ?>>Tokelau</option>
		<option value="TO" <?php if ($_REQUEST['country'] == 'TO') echo 'selected'; ?>>Tonga</option>
		<option value="TT" <?php if ($_REQUEST['country'] == 'TT') echo 'selected'; ?>>Trinidad and Tobago</option>
		<option value="TN" <?php if ($_REQUEST['country'] == 'TN') echo 'selected'; ?>>Tunisia</option>
		<option value="TR" <?php if ($_REQUEST['country'] == 'TR') echo 'selected'; ?>>Turkey</option>
		<option value="TM" <?php if ($_REQUEST['country'] == 'TM') echo 'selected'; ?>>Turkmenistan</option>
		<option value="TC" <?php if ($_REQUEST['country'] == 'TC') echo 'selected'; ?>>Turks and Caicos Islands</option>
		<option value="TV" <?php if ($_REQUEST['country'] == 'TV') echo 'selected'; ?>>Tuvalu</option>
		<option value="UG" <?php if ($_REQUEST['country'] == 'UG') echo 'selected'; ?>>Uganda</option>
		<option value="UA" <?php if ($_REQUEST['country'] == 'UA') echo 'selected'; ?>>Ukraine</option>
		<option value="AE" <?php if ($_REQUEST['country'] == 'AE') echo 'selected'; ?>>United Arab Emirates</option>
		<option value="GB" <?php if ($_REQUEST['country'] == 'GB') echo 'selected'; ?>>United Kingdom</option>
		<option value="US" <?php if ($_REQUEST['country'] == 'US') echo 'selected'; ?>>United States</option>
		<option value="UM" <?php if ($_REQUEST['country'] == 'UM') echo 'selected'; ?>>United States Minor Outlying Islands</option>
		<option value="UY" <?php if ($_REQUEST['country'] == 'UY') echo 'selected'; ?>>Uruguay</option>
		<option value="UZ" <?php if ($_REQUEST['country'] == 'UZ') echo 'selected'; ?>>Uzbekistan</option>
		<option value="VU" <?php if ($_REQUEST['country'] == 'VU') echo 'selected'; ?>>Vanuatu</option>
		<option value="VE" <?php if ($_REQUEST['country'] == 'VE') echo 'selected'; ?>>Venezuela</option>
		<option value="VN" <?php if ($_REQUEST['country'] == 'VN') echo 'selected'; ?>>Viet Nam</option>
		<option value="VG" <?php if ($_REQUEST['country'] == 'VG') echo 'selected'; ?>>Virgin Islands, British</option>
		<option value="VI" <?php if ($_REQUEST['country'] == 'VI') echo 'selected'; ?>>Virgin Islands, U.S.</option>
		<option value="WF" <?php if ($_REQUEST['country'] == 'WF') echo 'selected'; ?>>Wallis and Futuna</option>
		<option value="EH" <?php if ($_REQUEST['country'] == 'EH') echo 'selected'; ?>>Western Sahara</option>
		<option value="YE" <?php if ($_REQUEST['country'] == 'YE') echo 'selected'; ?>>Yemen</option>
		<option value="ZM" <?php if ($_REQUEST['country'] == 'ZM') echo 'selected'; ?>>Zambia</option>
		<option value="ZW" <?php if ($_REQUEST['country'] == 'ZW') echo 'selected'; ?>>Zimbabwe</option>
		</select>


</div></div>

<?php if (!isset($_REQUEST['dateway'])) $_GET['dateway'] = 'all'; ?>

<div class="col-xs-12 col-sm-3">
<div class="form-group">

<select name="dateway" class="form-control">
<option value="all" <?php echo (($_REQUEST['dateway'] == "all")?'selected="selected"':''); ?>>Who Joined Any Time</option>
<!--
<option value="on" <?php echo (($_REQUEST['dateway'] == "on")?'selected="selected"':''); ?>>Who Joined On</option>
-->
<option value="from" <?php echo (($_REQUEST['dateway'] == "from")?'selected="selected"':''); ?>>Who Joined From</option>
<!--
<option value="all_worked" <?php echo (($_REQUEST['dateway'] == "all_worked")?'selected="selected"':''); ?>>Who I Worked Any Time</option>
<option value="on_worked" <?php echo (($_REQUEST['dateway'] == "on_worked")?'selected="selected"':''); ?>>Who I Worked On</option>
<option value="from_worked" <?php echo (($_REQUEST['dateway'] == "from_worked")?'selected="selected"':''); ?>>Who I Worked From</option>

<option value="all_followups" <?php echo (($_REQUEST['dateway'] == "all_followups")?'selected="selected"':''); ?>>Scheduled Followups Any Time</option>
<option value="on_followups" <?php echo (($_REQUEST['dateway'] == "on_followups")?'selected="selected"':''); ?>>Scheduled Followups On</option>
<option value="from_followups" <?php echo (($_REQUEST['dateway'] == "from_followups")?'selected="selected"':''); ?>>Scheduled Followups From</option>
-->
</select>

</div>
</div>

<div class="col-xs-12 col-sm-3">
<div class="form-group">

                <div class='input-group date' id='datetimepicker'>
           
					<input type="text" class="form-control" placeholder="Start Date" title="Start Date" name="start_date" value="<?php echo ((!empty($_REQUEST['start_date']))?$_REQUEST['start_date']:'');?>">

                    <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
                    </span>
                </div>
			
</div>
</div>


<div class="col-xs-12 col-sm-3">
<div class="form-group">
                <div class='input-group date' id='datetimepicker'>
					<input type="text" class="form-control" placeholder="End Date" title="End Date" name="end_date" value="<?php echo ((!empty($_REQUEST['end_date']))?$_REQUEST['end_date']:'');?>">

                    <span class="input-group-addon"><span class="glyphicon glyphicon-calendar"></span>
                    </span>
                </div>		
				
</div>
</div>

</div>
</div>

<?php
if ($_SERVER['REQUEST_METHOD'] != 'POST' && !isset($_GET['page']) && !isset($_REQUEST['Username']) && !isset($_GET['qualify_user'])) {
 	$bypass_teamview = true;
} else {
	if ($Global['program_name'] != 'All Programs') $team = 'Team';
	else $team = '';
	$headline = $Global['program_name'].' '.$team;	
}

if ($debug == true) print_r($_REQUEST);
if ($debug == true) echo '<br/>';

// FORCE POWERLINES TO DISPLAY ACTIVE SELECTION IN DROP DOWN MENU (POWERLINES CANNOT BE ALL OR UNPAID)!
//if ($_REQUEST['powerlines'] != '') $_REQUEST['status'] = 'Active';
?>
<style>
.table-responsive .dropdown-menu {
   position: static !important;
}
th {
	text-align: center;
	vertical-align: middle;
}
</style>

<br/><br/>
<input type="submit" class="btn btn-primary" value="View Members">
</form>
<br/>


<?php
if (!isset($_REQUEST['status'])) $_REQUEST['status'] = 'All';
$status_to_get = $_REQUEST['status'];
$_SESSION['status_to_get'] = $status_to_get;

if ($_REQUEST['status'] == 'Active' || ($_REQUEST['status'] == '' && $_SESSION['status_to_get'] == 'Active') || $_REQUEST['powerlines'] != '') {

	if ($_REQUEST['show'] == 'user') {
		$heading = $_REQUEST['user'].'\'s Personally Sponsored Sales';
	} else {
		$heading = 'Personally Sponsored Sales';
	}
	
	if ($_REQUEST['powerlines'] != '') $heading = 'Powerline Sales';
	if ($_REQUEST['powerlines'] != '') $heading = 'Sales Passed To You';	

} else if ($_REQUEST['status'] == 'Unpaid' || ($_REQUEST['status'] == '' && $_SESSION['status_to_get'] == 'Unpaid')) {

	if ($_REQUEST['show'] == 'user') {
		$heading = $_REQUEST['user'].'\'s Personally Sponsored Unpaid Referrals';
	} else {
		$heading = 'Personally Sponsored Unpaid Referrals';
	}
} else if ($_REQUEST['status'] == 'All' && $_REQUEST['powerlines'] == '') {
	$heading = 'Personal Team';
} else if ($_REQUEST['status'] == 'All' && $_REQUEST['powerlines'] != '') {
	//$heading = 'Powerline Team';	
	$heading = 'Pass Up Team';
}

// MATRIX - DO NOT SHOW
if ($program_is_matrix == true) $heading = '';
// END MATRIX
?>

                   
                                    
<?php
///////////////////////////////////////////////////
// START THE DOWNLINE QUERIES -- PARTY STARTS HERE!
///////////////////////////////////////////////////
if ($_REQUEST['powerlines'] == 'passed_up') { //NOT WORKING -- TRY AGAIN, SHOULD WORK NOW

	// PASSED UP
	$selectMain = 'm.*, m.sponsorid as msponsor, ml.*, u.*, u.sponsorid as usponsorid';
	$tableMain = ['table' => 'members', 'as' => 'm'];
	$joinMain = [
		['table' => 'member_link', 'as' => 'ml', 'condition' => 'm.ID = ml.ID'],
		['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID']
	];
	$whereMain = [
		'u.powerline_sponsor' => ['!=', $_SESSION['loggedin']],
		'm.sponsorid' => ['=', $_SESSION['loggedin']],
		'm.Status' => ['!=', 'Cancelled'],
		'm.Username' => ['!=', 'DELETED'],
		'u.user_status' => ['=', 'Active'],
		'u.sign_id' => ['IN', explode(',', $powerline_order_comma_sep)]
	];
	$show_debug = 1;
	
	// FORCE A PROGRAM FOR POWERLINES
	//if ($_REQUEST['program'] == 0) $_REQUEST['program'] = 1;
} else if ($_REQUEST['powerlines'] == 'passed_to') {
	
	// POWERLINE SPONSORED -- MASTER DEFAULT QRY
	$selectMain = 'm.*, m.sponsorid as msponsor, ml.*, u.*, u.sponsorid as usponsorid';
	$tableMain = ['table' => 'members', 'as' => 'm'];
	$joinMain = [
		['table' => 'member_link', 'as' => 'ml', 'condition' => 'm.ID = ml.ID'],
		['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID']
	];
	$whereMain = [
		'u.powerline_sponsor' => ['=', $_SESSION['loggedin']],
		'm.sponsorid' => ['!=', $_SESSION['loggedin']],
		'm.Status' => ['!=', 'Cancelled'],
		'm.Username' => ['!=', 'DELETED']
	];
	$show_debug = 1;
	
	// FORCE A PROGRAM FOR POWERLINES
	if ($_REQUEST['program'] == 0) $_REQUEST['program'] = 1;	
} else {
	// PERSONALLY SPONSORED -- MASTER DEFAULT QRY

	$selectMain = 'm.*, ml.*, u.*, u.sponsorid as usponsorid';
	$tableMain = ['table' => 'members', 'as' => 'm'];
	$joinMain = [
		[
			'table' => 'member_link',
			'as' => 'ml',
			'condition' => 'm.ID = ml.ID'
		],
		[
			'table' => 'user_program',
			'as' => 'u',
			'condition' => 'm.ID = u.ID'
		]		
	];
	
	$whereMain['AND']['m.sponsorid'] = ['=', $_SESSION['loggedin']];
	$whereMain['AND']['m.Status'] = ['!=', 'Cancelled'];
	//echo 'in here';
}
// UPDATE TO PHPCPR
if ($_REQUEST['powerlines'] == 'passed_to' && $_REQUEST['markedpaid'] != '') {
	// PASSED TO, MARKING PAID
	$selectMain = 'm.*, m.sponsorid as msponsor, ml.*, u.*, u.sponsorid as usponsorid';
	$tableMain = ['table' => 'members', 'as' => 'm'];

	$joinMain = [
		['table' => 'member_link', 'as' => 'ml', 'condition' => 'm.ID = ml.ID'],
		['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID'],
		['table' => 'payment_plan', 'as' => 'pp', 'condition' => 'pp.user_payment_plan_id = upp.user_payment_plan_id'],
		['table' => 'user_custom_plan', 'as' => 'ucp', 'condition' => 'ucp.payment_plan_id = pp.payment_plan_id'],
		['table' => 'user_payment_plan', 'as' => 'upp', 'condition' => 'pp.user_payment_plan_id = upp.user_payment_plan_id AND u.user_program_id = upp.user_program_id']
	];

	$whereMain['AND'] = [
		'u.powerline_sponsor' => ['=', $_SESSION['loggedin']],
		'm.sponsorid' => ['!=', $_SESSION['loggedin']],
		'm.Status' => ['!=', 'Cancelled'],
		'm.Username' => ['!=', 'DELETED'],
		'upp.valid_plan' => ['!=', 'H'],
		'ucp.subscription_initiated' => ['=', 'Y'],
		'pp.username' => ['=', $_SESSION['loggedin']]
	];

	// FORCE A PROGRAM FOR POWERLINES
	if ($_REQUEST['program'] == 0) $_REQUEST['program'] = 1;	
} else if ($_REQUEST['markedpaid'] != '') { // UPDATE CODE!
	
	// MARKING PAID
	$selectMain = 'm.*, ml.*, u.*, u.sponsorid as usponsorid';
	$tableMain = ['table' => 'members', 'as' => 'm'];
	$joinMain = [
		['table' => 'member_link', 'as' => 'ml', 'condition' => 'm.ID = ml.ID'],
		['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID'],
		['table' => 'payment_plan', 'as' => 'pp', 'condition' => 'pp.user_payment_plan_id = upp.user_payment_plan_id'],
		['table' => 'user_custom_plan', 'as' => 'ucp', 'condition' => 'ucp.payment_plan_id = pp.payment_plan_id'],
		['table' => 'user_payment_plan', 'as' => 'upp', 'condition' => 'u.user_program_id = upp.user_program_id']
	];
	$whereMain = [
		'm.sponsorid' => ['=', $_SESSION['loggedin']],
		'm.Status' => ['!=', 'Cancelled'],
		'm.Username' => ['!=', 'DELETED'],
		'upp.valid_plan' => ['!=', 'H'],
		'pp.username' => ['=', $_SESSION['loggedin']],
		'ucp.subscription_initiated' => ['=', 'Y']
	];
	$show_debug = 1;

}


if (isset($_REQUEST['program']) && $_REQUEST['program'] != '' && $_REQUEST['program'] != 0) {
    $whereMain['AND']['u.program_id'] = $_REQUEST['program'];
}

if (isset($_REQUEST['markedpaid']) && $_REQUEST['markedpaid'] != '') {
    $whereMain['AND']['ucp.program_id'] = $Global['program'];
}

if (isset($_REQUEST['Username']) && $_REQUEST['Username'] != '') {
    $whereMain['AND']['m.Username'] = $_REQUEST['Username'];
}

if (isset($_REQUEST['country']) && $_REQUEST['country'] != '') {
    $whereMain['AND']['ml.country'] = $_REQUEST['country'];
}

if (isset($_GET['qualify_user']) && $_GET['qualify_user'] != '') {
    $whereMain['AND']['m.Username'] = $_GET['qualify_user'];
}


$order = '';
if ($status_to_get == 'Active' || $status_to_get == 'Comped') {
    $whereMain['AND']['u.user_status'] = $status_to_get;
    $order = 'u.started DESC, m.Signdate DESC, u.program_id DESC';
} elseif ($status_to_get == 'Unpaid') {
    $whereMain['AND']['u.user_status'] = 'Unpaid';
    $order = 'm.Signdate DESC, u.program_id ASC';
} elseif ($status_to_get == 'Suspended') {
    $whereMain['AND']['u.user_status'] = 'Suspended';
    $order = 'u.date_suspended DESC, m.Signdate DESC, u.program_id DESC';
} elseif ($status_to_get == 'Cancelled') {
    $whereMain['AND'] = [
        'u.user_status' => ['=', 'Cancelled'],
        'u.date_cancelled' => ['>', $too_old_date_cancelled]
    ];
    $order = 'u.date_cancelled DESC, m.Signdate DESC, u.program_id ASC';
} else {
    $order = 'm.Signdate DESC, u.program_id ASC';
}


// CANNOT GROUP BY ID or prog ID - IT PULLS WRONG RECORDS!

//if ($_GET['page'] == '' && $_REQUEST['Username'] == '' && $_REQUEST['aboutme'] == '') $_SESSION['viewteam_qry'] = $qry;

//echo 'party';

//////////////////////////////////////////////
// THE PARTY STARTS HERE!
/////////////////////////////////////////////
//$GLOBALS['debug'] = true;
if ($bypass_teamview == false) 
$result = select($selectMain, $tableMain, $joinMain, $whereMain, null, null, $order, 0, 1);

//echo 'still';

if (isset($result[0]) && is_array($result[0])) $rows = count($result);
else $rows = 0;
	
if ($rows == 0 && $bypass_teamview == false) {
	echo '<br/>There are no records to display.<br/>';
	$bypass_teamview = true;
	//include './../Sub/tpl/footer_tpl.php';
	//exit;
}

// DISABLE UNTIL CODE GETS UPDATED FOR PHPCPR
if (false && $_GET['qualify_user'] != '') {
	// WE ALREADY HAVE HEADER LOADED NOW
	//include './../Sub/tpl/header_tpl.php';
	$buffer = mysql_fetch_assoc($result);
	//print_r($buffer);
	//exit;

	$qry_qual = "UPDATE user_program SET user_qualify_perm='{$Global['up_powerline']}'
	WHERE user_program_id={$buffer['user_program_id']}";
	
	if ($_GET['undo'] == 'yes') {
		$qry_qual = "UPDATE user_program SET user_qualify_perm='0' WHERE user_program_id='".$buffer['user_program_id']."'";
		$qual_text = 'You have just reversed Auto Qualifying';
		$qual_text2 = 'This means this user will now be required to pass up sales to you.';	
	} else {
		$qual_text = 'You have just Auto Qualified';
		$qual_text2 = 'This means this user will no longer be required to pass up any sales to you.';
	}	
	
	/*if ($_SESSION['loggedin'] == 'testjim') {
		echo $qry."<br>";
		print_r($buffer);
		echo "<br/>".$qry_qual."<br/>";
	}*/	
	//$result_qual = mysql_query($qry_qual) or die($qry_qual.' '.mysql_error());
	
	?>
	<br/><h1 style="color:green">Auto Qualify Changed<h1>
	<h2><span style="color:blue;"><?php echo $qual_text.' '.$buffer['Username']; ?><br/></h2>

	<h3><?php echo $qual_text2; ?></h3>
	
	<?php if ($_GET['undo'] != 'yes') { ?>
	<h3><a href="viewteam.php?qualify_user=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>&undo=yes">Undo this action</a><br/>
	</span></h3>
	<?php } else { ?>
	<h3><a href="viewteam.php?qualify_user=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>">Undo this action</a><br/>
	</span></h3>	
	
	<?php } ?>	
	<br/>
	
	<?php
	echo '<br/><br/><a href="javascript:window.close();">Close this window to return to my team view</a>';
	
	include './../Sub/tpl/footer_tpl.php';
	exit;
} // END QUALIFING USER




if ($bypass_teamview == false) { 
	echo '<h2>'.$headline.'</h2>';
	if ($_REQUEST['program'] != '' && $Global['program'] != 0) echo $qualify_text;
	echo '<h4>'.$heading.'</h4>';	
} // END BYPASS IS FALSE

//PAGINATION PARAMS
if ($status_to_get == 'Unpaid' && $Global['program'] == 0) {
	$results_per_page = 35;
} else {
	$results_per_page = 25;
}
$results_per_page = 25;
$total_pages = ceil($rows/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

// QQQ BYPASSING PAGINATION FOR TCS - IT IS NOT WORKING!
//$results_per_page = 1000;
// END BYPASS

$offset = ($page - 1) * $results_per_page;

$limit = [
	'offset' => $offset,	
	'count' => $results_per_page
];

if ($bypass_teamview != true) 
$result = select($selectMain, $tableMain, $joinMain, $whereMain, null, null, $order, $limit, 1);

$show_rows = '';
// USER_PROGRAM TABLE INFLATES THE MEMBER COUNT, WHICH IS OK AS ROW COUNT IS STILL CORRECT WHEN SHOWING ALL PROGRAMS
// UNLESS SHOWING ONLY UNPAID MEMBERS - WHERE WE SKIP ANY ACTIVE RECORDS - NO EASY WAY TO GET PROPER ROW COUNT OR RECORD COUNT ON SUCH CASES, SO WE HIDE THE ROWS DISPLAY - WHEN THEY SEARCH UNPAID USERS IN ALL PROGRAMS
if ($status_to_get == 'Unpaid' && $Global['program'] == 0) $hide_rows = true; else $hide_rows = false;
if ($rows > 1) $plural = 's';
else $plural = '';
if ($bypass_teamview == false && $hide_rows == false) $show_rows = ' ('.$rows.' Result'.$plural.')';
//echo 'You have '.$rows.' Total Powerline Team Members (sales passed up to you).';
if ($status_to_get == '' || $status_to_get == 'All' && $_REQUEST['Username'] == '') $title = 'Showing all members';
if ($status_to_get == 'Active') $title = 'Showing only Active members';
if ($status_to_get == 'Unpaid') $title = 'Showing only Unpaid members';
if ($status_to_get == 'Unpaid' && $Global['program'] == 0) $title = 'Showing only Unpaid (in ALL Programs) members.';
if ($status_to_get == 'Suspended') $title = 'Showing only Suspended members';
if ($status_to_get == 'Cancelled') $title = 'Showing only Cancelled members';
if ($status_to_get == 'Comped') $title = 'Showing only Comped members';
if ($bypass_teamview == false && $title != '') echo $title.$show_rows.'<br/><br/>';
$count = 1;
$row_count = 0;

// NEW WAY - SHOW COUNT IN DESCENDING ORDER
$count = $rows;

/*if ($_GET['page'] != '' && $_GET['page'] != 1) {
	$page_count = $_GET['page'] - 1;
	// OLD WAY - SHOW COUNT IN ASCENDING ORDER!
	//$count_seen = $page_count * $results_per_page;
	//$count = $count + 1;
	
	// NEW WAY - SHOW COUNT IN DESCENDING ORDER!
	$count_seen = $page_count * $results_per_page;	
	$count = $rows - $count_seen;
}*/

if (isset($_GET['page']) && $_GET['page'] != 1) {
  $page_count = $_GET['page'] - 1;
  $count_seen = $page_count * $results_per_page;
  $count = $count - $count_seen;
}


unset($buffer);

foreach ($result as $buffer) {	
	//print_r($buffer);
	//exit;
	if ($status_to_get == 'Unpaid' && $Global['program'] == 0) {
		// NO WAY TO SHOW COUNT -- SINCE WE STRIP OUT ACTIVE, COMPED IN AN INNER QUERY
		// SO WE DISPLAY THOSE UNPAID IN ALL LEVELS AS COUNT "U"!
		
		// COMMENTING 2/12/24 - CAUSING Error: 1, Uncaught TypeError: Unsupported operand types: string - int
		//$count = 'U'; // DOING INSIDE LOOP, SINCE WE INCREMENT $count AT END OF LOOP
	}
	
	// NEW SESSION SET IN HEADER, TO NOW ALLOW QUALIFYING WHEN VIEWING ALL PROGRAMS, NOT JUST BY PROGRAM
	if ($_SESSION['p'.$buffer['program_id'].'_is_qualified'] == true) $loggedin_user_can_qualify_team = true;
	
	$row_count++;	
	$last_downline_ID = '';
	
	//while ($buffer = mysql_fetch_assoc($resultu)) {	
	
	// COMMENT NEXT LINE TO SHOW ALL PROGRAMS PER USER -- NOW AUTOMATIC WITH $Global['program'] != 0
	if ($last_downline_ID == $buffer['ID'] && $Global['program'] != 0)	{ 
	// DONE TO SUPRESS SHOWING ALL PROGRAMS FOR EVERY USER!
	// THIS IS A SAFETY NET WHICH SHOULD NEVER EXECUTE -- SINCE WE ONLY HAVE ONE (ID WITH PROGRAM_ID) PER USER_PROGRAM
		$row_count = ($row_count - 1);
		//continue;		
	}	
	$last_downline_ID = $buffer['ID'];	
	
	// KEEP -- THIS SECTION IS ONLY USED WITH THE OLD METHOD, STILL ON viewteamBK.php, WHERE SEARCHING ALL PROGRAMS WILL FIRST CHECK ONLY THE MEMBERS TABLE, THEN LATER QRY USER_PROGRAM AS AN INNER LOOP. TEST TO CONFIRM AGAIN!
	//GET THAT CODE AND RE-USE IT -- THIS IS THE ONLY WAY TO SHOW USERS UNPAID IN ALL LEVELS!
	/*if ($status_to_get == 'Unpaid' && $Global['program'] == 0) { // STRIP OUT ANY ACTIVE OR COMPED USERS NOW
		$buffera['ID'] = '';
		$qrya = "SELECT ID FROM user_program WHERE ID='".$buffer['ID']."'
		AND (user_status='Active' OR user_status='Comped')";
		//echo "<br/><br/>".$qrya."<br/>";
		$resulta = mysql_query($qrya) or die($qrya.' '.mysql_error());
		$buffera = mysql_fetch_assoc($resulta);
		if ($buffera['ID'] != '') {
			$row_count = ($row_count - 1);
			continue;			
		}	
	}	
						
	$program_id = $buffer['program_id'];	
	$qryp = "SELECT * FROM program WHERE program_id={$program_id} {$Global['program_restrict']} && program_approved='Y'";
	//echo "<br/><br/>".$qryp."<br/>";
	$resultp = mysql_query($qryp) or die($qryp.' '.mysql_error());
	$bufferp = mysql_fetch_assoc($resultp);
	
	if ($status_to_get == 'Unpaid' && $_REQUEST['program'] == '') { 
		$program_name = 'Not in any level';
	} else {
		$program_name = $bufferp['program_name'];
	}
	
	// WE FIND OUT IF THIS IS A PASS UP PROGRAM
	if ($bufferp['program_up'] > 0) {
		$program_is_powerline = true;
	} else {
		$program_is_powerline = false;
	}	
	
	if ($_SESSION['loggedin'] == 'admin') {
		$exclude_admin = "AND pp.payment_type='A'";
	} else {
		$exclude_admin = "AND pp.payment_type!='A'";
	}	
	
	$qry_paid = "SELECT log.user_program_id, log.payment_processor, log.timestamp FROM payment_log AS log JOIN payment_plan AS pp WHERE log.payer_username='{$buffer['Username']}' AND log.program_id={$buffer['program_id']} AND log.payment_plan_id=pp.payment_plan_id {$exclude_admin} ORDER BY log.payment_log_id DESC";
	$result_paid = mysql_query($qry_paid) or die($qry_paid.' '.mysql_error());
	$buffer_paid = mysql_fetch_assoc($result_paid);
	*/		
	/*echo '<br>qry paid: ';
	echo $qry_paid;
	echo '<br>buffer_who_got_paid: ';
	print_r($buffer_who_got_paid);		
	*/
	/*if ($buffer_paid['timestamp'] === NULL) {
		$last_paid_date = 'N/A';
	} else {
		$last_paid_date = date('F, jS Y', $buffer_paid['timestamp']);	
	}*/
	
	$join_date_unix = strtotime($buffer['Signdate']);
	if ($join_date_unix != '') $join_date = date('F, jS Y', $join_date_unix);
	else $join_date = 'N/A';
	$phone = '';
	if ($buffer['cellphone'] != '') {
		$phone = $buffer['cellphone'];
	}	
	if ($phone == '') {
		$phone = $buffer['phone'];
	}	
	if ($phone == '') {
		$phone = 'N/A';
	} else {
		$display_phone = preg_replace("/^1?(?:[- .])?(\d{3})(?:[- .])?(\d{3})(?:[- .])?(\d{4})$/", "($1) $2-$3", $phone);
		if ($buffer['country'] == 'US') $phone = '<a href="tel:+1-'.$phone.'">'.$display_phone.'</a>';
		else $phone = '<a href="tel:-'.$phone.'">'.$display_phone.'</a>';
	}	

	//if ($program_is_powerline == true) {
		
		// CHECK IF THIS WORKS!! - SHOULD BE OK - COPIED GUTS FROM -- OLD VIEW DOWNLINE PAGE
		 //THIS WORKS EXCEPT IT DOES NOT ACCOUNT FOR POWERLINES PASSED UP TO YOU!
		//$Global['powerline_order'] = explode(',', $bufferp['program_up_order']);
		// UNTIL THIS CODE IS REVAMPED FOR PHP 8.3
		//$Global['powerline_order'] = [0]; // QQQ QUICKIE FIX TO STOP WARNINGS OF PASSING NULL
		if ($status_to_get == 'Unpaid') {
			$payline = 'N/A';
			$payline_class = 'default';
		} else if ($Global['up_powerline']==0 || !in_array($buffer['sign_id'], $Global['powerline_order'])) {
			$payline = 'My Pay Line';
			$payline_class = 'info';
		} else {
			$payline = 'Passed Up';
			$payline_class = 'warning';
		}
		
		// NEW WAY TO CHECK IS PAYMENT WAS PASSED UP -- SEE WHO REALLY GOT IT!!
		// CHECK WHO GOT PAID
		if (isset($buffer_paid['user_program_id'])) {
			$selectFields = 'm.Username';
			$mainTable = ['table' => 'members', 'as' => 'm'];
			$joinConditions = [
				['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID']
			];
			$where = [
				'u.user_program_id' => ['=', $buffer_paid['user_program_id']],
				'u.program_id' => ['=', $buffer['program_id']]
			];
			$limit = 1; // Assuming you're only interested in fetching one record
			$show_debug = 1;

			$result_who_got_paid = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, $limit, $show_debug);

			$buffer_who_got_paid = isset($result_who_got_paid[0]) ? $result_who_got_paid[0] : null;
			
			//echo '<br>';
			//print_r($buffer_who_got_paid);
		}
		
		if (!isset($buffer_who_got_paid) || !is_array($buffer_who_got_paid)) {
			$buffer_who_got_paid = [];
			$buffer_who_got_paid['Username'] = '';
		}		
	if ($buffer['user_status'] == 'Unpaid' || $buffer['user_status'] == 'Cancelled') {
			$payline = 'N/A';
			$payline_class = 'default';
		} else if ($buffer_who_got_paid['Username'] == $_SESSION['loggedin'] || 
		($buffer['user_status'] == 'Comped' && $buffer['usponsorid'] == $_SESSION['loggedin']) ||
		($buffer['usponsorid'] == $_SESSION['loggedin'] && $buffer_who_got_paid['Username'] == 'admin' && !in_array($buffer['sign_id'], $Global['powerline_order']))) {
			$payline = 'My Pay Line';
			$payline_class = 'info';
		} else if ($buffer_who_got_paid['Username'] != '' && ($buffer_who_got_paid['Username'] != $_SESSION['loggedin'])) {
			$payline = 'Passed Up..zz';
			$payline_class = 'warning';
		} else {
			$payline = 'N/A';
			$payline_class = 'default';
		}
		// QQQ MATRIX DEFAULT	
		//$payline = 'N/A';
		$payline = 'My Pay Line';
		$payline_class = 'default';		
	//}
	if ($buffer['user_status'] == 'Unpaid') $label = "default";
	if ($buffer['user_status'] == 'Suspended') $label = "warning";
	if ($buffer['user_status'] == 'Cancelled') $label = "danger";
	if ($buffer['user_status'] == 'Active') $label = "success";
	if ($buffer['user_status'] == 'Comped') $label = "success";
	$status = '<span class="btn btn-'.$label.'">'.$buffer['user_status'].'</span>';
	
	$email = '<a href="mailto:'.$buffer['email'].'?subject='.$Global['webpage_name'].'%20Follow%20Up%20For%20'.$buffer['First_Name'].'&body=Hey%20'.$buffer['First_Name'].',%0D%0A%0D%0A

	Have you taken the time to really check out the '.$Global['webpage_name'].' program?%0D%0A%0D%0A

	Let me show you how to work this amazing business. Explore, and upgrade now: '.$Global['webpage_url'].'?id='.$buffer['Username'].'%0D%0A%0D%0A

	Take action now and make a change!%0D%0A%0D%0A
	  
	Sincerely,
	%0D%0A'.$_SESSION['Firstname_loggedin'].'%0D%0A'.$_SESSION['Phone_loggedin'].'">'.$buffer['email'].'</a>';
	
	$loggedin_user = $_SESSION['loggedin'];
	
	if ($buffer['email'] == '') $email = 'N/A';
	// SELECTING ONLY FEES NOT PAID TO ADMIN!
	/*
	$qry_paid_tot = "SELECT sum(log.amount) AS total FROM payment_log AS log JOIN payment_plan AS pp 
	WHERE log.payer_username='{$buffer['Username']}' AND log.program_id={$buffer['program_id']}
	AND pp.username='{$loggedin_user}' AND log.payment_plan_id=pp.payment_plan_id {$exclude_admin}";
	$result_paid_tot = mysql_query($qry_paid_tot) or die($qry_paid_tot.' '.mysql_error());
	$buffer_paid_tot = mysql_fetch_assoc($result_paid_tot);
	
	$qry_paid_tot = "SELECT sum(log.amount) AS total FROM transactions_log AS log WHERE log.usrid='{$buffer['ID']}'";
	$result_paid_tot = mysql_query($qry_paid_tot) or die($qry_paid_tot.' '.mysql_error());
	$buffer_paid_tot = mysql_fetch_assoc($result_paid_tot);	
	*/

// COUNT LOGS PAID BY THIS TEAM MEMBER	
$where = [
    'payer_username' => $buffer['Username'],
    'program_id' => $buffer['program_id']
];

$result = select('COUNT(payment_log_id) as logs', 'payment_log', [], $where, null, null, null, 0, 1);
$bufferlog = $result[0];

// GET TOTAL MATRIX COMMS PAID TO LOGGEDIN USER, BY THIS TEAM MEMBER


$userID = $_SESSION['UserID'];
$where = [
    'description' => ['LIKE', "%{$buffer['Username']}%"],
    'usrid' => ['=', $userID]
];
$result = select('SUM(amount) as tot', 'transactions_log', [], $where, null, null, null, 0, 1);
$bufferlt = $result[0];

	
	$total_payments = $bufferlog['logs'];
	$lifetime_value = '';
	$lifetime_value = $bufferlt['tot'];
	if ($lifetime_value !='') $lifetime_title = '$'; else $lifetime_title = '$0';
	
		/*	echo '<br>qry paid tot: ';
			echo $qry_paid_tot;	
			echo '<br>';
			print_r($buffer_paid_tot);
	*/
	$user_program_id = $_SESSION['p'.$buffer['program_id'].'_upid'];

	/*$qry_paid_logs = "SELECT count(log.payment_log_id) AS total FROM payment_log AS log JOIN payment_plan AS pp 
	WHERE log.payer_username='{$buffer['Username']}' AND log.program_id={$buffer['program_id']}
	AND log.payment_plan_id=pp.payment_plan_id {$exclude_admin}";
	
	// REMOVED THIS SECTION FROM QRY - AS WE SHOW THESE STATS EVEN ON PASSED UP SALES ALSO!!
	// AND log.user_program_id={$user_program_id}
	
	$qry_paid_logs = "SELECT sum(log.id) AS total FROM transactions_log AS log WHERE log.usrid='{$buffer['ID']}'";
	
	
	$result_paid_logs = mysql_query($qry_paid_logs) or die($qry_paid_logs.' '.mysql_error());
	$buffer_paid_logs = mysql_fetch_assoc($result_paid_logs);
	$total_payments = '';
	$total_payments = $buffer_paid_logs['total'];
	*/

	if (is_null($buffer['started']) || $buffer['started'] == '' || $buffer['started'] == 0 || $buffer['user_status'] == 'Unpaid') {
		$activation_date = 'N/A';
	} else {
		$activation_date = date('F, jS Y', $buffer['started']);
	}
	
	// QQQ KLUDGE TO SHOW LAST PAYMENT, UNTIL PAY PLANS, LOGS CODES ARE UPDATED - FINE FOR ONE TIME PROGRAM!
	$last_paid_date = $activation_date;

	$due_date = date('F, jS Y', $buffer['expire']);
	if (is_null($buffer['expire']) || $buffer['expire'] == 0) $due_date='N/A';
	if ($buffer['user_status'] == 'Comped') $due_date = 'Never';
	
	// QQQ ONE TIME PAYMENT PROGRAM KLUDGE!
	$due_date = 'Never';
	
	$image_path = '';
	$image_url = '';
	$image_path = $Global['path'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
	
	if (file_exists($image_path)) {
		$image_url = $Global['webpage_url_ssl'].'images/Users/'.floor(($buffer['ID'] / 1000)).'/'.$buffer['ID'].'.jpg';
	} else {
		//$image_url = '/images/people.jpg';
		$image_url = '';
	}	
	
	if ($buffer['address'] == '') $buffer['address'] = 'N/A';
	if ($buffer['address2'] == '') $buffer['address2'] = 'N/A';
	if ($buffer['city'] == '') $buffer['city'] = 'N/A'; 
	if ($buffer['state'] == '') $buffer['state'] = $buffer['province'];
	if ($buffer['state'] == '') $buffer['state'] = 'N/A';
	if ($buffer['zip'] == '') $buffer['zip'] = 'N/A';	
	if ($buffer['country'] == '') $buffer['country'] = 'N/A';
	
	//////////////////////////////////////////////////
	// FIND OUT IF ON A CUSTOM SUBSCRIPTION PAY PLAN!!
	//////////////////////////////////////////////////
	/*
	// GET USER PROG ID OF THE PERSON WE WANT TO CHECK
	$qry_dl_uprog = "SELECT user_program_id FROM user_program as u JOIN members as m WHERE m.ID=u.ID AND m.Username='".$buffer['Username'])."' AND u.program_id='".$buffer['program_id'])."'";  
	//echo $qry_dl_uprog."<br/>";
	$result_dl_uprog = mysql_query($qry_dl_uprog) or die($qry_dl_uprog.' '.mysql_error());
	$buffer_dl_uprog = mysql_fetch_assoc($result_dl_uprog);
	$user_program_id = $buffer_dl_uprog['user_program_id'];
	
	// SELECT THE USER PAYMENT PLAN ///////////////////////////////////////////////////////////////////
	$result_upp = mysql_query("SELECT user_payment_plan_id, valid_plan, real_sponsorid FROM user_payment_plan WHERE user_program_id='{$user_program_id}' AND valid_plan!='H' ORDER BY valid_plan ASC, user_payment_plan_id DESC LIMIT 1") or die(mysql_error());
	$buffer_upp = mysql_fetch_assoc($result_upp);

	$valid_plan = $buffer_upp['valid_plan'];
	$user_payment_plan_id = $buffer_upp['user_payment_plan_id'];


	// SELECT THE PAYMENT PLAN PAYING THE LOGGEDIN USER /////////////////////////////////////////////////////////////
	$qry_pp = "SELECT pp.*,m.payment_collected_by FROM payment_plan as pp JOIN members as m ON (pp.username=m.Username) WHERE pp.user_payment_plan_id='{$user_payment_plan_id}' AND m.Username='".$_SESSION['loggedin'])."' ORDER BY pp.payment_plan_id ASC";
	//echo "<br/>".$qry."<br/>";
	$result_pp = mysql_query($qry_pp) or die($qry_pp.' '.mysql_error());

	$buffer_pp = mysql_fetch_assoc($result_pp);
	$payment_plan_id = $buffer_pp['payment_plan_id'];
	
	$awaiting_payment_headline = ''; // INITIALIZE VAR
	
	if ($valid_plan == 'S' && $buffer_pp['payment_complete'] == 'Y') {
		$awaiting_payment_headline = '<i class="fa fa-hand-o-right" aria-hidden="true"></i> Awaiting Admin Payment';
	}
	
	if ($valid_plan == 'S' && $buffer_pp['payment_complete'] != 'Y') {
		$awaiting_payment_headline = '<i class="fa fa-hand-o-right" aria-hidden="true"></i> Awaiting Member Payment - If You Got It - Mark Them Paid Now! &nbsp;<a href="viewteam.php?markpaid='.$buffer['Username'].'&program='.$buffer['program_id'].'&uname='.$buffer['Username'].'" target="_blank"><span class="fa fa-money" style="color: white;"></span> <span style="font-family:Helvetica, Arial; color: white; text-decoration:underline"> Mark Payment Received</span></a>
		';
	}
	// MATRIX SYSTEMS - OR ADMIN COLLECTS!!
	$awaiting_payment_headline = ''; // SET EMPTY

	// NOW CHECK CUSTOM PLANS
	$qry_cp = "SELECT 
	ucp.*,
	FROM_UNIXTIME(master.timestamp_started) as started,
	FROM_UNIXTIME(ucp.last_payment) as last,
	FROM_UNIXTIME(ucp.next_payment) as next
	FROM payment_plan as pp
	JOIN user_custom_plan as ucp 
	JOIN user_payment_plan as master 
	WHERE pp.user_payment_plan_id=master.user_payment_plan_id 
	AND pp.username='".$_SESSION['loggedin']."'
	AND ucp.payment_plan_id=pp.payment_plan_id
	AND ucp.subscription_initiated='Y'
	AND pp.payment_plan_id='{$payment_plan_id}'";
	//echo "<br/>".$qry."<br/>";
	$result_cp = mysql_query($qry_cp) or die($qry_cp.' '.mysql_error());
	$buffer_cp = mysql_fetch_assoc($result_cp);

	if ($debug == true) { 
		echo '<br>PRINT R BUFFER: ';
		print_r($buffer_cp);
		echo '<br>';
	}	
	$cp_headline = ''; // INITIALIZE VAR
	if ($buffer_cp['user_custom_plan_id'] != '') {
		$cp_headline = '<i class="fa fa-hand-o-right" aria-hidden="true"></i> You have this user set to "Auto Renew"';
	}*/

	// DEFINING ADMIN ONLY LINKS TO FIND THE USERS	  
	if ($_SESSION['admin_session_view'] == true) {
		$show_username = '<a href="../admin/Sub/Finduser.php?username='.$buffer['Username'].'" target="_blank">'.$buffer['Username'].'</a>';
		
		// NOW ADD SPONSOR INFO TO SHOW ADMIN
		$show_username .= '<br/>SID '.$buffer['sign_id'].' <a href="../admin/Sub/Finduser.php?username='.$buffer['sponsorid'].'" target="_blank">'.$buffer['sponsorid'].'</a>';

		// SHOW UPCHAIN -- WHO THE THIS DOWNLINE MEMBER PAYS
		$show_username .= '<br/><a href="../admin/Sub/getsponsorchain.php?program='.$buffer['program_id'].'&username='.$buffer['Username'].'" target="_blank"><span class="glyphicon glyphicon-link"></span>  Upchain</a>';
		
		if (isset($buffer['msponsor'])) $show_msponsor = '<a href="../admin/Sub/Finduser.php?username='.$buffer['msponsor'].'" target="_blank">'.$buffer['msponsor'].'</a>';
		else $show_msponsor = '';

	} else {
		$show_username = $buffer['Username'] ?? '';
		$show_sponsorid = $buffer['usponsorid'] ?? '';
		$show_msponsor = $buffer['msponsor'] ?? '';
	}
	
	if ($_REQUEST['aboutme'] == 1) { ?>
		<div class="table-responsive">						
	<table class="table table-condensed table-hover">
	  <thead>
		<tr><td style="width:10%; margin-top:pt; margin-bottom:pt;">
		<?php
		echo ((!empty($image_url))?'<img src="'.$image_url.'" style="float:center; width:100px; height:100px" class="circlepic img-responsive img-circle" />':'<br/><i class="fa fa-user fa-lg fa-2x text-info" style="float:center; font-size:30px;"></i>');
		echo '</td><td style="text-align:left; margin-bottom:pt;">';
		if (!empty($image_url)) $br = '<br/>'; else $br = '';
		if ($buffer['paymentprocessor8'] != '') echo $br.$buffer['paymentprocessor8'];
		else echo '<sup><h2>This user has not entered any "about me" info yet.</h2></sup>';
	?>
	<!--	
					<h4>Their Links To Promote:</h4>			

                    <strong>
<a href="<?php echo $Global['webpage_url_ssl']; ?>lc1.php?id=<?php echo $buffer['Username']; ?>" target="_blank">
<?php echo $Global['webpage_url_ssl']; ?>lc1.php?id=<?php echo $buffer['Username']; ?></a>		
<br/>						
					
<a href="<?php echo $Global['webpage_url_ssl']; ?>?id=<?php echo $buffer['Username']; ?>" target="_blank">
<?php echo $Global['webpage_url_ssl']; ?>?id=<?php echo $buffer['Username']; ?>
</a></strong>
-->
<?php		
		echo '</td></tr></thead></table><br/>';
	}

	if ($_REQUEST['address'] == 1) { ?>
		<div class="table-responsive">						
	<table class="table table-condensed table-hover">
	  <thead>
		<tr><td style="width:10%; margin-top:pt; margin-bottom:pt;">
		<?php
		echo ((!empty($image_url))?'<img src="'.$image_url.'" style="float:center; width:100px; height:100px" class="circlepic img-responsive img-circle" />':'<br/><i class="fa fa-user fa-lg fa-2x text-info" style="float:center; font-size:30px;"></i>');
		echo '</td><td style="text-align:left; margin-bottom:pt;">';
		if (!empty($image_url)) $br = '<br/>'; else $br = '';
		
	echo '<h3>'.$buffer['First_Name'].' '.$buffer['Last_Name'].'</h3>';
	if ($buffer['address'] == 'N/A') echo 'Street Address N/A<br/>';
	else echo $buffer['address'].'<br/>';
	if ($buffer['address2'] != 'N/A') echo $buffer['address2'].'<br/>';
	if ($buffer['city'] == 'N/A') echo 'City N/A '; 
	else echo $buffer['city'].' ';
	if ($buffer['state'] == 'N/A') echo 'State N/A ';
	else echo $buffer['state'].' ';
	if ($buffer['zip'] == 'N/A') echo 'ZIP N/A ';
	else echo $buffer['zip'];
	if ($buffer['country'] == 'N/A') echo 'Country N/A';
	else echo ' '.$buffer['country'];
		echo '</td></tr></thead></table><br/>';
	}

	if (isset($_REQUEST['pay_methods']) && $_REQUEST['pay_methods'] == 1) { ?>
		<div class="table-responsive">						
	<table class="table table-condensed table-hover">
	  <thead>
		<tr><td style="width:10%; margin-top:pt; margin-bottom:pt;">
		<?php
		echo ((!empty($image_url))?'<img src="'.$image_url.'" style="float:center; width:100px; height:100px" class="circlepic img-responsive img-circle" />':'<br/><i class="fa fa-user fa-lg fa-2x text-info" style="float:center; font-size:30px;"></i>');
		echo '</td><td style="text-align:left; margin-bottom:pt;">';
		if (!empty($image_url)) $br = '<br/>'; else $br = '';
		
	echo '<h3>'.$buffer['First_Name'].' '.$buffer['Last_Name'].' ('.$buffer['Username'].') ';
	echo 'Payments collected by: '.$buffer['payment_collected_by'].'</h3>';
	
		echo '<h3><span class="text-info btn-block">Below you will see this user\'s payment options, as they appear on the payment page, to their referrals. If you spot any errors, or way to improve, you should alert them!</h3></span>';	
	
		echo '</td></tr></thead></table>';
		
		echo '<h3><span class="text-danger btn-block">Payment links are the same for all programs. Member must be Active to receive payments.</h3></span>';		

		echo '<h3><span class="text-danger btn-block">NOTE: Any payment links shown below, are for test purposes only!</h3></span>';

		echo '<br/><div class="clearfix"></div>';
	if ($buffer['payment_collected_by'] == 'member') {
		$_SESSION['program_collect'] = 'E';		
	} else {
		$_SESSION['program_collect'] = 'A';
	}		
		
		$test = true;
		$value['id'] = 1;
		$value['amount'] = 1.00;
		$Global['program_type'] = 'N';
		$Global['payment_duration'] = 'N';
		$Global['allow_onetime_payment'] = true; 
		$Global['sub_period'] = 0;
		$Global['program_type'] = 'N';
		$value['plan_type'] = 'N';
		$buffer_receiver = $buffer;
// CREATE FIRST DATA E4 TEST CREDENTIALS IF NEEDED, TO RUN TESTS, IF ADMIN OR PAYEE HAS NO E4
if ($_SESSION['program_collect'] == 'E' && empty($buffer['e4gatewayID'])) {
	$Global['use_E4'] = true;
	$buffer['e4MerchName'] = 'TEST MERCHANT NAME';
	$buffer['e4gatewayID'] = 1;
	$buffer['e4password'] = 1;
}			

// CREATE FIRST DATA E4 TEST CREDENTIALS IF NEEDED, TO RUN TESTS, IF ADMIN OR PAYEE HAS NO E4
if ($_SESSION['program_collect'] == 'A' && empty($buffer['e4gatewayID'])) {
	$Global['use_E4'] = true;
	$buffer['e4MerchName'] = 'TEST MERCHANT NAME';
	$buffer['e4gatewayID'] = 1;
	$buffer['e4password'] = 1;
}	
// DO NOT USE NEXT SESSION, OR MEMBERS WILL BE ABLE TO "BUY" FREE PERIODS, DOING CC TESTS!!
$_SESSION['test_credit_cards'] = false;		
		include '../apay/Ipns.inc.php'; // SHOW PAYMENT BUTTONS
		echo '<div class="clearfix"></div><br/>';
	}
	
	
	$selectFields = '*'; // Selecting all fields
	$mainTable = 'program'; // The table from which to select
	$where = [
		'program_id' => ['=', $buffer['program_id']],
		'program_approved' => ['=', 'Y']
	];
	$limit = 1; // Assuming you only want one record
	$show_debug = 1; // Assuming you want to show debug information

	// Execute the query
	$result_up = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);

	// Assuming select returns an array of results, and you're interested in the first one
	$buffer_up = isset($result_up[0]) ? $result_up[0] : null;


	$Global['program_type'] = $buffer_up['program_type'];
	$Global['program_name'] = $buffer_up['program_name'];
	$Global['up_powerline'] = $buffer_up['program_up'];
	
	
	?>	
	<div class="table-responsive">						
	<table class="table table-condensed table-striped table-bordered table-hover nQQQo-margin" style="margin:#">
	  <thead>
		<tr>
		  <th style="width:4%"><div style="color:#58A1CB">
		  <?php echo ((!empty($image_url))?'<img src="'.$image_url.'" style="float:center; width:25px; height:25px" class="circlepic img-responsive img-circle" />':'<i class="fa fa-user fa-lg"></i>');?> 
		  <!--
		  <i class="fa fa-user"></i>
		  -->
		  </div></th>
		  <th style="width:16%">Username</th>
          <th style="width:20%">Name</th>
          <th style="width:20%">Program Level</th>
          <th style="width:20%">Status</th>
          <th style="width:20%">Payline</th>
        </tr>
      </thead>
    <tbody>						
    <tr>
        <td><?php echo $count; ?></td>
		<td><?php echo $show_username; ?></td>
        <td><?php echo $buffer['First_Name']." ".$buffer['Last_Name']; ?></td>
		<td><?php echo $program_name; ?></td>  
        <td><?php echo $status; ?></td>
		<td><span class="btn btn-<?php echo $payline_class; ?>"><?php echo $payline; ?></span> 
		</td>
	</tr>
    <tbody>
	</table>
	</div>

	<?php 
	if ($_REQUEST['address'] == '1') {
	?>	
	<div class="table-responsive">						
	<table class="table table-condensed table-striped table-bordered table-hover nQQQo-margin">
	  <thead>
		<tr style="background-color:#efefff">
		  <th style="width:20%">City</th>
          <th style="width:20%">State</th>
          <th style="width:20%">Country</th>
          <th style="width:20%">Payments Made</th>
          <th style="width:20%">Lifetime Value To Date</th>
        </tr>
      </thead>
    <tbody>						
    <tr>
		<td><?php echo $buffer['city']; ?></td>
        <td><?php echo $buffer['state']; ?></td>
		<td><?php echo $buffer['country']; ?></td>  
        <td><span class="btn btn-<?php echo $total_payments_class; ?>"><?php echo $total_payments; ?></span></td>
		<td><span class="btn btn-<?php echo $lifetime_value_class; ?>"><?php echo $lifetime_title.$lifetime_value; ?></span></td>
	</tr>
    <tbody>
	</table>
	</div>	
	<?php }
	?>	
	
	<div class="table-responsive">
	<table class="table table-condensed table-striped table-bordered table-hover no-margin">
		<thead>
        <tr style="background-color:#efefff">
          <th style="width:20%">Phone</th>
          <th style="width:20%">Email</th>
          <th style="width:20%">Join Date / Activation Date</th>
          <th style="width:20%">Last Paid Date / Due Date</th>					  
          <th style="width:20%">More</th>
       </tr>
     </thead>
	<tbody>						
    <tr>
	<td><?php echo $phone; ?></td>
	<td><?php echo $email; ?></td>
	<td><?php echo $join_date; ?><br/><?php echo $activation_date; ?></td>          
	<td><?php echo $last_paid_date; ?><br/><?php echo $due_date; ?></td>

    <td>
	<!-- ACTION BUTTON 1 -->
	<div class="dropdown">
    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown">
      Action
	      <span class="caret"></span>
    <span class="sr-only">Toggle Dropdown</span>
    </button>
    <div class="dropdown-menu">
<!-- HIDING FOR MATRIX ONLY SYSTEM -->
<?php if ($program_is_matrix != true) { ?>
	<?php if ($buffer['user_status'] != 'Cancelled' && $buffer['user_status'] != 'Active' && $payline != 'Passed Up') { ?>
	<a class="dropdown-item btn btn-success btn-xs" style="width:100%; text-align:left" href="viewteam.php?markpaid=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>" target="_blank"><span class="fa fa-money"></span> Mark Payment Received</a>	
	<div class="dropdown-divider"></div>
	
	<?php 
	// QQQ HIDING FOR ONE TIME FEE PROGRAM!
	if (false && $buffer['user_status'] != 'Cancelled' && $cp_headline != '') { ?>
	<a class="dropdown-item btn btn-danger btn-xs" style="width:100%; text-align:left" href="viewteam.php?markunpaid=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>" target="_blank"><span class="fa fa-bank"></span> Mark Payment NOT Received</a>	
	<div class="dropdown-divider"></div>		
	<?php }
	
	if ($bufferq['user_status'] != 'Cancelled' && $loggedin_user_can_qualify_team == true && 
	($buffer['user_status'] == 'Active' || $buffer['user_status'] == 'Comped') &&
	($buffer['user_qualify'] != $Global['up_powerline'] && $buffer['user_qualify_perm'] != $Global['up_powerline'])) { ?>
	<a class="dropdown-item btn btn-success btn-xs" style="width:100%; text-align:left" href="viewteam.php?qualify_user=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>" target="_blank"><span class="fa fa-bank"></span> Auto Qualify This User</a>	
	<div class="dropdown-divider"></div>		
	<?php }
	
	if ($bufferq['user_status'] != 'Cancelled' && $loggedin_user_can_qualify_team == true && 
	($buffer['user_status'] == 'Active' || $buffer['user_status'] == 'Comped') &&
	($buffer['user_qualify'] != $Global['up_powerline'] && $buffer['user_qualify_perm'] == $Global['up_powerline'])) { ?>
	<a class="dropdown-item btn btn-danger btn-xs" style="width:100%; text-align:left" href="viewteam.php?qualify_user=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>&undo=yes" target="_blank"><span class="fa fa-bank"></span> Cancel Auto Qualify on This User</a>	
	<div class="dropdown-divider"></div>		
	<?php }	
	} // END PAYLINE IS NOT PASSED UP
	?>
<?php } ?>
	<!-- END HIDE FOR MATRIX ONLY SYSTEMS -->
	<?php
	if ($_REQUEST['program'] == '') {
	?>
	<a class="dropdown-item btn btn-info btn-xs" style="width:100%; text-align:left" href="viewteam.php?Username=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>"><span class="fa fa-user"></span> Show Only This Program</a>	
	<div class="dropdown-divider"></div>	
	
	<?php } else if ($_REQUEST['powerlines'] == '' && isset($_SESSION['p2_status'])) { ?>
	<a class="dropdown-item btn btn-info btn-xs" style="width:100%; text-align:left" href="viewteam.php?Username=<?php echo $buffer['Username']; ?>"><span class="fa fa-sitemap"></span> Show All Programs</a>	
	<div class="dropdown-divider"></div>
	<?php } ?>
	
	<?php 
	if ($_REQUEST['powerlines'] != '') $powerlines_link = '&powerlines='.$_REQUEST['powerlines'];
	else $powerlines_link = '';	
	
	
	if ($_REQUEST['aboutme'] == '') {
	?>
	<a class="dropdown-item btn btn-warning btn-xs" style="width:100%; text-align:left" href="viewteam.php?Username=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&aboutme=1<?php echo $powerlines_link; ?>" target="_blank"><span class="fa fa-user"></span> Show User's "About Me" Info</a>	
	<div class="dropdown-divider"></div>	
	
	<?php }

	if ($_REQUEST['address'] == '') {
	?>
	<a class="dropdown-item btn btn-primary btn-xs" style="width:100%; text-align:left" href="viewteam.php?Username=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?><?php echo $powerlines_link; ?>&address=1" target="_blank"><span class="fa fa-drivers-license-o"></span> Show User's Address</a>	
	<div class="dropdown-divider"></div>	
	
	<?php } ?>		

<?php if ($program_is_matrix != true) { ?>
	<?php // MATRIX - DISABLED LIMK WITH false &&
	if ($_REQUEST['pay_methods'] == '') { ?>
	<a class="dropdown-item btn btn-danger btn-xs" style="width:100%; text-align:left" href="viewteam.php?Username=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?><?php echo $powerlines_link; ?>&pay_methods=1"><span class="fa fa-credit-card"></span> Show User's Payment Methods</a>	
	<div class="dropdown-divider"></div>	
	
	<?php } ?>	
<?php } ?>
	
	<?php /*if ($_REQUEST['sms'] == '') { ?>
	<a class="dropdown-item btn btn-success btn-xs" style="width:100%; text-align:left" href="viewteam.php?Username=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&sms=1"><span class="fa fa-phone"></span> Send User Text Message</a>	
	<div class="dropdown-divider"></div>	
	
	<?php }*/ ?>
	  
	
    </div>
	</div>
	<!-- END ACTION BUTTON 1 -->
	</td>
	</tr>
	</tbody>
	</table>
	</div>
	
	<?php if ($payline == 'Passed Up' && $buffer_who_got_paid['Username'] != '') { ?>
	<div class="table-responsive">						
	<table class="table table-condensed table-striped table-bordered table-hover no-margin">
	  <thead>
		<tr class="btn-info" style="background-color:">
		  <th style="width:100%">
		  <?php if ($buffer['unpaid_ref'] != '') echo 'Unpaid Referral '; ?>
		  
		  <?php if ($buffer_who_got_paid['Username'] != '') { ?>		  
		  Paid To <?php echo $buffer_who_got_paid['Username']; 
		  } ?>
		  </th>
        </tr>
      </thead>
	</table>
	</div>	
	<?php } ?>
	
	<!-- END DIRECT DOWNLINE TABLE -->
	
	<?php if ($_REQUEST['powerlines']) { 
	if ($buffer['unpaid_ref'] != '') {
		$powerline_desc = 'Sale (unpaid referral)';
	} else if (!in_array($buffer['sign_id'], $Global['powerline_order'])) {
		$powerline_desc = '(Replacement Sale '.$buffer['sign_id'].')';
	} else {
		$powerline_desc = '(Sale '.$buffer['sign_id'].')';
	}
	?>
	<div class="table-responsive">
	<table class="table table-condensed table-striped table-bordered table-hover no-margin">
		<thead>
        <tr style="background-color:#eeffd7">
          <th style="width:100%"><span style="color:#00b3fe; font-size:20px;">
<i class="fa fa-mail-forward fa-1x fa-fw"></i>
</span> <!--Powerline--> <?php echo $powerline_desc; ?> Passed Up From <?php echo $show_msponsor; ?>

<?php if ($buffer['unpaid_ref'] != '') echo 'Program Sponsor: '.$buffer['usponsorid']; ?>
</th>
       </tr>
     </thead>
	<tbody>						
	</tbody>
	</table>
	</div>	
	<!-- END TABLE -->	
	<?php } ?>
	
	<?php if ($status_to_get == 'Suspended' || $status_to_get == 'Cancelled' || $status_to_get == 'Unpaid') { 
	if ($status_to_get == 'Suspended') {
		$exp_class = 'btn-warning';
		if (isset($buffer['date_suspended'])) {
			$exp_date = strtotime($buffer['date_suspended']);
			$status_desc = 'Suspended on: '.date('F, jS Y', $exp_date);
		} else {
			$status_desc = 'N/A';
		}			
	} else {
		$exp_class = 'btn-danger';
		if (isset($buffer['date_cancelled'])) {
			$exp_date = strtotime($buffer['date_cancelled']);		
			$status_desc = 'Cancelled on: '.date('F, jS Y', $exp_date);
		} else {
			$status_desc = 'N/A';
		}	
	}
	if ($status_to_get == 'Unpaid') $status_desc = 'Awaiting Admin Payment';
	?>
	<div class="table-responsive">
	<table class="table table-condensed table-striped table-bordered table-hover no-margin">
		<thead>
        <tr class="<?php echo $exp_class; ?>" style="background-color:#">
          <th style="width:100%"><span style="color:#fff; font-size:20px;">
<i class="fa fa-mail-forward fa-1x fa-fw"></i>
</span> <?php echo $status_desc; ?>
</th>
       </tr>
     </thead>
	<tbody>						
	</tbody>
	</table>
	</div>	
	<!-- END TABLE -->	
	<?php } if ($cp_headline != '') { ?>

<a href="viewteam.php?markunpaid=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>" target="_blank">		
	<div class="table-responsive">
	<table class="table table-condensed table-striped table-bordered table-hover no-margin">
		<thead>
        <tr class="btn-success" style="background-color:#">
          <th style="width:100%"><span style="color:#fff; font-size:20px;">
</span> <?php echo $cp_headline; ?>
</th>
       </tr>
     </thead>
	<tbody>						
	</tbody>
	</table>
	</div>
	</a>
	<!-- END TABLE -->		
	<?php } ?>
	
	<?php if ($awaiting_payment_headline != '') { ?>
	<div class="table-responsive">
	<table class="table table-condensed table-striped table-bordered table-hover no-margin">
		<thead>
        <tr class="btn-warning" style="background-color:#">
          <th style="width:100%"><span style="color:#fff; font-size:20px;">
</span> <?php echo $awaiting_payment_headline; ?>
</th>
       </tr>
     </thead>
	<tbody>						
	</tbody>
	</table>
	</div>
	<!-- END TABLE -->		
	<?php } ?>	
	
	
	<?php if ($buffer['user_qualify_perm'] == $Global['up_powerline'] && $Global['up_powerline'] != 0) { ?>

<a href="viewteam.php?qualify_user=<?php echo $buffer['Username']; ?>&program=<?php echo $buffer['program_id']; ?>&userid=<?php echo urlencode(base64_encode($buffer['ID'])); ?>&undo=yes" target="_blank">
		
	<div class="table-responsive">
	<table class="table table-condensed table-striped table-bordered table-hover no-margin">
		<thead>
        <tr class="btn-info" style="background-color:#">
          <th style="width:100%"><span style="color:#fff; font-size:20px;">
</span> <i class="fa fa-hand-o-right" aria-hidden="true"></i> You have this user "Auto Qualified"
</th>
       </tr>
     </thead>
	<tbody>						
	</tbody>
	</table>
	</div>
	</a>
	<!-- END TABLE -->		
	<?php } ?>	
	
	
	<br/>						
    <?php 
    $count = $count - 1;
	//} // END INNER LOOP (MEMBERS AND USER PROGRAM TABLES)
} // END MASTER LOOP (MEMBERS AND MEMBER LINK TABLES)
?>
                        
<?php if (false && $program_is_powerline == true) { ?>
<br />&nbsp;<br />
<h2>Sales Passed Up To You:</h2>

Sale passed up from

<?php
}

if ($debug == true) echo '<br/>row count: '.$row_count;


if ($bypass_teamview == false) { 
	if (/*$_SESSION['viewteam_qry'] != '' && */$_REQUEST['program'] != '' && $_REQUEST['Username'] == '') { ?>
	<br/>
	<div class="" style="text-align:center;">
		<form name="extractor" method="post" action="viewteam.php">
		<input type="hidden" name="program" value="<?php echo $Global['program']; ?>">
		<input type="hidden" name="action" value="extract">	
		<input type="submit" class="btn btn-default btn-xs" value="Extract <?php echo $headline; ?>"> 
		</form>
	</div><br/><br/>
	<div class="clearfix"></div>
	<?php 
	}	 
} // END BYPASS IS FALSE
?>


<div style="text-align:right; margin-right:40px;">
<ul class="pagination">
<li>
<?php 
$pag_vars = '?program='.$_REQUEST['program'].'&status='.$_REQUEST['status'].'&Username='.$_REQUEST['Username'].'&';	
$pag_vars .= 'find='.$_REQUEST['find'].'&way='.$_REQUEST['way'].'&colname='.$_REQUEST['colname'].'&';	
$pag_vars .= 'powerlines='.$_REQUEST['powerlines'].'&country='.$_REQUEST['country'].'&dateway='.$_REQUEST['dateway'].'&';
$pag_vars .= 'start_date='.$_REQUEST['start_date'].'&end_date='.$_REQUEST['end_date'].'&markedpaid='.$_REQUEST['markedpaid'].'&';
if (isset($page) && $total_pages != '')
// QQQ BYPASS PAGINATION FOR TCS
echo pagination_links($page, $total_pages, 6, 'viewteam.php'.$pag_vars, array('page' => 'Page', 'first' => 'first', 'last' => 'last'));
?>
</li>
</ul>
</div>
 <script>
     $(function () {
   var bindDatePicker = function() {
		$(".date").datetimepicker({
        format:'YYYY-MM-DD',
			icons: {
				time: "fa fa-clock-o",
				date: "fa fa-calendar",
				up: "fa fa-arrow-up",
				down: "fa fa-arrow-down"
			}
		}).find('input:first').on("blur",function () {
			// check if the date is correct. We can accept dd-mm-yyyy and yyyy-mm-dd.
			// update the format if it's yyyy-mm-dd
			var date = parseDate($(this).val());

			if (! isValidDate(date)) {
				//create date based on momentjs (we have that)
				date = moment().format('YYYY-MM-DD');
			}

			$(this).val(date);
		});
	}
   
   var isValidDate = function(value, format) {
		format = format || false;
		// lets parse the date to the best of our knowledge
		if (format) {
			value = parseDate(value);
		}

		var timestamp = Date.parse(value);

		return isNaN(timestamp) == false;
   }
   
   var parseDate = function(value) {
		var m = value.match(/^(\d{1,2})(\/|-)?(\d{1,2})(\/|-)?(\d{4})$/);
		if (m)
			value = m[5] + '-' + ("00" + m[3]).slice(-2) + '-' + ("00" + m[1]).slice(-2);

		return value;
   }
   
   bindDatePicker();
 });
  //# sourceURL=pen.js
  </script>
<!--
<h3>Find the team member, and use the "Action" button for all team management options
<br/>(marking a user paid or qualified, for example).</h3>
--><!--
<h4>NOTE: You must be Qualified in a program level before you can qualify your team in that level.
<br/>You may only Auto Qualify team members who are Active or Comped.</h4>
<h4>So (once you are Qualified) first mark a team member paid (Mark Payment Received)
<br/>and then 
-->
<!--(once Admin has ALSO marked them paid for the admin fee)--> <!--you may Auto Qualify them (if desired).</h4>-->
<?php
include './../Sub/tpl/footer_tpl.php';
?>