<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.

// LEAVING THESE VARS TO THE ORIGINAL "$Global", AS THEY DO NOT NEED TO CLUTTER THE $GLOBALS ARRAY.
// THEY ARE ONLY USED IN A FEW FILES
// THIS FILE NEEDS TO BE INCLUDED WHERE EMAIL IS SENT OUT

//This is the email sent to all affiliates that receive commission
$Global['email_affiliate_com_subject'] = "Store [store_name] Commission received";
$Global['email_affiliate_com_message'] = <<<EOR
Congratulations [name],

You have received commission in the [store_name] store of the following amount: [amount]

Regards
Store Administration
EOR;


//This is the email sent to the affiliate of a sale
$Global['email_affiliate_subject'] = "An affiliate sale for store [store_name]";
$Global['email_affiliate_message'] = <<<EOR
Congratulations [name],

You have made an affiliate sale in the store "[store_name]" to the following customer:

Name: [cus_name]
Phone: [cus_phone]
E-mail: [cus_email]

Regards
Store Administration
EOR;


//This is the email sent to the affiliate of a sale
$Global['email_affiliate_subject'] = "An affiliate sale";
$Global['email_affiliate_message'] = <<<EOR
congratulations [name],

You have made an affiliate sale to the following customer:

[cus_name]

Phone:
[cus_phone]

E-mail:
[cus_email]

Regards
Site Administration
EOR;



//Unsubscribe text added to the bottom of the emails the program users are allowed to send to their downline.
//Custom Tags : [webpage_name] [program_name] [firstname] [lastname] [unsubscribe_link]
$Global['unsubscribe_email_text'] = <<<EOR
This email was sent to you by your [program_name] sponsor, [firstname] [lastname]

To remove yourself completely from [webpage_name], click here [unsubscribe_link]
EOR;



//Unsubscribe text added to the bottom of the nag emails the program sends out if the function is enabled.
//Custom Tags : [webpage_name] [unsubscribe_link]
$Global['unsubscribe_email_text_nag'] = <<<EOR
To remove yourself completely from [webpage_name], click here [unsubscribe_link]
EOR;

//Unsubscribe text added to the bottom of the lead emails the program users send out to their leads.
$Global['unsubscribe_email_text_lead'] = <<<EOR
This leads update email was sent to you by your [program_name] referrer, [firstname] [lastname]

To remove yourself from this leads list with [webpage_name], click here [unsubscribe_link]
EOR;


//Security Emails
	//This error email is sent out if someone makes a subscription payment on a program that does not require it
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [paid_to_email] [firstname] [lastname] [paid_with_processor_name]
$Global['email_sub_payment_subject'] = "[program_name] Alert";
$Global['email_sub_payment_message'] = <<<EOR
Hello [firstname], 

You are signing up for [program_name], and have finished a payment to [paid_to_email] through [paid_with_processor_name].

This program is not subscription based, but your payment is a subscription. 

So please make sure you cancel any future subscription payments. BUT make sure you do not
cancel the payment that has been finished, or your program status will be revoked and 
you will lose any sales until the payment is completed again.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;


	//This error email is sent out if someone makes a normal payment on a subscription program
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [paid_to_email] [firstname] [lastname] [paid_with_processor_name] [subscription_days]
$Global['email_normal_payment_subject'] = "[program_name] Alert";
$Global['email_normal_payment_message'] = <<<EOR
Hello [firstname], 

You are signing up for [program_name], and have finished a payment to [paid_to_email] through [paid_with_processor_name].

This program is subscription based, but your payment was a normal one time payment. 

Please note, that if the next expected payment is not paid within [subscription_days] days your subscription will terminate, and all your lines will be passed on.

If the termination process is activated, there is NO WAY to get your lines back.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;


	//This error email is sent out if someone creates a subscription program that does not fit the subscription days
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [paid_to_email] [firstname] [lastname] [paid_with_processor_name] [subscription_days] [subscription_setup]
$Global['email_sub_wrong_period_payment_subject'] = "[program_name] Alert";
$Global['email_sub_wrong_period_payment_message'] = <<<EOR
Hello [firstname], 

You are signing up for [program_name], and have finished a payment to [paid_to_email] through [paid_with_processor_name].

You have setup the subscription to be paid each [subscription_setup] days. The subscription needs to be setup to [subscription_days].

Please note that if the next expected payment is not paid within [subscription_days] your subscription will terminate, and all your team will be passed on.

If the termination process is activated, there is NO WAY to get your lines back.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Thanks

Regards
Site Administration
EOR;


	//This error email is sent out if someone makes a subscription payment and does not set the payment again to unlimited
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [paid_to_email] [firstname] [lastname] [paid_with_processor_name] [round_times]
$Global['email_sub_rounds_payment_subject'] = "[program_name] Alert";
$Global['email_sub_rounds_payment_message'] = <<<EOR
Hello [firstname], 

You are signing up for [program_name], and have finished a payment to [paid_to_email] through [paid_with_processor_name].

You have setup the subscription to send over a payment [round_times] time(s).

Please make sure that you setup a new subscription before this one ends. If you fail to do so, your subscription will terminate, and all your team will be passed on.

If the termination process is activated, there is NO WAY to get your lines back.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;



	//This error email is sent out if someone makes a subscription payment, and tries to cheat on the trial time
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [paid_to_email] [firstname] [lastname] [paid_with_processor_name] [trial_time] [trial_system]
$Global['email_trial_payment_subject'] = "[program_name] Alert";
$Global['email_trial_payment_message'] = <<<EOR
Hello [firstname], 

You are signing up for [program_name], and have finished a payment to [paid_to_email] through [paid_with_processor_name].

You have setup a trial period on [trial_time] days, while it should have been [trial_system] days. This will not affect the program in any way, but your subscription period might be setup to pay too late.

Please note that if the next expected payment is not paid in time your subscription will terminate, and all your team will be passed on.

If the termination process is activated, there is NO WAY to get your lines back.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;


	//This error email is sent to the admin if there is a error with the payment amount in the system, meaning someone has edited a live program!
	//Custom Tags subject: [program_name]
	//Custom Tags message: [program_name] [paid_with_processor_name]
$Global['email_admin_payment_subject'] = "[program_name] Alert";
$Global['email_admin_payment_message'] = <<<EOR
Hello, 

There is an issue with [program_name]. 

It may be only related to [paid_with_processor_name], but most probably the cause is that someone has changed the payment values on a live program!

Make sure you fix the issue ASAP, as now it terminates valid payments.

This message was auto generated by your Automatic Web Software script.
EOR;




//System Emails
	//This email is sent out when someone receive money, only on IPN based payment methods.
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [paid_from_username] [paid_from_email] [firstname] [lastname] [paid_with_processor_name] [payment_type] [amount]
$Global['email_ipn_payment_subject'] = "[program_name] Alert";
$Global['email_ipn_payment_message'] = <<<EOR
Hello [firstname], 

You have a new active referral [paid_from_username], in [program_name].

Thanks and congratulations!

Regards
Site Administration
EOR;


	//This email is sent out when someone receive money, from a cc payment
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [paid_from_username] [paid_from_email] [firstname] [lastname] [paid_with_processor_name] [payment_type] [amount]
$Global['email_cc_payment_subject'] = "[program_name] Alert";
$Global['email_cc_payment_message'] = <<<EOR
Hello [firstname], 

You have received a [payment_type] payment amount of $[amount], for [program_name],
from [paid_from_username], paid through our merchant account.

This payment is pending and will be available for you to withdraw after {$Global['cc_grace']} days. 

Please note, that you can check how much money you have pending, from our members area.

Thanks and congratulations!

Regards,
Site Administration
EOR;


	//This email is sent out when a TempComp member reaches the qualifying number of members
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [qualify_up] [grace_expire]
$Global['email_tempcomp_subject'] = "[program_name] Alert";
$Global['email_tempcomp_message'] = <<<EOR
Hello [firstname], 

Congratulations! In [program_name], you have reached [qualify_up] users under you, which is the required qualification. 

You will need to upgrade your account to paid, before [grace_expire]. If you don't upgrade by this date, you will lose all new powerline sales made after this date, to your upline, and there will be NO WAY to get those lines back.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;


	//This email is sent out when there is x days left before the next subscription payment should be paid
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [expire_date]
$Global['email_payment_notification_subject'] = "[program_name] Alert";
$Global['email_payment_notification_message'] = <<<EOR
Hello [firstname], 

We greatly appreciate your membership in [program_name], and hope you are getting a lot out of the program!

This email is to remind you that your subscription due date is [expire_date].

If you last paid via credit card, that will be used to rebill your account, if you do not have enough earned commissions to cover your subscription.

Otherwise, you'll need to make another payment before or on the expiration date. Please note that the payment will add a new period on top of the current one, so you may pay it at any time.

You will not lose any time by paying in advance.

If you have enough accrued commissions, you may use those to pay for your next month membership. This will be automatic, if you take no action.

Please do not let your subscription lapse, or you will lose your future sales, and there is NO WAY to get those commissions back.

Please renew here: {$Global['webpage_url_ssl']}apay/pay.php?resub=Y

Thanks for your prompt attention in this matter.

We wish you great success with our program!

Regards
Site Administration

You are receiving this email as a member of our program. If you wish to be removed, please click here: [UNSUBSCRIBE]
EOR;

//If you have setup a subscription payment method, you just need to make sure that you have the funds required in your account, or available room on your credit card.
//If you made a one time payment (i.e. you did not set up a subscription payment), then you need to make another payment before the expiration date. 


	//This email is sent out when we set the grace time
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [grace_date] [need_to_pay]
$Global['email_grace_notification_subject'] = "[program_name] Alert";
$Global['email_grace_notification_message'] = <<<EOR
Hello [firstname], 

Your subscription in [program_name], has expired. In the event this is a misunderstanding, we have put your subscription in a grace period that expires on [grace_date].

If you do not pay your subscription fee before that date, you will lose your team.

You need to finish your payments to:
[need_to_pay]

Please go to the [program_name] payment page and process the payment.

Our system does not update the payment as paid before it has been processed and the payment has been received. This means if you pay with an e-check, your grace period might expire while you are waiting on the funds to clear.

You will not gain any time by paying right before the grace period expires. Our system does take the grace period into calculation, and will update the subscription accordingly. Due to this, it is much better to finish the payment process as soon as possible, to prevent a possible loss of your team and service. 

Thank you.

Regards
Site Administration
EOR;


	//This email is sent out on a chargeback, it is sent to the user who lost money
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [processor] [transaction_id] [by_user] [date] [chargeback_grace]
$Global['email_chargeback_victim_subject'] = "[program_name] Alert";
$Global['email_chargeback_victim_message'] = <<<EOR
Hello [firstname], 

We have processed a chargeback against your [program_name] account on [date]. 

The chargeback was initiated on a payment with transaction id [transaction_id] on payment processor [processor] by [by_user].

We have updated your account so the payment is now displayed as a chargeback, and the amount involved was removed from your account statistics.

We have also taken action against the user that initated the chargeback, the payment has been removed and his/her account will be terminated if a new payment has not been processed within [chargeback_grace] days. 

Regards,
Site Administration
EOR;


	//This email is sent out on a chargeback, it is sent to the user who initiated it
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [processor] [transaction_id] [against_user] [date] [chargeback_grace]
$Global['email_chargeback_starter_subject'] = "[program_name] Alert";
$Global['email_chargeback_starter_message'] = <<<EOR
Hello [firstname], 

We have processed a chargeback you initiated against [program_name] account [against_user] on [date]. 

The chargeback was initiated on a payment with transaction id [transaction_id] on payment processor [processor].

We have taken action against your account and removed the payment. Depending on the payment's status, your account might have been put into grace period. If that is the case you have received an additional email stating that. 

If your account was put into a grace period, please note that you need to process a new payment to the user within [chargeback_grace] days. Otherwise your account will be terminated, and all powerlines/teams will be lost.

Chargebacks are not taken lightly. If a user creates several chargebacks his/her account(s) will be terminated!

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;


	//This email is sent out when a TempComp grace period expire
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [date]
$Global['email_tempcomp_notification_subject'] = "[program_name] Alert";
$Global['email_tempcomp_notification_message'] = <<<EOR
Hello [firstname], 

Your subscription in [program_name], expired on [date]. You will keep your current team, but any new users joining either in your team or powerline will be passed up.

If you would like to keep receiving your team and powerline sales, you will need to purchase a subscription. Login, and visit the [program_name] payment page, and it will show who you need to process a payment to before your subscription is active.

Thanks!

Regards,
Site Administration
EOR;


	//This email is sent out when a user is suspended
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [date] [username] [password]
$Global['email_suspend_notification_subject'] = "[program_name] Suspension Alert!";
$Global['email_suspend_notification_message'] = <<<EOR
Hello [firstname], 

Your subscription in [program_name], expired on [date]. Your membership has been suspended or cancelled.

You must renew your subscription immediately, or you will lose your membership, and all it's priviledges.

Please don't delay, and login to renew your membership now!

Please renew here: {$Global['webpage_url_ssl']}apay/pay.php?resub=Y
username: [username]

If you believe this suspension to be in error, please hit reply to notify admin, including your payment method, and last date of payment.

We welcome your comments and suggestions on how you feel we may improve our program.

Thank you,
Site Administration
EOR;

	//This email is sent out when a grace period expire, to the user owning the subscription
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [date]
$Global['email_expire_notification_subject'] = "[program_name] Alert";
$Global['email_expire_notification_message'] = <<<EOR
Hello [firstname], 

Your subscription in [program_name], expired on [date]. 

We're sorry you decided not to renew your subscription.

Your team and powerlines have been moved to the next qualified upline member.

If this message is comes as a surprise, we certainly didn't intend it that way. You have already been sent 2 billing reminder email notices, one when your subscription was coming due, and one more, when your subscription became past due, and your membership entered a grace period.

We wish you well in all your endeavors, and will gladly welcome you back, should you decide to join us again at a later date.

We welcome your comment and suggestions on how you feel we may improve our program.

Thank you,
Site Administration
EOR;


	//This email is sent out when a user need to start paying another member
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [amount] [old_sponsor] [new_sponsor] [type_payment]
$Global['email_change_payer_subject'] = "[program_name] Alert";
$Global['email_change_payer_message'] = <<<EOR
Hello [firstname], 

Your [type_payment] payment of \$[amount] to sponsor [old_sponsor] in [program_name] needs to be updated as [old_sponsor] has left the program.

You need to update your payment plan, and start paying [new_sponsor] instead. Please login to make your new payment.

If you have setup a subscription payment method, you need to cancel the old subscription.

Then you can either do a new subscription payment to the new sponsor [new_sponsor] or a one time payment.

You will not lose any time by paying in advance.

Please note that if you are paying through our credit card solution you do not need to do anything, the next payment made will automatically be delivered to the new sponsor.

If you don't remember what payment type you made, please login, and visit the [program_name] payment page, and it will show when, by what processor, and what type of payment you made.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;


	//This email is sent out when a user need to start paying another powerline
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [amount] [old_powerline] [new_powerline] [type_payment]
$Global['email_change_powerline_subject'] = "[program_name] Alert";
$Global['email_change_powerline_message'] = <<<EOR
Hello [firstname], 

Your [type_payment] payment of \$[amount] to powerline [old_powerline] in [program_name] needs to be updated due to account changes.

You need to update your payment plan, and start paying [new_powerline] instead. Please login to make your new payment.

If you have setup a subscription payment method, you need to cancel the old subscription.

Then you can either do a new subscription payment to the new powerline [new_powerline] or a one time payment.

You will not lose any time by paying in advance.

Please note that if you are paying through our credit card solution you do not need to do anything, the next payment made will automatically be delivered to the new powerline.

If you don't remember what payment type you made, please login, and visit the [program_name] payment page, and it will show when, by what processor and what type of payment you made.

Thanks for your prompt attention and understanding in this matter.

We wish you great success with the [program_name] program!

Regards
Site Administration
EOR;


	//This email is sent out when you do a payment to the user
	//Custom Tags subject: [firstname] [lastname]
	//Custom Tags message: [firstname] [lastname] [amount] [your_account] [by_processor] [by_account] [date]
$Global['email_payment_subject'] = "Payment Notification";
$Global['email_payment_message'] = <<<EOR
Hello [firstname], 

The administration has just sent a payment of \$[amount] to your account [your_account] using the payment processor [by_processor]. The payment was processed by account [by_account] on [date].

This money was earned through the credit card solution offered on our site. Please note that the money may come from several programs. If you want more details, please login to your account and view the payment log.

Thanks, and congratulations!

Regards,
Site Administration
EOR;


	//This email is send out as the first nag email if its enabled.
	//Custom Tags subject: [firstname] [lastname]
	//Custom Tags message: [firstname] [lastname]
$Global['email_nag1_subject'] = "Hi [firstname], Are you ready yet?";
$Global['email_nag1_message'] = <<<EOR
Hello [firstname],

It's been a few days since you joined our program. We noticed you haven't taken advantage of the paid membership yet. Why not?

Did you know, all unpaid members will pass up (lose) paid member commissions, forever?

Don't lose sales, upgrade today! Just login at {$Global['webpage_url_ssl']}login.php. If you have lost your membership login details, just use our lost password feature, to have them emailed to you, instantly!

Remember, only paid members can earn paid member commissions as described in our program.

If you have any questions, just email us. We're always here to help!

Sincerely,
Site Administration
EOR;


	//This email is send out as the second nag email if its enabled.
	//Custom Tags subject: [firstname] [lastname]
	//Custom Tags message: [firstname] [lastname]
$Global['email_nag2_subject'] = "[firstname], Why aren't you onboard yet?";
$Global['email_nag2_message'] = <<<EOR
Hello [firstname],

We've noticed you haven't taken advantage of the paid membership yet. Why not?

Did you know, all unpaid members will pass up (lose) paid member commissions, forever?

Don't lose sales, upgrade today! Just login at {$Global['webpage_url_ssl']}login.php. If you have lost your membership login details, just use our lost password feature, to have them emailed to you, instantly!

Remember, only paid members can earn paid member commissions as described in our program.

If you have any questions, just email us. We're always here to help!

Sincerely,
Site Administration
EOR;


	//This email is send out as the third nag email if its enabled.
	//Custom Tags subject: [firstname] [lastname]
	//Custom Tags message: [firstname] [lastname]
$Global['email_nag3_subject'] = "Last Chance, [firstname]!";
$Global['email_nag3_message'] = <<<EOR
This is the final boarding call for [firstname] [lastname]!

[firstname], by this time you have hopefully had ample time to review our program, and become familiar with our compensation plan.

However... we have noticed you still haven't taken advantage of the paid membership yet. 

Did you know, all unpaid members will pass up (lose) paid member commissions, forever?

Don't lose sales, upgrade today! Just login at {$Global['webpage_url_ssl']}login.php. If you have lost your membership login details, just use our lost password feature, to have them emailed to you, instantly!

Remember, only paid members can earn paid member commissions as described in our program.

Take action now, before it's too late!

If you have any questions, just email us. We're always here to help!

Sincerely,
Site Administration
EOR;



	//This email is send out when someone decide to end their subscription. Meaning it will not send them renewal emails.
	//Custom Tags subject: [firstname] [lastname] [program_name]
	//Custom Tags message: [firstname] [lastname] [program_name] [username] [email] [join_date] [ip] [sponsor] [expire_date] [subscription_payments]
$Global['email_endprogram_subject'] = "Your [program_name] Membership Cancellation - Action Required!";
$Global['email_endprogram_message'] = <<<EOR
Hi [firstname],

Please read this carefully. Your action is required!

As you have requested, your [program_name] membership has been cancelled. You may use any remaining time you have paid for. 

[subscription_payments]

Your stats are below:

Name: [firstname] [lastname]
Username: [username]
Contact Email: [email]
Joined on: [join_date] [ip]
Referred by: [sponsor]
Membership Time Remaining: Expires [expire_date]

We're sorry to see you leave, but we respect your wishes. If you have any ideas on how we can improve [program_name], please let us know!

You may rejoin [program_name] at any time, by logging in, and clicking on the [program_name] link.

We thank you for your time with us, and wish you the best in the future!

Thank you,

Site Administration
EOR;


	//This email is send out when someone decide to enable their subscription. Meaning it will send them renewal emails.
	//Custom Tags subject: [firstname] [lastname] [program_name]
	//Custom Tags message: [firstname] [lastname] [program_name] [username] [email] [join_date] [ip] [sponsor] [expire_date]
$Global['email_enableprogram_subject'] = "Your [program_name] Membership Re-Enableing";
$Global['email_enableprogram_message'] = <<<EOR
Hi [firstname],

As you have requested, your [program_name] membership has been re-enabled. 

Your stats are below:

Name: [firstname] [lastname]
Username: [username]
Contact Email: [email]
Joined on: [join_date] [ip]
Referred by: [sponsor]
Membership Time Remaing: Expires [expire_date]

Please note that any emails sent while you did not want to receive any email notifications will not be resent. We recommend that you check the renewal payments page incase you need to make a payment right away to be able to keep your account.

Thank you,

Site Administration
EOR;


	//This email is sent out when someone receive money and the passphrase function fails.
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name]  [firstname] [lastname] [payer_firstname] [payer_lastname] [payment_type] [amount] [processor_name] [paid_from_account]
$Global['email_passphrase_subject'] = "[program_name] Alert";
$Global['email_passphrase_message'] = <<<EOR
Hello [firstname],

It appears you have received a [payment_type] payment amount of $[amount], for [program_name],
from [payer_firstname] [payer_lastname] ([paid_from_account]), paid through [processor_name].

We cannot verify this payment, because the IPN failed the passphrase check.
This can be due to one of the following reasons:

1) The passphrase in your profile is incorrect.
2) The payment was not valid (payment was never made).

Before responding to this email, please login to [processor_name], to verify you have received the payment.
If you did not, please reply to this email, and let us know as once.

If you did receive the payment, please update your member profile [processor_name] passphrase.
Directions for setting up your passphrase are on the profile page itself.

Thank you.

Regards,
Site Administration 
EOR;



	//This email is sent out when someone wants to unsubscribe from the webpage. It is the first unsubscribe email.
	//Custom Tags subject: [webpage_name] [firstname] [lastname]
	//Custom Tags message: [webpage_name]  [firstname] [lastname] [unsubscribe_link]
$Global['email_unsubscribe1_subject'] = "[webpage_name] Account Cancellation Request - Your Action Required";
$Global['email_unsubscribe1_message'] = <<<EOR
Hello [firstname],

A request has been made to cancel your [webpage_name] account. 

If this request did not come from you, please simply ignore this email. Your account is fine.

If you did request that your [webpage_name] account be cancelled, please click the link below:
[unsubscribe_link]

Thank you.

Regards,
Site Administration 
EOR;


	//This email is sent out when someone wants to unsubscribe from the webpage. It is the second and final unsubscribe email.
	//Custom Tags subject: [webpage_name] [firstname] [lastname]
	//Custom Tags message: [webpage_name]  [firstname] [lastname]
$Global['email_unsubscribe2_subject'] = "Your [webpage_name] Account Has Been Cancelled";
$Global['email_unsubscribe2_message'] = <<<EOR
Hello [firstname],

As requested, your [webpage_name] account has been cancelled. 

If you paid with a credit card directly to the company, any subscription you may have had has now been cancelled.

If you paid with a credit card directly to your upline sponsor, you will need to contact them directly to cancel your billing.  

If you did not cancel any subscription payments running from a third party service, such as Paypal etc., you will need to login to your account with them, to cancel any such subscriptions.

We do not have access to automatically cancel such subscriptions.

We thank you for your time with us, and wish you the best in the future!

Thank you.

Regards,
Site Administration 
EOR;


	//This email is sent out when someone joins the webpage. Sent to the person joining.
	//Custom Tags subject: [webpage_name] [firstname] [lastname]
	//Custom Tags message: [webpage_name]  [firstname] [lastname] [username] [password] [login_url] [referal_url] [ip]
$Global['email_join_user_subject'] = "Welcome to [webpage_name]!";
$Global['email_join_user_message'] = <<<EOR
Hello [firstname],

Welcome To [webpage_name]

You are almost in a position to earn money infinitely through our unique compensation plan.

If you have not already done so, please login to finish paying for your active membership.

NOTE: You must be a paid member to make sales! To unleash the TRUE power of [webpage_name], 

choose a username and password (unless you have already done so):

{$Global['webpage_url_ssl']}login-check-enrollee.php?id=[username]&login=[username]

This is what you need to advertise to start building your team and earning a limitless income.

Once you become paid, and start referring new members, you are on your way to earning serious money. 

There are NO limits to how much you can earn with [webpage_name]. 

We look forward to helping you build your business and wish you great success in all your endeavors! 

Promote long, and prosper! 

Regards,
Site Administration 

Your I.P. address was logged. Please abide by our terms.
IP Address: [ip]
EOR;




	//This email is sent out when someone joins the webpage. Sent to the admin.
	//Custom Tags subject: [webpage_name]
	//Custom Tags message: [webpage_name]  [firstname] [lastname] [username] [sponsor] [email] [phone] [ip]
$Global['email_join_admin_subject'] = "[webpage_name] Signup!";
$Global['email_join_admin_message'] = <<<EOR
A new member has joined [webpage_name].

Username: [username]
First name: [firstname]
Last name: [lastname]
Email: [email]
Phone: [phone]
Sponsor: [sponsor]
IP: [ip]

This message was auto generated by your Automatic Web Software script.
EOR;



	//This email is sent out to the direct sponsor, every time a member joins for free
	//Custom Tags subject: [webpage_name] [firstname] [lastname]
	//Custom Tags message: [webpage_name]  [firstname] [lastname] [new_username] [new_firstname] [new_lastname] [new_email] [phone]
$Global['email_join_sponsor_subject'] = "Congratulations, You have just signed up a new pending member!";
$Global['email_join_sponsor_message'] = <<<EOR
Congratulations [firstname]!

You just referred the following person to [webpage_name]

Name: [new_firstname] [new_lastname], [new_email]

Phone: [phone]

You should take a moment, and welcome your new member.

This is an unpaid referral, placed DIRECTLY under you.

We strongly recommend that you contact [new_firstname],

welcome them to [webpage_name], and ask them to take

action and login and upgrade to become a paid member.

Also, be sure to login yourself, and use our team mailer 

often, to encourage your team to take action!

We will also continue to email them on your behalf.

Thanks, and keep up the GREAT WORK!

Regards,
Site Administration 
EOR;

//This email will be sent out to the receiver WHEN PAYMENT IS MARKED SENT BY SENDER
// via: [paid_courier]  - NOT USING IN PIF
$Global['email_mark_payment_subject'] = 'Payment Marked Sent in [program_name]';
$Global['email_mark_payment_message'] = <<<EOR
Hello [dearfirstname], 

In the [program_name] level, the new member [firstname] [lastname] username: [paid_from_username] email: [email] 
has noted they sent you a payment on: [paid_date]
Tracking ID or Blockchain ID: [paid_tracking]
Comments or Crypto: [paid_comment]

Be sure to mark them paid if you got this transaction, or follow up with this user otherwise with any issue.

Regards
Site Admin
EOR;

	//This email will be sent out to the receiver and cc'ed to the payer when a intabill payment is canceled by the payer
	//Custom Tags subject: [program_name] [firstname] [lastname]	
	//Custom Tags message: [program_name] [firstname] [lastname] [member_firstname] [member_lastname] [member_username] [transactionid] [transactionreference] [transactionusername]
$Global['email_intabill_receiver_subject'] = '[program_name] - You have Canceled A Transaction Alert';
$Global['email_intabill_receiver_message'] = <<<EOR
Hello [firstname], 

You have just canceled a members Intabill subscription on [program_name].

The subscription belonged to member [member_firstname] [member_lastname] ([member_username]).

If its not already canceled, please login to your Intabill account and cancel the subscription there too:

Username: [transactionusername]
Merchant Reference Number: [transactionreference] 
Transaction ID: [transactionid]

Thanks!

Regards
Site Admin
EOR;

	//This email is sent out when you cancel a authorize.net ARB with only sub, or linkpoint etc
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [grace_date] [need_to_pay] [amount]
$Global['email_arb_sub_subject'] = "[program_name] Alert";
$Global['email_arb_sub_message'] = <<<EOR
Hello [firstname], 

Your credit card renewal payment has failed. Your account has been suspended with a temporary grace period.

Don't lose your benefits and team.

Please go to {$Global['webpage_url_ssl']}apay/pay.php?resub=Y to complete your payment.

You will not gain any time by paying right before the grace period expires. Our system does take the grace period into calculation, and will update the subscription accordingly. Due to this, it is much better to finish the payment process as soon as possible, to prevent a possible loss of your team and service. 

If your grace period does expire, you will lose your team and subscription payments as they will be passed up. That cannot be reversed once initiated!

Regards,
Site Admin
EOR;

	//This email is sent out when you cancel a linkpoint subscription expire
	//Custom Tags subject: [program_name] [firstname] [lastname]
	//Custom Tags message: [program_name] [firstname] [lastname] [need_to_pay] [amount]
$Global['email_link_terminate_subject'] = "[program_name] Alert";
$Global['email_link_terminate_message'] = <<<EOR
Hello [firstname], 

Your credit card subscription payment for \$[amount] in program [program_name] has expired. To make sure your account will stay functional you will need to setup another subscription payment ASAP.

If you do not renew your subscription before your grace period expires, you will lose all subscription payments (coming to you) as they will be passed up to the first active upline member.  That cannot be reversed, once done. 

Remember, if you have even one active person in your team, you are generating income each month - so there is no reason to make your subscription lapse.

You need to finish your payments to:
[need_to_pay]

Please go to the [program_name] payment page and process the payments.

You will not gain any time by paying right before the grace period expires. Our system does take the grace period into calculation, and will update the subscription accordingly. Due to this, it is much better to finish the payment process as soon as possible, to prevent a possible loss of your service and active team. 

If your grace period does expire, then your active team and ability to earn commissions as a paid member will be lost!

Don't delay. Renew today!

Regards
Site Admin
EOR;


	//This email is sent out when a free trial expires
$Global['email_freetrial_cancelled_subject'] = "Your Free Trial Has Ended - Action Required!";
$Global['email_freetrial_cancelled_message'] = <<<EOR
Hello [firstname], 

Your Free Trial in program [program_name] has expired. To re-activate your account you will need to make payment ASAP.

Don't delay!

Click here to upgrade now: [upgrade_link] 

username: [username]

Your referral link will be restored once you upgrade. 

Don't lose your ability to earn commissions as a paid member.

Click here to upgrade now: [upgrade_link] 

Thank you,
Site Admin
EOR;


// TEMP FIX, UNTIL ALL VARS GET UPDATED!
// Merge $Global into $GLOBALS, keeping existing elements in $GLOBALS
//$GLOBALS = array_merge($Global, $GLOBALS); THIS OVERWROTE GLOBALS ARRAY!!

foreach ($Global as $key => $value) {
    $GLOBALS[$key] = $value;
}

?>