<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------

$use_php_mailer = false;
//include_once './../Lib/phpmailer/class.phpmailer.php';
include_once './../Lib/Ar.functions.php';


if ($cronlock != true) {
	echo "No cron lock parent. Exiting now!";
	exit;
}
$handshake = 'T'; // FOR CRON LOCK - PROVES THIS FILE RAN!

//how many emails to send at once
$limit = 250;



//an array with IDs of successfully sent emails
$success_emails = array();
$extracted_tags = extract_ar_tags($ar_tags);

// GET LEAD RECORDS QUEUED FOR REMINDERS TO BE SENT
$todayDate = date("Y-m-d");

$selectFields = [
    'm.email',
    'm.First_Name',
    'm.Last_Name',
    'm.Username',
    'm.unsubscribe_id',
    'ml.phone',
    'ald.*'
];

$mainTable = ['table' => 'ar_leads', 'as' => 'ald'];
$joinConditions = [
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'm.ID = ald.ID'
    ],
    [
        'table' => 'member_link',
        'as' => 'ml',
        'condition' => 'm.ID = ml.ID'
    ]	
];

$where = [
    'ald.followupdate' => ['<=', $todayDate],
    'ald.followupdate' => ['!=', '0000-00-00'],
    'ald.followup_emailsent' => ['=', 0],
    'ald.expire_date' => ['>=', $todayDate]
];
$orderBy = 'ar_leads_id';

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, 1);

echo 'TOTAL ROWS: ' . count($result) . '<BR><BR>'; 

echo '<p>&nbsp;</p>';
foreach ($result as $buffer) {
	
	$status = $buffer['status'];
	if ($status == 'closer') {
		$closer_id = $buffer['closer_id'];
		
		$selectFields = ['email', 'First_Name', 'Last_Name'];
		$mainTable = ['table' => 'members'];
		$where = ['ID' => ['=', $closer_id]];
		$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

		if (count($result2) > 0) {
			$buffer2 = $result2[0];
		} else {
			// Handle the case where no rows are returned
		}
		
		
		$closer_email = $buffer2['email'];
		$email = $buffer2['email'];
		$fname = $buffer2['First_Name'];
		$lname = $buffer2['Last_Name'];
	} else {
		$email = $buffer['email'];
		$fname = $buffer['First_Name'];
		$lname = $buffer['Last_Name'];
	}	

	//create the unsubscribe link
	if (strpos($Global['email_followup_message'], '[unsubscribe_url]') === false) {
		$unsub = str_replace('[link]', '<a href="'.$Global['webpage_url'].'unsubscribe_ar.php?hash='.$buffer['ar_leads_md5'].'">'.$Global['unsubscribe_link_text'].'</a>', $Global['unsubscribe_text']);
	} else {
		$unsub = '';
	}

	//setup the links

	$buffer['website'] = '<a href="'.$Global['webpage_url'].'">'.$Global['webpage_url'].'</a>';
	$buffer['member_website'] = '<a href="'.$Global['webpage_url'].'?id='.$buffer['Username'].'">'.$Global['webpage_url'].'?id='.$buffer['Username'].'</a>';
	$buffer['login_link'] = '<a href="'.$Global['webpage_url'].'login.php">'.$Global['webpage_url'].'login.php</a>';
	
	$leave = '<a href="'.$Global['webpage_url'].'leave.php?id='.$buffer['unsubscribe_id'].'">click here to completely cancel your membership</a>';

	$lead_info = '<a href="'.$Global['webpage_url_ssl'].'Members/leads_edit.php?id='.$buffer['ar_leads_md5'].'">View & Manage This Lead Here</a>';
	$buffer['subscribe_link'] = '<a href="'.$Global['webpage_url'].'join.php?lead='.$buffer['ar_leads_md5'].'">'.$Global['webpage_url'].'join.php?lead='.$buffer['ar_leads_md5'].'</a>';

	$ar_data = create_ar_data($buffer, $ar_tags);

	$ar_data['webpage_name'] = $Global['webpage_name'];
	
	$ar_data['fnamestr'] = '';
	if($buffer['ar_leads_firstname'])
	$ar_data['fnamestr'] = 'First Name: '.$buffer['ar_leads_firstname'].'<br>';
	
	$ar_data['lnamestr'] = '';
	if($buffer['ar_leads_lastname'])
	$ar_data['lnamestr'] = 'Last Name: '.$buffer['ar_leads_lastname'].'<br>';
	
	$ar_data['emailstr'] = '';
	if($buffer['ar_leads_email'])
	$ar_data['emailstr'] = 'E-mail: '.$buffer['ar_leads_email'].'<br>';
	
	$ar_data['phonestr'] = '';
	if($buffer['ar_leads_phone'])
	$ar_data['phonestr'] = 'Phone: '.$buffer['ar_leads_phone'].'<br>';
	
	$ar_data['addressstr'] = '';
	if($buffer['address'])
	$ar_data['addressstr'] = 'Address: '.$buffer['address'].'<br>';
	
	$ar_data['address2str'] = '';
	if($buffer['address2'])
	$ar_data['address2str'] = 'Address2: '.$buffer['address2'].'<br>';
	
	$ar_data['citystr'] = '';
	if($buffer['city'])
	$ar_data['citystr'] = 'City: '.$buffer['city'].'<br>';
	
	$ar_data['zipstr'] = '';
	if($buffer['zip'])
	$ar_data['zipstr'] = 'Zip: '.$buffer['zip'].'<br>';
	
	$ar_data['statestr'] = '';
	if($buffer['state'])
	$ar_data['statestr'] = 'State: '.$buffer['state'].'<br>';
	
	$ar_data['provincestr'] = '';
	if($buffer['province'])
	$ar_data['provincestr'] = 'Province/State: '.$buffer['province'].'<br>';
	
	$ar_data['countrystr'] = '';
	if($buffer['country'])
	$ar_data['countrystr'] = 'Country: '.$buffer['country'].'<br>';
	
	$ar_data['companystr'] = '';
	if($buffer['company'])
	$ar_data['companystr'] = 'Company: '.stripslashes($buffer['company']).'<br>';
	
	$ar_data['urlstr'] = '';
	if($buffer['url'])
	$ar_data['urlstr'] = 'Url: '.$buffer['url'].'<br><br>';
	
	$ar_data['optinstr'] = '';
	if($buffer['stdate'] && $buffer['stdate']!='0000-00-00')
	$ar_data['optinstr'] = 'Opt In Date: '.$buffer['stdate'].'<br>';
	
	$ar_data['campaignstr'] = '';
	if($buffer['campaign_name'])
	$ar_data['campaignstr'] = 'Campaign: '.stripslashes($buffer['campaign_name']);
	
	$ar_data['foundstr'] = '';
	if($buffer['found'])
	$ar_data['foundstr'] = 'Referred By (How Found): '.$buffer['found'].'<br>';
	
	$ar_data['timezonestr'] = '';
	if($buffer['timezone'])
	$ar_data['timezonestr'] = 'Time Zone: '.$buffer['timezone'].'<br>';
	
	$ar_data['prefcontactstr'] = '';
	if($buffer['preferred_contact_method'])
	$ar_data['prefcontactstr'] = 'Preferred Contact: '.$buffer['preferred_contact_method'].'<br>';
	
	$ar_data['btimetocallstr'] = '';
	if($buffer['timetocall'])
	$ar_data['btimetocallstr'] = 'Best Time to Call: '.$buffer['timetocall'].'<br>';
	
	$ar_data['intereststr'] = '';
	if($buffer['interest'])
	$ar_data['intereststr'] = 'Level of Interest: '.$buffer['interest'].'<br>';
	
	$ar_data['commentsstr'] = '';
	if($buffer['comments'])
	$ar_data['commentsstr'] = 'Comments: '.$buffer['comments'].'<br><br>';
	
	$ar_data['ratingstr'] = '';
	if($buffer['rating'])
	$ar_data['ratingstr'] = 'Rating: '.$buffer['rating'].'<br>';
	
	$ar_data['fdatestr'] = '';
	if($buffer['followupdate'] && $buffer['followupdate']!='0000-00-00')
	$ar_data['fdatestr'] = 'Follow Up Date: '.$buffer['followupdate'].'<br>';
	
	$ar_data['notesstr'] = '';
	if($buffer['notes'])
	$ar_data['notesstr'] = 'Notes: '.$buffer['notes'].'<br>';
	

$message = "Hello [member_first_name],

You set a reminder to yourself to follow up with the following lead today:

[lead_first_name] [lead_last_name]
[lead_email]
[lead_phone]

Take action, and make it count!

".$lead_info."


You are receiving this email as a member of ".$Global['webpage_name']."
If you wish to remove yourself completely from ".$Global['webpage_name'].", ".$leave;

$message_text =	$message;
$message_text = stripslashes(nl2br($message_text));

echo 'Message Text After: ';
echo $message_text;

//echo "<br/>AR data: ";
//print_r($ar_data);
//echo "<br/>";
//echo "<br/>Extracted tags: ";
//print_r($extracted_tags);

$transformed_message = replace_ar_tags($message_text, $ar_data, $extracted_tags);
echo "<br/><br/>Transformed Message: ";
echo $transformed_message;

$test_mode = false;
//$test_mode = true;
echo "<br/><hr>";



	if ($use_php_mailer === true && $test_mode === false) {
		// EMAIL THE REMINDERS
		$mail = new PHPMailer();
		$mail->SetFrom($Global['admin_email'], $Global['admin_email_heading']);
		
		$mail->AddReplyTo($email, $fname.' '.$lname);
		
		if ($buffer['status'] == 'closer') {
			$buffer['First_Name'] = 'Closer '.$buffer['First_Name'].' '.$buffer['Last_Name'];
			$mail->AddAddress($closer_email);
		} else {
			$mail->AddAddress($buffer['email']);
		}
			
			
		// THIS IS THE EMAIL OF THE LEAD!! 
		//$mail->AddAddress($buffer['ar_leads_email']);
		//$mail->AddAddress('Jim.Symonds@automaticwebsoftware.com');		
		$mail->MsgHTML($transformed_message);

		$subject = "Lead Followup Reminder - ".$Global['webpage_name'];

		$mail->Subject  = replace_ar_tags($subject, $ar_data, $extracted_tags);

		$mail->WordWrap = 50;

		if($mail->Send()) {
			$success_emails[] = $buffer['ar_link_id'];
		}
	} else if ($test_mode === false) {
        // Use PHP mail() function
        $headers = "From: " . $Global['admin_email'] . "\r\n";
        $headers .= "Reply-To: " . $email . "\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

        $to = $buffer['status'] == 'closer' ? $closer_email : $buffer['email'];
        $mail_subject = replace_ar_tags($subject, $ar_data, $extracted_tags);
        $mail_body = $transformed_message;

        if (mail($to, $mail_subject, $mail_body, $headers)) {
            $success_emails[] = $buffer['ar_link_id'];
        }		
	}	
		$next_date = '';
		
	if ($buffer['recurring_days'] != 0) {
		$next_date = date('Y-m-d', strtotime(' + '.$buffer['recurring_days'].' days'));

		// UPDATE THE RECORDS
		$updateData = ['followupdate' => $next_date];
		$where = ['ar_leads_id' => ['=', $buffer['ar_leads_id']]];

		if ($test_mode == false) {
			update('ar_leads', $updateData, [], $where, 1, 1);
		}
		
	
	} else {
		// UPDATE THE RECORDS
		$updateData = ['followup_emailsent' => 1];
		$where = ['ar_leads_id' => ['=', $buffer['ar_leads_id']]];

		if ($test_mode == false) {
			update('ar_leads', $updateData, [], $where, 1, 1);
		}
	}
} // END LOOP!

?>
