<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('FIND_MEMBER') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
}

//error_reporting(-1);
//$_SESSION['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */
$datetimenow = date("Y-m-d H:i:s");
	
$pageName = 'Cron Report';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

include './../Inc/Header.inc.php';

echo '<h2>Latest Cron Runs</h2>';

if (isset($_GET['show']) && $_GET['show'] != 'dev') echo '<a href="Cron_report.php?show=dev">Show Developer Arrays</a>';
else echo '<a href="Cron_report.php">Hide Developer Arrays</a>';
	
echo '<p></p>';

// THIS QUERY DOES NOT SHOW LATEST RUNS, DUE TO GROUP BY CONDITION
//SELECT * FROM `cron_run` WHERE lastrun > '2019-07-09' GROUP BY `cronname` ORDER BY `lastrun` DESC
$cronname = '';

$count = 1;
$E4_count = 1;

$too_old_date = date("Y-m-d H:i:s",strtotime("-30 days")); 

// Define the select fields and the table
$selectFields = 'DISTINCT(cronname)';
$mainTable = 'cron_run';

// Since WHERE 1 is just a placeholder for no specific condition, you can use an empty array
$where = ['1'];

// Define the ORDER BY and LIMIT
$orderBy = 'lastrun DESC';
$limit = 20;

// Execute the select query using PHPCPR
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

foreach ($result as $buffer) {
	
	if ($buffer['cronname'] == $cronname) continue;
	
	$cronname = $buffer['cronname'];
	
/*	if ($cronname != 'Mailmembers.cron' &&
    $cronname != 'Suspend_user.cron' &&
    $cronname != 'Lead_adder.cron' &&
    $cronname != 'Ar_send.cron' &&
    $cronname != 'Stats.cron' &&
    $cronname != 'SMS_send_leads.cron' &&
    $cronname != 'Send_sms_drips.cron') {
		$cronlock = 'Cronlock_new.php';
	} else {
		$cronlock = 'Cronlock.php';
	}*/
	// ALL UPDATED PHP FILES WILL USE THIS NOW:
	$cronlock = 'Cronlock.php';
		
	// Define the select fields and the table
	$selectFields = '*';
	$mainTable = 'cron_run';

	// Define the WHERE condition using the 'cronname' from the $buffer
	// Make sure to escape or sanitize $buffer['cronname'] as needed to prevent SQL injection
	$where = [
		"cronname" => $buffer['cronname']
	];

	// Define the ORDER BY and LIMIT
	$orderBy = 'lastrun DESC';
	$limit = 1;

	// Execute the select query using PHPCPR
	$result2 = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

	// Fetch the first row from the result
	$buffer2 = !empty($result2) ? $result2[0] : null;
	
	
	if ($buffer2['lastrun'] < $too_old_date) continue; // DO NOT SHOW CRON ITEMS THAT WERE A ONE TIME FIX, OR NO LONGER USED
	
	echo '<br/>'.$count.') '.$buffer2['cronname'].' ';
	
	if (!empty($buffer2['records_affected']) && $buffer2['records_affected'] != 0) echo 'Records Affected: ('.$buffer2['records_affected'].') ';

	echo 'Last Ran: '.$buffer2['lastrun'].' Completed: '.$buffer2['completed'].' Handshake: '.$buffer2['handshake'];
	
	if ($buffer2['handshake'] == 'F') echo ' >> <a href="'.$Global['webpage_url_ssl'].'admin/Cron/'.$cronlock.'?pw='.$Global['cron_password'].'&cronname='.$buffer2['cronname'].'&reset=Y" target="_blank">RESET</a>';
	else echo ' >> <a href="'.$Global['webpage_url_ssl'].'admin/Cron/'.$cronlock.'?pw='.$Global['cron_password'].'&cronname='.$buffer2['cronname'].'" target="_blank">Run This Cron Manually</a>';
	
	if (isset($_GET['show']) && $_GET['show'] == 'dev') {
		echo '<br/>';
		print_r($buffer2);
	}	
	echo '<hr>';
 
	$count++;	
} // END LOOP

//echo 'First Data E4 cron has run '.$E4_count.' times since '.$E4_earliest;

echo '<p></p><p></p>';	
?>
Handshake is true or false. When Handshake: T (means cron completed successfully). When Handshake: F (means cron has yet to complete or possibly failed - try refreshing page) 

<p>&nbsp;</p>
<?php 
include './../Inc/Footer.inc.php';
?>
