<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include_once './../../Sub/Config.inc.php'; 
include_once $GLOBALS['path'].'phpcpr.php';

$cron_runner = true;

set_time_limit(0); // Make sure it will not expire before it's complete

date_default_timezone_set('America/New_York');

// Cron jobs array with human-readable frequencies
$cron_jobs = [
    'Ar_followup.cron' => 'twice a day',
    'Ar_send.cron' => 'every 5 minutes',
    /* 'Bounced_email_remover.cron' => 'every 10 minutes', */
    'cc.cron' => 'every hour',
    /* 'comm.cron' => 'every hour', */
    /* 'E4.cron' => 'every 30 minutes', */
    'Email.cron' => 'once a day',
    /* 'Lead_adder.cron' => 'every 10 minutes', */
    /* 'Leads_give.cron' => 'every 10 minutes', */
    /* 'Freetrial.cron' => 'every hour', */
    'Mailmembers.cron' => 'every minute',
    'Powerline_queue_emails.cron' => 'every 5 minutes',
    'Powerline_set_email_status.cron' => 'every 5 minutes',
    'Stats.cron' => 'every 5 minutes',
    'Stats1day.cron' => 'twice a day',
    'Stats_top_earners.php' => 'twice a day',
    /* 'Sub_process.cron' => 'every 30 minutes', */
    'Suspend_user.cron' => 'every minute',
    'Wipe.cron' => 'every week'
];

// Function to convert human-readable frequency to seconds
function frequency_to_seconds($frequency) {
    switch ($frequency) {
        case 'every minute':
            return 60;
        case 'every 5 minutes':
            return 300;
        case 'every 10 minutes':
            return 600;
        case 'every 30 minutes':
            return 1800;
        case 'every hour':
            return 3600;
        case 'twice a day':
            return 43200;
        case 'once a day':
            return 86400;
        case 'every week':
            return 604800;
        default:
            return 0;
    }
}

// Define the select fields and the table
$selectFields = 'cronname, MAX(lastrun) AS last_run';
$mainTable = 'cron_run';
$where = ['1'];
$groupBy = 'cronname';

// Execute the select query using PHPCPR
$result = select($selectFields, $mainTable, [], $where, $groupBy, null, null, 0, 1);
$rows = is_array($result) ? count($result) : 0;

$now = time(); // Use timestamp for consistency
$nextCron = null;
$nextRunTime = PHP_INT_MAX; // Initialize to a large value
$cnt = 0;

foreach ($result as $row) {
    $cnt++;
    $cronname = $row['cronname'];
    if (isset($cron_jobs[$cronname])) {
        $frequencySeconds = frequency_to_seconds($cron_jobs[$cronname]);
        $lastRun = strtotime($row['last_run']);
        $dueTime = $lastRun + $frequencySeconds;

        echo "Checking cron: $cronname\n";
        echo "Last run: " . date('Y-m-d H:i:s', $lastRun) . "\n";
        echo "Due time: " . date('Y-m-d H:i:s', $dueTime) . "\n";
        echo "Current time: " . date('Y-m-d H:i:s', $now) . "\n";

        // Ensure we do not run crons more than once within the same interval
        if ($now < $dueTime) {
            echo "Skipping cron: $cronname, due in the future\n";
            continue;  // Skip to next iteration if it was executed too recently
        }

        if ($now >= $dueTime && $dueTime < $nextRunTime) {
            $nextCron = $cronname;
            $nextRunTime = $dueTime;
        }
    }
}

// If no suitable cron was found in the initial result, check for any due crons from the entire cron_jobs array
if ($nextCron === null) {
    foreach ($cron_jobs as $cron_name => $frequency) {
        $where = ['cronname' => $cron_name];
        $result = select($selectFields, $mainTable, [], $where, $groupBy, null, null, 0, 1);
        $lastRun = isset($result[0]['last_run']) ? strtotime($result[0]['last_run']) : 0;
        $frequencySeconds = frequency_to_seconds($frequency);
        $dueTime = $lastRun + $frequencySeconds;

        echo "Fallback checking cron: $cron_name\n";
        echo "Last run: " . date('Y-m-d H:i:s', $lastRun) . "\n";
        echo "Due time: " . date('Y-m-d H:i:s', $dueTime) . "\n";
        echo "Current time: " . date('Y-m-d H:i:s', $now) . "\n";

        if ($now >= $dueTime && $dueTime < $nextRunTime) {
            $nextCron = $cron_name;
            $nextRunTime = $dueTime;
        }
    }
}

// Debug statement to check the selected cron job
echo $nextCron ? "Selected cron: $nextCron\n" : "No cron selected\n";

if ($nextCron !== null) {
    $cronUrl = 'https://' . $GLOBALS['webpage_name'] . '/admin/Cron/Cronlock.php?pw=' . $GLOBALS['cron_password'] . '&cronname=' . urlencode($nextCron);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $cronUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $cronOutput = curl_exec($ch);
    curl_close($ch);

    echo "Cron job '$nextCron' has been executed.\n";
} else {
    echo "No cron job selected for execution.\n";
}
?>
