<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if (!isset($cron_runner)) {
	include_once './../../Sub/Config.inc.php';
	include_once './../../phpcpr.php';
}

$mtime = microtime(); 
$mtime = explode(" ", $mtime); 
$mtime = $mtime[1] + $mtime[0]; 
$starttime = $mtime; 
set_time_limit(0); // Make sure it will not expire before it's complete
	

//date_default_timezone_set('America/Los_Angeles');
date_default_timezone_set('America/Chicago'); // Central Time
//date_default_timezone_set('America/New_York');
//echo date('Y-m-d H:i:s'); exit;

//$demosite = true;
$demosite = false;

//error_reporting(-1);
$datetime = date("Y-m-d H:i:s");

// DEFINED FOR CRON INCLUDES, DO NOT EDIT!
$cronlock = true;

// QQQ MOVED TO CONFIG!
//$Global['cron_password'] = 'phpcprAUG12@';

// PREVENT XSS
//$_GET = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING);

if ($_GET['cronname'] != '') {
    $cronname = $_GET['cronname'];
} else { 
    echo "No cron defined. Exiting now!";
    exit;
}
if ($_GET['pw'] != $GLOBALS['cron_password']) {
    echo "No cron password or cron password mismatch. Exiting now!";
    exit;
}

/*
CREATE TABLE `cron_run` (
  `idx` int(11) NOT NULL AUTO_INCREMENT,
  `cronname` varchar(100) NOT NULL,
  `lastrun` datetime NOT NULL,
  `completed` datetime NOT NULL,  
  `locked` varchar(10) NOT NULL DEFAULT 'Y',
  `cronreset` varchar(10) NOT NULL DEFAULT 'N',
  `handshake` varchar(10) NOT NULL DEFAULT 'F',  
  PRIMARY KEY (`idx`),
  KEY `cron` (`cronname`,`lastrun`,`completed`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;
*/

// JS ADDING CRON LOCK TO PREVENT CRON FROM RUNNING WHILE ALREADY RUNNING!!!!!!
// ALL EXISTING CRONS WILL BE TWEAKED TO RUN AS INCLUDES, INSIDE THIS FILE, BELOW

// THE DATE BY WHICH THE CRON HAS BEEN LOCKED FOR TOO LONG (THIS MEANS THE CRON WAS TERMINATED PREMATURELY, NOT UNLOCKING THE CRON RECORD)
$too_old_date = date('Y-m-d H:i:s', strtotime('-10 minutes'));

// GET THE MOST RECENT CRON RUN RECORD
//SELECT * FROM cron_run WHERE cronname='{$cronname}' ORDER BY lastrun DESC LIMIT 1;

//echo "GOT TO: " . __LINE__."<BR>";

$selectFields = '*';
$mainTable = 'cron_run';
$joinConditions = [];

$where = [
    'cronname' => ['=', $cronname]
];


$groupBy = null;
$having = null;
$orderBy = 'lastrun DESC';
$limit = 1;
$show_debug = 1;

if (isset($resultcron)) unset($resultcron);
if (isset($buffercron)) unset($buffercron);

$resultcron = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);

if (!empty($resultcron)) {
	
	$buffercron = $resultcron[0] ?? ''; // Assign the first row array to $buffercron
	
	$idx = '';
	$last_cronname = '';
	$records_affected = '';
	$lastrun = '';
	$completed = '';
	$locked = '';
	$cronreset = '';
	$last_handshake = '';
	
	$idx = $buffercron['idx'];
	$last_cronname = $buffercron['cronname']; // DO NOT RE-USE / RESET $cronname!
	$records_affected = $buffercron['records_affected'];
	$lastrun = $buffercron['lastrun'];
	$completed = $buffercron['completed'];
	$locked = $buffercron['locked'];
	$cronreset = $buffercron['cronreset'];
	$last_handshake = $buffercron['handshake']; // DO NOT RE-USE / RESET $handshake!

	echo "idx: $idx\n";
	echo "last_cronname: $cronname\n";
	echo "records_affected: $records_affected\n";
	echo "lastrun: $lastrun\n";
	echo "completed: $completed\n";
	echo "locked: $locked\n";
	echo "cronreset: $cronreset\n";
	echo "last_handshake: $last_handshake\n";
} else {
	// NO RESULT, SET VAR TO AVOID INDEX ERRORS
	$buffercron['locked'] = 'N';
}	

if ($buffercron['locked'] == 'Y') { // WE HAVE AN EXISTING LOCKED RECORD!
    
	// CHECK THE LOCKED RECORD FOR THE CONDITION REQUIREMENTS
    // IF LASTRUN OLDER THAN TOO OLD DATE, UNLOCK CRON!	
	
    if (($buffercron['locked'] == 'Y' && $buffercron['lastrun'] < $too_old_date) || (isset($_GET['reset']) && $_GET['reset'] == 'Y')) { // CRON LOCKED FOR TOO LONG, RESET IT!
		echo 'CRON WAS LOCKED TOO LONG, RESETTING NOW';
        //update('cron_run', ['locked' => 'N', 'cronreset' => 'Y'], ['idx' => $buffercron['idx']], 1, 1, 1);
		// UPDATE THE RECORD TO UNLOCK IT!
		$updateTable = 'cron_run';
		$updateData = [
			'locked' => 'N',
			'cronreset' => 'Y'
		];
		$updateWhere = [
			'idx' => 
				['=', $buffercron['idx']]
		];		
		$limit = 1;
		$live = 1;
		$show_debug = 1;

		update($updateTable, $updateData, [], $updateWhere, $live, $limit, $show_debug);	
		
		
        echo 'CRON JUST RESET. THIS WILL PROCESS ON THE NEXT CRON RUN NOW.';
        echo '<br><br>';
    } else if ($buffercron['locked'] == 'Y') { // CRON IS LOCKED, BUT NOT TOO OLD
        echo '<br>CRON IS ALREADY RUNNING! Exiting Now! Buh Bye. :-)';
        exit;
	} // END RECORD CHECKING - PROCEED WITH CRON RUN

} else { // THERE IS NO LOCKED RECORD, SO WE SET UP NEW CRON RUN RECORD

	echo debug_stmt("Before DB operation - lastrun datetime: $datetime", 1);

    insert('cron_run', [
        'cronname' => $cronname,
        'lastrun' => $datetime,		
        'locked' => 'Y'
    ], 1, 1);

    // NOW GET IDX RECORD TO UPDATE LATER - GET THE MOST RECENT RUN RECORD BY THIS $cronname
    //SELECT * FROM cron_run WHERE cronname='{$cronname}' ORDER BY lastrun DESC LIMIT 1
	if (isset($resultcron)) unset($resultcron);
	if (isset($buffercron)) unset($buffercron);
	$resultcron = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);

    //$buffercron = $resultcron[0]; // Assign the first row array to $buffercron
	$buffercron = isset($resultcron[0]) ? $resultcron[0] : null;

    echo 'NEW IDX: '.$buffercron['idx'].'<br>';
    echo 'NEW IDX RECORD buffercron locked is set to: ';
    echo $buffercron['locked'].'<br>';
    echo 'lastrun: '.$buffercron['lastrun'].'<br>';
    echo 'completed: '.$buffercron['completed'].'<br>';

} // END INSERT -- CRON IS NOW LOCKED AGAINST FUTURE USES, WHILE WE RUN IT - PROCEED ON TO RUN CRON NOW...	

// THIS CODE AUTOMATICALLY INCLUDES THE CRON TO RUN HERE!
//if ($cronname != '') include_once ''.$cronname.'.php';
if ($cronname != '') include ''.$cronname.'.php';


//echo $buffercron['idx']; 
//exit;

$datetime_completed = date("Y-m-d H:i:s");
if (!isset($handshake)) $handshake = 'F';

// UPDATE THE CRON RUN AS COMPLETED!
$updateTable = 'cron_run';
$updateData = [
	'locked' => 'N',
	'completed' => $datetime_completed,
	'handshake' => $handshake	
];
$updateWhere = [
	'idx' => ['=', $buffercron['idx']]
];
$limit = 1;
$live = 1;
$show_debug = 1;

// END OF CRON RUN - UPDATE CRON RUN TABLE - UNLOCK RECORD, UPDATE TIME COMPLETED
update($updateTable, $updateData, [], $updateWhere, $live, $limit, $show_debug);

// SHOW TIME IT TOOK TO RUN THIS FILE
echo '<br>CRON RUN FINISHED FOR '.$cronname.'!';
echo '<br>time started: '.$datetime;
echo '<br>time completed: '.$datetime_completed;	
$mtime = microtime(); 
$mtime = explode(" ",$mtime); 
$mtime = $mtime[1] + $mtime[0]; 
$endtime = $mtime; 
$totaltime = ($endtime - $starttime); 
echo "<br>Total Processing Time: ".$totaltime." seconds"; 
?>
