<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if ($cronlock != true) {
	echo "No cron lock parent. Exiting now!";
	exit;
}
$handshake = 'T'; // FOR CRON LOCK - PROVES THIS FILE RAN!

//$GLOBALS['debug'] = true;

$use_sendgrid = $Global['use_sendgrid']; // SET THIS TO FALSE TO SEND CONFIRMATION EMAIL NORMALLY, TRUE TO USE SENDGRID
if ($use_sendgrid == true) include './../../sendgrid.inc.php'; // load sendgrid functions if using them

//how many emails to send per time
// Important to avoid allegations of spam to keep emails down to less than 500 total per hour.
$emails_limit = 50; // send 50 at a time, schedule Cron for every 1 min, for 3000/hour max. Should be OK as long as mailing is done from the start as the business is built from scratch, so the growth is organic as the number of emails climbs.
// REMEMBER other processes ALSO send emails
if ($use_sendgrid == true) $emails_limit = 2500; // Can use a higher limit if using sendgrid. It will handle throttling internally. CRON RUNS ONCE PER HOUR 

$pause_time = date('Y-m-d H:i:s', strtotime('-3 minutes'));

//the subject and body of the email
$mailbody = '';
$real_subject = '';

// TWEAKED TO SUPPORT EMAILING LEADS ALSO!
	
$selectFields = '*';
$mainTable = 'send_email';
$where = ['email_status' => 0];
$orderBy = 'email_id ASC';
$limit = $emails_limit;

// Call the PHPCPR select function for the first query example.
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);

$rows = count($result);
//echo $rows;

// For the second query with the pause time condition, adjust the $where array.
//$whereWithPauseTime = ['email_status' => 0, 'email_date' => ['>', "'{$pause_time}'"]; // UNTESTED!

// Call the PHPCPR select function for the second query example.
//$resultsWithPauseTime = select($selectFields, $mainTable, [], $whereWithPauseTime, null, null, $orderBy, $limit, 1);

// Processing the results.
// Assuming the select function returns an associative array of results.
foreach ($result as $row) {
 
	if ($use_sendgrid == true) {
		sendgrid_email($row['email'],$row['email_subject'], $row['email_message']);
			} else {
				//mail($row['email'], $row['email_subject'], $row['email_message'], "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n","-f{$Global['admin_email']}");
				
				// UPDATE 8/22/23 - DEFINING HEADER, TO GET EMJOIS TO SHOW UP MORE RELIABLY
				$headers = "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n";
				$headers .= "Content-Type: text/plain; charset=UTF-8\r\n";
				mail($row['email'], $row['email_subject'], $row['email_message'], $headers, "-f{$Global['admin_email']}");
	}
	
	echo "<br />";
	echo $row['email']."<br />";
	echo $row['email_subject']."<br />";
	echo $row['email_message']."<br />";
	
	//mark the sent emails in the DB
	$now = date('Y-m-d H:i:s');
	$emailId = $row['email_id']; // Make sure this variable is safe to use in a query context
	$table = 'send_email';
	$data = [
		'email_status' => 1,
		'email_sent_date' => $now
	];
	unset($where);
	$where = [
		'email_id' => $emailId
	];

	// Call the update function from your PHPCPR CRUD system
	update($table, $data, [], $where, 1, 0, 1);	
}
?>
