<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if ($cronlock != true) {
	echo "No cron lock parent. Exiting now!";
	exit;
}
$handshake = 'T'; // FOR CRON LOCK - PROVES THIS FILE RAN!
//RUN ONCE PER DAY - FILE BORN FROM Stats.cron.php
//THIS CRON IS VERY FAST. COMPLETED EACH RUN IN JUST A FEW SECONDS ON E1UP. 
//IT WAS CREATED TO RETRO-ACTIVELY CREATE SINGLE DAY STATS LOGS GOING BACK TO JAN 1 OF THE CURRENT YEAR.
//SO I SET THIS TO RUN 1 PER MINUTE UNTIL IT CAUGHT UP (ABOUT 3 HOURS). THEN CHANGED IT TO RUN ONCE PER DAY  
//IT WILL NOT CREATE LOGS FOR THE CURRENT DATE OR DATES IN THE FUTURE (AS WE WOULDN'T WANT THAT). SO IT IS FAILSAFE IN THAT SENSE
//WE ONLY CREATE STATS LOGS FOR PAST DAYS, NOT TODAY - SINCE WE WON'T HAVE ALL OF TODAY'S DATA UNTIL TMOW!
// THIS DATA IS DISPLAYED HERE: /admin/Sub/Stats_earnings.php?range=1
// AND /admin/Sub/Stats_by_month.php


// GET LATEST DATE
$selectFields = ['*'];
$mainTable = 'latest_stats';
$where = ['type' => '1day'];
$orderBy = ['enddate DESC', 'idx DESC'];
$limit = 1;

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$buffer = isset($result[0]) ? $result[0] : '';


$found_single_day_stats = false; // INITIALIZE VAR

if ($buffer) {
    foreach ($buffer as $row) {
		$startdate = substr($buffer['startdate'],0,-9); // WORKS TO GET JUST THE DATE!
		$enddate = substr($buffer['enddate'],0,-9); // WORKS TO GET JUST THE DATE!
		
		if ($startdate != '') {
			$found_single_day_stats = true;
		} else {
			$found_single_day_stats = false;
		}		
	} // END LOOP
}

//$startdate = '2019-12-31';
echo $buffer['startdate'];
echo '<br>found single day stats: '.$found_single_day_stats.'<br>';
echo $startdate;
echo '<br>';
//exit;
$day = '';

if ($found_single_day_stats == true) {
	// Add days to date and display it 
	$day = date('Y-m-d', strtotime($startdate. ' + 1 day')); // WORKS!
	//$day = '2020-07-01'; // FOR TESTING - WORKS FINE!
	echo 'Single day stats found! Next date to create stats for is: '.$day.'<br>';
	
	$today = date('Y-m-d');
	if ($day >= $today) {
		// DO NOT PROCESS FUTURE DATES OR TODAY'S DATE!
		// IF DATE IS TODAY, WE MUST WAIT UNTIL TMOW TO GET PROPER STATS (ALL SIGN UPS / SALES)
		// ELSE WE WOULD GET ONLY PARTIAL DATA OFR THE DAY
		echo 'Next date to process is today (or in the future)! Setting handshake true, unlocking cron and exiting now!<br>';
		// END OF CRON RUN - UPDATE CRON RUN TABLE
		$datetime_completed = date("Y-m-d H:i:s");
		$table = 'cron_run';
		$data = [
			'locked' => 'N', 
			'completed' => $datetime_completed, 
			'handshake' => 'T'
		];
		$where = ['idx' => $buffercron['idx']];
		update($table, $data, [], $where, 1, 1, 1);
		exit;
	}
	
} else {
	echo 'No single day stats found!';
	// CRON WILL DEFAULT TO START RECORDING AT TOP OF CURRENT YEAR, IF NO DAILY STATS RECORDS ARE FOUND
	$this_year = date("Y");
	
	// CODE TO GET STATS FROM BEGINNING OF THIS YEAR
	//$start_cron_date = $this_year.'-01-01';
	//$day = $start_cron_date;
	
	// START FROM THE DAY THE SYSTEM WAS INSTALLED
	$day = substr($Global['installation_date'],0,-9); 
}

//exit; // FOR TESTING - REMOVE!!!!!!!!	

//$starttime = "'.$_REQUEST['year'].' . '.' . '.$_REQUEST['month'].' . '.' . '.$_REQUEST['day'].' . '00:00:00'";
$startdate = $day. ' ' . '00:00:00';
$enddate = $day. ' ' . '23:59:59';
$endday = $day;

/* // DEBUGGING STATEMENTS
echo 'Start Time<br />';
echo $starttime;
echo '<br />End Time<br/>';
echo $endtime;
*/
$timestamp = strtotime($startdate);
$timestamp2 = strtotime($enddate);  

$selectFields = ['COUNT(ID) AS cnt'];
$mainTable = 'members';
$where = [
		'AND' => [
			['SignDate' => ['>=', $startdate]],
			'SignDate' => ['<=', $enddate]
			]
		];

$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
$bufferj = isset($result[0]) ? $result[0] : '';

$members_joined = $bufferj['cnt'];
//echo $cnt. ' Users Joined us in the last 7 days';

$selectFields = ['SUM(log.amount) AS tot_earned'];
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'log.user_program_id = u.user_program_id'
    ],
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'u.ID = m.ID'
    ]
];
$where = [
    'AND' => [
		['log.timestamp' => ['>=', $timestamp]],
		'log.timestamp' => ['<=', $timestamp2],
        'm.Username' => ['!=', 'admin'],
        'log.payment_processor' => ['=', 'E4']
    ]
];

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer_earnings = isset($result[0]) ? $result[0] : '';

//echo '<h2>Our Members Gross Earnings (Last 30 Days): $'.number_format($buffer_earnings['tot_earned']).'</h2>';
$comm_earned_cc = $buffer_earnings['tot_earned'];
$comm_earned_all = $buffer_earnings['tot_earned'];

$selectFields = ['SUM(log.amount) AS tot_earned'];
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'log.user_program_id = u.user_program_id'
    ],
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'u.ID = m.ID'
    ]
];
$where = [
    'AND' => [
		['log.timestamp' => ['>=', $timestamp]],
		'log.timestamp' => ['<=', $timestamp2],
        'm.Username' => ['!=', 'admin'],
        ['log.payment_processor' => ['!=', 'E4']],
        'log.payment_processor' => ['!=', 'C'],		
    ]
];

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer_earnings = isset($result[0]) ? $result[0] : '';

//echo '<h2>Our Members Gross Earnings (Last 30 Days): $'.number_format($buffer_earnings['tot_earned']).'</h2>';
$comm_earned_other = $buffer_earnings['tot_earned'];
$comm_earned_all = $comm_earned_all + $buffer_earnings['tot_earned'];

$selectFields = ['SUM(log.amount) AS tot_earned'];
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'log.user_program_id = u.user_program_id'
    ],
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'u.ID = m.ID'
    ]
];
$where = [
    'AND' => [
		['log.timestamp' => ['>=', $timestamp]],
		'log.timestamp' => ['<=', $timestamp2],
        'm.Username' => ['!=', 'admin'],
        'log.payment_processor' => ['=', 'C']
    ]
];

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer_eanrings = isset($result[0]) ? $result[0] : '';
//echo '<h2>Our Members Gross Earnings (Last 30 Days): $'.number_format($buffer_earnings['tot_earned']).'</h2>';
$comm_earned_man = $buffer_earnings['tot_earned'];
$comm_earned_all = $comm_earned_all + $buffer_earnings['tot_earned'];

$selectFields = ['SUM(log.amount) AS tot_earned'];
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [
    [
        'table' => 'user_program',
        'as' => 'u',
        'condition' => 'log.user_program_id = u.user_program_id'
    ],
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'u.ID = m.ID'
    ]
];
$where = [
    'AND' => [
		['log.timestamp' => ['>=', $timestamp]],
		'log.timestamp' => ['<=', $timestamp2],
        'm.Username' => ['!=', 'admin']
    ]
];

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, 1);
$buffer_earnings = isset($result[0]) ? $result[0] : '';
//echo '<h2>Our Members Gross Earnings (Last 30 Days): $'.number_format($buffer_earnings['tot_earned']).'</h2>';
$admin_earned = $buffer_earnings['tot_earned'];

if ($Global['use_matrix'] == true) {
	$selectFields = ['SUM(log.amount) AS tot_earned'];
	$mainTable = ['table' => 'transactions_log', 'as' => 'log'];
	$where = [
		'AND' => [
			'log.usrid' => ['!=', 1],
			['log.logdate' => ['>=', $startdate]],
			'log.logdate' => ['<=', $enddate]
		]
	];

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer_earnings = isset($result[0]) ? $result[0] : '';
	
	//echo '<h2>Our Members Gross Earnings (Last 30 Days): $'.number_format($buffer_earnings['tot_earned']).'</h2>';
	$comm_earned_all = $comm_earned_all + $buffer_earnings['tot_earned'];
}

//if (!is_null($comm_earned_all))

$data = [
    'members_joined' => $members_joined+0,
    'comm_earned_all' => $comm_earned_all+0,
    'comm_earned_other' => $comm_earned_other+0,
    'comm_earned_man' => $comm_earned_man+0,
    'comm_earned_cc' => $comm_earned_cc+0,
    'admin_earned' => $admin_earned+0,
    'type' => '1day',
    'startdate' => $startdate,
    'enddate' => $enddate
];

$result = insert('latest_stats', $data, 1, 1);

	
// DELETE ALL PRIOR RECORDS OF SAME TYPE FOR SAME DAY
$where = [
    'AND' => [
        'type' => '1day',
        ['enddate' => ['LIKE', "%{$endday}%"]],
        ['enddate' => ['>', $endday]],
        ['enddate' => ['!=', $enddate]]
    ]
];

delete('latest_stats', [], $where, 'idx ASC', 1, 1, 1);
?>		