<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
if ($cronlock != true) {
	echo "No cron lock parent. Exiting now!";
	exit;
}
$handshake = 'T'; // FOR CRON LOCK - PROVES THIS FILE RAN!
echo '<h2>Got in Suspend_user.cron.php</h2>';

define('UNSUBSCRIBE', true);
$timestamp = time();
$date = date("Y-m-d");
$datetime = date("Y-m-d H:i:s");
$lastrun = date("Y-m-d H:i:s");

// CUTOFF DATES
//$lose_date = strtotime("-1 day", $timestamp); // DO NOT SUSPEND UNTIL X DAYS AFTER EXPIRATION DATE
$lose_date = $timestamp; // SUSPEND IMMEDIATELY AFTER EXPIRATION DATE
$suspended_limit_date = date("Y-m-d H:i:s",strtotime("-30 day", $timestamp)); // date after which suspended emails no longer sent out
$cancel_limit_date = date("Y-m-d H:i:s",strtotime("-2 day", $timestamp)); // date after which people are cancelled after having been suspended this long
// TO CANCEL IMMEDIATELY
//$cancel_limit_date = date("Y-m-d H:i:s",strtotime($timestamp)); // date after which people are cancelled after having been suspended this long

$cron = 'CRON';
$just_cancelled = false; // INI VAR!
$keep = false; // INI VARS

$debug = false;
$debug = true;

$_SESSION['debug'] = false;
$_SESSION['debug'] = true;

//First select all programs we need to check.
$selectFields = 'program_id, program_name, program_admin_pay, program_up_order, program_sub_period, program_link, program_tier_unpaid_level';
$mainTable = ['table' => 'program', 'as' => 'prog'];
$where = [
    'prog.program_type' => ['=', 'S'],
    'prog.program_admin_type' => ['=', 'S'],	
    'prog.program_approved' => ['=', 'Y']
];
$show_debug = 1;
$result_prog = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug); // LOOP THRU ALL PROGRAMS!

foreach($result_prog as $prog_buffer) {
	
	$rebill_amount = $prog_buffer['program_admin_pay'];
	
	$powerline_order = explode(',', $prog_buffer['program_up_order']);
		
	// SELECT ALL THE USERS IN THIS PROGRAM WE NEED TO MAKE SUSPENDED - WE WILL ALSO EMAIL THOSE SUSPENDED TO REMIND THEM!
	// SETS SUSPENDED OR CANCELLED STATUS FOR ALL USER_PROGRAM RECORDS THAT HAVE EXPIRED OR ADMIN HAS SUSPENDED THEM!
	// NOTE - ADMIN MAKING A USER SUSPENDED WILL OVERRIDE THE USER PROGRAM EXPIRE DATE, TO ALLOW FOR PAYMENTS THAT FAILED OR IF A PAYMENT WAS REFUNDED, AND ADMIN DID NOT REMOVE A PERIOD
	$selectFields = 'prog.*, memb.*';
	$mainTable = ['table' => 'user_program', 'as' => 'prog'];
	$joinConditions = [
		['table' => 'members', 'as' => 'memb', 'condition' => 'prog.ID = memb.ID', 'type' => 'LEFT']
	];
	$where = [
		/*'memb.Status' => ['!=', 'Cancelled'], // COMMENTED - TO ALLOW CANCELLING USERS, WHO CANCELLED THEMSELVES, BUT KEPT TIME REMAINING! */ 
		'memb.Username' => ['!=', 'DELETED'],
		'prog.program_id' => ['=', $prog_buffer['program_id']],
		'prog.user_status' => ['IN', ['Active', 'Suspended']],
		'prog.expire' => ['<', $lose_date],
		'prog.status_last_checked' => ['<', $date],
		'prog.suspended_by' => ['!=', 'do not suspend']
	];
	
	$orderBy = 'prog.expire ASC';
	$limit = 1;
	$show_debug = 1;

	$result_user = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);

	// CHANGED TO LIMIT 1 AND CRON NOW RUNS EVERY MIN - SINCE WE MAY DEBIT BANK USING Mat.give.php, AND HAD SOME ISSUES WITH THAT INSIDE THE WHILE LOOP!
 
	foreach($result_user as $buffer_user) {

		$table = 'user_program';
		$data = [
			'status_last_checked' => $lastrun
		];
		$where = [
			'user_program_id' => ['=', $buffer_user['user_program_id']]
		];
		$live = 1;
		$show_debug = 1;
		update($table, $data, [], $where, $live, 1, $show_debug);		

		// GET USER'S BANK BALANCE
		$selectFields = 'SUM(amount) as balance';
		$mainTable = ['table' => 'transactions_log', 'as' => 'trans'];
		$where = [
			'trans.usrid' => ['=', $buffer_user['ID']],
			'trans.description' => ['!=', 'CHARGEBACKW']
		];
		$show_debug = 1;
		$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
		$buffer = isset($result[0]) ? $result[0] : null;
		// UPDATE 5/18/24 ADDED ?? 0 - IT APPEARED $balance WAS NOT GETTING RESET FOR USERS WITH NO TRANSACATIONS,
		// THUS THEY PAID VIA BANK, WITHOUT BANK FUNDS, AND WENT NEGATIVE IN THEIR BANKS
		$balance = $buffer['balance'] ?? 0;	
		
		$keep = false; // INI VARS
		$rebill_user = false;
		
		//WE STORE ALL payment_attempts. After 3, we stop trying to bill.
		// ELSE IT WOULD KEEP TRYING EACH DAY AND NEVER SUSPEND THEM!
		// on successful payment, we reset to payment_attempts to 0.		
		
		if ($Global['use_authorize'] === true) {
			$customerProfileId = $buffer_user['customerProfileId'] ?? 0;
			$customerPaymentProfileId = $buffer_user['customerPaymentProfileId'] ?? 0;
			if ($customerProfileId > 0 && $customerPaymentProfileId > 0 && $buffer_user['payment_attempts'] < 3)
			$rebill_user = true;
			
		} else if (false && $Global['use_stripe'] === true) {	
			$stripe_customer_id = $buffer_user['stripe_customer_id'];
			$stripe_payment_method = $buffer_user['stripe_payment_method'];
			if ($stripe_customer_id == '') $stripe_customer_id = 0; // SHOULD CHANGE FIELD TYPE TO INT 4 LATER
			if ($stripe_payment_method == '') $stripe_payment_method = 0;
			if ($stripe_customer_id > 0 && $stripe_payment_method > 0 && $buffer_user['payment_attempts'] < 3)
			$rebill_user = true;			
		}
		
		$payer_username = $buffer_user['Username'];
		
		if ($debug == true) echo '<br><h2>CHECKING <a href="/admin/Sub/Finduser.php?username='.$payer_username.'" target="_blank">'.$payer_username.'</a>!</h2><br>';		
		
		// IF BALANCE IS ENOUGH, WE DEBIT THEM FOR THEIR SUBSCRIPTION
		if ($balance >= $rebill_amount) { // SET AMOUNT PER PROGRAM!
			//$program_id = The ID of the master program.
			//$payer_username = The username of the member doing the payment.
			$program_id = $prog_buffer['program_id'];
			$payer_username = $buffer_user['Username'];
			if ($debug == true) {
				echo $payer_username;
				echo '<br>';
				//exit; // RUNNING MANUALLY TO CHECK IF WORKING!!
				echo '<br><h2>'.$payer_username.' PAYING WITH BANK COMMS NOW!</h2><br>';
			}
			include $Global['path'].'Ipn/Give/Mat.give.php';
			$keep = true;
			
		// IF THEY HAVE 3 OR MORE PAYMENT ATTEMPTS, WE SKIP THIS AND SUSPEND THEM!	
		} else if ($rebill_user === true) { // REBILL VIA AUTHNET OR STRIPE
			$program_id = $prog_buffer['program_id'];
			$payer_username = $buffer_user['Username'];
			$payer_id = $buffer_user['ID'];
			$user_program_id = $buffer_user['user_program_id'];
			$GLOBALS['program_name'] = $Global['webpage_name'];
			$description = $Global['webpage_name'];
			$customerProfileId = $buffer_user['customerProfileId'];
			$customerPaymentProfileId = $buffer_user['customerPaymentProfileId'];
			$amount = $rebill_amount; // SET AMOUNT PER PROGRAM!
			$refId = $buffer_user['ID'];
			$email = $buffer_user['email'];
			$firstName = $buffer_user['First_Name'];
			$lastName = $buffer_user['Last_Name'];
			$address1 = 'CRON REBILL';
			$city = '';
			$zip = '';
			$state = '';
			$country = '';
			$phone = '';
			
				
			// payment_program VALUES, N (normal one time or sub), Y (yearly), L (lifetime)	
			// GETTING ANY type of valid_plan - WE JUST WANT MOST RECENT! AS WE CANNOT BE SURE IF IT WILL BE ACTIVE OR HISTORY!
			$selectFields = 'user_payment_plan_id, valid_plan, real_sponsorid';
			$mainTable = ['table' => 'user_payment_plan', 'as' => 'upp'];
			$where = [
				'upp.user_program_id' => ['=', $user_program_id],
				//'upp.valid_plan' => ['!=', 'H'], 
				//'upp.payment_program' => ['IN', ['N', 'Y']]
			];
			$orderBy = 'upp.user_payment_plan_id DESC';
			$limit = 1;
			$show_debug = 1;
			$live = 1;

			$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
			$plan_buffer = isset($result[0]) ? $result[0] : null;
			
			if (isset($plan_buffer['user_payment_plan_id'])) {
			$user_payment_plan_id = $plan_buffer['user_payment_plan_id'];
			$user_paymentplan_id = $plan_buffer['user_payment_plan_id'];			
			
				// SELECT THE PAYMENT PLAN //////////////////////
			$selectFields = 'pp.*, m.payment_collected_by';
			$mainTable = ['table' => 'payment_plan', 'as' => 'pp'];
			$joinConditions = [
				['table' => 'members', 'as' => 'm', 'condition' => 'pp.username = m.Username']
			];
			$where = [
				'pp.user_payment_plan_id' => ['=', $user_paymentplan_id],
				'pp.username' => ['=', 'admin']
			];
			$orderBy = 'pp.payment_plan_id DESC'; // ASC SHOWS SPONSOR TO BE PAID FIRST, DESC SHOWS ADMIN TO BE PAID FIRST
				$limit = 1;
			$show_debug = 1;
			$result2 = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);
			$plan_buffer2 = isset($result2[0]) ? $result2[0] : null;
			
				$payment_plan_id = $plan_buffer2['payment_plan_id'];
				
				if ($plan_buffer2['amount'] != $rebill_amount) {
					
					// UPDATE PAYMENT PLAN TO THE REBILL AMOUNT!
					$data = [
						'amount' => $rebill_amount,
						'payment_complete' => 'N'
					];

					$where = ['payment_plan_id' => ['=', $payment_plan_id]];
					update('payment_plan', $data, [], $where, 1, 1, 1);					
					
				}	
				
			} else {
				$user_payment_plan_id = 0;
				$user_paymentplan_id = 0;
			}	

			$payer = 'AN';
			$payment_processor = 'AN';
			$payment_processor_name = 'AuthorizeNet';
			$receiver_username = 'admin'; // QQQ IF NOT MATRIX OR ADMIN, THIS NEEDS MORE WORK
			$expected_amount = $amount;
			$program_name = $Global['webpage_name'];
			$Global['program_type'] = 'S';
			$program_type = $Global['program_type'];
			$Global['up_powerline'] = 0;
			$program_powerline = $Global['up_powerline'];


			$admin_collects = true;
			$admin_collects_tiers = false;
			$freetrial = false;
	
			// IF DOING MEMBER PAYMENTS - NOT NEEDED NOW, AS I SET UP NEW CHAIN FOR REBILLS, NO LONGER USING LOGGING / FINALIZE!
			//$plan_info = An array containing all the payment_plans in this user_payment_plan.			
			$charge_customer = true; // SET TRUE FOR REBILL PROCESS!
			$rebill_successful = false; // INI VAR
			$updateData = [
				'payment_attempts' => ['expression' => 'payment_attempts'.'+'.'1']
			];
			$where = ['ID' => ['=', $payer_id]];
			update('members', $updateData, [], $where, 1, 1, 1);			
			
			if ($Global['use_authorize'] === true) {
				if ($debug == true) echo '<br><h2>CALLING AUTHNET REBILL CRON NOW!</h2><br>';				
				include $Global['path'].'apay/pm/AuthorizeNet/rebill.php';
			} else if (false && $Global['use_stripe'] === true) {
				// THIS NEEDS MORE REVIEW AND WORK!!
				if ($debug == true) echo '<br><h2>CALLING STRIPE CRON NOW!</h2><br>';
				//include $Global['path'].'admin/Cron/Stripe_rebill.cron.php';			
			}
			// END OF CRON RUN - UPDATE CRON RUN TABLE - SHOW HANDSHAKE WAS TRUE
			
			if ($rebill_successful == true) {
				$keep = true;
				if ($debug == true) echo '<br><h2>REBILL SUCCESSFUL</h2><br>';
				// RESET PAYMENT ATTEMPTS!
				$updateData = [
					'payment_attempts' => 0
				];
				$where = ['ID' => ['=', $payer_id]];
				update('members', $updateData, [], $where, 1, 1, 1);
			} // IF REBILL FAILS, CRON CONTINUES TO RUN NORMALLY, SO THEY WILL GET SUSPENSION EMAIL
			// THIS COULD LATER BE IMPROVED WITH AN EMAIL, STATING THEIR REBILLING FAILED!
			
		} // END AUTHNET OR STRIPE REBILL	
		
		// UPDATE STATUS TO CANCELLED OR SUSPENDED, WITH DATES OF SAME IN user_program!

		if (($buffer_user['user_status'] == 'Active' && $buffer_user['end_program'] == 'Y') || 
		($buffer_user['user_status'] == 'Suspended' && $buffer_user['end_program'] == 'Y') || 
		($buffer_user['user_status'] == 'Suspended' && $buffer_user['date_suspended'] < $cancel_limit_date)
		&& $keep === false) { 
		
			$just_cancelled = true;

			// IF USER HAS CANCELLED, OR HAS BEEN SUSPENDED FOR X DAYS OR MORE, SET STATUS TO CANCELLED
			$updateDataUserProgram = [
				'user_status' => 'Cancelled',
				'date_cancelled' => $datetime,
				'cancelled_by' => 'cron'
			];
			$whereUserProgram = [
				'user_program_id' => ['=', $buffer_user['user_program_id']]
			];
			update('user_program', $updateDataUserProgram, [], $whereUserProgram, 1, 1, 1);
			
			// CANCEL USER IN MEMBERS TABLE
			// RE-THOUGHT - NOT A GOOD IDEA - SINCE WE CANNOT MAIL THEM ANYMORE!
			/*$updateDataMember = [
				'Status' => 'Cancelled'
			];
			$whereMember = [
				'ID' => ['=', $buffer_user['ID']]
			];
			update('members', $updateDataMember, [], $whereMember, 1, 1, 1);*/		
					
			// CANCEL USER IN MATRIX
			$updateDataMatrix = [
				'active' => 'N'
			];
			$whereMatrix = [
				'usrid' => ['=', $buffer_user['ID']],
				'matlevel' => ['=', $buffer_user['program_id']]
			];			
			update('matrix', $updateDataMatrix, [], $whereMatrix, 1, 1, 1);
			
			// ADDING E4 CANCELLATIONS 9/3/2014
			$updateData = [
				'active' => 'N'
			];
			$where = [
				'program_id' => ['=', $buffer_user['program_id']],
				'id_paying' => ['=', $buffer_user['ID']]
			];
			update('e4_arb', $updateData, [], $where, 1, 1, 1);
		
			// JS ADDING IN CANCEL USER IN ALL CHILD PROGRAMS
			$updateData = [
				'user_status' => 'Cancelled',
				'date_cancelled' => $datetime,
				'cancelled_by' => 'cron',
				'cancel_reason' => "User was originally comped in this child program, and lost active status in master program {$prog_buffer['program_id']}"
			];
			$where = [
				'ID' => ['=', $buffer_user['ID']],
				'program_linked' => ['=', 'Y'],
				'program_linked_to' => ['=', $prog_buffer['program_id']],
				'user_status' => ['=', 'Comped']
			];
			update('user_program', $updateData, [], $where, 1, 1, 1);
			// END CANCEL CHILD PROGRAMS

			// FIND THE SPONSOR!
			$selectFields = 'u.user_program_id, u.user_qualify';
			$mainTable = ['table' => 'user_program', 'as' => 'u'];
			$joinConditions = [
				['table' => 'members', 'as' => 'm', 'condition' => 'u.ID = m.ID']
			];
			$where = [
				'm.Username' => ['=', $buffer_user['sponsorid']],
				'u.program_id' => ['=', $buffer_user['program_id']]
			];
			$show_debug = 1;
			$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, null, 0, $show_debug);
			$buffer = isset($result[0]) ? $result[0] : null;
		
			// UPDATE USER_QUALIFY FOR THE SPONSOR!	
			if (in_array($buffer_user['sign_id'], $powerline_order)) {
				$table = 'user_program';
				$data = ['user_qualify' => ['expression' => 'user_qualify'.'-'.'1']];
				$where = [
					'user_qualify' => ['>', 0],
					'user_program_id' => ['=', $buffer['user_program_id']]
				];
				$live = 1;
				$show_debug = 1;
				update($table, $data, [], $where, $live, 1, $show_debug);
			}
	
		} else if ($buffer_user['user_status'] == 'Active' && $buffer_user['end_program'] == 'N' && $buffer_user['status_last_checked']<='{$lastrun}' && $keep == false) { // END PROGRAM IS NOT Y. THEY DID NOT ASK TO BE CANCELLED, SO WE SUSPEND THEM
		// only suspend them if status_last_checked is not a future date,
		// so manually setting that field makes users immune to suspension until then!!
				
			$table = 'user_program';
			$data = [
				'user_status' => 'Suspended',
				'date_suspended' => $datetime,
				'suspended_by' => 'cron'
			];
			$where = [
				'user_program_id' => ['=', $buffer_user['user_program_id']]
			];
			$limit = 1; // Assuming you want to update a single row matching the user_program_id
			$show_debug = 1;
			$live = 1;

			update($table, $data, [], $where, $live, $limit, $show_debug);
						
			// NOW RESET THE STATUS, SO WE EMAIL THEM TODAY (NOW)! (COND. BELOW)
			$buffer_user['user_status'] = 'Suspended';

		} else if ($keep == true) {

			/*"UPDATE user_program SET date_suspended='0000-00-00 00:00:00', suspended_by='do not suspend', suspend_reason='User last paid with Authorize.net or was manually marked paid, so we do not automatically suspend them.' WHERE user_program_id={$buffer_user['user_program_id']}"*/
		} // END SUSPENSION

		/*
		echo '<br/>user status: ';
		echo $buffer_user['user_status'];
		echo '<br/>';

		echo '<br/>program id: ';
		echo $prog_buffer['program_id'];
		echo '<br/>';
		*/

		// SEND EMAILS TO THOSE WHO ARE SUSPENDED - EMAILS ONCE PER DAY, FOR AS LONG AS THEY REMAIN SUSPENDED!
		// COMMENTED OUT && ($buffer_user['date_suspended'] > $suspended_limit_date), AS IT WAS NOT SENDING EMAIL ON DATE SUSPENDED!
		if ($keep == false && ($buffer_user['user_status'] == 'Suspended' || $just_cancelled == true) /*&& ($buffer_user['date_suspended'] > $suspended_limit_date)*/ && ($buffer_user['status_last_checked'] <= $lastrun)) { 
			//echo "We got to suspended<br>";

			$expire_time = date("M d, Y", $buffer_user['expire']);

			$text_replace = array('[webpage_name]', '[unsubscribe_link]');	
			$text_replace_with = array($Global['webpage_name'], $Global['webpage_url'].'leave.php?id='.$buffer_user['unsubscribe_id']);
			$sender_text = str_replace($text_replace, $text_replace_with, $Global['unsubscribe_email_text_nag']);	

			$subject_replace = array('[program_name]', '[firstname]', '[lastname]');	
			$subject_replace_with = array($prog_buffer['program_name'], $buffer_user['First_Name'], $buffer_user['Last_Name']);
						  						
			//Custom Tags message: [program_name] [firstname] [lastname] [date]
			$message_replace = array('[program_name]', '[firstname]', '[lastname]', '[date]', '[username]', '[password]');
			$message_replace_with = array($prog_buffer['program_name'], $buffer_user['First_Name'], $buffer_user['Last_Name'], $expire_time, $buffer_user['Username'], $buffer_user['Password']);
							  							
			if ($rebill_user == true && $rebill_successful != true) { // REBILL FAILED - LET THEM KNOW!
			$subject2 = str_replace($subject_replace, $subject_replace_with, $Global['email_arb_sub_subject']);
			$message2 = str_replace($message_replace, $message_replace_with, $Global['email_arb_sub_message'].$sender_text);
			
			} else { // SEND STANDARD SUSPENSION EMAIL NOTICE!			
			$subject2 = str_replace($subject_replace, $subject_replace_with, $Global['email_suspend_notification_subject']);
			$message2 = str_replace($message_replace, $message_replace_with, $Global['email_suspend_notification_message'].$sender_text);
			}
			
			if ($debug == true) {
				echo '<h2>Sending Email</h2>';	
				echo $message2;
				echo '<br/><br/>';
			}
	
			mail($buffer_user['email'], $subject2, $message2, "From: {$Global['admin_email_heading']} <{$Global['admin_email']}>\r\n");	
		} // END SEND EMAILS TO THOSE WHO ARE SUSPENDED
		
	} // END INNER LOOP		

} // END OUTER LOOP

echo 'complete!<br/><br/>Reminder - suspended users will be emailed once per day!';
  
?>