<?php
/**
 *  A very rudimentary User class to maintain the record of a user's 
 *  permission and manage Access Control
 * 
 * @author Kailash Badu - Kaizen Web-Productions (http://www.kaizen-web.com)   
 * @copyright Copyright(C), Kaizen Web-Productions, 2004-2008, All Rights Reserved. 
 */
class User {

    private $username;
    private $userId;
    private $permissions;
    private $con;

    public function __construct($con, $username = null) {
        $this->con = $con;
        $this->username = is_null($username) ? $_SESSION['admin_username'] : $username;
    }

    public function getUserId() {
        if (!$this->userId) {
            $where = ["Username" => addslashes($this->username)];
            $result = select("ID", "members", [], $where, null, null, null, 1, 1);
            if ($result) {
                $this->userId = $result[0]["ID"];
            }
        }
        return $this->userId;
    }

    public function checkPermissionStore($permission, $store = null) {
        if (!$store) {
            $store = isset($_SESSION['store_id']) ? $_SESSION['store_id'] : null;
        }
        if (!$store) { return false; }
        if ($this->checkPermission('ADMINISTRATORS_STORES')) {
            return true;
        } else {
            $where = [
                "member_id" => $this->getUserId(), 
                "store_id" => $store, 
                "permission.permission_name" => $permission
            ];
            $result = select("count(*) as records_count", "members_stores_permissions", ["LEFT OUTER JOIN" => ["permission" => "permission.permission_id=members_stores_permissions.permission_id"]], $where, null, null, null, 0, 1);
            return isset($result[0]) && $result[0]["records_count"] == 1;
        }
    }

    public function checkPermission($permission) {
        if (is_null($this->permissions)) {
            $this->permissions = [];
            $where = ["Username" => $this->username];
            $result = select("permission_name", "members", ["INNER JOIN" => ["user_permission" => "members.ID = user_permission.user_id", "permission" => "user_permission.permission_id = permission.permission_id"]], $where, null, null, null, 0, 1);
            if ($result) {
                foreach ($result as $row) {
                    $this->permissions[] = $row['permission_name'];
                }
            }
        }
        return in_array($permission, $this->permissions);
    }
}

<?php
if (FALSE) {
   class User{
   
     /**
      * Username
      * @var string
      */
      
     private $username;

     /**
      * User id
      * @var int
      */
     private $userId;
     
     /**
      * Permissons assigned to the user
      * @var array
      */
     private $permissons;
     
     /**
      * MySQL connection resource
      * @var resource
      */
     private $con;
   
     /**
      * @param resource $con database connection resource,
      * @param username $username username of the user
      */
     public function __construct($con, $username = null){
        $this->con = $con;
        
        //if id is not provided, assume it to be the logged in user
        $this->username = is_null($username) ? $_SESSION['admin_username'] : $username;  
     }
     
     public function getUserId() {
     	if (!$this->userId) {
     		$tmpResultSet = mysql_query("select ID from members where Username=\"" . addslashes($this->username). "\"") or die(mysql_error());
     		$tmp = mysql_fetch_assoc($tmpResultSet);
     		$this->userId = $tmp["ID"];
     	}
     	
     	return $this->userId;
     }
     
     public function checkPermissonStore($permisson, $store = null) {
     	if (!$store) {
     		if (isset($_SESSION['store_id'])) {
     			$store = $_SESSION['store_id'];
     		}
     	}
     	if (!$store) {return false;}
     	if ($this->checkPermisson('ADMINISTRATORS_STORES')) {
     		return true;
     	} else {
	     	$tmpResultSet = mysql_query("select count(*) as records_count from members_stores_permissions left outer join permission on permission.permission_id=members_stores_permissions.permission_id where member_id=" . $this->getUserId() . " and store_id=" . $store . " and permission.permission_name=\"" . $permisson . "\"") or die(mysql_error());
	     	$tmp = mysql_fetch_row($tmpResultSet);
	     	
	     	return $tmp[0] == 1;
     	}
     }
     
     public function checkPermisson($permisson){
       //load the permissons for this user only the first time this method is called  
       if(is_null($this->permissons)){
          $this->permissons = array();
          $sql = "SELECT 
                        permission_name
                  FROM
                        members INNER JOIN user_permission ON  members.ID = user_permission.user_id
                        INNER JOIN permission ON user_permission.permission_id =   permission.permission_id
                  WHERE 
                        members.Username = '%s'";
          $sql = sprintf($sql, $this->username);
          //the MySQL functions can be replaced with PDO or other DBALs if required.
          $result = mysql_query($sql, $this->con);
          while ($row = mysql_fetch_assoc($result)) {
              $this->permissons[] = $row['permission_name'];  
          }        
       }
       //check if the permisson exists
       if (in_array($permisson, $this->permissons)) {
         return true;
       }
       else {
         return false;
       }       
     }   
   }

}