function unserialize(data) {
					var error = function (type, msg, filename, line){throw new this.window[type](msg, filename, line);};
					var read_until = function (data, offset, stopchr){
							var buf = [];
							var chr = data.slice(offset, offset + 1);
							var i = 2;
							while (chr != stopchr) {
									if ((i+offset) > data.length) {
											error('Error', 'Invalid');
									}
									buf.push(chr);
									chr = data.slice(offset + (i - 1),offset + i);
									i += 1;
							}
							return [buf.length, buf.join('')];
					};
					var read_chrs = function (data, offset, length){
							var buf;

							buf = [];
							for(var i = 0;i < length;i++){
									var chr = data.slice(offset + (i - 1),offset + i);
									buf.push(chr);
							}
							return [buf.length, buf.join('')];
					};
					var _unserialize = function (data, offset){
							var readdata;
							var readData;
							var chrs = 0;
							var ccount;
							var stringlength;
							var keyandchrs;
							var keys;

							if(!offset) {offset = 0;}
							var dtype = (data.slice(offset, offset + 1)).toLowerCase();

							var dataoffset = offset + 2;
							var typeconvert = new Function('x', 'return x');

							switch(dtype){
									case 'i':
											typeconvert = function (x) {return parseInt(x, 10);};
											readData = read_until(data, dataoffset, ';');
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 1;
									break;
									case 'b':
											typeconvert = function (x) {return parseInt(x, 10) !== 0;};
											readData = read_until(data, dataoffset, ';');
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 1;
									break;
									case 'd':
											typeconvert = function (x) {return parseFloat(x);};
											readData = read_until(data, dataoffset, ';');
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 1;
									break;
									case 'n':
											readdata = null;
									break;
									case 's':
											ccount = read_until(data, dataoffset, ':');
											chrs = ccount[0];
											stringlength = ccount[1];
											dataoffset += chrs + 2;

											readData = read_chrs(data, dataoffset+1, parseInt(stringlength, 10));
											chrs = readData[0];
											readdata = readData[1];
											dataoffset += chrs + 2;
											if(chrs != parseInt(stringlength, 10) && chrs != readdata.length){
													error('SyntaxError', 'String length mismatch');
											}
									break;
									case 'a':
										
											readdata = {};

											keyandchrs = read_until(data, dataoffset, ':');
											chrs = keyandchrs[0];
											keys = keyandchrs[1];
											dataoffset += chrs + 2;

											for(var i = 0;i < parseInt(keys, 10);i++){
													var kprops = _unserialize(data, dataoffset);
													var kchrs = kprops[1];
													var key = kprops[2];
													dataoffset += kchrs;

													var vprops = _unserialize(data, dataoffset);
													var vchrs = vprops[1];
													var value = vprops[2];
													dataoffset += vchrs;

													readdata[key] = value;
											}

											dataoffset += 1;
									break;
									default:
											error('SyntaxError', 'Unknown / Unhandled data type(s): ' + dtype);
									break;
							}
							return [dtype, dataoffset - offset, typeconvert(readdata)];
					};

					return _unserialize((data+''), 0)[2];
			}

	function serialize(mixed_value ) {
			var _getType = function( inp ) {
					var type = typeof inp, match;
					var key;
					if (type == 'object' && !inp) {
							return 'null';
					}
					if (type == "object") {
							if (!inp.constructor) {
									return 'object';
							}
							var cons = inp.constructor.toString();
							match = cons.match(/(\w+)\(/);
							if (match) {
									cons = match[1].toLowerCase();
							}
							var types = ["boolean", "number", "string", "array"];
							for (key in types) {
									if (cons == types[key]) {
											type = types[key];
											break;
									}
							}
					}
					return type;
			};
			var type = _getType(mixed_value);
			var val, ktype = '';

			switch (type) {
					case "function":
							val = "";
							break;
					case "boolean":
							val = "b:" + (mixed_value ? "1" : "0");
							break;
					case "number":
							val = (Math.round(mixed_value) == mixed_value ? "i" : "d") + ":" + mixed_value;
							break;
					case "string":
							val = "s:" + encodeURIComponent(mixed_value).replace(/%../g, 'x').length + ":\"" + mixed_value + "\"";
							break;
					case "array":
					case "object":
							val = "a";
							/*
							if (type == "object") {
									var objname = mixed_value.constructor.toString().match(/(\w+)\(\)/);
									if (objname == undefined) {
											return;
									}
									objname[1] = serialize(objname[1]);
									val = "O" + objname[1].substring(1, objname[1].length - 1);
							}
							*/
							var count = 0;
							var vals = "";
							var okey;
							var key;
							for (key in mixed_value) {
									ktype = _getType(mixed_value[key]);
									if (ktype == "function") {
											continue;
									}

									okey = (key.match(/^[0-9]+$/) ? parseInt(key, 10) : key);
									vals += serialize(okey) +
													serialize(mixed_value[key]);
									count++;
							}
							val += ":" + count + ":{" + vals + "}";
							break;
					case "undefined": // Fall-through
					default: // if the JS object has a property which contains a null value, the string cannot be unserialized by PHP
							val = "N";
							break;
			}
			if (type != "object" && type != "array") {
					val += ";";
			}
			return val;
	}

function print_r( array, return_val ) {
    // Prints out or returns information about the specified variable
    //
    // version: 906.801
    // discuss at: http://phpjs.org/functions/print_r
    // +   original by: Michael White (http://getsprink.com)
    // +   improved by: Ben Bryan
    // +      input by: Brett Zamir (http://brett-zamir.me)
    // +      improved by: Brett Zamir (http://brett-zamir.me)
    // +   improved by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // -    depends on: echo
    // *     example 1: print_r(1, true);
    // *     returns 1: 1

    var output = "", pad_char = " ", pad_val = 4, d = this.window.document;
    var getFuncName = function (fn) {
        var name = (/\W*function\s+([\w\$]+)\s*\(/).exec(fn);
        if(!name) {
            return '(Anonymous)';
        }
        return name[1];
    };

    var repeat_char = function (len, pad_char) {
        var str = "";
        for(var i=0; i < len; i++) {
            str += pad_char;
        }
        return str;
    };

    var formatArray = function (obj, cur_depth, pad_val, pad_char) {
        if (cur_depth > 0) {
            cur_depth++;
        }

        var base_pad = repeat_char(pad_val*cur_depth, pad_char);
        var thick_pad = repeat_char(pad_val*(cur_depth+1), pad_char);
        var str = "";

        if (typeof obj === 'object' && obj !== null && obj.constructor && getFuncName(obj.constructor) !== 'PHPJS_Resource') {
            str += "Array\n" + base_pad + "(\n";
            for (var key in obj) {
                if (obj[key] instanceof Array) {
                    str += thick_pad + "["+key+"] => "+formatArray(obj[key], cur_depth+1, pad_val, pad_char);
                } else {
                    str += thick_pad + "["+key+"] => " + obj[key] + "\n";
                }
            }
            str += base_pad + ")\n";
        } else if(obj === null || obj === undefined) {
            str = '';
        } else { // for our "resource" class
            str = obj.toString();
        }

        return str;
    };

    output = formatArray(array, 0, pad_val, pad_char);

    if (return_val !== true) {
        if (d.body) {
            alert(output);
        }
        else {
            try {
                d = XULDocument; // We're in XUL, so appending as plain text won't work; trigger an error out of XUL
                this.echo('<pre xmlns="http://www.w3.org/1999/xhtml" style="white-space:pre;">'+output+'</pre>');
            }
            catch(e) {
                alert(output); // Outputting as plain text may work in some plain XML
            }
        }
        return true;
    } else {
        return output;
    }
}

/**
 * jQuery Builder Plugin
 * Copyright (c) 2009 Nikolay Kolev, Kaizen Web-Productions (http://www.kaizen-web.com)
 * Copyright notice and license must remain intact for legal use
 * Version 0.1
 */
(function($){
	$.fn.formbuilder = function(options) {

		// Extend the configuration options with user-provided
		var defaults = {
			elements: false,
			pointer: false,
			idx: false
		};
		var opts = $.extend(defaults, options);

		return this.each(function() {
			var ul_obj 		= this;
			var field 		= '';
			var field_type 	= '';
			var last_id 	= 1;
			var elements = {};
			var current_level = elements;
			var element_sequence = {0: 0};

			/**
			 * Count the number of properties in an object
			 */
			var count = function(myobj) {
				var count = 0;
				for (k in myobj) {
					if (myobj.hasOwnProperty(k)) {
						count++;
						}
					}
				return count;
				}

			/**
			 * Deletes element with index and shift the other elements
			 */
			var deleteElement = function(elems, index) {
				var len = count(elems), temp, i;
				if (index >= 1 && index <= len) {
					temp = elems[index];
					for(i=index;i < len;++i) {
						//elems[i] = jQuery.extend(true, {}, elems[i*1+1*1]);
						elems[i] = elems[i*1+1*1];
						elems[i]['order'] = i;
						if (elems[i]['checks']) {
							for(j in elems[i]['checks']) {
								elems[i]['checks'][j]['parent_order'] = i;
								}
							}
						}
					elems[len] = temp;
					delete elems[len];
					}
				}

			/**
			 * Go one level up
			 */
			var changeLevel = function(parent_order, child_order) {

				var old_cnt_p = count(current_level), old_cnt_c = count(current_level[parent_order]['checks']);

				//save the data from the current level
				updateElements();

				parent_order = parent_order - (old_cnt_p - count(current_level));
				child_order = child_order- (old_cnt_c - count(current_level[parent_order]['checks']));

				var len = count(element_sequence);
				element_sequence[len] = parent_order;
				element_sequence[len+1] = child_order;

				current_level = current_level[parent_order]['checks'][child_order]['elements'];
				loadElements(current_level);

				//generate the new path
				generatePath();
			}

			/**
			 * Loads all the elements from the specified array
			 */
			var loadElements = function(elems) {
				$(ul_obj).html('');
				var eli;
				last_id = 1;
				for(eli in elems) {
					appendNewField(elems[eli]['type'], elems[eli]);
					}
				}

			/**
			 * Updates the value of the current elements
			 */
			var updateElements = function() {
				$('ul#form-builder'+opts.idx).each(function(){
					var ul_obj = this;

					var li_count 	= 1;
					$(this).children().each(function() {

						while (current_level[li_count]['deleted']) {
							++li_count;
						}

						current_level[li_count]['required'] = $('#'+$(this).attr('id')+' input.required').is(':checked');

						switch($(this).attr('class')) {
							case 'input_text':
								$('#'+$(this).attr('id')+' input[type=text]').each(function(){
									if($(this).attr('name') == 'label') {
										current_level[li_count]['label'] = $(this).val();
									} else {
										current_level[li_count]['value'] = $(this).val();
									}
									});
								break;
							case 'link':
								$('#'+$(this).attr('id')+' input[type=text]').each(function(){
									if($(this).attr('name') == 'label') {
										current_level[li_count]['label'] = $(this).val();
									} else if($(this).attr('name') == 'value') {
										current_level[li_count]['value'] = $(this).val();
									}
									});
								$('#'+$(this).attr('id')+' input[type=checkbox]').each(function(){
									if($(this).attr('name') == 'blank' && $(this).is(':checked')) {
										current_level[li_count]['blank'] = 1;
									}
									});
								break;
							case 'textarea':
								$('#'+$(this).attr('id')+' input[type=text]').each(function(){
									if($(this).attr('name') == 'label') {
										current_level[li_count]['label'] = $(this).val();
									}
									});
								$('#'+$(this).attr('id')+' textarea').each(function(){
									if($(this).attr('name') == 'value') {
										current_level[li_count]['value'] =$(this).val();
									}
									});
								break;
							case 'checkbox':
								$('#'+$(this).attr('id')+' input[type=text]').each(function(){

									if($(this).attr('name') == 'label') {
										current_level[li_count]['label'] = $(this).val();
									}
								});
								$('#'+$(this).attr('id')+' input[type=checkbox].innset_elem').each(function(){
									current_level[li_count]['checks'][$(this).attr('rel')]['value'] = $(this).next().next().next().val();
									current_level[li_count]['checks'][$(this).attr('rel')]['label'] = $(this).next().next().next().next().next().next().val();
									current_level[li_count]['checks'][$(this).attr('rel')]['checked'] = $(this).is(':checked');
								});
								break;
							case 'radio':
								$('#'+$(this).attr('id')+' input[type=text]').each(function(){

									if($(this).attr('name') == 'label') {
										current_level[li_count]['label'] = $(this).val();
									}
								});
								$('#'+$(this).attr('id')+' input[type=radio].innset_elem').each(function(){
									current_level[li_count]['checks'][$(this).attr('rel')]['value'] = $(this).next().next().next().val();
									current_level[li_count]['checks'][$(this).attr('rel')]['label'] = $(this).next().next().next().next().next().next().val();
									current_level[li_count]['checks'][$(this).attr('rel')]['checked'] = $(this).is(':checked');
								});
								break;
							case 'select':
								$('#'+$(this).attr('id')+' input[type=text]').each(function(){

									if($(this).attr('name') == 'label') {
										current_level[li_count]['label'] = $(this).val();
									}
								});
								$('#'+$(this).attr('id')+' input[type=radio].innset_elem').each(function(){
									current_level[li_count]['checks'][$(this).attr('rel')]['value'] = $(this).next().next().next().val();
									current_level[li_count]['checks'][$(this).attr('rel')]['label'] = $(this).next().next().next().next().next().next().val();
									current_level[li_count]['checks'][$(this).attr('rel')]['checked'] = $(this).is(':checked');
								});
							break;
						}

						++li_count;
					});
				})

				clearCurrentLevel();
				}

			$(ul_obj).html('');

			var with_subelements = ['checkbox', 'radio', 'select'];

			var hasSubelements = function(elem_type) {
				var len = with_subelements.length, found = false;
				for(i=0;i < len;++i) {
					if (with_subelements[i] == elem_type) {
						found = true;
						break;
						}
					}
				return found;
				}

			// Create form control select box and add into the editor
			$(this).before('<strong>Path:</strong> <span id="elements_path'+opts.idx+'" class="form_elements_path">Main Level</span><br /><br />');
			var select = '';
			select += '<option value="0">Add New Field...</option>';
			select += '<option value="input_text">Text</option>';
			select += '<option value="link">Link</option>';
			select += '<option value="textarea">Text Area</option>';
			select += '<option value="checkbox">Checkboxes</option>';
			select += '<option value="radio">Radio</option>';
			select += '<option value="select">Select List</option>';
			$(this).before('<select name="field_control_top" class="field_control">'+select+'</select>');
			$(this).after('<select name="field_control_bot" class="field_control">'+select+'</select>');
			$('.field_control').change(function(){
				current_level[last_id] = {'type': $(this).val()};
				appendNewField($(this).val(), current_level[last_id]);
				$(this).val(0).blur();
				return false;
			});

			/**
			 * Does clean tasks on the current level - deletes marked for deletion
			 * elements, etc.
			 */
			var clearCurrentLevel = function() {
				for(c in current_level) {
					if (current_level[c]['deleted']) {
						deleteElement(current_level, c);
						}
					else if (hasSubelements(current_level[c]['type'])) {

						//iterate through it's sub elements
						for(sub in current_level[c]['checks']) {
							if (current_level[c]['checks'][sub]['deleted']) {
								deleteElement(current_level[c]['checks'], sub);
								}
							}
						}
					}
				}

			/**
			 * Shows the full path to navigate
			 */
			var generatePath = function() {
				var len = count(element_sequence), str = '', lastElem = elements, cnt = 0;
				$('#elements_path'+opts.idx).html('');
				if (len > 1) {
					for(var i in element_sequence) {
						if (i == 0) {
							$('#elements_path'+opts.idx).append('<a href="#" rel="'+i+'" class="change_path">Main Level</a> => ');
							}
						else if (cnt == len - 1) {
							if (lastElem['checks'][element_sequence[i]]['label'] == "") {
								str = '[no label]';
								}
							else {
								str = lastElem['checks'][element_sequence[i]]['label'];
								}
							$('#elements_path'+opts.idx).append(str);
							}
						else if (i % 2 == 1) {
							if (lastElem[element_sequence[i]]['label'] == "") {
								str = '[no label]';
								}
							else {
								str = lastElem[element_sequence[i]]['label'];
								}
							$('#elements_path'+opts.idx).append('<a href="#" rel="'+i+'" class="change_path">'+str+'</a> => ');
							lastElem = lastElem[element_sequence[i]];
							}
						else {
							if (lastElem['checks'][element_sequence[i]]['label'] == "") {
								str = '[no label]';
								}
							else {
								str = lastElem['checks'][element_sequence[i]]['label'];
								}
							$('#elements_path'+opts.idx).append('<a href="#" rel="'+i+'" class="change_path">'+str+'</a> => ');
							lastElem = lastElem['checks'][element_sequence[i]]['elements'];
							}
						++cnt;
						}
					}
				else {
					$('#elements_path'+opts.idx).append('Main Level');
					}
				}

			generatePath();

			/**
			 * Fills in the main container with all element
			 */
			var drawElements = function() {
				var len = count(element_sequence);
				if (len > 1) {
					var lastElem = elements;
					for(var i in element_sequence) {
						if (i == 0) {
							continue;
							}
						if (i % 2 == 1) {
							lastElem = lastElem[element_sequence[i]];
							}
						else {
							lastElem = lastElem['checks'][element_sequence[i]]['elements'];
							}
						}
					current_level = lastElem;
					}
				else {
					current_level = elements;
					}
				loadElements(current_level);
				}

			// handle field delete links
			$('.change_path').live('click', function(){

				if ($(this).attr('rel') == 0) {
					$(this).attr('rel', 1);
					}

				for(var i=count(element_sequence)-1;i > $(this).attr('rel');--i) {
					delete element_sequence[i];
					}

				if (count(element_sequence) % 2 == 0 && count(element_sequence) > 1) {
					delete element_sequence[count(element_sequence)-1];
					}

				updateElements();
				generatePath();
				drawElements();
				return false;
				});

			// Wrapper for adding a new field
			var appendNewField = function(type, elem) {

				field = '';
				field_type = type;

				if(typeof(elem['order']) == 'undefined'){ elem['order'] = last_id; }
				if(typeof(elem['post_name']) == 'undefined'){ elem['post_name'] = ''; }
				if(typeof(elem['value']) == 'undefined'){ elem['value'] = ''; }
				if(typeof(elem['label']) == 'undefined'){ elem['label'] = ''; }
				if(typeof(elem['required']) == 'undefined'){ elem['required'] = false; }
				elem['deleted'] = false;

				switch(type){
					case 'input_text':
						appendTextInput(elem);
						break;
					case 'textarea':
						appendTextarea(elem);
						break;
					case 'checkbox':
						appendCheckboxGroup(elem);
						break;
					case 'radio':
						appendRadioGroup(elem);
						break;
					case 'select':
						appendSelectList(elem);
						break;
					case 'link':
						appendLink(elem);
						break;
				}
			}

			// single line input type="text"
			var appendTextInput = function(elem){

				field += '<label>Label:</label>';
				field += '<input class="fld-label" name="label" id="label-'+last_id+'" type="text" value="'+elem['label']+'" /><br />';
				field += '<label>Default Value:</label>';
				field += '<input class="fld-value" name="value" id="value-'+last_id+'" type="text" value="'+elem['value']+'" />';
				help = '';

				appendFieldLi('Text Field', field, elem['required'], help, elem);

			}

			// a html link
			var appendLink = function(elem){

				var checked = '';
				if(elem['blank'] && elem['blank'] == 1){
					checked = ' checked="checked"';
					}

				field += '<label>Open In New Window:</label> <input class="fld-check" name="blank" id="blank-'+last_id+'"'+checked+' type="checkbox" value="1" />';
				field += '<br /><label>Label:</label>';
				field += '<input class="fld-label" name="label" id="label-'+last_id+'" type="text" value="'+elem['label']+'" />';
				field += '<br /><label>Link:</label>';
				field += '<input class="fld-value" name="value" id="value-'+last_id+'" type="text" value="'+elem['value']+'" /><br />';
				help = '';

				appendFieldLi('Link', field, elem['required'], help, elem);

			}

			// multi-line textarea
			var appendTextarea = function(elem){

				field += '<label>Label:</label>';
				field += '<input type="text" class="fld-label" name="label" value="'+elem['label']+'" /><br />';
				field += '<label>Default Value:</label>';
				field += '<textarea class="fld-value" name="value" id="value-'+last_id+'">'+elem['value']+'</textarea>';
				help = '';

				appendFieldLi('Text Area Field', field, elem['required'], help, elem);

			}

			// adds a checkbox element
			var appendCheckboxGroup = function(elem){

				field += '<div class="chk_group">';
				field += '<label>Label:</label>';
				field += '<input type="text" name="label" value="'+elem['label']+'" /></div>';
				field += '<div class="false-label">Select Options</div>';
				field += '<div class="fields">';

				if(typeof(elem['checks']) == 'object'){
					for(c in elem['checks']){
						field += checkboxFieldHtml(elem['checks'][c]);
					}
				} else {
					elem['checks'] = {}
					elem['checks'][1] = addEmptyElement(elem['post_name'], 1, elem['order']);
					field += checkboxFieldHtml(elem['checks'][1]);
				}

				field += '<div class="add-area"><a href="#" class="add add_ck_'+elem['order']+'">Add Check</a></div>';
				field += '</div>';
				//field += '</div>';

				help = '';
				appendFieldLi('Checkbox Group', field, elem['required'], help, elem);

				$('ul#form-builder'+opts.idx+' .add_ck_'+elem['order']).bind('click', function() {
					if(typeof(elem['checks']) == 'undefined') {
						elem['checks'] = {}
						}
					var len = count(elem['checks'])+1;
					elem['checks'][len] = addEmptyElement(elem['post_name'], len, elem['order']);
					$(this).parent().before( checkboxFieldHtml(elem['checks'][len]) );
					return false;
				});
			}

			// Checkbox field html, since there may be multiple
			var checkboxFieldHtml = function(elem){

				field = '';
				field += '<br /><div>';
				field += '<div class="center_checks"><a href="#" class="remove_'+elem['parent_order']+'_'+elem['order']+'" title="Are you sure you want to remove this checkbox?">Remove</a>';
				field += ' | <a href="#" class="elems_'+elem['parent_order']+'_'+elem['order']+'">Manage Elements ('+(count(elem['elements']))+')</a></div>';
				field += '<label>Checked:</label> <input class="innset_elem" rel="'+elem['order']+'" type="checkbox"'+(elem['checked'] ? ' checked="checked"' : '')+' /> <br /> <label>Value:</label> <input type="text" name="value_in" value="'+elem['value']+'" /><br /> <label>Label:</label> <input type="text" name="label_in" value="'+elem['label']+'" />';
				field += '</div>';

				// handle field delete links
				$('ul#form-builder'+opts.idx+' .remove_'+elem['parent_order']+'_'+elem['order']).live('click', function(){
					if(confirm( $(this).attr('title') )){
						$(this).parent('div').parent('div').animate({opacity: 'hide', height: 'hide', marginBottom: '0px'}, 'fast', function () {
							elem['deleted'] = true;
							$(this).remove();
						});
					}
					return false;
				});

				$('ul#form-builder'+opts.idx+' .elems_'+elem['parent_order']+'_'+elem['order']).live('click', function(){
					changeLevel(elem['parent_order'], elem['order']);
					return false;
				});

				return field;

			}

			// adds a radio element
			var appendRadioGroup = function(elem){

				field += '<div class="rd_group">';
				field += '<label>Label:</label>';
				field += '<input type="text" name="label" value="'+elem['label']+'" /></div>';
				field += '<div class="false-label">Select Options</div>';
				field += '<div class="fields">';

				if(typeof(elem['checks']) == 'object'){
					for(c in elem['checks']){
						field += radioFieldHtml(elem['checks'][c]);
					}
				} else {
					elem['checks'] = {}
					elem['checks'][1] = addEmptyElement(elem['post_name'], 1, elem['order']);
					field += radioFieldHtml(elem['checks'][1]);
				}

				field += '<div class="add-area"><a href="#" class="add add_rd_'+elem['order']+'">Add Radio</a></div>';
				field += '</div>';
				//field += '</div>';
				help = '';

				appendFieldLi('Radio Group', field, elem['required'], help, elem);

				$('ul#form-builder'+opts.idx+' .add_rd_'+elem['order']).bind('click', function(){
					if(typeof(elem['checks']) == 'undefined') {
						elem['checks'] = {}
						}
					var len = count(elem['checks'])+1;
					elem['checks'][len] = addEmptyElement(elem['post_name'], len, elem['order']);
					$(this).parent().before( radioFieldHtml(elem['checks'][len]) );
					return false;
				});
			}

			// Radio field html, since there may be multiple
			var radioFieldHtml = function(elem){

				field = '';
				field += '<br /><div>';
				field += '<div class="center_checks"><a href="#" class="remove_'+elem['parent_order']+'_'+elem['order']+'" title="Are you sure you want to remove this radio button option?">Remove</a>';
				field += ' | <a href="#" class="elems_'+elem['parent_order']+'_'+elem['order']+'">Manage Elements ('+(count(elem['elements']))+')</a></div>';
				field += '<label>Selected:</label> <input class="innset_elem" rel="'+elem['order']+'" type="radio"'+(elem['checked'] ? ' checked="checked"' : '')+' name="'+opts.idx+'rdb_'+elem['parent_order']+'" /> <br /><label>Value:</label> <input name="value_in" type="text" value="'+elem['value']+'" /> <br /> <label>Label:</label> <input type="text" name="label_in" value="'+elem['label']+'" />';
				field += '</div>';

				// handle field delete links
				$('ul#form-builder'+opts.idx+' .remove_'+elem['parent_order']+'_'+elem['order']).live('click', function(){
					if(confirm( $(this).attr('title') )){
						$(this).parent('div').parent('div').animate({opacity: 'hide', height: 'hide', marginBottom: '0px'}, 'fast', function () {
							elem['deleted'] = true;
							$(this).remove();
						});
					}
					return false;
				});

				$('ul#form-builder'+opts.idx+' .elems_'+elem['parent_order']+'_'+elem['order']).live('click', function(){
					changeLevel(elem['parent_order'], elem['order']);
					return false;
				});

				return field;

			}

			// adds a select/option element
			var appendSelectList = function(elem){

				field += '<div class="opt_group">';
				field += '<label>Label:</label>';
				field += '<input type="text" name="label" value="'+elem['label']+'" /></div>';
				field += '';
				field += '<div class="false-label">Select Options</div>';
				field += '<div class="fields">';

				if(typeof(elem['checks']) == 'object'){
					for(c in elem['checks']){
						field += selectFieldHtml(elem['checks'][c]);
					}
				} else {
					elem['checks'] = {}
					elem['checks'][1] = addEmptyElement(elem['post_name'], 1, elem['order']);
					field += selectFieldHtml(elem['checks'][1]);
				}

				field += '<div class="add-area"><a href="#" class="add add_opt_'+elem['order']+'">Add</a></div>';
				field += '</div>';
				//field += '</div>';
				help = '';

				appendFieldLi('Select List', field, elem['required'], help, elem);

				$('ul#form-builder'+opts.idx+' .add_opt_'+elem['order']).bind('click', function() {
					if(typeof(elem['checks']) == 'undefined') {
						elem['checks'] = {}
						}
					var len = count(elem['checks'])+1;
					var ttt = addEmptyElement(elem['post_name'], len, elem['order']);
					elem['checks'][len] = ttt;
					$(this).parent().before( selectFieldHtml(elem['checks'][len]) );
					return false;
				});
			}

			// Select field html, since there may be multiple
			var selectFieldHtml = function(elem){
				return radioFieldHtml(elem);
			}


			// Appends the new field markup to the editor
			var appendFieldLi = function(title, field_html, required, help, elem) {

				var li = '';
				li += '<li id="frm-'+last_id+'-item'+opts.idx+'" class="'+field_type+'">';
				li += '<div class="legend"><strong id="txt-title-'+last_id+'">'+title+'</strong><div class="manage_field_links"><a id="frm-'+last_id+'" class="toggle-form" href="#">Hide</a>&nbsp;&nbsp;&nbsp;<a id="del_'+last_id+'" class="del-button delete-confirm_'+elem['order']+'" href="#"  title="Are you sure you want to delete this form section?">Delete</a>&nbsp;</div><div style="clear:both;"><!-- --></div></div>';
				li += '<div id="frm-'+last_id+'-fld" class="frm-holder">';
				li += '<div class="frm-elements">';
				if (elem['type'] != 'link') {
					li += '<div class="frm-fld"><label for="required-'+last_id+'">Required?</label><input class="required" type="checkbox" value="1" name="required-'+last_id+'" id="required-'+last_id+'"'+(required ? ' checked="checked"' : '')+' /></div>';
				}
				li += field;
				li += '</div>';
				li += '&nbsp;';
				li += '</div>';
				li += '</li>';

				$(ul_obj).append(li);
				$('#frm-'+last_id+'-item'+opts.idx).hide();
				$('#frm-'+last_id+'-item'+opts.idx).animate({opacity: 'show', height: 'show', marginBottom: 35}, 'slow');

				last_id++;

				// handle delete confirmation
				$('ul#form-builder'+opts.idx+' .delete-confirm_'+elem['order']).bind('click', function() {
					var delete_id = $(this).attr("id").replace(/del_/, '');
					if(confirm( $(this).attr('title') )){
						$('#frm-'+delete_id+'-item'+opts.idx).animate({opacity: 'hide', height: 'hide', marginBottom: '0px'}, 'slow', function () {
							current_level[delete_id]['deleted'] = true;
							$(this).remove();
						});
					}
					return false;
				});
			}

			var addEmptyElement = function(post_name, order, parent_order) {
				return {'parent_order': parent_order, 'order': order, 'deleted': false, 'post_name': post_name, 'label': '', 'value': '', 'checked': false, 'elements': {}};
			}

			// handle field display/hide
			$('.toggle-form').live('click', function(){
				var target = $(this).attr("id");
				if($(this).html() == 'Hide'){
					$(this).removeClass('open').addClass('closed').html('Show');
					$('#' + target + '-fld').animate({opacity: 'hide', height: 'hide'}, 'slow');
					return false;
				}
				if($(this).html() == 'Show'){
					$(this).removeClass('closed').addClass('open').html('Hide');
					$('#' + target + '-fld').animate({opacity: 'show', height: 'show'}, 'slow');
					return false;
				}
				return false;
			});

			// handle delete confirmation
			$('.delete-confirm').live('click', function() {
				var delete_id = $(this).attr("id").replace(/del_/, '');
				if(confirm( $(this).attr('title') )){
					$('#frm-'+delete_id+'-item').animate({opacity: 'hide', height: 'hide', marginBottom: '0px'}, 'slow', function () {
						$(this).remove();
					});
				}
				return false;
			});

			// saves the serialized data to the server
			this.save = function(){
				updateElements()
				
				return serialize(elements);
			}

			//load the initial values
			if(opts.elements){
				elements = unserialize(opts.elements);
				current_level = elements;
				loadElements(current_level);
				}

			if (opts.pointer && opts.idx) {
				opts.pointer[opts.idx] = this;
				}
		});
	};
})(jQuery);