<?php
//---------------------------------------------------------------
//Made by: Nikolay Kolev
//Firm: Kaizen
//Date: 16th July 2009
//Last Modified: 22th January 2010
//----------------------------------------------------------------

include_once $Global['path'].'admin/Lib/OrderSubscription.inc.php';

//if there is no language included include a default one
if (!isset($Language)) {
	include_once $Global['path'].'Store_inc/Lang/English.language.php';
	}

/**
 * Returns order item and description texts for a store
 *
 * @param int $store_id		The store we want to get the text for
 * @return array					The returned texts
 */
function get_order_texts($store_id) {
	$res = array('item'=>'', 'description'=>'');
	$query = "SELECT
							text_type
							, text_data
						FROM
							text
						WHERE
							store_id=".(int)$store_id."
							AND text_type IN ('order_item', 'order_desc')";
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {
		if ($buffer['text_type'] == 'order_item') {
			$res['item'] = $buffer['text_data'];
			}
		else {
			$res['description'] = $buffer['text_data'];
			}
		}
	return $res;
	}

/**
 * Sends an email(s) for the subscription info for an order if
 * the order has a subscription. We sent an email that the subscription
 * is received and the code the unsubscribe from it
 *
 * @param int $order_id
 */
function send_subscription_emails($order_id) {

	global $Language, $Global;

	//the list of all products
	$product_email = "";

	//the info for the store the order is from
	$store_id = '';
	$store_email = '';
	$store_email_title = '';

	//whether this order has subscription or not
	$has_subscription = false;

	//an array of emails to which the email should be sent to
	$emails = array();

	//get the order details
	$query = "SELECT
							o.*
							, ol.*
							, s.store_name
							, s.store_email
							, s.store_email_title
						FROM
							orders o
							INNER JOIN order_link ol
								USING(orders_id)
							INNER JOIN store s
								USING(store_id)
						WHERE
							o.orders_id=".(int)$order_id;
	$result = mysql_query($query) or die(mysql_error());
	$first = true;
	while ($buffer = mysql_fetch_assoc($result)) {
		
		//fetch the order details once
		if ($first === true) {

			//check if this order has active subscription
			if ($buffer['orders_subscription'] == 'Y' && $buffer['orders_subscription_active'] == 'Y') {
				$has_subscription = true;
				}
			else {
				break 1;
				}

			//depending if this order was made by a logged in person or not we change the url for unsubscription
			if (!empty($buffer['buyer_id'])) {
				$order_cancel_url = $Global['webpage_url_ssl'].'Members/unsubscribe_order.php';
				}
			else {
				$order_cancel_url = $Global['webpage_url_ssl'].'unsubscribe_order.php';
				}

			//the values which we'll replace the tags with
			$subject_replace_with = array($buffer['store_name'], $buffer['orders_id'], $buffer['orders_firstname'], $buffer['orders_lastname']);
			$message_replace_with = array($buffer['store_name'], $buffer['orders_firstname'], $buffer['orders_lastname'], $buffer['orders_address'].((!empty($buffer['orders_address2']))?"\r\n".$buffer['orders_address2']:''), $buffer['orders_zip'], $buffer['orders_city'], get_state_name($buffer['orders_state'], $buffer['orders_region']), get_country_name($buffer['orders_country']), ((!empty($buffer['orders_phone']))?$buffer['orders_phone']:$Language['checkout']['na']), $Language['checkout']['na'], $buffer['orders_id'], '', number_format($buffer['orders_total_price'], 2), number_format($buffer['orders_total_shipping'], 2), number_format($buffer['orders_total_tax'], 2), (($buffer['orders_total_discount'] > 0)?'-':'').number_format($buffer['orders_total_discount'], 2), number_format($buffer['orders_total_price'], 2), $order_cancel_url, $buffer['orders_hash']);

			//we save the store info
			$store_id = $buffer['store_id'];
			$store_email = $buffer['store_email'];
			$store_email_title = $buffer['store_email_title'];

			//we add the email we want to send to
			$emails[] = $buffer['orders_email'];

			$first = false;
			}

		$product_email .= ((!empty($product_email))?"\r\n":'').$buffer['order_amount'].' x '.$buffer['product_name'];
		}

	//if we have a subscription with data then get and send the email
	if ($has_subscription === true) {
		$message_replace_with[11] = $product_email;

		//get the subscription email message to be send
		$query = "SELECT
								email_id
								, email_subject
								, email_message
							FROM
								email
							WHERE
								store_id=".(int)$store_id."
								AND email_type='sub'";
		$result = mysql_query($query) or die(mysql_error());
		$buffer = mysql_fetch_assoc($result);
		if (!empty($buffer['email_id'])) {
			//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
			$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');

			//Custom Tags message: [store_name] [firstname] [lastname] [address] [zip] [city] [state] [country] [phone] [note] [order_id] [products] [amount] [shipping_amount] [tax_amount] [discount_amount] [total_amount]
			$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[address]', '[zip]', '[city]', '[state]', '[country]', '[phone]', '[note]', '[order_id]', '[products]', '[amount]', '[shipping_amount]', '[tax_amount]', '[discount_amount]', '[total_amount]', '[order_cancel_url]', '[order_key]');

			$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
			$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

			foreach($emails AS $email) {
				mail($email, $subject, $message, "From: {$store_email_title} <{$store_email}>\r\n");
				}
			}
		}
	}

/**
 * For a given order we return all the affiliates and the amount to payed for
 * each one of them
 *
 * @param int $order_id
 * @return array
 */
function get_affiliate_amounts($order_id) {
	$affs = array();
	$cnt = 0;

	$query = 'SELECT m.Username, op.order_payment_amount FROM order_payment op INNER JOIN members m ON m.ID=op.receiver_id WHERE op.orders_id='.(int)$order_id.' ORDER BY op.order_payment_order';
	$result = mysql_query($query) or die(mysql_error());
	while ($buffer = mysql_fetch_assoc($result)) {

		$affs[$cnt]['name'] = $buffer['Username'];
		$affs[$cnt]['amount'] = $buffer['order_payment_amount'];
		++$cnt;
		}

	return $affs;
	}

/**
 * Returns info for all the affiliates
 *
 * @param int $store_id
 * @param string $affiliate
 * @return array
 */
function get_affiliate_info($store_id, $affiliate) {

	global $Global;

	$store_id = (int)$store_id;

	$affiliates = array();

	if (empty($affiliate)) {
		return $affiliates;
		}

	//check if the store allows affiliate payments
	$query = 'SELECT store_id, member_id FROM store WHERE store_id='.$store_id.' AND store_affiliate_payout="Y" LIMIT 1';
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	if (empty($buffer['store_id'])) {
		return $affiliates;
		}
		
	$store_owner = $buffer['member_id'];

	$tiercnt = 5;
	$member = $affiliate;
	for($i=0;$i < $tiercnt;++$i) {
		$query = 'SELECT m.*, up.program_id, up.user_status FROM members m LEFT JOIN user_program up ON m.ID=up.ID WHERE m.Username="'.mysql_escape_string($member).'"';
		$result = mysql_query($query) or die(mysql_error());
		$first = true;
		$internal_cnt = 0;
		
		while($buffer = mysql_fetch_assoc($result)) {

			if ($first === true) {
				$member = $buffer['sponsorid'];
				$affiliates[$i+1]['id'] = $buffer['ID'];
				$affiliates[$i+1]['amount'] = 0;
				$affiliates[$i+1]['programs'] = array();
				$internal_cnt = 0;
				$first = false;
				}
			if (!empty($buffer['program_id'])) {
				$affiliates[$i+1]['programs'][$internal_cnt]['id'] = $buffer['program_id'];
				$affiliates[$i+1]['programs'][$internal_cnt]['status'] = $buffer['user_status'];
				}
			}

		//if we don't have a sponsor or this is the admin then break
		if (empty($member) || $member == $Global['administrator']) {
			break 1;
			}
		}

	return $affiliates;
	}

/**
 * For a given order id we return all the payments
 *
 * @param int $order_id
 * @return array
 */
function get_order_payments($order_id) {
	}

/**
 * Adds order payments for the given order, products
 * and affiliates
 *
 * @param int $store_id
 * @param int $order_id
 * @param int $total_pay_amount
 * @param array $product_ids
 * @param array $product_amounts
 * @param array $affiliates
 * @return int		The id of the inserted order
 */
function add_payments($store_id, $order_id, $total_pay_amount, $product_ids, $product_amounts, $affiliates, $admin_collects_all = false) {

	global $Global;

	//check if the store supports affiliate payouts
	$query = 'SELECT store_affiliate_payout, store_admin_accept_all, store_payment_keep_period, member_id FROM store WHERE store_id='.(int)$store_id.' LIMIT 1';
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);
	
	$admin_amount = $total_pay_amount;

	$owner = empty($buffer['member_id']) ? 1 : $buffer['member_id'];

	//insert the store admin payment
	mysql_query('INSERT INTO order_payment SET receiver_id='.$owner.', orders_id='.(int)$order_id.', order_payment_processor="", order_payment_amount="'.$admin_amount.'", order_payment_pending=0') or die(mysql_error());
	return mysql_insert_id();
	}

function get_state_name($state, $region) {

	if (!empty($region)) {
		return $region;
		}

	//get the full name of the state
	$query = 'SELECT state_name FROM state WHERE state_id='.(int)$state;
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	return $buffer['state_name'];
	}

/**
 * For a given abbriviation it returns the full name of a coutry
 *
 * @param string $abr
 * @return string
 */
function get_country_name($abr) {

	$query = 'SELECT printable_name FROM country WHERE iso="'.mysql_escape_string($abr).'"';
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	return $buffer['printable_name'];
	}

/**
 * For a given payment id we return the it's member id
 * or if we don't have one assigned we return the store owner id
 *
 * @param int $payment_id
 * @return int
 */
function get_member_id_from_payment($payment_id) {
	$query = 'SELECT s.member_id AS owner_id, op.receiver_id FROM order_payment op INNER JOIN orders o ON o.orders_id=op.orders_id INNER JOIN store s ON s.store_id=o.store_id WHERE order_payment_id='.(int)$payment_id.' LIMIT 1';
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	if (empty($buffer['receiver_id'])) {
		return empty($buffer['owner_id']) ? 1 : $buffer['owner_id'];
		}
	else {
		return $buffer['receiver_id'];
		}
	}

/**
 * For a given store id the function returns the thank you page with the redirect link
 *
 * @param int $store_id
 * @return string
 */
function get_thank_you_page($order_id) {
	$query = 'SELECT it.template, s.redirect_link, o.* FROM orders o INNER JOIN store s ON s.store_id=o.store_id LEFT JOIN invoices_templates it ON s.store_id=it.store_id WHERE (it.template_type=16 OR it.template_type IS NULL) AND o.orders_id='.(int)$order_id;
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	$redir = '';
	if (!empty($buffer['redirect_link'])) {
		@session_start();

		$inv_data = array();
		$inv_data['firstname'] = $buffer['orders_firstname'];
		$inv_data['lastname'] = $buffer['orders_lastname'];
		$inv_data['address'] = $buffer['orders_address'];
		$inv_data['address2'] = $buffer['orders_address2'];
		$inv_data['city'] = $buffer['orders_city'];
		$inv_data['zip'] = $buffer['orders_zip'];
		$inv_data['country'] = get_country_name($buffer['orders_country']);
		$inv_data['phone'] = $buffer['orders_phone'];
		$inv_data['email'] = $buffer['orders_email'];
		$inv_data['region'] = get_state_name($buffer['orders_state'], $buffer['orders_region']);
		$inv_data['ship_firstname'] = $buffer['orders_ship_firstname'];
		$inv_data['ship_lastname'] = $buffer['orders_ship_lastname'];
		$inv_data['ship_address'] = $buffer['orders_ship_address'];
		$inv_data['ship_address2'] = $buffer['orders_ship_address2'];
		$inv_data['ship_city'] = $buffer['orders_ship_city'];
		$inv_data['ship_zip'] = $buffer['orders_ship_zip'];
		$inv_data['ship_country'] = get_country_name($buffer['orders_ship_country']);
		$inv_data['ship_region'] = get_state_name($buffer['orders_ship_state'], $buffer['orders_ship_region']);

		$_SESSION['send_vars'] = $inv_data;
		$_SESSION['send_url'] = $buffer['redirect_link'];
		$redir = '<br />You will be redirected in 2 seconds
			<META http-equiv="refresh" content="2;URL=./Inc/redirected.php">';
		}

	

	return $buffer['template'].$redir;
	}

/**
 * Sends an email with an info about the made order to the user
 * who made the order. It's used for paid payments only
 *
 * @param int $order_id				The id of the order we want to send info for
 * @param string $email_type	The type of email we want to send info
 */
function send_email_complete_payment($order_id, $email_type) {
	$query = "SELECT
							o.*
							, p.*
							, op.*
						FROM
							orders o
							INNER JOIN order_link op
								USING(orders_id)
							INNER JOIN product p
								USING(product_id)
						WHERE
							o.orders_id=".(int)$order_id;
	}

/**
 * Marks a payment as payed and send the appropriate e-mails
 * Return true if this was the last payment
 *
 * @param int $payment_id			The order payment id
 * @param int $processor			The processor the payment was made with
 * @return bool
 */
function mark_payment_payed($payment_id, $processor) {

	global $Global, $Language;

	//check to see if we the admin collects everything for this store
	$query = 'SELECT
							s.store_id
							, s.store_admin_accept_all
							, o.orders_id
							, op.order_payment_amount
						FROM
							store s
							INNER JOIN orders o
								ON s.store_id=o.store_id
							INNER JOIN order_payment op
								ON o.orders_id=op.orders_id
						WHERE
							order_payment_id='.(int)$payment_id.'
						LIMIT 1';
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	if (empty($buffer['orders_id'])) {
		return false;
		}

	//mark the payment as payed
	if ($buffer['store_admin_accept_all'] == 'N') {
		$query = 'UPDATE order_payment SET order_payment_processor="'.mysql_escape_string($processor).'", order_payment_paid="Y", order_payment_paid_date=now(), order_payment_processed="Y" WHERE order_payment_id='.(int)$payment_id;
		}
	else {
		$query = 'UPDATE order_payment SET order_payment_processor="'.mysql_escape_string($processor).'", order_payment_paid="Y", order_payment_paid_date=now(), order_payment_processed="Y" WHERE orders_id='.(int)$buffer['orders_id'];
		}
	mysql_query($query) or die(mysql_error());

	//if this was the last payment then send out the emails
	$last_payment = false;
	$query = 'SELECT op1.order_payment_id FROM order_payment op INNER JOIN order_payment op1 ON op.orders_id=op1.orders_id WHERE op.order_payment_id='.(int)$payment_id.' AND op1.order_payment_paid="N" LIMIT 1';
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);
	$orders_key = '';
	$product_email = '';

	if (empty($buffer['order_payment_id'])) {
		$last_payment = true;
		$query = 'SELECT 
								s.country_iso
								, o.orders_ship_country
								, s.store_email
								, s.store_email_title
								, s.store_name
								, ol.product_weight
								, gh.giftcard_hash_md5
								, dh.dl_hash_md5
								, ol.product_id
								, ol.product_name
								, ol.product_download_nr
								, ol.order_amount
								, o.*
							FROM
								order_payment op
								INNER JOIN orders o
									ON o.orders_id=op.orders_id
								INNER JOIN order_link ol
									ON ol.orders_id=o.orders_id
								INNER JOIN store s
									ON s.store_id=o.store_id
								LEFT JOIN dl_hash dh
									ON ol.order_link_id=dh.order_link_id
								LEFT JOIN giftcard_hash gh
									ON ol.order_link_id=gh.order_link_id
								WHERE
									op.order_payment_id='.(int)$payment_id;
		$result = mysql_query($query) or die(mysql_error());
		$row = mysql_fetch_assoc($result);

		if (!empty($row['orders_id'])) {

			$orders_id = $row['orders_id'];

			//check to see if we have any shippable/giftcard items
			$download_email = '';
			$download_exist = false;

			$giftcard_email = '';
			$giftcard_exist = false;

			$shippable = false;

			$first = true;

			$inv_data = array();

			do {

				if ($first === true) {

					$inv_data = $row;

					if ($row['orders_ship_country'] == $row['country_iso']) {
						$ship_type = 'D';
						}
					else {
						$ship_type = 'I';
						}

					$orders_key = $row['orders_hash'];

					$Global['store_email'] = $row['store_email'];
					$Global['store_email_title'] = $row['store_email_title'];
					$inv_data['store_id'] = $row['store_id'];
					$inv_data['orders_email'] = $row['orders_email'];
					$inv_data['orders_status'] = $row['orders_status'];
					$inv_data['store_name'] = $row['store_name'];
					$inv_data['client_ship_first_name'] = $row['orders_ship_firstname'];
					$inv_data['client_ship_last_name'] = $row['orders_ship_lastname'];

					$first = false;
					}

				$store_id = $row['store_id'];

				if (!empty($row['giftcard_type'])) {

					$giftcard_email .= ((!empty($giftcard_email))?"\r\n":'').$row['giftcard_hash_md5'].' - '.$row['product_name'].' :: '.$Language['checkout']['giftcard_cash'];
					$giftcard_exist = true;
					}

				if ($row['product_download_nr'] > 0) {

					$download_email .= ((!empty($download_email))?"\r\n":'').$row['dl_hash_md5'].' - '.$row['product_name'];
					$download_exist = true;
					}

				$product_email .= ((!empty($product_email))?"\r\n":'').$row['order_amount'].' x '.$row['product_name'];

				if ($row['product_download_nr'] == 0 && $row['product_weight'] > 0) {

					$shippable = true;
					}
				}
			while ($row = mysql_fetch_assoc($result));
			}
		else {

			//if there is no such order
			return;
			}

		//if this is a subscription payment
		$is_subscription_payment = false;
		if ($inv_data['orders_status'] == 'F' && $inv_data['orders_subscription'] == 'Y' && $inv_data['orders_subscription_active'] == 'Y') {
			$is_subscription_payment = true;
			}

		if ($shippable === true) {

			//if the order is already finished then include the orders give script
			if ($inv_data['orders_status'] == 'F') {

				//include the commission give away file
				$GLOBALS['orders_id'] = (int)$orders_id;
				

				if (!defined('IPN_PROCESS')) {
					define('IPN_PROCESS', true);
					}
				//include the give away file for the order
				include $Global['path'].'Ipn/Give/Orders.give.php';
				}
			else {

				//else update the status to paid
				$sql = 'UPDATE orders SET orders_status="PA", orders_paid_date="'.time().'" WHERE orders_id='.(int)$orders_id.' LIMIT 1';
				mysql_query($sql);
				}
			}
		else {

			$sql = 'UPDATE orders SET orders_status="F", orders_final_date="'.time().'" WHERE orders_id='.(int)$orders_id.' LIMIT 1';
			mysql_query($sql);

			//include the commission give away file
			$GLOBALS['orders_id'] = (int)$orders_id;

			if (!defined('IPN_PROCESS')) {
				define('IPN_PROCESS', true);
				}
			//include the give away file for the order
			include $Global['path'].'Ipn/Give/Orders.give.php';
			}

		//if this is a finilized order and it's a subscription then send the emails increase the number of download times
		if ($inv_data['orders_subscription'] == 'Y' && $inv_data['orders_subscription_active'] == 'Y') {
			send_subscription_emails($orders_id);

			//mark the next order subscription period
			mark_next_subscription_order($orders_id);

			//increase the download times
			$query = "UPDATE
									order_link
								SET
									product_download_nr=product_download_nr+product_download_add
								WHERE
									orders_id=".(int)$orders_id;
			mysql_query($query) or die(mysql_error());
			}

		//if the previous state of the order is Paid then skip sending the download cause they should already be sent
		if ($inv_data['orders_status'] == 'PA') {

			return;
			}

		//mark all downloads and giftcard hashes enabled
		$sql = 'UPDATE dl_hash, order_link SET dl_hash.dl_hash_status="E" WHERE dl_hash.order_link_id=order_link.order_link_id AND order_link.orders_id='.(int)$orders_id;
		mysql_query($sql) or die(mysql_error());
		$sql = 'UPDATE giftcard_hash, order_link SET giftcard_hash.giftcard_hash_status="E" WHERE giftcard_hash.order_link_id=order_link.order_link_id AND order_link.orders_id='.(int)$orders_id;
		mysql_query($sql) or die(mysql_error());

		//determine the type of email that should be sent for the
		$email_type = "";
		if ($processor != 'LP' && $processor != 'AN') {
			if ($shippable === false) {
				if ($ship_type == 'D') $email_type = ", 'paed'";
				else $email_type = ", 'paei'";
				}
			else {
				if ($ship_type == 'D') $email_type = ", 'pased'";
				else $email_type = ", 'pasei'";
				}
			$email_type .= ", 'ae'";
			}

		$pay_type = $Language['checkout']['order_paid'];

		//if there is a subscription add that in the email
		$subscription_email = $Language['checkout']['na'];

		/**
		 * Send out the giftcard/download emails
		 */

		$total_amount = $inv_data['orders_total_price']+$inv_data['orders_total_price']-($inv_data['orders_total_shipping']+$inv_data['orders_total_tax']);

		$result = mysql_query("SELECT email_type, email_subject, email_message FROM email WHERE store_id={$inv_data['store_id']} && email_type IN ('non_existing'".($download_exist === true ? ", 'dle'" : "").($giftcard_exist === true ? ", 'gce'" : "").$email_type.")");

		while ($buffer = mysql_fetch_assoc($result))
			{

			$message = '';
			$subject = '';
			//Download email
			if ($buffer['email_type'] == 'dle') {
				//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
				$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
				$subject_replace_with = array($inv_data['store_name'], $orders_id, $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name']);

				//Custom Tags message: [store_name] [firstname] [lastname] [order_id] [download_hash] [download_url]
				$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[order_id]', '[download_hash]', '[download_url]');
				$message_replace_with = array($inv_data['store_name'], $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name'], $orders_id, $download_email, $Global['webpage_url_ssl'].'download.php');

				$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
				$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

				}
			elseif ($buffer['email_type'] == 'gce') {
				//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
				$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
				$subject_replace_with = array($inv_data['store_name'], $orders_id, $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name']);

				//Custom Tags message: [store_name] [firstname] [lastname] [order_id] [giftcard_hash] [giftcard_url]
				$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[order_id]', '[giftcard_hash]', '[giftcard_url]');
				$message_replace_with = array($inv_data['store_name'], $inv_data['client_ship_first_name'], $inv_data['client_ship_last_name'], $orders_id, $giftcard_email, $Global['webpage_url_ssl'].'giftcard.php');

				$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
				$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

				}
			elseif ($buffer['email_type'] == 'paed' || $buffer['email_type'] == 'paei') {
				//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
				$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
				$subject_replace_with = array($inv_data['store_name'], $orders_id, $inv_data['orders_firstname'], $inv_data['orders_lastname']);

				//Custom Tags message: [store_name] [firstname] [lastname] [address] [zip] [city] [state] [country] [phone] [email] [note] [order_id] [products] [amount] [shipping_amount] [tax_amount] [discount_amount] [total_amount]
				$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[address]', '[zip]', '[city]', '[state]', '[country]', '[phone]', '[note]', '[order_id]', '[products]', '[amount]', '[shipping_amount]', '[tax_amount]', '[discount_amount]', '[total_amount]', '[email]');
				$message_replace_with = array($inv_data['store_name'], $inv_data['orders_firstname'], $inv_data['orders_lastname'], $inv_data['orders_address'].((!empty($inv_data['orders_address2']))?"\r\n".$inv_data['orders_address2']:''), $inv_data['orders_zip'], $inv_data['orders_city'], get_state_name($inv_data['orders_state'], $inv_data['orders_region']), get_country_name($inv_data['orders_country']), ((!empty($inv_data['orders_phone']))?$inv_data['orders_phone']:$Language['checkout']['na']), $subscription_email, $inv_data['orders_id'], $product_email, number_format($inv_data['orders_total_price'], 2), number_format($inv_data['orders_total_shipping'], 2), number_format($inv_data['orders_total_tax'], 2), (($inv_data['orders_total_discount'] > 0)?'-':'').number_format($inv_data['orders_total_discount'], 2), number_format($inv_data['orders_total_price'], 2), $inv_data['orders_email']);

				$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
				$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

				//$email = $_POST['email'];
				}
			//Paid order email confirmation (require shipping)
			elseif ($buffer['email_type'] == 'pased' || $buffer['email_type'] == 'pasei') {
				//Custom Tags subject: [store_name] [order_id] [firstname] [lastname]
				$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]');
				$subject_replace_with = array($inv_data['store_name'], $orders_id, $inv_data['orders_firstname'], $inv_data['orders_lastname']);

				//Custom Tags message: [store_name] [firstname] [lastname] [address] [zip] [city] [state] [country] [phone] [email] [ship_firstname] [ship_lastname] [ship_address] [ship_zip] [ship_city] [ship_state] [ship_country] [note] [order_id] [products] [amount] [shipping_amount] [tax_amount] [discount_amount] [total_amount] [courier]
				$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[address]', '[zip]', '[city]', '[state]', '[country]', '[phone]', '[ship_firstname]', '[ship_lastname]', '[ship_address]', '[ship_zip]', '[ship_city]', '[ship_state]', '[ship_country]', '[note]', '[order_id]', '[products]', '[amount]', '[shipping_amount]', '[tax_amount]', '[discount_amount]', '[total_amount]', '[courier]', '[email]');
				$message_replace_with = array($inv_data['store_name'], $inv_data['orders_firstname'], $inv_data['orders_lastname'], $inv_data['orders_address'].((!empty($inv_data['orders_address2']))?"\r\n".$inv_data['orders_address2']:''), $inv_data['orders_zip'], $inv_data['orders_city'], get_state_name($inv_data['orders_state'], $inv_data['orders_region']), get_country_name($inv_data['orders_country']), ((!empty($inv_data['orders_phone']))?$inv_data['orders_phone']:$Language['checkout']['na']), $inv_data['orders_ship_firstname'], $inv_data['orders_ship_lastname'], $inv_data['orders_ship_address'].((!empty($inv_data['orders_ship_address2']))?"\r\n".$inv_data['orders_ship_address2']:''), $inv_data['orders_ship_zip'], $inv_data['orders_ship_city'], get_state_name($inv_data['orders_ship_state'], $inv_data['orders_ship_region']), get_country_name($inv_data['orders_ship_country']), $subscription_email, $inv_data['orders_id'], $product_email, number_format($inv_data['orders_total_price'], 2), number_format($inv_data['orders_total_shipping'], 2), number_format($inv_data['orders_total_tax'], 2), (($inv_data['orders_total_discount'] > 0)?'-':'').number_format($inv_data['orders_total_discount'], 2), number_format($inv_data['orders_total_price'], 2), $inv_data['ship_name'].' - '.(($ship_type == 'D')?$Language['checkout']['domestic']:$Language['checkout']['international']), $inv_data['orders_email']);

				$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
				$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

				//$email = $_POST['email'];
				}
			//Admin confirmation email
			elseif ($buffer['email_type'] == 'ae') {
				//Custom Tags subject: [store_name] [order_id] [firstname] [lastname] [status]
				$subject_replace = array('[store_name]', '[order_id]', '[firstname]', '[lastname]', '[status]');
				$subject_replace_with = array($inv_data['store_name'], $orders_id, $inv_data['orders_firstname'], $inv_data['orders_lastname'], $pay_type);

				//Custom Tags message: [store_name] [firstname] [lastname] [address] [zip] [city] [state] [country] [phone] [email] [ship_firstname] [ship_lastname] [ship_address] [ship_zip] [ship_city] [ship_state] [ship_country] [note] [order_id] [products] [amount] [shipping_amount] [tax_amount] [discount_amount] [total_amount] [courier] [status]
				$message_replace = array('[store_name]', '[firstname]', '[lastname]', '[address]', '[zip]', '[city]', '[state]', '[country]', '[phone]', '[ship_firstname]', '[ship_lastname]', '[ship_address]', '[ship_zip]', '[ship_city]', '[ship_state]', '[ship_country]', '[note]', '[order_id]', '[products]', '[amount]', '[shipping_amount]', '[tax_amount]', '[discount_amount]', '[total_amount]', '[courier]', '[email]', '[status]');
				$message_replace_with = array($inv_data['store_name'], $inv_data['orders_firstname'], $inv_data['orders_lastname'], $inv_data['orders_address'].((!empty($inv_data['orders_address2']))?"\r\n".$inv_data['orders_address2']:''), $inv_data['orders_zip'], $inv_data['orders_city'], get_state_name($inv_data['orders_state'], $inv_data['orders_region']), get_country_name($inv_data['orders_country']), ((!empty($inv_data['orders_phone']))?$inv_data['orders_phone']:$Language['checkout']['na']), $inv_data['orders_ship_firstname'], $inv_data['orders_ship_lastname'], $inv_data['orders_ship_address'].((!empty($inv_data['orders_ship_address2']))?"\r\n".$inv_data['orders_ship_address2']:''), $inv_data['orders_ship_zip'], $inv_data['orders_ship_city'], get_state_name($inv_data['orders_ship_state'], $inv_data['orders_ship_region']), get_country_name($inv_data['orders_ship_country']), $subscription_email, $inv_data['orders_id'], $product_email, number_format($inv_data['orders_total_price'], 2), number_format($inv_data['orders_total_shipping'], 2), number_format($inv_data['orders_total_tax'], 2), (($inv_data['orders_total_discount'] > 0)?'-':'').number_format($inv_data['orders_total_discount'], 2), number_format($inv_data['orders_total_price'], 2), $inv_data['ship_name'].' - '.(($ship_type == 'D')?$Language['checkout']['domestic']:$Language['checkout']['international']), $inv_data['orders_email'], $pay_type);

				$subject = str_replace($subject_replace, $subject_replace_with, $buffer['email_subject']);
				$message = str_replace($message_replace, $message_replace_with, $buffer['email_message']);

				//$email = $_POST['email'];
				}

			if (!empty($message) && !empty($subject)) {

				mail($inv_data['orders_email'], $subject, $message, "From: {$Global['store_email_title']} <{$Global['store_email']}>\r\n");
				}
			}
		}
	else {

		//if this is not the last payment the mark the order as not completed
		$sql = 'UPDATE orders, order_payment SET orders.orders_status="NC" WHERE orders.orders_id=order_payment.orders_id AND order_payment.order_payment_id='.(int)$payment_id;
		mysql_query($sql) or die(mysql_error());
		}
	return $last_payment;
	}