<?php
//---------------------------------------------------------------
//Made by: Nikolay Kolev
//Firm: Kaizen
//Date: 22th January 2010
//Last Modified: 24th January 2010
//----------------------------------------------------------------

include_once $Global['path'].'/admin/Lib/Invoice.inc.php';

/**
 * For a given order if it has a subscription set the next payment date
 * and add a record for the payed payment for the current month
 *
 * @param int $order_id			The order we want to set subscription periods for
 */
function mark_next_subscription_order($order_id) {

	$timestamp = time();

	$query = "SELECT
							orders_id
							, orders_total_subscription_period
							, orders_subscription_next_pay
						FROM
							orders
						WHERE
							orders_id=".(int)$order_id."
							AND orders_subscription='Y'
							AND orders_subscription_active='Y'";
	$result = mysql_query($query) or die(mysql_error());
	$buffer = mysql_fetch_assoc($result);

	//if this order has an active subscription
	if (!empty($buffer['orders_id'])) {

		//insert the payment record for the current period
		$query = "INSERT INTO
								orders_subscription
							SET
								orders_id=".$buffer['orders_id']."
								, orders_subscription_date_paid=".$timestamp;
		mysql_query($query) or die(mysql_error());

		//update the next payment date
		if (empty($buffer['orders_subscription_next_pay']) || $buffer['orders_subscription_next_pay'] < $timestamp) {
			$next_period_start = $timestamp;
			}
		else {
			$next_period_start = $buffer['orders_subscription_next_pay'];
			}
		$query = "UPDATE
								orders
							SET
								orders_subscription_next_pay=".($next_period_start + (int)$buffer['orders_total_subscription_period']*86400)."
							WHERE
								orders_id=".$buffer['orders_id'];
		mysql_query($query) or die(mysql_error());
		}
	}


/**
 * For a given order tries to remove subscription
 * If it's authorize or linkpoint initiates a cancel order
 *
 * @param int $order_id			The order we want to unscribe from
 * @return mixed						True is it was successfull, the error message otherwise
 */
function unscribe_order($order_id) {

	global $Global;

	//get the order info and the payment processor for it
	$query = "SELECT
							o.orders_id
							, o.orders_subscription
							, o.orders_subscription_active
							, op.order_payment_processor
							, op.receiver_id
							, s.member_id
						FROM
							orders o
							INNER JOIN order_payment op
								USING(orders_id)
							LEFT JOIN store s
								USING(store_id)
						WHERE
							o.orders_id=".(int)$order_id;
	$result = mysql_query($query);
	$buffer = mysql_fetch_assoc($result);
	if (empty($buffer['orders_id'])) {
		return 'Invalid order';
		}
	elseif ($buffer['orders_subscription'] == 'N') {
		return 'This order does not have a subscription';
		}
	elseif ($buffer['orders_subscription_active'] == 'N') {
		return 'The subscription for this order is already canceled';
		}
	elseif ($buffer['order_payment_processor'] != 'AN' && $buffer['order_payment_processor'] != 'LP') {
		return 'You can cancel only orders made with Authorize.net and Linkpoint payment processors';
		}
	$order_id = $buffer['orders_id'];
	$receiver_id = $buffer['receiver_id'];
	$member_id = (!empty($buffer['member_id']) ? $buffer['member_id']:1);

	//if the payment processor is authorize or linkpoint unscribe from these
	if ($buffer['order_payment_processor'] == 'AN') {

		//get the authorize subscription id
		$query = "SELECT
								authorize_history_id
								, subscription_id
							FROM
								authorize_history
							WHERE
								invoice_md5='s".$order_id."'
							LIMIT 1";
		$result = mysql_query($query);
		$buffer = mysql_fetch_assoc($result);

		//do we have a record to cancel
		if (!empty($buffer['authorize_history_id'])) {

			define('IPN_PROCESS', true);
			include_once $Global['path'].'/Ipn/Lib/Authorize.class.php';

			//get the credentials for the member for authorize
			$credentials = get_processor_credentials($receiver_id, 'AN');

			//cancel the subscription
			$auth = new authorize_arb($credentials[0], $credentials[1], $Global['test_mode']);
			$reply = $auth->interpret_answer($auth->create_cancel($buffer['subscription_id'], 's'.$order_id));

			//if there is an error return it
			if ($reply === false || strtolower($reply['result_code']) != 'ok') {
				$Error_msg = '';
				foreach ($reply['message_code'] as $key => $value) {
					$Error_msg .= '<br />Error '.$value.': '.$reply['message_text'][$key];
					}
				return $Error_msg;
				}
			}
		}
	elseif ($buffer['order_payment_processor'] == 'LP') {
		//get the authorize subscription id
		$query = "SELECT
								linkpoint_history_id
								, subscription_id
							FROM
								linkpoint_history
							WHERE
								invoice_md5='s".$order_id."'
							LIMIT 1";
		$result = mysql_query($query);
		$buffer = mysql_fetch_assoc($result);

		//do we have a record to cancel
		if (!empty($buffer['linkpoint_history_id'])) {

			define('IPN_PROCESS', true);
			include_once $Global['path'].'/Ipn/Lib/Linkpoint.class.php';

			//get the credentials for the member for authorize
			$credentials = get_processor_credentials($receiver_id, 'LP');

			$lp_path = $Global['linkpoint_path'].floor(($member_id / 1000)).'/'.$member_id.'.pem';

			$Global['lp_store'] = $credentials[0];
			$Global['lp_certificate'] = ((file_exists($lp_path))?$lp_path:false);

			//cancel the subscription
			$linkpoint = new linkpoint($Global['lp_store'], $Global['lp_certificate'], $Global['test_mode']);
			$response = $linkpoint->create_cancel($Global['cc_prefix'].'-'.$buffer['linkpoint_history_id']);
			$linkpoint_relay = $linkpoint->interpret_answer($response);

			$Error_msg = '';
			if (empty($linkpoint_relay['result_code']) || strtolower($linkpoint_relay['result_code']) != 'approved') {
				if (!empty($linkpoint_relay['error'])) {
					$Error_msg = 'Error: '.$linkpoint_relay['error'];
					}
				else {
					$Error_msg = 'The transaction timed out or got interrupted by an error. Please try again in a few minutes.';
					}
				}

			//if there is an error return it
			if (!empty($Error_msg)) {
				return $Error_msg;
				}
			}
		}

	$query = "UPDATE
							orders
						SET
							orders_subscription_active='N'
						WHERE
							orders_id=".$order_id;
	mysql_query($query) or die(mysql_error());
	return true;
	}