<?php

/**
 * For a given number of seconds we return an array with readble time values:
 * array('months' => <months>, 'weeks' => <weeks>, 'days' => <days>, 'hours' => <hours>, 'minutes' => <minutes>)
 *
 * @param int $seconds		The secords we need to convert
 * @return array					The readable array values
 */
function split_time_readable($seconds) {
	//holds all the time values
	$arr = array();

	//calculate months
	$months = floor($seconds/2592000);
	$arr['months'] = $months;
	$seconds = $seconds%2592000;

	//calculate weeks
	$weeks = floor($seconds/604800);
	$arr['weeks'] = $weeks;
	$seconds = $seconds%604800;

	//calculate days
	$days = floor($seconds/86400);
	$arr['days'] = $days;
	$seconds = $seconds%86400;

	//calculate hours
	$hours = floor($seconds/3600);
	$arr['hours'] = $hours;
	$seconds = $seconds%3600;

	//calculate minutes
	$minutes = floor($seconds/60);
	$arr['minutes'] = $minutes;

	return $arr;
	}

/**
 * For a given number of seconds we return a readable time format:
 * x Months, x Weeks, x Days, x Hours, x Minutes
 *
 * @param int $seconds		The secords we need to convert
 * @return string					The converted seconds into a friendly format
 */
function readable_time($seconds) {

	$readable_arr = split_time_readable($seconds);

	//holds all the time values
	$str_arr = array();

	//calculate months
	if ($readable_arr['months'] > 0) {
		$str_arr[] = $readable_arr['months'].' months';
		}

	//calculate weeks
	if ($readable_arr['weeks'] > 0) {
		$str_arr[] = $readable_arr['weeks'].' weeks';
		}

	//calculate days
	if ($readable_arr['days'] > 0) {
		$str_arr[] = $readable_arr['days'].' days';
		}

	//calculate hours
	if ($readable_arr['hours'] > 0) {
		$str_arr[] = $readable_arr['hours'].' hours';
		}

	//calculate minutes
	if ($readable_arr['minutes'] > 0) {
		$str_arr[] = $readable_arr['minutes'].' minutes';
		}

	return implode(', ', $str_arr);
	}