<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
// COMMENTED OUT - FOR HTML EMAILS
//include './../../Inc/cuteeditor_files/include_CuteEditor.php';
include './../Lib/Pagination.function.php';
include './../Lib/TimeFormatting.function.php';
include './../Lib/Ar.functions.php';
include './../Inc/Login.inc.php';
//include_once './../Lib/phpmailer/class.phpmailer.php';

$pageName = 'New AR Email';

if ($_GET['email'] != '') $pageName = 'Edit AR Email';

$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

///*
if ($loggedUser->checkPermisson('AUTORESPONDER') === false) {
	$errorMessage = 'You are not allowed to access this page.';
	require_once('./../Inc/error.php');
	exit();
	}

//if we don't have an auto responder set then go to the list
if (empty($_SESSION['ar_id'])) {
	header('location: Ar_list.php');
	exit;
	}
//*/
//set the ar email data array to no values
$ar = array('id'=>'', 'subject'=>'', 'text'=>'', 'email_type'=>1, 'timeout'=>array('months'=>0, 'weeks'=>0, 'days'=>0, 'hours'=>0, 'minutes'=>0));

$email_types = array(1=>'Normal', 2=>'Confirmation E-mail');

//if we edit an auto responder get it's data
if (isset($_GET['email']) && ctype_digit((string)$_GET['email'])) {
	//get the auto responder data
	$selectFields = 'ar_master_email_id AS id, ar_master_id, ar_master_email_subject AS subject, ar_master_email_text AS text, ar_master_email_timeout AS timeout, ar_master_email_type AS email_type';
	$mainTable = 'ar_master_email';
	$where = [
		'ar_master_email_id' => ['=', $_GET['email']]
	];
	$limit = 1;
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
	$buffer = $result[0];
	
	$selectFields = 'ar_master_id, ar_master_name';
	$mainTable = 'ar_master';
	$joinConditions = []; // No joins needed for this query
	$where = [
		'ar_master_id' => ['=', $buffer['ar_master_id']]
	];
	$groupBy = null;
	$orderBy = null;
	$limit = 1;
	$show_debug = 1;

	$resultr = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);
	$bufferr = $resultr[0];

	$ar_master_name = $bufferr['ar_master_name'];	

	// JS ADDING NEW VARS TO SHOW PREVIOUSLY SAVED TIMEOUT DAYS ON EDIT SCREEN	
    $secondsInAMinute = 60;
    $secondsInAnHour = 60 * $secondsInAMinute;
    $secondsInADay = 24 * $secondsInAnHour;

    // Extract days
    $days = floor($buffer['timeout'] / $secondsInADay);
	$timeout = $days;
	// END EDIT	
	
	if (!empty($buffer['id'])) {
		$buffer['timeout'] = split_time_readable($buffer['timeout']);
		$ar = $buffer;
	}
}

$error = '';

//if the user submited the form
if (!empty($_POST)) {

	//validate the user input
	if (empty($_POST['subject'])) {
		$error = 'Please input a subject';
		}
	elseif (empty($_POST['text'])) {
		$error = 'Please input a text for the email';
		}
	elseif (empty($_POST['email_type']) || !in_array($_POST['email_type'], array_keys($email_types))) {
		$error = 'Please select an email type';
		}
/*		
	elseif (!isset($_POST['timeout']['months']) || !isset($_POST['timeout']['weeks']) || !isset($_POST['timeout']['days']) || !isset($_POST['timeout']['hours']) || !isset($_POST['timeout']['minutes'])) {
		$error = 'Invalid timeout values';
		}
	*/	
	elseif (!ctype_digit((string)$_POST['timeout']['days'])) {
		$error = 'Timeout values should contain only integer values';
		}
	elseif ($_POST['email_type'] == 2) {
		//check if we already have a subscribe email
		$selectFields = 'ar_master_email_id';
		$mainTable = 'ar_master_email';
		$where = [
			'ar_master_email_type' => ['=', 2],
			'ar_master_email_id' => ['!=', $ar['id']]
		];
		$limit = 1;
		$show_debug = 1;

		$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
		$buffer = $result[0];
		
		if (!empty($buffer['ar_master_email_id'])) {
// FORCED TO COMMENT NEXT LINE FOR NOW, AS IT CURRENTLY DOES NOT DISTINGUISH BETWEEN ARs, MEANING IT SHOWS THE ERROR WHEN SETTING UP ANY ADDITIONAL AR WITH A SINGLE CONFIRMATION EMAIL
			//$error = 'You already have a subscribe e-mail added.';
			}
		elseif (strpos($_POST['text'], '[unsubscribe_url]') !== false || strpos($_POST['subject'], '[unsubscribe_url]') !== false) {
			$error = 'You cannot use the [unsubscribe_url] tag in Confirmation E-mails.';
			}
		}
	elseif ($_POST['email_type'] == 1) {
		//if we have a normal e-mail check if we used the confirm link inside the body
		if (strpos($_POST['text'], '[confirm_link]') !== false || strpos($_POST['subject'], '[confirm_link]') !== false) {
			$error = 'You can use the confirm link tag in a normal e-mail message. This tag is only allowed in subscribe e-mails.';
			}
		}

	//if there is no error save the changes
	if (empty($error)) {

		//calculate the seconds
		if ($_POST['email_type'] == 1) {
			$seconds = $_POST['timeout']['months']*2592000 + 604800*$_POST['timeout']['weeks'] + 86400*$_POST['timeout']['days'] + 3600*$_POST['timeout']['hours'] + 60*$_POST['timeout']['minutes'];
			}
		else {
			//if it's a subscribe e-mail then no delay
			$seconds = 0;
			}
			
		$timeout = $_POST['timeout']['days'];
		
		// MAKING SURE ONLY UTF-8 CHARS ARE ALLOWED!
		$subject = mb_convert_encoding($_POST['subject'], 'UTF-8', 'UTF-8');
		$text = mb_convert_encoding($_POST['text'], 'UTF-8', 'UTF-8');
		
		$ar_master_id = (int)$_SESSION['ar_id'];
		$email_type = (int)$_POST['email_type'];
		$seconds = $seconds; // Assuming $seconds is already defined and sanitized

		$data = [
			'ar_master_email_subject' => $subject,
			'ar_master_email_text' => $text,
			'ar_master_id' => $ar_master_id,
			'ar_master_email_type' => $email_type,
			'ar_master_email_timeout' => $seconds
		];

		//check if it's an update or insert
		if (!empty($ar['id'])) {
			$table = 'ar_master_email';
			$where = [
				'ar_master_email_id' => ['=', $ar['id']]
			];
			$limit = 1; // Typically, updating a single row by ID
			$show_debug = 1;
			$live = 1; // Assuming execution of the query is desired

			update($table, $data, [], $where, $live, $limit, $show_debug);
			
			$_POST['id'] = $ar['id'];
	} else {
			$insert = true;
			$table = 'ar_master_email';
			$live = 1; // Assuming execution of the query is desired
			$show_debug = 1;

			$res = insert($table, $data, $live, $show_debug);			
			
			$_GET['email'] = $res['last_insert_id'];
			
			// JS ADDING IN AR_LINK FIX Nov 2017!!
			// WE KNOW INSERT IS ALREADY TRUE HERE...
			$selectFields = 'ar_master_email_id AS id, ar_master_email_timeout AS timeout';
			$mainTable = 'ar_master_email';
			$where = ['1']; // Since the query uses WHERE 1, indicating no specific conditions, this can be empty or omitted.
			$orderBy = 'ar_master_email_id DESC';
			$limit = 1; // Fetching the last record
			$show_debug = 1; // To show debug information as per your requirements

			// Execute the select query
			$resultid = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
			$bufferid = $resultid[0];
			
			
			//echo "<br/><br/>";
			//print_r($bufferid);
			//echo "<br/><br/>";
			$ar_master_email_id = $bufferid['id'];
			$timeout = $bufferid['timeout'];
			//echo 'timeout ';
			//echo $timeout;
			//echo "<br/><br/>";
			
			$selectFields = 'arl.*, arm.*';
			$mainTable = ['table' => 'ar_leads', 'as' => 'arl'];
			$joinConditions = [
				[
					'table' => 'ar_member_email',
					'as' => 'arm',
					'condition' => 'arl.ID = arm.ar_member_master_id'
				]
			];
			$where = [
				'arl.ar_leads_status' => ['=', 1],
				'arm.ar_master_email_id' => ['=', $ar_master_email_id]
			];
			$orderBy = null; // Assuming no specific order required
			$limit = 0; // Assuming you want to fetch all matching records, set 0 or null for no limit
			$show_debug = 1; // To show debug information

			// Execute the select query to fetch results
			$result2 = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);

			// Assuming $results is an array of associative arrays, each representing a row
			foreach ($result2 as $buffer2) {
				//print_r($buffer2);
				//echo "<br/><br/>";
				
				$link_date = strtotime($buffer2['stdate']) + $timeout;
				//echo ' link date: ';
				//echo $link_date;
				//exit;
				$ar_leads_id = $buffer2['ar_leads_id'];
				$ar_member_master_id = $buffer2['ar_member_master_id'];
				$ar_member_email_id = $buffer2['ar_member_email_id'];
			
				$data = [
					'ar_leads_id' => $ar_leads_id,
					'ar_member_master_id' => $ar_member_master_id,
					'ar_member_email_id' => $ar_member_email_id,
					'ar_link_date' => $link_date
				];

				$table = 'ar_link';
				$live = 1; // Assuming execution of the query is desired
				$show_debug = 1;
				insert($table, $data, $live, $show_debug);
			}
			// END JS AR LINK FIX
	}

		$error = 'The auto responder email was saved.';
// send email to admin if he wants to test it
				/*if($_REQUEST['subaction']){
					$sender_email=$Global['admin_email'];
					
							//get the member info
		$member_info = mysql_fetch_array(mysql_query("select * from members where ID=1"));

		//create the tags array
//		print_r($member_info);
$md5 = md5(microtime().rand(0, 1000));
		 $member_info['ar_leads_firstname']=$member_info['First_Name'] ;
			//$member_info['ar_leads_email'] = $Global['admin_email'];
			$member_info['phone'] = $member_info['cellphone'];
			$member_info['unsubscribe_url'] = '<a href="'.$Global['webpage_url'].'unsubscribe_ar.php?hash='.$buffer['ar_leads_md5'].'">'.$Global['unsubscribe_link_text'].'</a>';
		$member_info['website'] = '<a href="'.$Global['webpage_url'].'">'.$Global['webpage_url'].'</a>';
		$member_info['member_website'] = '<a href="'.$Global['webpage_url'].'?id='.$member_info['Username'].'">'.$Global['webpage_url'].'?id='.$member_info['Username'].'</a>';
		$member_info['subscribe_link'] = '<a href="'.$Global['webpage_url'].'join.php?lead='.$md5.'">'.$Global['webpage_url'].'join.php?lead='.$md5.'</a>';

				//create the confirm link
				$member_info['confirm_link'] = '<a href="'.$Global['webpage_url'].'confirm_ar.php?hash='.$md5.'">'.$Global['webpage_url'].'confirm_ar.php?hash='.$md5.'</a>';

		//				$subject = $_POST['subject'];
	//		$message = stripslashes($_POST['text']);
			$email= $_REQUEST['preview'];

		//	mail($email, $subject, $message, "From: $sender_email");
			
				//create the email
				$mail = new PHPMailer();
				$mail->IsSendmail();
				$mail->SetFrom($member_info['email'], $member_info['First_Name'].' '.$member_info['Last_Name']);
				$mail->AddReplyTo($email, 'Administrator');

				$mail->AddAddress($email);

				$mail->Subject  = replace_ar_tags(stripslashes($_POST['subject']), create_ar_data($member_info, $ar_tags), extract_ar_tags($ar_tags));

				$mail->MsgHTML(replace_ar_tags(stripslashes($_POST['text']), create_ar_data($member_info, $ar_tags), extract_ar_tags($ar_tags)));
				$mail->WordWrap = 50;
					$mail->Send();
					$error = 'The auto responder email was saved. The test email was successfully sent!';
				}*/
		
		}

	$ar = $_POST;
	$ar['id'] = $_GET['email'];
	}


include './../Inc/Header.inc.php';
?>
<style>
table, th, td {
    border: 0px;
    padding: 0px;
	text-align:center;
	border-top: none !important;
}
</style>
<div class="col-md-6 col-md-offset-3" style="text-align:center">
<h1><?php echo $ar_master_name; ?></h1>
<h2><?php echo (!empty($ar['id']) ? 'Edit':'New'); ?> Email Follow Up</h2>

	<a class="btn btn-info btn-sm" href="Ar_emails_list.php"><i class="fa fa-angle-double-left" aria-hidden="true" style="color:white"></i>&nbsp; Back To List</a><br />&nbsp;

	<?php if (!empty($error)) { ?>
	<br /><span class="error"><?php echo $error; ?></span><br />&nbsp;
	<?php } ?>

	<form method="post" action="Ar_emails_edit.php?email=<?php echo $ar['id']; ?>" accept-charset="utf-8">
<div class="table-responsive">
<table class="col-md-5 table">
			<tr>
				<td>
					<input type="text" placeholder="Subject" name="subject" class="form-control" value="<?php echo $ar['subject']; ?>" /></td>
			</tr>
			<tr>
				<td>

					<textarea name="text" placeholder="Message" class="form-control" cols="100%" rows="30"><?php echo stripslashes($ar['text']); ?></textarea>
			
					  <?php
/* 
//FOR HTML EMAILS
            $editor=new CuteEditor();
            $editor->ID="text";
            $editor->Text=stripslashes($ar['text']);
            $editor->EditorBodyStyle="font:normal 12px arial;";
            $editor->EditorWysiwygModeCss="php.css";
            $editor->Draw();
            $editor=null;
            
            //use $_POST["Editor1"]to retrieve the data
*/
        ?>


	</td>
			</tr>
					</table>
					</div>
<div class="form-group">					
<div class="table-responsive">
<table class="col-md-5 table">					
<tr>			
			<th style="width:30%; margin-top:10px;">Email Type:</th>
				<td>
					<select class="form-control" name="email_type">
						<?php foreach($email_types AS $etype_key=>$etype_val) { ?>
						<option value="<?php echo $etype_key ?>" <?php echo ($etype_key == $ar['email_type'] ? 'selected="selected"':''); ?>><?php echo $etype_val ?></option>
						<?php } ?>
					</select>

				</td>
			</tr>
			<tr>
				<th>Status Type:</th>
				<td>					
					
					<select class="form-control" name="active_in">
							<option value="0">Any Status</option>					
						<?php
						//Select all programs
						$where = ['AND' => ['program_approved' => 'Y']];
						if (isset($Global['program_restrict']) && $Global['program_restrict'] != '') {
							$where['AND']['program_id'] = ['NOT IN', $Global['program_restrict']];
						}

						$orderBy = 'program_up_pay ASC';
						$programs = select('program_id, program_name', 'program', [], $where, null, null, $orderBy, 0, 1);

						$program_info = '<option value="-1">Select a program</option>';
						if ($program_id == 0) {
							$program_info .= '<option value="0" selected>All Programs</option>';
						} else {
							$program_info .= '<option value="0">All Programs</option>';
						}

						if (is_array($programs)) {
							foreach ($programs as $buffer) {
								$selected = ($program_id == $buffer['program_id']) ? ' selected' : '';
								$program_info .= '<option value="'.$buffer['program_id'].'"'.$selected.'>'.htmlentities($buffer['program_name']).'</option>';
							}
						}						 
						?>

					</select>					
					
				</td>
			</tr>
			<tr>
				<th>Timeout Days:</th>
				<td>
				<!--
					<input type="text" class="form-control" name="timeout[months]" style="width:40px;" value="<?php echo $ar['timeout']['months']; ?>" /> Months <br />
					<input type="text" class="form-control" name="timeout[weeks]" style="width:40px;" value="<?php echo $ar['timeout']['weeks']; ?>" /> Weeks <br />
					-->
<!--
					<input type="text" class="form-control" name="timeout[days]" value="<?php echo $ar['timeout']['days']; ?>" /> 
		-->
					<input type="text" class="form-control" name="timeout[days]" value="<?php echo $timeout; ?>" /> 		

					<!--
					<input type="text" name="timeout[hours]" style="width:40px;" value="<?php echo $ar['timeout']['hours']; ?>" /> Hours <br />
					<input type="text" name="timeout[minutes]" style="width:40px;" value="<?php echo $ar['timeout']['minutes']; ?>" /> Minutes
					-->
				</td>
			</tr>
			
			<!--
				<tr>
	<th>
	Send Test Email To:
	</th> 
	<td><input type="text" class="form-control" name="preview" value="<?php echo $Global['admin_email'] ?>" /></td>
</tr>
	-->						
			<tr><td>&nbsp;</td></tr>
																
			<tr>
				<td colspan="2"><input type="submit" class="btn btn-success" value="Save" /></td>
			</tr>
			<tr>
			<!--
				<td colspan="2"><input type="submit" class="btn btn-success" name="subaction" value="Save & Send Test Email" /></td>
			-->	
			</tr>
		</table>
		</div>
		</div>
	
	</form>
</div>


<div class="col-md-3" style="text-align:left; line-height: 2.5em;">
 <p>&nbsp;</p> <p>&nbsp;</p> <p>&nbsp;</p><p>&nbsp;</p>
					<strong>Tags You May Use:</strong> <br />
					<?php
						foreach ($ar_tags AS $tag) {
							echo $tag['tag'].' - '.$tag['desc'].'<br />';
							}
					?>
					</div>

<div class="clearfix"></div>
<?php include './../Inc/Footer.inc.php'; ?>