<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Lib/Pagination.function.php';
include './../Lib/TimeFormatting.function.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('AUTORESPONDER') === false) {
	$errorMessage = 'You are not allowed to access this page.';
	require_once('./../Inc/error.php');
	exit();
}
	
$pageName = 'Autoresponder Emails';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';	

//get the auto responder
if (isset ($_GET['ar']) && ctype_digit((string)$_GET['ar'])) {
	$responder = (int)$_GET['ar'];
} elseif (!empty($_SESSION['ar_id'])) {
	$responder = (int)$_SESSION['ar_id'];
} else {
	header('location: Ar_list.php');
	exit;
}

$email_types = array(1=>'Normal', 2=>'Confirmation E-mail');

//get the info for this auto responder
$selectFields = 'ar_master_id, ar_master_name';
$mainTable = 'ar_master';
$joinConditions = []; // No joins needed for this query
$where = [
    'ar_master_id' => ['=', $responder]
];
$groupBy = null;
$orderBy = null;
$limit = 1;
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, $limit, $show_debug);
$buffer = $result[0];

$ar_master_name = $buffer['ar_master_name'];

if (empty($buffer['ar_master_id'])) {
	header('location: Ar_list.php');
	exit;
}
$_SESSION['ar_id'] = $responder;

$error = '';

//set the message if we are back from message delete
if (isset ($_GET['deleted']) && $_GET['deleted'] == 'yes') {
	$error = 'The e-mail was successfully deleted.';
}

include './../Inc/Header.inc.php';
echo '<h1>Emails for Autoresponder "'.$ar_master_name.'"</h1>';
?>
<style>
table, th, td {
    border: 1px solid #eeeeee;
}

th, td {
    padding: 10px;
	text-align:center;
}
</style>
<div class="col-md-8 col-md-offset-2" style="text-align:center"> 

<?php if (!empty($error)) { ?>
<div class="error"><?php echo $error; ?></div>
<?php } ?>

<a href="Ar_list.php" class="btn btn-info btn-sm"><i class="fa fa-angle-double-left" aria-hidden="true" style="color:white"></i>
	&nbsp; Back To Autoresponders</a><br />&nbsp;

<div class="table-responsive">
<table class="col-md-8 table">
<tr>
<th>ID</th>
<th>Subject</th>
<th>Timeout</th>
<th>E-mail Type</th>
<th>Actions</th>
</tr>

<?php

//get the count of the emails for the auto responder
$selectFields = 'COUNT(ar_master_email_id) AS cnt';
$mainTable = 'ar_master_email';
$where = [
    'ar_master_id' => ['=', $responder]
];
$limit = 0;
$show_debug = 1;

$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
$buffer = $result[0];


//paging params
$results_per_page = 25;
$total_pages = ceil($buffer['cnt']/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

//the styling of the results table
$nr = 1;
$color[0] = 'FFFFFF';
$color[1] = 'A3FFA3'; // LIGHT GREEN
$color[1] = 'eeeeee';

//get the email drips	
$selectFields = 'ar_master_email_id, ar_master_email_subject, ar_master_email_timeout AS timeout, ar_master_email_type';
$mainTable = 'ar_master_email';

$where = [
    'ar_master_id' => ['=', $responder]
];

$orderBy = 'ar_master_email_timeout ASC, ar_master_email_type DESC';

$offset = ($page - 1) * $results_per_page;
$limit = [
    'offset' => $offset,
    'count' => $results_per_page
];
$show_debug = 1;

$email_id = 0;

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
foreach ($result as $buffer) {
	
	$email_id++;
// JS ADDING NEW VARS TO SHOW PREVIOUSLY SAVED TIMEOUT DAYS ON EDIT SCREEN	
	
    $secondsInAMinute = 60;
    $secondsInAnHour = 60 * $secondsInAMinute;
    $secondsInADay = 24 * $secondsInAnHour;

    // Extract days
    $days = floor($buffer['timeout'] / $secondsInADay);
	$timeout = $days;
// END EDIT		
?>
<tr bgcolor="<?php echo (($nr % 2 == 0)?$color[0]:$color[1]); ?>">    
<!--
<td align="left"><?php echo $buffer['ar_master_email_id']; ?></td>
-->
<td align="left"><?php echo $email_id ?></td>
	<td><?php echo $buffer['ar_master_email_subject']; ?></td>
	<!--
	<td><?php echo readable_time($buffer['ar_master_email_timeout']); ?>&nbsp;</td>
	-->
	<td>Day <?php echo $timeout; ?></td>
	<td><?php echo $email_types[$buffer['ar_master_email_type']]; ?></td>
	<td>
		<a class="btn btn-info btn-xs" href="Ar_emails_edit.php?email=<?php echo $buffer['ar_master_email_id']; ?>"><i class="fa fa-pencil-square-o" style="color:#ffffff" aria-hidden="true" title="Edit Email"></i>&nbsp;Edit</a> &nbsp;
		<a class="btn btn-danger btn-xs" OnClick="return confirm('Are You Sure?');" href="Ar_emails_delete.php?email=<?php echo $buffer['ar_master_email_id']; ?>"><li class="fa fa-trash-o" aria-hidden="true" style="color:white" title="Delete Email"></li>&nbsp;Delete</a>

	</td>
</tr>
<?php
	++$nr;
}
?>

<tr>
	<td colspan="5" style="text-align:right">
	<a class="btn btn-success btn-xs" href="Ar_emails_edit.php">
	<i class="fa fa-send-o" aria-hidden="true" style="color:white"></i>
	&nbsp;
	Add Email Follow Up</a>
	&nbsp;&nbsp;
	<?php echo pagination_links($page, $total_pages, 6, 'Ar_emails_list.php?', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?></td>
</tr>
</table>
</div>
</div>
<div class="clearfix"></div>
<?php include './../Inc/Footer.inc.php'; ?>