<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Lib/Pagination.function.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('AUTORESPONDER') === false) {
	$errorMessage = 'You are not allowed to access this page.';
	require_once('./../Inc/error.php');
	exit;
}

$error = '';
if (isset ($_GET['deleted']) && $_GET['deleted'] == 'yes') {
	$error = 'The auto responder was successfully deleted.';
}
$pageName = 'Manage Autoresponders';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
include './../Inc/Header.inc.php';
 
echo '<h1>Autoresponders</h1>';
?>

<style>
table, th, td {
    border: 1px solid #eeeeee;
}

th, td {
    padding: 10px;
	text-align:center;
}
</style>

<div class="col-md-8 col-md-offset-2" style="text-align:center"> 

<a class="btn btn-info btn-sm" href="Ar_edit.php"><i class="fa fa-mail-forward" aria-hidden="true" style="color:white"></i>
	&nbsp; Add Autoresponder</a><br />&nbsp;

<?php if (!empty($error)) { ?>
<div class="error"><?php echo $error; ?></div>
<?php } ?>


<div class="table-responsive">
<table class="col-md-8 table">
<tr>
<th>ID</td>
<th>Name</td>
<th>Reset</td>
<th>Enabled</td>
<th>Actions</td>
</tr>

<?php

//get the count of the auto responders
$selectFields = 'ar_master_id';
$mainTable = 'ar_master';
$where = ['1']; // JUST GETTING ALL!
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
if ($result !== false) {
	$rows = count($result);
} else {
    $rows = 0;
}


//paging params
$results_per_page = 25;
$total_pages = ceil($rows/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

//the styling of the results table
$nr = 1;
$color[0] = 'FFFFFF';
$color[1] = 'A3FFA3'; // LIGHT GREEN
$color[1] = 'eeeeee';

//get the auto responders
$selectFields = 'ar_master_id, ar_master_name, ar_master_reset_type, ar_master_enabled';
$mainTable = 'ar_master';
$orderBy = 'ar_master_id ASC';
$offset = ($page - 1) * $results_per_page;
$limit = $offset . ', ' . $results_per_page;
$result = select($selectFields, $mainTable, [], ['1'], null, null, $orderBy, $limit, 1);
foreach ($result as $buffer) {
    
?>
<tr style="background-color:<?php echo (($nr % 2 == 0)?$color[0]:$color[1]); ?>">    <td><?php echo $buffer['ar_master_id'] ?></td>
	<td><?php echo $buffer['ar_master_name']; ?></td>
	<td><?php echo ($buffer['ar_master_reset_type'] == '0' ? 'Not available':'Available'); ?></td>
	<td><?php echo ($buffer['ar_master_enabled'] == '0' ? 'No':'Yes'); ?></td>
	<td>
	<!--
		<a class="btn btn-info btn-xs" href="Ar_leads_list.php?reset=1&ar=<?php echo $buffer['ar_master_id']; ?>">View Leads</a> 
	-->
		<a class="btn btn-warning btn-xs" href="Ar_emails_list.php?ar=<?php echo $buffer['ar_master_id']; ?>"><i class="fa fa-binoculars" aria-hidden="true" style="color:white"></i>
	&nbsp;View Emails</a>
		<a class="btn btn-success btn-xs" href="leademailer.php?ar=<?php echo $buffer['ar_master_id']; ?>"><i class="fa fa-send-o" aria-hidden="true" style="color:white"></i>
	&nbsp;Send Emails</a>
		<a class="btn btn-info btn-xs" href="Ar_edit.php?ar=<?php echo $buffer['ar_master_id']; ?>"><i class="fa fa-edit" aria-hidden="true" style="color:white"></i>
	&nbsp;Edit</a>
	<!--
		<a class="btn btn-danger-xs" href="Ar_delete.php?ar=<?php echo $buffer['ar_master_id']; ?>">Delete</a>
	-->
	</td>
</tr>
<?php
	++$nr;
	}
?>

<tr>
	<td colspan="5" style="text-align:right"><?php echo pagination_links($page, $total_pages, 6, 'Ar_list.php?', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?></td>
</tr>
</table>
</div>
</div>
<div class="clearfix"></div> 
<?php include './../Inc/Footer.inc.php'; ?>