<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('ADD_MEMBER') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//$_SESSION['UserID'] = 81; // FOR TESTING ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */


if (!empty($_POST['ID']) && ctype_digit($_POST['ID'])) {
//echo 'got into update!!!!!!!!!!!!!!!!!!';

	$username_exists = false;	
	$email_exists = false;
	$sponsor_exists = false;
	$user_id = (int) $_POST['ID'];	
			
	// Fetch the current user's username
	$selectFields = ['Username', 'sponsorid'];
	$where = ['ID' => ['=', $user_id]];
	$buffer = select($selectFields, 'members', [], $where);
	$current_username = $buffer[0]['Username'];

	if ($_POST['username'] != $current_username) {
		// Check if the new username already exists
		$selectFields = ['COUNT(ID) as total'];
		$where = [
			'Username' => ['=', $_POST['username']],
			'ID' => ['!=', $user_id]
		];
		$buffer = select($selectFields, 'members', [], $where);
		if ($buffer[0]['total'] > 0) $username_exists = true;
	}

	// Check if the sponsor exists
	$selectFields = ['COUNT(ID) as total'];
	$where = ['Username' => ['=', $_POST['sponsorid']]];
	$buffer = select($selectFields, 'members', [], $where);
	if ($buffer[0]['total'] > 0) $sponsor_exists = true;
	

	if (empty($_POST['username'])) {
		$error_msg = 'Please fill out the username field.';
	} elseif ($username_exists === true) {
		$error_msg = 'The username already exists. Please try a different username.';
	}
	
	if ($sponsor_exists === false) {
		$error_msg = 'The sponsor username does not exist. Please try a different sponsor username.';
	} else {
		// Prepare the data for update
		$data = ['sponsorid' => $_POST['sponsorid']];
		$where = ['ID' => ['=', $user_id]];

		// Execute the update query using PHPCPR framework
		$result = update('members', $data, [], $where, 1, 1, 1);

		if (!$result) {
			die("Error updating record"); 
		}
	}

	if (empty($error_msg)) {

		//note that we need to set the const UPDATE to true before any additional includes will run, a security function to protect the file from beeing run by itself.
		define('UPDATE', true);
		
		//Include file that will update any other scripts running together with MLM, this file will allow the customers to use the script side by side with any script. 
		//include './../../Inc/updatemember.inc.php';
		
		//If the username got changed, we update the database tables
		if ($_POST['username'] != $current_username) {	
					
			// Update sponsorid in user_program
			$data = ['sponsorid' => $_POST['username']];
			$where = ['sponsorid' => ['=', $current_username]];
			update('user_program', $data, [], $where, 1, 1, 1);

			// Update unpaid_ref in user_program
			$data = ['unpaid_ref' => $_POST['username']];
			$where = ['unpaid_ref' => ['=', $current_username]];
			update('user_program', $data, [], $where, 1, 1, 1);

			// Update real_sponsorid in user_payment_plan
			$data = ['real_sponsorid' => $_POST['username']];
			$where = ['real_sponsorid' => ['=', $current_username]];
			update('user_payment_plan', $data, [], $where, 1, 1, 1);

			// Update username in payment_plan
			$data = ['username' => $_POST['username']];
			$where = ['username' => ['=', $current_username]];
			update('payment_plan', $data, [], $where, 1, 1, 1);

			// Update payer_username in payment_plan
			$data = ['payer_username' => $_POST['username']];
			$where = ['payer_username' => ['=', $current_username]];
			update('payment_plan', $data, [], $where, 1, 1, 1);

			// Update payer_username in payment_log
			$data = ['payer_username' => $_POST['username']];
			$where = ['payer_username' => ['=', $current_username]];
			update('payment_log', $data, [], $where, 1, 1, 1);
									
			// Update Username in members
			$data = ['Username' => $_POST['username']];
			$where = ['Username' => ['=', $current_username]];
			update('members', $data, [], $where, 1, 1, 1);

			// Update sponsorid in members
			$data = ['sponsorid' => $_POST['username']];
			$where = ['sponsorid' => ['=', $current_username]];
			update('members', $data, [], $where, 1, 1, 1);

			// Update Username in leaderboard
			$data = ['Username' => $_POST['username']];
			$where = ['Username' => ['=', $current_username]];
			update('leaderboard', $data, [], $where, 1, 1, 1);

			// Update Username in leaderboard_earnings
			$data = ['Username' => $_POST['username']];
			$where = ['Username' => ['=', $current_username]];
			update('leaderboard_earnings', $data, [], $where, 1, 1, 1);
			
			// Update Username in leaderboard_earnings
			$data = ['Username' => $_POST['username']];
			$where = ['Username' => ['=', $current_username]];
			update('member_pages', $data, [], $where, 1, 1, 1);			

			// Update log_login_username in member_log
			$data = ['log_login_username' => $_POST['username']];
			$where = ['log_login_username' => ['=', $current_username]];
			update('member_log', $data, [], $where, 1, 1, 1);			
			
			//Include file that will update any other scripts running together with MLM, this file will allow the customers to use the script side by side with any script. 
			//include './Inc/editusername.inc.php';			
			}	
		
		$error_msg = 'The user has been updated!';
		}
	}

include './../Inc/Header.inc.php';
echo '<h1>Change Username or Referring Sponsor</h1>';

//echo 'GET id: '.$_GET['id'];	
//echo ' POST ID: '.$_POST['ID'];	

if (!empty($_GET['id'])) {
	$user_id = (int) $_GET['id'];
	}
else if (!empty($_POST['ID'])) {
	$user_id = (int) $_POST['ID'];
	}

if ($user_id == '')	{
	echo 'no user found!';
	include './../Inc/Footer.inc.php';
	exit;
}	
	
if (empty($error_msg)) {
			
	$selectFields = 'Username, sponsorid';
	$mainTable = 'members';
	$where = ['ID' => ['=', $user_id]];
	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer = $result[0];		
	
	$_POST['sponsorid'] = $buffer['sponsorid'];
	$_POST['username'] = $buffer['Username'];

}
?>
<div style="text-align:center; width="300px;">
<form method="post" action="Edit_user.php" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

<?php  
echo "<input type=\"hidden\" name=\"ID\" value=\"{$user_id}\">";
if (!empty($error_msg)) {
	echo $error_msg;
}
?>
<p>&nbsp;</p>
			Username:		
				<input type="text" class="form-control" onMouseover="this.focus()" size="10" name="username" value="<?php if(isset($_POST['username'])) : echo $_POST['username']; else : echo ''; endif; ?>" id="inputSuccess" placeholder="">

		
		Sponsor:
				<input type="text" class="form-control" onMouseover="this.focus()" size="10" name="sponsorid" value="<?php if(isset($_POST['sponsorid'])) : echo $_POST['sponsorid']; else : echo ''; endif; ?>" id="inputSuccess" placeholder=""> (Note: This value is only used when a new program is setup.)
		<p></p>

<div style="text-align:center">
<p>&nbsp;</p>
<input type="submit" value="Update User Account" id="submit" name="submit" class="btn btn-info btn-default">

<p>&nbsp;</p>
This process must update many tables in the database. Please be patient and do not reload or reclick the submit button!
<p>&nbsp;</p>

</div>		
</div>
<?php
include './../Inc/Footer.inc.php';
?>