<?php
include './../../Sub/Config.inc.php';
include $GLOBALS['path'].'phpcpr.php';
include './../Inc/Login.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit;   
}

if (!empty($_POST['submit']) && (!empty($_POST['ID']) && ctype_digit($_POST['ID'])) && (!empty($_POST['prog']) && ctype_digit($_POST['prog']))) {
    $user_id = (int) $_POST['ID'];
    $program_id = (int) $_POST['prog'];
    $username_exists = false;
    $unpaidref_exists = false;
    $forcedref_exists = false;

    $selectFields = 'program_up';
    $mainTable = 'program';
    $where = ['program_id' => ['=', $program_id]];
    $result = select($selectFields, $mainTable, [], $where);
    $buffer = isset($result[0]) ? $result[0] : null;
    $program_up = $buffer['program_up'];

    $selectFields = 'COUNT(ID) as total';
    $mainTable = 'members';
    $where = ['Username' => ['=', $_POST['sponsorid']]];
    $result = select($selectFields, $mainTable, [], $where);
    $buffer = isset($result[0]) ? $result[0] : null;
    if ($buffer['total'] > 0) $username_exists = true;

    if (!empty($_POST['unpaidref'])) {
        $where = ['Username' => ['=', $_POST['unpaidref']]];
        $result = select($selectFields, $mainTable, [], $where);
        $buffer = isset($result[0]) ? $result[0] : null;
        if ($buffer['total'] > 0) $unpaidref_exists = true;   
    }

    if (!empty($_POST['forcedref'])) {
        $where = ['Username' => ['=', $_POST['forcedref']]];
        $result = select($selectFields, $mainTable, [], $where);
        $buffer = isset($result[0]) ? $result[0] : null;
        if ($buffer['total'] > 0) $forcedref_exists = true;
    }

    if (empty($_POST['sponsorid'])) {
        $error_msg = 'Please fill out the sponsorid field.';
    } elseif ($username_exists === false) {
        $error_msg = 'The sponsorid does not exist. Please try a different username.';
    } elseif (!empty($_POST['unpaidref']) && $unpaidref_exists === false) {
        $error_msg = 'The unpaid ref does not exist. Please try a different username.';
    } elseif (!empty($_POST['forcedref']) && $forcedref_exists === false) {
        $error_msg = 'The forced passup ref does not exist. Please try a different username.';
    } elseif (!ctype_digit($_POST['signid'])) {
        $error_msg = 'The sign id field can only contain an integer value.';
    } elseif (!ctype_digit($_POST['userqualify'])) {
        $error_msg = 'The user qualify field can only contain an integer value.';
    } elseif ((int) $_POST['userqualify'] > $program_up) {
        $error_msg = 'The user qualify field cannot have a higher value than ' . $program_up . '.';
    } elseif (!ctype_digit($_POST['usersignup'])) {
        $error_msg = 'The user signup field can only contain an integer value.';
    }   

    if (empty($error_msg)) {
        $data = [
            'forced_ref' => $_POST['forcedref'],
            'sponsorid' => $_POST['sponsorid'],
            'unpaid_ref' => !empty($_POST['unpaidref']) ? $_POST['unpaidref'] : null,
            'sign_id' => (int) $_POST['signid'],
            'user_qualify_perm' => (int) $_POST['userqualify'],
            'user_signup' => (int) $_POST['usersignup']
        ];
        $where = [
            'ID' => ['=', $user_id],
            'program_id' => ['=', $program_id]
        ];
        update('user_program', $data, [], $where, 1, 1, 1);

        $error_msg = 'The user program information has been updated!';
    }
}

if (!empty($_GET['id'])) {
    $user_id = (int) $_GET['id'];
    $program_id = (int) $_GET['prog'];
} elseif (!empty($_POST['ID'])) {
    $user_id = (int) $_POST['ID'];
    $program_id = (int) $_POST['prog'];
} else {
    header("Location: Finduser.php");
    exit;
}   

include './../Inc/Header.inc.php';

$selectFields = 'program_name';
$mainTable = 'program';
$where = ['program_id' => ['=', $program_id]];
$result = select($selectFields, $mainTable, [], $where);
$buffer = isset($result[0]) ? $result[0] : null;

echo '<h1>Edit Program</h1><h3>'.$buffer['program_name'].'</h3>';

//JS - added user info
//Find all information about the user and display it...

$selectFields = '*';
$mainTable = 'members';
$where = ['ID' => ['=', intval($_GET['id'])]];
$result_user_info = select($selectFields, $mainTable, [], $where);
$buffer_user_info = isset($result_user_info[0]) ? $result_user_info[0] : null;

$user_id = $buffer_user_info['ID'];

echo <<<EOD
<table align="center">
<tr>
<td>
<strong>User Information:</strong> <br />
ID: {$buffer_user_info['ID']}<br />
Username: {$buffer_user_info['Username']} <a href="./memberlogin.php?id={$buffer_user_info['ID']}" target="_blank">Login As User</a><br />
First Name: {$buffer_user_info['First_Name']}<br />
Last Name: {$buffer_user_info['Last_Name']}<br />
Email: {$buffer_user_info['email']}<br />
<!--
    <form name="form" method="post" action="Loginuser.php" target="_blank">        
<input type="hidden" name="login" value="{$buffer['Username']}">      
<input type="hidden" name="completed" value="yes">
<input type="hidden" name="pass" value="{$buffer['Password']}">      
<input type="submit" value="Login As Member" class="input" name="Submit">
</form>
-->
<td>
</tr>
</table>
EOD;

//JS added mysql and login links

$selectFields = '*';
$mainTable = [
    'table' => 'members',
    'as' => 'm'
];
$joinConditions = [
    ['table' => 'user_program', 'as' => 'u', 'condition' => 'm.ID = u.ID'],
    ['table' => 'program', 'as' => 'p', 'condition' => 'u.program_id = p.program_id']
];
$where = [
    'm.ID' => ['=', $user_id],
    'u.program_id' => ['=', $program_id]
];
$result = select($selectFields, $mainTable, $joinConditions, $where);
$buffer = isset($result[0]) ? $result[0] : null;

/*
echo'<a href="memberlogin.php?id='.$buffer['ID'].'&rd=viewpayment.php?program='.$buffer['program_id'].'" target="_blank">Member Earned</a> | 
<a href="memberlogin.php?id='.$buffer['ID'].'&rd=viewdirectpayment.php?program='.$buffer['program_id'].'" target="_blank">Member Received</a> | 
<a href="memberlogin.php?id='.$buffer['ID'].'&rd=program.php?program='.$buffer['program_id'].'" target="_blank">Member Payment (program.php)</a> | 
<a href="Viewplan.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank">Payment Plans</a><br />';
*/

echo <<<EOD2
<!--
<a href="Editplan.php?id={$user_id}&prog={$buffer['program_id']}" target="_blank">Edit Program</a> |
<a href="memberlogin.php?id={$user_id}&rd=viewdownline.php?id={$user_id}&prog={$buffer['program_id']}" target="_blank">View Downline</a> |
<a href="memberlogin.php?id={$user_id}&rd=viewpayment.php?program={$buffer['program_id']}" target="_blank">Earned</a> |
<a href="memberlogin.php?id={$user_id}&rd=viewdirectpayment.php?program={$buffer['program_id']}" target="_blank">Received</a> |
<a href="Viewplan.php?id={$user_id}&prog={$buffer['program_id']}" target="_blank">Pay Plan</a> |
<a href="memberlogin.php?id={$user_id}&rd=program.php?program={$buffer['program_id']}" target="_blank">Pay</a> |
-->
<a href="./Finduser.php?username={$buffer_user_info['Username']}">Return To Find User</a> | 
<a href="Editplan.php?id={$user_id}&prog={$_GET['prog']}" target="_self">Refresh</a>
<br />
<br />
EOD2;

echo 'Please note that if the member has already joined the program, then changing the sponsor id will not<br>change who gets paid. The member will keep paying their old sponsor, unless their pay plans are also updated.<br>

To change who gets paid, edit the current Active <a href="Viewplan.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank">Payment Plan</a><br /><br />';

if (empty($error_msg)) {
    $selectFields = '*';
    $mainTable = 'user_program';
    $where = [
        'ID' => ['=', $user_id],
        'program_id' => ['=', $program_id]
    ];
    $result = select($selectFields, $mainTable, [], $where);
    $buffer = isset($result[0]) ? $result[0] : null;

    $_POST['sponsorid'] = $buffer['sponsorid'];
    $_POST['unpaidref'] = $buffer['unpaid_ref'];
    $_POST['forcedref'] = $buffer['forced_ref'];
    $_POST['signid'] = $buffer['sign_id'];
    $_POST['userqualify'] = $buffer['user_qualify_perm'];
    $_POST['usersignup'] = $buffer['user_signup'];
    $_POST['ID'] = $user_id;
    $_POST['prog'] = $program_id;
}

echo "
<div align=\"center\">
  <center>
  <table WIDTH=\"600\" class=\"sample\" cellpadding=\"0\" cellspacing=\"0\" bordercolor=\"#dddddd\" bgcolor=\"#ffffff\" BACKGROUND=\"\">
<form method=\"post\" action=\"Editplan.php?id=".$_GET['id']."&prog=".$_GET['prog']."\">";

//UPDATE

echo "<input type=\"hidden\" name=\"ID\" value=\"{$_POST['ID']}\"><input type=\"hidden\" name=\"prog\" value=\"{$_POST['prog']}\">";

//END UPDATE

if (!empty($error_msg)) {
    echo "<tr><td  align=\"center\" colspan=\"2\"><br>
            <font face=\"Trebuchet MS\" color=\"FF0000\" size=\"2\">".$error_msg."<br><br></td>
                </tr>";
}
echo "<tr>
<td valign=\"top\" align=\"right\" width=\"40%\">
                Sponsor id:&nbsp;</td>
                <td align=\"left\" width=\"60%\">
            <input class=\"input\"  size=\"25\" name=\"sponsorid\" value=\"".((!empty($_POST['sponsorid']))?$_POST['sponsorid']:'')."\" ><br />
            This is the registered sponsor for the member in this program.<br /><br />
        </td>
            </tr>
            <tr>
<td valign=\"top\"  align=\"right\" width=\"40%\">
                Unpaid Ref:&nbsp;</td>
                <td align=\"left\" width=\"60%\">
            <input class=\"input\"  size=\"25\" name=\"unpaidref\" value=\"".((!empty($_POST['unpaidref']))?$_POST['unpaidref']:'')."\" ><br />
            If this field is filled out, it means that the member was passed up due to his sponsor was unpaid. The unpaid sponsor that passed the member up is the one listed in this field.<br /><br />
        </td>
            </tr>
    <tr>
<td valign=\"top\"  align=\"right\" width=\"40%\">
                Forced Passup Ref:&nbsp;</td>
                <td align=\"left\" width=\"60%\">
            <input class=\"input\"  size=\"25\" name=\"forcedref\" value=\"".((!empty($_POST['forcedref']))?$_POST['forcedref']:'')."\" ><br />
            If this field is filled out, it means that the member was passed up due to his sponsor had to give him the sale. The sponsor that passed the member up is the one listed in this field. This field is NOT used for powerlines pass ups!<br /><br />
        </td>
            </tr>
            <tr>
<td valign=\"top\"  align=\"right\" width=\"40%\">
                Sign id:&nbsp;</td>
                <td align=\"left\" width=\"60%\">
            <input class=\"input\"  size=\"25\" name=\"signid\" value=\"".((isset($_POST['signid']))?$_POST['signid']:'')."\" ><br />

            This is the placement of the member in their sponsor's downline. If the number is the same as any powerline pass up (in the program), then the member is a qualifier for their sponsor. Example: If program is a rev 2-up (passing sales 2 and 4), and this number is 2 or 4, then this member gets passed up.<br /><br />
        </td>
            </tr>
            <tr>

<td valign=\"top\"  align=\"right\" width=\"40%\">
                Free (Giveaway) Qualifiers:&nbsp;</td>
                <td align=\"left\" width=\"60%\">
            <input class=\"input\"  size=\"25\" name=\"userqualify\" value=\"".((isset($_POST['userqualify']))?$_POST['userqualify']:'')."\" ><br />

            This is the number of \"free\" qualifiers that this member is given, so they are required to pass up fewer sales. To make the member fully qualified in this program (and to make sure they do NOT have to pass up ANY sales), this field must be set to the same number as the powerline in the program. Example: If program is a 2-up (or rev 2-up), this number should be 2.<br /><br />
        </td>
            </tr>
            <tr>
<td valign=\"top\"  align=\"right\" width=\"40%\">
                User Signup:&nbsp;</td>
                <td align=\"left\" width=\"60%\">
            <input class=\"input\"  size=\"25\" name=\"usersignup\" value=\"".((isset($_POST['usersignup']))?$_POST['usersignup']:'')."\" ><br />
            This field shows approximately how many people this member has referred. This field MUST BE at least the same number as the powerline in the program if the member is qualified. Example: If program is a 2-up (or rev 2-up), this number should be 2 or higher.<br />
        </td>
            </tr>
            ";
        echo "    <tr><tr align=\"middle\">
                <td colSpan=\"2\">
<br>
                <input class=\"input\" type=\"submit\" value=\"Update\" name=\"submit\">
                </td>
            </tr>
        </table>
            </center>";

include './../Inc/Footer.inc.php';

?>
