<?php
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';

if ($loggedUser->checkPermisson('VIEW_PROGRAM') !== true){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();
}

$pageName = 'Coupon Stats';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';


$error = '';

//if the user submited the form validate the user input
if (!empty($_POST)) {
	if (empty($_POST['separator']) || empty($_POST['wrapper']) || empty($_POST['fetch'])) {
		$error = 'Please fill in all fields';
		}
	elseif ($_POST['separator'] == $_POST['wrapper']) {
		$error = 'The separator and the wrapper values cannot be the same.';
		}
		$separator = $_POST['separator'];
		//$wrapper = str_replace(chr(92),"",$_POST['wrapper']);
		if ($_POST['separator'] == "tab") $separator = chr(15);
		if ($_POST['wrapper'] == "double quote") $wrapper = chr(34);
		if ($_POST['wrapper'] == "none") $wrapper = "";
		$esc = chr(92);
	//if the form is valid send the CSV file
	if (empty($error)) {
		
		// FIRST WE CANCEL ALL COUPONS OF CANCELLED USERS!
		$table = 'coupon';
		$data = ['valid' => 'N'];
		$joinConditions = [
			['table' => 'user_program', 'as' => 'u', 'condition' => 'coupon.ID = u.ID']
		];
		$where = [
			'coupon.ID' => ['>', 0],
			'coupon.valid' => ['=', 'Y'],
			'u.program_id' => ['=', 1],
			'u.user_status' => ['=', 'Cancelled']
		];
		$live = 1;
		$show_debug = 1;

		update($table, $data, $joinConditions, $where, $live, 0, $show_debug);
		

		$member = array();
		$limit = null;

		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Pragma: public");
		header("Content-Type: application/octet-stream");
		header("Content-Transfer-Encoding: binary");
		header("Accept-Ranges: bytes");
		header('Content-Disposition: attachment; filename="coupons_'.date('m-d-Y').'.csv"');
		header("Connection: close");

		echo 'organizationcustomeridentifier'.$separator.'programcustomeridentifier'.$separator.'membercustomeridentifier'.$separator.'memberStatus'.$separator.'firstName'.$separator.'lastName'.$separator.'postalCode'."\r\n";

		if ($_POST['fetch'] == 'all') {

			$selectFields = 'c.*, u.user_status, memb.ID, memb.Username, memb.First_Name, memb.Last_Name, link.address, link.address2, link.city, link.state, link.zip, link.country, link.ship_address, link.ship_address2, link.ship_city, link.ship_state, link.ship_zip, link.ship_country, memb.email, link.phone';
			$mainTable = ['table' => 'members', 'as' => 'memb'];
			$joinConditions = [
				['table' => 'member_link', 'as' => 'link', 'condition' => 'memb.ID=link.ID', 'type' => 'LEFT'],
				['table' => 'user_program', 'as' => 'u', 'condition' => 'memb.ID=u.ID'],
				['table' => 'coupon', 'as' => 'c', 'condition' => 'memb.ID=c.ID']
			];
			$where = [
				'c.ID' => ['!=', 0],
				'c.valid' => ['=', 'N'],				
				'memb.Username' => ['!=', 'DELETED'],
				'u.program_id' => ['=', 1],
				/*'memb.Status' => ['!=', 'Cancelled']*/
			];
			$show_debug = 1;

			$result = select($selectFields, $mainTable, $joinConditions, $where, 'memb.ID', null, null, 0, $show_debug);


 			foreach ($result as $buffer) {
				//only add unique members
				//if (isset ($member[$buffer['ID']])) {
				//	continue 1;
				//	}
				
				//only add unique orders
				//if (isset ($member[$buffer['payment_log_id']])) {
				//	continue 1;
				//	}

				//date("Y-m-d",$buffer['timestamp'])
				$order = date($Global['date_setting'], $buffer['timestamp']);
                    
				if ($buffer['user_status'] == 'Active') {
					$buffer['user_status'] = 'OPEN';
				} else 
				if ($buffer['user_status'] == 'Suspended') {
					$buffer['user_status'] = 'SUSPEND';
				}
				if ($buffer['user_status'] == 'Cancelled') {
					$buffer['user_status'] = 'CLOSED';
				}	
				
				echo $GLOBALS['webpage_name'].$separator. '1' .$separator 

				. (strpos($buffer['couponcode'], $separator) === false ? $buffer['couponcode'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['couponcode']).$wrapper.$separator)

				. (strpos($buffer['user_status'], $separator) === false ? $buffer['user_status'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['user_status']).$wrapper.$separator)

				. (strpos($buffer['First_Name'], $separator) === false ? $buffer['First_Name'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['First_Name']).$wrapper.$separator)

				. (strpos($buffer['Last_Name'], $separator) === false ? $buffer['Last_Name'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['Last_Name']).$wrapper.$separator)

				. (strpos($buffer['ship_zip'], $separator) === false ? $buffer['ship_zip'].$separator:$wrapper.str_replace($wrapper, $esc.$wrapper, $buffer['ship_zip']).$wrapper)."\r\n";

				$member[$buffer['ID']] = true;
				unset($order, $status, $buffer);
				}
			}

		exit;
		}
	}



include './../Inc/Header.inc.php';

echo '<div style="text-align: center;"><center><h1>Download Coupons Redeemed</h1><br>';

//if we have an error display it
if (!empty($error)) {
	echo '<div style="color:red;">'.$error.'</div>';
	}

echo '
<form action="Fetch-coupons.php" method="POST">
<table>
	<tr>
		<td>Separator:</td>
		<td><select name="separator">
			<option value=",">,</option>
			<option value=";">;</option>
			<option value="tab">tab</option>
			</select>
		</td>
	</tr>
	<tr>
		<td>Wrapper:</td>
		<td><select name="wrapper">
			<option selected=selected value="double quote">"</option>
			<option value="none">None</option>
			</select>
		</td>
	</tr>
	<tr>
		<td>Find Coupons Redeemed:</td>
		<td>
<select name="fetch">
<option value="all"'.((!empty($_POST['fetch']) && $_POST['fetch'] =='all')?' selected="selected"':'').'>Coupons</option>
</select>
		</td>
	</tr>
</table>
<input type="submit" name="submit" value="Submit" class="btn btn-primary"/>
</form>
';
?>
<!--
<a href="Fetch-orders-mark-shipped.php">Go To The Mark Orders Shipped Page</a> (Further Action Will Be Required To Mark Orders Shipped)
-->

<?php

if (!empty($_POST['fetch'])) {
	}
	
include './../Inc/Footer.inc.php';
?>