<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include_once './../../phpcpr.php';
include './../Inc/Login.inc.php';
//if ($loggedUser->checkPermisson('FIND_MEMBER') === false) {
	if ($loggedUser->checkPermisson('PAYMENT') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
}

$pageName = 'Status Type Breakdown';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
include './../Inc/Header.inc.php';
$datetime = date("Y-m-d H:i:s");
$cutoff = strtotime("-14 days"); // MADE ORIGINALLY TO SHOW THOSE IN ONE PROGRAM ONLY FOR AT LEAST 2 WEEKS - NOT USING THIS IN GENERAL NOW
$coming_due = strtotime("+5 days");

// REMOVING CUTOFF RESTRICTION HERE!
$cutoff = $datetime;

// Define the select fields and conditions
$selectFields = 'program_id, program_name';
$mainTable = 'program';
$where = [
    'program_approved' => ['=', 'Y'],
    'program_id' => ['>', 0]
];

// Call the select function from your PHPCPR CRUD system
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

$rows = is_array($result) ? count($result) : 0;

if ($rows == 0 && $_GET['p'] == '') { // THERE ARE NO OTHER PROGRAMS, SO DEFAULT TO PROGRAM 1!
	$_GET['p'] = 1;
}

if ($_GET['p'] == '') $_GET['p'] = 'all';

if ($_GET['p'] == 'all') {
	$program_id = '';
} else {
	$program_id = $_GET['p'];
}


if ($_GET['p'] != '') {
	echo '<h1>Show Users By Status & Program</h1>';
	echo '<h4><a href="Finduser-status.php?p='.$program_id.'&status=a">Active</a> | ';
	echo '<a href="Finduser-status.php?p='.$program_id.'&status=comp">Comped</a> | ';	
	echo '<a href="Finduser-status.php?p='.$program_id.'&status=s">Suspended</a> | ';
	echo '<a href="Finduser-status.php?p='.$program_id.'&status=c">Cancelled</a> | ';
	echo '<a href="Finduser-status.php?p='.$program_id.'&status=due">Coming Due</a> | ';	
	echo '<a href="Finduser-status.php?p='.$program_id.'&status=u">Unpaid</a></h4>';	
	//exit;
}

if ($rows > 0) { // WE HAVE MORE THAN ONE PROGRAM, SHOW THEM!
	echo '<h4>';
	//echo '<span style="font-size:20pt">| ';

	foreach ($result as $buffer) {
	echo '<a href="Finduser-status.php?p='.$buffer['program_id'].'&status='.$_GET['status'].'">'.$buffer['program_name'].'</a> | ';
	}
	echo '<a href="Finduser-status.php?p=all&status='.$_GET['status'].'">SHOW ALL PROGRAMS</a></h4>';
}

echo '<p>&nbsp;</p>';

$cull = $_GET['p'];

if ($_GET['p'] != '') {

	if ($_GET['status'] == '') {
		$_GET['status'] = 'a';
	}
	if ($_GET['status'] == 's') { 
		$status = 'Suspended';
		$order_by = "u.date_suspended";
	} else if ($_GET['status'] == 'c') {
		$status = 'Cancelled';
		$order_by = "u.date_cancelled";
	} else if ($_GET['status'] == 'a') {
		$status = 'Active';
		$order_by = "u.started";
	} else if ($_GET['status'] == 'comp') {
		$status = 'Comped';
		$order_by = "u.started";
	} else if ($_GET['status'] == 'u') {
		$status = 'Unpaid';
		$order_by = "u.ID";
	}
	
	if ($_GET['status'] == 'due') {
		$status = 'Active';
		$order_by = "u.expire";		
		//$due_sql = 'AND u.expire <= '.$coming_due;
	} else {
		$due_sql = '';
	}	

	if ($_GET['order'] == 'ASC') {
		$way = "ASC";
	} else {
		$way = "DESC";
	}		
	
	
	if ($_GET['find_unique'] == 'Y') {
		
		echo '<h3>Now Showing Those Most Recently '.$status.' in Program '.$_GET['p'].'</h3><br/>';	
		
		$selectFields = 'DISTINCT u1.ID';
		$mainTable = ['table' => 'user_program', 'as' => 'u1'];
		$joinConditions = [
			[
				'type' => 'LEFT JOIN', // Specify join type
				'table' => 'user_program',
				'as' => 'u2',
				'condition' => 'u1.ID = u2.ID'
			]
		];
		$where = [
			'u1.user_status' => ['IN', ['Active', 'Comped']],
			'u1.program_id' => ['=', $program_id],
			'u1.started' => ['<', '{$cutoff}'],
			'u2.ID' => ['IS', 'NULL'] // Ensuring u2.ID is NULL filters out users active or comped in other programs
		];
		$orderBy = 'u1.ID DESC';
		$limit = 0;
		$show_debug = 1;
			
	} else {
		
		$selectFields = '*';
		$mainTable = ['table' => 'user_program', 'as' => 'u'];
		$joinConditions = [];
		$where = [
			'u.user_status' => ['=', $status]
		];
		
		$order_by_str = $order_by.' '.$way;
		
		$orderBy = $order_by_str.', program_id ASC';
		$limit = 0;
		$show_debug = 1;

		if ($_GET['status'] == 'due') {
			echo '<h3>Now Showing Those Due Within 5 Days</h3><br/>';
			$where['AND']['u.expire'] = ['<=', $coming_due];
		} else if ($_GET['p'] != 'all') { 
			echo '<h3>Now Showing Those '.$status.' in Program '.$_GET['p'].'</h3><br/>';
			$where['AND']['u.program_id'] = ['=', $program_id];
		} else {
			echo '<h3>Now Showing Those '.$status.' (ALL Programs)</h3><br/>';	
		}
	}
	
	if ($_GET['p'] == 'all') {
		// DO NOTHING
	} else {	
		$where['AND']['u.program_id'] = ['=', $program_id];
	}	
	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, $show_debug);

	$rows = is_array($result) ? count($result) : 0;	

	if ($rows == 0) {
	$records = 'No Results';
	} else {
	$records = 'Total Records: ' . $rows;
	}

	echo $records;
	echo '<br/><br/><table style="margin:auto;">';

	foreach ($result as $buffer) {
	echo '<tr><td>';
	echo $buffer['ID'];
	echo '&nbsp;';	
	//print_r($buffer);

	$selectFields = '*';
	$mainTable = 'members';
	$where = [
		'ID' => ['=', $buffer['ID']]
	];
	$show_debug = 1;

	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
	$buffer2 = isset($result2[0]) ? $result2[0] : null;

	echo "<a href='Finduser.php?username=".$buffer2['Username']."' target='_blank'>".$buffer2['Username']."</a>&nbsp;&nbsp;";
	echo "</td><td>";
	
	echo '<a href="Viewplan.php?id='.$buffer2['ID'].'&prog='.$buffer['program_id'].'" target="_blank">Pay Plan</a>&nbsp;&nbsp;';
	echo "</td><td>";	
	
	echo '<a href="Payment-Logs.php?username='.$buffer2['Username'].'&prog='.$_GET['p'].'&searchway=username_who_paid&cc_pending=ALL" target="_blank">Log</a>';
	echo "&nbsp;</td><td>";	

	echo '<a href="mailto:'.$buffer2['email'].'?subject='.$Global['webpage_name'].'%20Follow%20Up%20For%20Username%20'.$buffer2['Username'].'&body=Dear%20'.$buffer2['First_Name'].',%0D%0A%0D%0A

	We hope this email finds you well, and you are getting a lot out of the '.$Global['webpage_name'].' program.%0D%0A%0D%0A

	We have reviewed your user account '.$buffer2['Username'].' (affiliate link '.$Global['webpage_url'].'?id='.$buffer2['Username'].'),%0D%0A%0D%0A

	[ENTER MORE TEXT HERE] %0D%0A%0D%0A
	  
	Sincerely,
	%0D%0A
	Admin">'.$buffer2['email'].'</a>';

	echo '&nbsp;';
	echo $buffer2['cellphone'];
	echo '&nbsp;';

	$start_date = date('Y-m-d', $buffer['started']);
	$exp_date = date('Y-m-d', $buffer['expire']);	
	//$start_date = $buffer2['Signdate'];
	$date_r=substr($buffer2['Signdate'], 0, 10); 
	$date_s=substr($buffer['date_suspended'], 0, 10); 
	$date_c=substr($buffer['date_cancelled'], 0, 10); 
	echo "Registered: ".$date_r;
	echo '&nbsp;';
	if ($_GET['status'] != 'u') echo 'Activated: '.$start_date.'&nbsp;';
	
	echo "Due Date: ".$exp_date.'&nbsp;';	

	if ($_GET['status'] == 's' || $_GET['status'] == 'c') echo "Suspended: ".$date_s.'&nbsp;';
		
	if ($_GET['status'] == 'c') {
		echo "Cancelled: ".$date_c;
		echo '&nbsp;';
		echo 'By ';
		echo $buffer['cancelled_by'];
	}

	echo '</td></tr>';

	} // END WHILE LOOP
	echo '</table>';	
} // END $_GET['p'] != '' 
include './../Inc/Footer.inc.php';
?>