<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('FIND_MEMBER') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
}
$pageName = 'Find Member';
$pageAlign = 'center';
$pageClass = '';
$timestamp = time();
if (isset($_GET['page']) && $_GET['page'] != '') {
	$pagination_page = $_GET['page'] + 0;
} else {
	$pagination_page = -1;
}

include './../Inc/Header.inc.php';
echo '<h1>Find User</h1>'; 
//exit;

//$GLOBALS['debug'] = true;

if (!isset($_POST) && isset($_GET)) $_POST = $_GET;

// Define the list of expected keys
$expectedKeys = [
    'order', 'browse', 'program', 'prog', 'find', 'colname', 'way', 'program', 'username', 'email', 'phone', 'unpaid_ref', 'user_qualify'
];

// If there is POST data, overwrite the initial values with the actual submitted data where available
if (true || $_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($expectedKeys as $key) {
        $values[$key] = $_POST[$key] ?? '';
    }
} 

foreach ($expectedKeys as $key) {
	$values[$key] = $_GET[$key] ?? '';
}

if (isset($_GET['page'])) {
	$_POST = $_SESSION['finduserform'];
	$_REQUEST = $_SESSION['finduserformreq'];	
}
if (!isset($_POST) && (!isset($_GET['username']) || empty($_GET['username']))) {
    if (isset($_GET['browse']) && $_GET['browse'] == 'Y' && isset($_GET['page']) && $_GET['page'] === '') {
		$_SESSION['finduserform'] = '';
		$_SESSION['finduserformreq'] = '';
	}
	
	$_POST = $_SESSION['finduserform'];
	$_REQUEST = $_SESSION['finduserformreq'];
} else {
    if (isset($_GET['username']) && $_GET['username'] != '') {
		$_POST['find'] = $_GET['username'];
		$_POST['colname'] = 1;
		$_REQUEST['find'] = $_GET['username'];
		$_REQUEST['colname'] = 1;
	}
	$_SESSION['finduserform'] = $_POST;
	$_SESSION['finduserformreq'] = $_REQUEST;
}

// Added isset checks
if (isset($_GET['prog']) && !empty($_GET['prog'])) {
    $_REQUEST['prog'] = $_GET['prog'];
	$_REQUEST['program'] = $_GET['prog'];
}
if (isset($_GET['program']) && !empty($_GET['program'])) {
    $_REQUEST['program'] = $_GET['program'];
	$_REQUEST['prog'] = $_GET['program'];
}
if (isset($_GET['order']) && !empty($_GET['order'])) {
    $_REQUEST['order'] = $_GET['order'];
}
if (isset($_GET['pname']) && !empty($_GET['pname'])) {
    $_REQUEST['pname'] = $_GET['pname'];
}
if (isset($_GET['browse']) && !empty($_GET['browse'])) {
    $_REQUEST['browse'] = $_GET['browse'];
}
if (isset($_GET['order']) && $_GET['order'] === '' && isset($_REQUEST['browse']) && $_REQUEST['browse'] == 'Y') {
	$_REQUEST['order'] = 'desc';
	$_GET['order'] = 'desc';
}

// ADDED SHORTEN VARIABLE FUNCTION
if (isset($_POST['way']) && $_POST['way'] == 1) { // DO NOT TRUNCATE RESULTS ON EXACT MATCHES

    function ShortenText2($text) { 
        // Change to the number of characters you want to display 
        $chars2 = 100000; 
        //$text = $text." "; 
        $length = strlen($text);
        $text = substr($text,0,$chars2);  
        //$text = substr($text,0,strrpos($text,' ')); 
		if ($length>$chars2) $text = $text."..."; 
        return $text; 
    } 

    function ShortenText($text) { 
        // Change to the number of characters you want to display 
        $chars = 100; 
        //$text = $text." "; 
        $length = strlen($text);
        $text = substr($text,0,$chars);  
        //$text = substr($text,0,strrpos($text,' ')); 
		if ($length>$chars) $text = $text."..."; 
        return $text; 
    } 

} else { 

    function ShortenText2($text) { 
        // Change to the number of characters you want to display 
        $chars2 = 10; 
        //$text = $text." "; 
        $length = strlen($text);
        $text = substr($text,0,$chars2);  
        //$text = substr($text,0,strrpos($text,' ')); 
		if ($length>$chars2) $text = $text."..."; 
        return $text; 
    } 

    function ShortenText($text) { 
        // Change to the number of characters you want to display 
        $chars = 7; 
        //$text = $text." "; 
        $length = strlen($text);
        $text = substr($text,0,$chars);  
        //$text = substr($text,0,strrpos($text,' ')); 
		if ($length>$chars) $text = $text."..."; 
        return $text; 
    } 

} // END SHORTEN FUNCTIONS

?>
<base target="_blank">

<?php
/*
if ($_GET['browse'] == 'Y' && $_GET['order'] == '') {
	if ($_GET['pname'] == '') $_GET['pname'] = 'ALL PROGRAMS';
	echo '<h1>Browse '.$_GET['pname'].'</h1>';
	echo '<h2><a href="Finduser.php?prog='.$_GET['prog'].'&browse=Y&order=desc&pname='.$_GET['pname'].'">Show Me Latest Members First</a></h2>';
	echo '<h2><a href="Finduser.php?prog='.$_GET['prog'].'&browse=Y&order=asc&pname='.$_GET['pname'].'">Show Me Earliest Members First</a></h2>';
	include './../Inc/Footer.inc.php';
	exit;
}
*/

//unset($_SESSION['browse_program_array']);
//unset($_SESSION['browse_program_array_asc']);
if (!isset($_SESSION['browse_program_array'])) {
    // Define the select fields and the table
    $selectFields = 'program_id, program_name, program_type, giveaway_file';
    $mainTable = 'program';
    
    // Define the WHERE condition
    $where = [
        'program_approved' => 'Y'
    ];

	if (isset($Global['program_restrict']) && $Global['program_restrict'] != '') {
		$where['AND']['program_id'] = ['NOT IN', [$Global['program_restrict']]];
	}
    // Execute the select query using PHPCPR
    $result = select($selectFields, $mainTable, [], $where, null, null, 'program_id ASC', 0, 1);
	
	$_SESSION['browse_program_array'] = '';
	$_SESSION['browse_program_array_asc'] = '';

    foreach ($result as $buffer) {
        $_SESSION['browse_program_array'] .= '<a href="Finduser.php?prog=' . $buffer['program_id'] . '&browse=Y&order=desc&pname=' . $buffer['program_name'] . '">' . $buffer['program_name'] . '</a> <small>|</small> ';
        $_SESSION['browse_program_array_asc'] .= '<a href="Finduser.php?prog=' . $buffer['program_id'] . '&browse=Y&order=asc&pname=' . $buffer['program_name'] . '">' . $buffer['program_name'] . '</a> <small>|</small> ';
		$_SESSION['p'.$buffer['program_id'].'_name'] = $buffer['program_name'];	
		$_SESSION['p'.$buffer['program_id'].'_program_type'] = $buffer['program_type'];		
		$_SESSION['p'.$buffer['program_id'].'_giveaway_file'] = $buffer['giveaway_file'];	
    }
}

echo '<h4><small>BROWSE LATEST</small> ';
echo $_SESSION['browse_program_array'];
echo '<a href="Finduser.php?browse=Y&order=desc">All Programs</a> <small>|</small> ';
echo '<a class="btn btn-primary btn-xs" href="memberlogin.php?id=2&rd=index.php" target="_blank"><span class="fa fa-user"></span> &nbsp;Demo User LOGIN >> GO!</a>';
echo '<br/><small>BROWSE EARLIEST</small> ';
echo $_SESSION['browse_program_array_asc'];
echo '<a href="Finduser.php?browse=Y&order=asc">All Programs</a> <small>|</small> ';
echo '<a class="btn btn-primary btn-xs" href="memberlogin.php?id=1&rd=index.php" target="_blank"><span class="fa fa-user"></span> &nbsp;Admin User LOGIN >> GO!</a>';
//echo '<br/><a class="btn btn-primary btn-xs" href="memberlogin.php?id=7&prd=ads/campaign-stats.php" target="_blank"><span class="fa fa-user"></span> &nbsp;AdCoop User LOGIN >> GO!</a>';
echo '</h4>';
// QQQ FAVORITE USERS LOGIN ACCESS
/*
echo '<a class="btn btn-primary btn-xs" href="memberlogin.php?id=5&rd=advanced_viewer.php" target="_blank"><span class="fa fa-user"></span> &nbsp;fisherman</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="memberlogin.php?id=162&rd=advanced_viewer.php" target="_blank"><span class="fa fa-user"></span> &nbsp;MissMigrou</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="memberlogin.php?id=230&rd=advanced_viewer.php" target="_blank"><span class="fa fa-user"></span> &nbsp;brimee</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="memberlogin.php?id=409&rd=advanced_viewer.php" target="_blank"><span class="fa fa-user"></span> &nbsp;getlivehelp</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="memberlogin.php?id=219&rd=advanced_viewer.php" target="_blank"><span class="fa fa-user"></span> &nbsp;jeff</a>&nbsp;';
echo '<br>';
echo '<a class="btn btn-primary btn-xs" href="/admin/Sub/Finduser.php?username=fisherman" target="_blank"><span class="fa fa-user"></span> &nbsp;fisherman</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="/admin/Sub/Finduser.php?username=MissMigrou" target="_blank"><span class="fa fa-user"></span> &nbsp;MissMigrou</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="/admin/Sub/Finduser.php?username=brimee" target="_blank"><span class="fa fa-user"></span> &nbsp;brimee</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="/admin/Sub/Finduser.php?username=getlivehelp" target="_blank"><span class="fa fa-user"></span> &nbsp;getlivehelp</a>&nbsp;';
echo '<a class="btn btn-primary btn-xs" href="/admin/Sub/Finduser.php?username=jeff" target="_blank"><span class="fa fa-user"></span> &nbsp;jeff</a>&nbsp;';
*/?>

<form method="POST" action="<?php echo $_SERVER['PHP_SELF']; ?>" target="_self">
<div class="table-responsive form-group">
<table class="table" style="margin:auto; width:65%; background-color:#FFFFFF">
<tr><td>
<input type="button"  class="btn btn-danger btn-sm" NAME="blank" VALUE="RESET" SIZE="" onClick="this.form.find.value='';this.form.colname.value=('1');this.form.way.value=('1');this.form.status.value='All';this.form.program.value='0'">
</td><td>
<button id="copyButton" class="btn btn-warning btn-sm">COPY</button>
</td><td>
<input type="button"  class="btn btn-info btn-sm" NAME="blank" VALUE="CLEAR" SIZE="" onClick="this.form.find.value=''">


<!--
</td><td style="vertical-align:middle">
Search for
-->
</td>
<?php
// AUTO SUBMIT SEARCH FOR USERNAME, WHEN PRESENT IN URL
		if (isset($_GET['username']) && $_GET['username'] != '') {
			$username_condition = $_GET['username'];
			$_POST['way'] = 1;
			$_POST['colname'] = 1;
			$_POST['limit'] = 100;
			$_POST['find'] = $_GET['username'];
			//$_POST['submit'] = "SEARCH";
		
?>
<td>

<input type="text" class="form-control" id="find" name="find" value="<?php echo $username_condition;?>" placeholder="Enter value" onmouseover="this.focus();">

</td>

<td>
<select name="way" class="form-control">
<option value="1" <?php if ($true = true) echo 'selected';?>>Exact Match</option>
<option value="2" <?php if (isset($_POST['way']) && $_POST['way'] == '2') echo 'selected';?>>Contains</option>
</select>
</td>
<?php	} else if (isset($_GET['email']) && $_GET['email'] != '') {
			$username_condition = $_GET['email'];
			$_POST['way'] = 1;
			$_POST['colname'] = 4;
			$_POST['limit'] = 100;
			$_POST['find'] = $_GET['email'];
			//$_POST['submit'] = "SEARCH";
?>
<td>
<input type="text" class="form-control" id="find" name="find" value="<?php echo $username_condition;?>" placeholder="Enter value" onMouseover="this.focus()"> 
</td>
<td>
<select name="way" class="form-control">
<option value="1" <?php if ($true = true) echo 'selected';?>>Exact Match</option>
</select>			
</td>			
<?php		
		} else if (isset($_GET['status']) && $_GET['status'] != '') {
			//$username_condition = $_GET['email'];
			$_POST['way'] = $_GET['way'];
			$_POST['colname'] = $_GET['colname'];
			$_POST['limit'] = 100;
			$_POST['find'] = $_GET['find'];
			//$_POST['submit'] = "SEARCH";
?>
<td>
<input type="text" class="form-control" id="find" name="find" value="<?php if (isset($_REQUEST['find'])) echo $_REQUEST['find'];?>" placeholder="Enter value" onMouseover="this.focus()"> 
</td>
<td>
<select name="way" class="form-control">
<option value="1" <?php if (isset($_POST['way']) && $_POST['way'] == '1') echo 'selected';?>>Exact Match</option>
<option value="2" <?php if (isset($_POST['way']) && $_POST['way'] == '2') echo 'selected';?>>Contains</option>
</select>
</td>
<?php  // END AUTO SUBMIT SEARCH FOR USERNAME, WHEN PRESENT IN URL
} else { // SEARCH THE NORMAL WAY 
?>
<td>
<input type="text" class="form-control" id="find" name="find" value="<?php if (isset($_REQUEST['find'])) echo $_REQUEST['find'];?>" placeholder="Enter value" onMouseover="this.focus()"> 
</td>
<td>
<select name="way" class="form-control">
<option value="1" <?php if (isset($_POST['way']) && $_POST['way'] == '1') echo 'selected';?>>Exact Match</option>
<option value="2" <?php if (isset($_POST['way']) && $_POST['way'] == '2') echo 'selected';?>>Contains</option>
</select>
</td>
<?php } // END AUTO SUBMIT SEARCH FOR USERNAME, WHEN PRESENT IN URL
?>
<td style="vertical-align:middle">
in the
</td>
<td>
<select name="colname" class="form-control">
<option value="1" <?php if (isset($_POST['colname']) && $_POST['colname'] == 1) echo 'selected';?>>Username</option>
<option value="2" <?php if (isset($_POST['colname']) && $_POST['colname'] == 2) echo 'selected';?>>First Name</option>
<option value="3" <?php if (isset($_POST['colname']) && $_POST['colname'] == 3) echo 'selected';?>>Last Name</option>
<option value="4" <?php if (isset($_POST['colname']) && $_POST['colname'] == 4) echo 'selected';?>>Email</option>
<option value="5" <?php if (isset($_POST['colname']) && $_POST['colname'] == 5) echo 'selected';?>>Referrer</option>
<!--
<option value="7" <?php if (isset($_POST['colname']) && $_POST['colname'] == 7) echo 'selected';?>>Grace Period</option>

<option value="8" <?php if (isset($_POST['colname']) && $_POST['colname'] == 8) echo 'selected';?>>Safepay Username</option>
-->
<option value="9" <?php if (isset($_POST['colname']) && $_POST['colname'] == 9) echo 'selected';?>>Paypal Email</option>

<!--
<option value="10" <?php if (isset($_POST['colname']) && $_POST['colname'] == 10) echo 'selected';?>>JV Status</option>

<option value="11" <?php if (isset($_POST['colname']) && $_POST['colname'] == 11) echo 'selected';?>>Alertpay Email</option>
-->
<option value="12" <?php if (isset($_POST['colname']) && $_POST['colname'] == 12) echo 'selected';?>>ID</option>
<option value="13" <?php if (isset($_POST['colname']) && $_POST['colname'] == 13) echo 'selected';?>>Join Date</option>
<option value="14" <?php if (isset($_POST['colname']) && $_POST['colname'] == 14) echo 'selected';?>>IP Address</option>

</select>
</td>
<td style="vertical-align:middle">
column.
</td>
</tr>
</table> 
</div>

<!--
Limit to <select name="limit">
<option value="100" <?php if (isset($_POST['limit']) && $_POST['limit'] == '100') echo 'selected';?>>100</option>
<option value="250" <?php if (!isset($_POST['limit']) || isset($_POST['limit']) && $_POST['limit'] == '250') echo 'selected';?>>250</option>
<option value="500" <?php if (isset($_POST['limit']) && $_POST['limit'] == '500') echo 'selected';?>>500</option>
<option value="750" <?php if (isset($_POST['limit']) && $_POST['limit'] == '750') echo 'selected';?>>750</option>
<option value="1000" <?php if (isset($_POST['limit']) && $_POST['limit'] == '1000') echo 'selected';?>>1000</option>
<option value="2000" <?php if (isset($_POST['limit']) && $_POST['limit'] == '2000') echo 'selected';?>>2000</option>
<option value="3000" <?php if (isset($_POST['limit']) && $_POST['limit'] == '3000') echo 'selected';?>>3000</option>
<option value="5000" <?php if (isset($_POST['limit']) && $_POST['limit'] == '5000') echo 'selected';?>>5000</option>
</select> members 
-->


<?php //SELECT ALL PROGRAMS 
// Define the select fields and the table
$selectFields = 'program_id, program_name, program_type, program_setup_type, program_up';
$mainTable = 'program';

// Define the WHERE condition
$where = [
	'program_approved' => 'Y'
];

if (isset($Global['program_restrict']) && $Global['program_restrict'] != '') {
	$where['AND']['program_id'] = ['NOT IN', [$Global['program_restrict']]];
}

// Execute the select query using PHPCPR
$resultp = select($selectFields, $mainTable, [], $where, null, null, 'program_id ASC', 0, 1);

$proginfo_array = array();

$program_info = '<option value="0">All Programs</option>';

foreach ($resultp as $bufferp) {

	$proginfo_array[$bufferp['program_id']]['program_type'] = $bufferp['program_type'];
	$proginfo_array[$bufferp['program_id']]['program_setup_type'] = $bufferp['program_setup_type'];
	$proginfo_array[$bufferp['program_id']]['program_up'] = $bufferp['program_up'];
	if (isset($_POST['program']) && $_POST['program'] == $bufferp['program_id']) $selected = ' selected';
	else $selected = '';
		
	$program_info .= '<option value="'.$bufferp['program_id'].'"'.$selected.'>'.$bufferp['program_name'].'</option>';
}
// SPEED UP SEARCH BY STORING NEEDED INFO FROM PROGRAM TABLE INTO proginfo_array FOR LATER USE
// $proginfo_array[1]['program_type'] now contains the program_type of program 1, 
// $proginfo_array[3]['program_type'] now contains the program_setup_type of program 3, 
// $proginfo_array[8]['program_up'] now contains the program_up of program 8, etc.


$alert = false;

if (isset($_POST['way']) && $_POST['way'] == '2' && $_REQUEST['program'] == '') {
	$_REQUEST['program'] = $Global['default_program'];
	$alert = true;
}
if (isset($_POST['find']) && $_POST['find'] == '' && $alert == true) $alert = false;

if (!isset($_REQUEST['status'])) $_REQUEST['status'] = "All";
?>	


<div class="table-responsive form-group">
<table class="table" style="margin:auto; width:45%; background-color:#FFFFFF">
<tr><td style="text-align:center; vertical-align:middle">

Show 
</td><td><select name="status" class="form-control">
<option value="All" <?php echo (($_REQUEST['status'] == "All")?'selected="selected"':''); ?>>All</option>
<option value="Active" <?php echo (($_REQUEST['status'] == "Active")?'selected="selected"':''); ?>>Active</option>
<option value="Suspended" <?php echo (($_REQUEST['status'] == "Suspended")?'selected="selected"':''); ?>>Suspended</option>
<option value="Cancelled" <?php echo (($_REQUEST['status'] == "Cancelled")?'selected="selected"':''); ?>>Cancelled</option>
<option value="Unpaid" <?php echo (($_REQUEST['status'] == "Unpaid")?'selected="selected"':''); ?>>Unpaid</option>
<option value="Comped" <?php echo (($_REQUEST['status'] == "Comped")?'selected="selected"':''); ?>>Comped</option>

<!--
<option value="TempComp" <?php echo (($_REQUEST['status'] == "TempComp")?'selected="selected"':''); ?>>TempComp</option>
-->
</select>
</td><td style="text-align:center; vertical-align:middle">members in</td><td>
<?php 
echo <<<EOD
<select name="program" class="form-control">
{$program_info}
</select>
EOD;

// WE WILL NOT SEARCH THE PAYMENT PLAN AND PAYMENT LOG TABLES, UNLESS WE NEED TO
$pp = '1';
$pp2 = '';
$upp = '';

	
//if ($_SESSION['debug'])	echo 'program id: '.$program;
?>
</td><td>
<input type="submit" class="btn btn-primary" value="SEARCH">
</form>
</td></tr></table></div>

<?php
if (isset($_REQUEST['find']) || (isset($_GET['browse']) && $_GET['browse'] == 'Y')) {

	$find = $_POST['find'];
	
	switch ($_POST['colname']) {
		case 2:
			$colname = 'First_Name';
			break;
		case 3:
			$colname = 'Last_Name';
			break;
		case 4:
			$colname = 'email';
			break;
		case 5:
			$colname = 'm.sponsorid';
			break;
		case 6:
			$colname = 'grace_expire';
			break;
		case 7:
			$colname = 'cellphone';
			break;
		case 8:
			$colname = 'ml.phone';
			break;
		case 9:
			$colname = 'paypalaccount';
			break;
		case 10:
			$colname = 'Status';
			break;
		case 11:
			$colname = 'alertpay';
			break;
		case 12:
			$colname = 'm.ID';
			break;
		case 13:
			$colname = 'Signdate';
			break;
		case 14:
			$colname = 'ip';
			break;
		default:
			$colname = 'm.Username';
			break;
		}
		
	if ($_POST['way'] == 1 && $colname!='' && $find!='') {
	$search_way = "AND ".$colname."='$find'";
	} else if ($colname!='' && $find!='') { 
	$search_way = "AND $colname LIKE '%$find%'";
	} else {
	$search_way = '';
	}

/*
IDEAS OF FIELDS TO ADD TO SEARCH AND OR DISPLAY
//Status - JV status - was egold
//show ip somewhere?
//cellphone
//phone
//sign id
//URQ
//status
//referrer
//sponsor

  `member_link_id` int(11) NOT NULL AUTO_INCREMENT,
  `ID` int(10) unsigned DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `address2` varchar(255) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `state` varchar(100) DEFAULT NULL,
  `zip` varchar(100) DEFAULT NULL,
  `country` char(2) DEFAULT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `tax_id` varchar(100) DEFAULT NULL,
*/



if (isset($_REQUEST['program'])) $alert = true;

$display_rows = 25;
//$display_rows = $_POST['limit'];
$offset_row = max(0,$display_rows * $pagination_page);
$first_record_shown = $offset_row + 1;
$last_record_shown = $first_record_shown + $display_rows - 1;

// MAIN SEARCH QUERY
// Define the select fields	

$selectFields = 'm.ID as ID, u.user_program_id, u.program_id, u.program_id as exclude_prog_id, m.Username, m.First_Name, m.Last_Name, m.email, m.Status, m.sponsorid as msponsorid, u.sponsorid as usponsorid, u.user_status, u.sign_id, u.user_qualify_perm, u.user_signup, m.Signdate, u.started, u.expire, u.end_program, m.payment_collected_by, m.e4gatewayID';

// Define the main table and join conditions
//$mainTable = 'members as m';
$mainTable = ['table' => 'members', 'as' => 'm'];

$joinConditions = [
	[
		'table' => 'user_program',
		'as' => 'u',
		'condition' => 'm.ID = u.ID'
	]
];
$where = [
	'AND' => ['m.ID' => ['!=', 'NULL']]
	];
	
if (isset($_REQUEST['status']) && $_REQUEST['status'] != 'All' && $_REQUEST['status'] != '') {	
	$bystatus = $_REQUEST['status'];
}
if (isset($_GET['browse']) && $_GET['browse'] == 'Y') {
	$bystatus = '';
	$program = '';
	$search_way = '';
}

if (isset($_GET['browse'], $_REQUEST['program']) && $_GET['browse'] == 'Y' && $_REQUEST['program'] != '') {
	$program = $_REQUEST['program'];
	$alert = true;
}

if (isset($Global['program_restrict']) && $Global['program_restrict'] != '') {
	$where['AND']['u.program_id'] = ['NOT IN', [$Global['program_restrict']]];
}

if (isset($bystatus) && $bystatus != ''/* || (isset($_REQUEST['status']) && $_REQUEST['status'] != '')*/) {
	$where['AND']['u.user_status'] = ['=', $_REQUEST['status']];
}

if (isset($_REQUEST['program']) && $_REQUEST['program'] != 0 && $_REQUEST['program'] != '') {
	$where['AND']['u.program_id'] = ['=', $_REQUEST['program']];
}

if ($_POST['way'] == 1 && $colname!='' && $find!='') {
	$where['AND']["$colname"] = ['=', $find];
} else if ($colname!='' && $find!='') { 
	$where['AND']["$colname"] = ['LIKE', "%$find%"];
}
	
if ($_GET['order'] == 'desc' || ($_POST['find'] != '' && $_POST['colname'] == 5)) { 
	$order_by_clause = "m.ID DESC, u.program_id ASC";
	$btitle = 'Latest';	
} else { 
	$order_by_clause = "m.ID ASC, u.program_id ASC";
	$btitle = 'Earliest';
}

if ($_GET['browse'] == 'Y' && $_REQUEST['program'] != '') {
	$limit = '1000';
} else if ($_GET['browse'] == 'Y' && $_REQUEST['program'] == '') {
	$limit = '500';
} else {
	$limit = 0; // UNLIMITED
}

//if ($pagination_page < 0 && $search_way != "") { // if there is no page set (meaning this is the first search) && There is some search criteria
//$uniq_session_param = $_REQUEST['find'].$_REQUEST['colname'].$_REQUEST['way'].$_REQUEST['status'].$_REQUEST['program'];
$uniq_session_param = ($_GET['browse'] == 'Y') ? 'browse':'search';
$uniq_session_param .= $_REQUEST['program'];
//echo "UNIQ: $uniq_session_param<br />";
if ($pagination_page < 0) {	
	// find out how many total rows there will be & then use results of this query as the first set of 25 for speed improvement
	$pagination_page = 0;
	
	// Execute the select query using PHPCPR
	//$GLOBALS['debug'] = true;
	$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $order_by_clause, $limit, 1);

	$_SESSION['finduser'][$uniq_session_param]['rows'] = count($result);
	$tot_rows = $_SESSION['finduser'][$uniq_session_param]['rows'];
	
	// SHOULD NOT NEED - KEEPING IN CASE WE DO!
/*	if ($tot_rows < 25 && $btitle == 'Latest') {
	$order_by_clause = "ORDER BY m.ID DESC, u.program_id DESC";	
	$qry_firstpg = "{$sql} {$order_by_clause} {$LIMIT} {$browse}";
	//echo $qry_firstpg."<br />";
	$result = mysql_query($qry_firstpg) or die($qry_firstpg.' '.mysql_error());			
	}*/
} else {
	if ($pagination_page >= 0) {
		
		$limit = ['count' => $display_rows, 'offset' => $offset_row];
		
		// Execute the select query using PHPCPR
		$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $order_by_clause, $limit, 1);		
		
		$tot_rows = $_SESSION['finduser'][$uniq_session_param]['rows'];
	} else {
		// show no records if no criteria
		$_SESSION['finduser'][$uniq_session_param]['rows'] = 0;
		$tot_rows = 0;
		echo 'No Criteria';
		//$pagination_page = 0;	
		//$tot_rows = $_SESSION['finduser']['rows'][$uniq_session_param];
	}
}
//print_r($_SESSION);

if ($_GET['browse'] == 'Y' && $_GET['prog'] == '') echo '<h3>Browsing '.$btitle.' Records - ALL PROGRAMS</h3>';
if ($_GET['browse'] == 'Y' && $_GET['prog'] != '') echo '<h3>Browsing '.$btitle.' Members - '.$_GET['pname'].' (Program '.$_GET['prog'].')</h3>';
if ($alert === true) echo '<h4>CLICK ON USERNAME TO SEE ALL PROGRAMS</h4>';	

if ($_GET['order'] == 'desc') {
	$rev = 'asc';
} else {
	$rev = 'desc';
}

//echo '<small><a href="Finduser.php?prog='.$_GET['prog'].'&browse=Y&order='.$rev.'&pname='.$_GET['pname'].'">Reverse Order</a></small><br/>';

$last_record_shown = min($tot_rows,$last_record_shown); // $last_record_shown is smallest of these two


if ($tot_rows == 0) {
	$records = 'No Results';
} elseif ($tot_rows > 0) {
	if ($_GET['browse'] != 'YXXXX') {
		if ($tot_rows > 0) echo '<br/>Showing '.$btitle.' Records '.$first_record_shown.' - '.$last_record_shown.' of '.$tot_rows.' Total Records';
		
	} else {
		echo '<br/>Showing '.$btitle.' Records '.$first_record_shown.' - '.$last_record_shown;
	}
	
	
	// ALLOW ADMIN TO REVERSE THE SEARCH RESULTS ORDER
	if ($tot_rows > 1) {
	echo '&nbsp;<small><a href="Finduser.php?prog='.$_REQUEST['prog'].'&find='.$_REQUEST['find'].'&way='.$_REQUEST['way'].'&colname='.$_REQUEST['colname'].'&status='.$_REQUEST['status'].'&program='.$_REQUEST['program'].'&username='.$_REQUEST['username'].'&browse='.$_REQUEST['browse'].'&order='.$rev.'&pname='.$_REQUEST['pname'].'&email='.$_REQUEST['email'].'">Reverse Order</a></small><br/>';
	}
	
} else {
	$records = "";
}
if (!empty($records)) echo '<br/>'.$records;

echo '<br/><br/>';

$nr = 1;
$color[0] = 'FFFFFF';
$color[1] = 'A3FFA3';

   foreach ($result as $buffer) {

	//print_r($buffer);

	$program_id = $buffer['program_id'];
	
	/* // MOVED TO UP TOP SESSION INSTEAD,
	// AS DOING FOR EACH ROW IS VERY INEFFECIENT!!
	// Define the select fields and the table
	$selectFields = 'program_name, program_type, giveaway_file';
	$mainTable = 'program';

	// Define the WHERE condition
	$where = [];

	// Execute the select query using PHPCPR
	$resultp2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

	// Fetch the first row from the result
	$bufferp2 = !empty($resultp2) ? $resultp2[0] : null;*/

	if ($nr > $display_rows) break;
	switch ($buffer ['user_status']) {
		case "Active":
			$colorStatus = '#2CE62C'; $user_status = 'Active'; $real_user_status = 'Active';
			break;
		case "FreeTrial":
			$colorStatus = '#1DE2FF'; $user_status = 'FreeTrial'; $real_user_status = 'FreeTrial';
			break;
		case "Comped":
			$colorStatus = '#FBFD4B'; $user_status = 'Comped'; $real_user_status = 'Comped';
			break;
		case "TempComp":
			$colorStatus = '#80FFFF'; $user_status = 'TComped'; $real_user_status = 'Temp Comped';
			break;
		case "Unpaid":
			$colorStatus = '#FC4F42'; $user_status = 'Unpaid'; $real_user_status = 'Unpaid';
			break;
		case "Suspended":
			$colorStatus = '#FF40FF'; $user_status = 'Suspnded'; $real_user_status = 'Suspended';
			break;
		case "Cancelled":
			$colorStatus = '#FC4F42'; $user_status = 'Cancelled'; $real_user_status = 'Cancelled';
			break;
		default:
			$colorStatus = '#FFFFFF'; $user_status = ''; 
			break;
	}
	
	$mail_user_status = $real_user_status;

	// SET ACTIVE CANCELLED USERS (THOSE WITH TIME REMAINING) TO SHOW IN AS CANCELLED IN RED, INSTEAD OF ACTIVE IN GREEN
	if ($buffer['user_status'] == 'Active' && $buffer['end_program'] == 'Y') { 
		$colorStatus = 'yellow'; 
		$user_status = '2BCanc'; 
		$mail_user_status = 'Active Pending Cancellation';
	}


	$colorQ = '#FC4F42';
	// SET Q FIELD TO GREEN WHEN PROGRAM IS NOT A STORE, USERS ARE QUALIFIED, OR THE ADMIN
	if ($proginfo_array[$buffer['program_id']]['program_setup_type'] != 'S' && $buffer['user_qualify_perm'] == $proginfo_array[$buffer['program_id']]['program_up'] || $buffer['ID'] == '1') $colorQ = '#2CE62C';

	// LINK MUST BE UP HERE!
	//$redirect = "apay/pay.php?uname=".$buffer['Username'];
	$uname = $buffer['Username'];

	if (filter_var($uname, FILTER_VALIDATE_EMAIL)) {
		// Add a backslash before the '@' symbol if uname is an email
		$uname = str_replace('@', '\@', $uname);
	}

	$redirect = "apay/pay.php?uname=" . $uname;

	// started date is unix timestamp - for time started (activated)
	if ($buffer['Username'] != 'admin' && (is_null($buffer['started']) || ($buffer['started'] ==0))) {
		
		//$redirect = "apay/pay.php?uname=".$buffer['Username'];
		//echo $redirect;
		
		/*if (true) { 
			$starteddate = '<a class="btn btn-success btn-sm" href="'.$Global['webpage_url_ssl'].'admin/Sub/memberlogin.php?id=1&prd='.$redirect.'&program='.$program_id.'" target="_blank"><span class="fa fa-money"></span> Mark Paid</a>';
		} else {
			$starteddate = 'Not Yet';
		}*/
		$starteddate = '<a class="btn btn-success btn-sm" href="'.$Global['webpage_url_ssl'].'admin/Sub/memberlogin.php?id=1&prd='.$redirect.'&program='.$program_id.'" target="_blank"><span class="fa fa-money"></span> Mark Paid</a>';		
		
		$due = '';
	} else if ($buffer['Username'] != 'admin' && $buffer['user_status'] != 'Unpaid') {
		//$starteddate = date("M d, Y", $buffer['started']);
		$starteddate = '<a class="btn btn-success btn-sm" href="'.$Global['webpage_url_ssl'].'admin/Sub/memberlogin.php?id=1&prd='.$redirect.'&program='.$program_id.'" target="_blank"><span class="fa fa-money"></span> Mark Again</a>';			
		if (is_null($buffer['expire'])) {
			$due = '';
		} else {
			$due = date("M d, Y", $buffer['expire']);
		}
		if ($user_status == 'Comped') $due = 'Never';
	} else if ($buffer['Username'] == 'admin') {
		$starteddate = date("M d, Y", strtotime($buffer['Signdate']));
	}	
	if ($_SESSION['p'.$buffer['program_id'].'_program_type'] == 'N') $due = ''; 

	if ($proginfo_array[$buffer['program_id']]['program_type'] == 'N') {
		if ($user_status == 'Active' || $user_status == 'Comped') $due = 'Never';
		else $due='';
	} 
	if ($user_status == 'Comped') $due = 'Never';
	if (is_null($due)) $due = '';
	
if ($user_status != 'QQQUnpaid') {
	//$due = '';
	//$colorStatus = '';
	$user_status = '<a class="btn btn-sm" style="width:100%; color:#fff; background-color:'.$colorStatus.'; text-align:center" href="User_stats.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank">'.$user_status.'</a>';
}
	// Signdate is a datetime - this is time they registered
	if (is_null($buffer['Signdate']) || $buffer['Signdate'] ==0) {
		$sdate = '';
	} else {
		$sdate = date("M d, Y", strtotime($buffer['Signdate']));
	}

	// grace_expire is unix timestamp
	/*if (is_null($buffer['grace_expire']) || ($buffer['grace_expire']=='0')) {
		$grace = '';
		$grace_expire = '';
		$colorg = '#ffffff';
	} else {
		$grace_expire_date = ($buffer['expire']+$Global['grace_end']);
		$grace = 'Grace Expires<br/>';
		//$grace_expire = date("M d, Y", $buffer['grace_start']);
		$grace_expire = date("M d, Y", $grace_expire_date);
		$colorg = '#FC4F42';
	}*/
	$colorg = '#';

	//$Global['use_E4'] = true;
	if ($Global['use_E4'] === true) { // IF USING FIRST DATA E4 GLOBAL GATEWAY

		//$colorE4 = '#FF2121'; Unpaid
		$colorE4 = '#FC4F42';

		$E4 = '<th style="width:2%; text-align:center;">E4</th>';
		$hasE4 = '<td style="width:2%; text-align:center; vertical-align:middle; background-color: '.$colorE4.'">N</td>';

			if ($buffer['e4gatewayID'] != '' && $buffer['payment_collected_by'] == 'member') {
				$colorE4 = '#2CE62C'; 
				$hasE4 = '<td style="width:2%; text-align:center; vertical-align:middle; background-color: '.$colorE4.'">Y</td>';
			} else if ($buffer['e4gatewayID'] != '' && $buffer['payment_collected_by'] == 'admin') {
				$colorE4 = '#FF2121'; 
				$hasE4 = '<td style="width:2%; text-align:center; vertical-align:middle; background-color: '.$colorE4.'">Y</td>';
			}	
		} else {
		$E4 = '';
		$hasE4 = '';

	} // END IF USING E4 GLOBAL GATEWAY
?>	

<div class="table-responsive">
<table class="table table-condensed table-striped table-bordered table-hover no-margin">
                  <thead>
                    <tr <?php if ($buffer['Status'] == 'Cancelled') echo 'style="color:red"';?>>
                      <th style="width:2%"><div style="color:#58A1CB"><i class="fa fa-user"></i></div></th>
					  <!--<th style="width:2%; text-align:center;">UPID</th>-->
					  
                      <th style="width:10%; text-align:center;">First Name</th>
					  <th style="width:10%; text-align:center;">Last Name</th>					  
                      <th style="width:8%; text-align:center;">Username</th>
                      <th style="width:8%; text-align:center;">Referrer</th>

                      <th style="width:8%; text-align:center;">Sponsor</th>
                      <th style="width:3%; text-align:center;">Status</th>

                      <th style="width:3%; text-align:center;">SID</th>

	                 <th style="width:1%; text-align:center;">PQ</th>
                      <th style="width:7%; text-align:center;">Registered</th>
                      <th style="width:7%; text-align:center;">Activation</th>
					 
					 <?php if ($_SESSION['p'.$buffer['program_id'].'_giveaway_file']  == 'Mat.give.php') { ?>
					 <th style="width:7%; text-align:center;">Matrix</th>
					 <?php } else if ($_SESSION['p'.$buffer['program_id'].'_program_type'] != 'N') { ?>
					 <th style="width:7%; text-align:center;">Due Date</th>
					 <?php } else if ($Global['use_bank'] == true) { ?>
					 <th style="width:7%; text-align:center;">Bank</th>
					 <?php } else { ?>
					 <th style="width:7%; text-align:center;">Earned</th>
					 <?php } ?>
					 
					 
					 
					 <?php echo $E4; ?>
	                 <th style="width:5%; text-align:center;">Payments</th>
	                 <th style="width:5%; text-align:center;"><?php echo $_SESSION['p'.$buffer['program_id'].'_name']; ?></th>
	                 <th style="width:5%; text-align:center;">Member</th>					 
                    </tr>
                  </thead>
                  <tbody>  


<?php
echo '
<tr bgcolor="'.(($nr % 1 == 0)?$color[0]:$color[1]).'">
<!--
<td style="text-align:center; vertical-align:middle">
<a href="../../join.php?id='.$buffer['Username'].'&jv='.$Global['jv_key'].'&q='.$Global['jv_qualify_key'].'" target="_blank"
title="'.$buffer['ID'].'">'.ShortenText2($buffer['ID']).'</a>
</td>

<td style="text-align:center; vertical-align:middle">
<a href="../../join.php?id='.$buffer['Username'].'&jv='.$Global['jv_key'].'&q='.$Global['jv_qualify_key'].'" target="_blank"
title="'.$buffer['user_program_id'].'">'.ShortenText2($buffer['user_program_id']).'</a>
</td>

<td style="text-align:left; vertical-align:middle">
<a href="../../login-check-enrollee.php?id='.$buffer['Username'].'&login='.$buffer['Username'].'&t=y&rd=Members/program.php?program='.$buffer['program_id'].'&sendemail=n" target="_blank" title="'.$buffer['First_Name'].'">'.ShortenText($buffer['First_Name']).'</a></td>
-->

<td style="text-align:center; vertical-align:middle">
'.ShortenText2($buffer['ID']).'
</td>
<!--
<td style="text-align:center; vertical-align:middle">
'.ShortenText2($buffer['user_program_id']).'
</td>
-->';

if (false && $GLOBALS['powerline_program_id'] > 0) { // 0 WHEN POWERLINE FEAR OF LOSS SYSTEM IS BEING USED
echo '<td style="text-align:left; vertical-align:middle">
<a href="../../login-check-enrollee.php?id='.$buffer['Username'].'&login='.$buffer['Username'].'&t=y" target="_blank" title="'.$buffer['First_Name'].'">'.ShortenText($buffer['First_Name']).'</a></td>';

} else {
echo '<td style="text-align:left; vertical-align:middle">
<a href="../../join.php?id='.$buffer['Username'].'&t=y" target="_blank" title="'.$buffer['First_Name'].'">'.ShortenText($buffer['First_Name']).'</a></td>';
}	

echo '<td style="text-align:left; vertical-align:middle">
<a href="mailto:'.$buffer['email'].'?subject='.$Global['webpage_name'].'%20Follow%20Up%20For%20Username%20'.$buffer['Username'].'&body=Dear%20'.$buffer['First_Name'].',%0D%0A%0D%0A

I hope this email finds you well, and you are getting a lot out of the '.$Global['webpage_name'].' program.%0D%0A%0D%0A

We have reviewed your user account '.$buffer['Username'].' (affiliate link '.$Global['webpage_url'].'?id='.$buffer['Username'].'),%0D%0A%0D%0A

Your account status is currently '.$mail_user_status.'.%0D%0A%0D%0A
  
Sincerely,
%0D%0A
Admin" title="'.$buffer['Last_Name'].'.'.$buffer['phone'].'">'.ShortenText($buffer['Last_Name']).'</a></td>

<td style="text-align:center; vertical-align:middle" title="'.$buffer['Username'].'"><a href="Finduser.php?username='.$buffer['Username'].'" target="_blank">'.ShortenText($buffer['Username']).'</a></td>

<td style="text-align:center; vertical-align:middle" title="'.$buffer['msponsorid'].'"><a href="Finduser.php?username='.$buffer['msponsorid'].'&prog='.$_REQUEST['prog'].'" target="_blank">'.ShortenText($buffer['msponsorid']).'</a></td>

<td style="text-align:center; vertical-align:middle" title="'.$buffer['usponsorid'].'"><a href="Finduser.php?username='.$buffer['usponsorid'].'&prog='.$_REQUEST['prog'].'" target="_blank">'.ShortenText($buffer['usponsorid']).'</a></td>


<td style="text-align:center; vertical-align:middle; background-color: '.$colorStatus.'">'.$user_status.'</td>

<td style="text-align:center; vertical-align:middle">'.$buffer['sign_id'].'</td>

<td style="text-align:center; ; vertical-align:middle; background-color: '.$colorQ.'">'.$buffer['user_qualify_perm'].'</td>
<!--
<td style="text-align:center; background-color: '.$colorQ.'">'.$buffer['user_qualify_perm'].'</td>
<td style="text-align:center">'.$buffer['user_signup'].'</td>
-->
<td style="text-align:center; vertical-align:middle">'.$sdate.'</td>

<td style="text-align:center; ; vertical-align:middle; background-color: '.$colorg.'">'.$starteddate.'
<br/>
</td>';

echo $hasE4;

if ($_SESSION['p'.$buffer['program_id'].'_giveaway_file'] == 'Mat.give.php') {
	echo '<td style="text-align:center; vertical-align:middle"><a class="btn btn-info btn-sm" style="width:100%; text-align:center" href="memberlogin.php?id='.$buffer['ID'].'&prd=Members/advanced_viewer.php?m='.$buffer['program_id'].'" target="_blank"><span class="fa fa-sitemap"></span> View Matrix</a></td>';
} else if ($_SESSION['p'.$buffer['program_id'].'_program_type'] != 'N') {
	echo '<td style="text-align:center; vertical-align:middle">'.$due.'</a></td>';
} else if ($Global['use_bank'] == true) {
	echo '<td style="text-align:center; vertical-align:middle"><a class="btn btn-success btn-sm" style="width:100%; text-align:center" href="memberlogin.php?id='.$buffer['ID'].'&prd=Members/bankledger.php?m='.$buffer['program_id'].'" target="_blank"><span class="fa fa-bank"></span> View Bank</a></td>';
} else {
// LINK WILL FWD TO COMMS EARNED PAGE!
	echo '<td style="text-align:center; vertical-align:middle"><a class="btn btn-success btn-sm" style="width:100%; text-align:center" href="memberlogin.php?id='.$buffer['ID'].'&prd=Members/bankledger.php?m='.$buffer['program_id'].'" target="_blank"><span class="fa fa-bank"></span> View Comms</a></td>';
}	
?>
<td style="text-align:center">

<!-- ACTION BUTTON 1 -->
<div class="btn-group <?php if ($nr > 4) echo 'dropup';?>">
  <button type="button" class="btn btn-danger dropdown-toggle btn-sm" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    Action
  </button>
  <div class="dropdown-menu" style="background-color: #e7e7e7">
 
                            <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&prd=apay/buy.php?reset=100" target="_blank"><span class="fa fa-filter"></span> Join Funnel</a>'; ?> 

                            <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&prd=apay/pay.php?program='.$buffer['program_id'].'" target="_blank"><span class="glyphicon glyphicon-tag"></span> Buy</a>'; ?>

							<?php //echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="Viewplan.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank"><span class="fa fa-line-chart"></span> Pay Plan</a>'; ?>
 
                             <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="Payment-Logs.php?username='.$buffer['Username'].'&prog='.$buffer['program_id'].'&searchway=username_who_paid&cc_pending=ALL" target="_blank"><span class="glyphicon glyphicon-folder-open"></span> &nbsp; Payment Log</a>'; ?>
                                                    
                              <?php if ($Global['use_E4'] === true) 
								  echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="first-data-logs.php?user='.$buffer['Username'].'&prog='.$buffer['program_id'].'" target="_blank"><span class="fa fa-shopping-cart"></span> &nbsp;E4 Log</a>'; ?> 
                            
                            <?php if ($Global['use_bank'] == true) { ?>
							<!-- PHP NOT UPDATED YET! - RARELY USED PAGE ANYWAY - WILL REVAMP AS NEEDED
							ONCE DONE, ADD BACK IN admin/Inc/Header.inc.php, TOO!
							 <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="search-bank-logs.php?username='.$buffer['Username'].'" target="_blank"><span class="glyphicon glyphicon-link"></span> Bank Log</a>'; ?>
							-->
                             <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=bankledger.php" target="_blank"><span class="fa fa-bank"></span> Bank</a>'; ?>
                            <?php } ?>
                            
                             <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=viewpayment.php?program='.$buffer['program_id'].'" target="_blank"><span class="fa fa-money"></span> Earned</a>'; ?>
                            
							<!--							
							<?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=viewdirectpayment.php?program='.$buffer['program_id'].'" target="_blank">Paid Out</a><br />'; ?>
							-->						
    
                        </div>
</div>

<!-- END ACTION BUTTON 1 -->
</td>
<td style="text-align:center">

<!-- ACTION BUTTON 2 -->
<div class="btn-group <?php if ($nr > 4) echo 'dropup';?>">
  <button type="button" class="btn btn-success dropdown-toggle btn-sm" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    Action
  </button>
  <div class="dropdown-menu dropdown-menu-right" style="background-color: #e7e7e7">

                            <?php
							$Global['use_binary'] = false;
							if ($buffer['program_id'] == 1 && $Global['use_binary'] == true) {
								 
							 echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=binary_viewer.php" target="_blank"><span class="glyphicon glyphicon-link"></span>  View Binary</a>'; 
							 
							 if ($_SESSION['mvfrom_cell'] != "") {
								echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="../../Members/binary_viewer_mover_from.php?usrid='.$buffer['ID'].'" target="_blank"><span class="glyphicon glyphicon-link"></span>  Binary Mover FROM</a>';
								echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="../../Members/binary_viewer_mover_to.php?usrid='.$buffer['ID'].'" target="_blank"><span class="glyphicon glyphicon-link"></span>  Binary Mover TO</a>';
							 } else {
								echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="../../Members/binary_viewer_mover_from.php?usrid='.$buffer['ID'].'" target="_blank"><span class="glyphicon glyphicon-link"></span>  Binary Mover</a>';		 
							 }
							} // END BINARY PROGRAM
						
							if ($_REQUEST['prog'] == '' || ($_POST['way'] == '2' && $tot_rows > 1)) {
							echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="Finduser.php?username='.$buffer['Username'].'&prog='.$buffer['program_id'].'" target="_blank"><span class="fa fa-binoculars"></span> Isolate Program</a>';
							} else {
							echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="Finduser.php?username='.$buffer['Username'].'" target="_blank"><span class="fa fa-window-maximize"></span> Show All Programs</a>';
							}							

							echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=viewdownline.php?program='.$buffer['program_id'].'" target="_blank"><span class="fa fa-sitemap"></span> View Team</a>';							
							
							//echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="Edituser.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank"><span class="fa fa-id-badge"></span> Status</a>';

							echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="Editplan.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank"><span class="fa fa-hand-o-up"></span> Sponsor / Q</a>';
							
											
 							 if ($Global['use_matrix'] == true && $buffer['program_id'] != 1) { // QQQ DO NOT SHOW UPLINE CHAIN ON MATRIX PROGRAMS! ASSUMES P1 WILL ALWAYS BE THE BINARY MATRIX
								echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="getsponsorchain.php?program='.$buffer['program_id'].'&username='.$buffer['Username'].'" target="_blank"><span class="glyphicon glyphicon-link"></span>  Upchain</a>';
							 }?>
              
    </div>
</div>

<!-- END ACTION BUTTON 2 -->

</td>
<td style="text-align:center">

<!-- ACTION BUTTON 3 -->
<div class="btn-group <?php if ($nr > 4) echo 'dropup';?>">
  <button type="button" class="btn btn-info dropdown-toggle btn-sm" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    Action
  </button>
  <div class="dropdown-menu dropdown-menu-right" style="background-color: #e7e7e7">

                            <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=profile.php" target="_blank"><span class="glyphicon glyphicon-user"></span> Profile</a>'; ?>

							<?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=index.php?program='.$buffer['program_id'].'" target="_blank"><span class="glyphicon glyphicon-list-alt"></span> Index</a>'; ?>

							 <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="member-notes.php?id='.$buffer['ID'].'" target="_blank"><span class="fa fa-file-o"></span> User Notes</a>'; ?>
							
							<?php if ($GLOBALS['use_campaigns'] == true) {
							echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&prd=ads/admin/assign_credits.php?id='.$buffer['ID'].'" target="_blank"><span class="fa fa-tv"></span> Add Credits</a>';							
							
							}
							
							echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="login-logs.php?user='.$buffer['Username'].'" target="_blank"><span class="fa fa-paw"></span> User Logins</a>'; ?>							
 
							 <?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="memberlogin.php?id='.$buffer['ID'].'&rd=profile-update.php" target="_blank"><span class="fa fa-wrench"></span> Profile Override</a>'; ?>							
 
							 <?php if ($Global['use_E4'] === true) { // IF USING FIRST DATA E4 GLOBAL GATEWAY
							 echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="minfraud-bypass.php?username='.$buffer['Username'].'" target="_blank"><span class="fa fa-arrow-circle-right"></span> Minfraud Bypass</a>'; } ?>							
 
							<?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="Edit_user.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank"><span class="fa fa-id-card-o"></span> Username / Sponsor</a>'; ?>
							
							<?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="cancel-user.php?id='.$buffer['ID'].'" target="_blank"><span class="fa fa-credit-card"></span> Cancel User</a>'; ?>							

							<?php echo '<a class="dropdown-item btn btn-info btn-sm" style="width:100%; text-align:left" href="../delete_user.php?user='.$buffer['Username'].'&action=delete" target="_blank"><span class="fa fa-trash-o"></span> Delete User</a>'; ?>								 
              
    </div>
</div>
<!-- END ACTION BUTTON 3 -->
<!--
<a href="memberlogin.php?id='.$buffer['ID'].'&rd=profile-check.php?program='.$buffer['program_id'].'" target="_blank">Nag</a>
-->
<!-- NOT GOING TO DELETE USERNAMES ANYMORE, AS THIS CAUSES TOO MUCH CONFUSION FOR FORENSIC WORK LATER ON... WE NEED TO KEEP USERNAMES FOR HISTORICAL PURPOSES
<a href="null.php?id='.$buffer['ID'].'" target="_blank">Null</a> | <a href="remove.php?id='.$buffer['ID'].'" target="_blank">Delete</a>
-->
</td>
</tr>
<?php			
			++$nr;
	} // END WHILE LOOP
} // END isset($_POST['find']) || $_GET['browse'] == 'Y'
		
echo '<tr><td colspan="17"><br/><br/><br/>';
echo '<div style="text-align:center">';

$view_prev_page = max(-1,$pagination_page - 1);
$view_next_page = max(1,$pagination_page + 1);

if (isset($_GET['browse']) && $_GET['browse'] == 'Y') {
	$browse_page = '&browse=Y';
} else {
	$browse_page = '';
}	

if (isset($tot_rows) && $tot_rows != 0) {
	if ($_GET['browse'] != 'Y') {
		if ($tot_rows > 0) echo '<br/>Showing Records '.$first_record_shown.' - '.$last_record_shown.' of '.$tot_rows.' Total Records<br/>';
	} else {
		echo '<br/>Showing Records '.$first_record_shown.' - '.$last_record_shown.'<br />';
	}
	if ($view_prev_page >= 0) {
		echo '<a href="Finduser.php?page='.$view_prev_page.$browse_page.'&order='.$_GET['order'].'&prog='.$_REQUEST['prog'].'">Previous Records</a>  |  ';
	}
	
	if ($tot_rows > $last_record_shown || $tot_rows < 0) { // if there are more rows available, or if total number of rows not known
		echo '<a href="Finduser.php?page='.$view_next_page.$browse_page.'&order='.$_GET['order'].'&prog='.$_REQUEST['prog'].'">Next Records</a>  <br/>';
	}
}
?>
</div>

<?php
echo '<br/><br/><br/><br/><br/></td></tr></tbody></table></div>'; 
?>

<script>
  document.getElementById("copyButton").addEventListener("click", function(event) {
    event.preventDefault();
    var copyText = document.getElementById("find");
    copyText.focus();
    copyText.select();
    var successful = document.execCommand('copy');
  });
</script>

<?php
include './../Inc/Footer.inc.php';
?>