<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('FIND_MEMBER') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
}
$pageName = 'Search Payment Logs';
$pageAlign = 'center';
$pageClass = '';
$timestamp = time();
if (isset($_GET['page']) && $_GET['page'] != '') {
	$pagination_page = $_GET['page'] + 0;
} else {
	$pagination_page = -1;
}

date_default_timezone_set('America/New_York');

include './../Inc/Header.inc.php';
echo '<h1>Search Payment Logs</h1>';
//exit;

//$GLOBALS['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//$_SESSION['UserID'] = 81; // FOR TESTING ONLY!!
include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
*/

// KILL DEV DESSION
if (isset($_GET['dev']) && $_GET['dev'] === '0') {
	$debug = false;
	$_SESSION['dev'] = false;
}
// override - kill session for client
//	$debug = false;
//	$_SESSION['dev'] = false;

if (!empty($_GET['do']) && $_GET['do'] == 'EditLog') {
    if ($_GET['changelog'] == 'yes' && $_GET['sure'] == 'yes') {
        $cc_status = ($_GET['logstatus'] === 'R') ? 'N' : $_GET['logstatus'];
        $refund = ($_GET['logstatus'] === 'R') ? 'Y' : 'N';
        $data = [
            'cc_pending' => $cc_status,
            'chargeback' => $refund
        ];
        $where = [
            'payment_log_id' => ['=', $_GET['log_id']]
        ];
        update('payment_log', $data, [], $where, 1, 1, 1);
        echo 'Successfully Edited Payment Log ' . $_GET['log_id'] . '!<br/><br/>';
        exit;
    }
}

if (!empty($_GET['do']) && $_GET['do'] == 'DeleteLog') {
    if ($_GET['flush'] === 'true') {
        $where = [
            'payment_log_id' => ['=', $_GET['log_id']]
        ];
        delete('payment_log', [], $where, null, 1, 1, 1);
        echo 'Successfully Flushed Payment Log ' . $_GET['log_id'] . '!<br/><br/>';
        exit;
    }
}

$payer = $_GET['payer'] ?? '';
$prog = $_GET['prog'] ?? 1;

$selectFields = 'program_name'; 
$mainTable = 'program'; 
$wherep = [
    'program_id' => ['=', $prog]
];
$show_debug = 1;

$resultp = select($selectFields, $mainTable, [], $wherep, null, null, null, 0, $show_debug);
$bufferp = isset($resultp[0]) ? $resultp[0] : null;

if (isset($payer)) {
	$selectFields = 'ID'; 
	$mainTable = 'members'; 
	$where = [
		'Username' => ['=', $payer]
	];

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
}
?>
		
<form enctype="multipart/form-data" method="POST" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>?username=<?php echo $_REQUEST['username']; ?>&cc_pending=<?php echo $_REQUEST['cc_pending']; ?>">


<?php
// AUTO SUBMIT SEARCH FOR USERNAME, ETC., WHEN PRESENT IN URL
// Transfer values from GET to POST if POST is not set or empty and GET is set and not empty

if (isset($_GET['username']) && !isset($_POST['username']) && $_GET['username'] != '') {
    $_POST['username'] = $_GET['username'];
}
if (isset($_GET['prog']) && !isset($_POST['program']) && $_GET['prog'] != '') {		
    $_POST['program'] = $_GET['prog'];
}
if (isset($_GET['cc_pending']) && !isset($_POST['cc_pending']) && $_GET['cc_pending'] != '') {
    $_POST['cc_pending'] = $_GET['cc_pending'];
}
if (isset($_GET['searchway']) && !isset($_POST['searchway']) && $_GET['searchway'] != '') {
    $_POST['searchway'] = "username_who_got_paid";
}

// END AUTO SUBMIT SEARCH FOR USERNAME, ETC., WHEN PRESENT IN URL


$checkp = isset($_REQUEST['searchpay']) && $_REQUEST['searchpay'] == 'admin' ? 'checked="checked"' : '';

$checkp2 = isset($_REQUEST['searchpay']) && $_REQUEST['searchpay'] == 'member' ? 'checked="checked"' : '';

$check1 = isset($_REQUEST['searchway']) && $_REQUEST['searchway'] == 'username_who_got_paid' ? 'checked="checked"' : '';

$check2 = isset($_REQUEST['searchway']) && $_REQUEST['searchway'] == 'username_who_paid' ? 'checked="checked"' : '';

$check3 = isset($_REQUEST['searchway']) && $_REQUEST['searchway'] == 'anyone' ? 'checked="checked"' : '';

$checkY = isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] == 'Y' ? 'checked="checked"' : '';

$checkA = isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] == 'A' ? 'checked="checked"' : '';

$checkN = isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] == 'N' ? 'checked="checked"' : '';

$checkALL = isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] == 'ALL' ? 'checked="checked"' : '';

$checkAdmin = isset($_REQUEST['show_logs_to_admin']) && $_REQUEST['show_logs_to_admin'] == 'yes' ? 'checked="checked"' : '';

$checkCan = isset($_REQUEST['show_logs_to_cancelled']) && $_REQUEST['show_logs_to_cancelled'] == 'yes' ? 'checked="checked"' : '';

$checkV = isset($_REQUEST['show_status']) && $_REQUEST['show_status'] == 'valid' ? 'checked="checked"' : '';

$checkR = isset($_REQUEST['show_status']) && $_REQUEST['show_status'] == 'refund' ? 'checked="checked"' : '';

$checkB = isset($_REQUEST['show_status']) && $_REQUEST['show_status'] == 'both' ? 'checked="checked"' : '';

$datecheck = isset($_REQUEST['datesearch']) && $_REQUEST['datesearch'] == 'yes' ? 'checked="checked"' : '';

/*
echo 'Show All Payment Logs';

// These ensure that the correct radio button is checked based on the value of $_REQUEST variables
echo '<input type="radio" name="cc_pending" value="Y" ' . (isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] == 'Y' ? 'checked="checked"' : '') . '> Pending';
echo '<input type="radio" name="cc_pending" value="N" ' . (isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] == 'N' ? 'checked="checked"' : '') . '> Paid Out';
echo '<input type="radio" name="cc_pending" value="ALL" ' . (isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] == 'ALL' ? 'checked="checked"' : '') . '> All &nbsp;';

echo 'Show Only';
echo '<input type="radio" name="show_status" value="valid" ' . (isset($_REQUEST['show_status']) && $_REQUEST['show_status'] == 'valid' ? 'checked="checked"' : '') . '> Valid Logs';
echo '<input type="radio" name="show_status" value="refund" ' . (isset($_REQUEST['show_status']) && $_REQUEST['show_status'] == 'refund' ? 'checked="checked"' : '') . '> Refunded Logs';
echo '<input type="radio" name="show_status" value="both" ' . (isset($_REQUEST['show_status']) && $_REQUEST['show_status'] == 'both' ? 'checked="checked"' : '') . '> Both';

echo '<br /><br/>';

echo 'Search Only Logs';
echo '<input type="radio" name="searchpay" value="admin" ' . (isset($_REQUEST['searchpay']) && $_REQUEST['searchpay'] == 'admin' ? 'checked="checked"' : '') . '> Collected By Admin';
echo '<input type="radio" name="searchpay" value="member" ' . (isset($_REQUEST['searchpay']) && $_REQUEST['searchpay'] == 'member' ? 'checked="checked"' : '') . '> Collected By Member';

echo '<br /><br/>';
*/

echo 'Search Only Logs';
echo '<input type="radio" name="searchway" value="username_who_got_paid" ' . (isset($_REQUEST['searchway']) && $_REQUEST['searchway'] == 'username_who_got_paid' ? 'checked="checked"' : '') . '> Paying This Username';
echo '<input type="radio" name="searchway" value="username_who_paid" ' . (isset($_REQUEST['searchway']) && $_REQUEST['searchway'] == 'username_who_paid' ? 'checked="checked"' : '') . '> Paid By This Username';

echo '<!-- THIS IS THE USERNAME SEARCH FIELD -->';
echo '<input name="username" type="text" value="' . (isset($_REQUEST['username']) ? htmlspecialchars($_REQUEST['username']) : '') . '" />';

echo '<input type="radio" name="searchway" value="anyone" onclick="this.form.username.value=this.value=\'\'" ' . (isset($_REQUEST['searchway']) && $_REQUEST['searchway'] == 'anyone' ? 'checked="checked"' : '') . '> Paid By Anyone To Anyone';
echo '<br /><br/>';

echo 'Where Payment Processor Equals';
echo '<!-- THIS IS THE PAYMENT PROCESSOR SEARCH FIELD -->';
echo '<input name="pp" type="text" size="2" value="' . (isset($_REQUEST['pp']) ? htmlspecialchars($_REQUEST['pp']) : '') . '" />';
?>


<br /><br />
Search By Dates: 
<input type="date" name="start_date" value="<?php echo isset($_POST['start_date']) ? htmlspecialchars($_POST['start_date'], ENT_QUOTES) : ''; ?>">
    to
<input type="date" name="end_date" value="<?php echo isset($_POST['end_date']) ? htmlspecialchars($_POST['end_date'], ENT_QUOTES) : ''; ?>">

<br>

<?php
// SEARCH BY DATES

if (isset($_POST['start_date']) && $_POST['start_date'] != '') {
    $_POST['start_date'] .= ' 00:00:00';
    $start_date = strtotime($_POST['start_date']);
}

if (isset($_POST['end_date']) && $_POST['end_date'] != '') {
    $_POST['end_date'] .= ' 23:59:59';
    $end_date = strtotime($_POST['end_date']);
}

/* // DEBUGGING STATEMENTS
echo 'Start Time: ';
echo $start_date;
echo '<br />End Time: ';
echo $end_date;
echo '<br />';
*/


if (isset($_POST['start_date']) && $_POST['start_date'] != '' && isset($_POST['end_date']) && $_POST['end_date'] != '') {

	$whereAND = [
		'AND' => [
			['log.timestamp' => ['>=', $start_date]],
			'log.timestamp' => ['<=', $end_date]
		]
	];
} else {
	$whereAND = [];
}
//SELECT ALL PROGRAMS 

$selectFields = 'program_id, program_name';
$mainTable = 'program';
$wherep = [
    'program_approved' => ['=', 'Y']
];
$orderBy = 'program_name ASC';
$show_debug = 1;

$resultp = select($selectFields, $mainTable, [], $wherep, null, null, $orderBy, 0, $show_debug);
$program_info = '<option value="0">All Programs</option>';

if ($_POST['program'] == '') {
    $_POST['program'] = $_GET['prog'] ?? '';
}

foreach ($resultp as $bufferp) {
    $selected = ($_POST['program'] == $bufferp['program_id']) ? ' selected' : '';
    $program_info .= '<option value="' . htmlentities($bufferp['program_id']) . '"' . $selected . '>' . htmlentities($bufferp['program_name']) . '</option>';
}

echo <<<EOD
<table align="center" bgcolor="#FFFFFF"><tr><td>
Search By
<select name="program">
{$program_info}
</select>
</td></tr></table>
EOD;

$program = '';
if ($_REQUEST['program'] != 0 && $_REQUEST['program'] != "") {
    $program = "&& log.program_id = " . $_POST['program'];
} elseif ($_REQUEST['prog'] != 0 && $_REQUEST['prog'] != "") {
    $program = "&& log.program_id = " . $_REQUEST['prog'];
}

?>
<br/>			

<input type="checkbox" NAME="show_logs_to_admin" VALUE="yes" <?php echo (isset($_REQUEST['show_logs_to_admin']))? $checkAdmin:''; ?>> 
DO NOT Include Logs Paid To Admin<br/><br/>


<input type="checkbox" NAME="show_logs_to_cancelled" VALUE="yes" <?php echo (isset($_REQUEST['show_logs_to_cancelled']))? $checkCan:''; ?>> 
DO NOT Include Logs Paid To Cancelled And Suspended Members<br/>
NOTE: Commissions are not paid to suspended or cancelled members. This checkbox is simply used to display past payments,<br/>
and payments that would be due the member if they return to Active status (and have any commissions pending).
<br/><br/>
	
<table align="center"><tr><td align="center"> 
<input type="submit" name="submit" value="Search or Browse Payment Logs" /></form><br/> 


<p></p>
<!--
			<form enctype="multipart/form-data" method="POST" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>?show=all_recent_logs">
			
			<input type="submit" name="submit" value="Show All Recent Logs" /></form>
<p></p>

			<form enctype="multipart/form-data" method="POST" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>?show=all_recent_logs&status=u">
			
			<input type="submit" name="submit" value="Show All Recent Logs From Unpaid Users" /></form>			 


<p></p>

			<form enctype="multipart/form-data" method="POST" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>?show=all_recent_logs&status=u&old=Y">
			
			<input type="submit" name="submit" value="Show All Recent Logs 2 Days Old Where Users Still Unpaid" /></form>			 
<p></p>
-->

<a href="Payment-Logs.php">Reset Form</a>			

</td></tr></table>


<?php
$selectFieldsAMT = 'SUM(log.amount) as tot_amount, memb.ID, memb.Username, memb.First_Name, memb.Last_Name, memb.email, prog.user_program_id, prog.user_status, prg.program_name, log.*';

$selectFields = 'memb.ID, memb.Username, memb.First_Name, memb.Last_Name, memb.email, prog.user_program_id, prog.user_status, prg.program_name, log.*';

$mainTable = [
    'table' => 'payment_log', 
    'as' => 'log'
];

$joinConditions = [
    ['table' => 'program', 'as' => 'prg', 'condition' => 'log.program_id = prg.program_id'],
    ['table' => 'user_program', 'as' => 'prog', 'condition' => 'log.user_program_id = prog.user_program_id'],
    ['table' => 'members', 'as' => 'memb', 'condition' => 'prog.ID = memb.ID']
];

$where = [
    'memb.Username' => ['!=', 'DELETED'],
    'log.amount' => ['!=', 0]
];

if (isset($_REQUEST['searchpay']) && $_REQUEST['searchpay'] != '') {
    $where['log.collected_by'] = ['=', $_REQUEST['searchpay']];
}

if (isset($_REQUEST['username'])) {
    if ($_REQUEST['searchway'] == 'username_who_got_paid') {
        $where['memb.Username'] = ['=', $_REQUEST['username']];
    } elseif ($_REQUEST['searchway'] == 'username_who_paid') {
        $where['log.payer_username'] = ['=', $_REQUEST['username']];
    }
}

if (isset($_REQUEST['cc_pending']) && $_REQUEST['cc_pending'] != '' && $_REQUEST['cc_pending'] != 'ALL') {
    $where['log.cc_pending'] = ['=', $_REQUEST['cc_pending']];
}

if (isset($_REQUEST['show_logs_to_admin']) && $_REQUEST['show_logs_to_admin'] == 'yes') {
    $where['memb.ID'] = ['!=', 1];
}

if (isset($_REQUEST['show_logs_to_cancelled']) && $_REQUEST['show_logs_to_cancelled'] == 'yes') {
    $where['prog.user_status'] = ['NOT IN', ['Cancelled', 'Suspended', 'Unpaid']];
}

if (isset($_REQUEST['pp']) && $_REQUEST['pp'] != '') {
    $where['log.payment_processor'] = ['=', $_REQUEST['pp']];
}

if (isset($_REQUEST['period']) && $_REQUEST['period'] != '') {
    $where['pp.payment_period'] = ['=', $_REQUEST['period']];
}

if (isset($_REQUEST['show_status'])) {
    switch ($_REQUEST['show_status']) {
        case 'refund':
            $where['log.chargeback'] = ['=', 'Y'];
            break;
        case 'valid':
            $where['log.chargeback'] = ['=', 'N'];
            break;
        case 'both':
            // no additional where condition
            break;
    }
}

$orderBy = 'log.timestamp DESC, log.program_id, log.user_program_id';
$show_debug = 1;

$whereMain = array_merge($where, $whereAND);

// PARTY STARTS HERE - MAIN SEARCH
//$GLOBALS['debug'] = true;

$result = select($selectFieldsAMT, $mainTable, $joinConditions, $whereMain, null, null, $orderBy, 0, $show_debug);
$buffersum = isset($result[0]) ? $result[0] : null;

$result = select($selectFields, $mainTable, $joinConditions, $whereMain, null, null, $orderBy, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;
$rows = is_array($result) ? count($result) : 0;


if ($_GET['show'] == 'all_recent_logs' && $_GET['status'] == '') {
	
} else if ($_GET['show'] == 'all_recent_logs' && $_GET['status'] == 'u' && $_GET['old'] != 'Y') {

//$where = ['prog.user_status'] = 'Unpaid'

} else if ($_GET['show'] == 'all_recent_logs' && $_GET['status'] == 'u' && $_GET['old'] == 'Y') {
//qq1
//$old_date = strtotime("-2 days");

//&& (log.timestamp < $old_date)
	
}


if (isset($_REQUEST['username']) || isset($_POST['submit'])) {

//print_r($_POST); exit;

	$nr = 1;
	$color[0] = 'FFFFFF';
	$color[1] = 'A3FFA3';

$records = count($result);
	

// *************************************************************************************************************
// *************************************************************************************************************
// ************************************ BEGIN SEARCH RESULTS DISPLAY HERE **************************************

// CALCULATE TOTAL NET EARNINGS
$gross = number_format($buffersum['tot_amount'], 2, '.', '');
$net = $buffersum['tot_amount'] - ($buffersum['tot_amount'] * $GLOBALS['cc_fee_rate']);
$net2 = number_format($net, 2, '.', '');

echo '<div align="center"><h2>Total Records: '.$records.' Total Amount: '.$gross;

if ($gross > $net2) echo '&nbsp;Total Net Amount: '.$net2;

echo '</h2></div>';		
?>
<table width="965px" align="center" cellpadding="0" cellspacing="0" style="border: 1px solid #000">
<tr>
<td align="center" width="30px" style="font-weight: bold; border-right: 1px solid #000; border-bottom: 1px solid #000;">ID</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">UID</td>


<?php if ($_GET['show'] != 'all_recent_logs') { ?>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Paid To Username</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Collected By</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Earned In Program</td>
<?php } ?>

<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">First Name</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Last Name</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Email</td>
<td align="left" width="30px" style="font-weight: bold; border-right: 1px solid #000; padding-left: 5px; border-bottom: 1px solid #000;">Program</td>

<td align="left" width="110px" style="font-weight: bold; border-right: 1px solid #000; padding-left: 5px; border-bottom: 1px solid #000;">Log Status</td>

<td align="left" width="110px" style="font-weight: bold; border-right: 1px solid #000; padding-left: 5px; border-bottom: 1px solid #000;">Amount</td>

<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Paid By</td>
<td align="left" width="110px" style="font-weight: bold; border-right: 1px solid #000; padding-left: 5px; border-bottom: 1px solid #000;">

<?php if (!isset($_GET['show'])) { 

	echo 'Payee Status';
} else {
	echo 'Payer Status';
}	
?>
</td>

<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Timestamp</td>


<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Payment Log Id</td>


<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Payment Plan Id</td>


<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Payment Processor</td>

<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Manual Override</td>

<!--
<td align="center" width="60px" style="font-weight: bold; border-bottom: 1px solid #000;">Action</td>
-->
</tr>

<?php
foreach ($result as $buffer) {
		

// CHECK LOG STATUS OF CC_PENDING

if ($buffer['cc_pending'] == 'Y') {

$cc_pending_status = 'Pending';

} else if ($buffer['cc_pending'] == 'A') { 

$cc_pending_status = 'Awaiting Payment';

} else if ($buffer['cc_pending'] == 'N' && $buffer['chargeback'] == 'Y') { 

$cc_pending_status = 'Refunded';

} else if ($buffer['cc_pending'] == 'N' && $buffer['chargeback'] != 'Y') { 

$cc_pending_status = 'Paid Out';

}

$upid = $buffer['user_program_id'];

$cc_pending_status = 'Received';


		$payment_text = '<tr bgcolor="'.(($nr % 2 == 0)?$color[0]:$color[1]).'">
<td align="center" style="border-right: 1px solid #000">'.$buffer['ID'].'</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['user_program_id'].'</td>';

if ($_GET['show'] != 'all_recent_logs') { 

$payment_text .= '
<td align="left" style="padding-left: 5px; border-right: 1px solid #000">
<a href="Finduser.php?username='.$buffer['Username'].'&prog='.$buffer['program_id'].'" target="_blank">
'.$buffer['Username'].'</a>
</td>

<td align="left" style="padding-left: 5px; border-right: 1px solid #000">
'.$buffer['collected_by'].'
</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">
<a href="memberlogin.php?id='.$buffer['ID'].'&rd=viewpayment.php?program='.$buffer['program_id'].'" target="_blank">
Login</a>
</td>';

}

$payment_text .= '
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['First_Name'].'</td>
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['Last_Name'].'</td>
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">

<a href="mailto:'.$buffer['email'].'?subject='.$Global['webpage_name'].'%20Follow%20Up%20For%20Username%20'.$buffer['Username'].'&body=Dear%20'.$buffer['First_Name'].',%0D%0A%0D%0A

I hope this email finds you well, and you are getting a lot out of the '.$Global['webpage_name'].' program.%0D%0A%0D%0A

We have reviewed your user account '.$buffer['Username'].' (affiliate link '.$Global['webpage_url'].'?id='.$buffer['Username'].'),%0D%0A%0D%0A


  
Sincerely,
%0D%0A
Admin">'.$buffer['email'].'</a>

</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['program_id'].' '.$buffer['program_name'].'</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$cc_pending_status.'</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['amount'].'</td>
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">

<a href="Finduser.php?username='.$buffer['payer_username'].'&prog='.$buffer['program_id'].'" target="_blank">
'.$buffer['payer_username'].'
</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">
'.$buffer['user_status'].'
</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.date("Y-m-d H:i:s",$buffer['timestamp']).'</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['payment_log_id'].'</td>
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">

<!--
<a href="Viewplan.php?username='.$buffer['payer_username'].'&prog='.$buffer['program_id'].'" target="_blank">
'.$buffer['payment_plan_id'].'
</a>
-->
'.$buffer['payment_plan_id'].'

</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">
<!--
<a href="/ipt/getpayplans.php?u='.$buffer['payer_username'].'&prog='.$buffer['program_id'].'" target="_blank">
'.$buffer['payment_processor'].'
</a>
-->
'.$buffer['payment_processor'].'
</td>

<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['manual_override'].'</td>

<!--
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">

<a href="Payment-Logs.php?do=EditLog&id='.$buffer['ID'].'&log_id='.$buffer['payment_log_id'].'&paid_to='.$buffer['Username'].'&plan='.$buffer['payment_plan_id'].'&prog='.$buffer['program_id'].'&payer='.$buffer['payer_username'].'&amount='.$buffer['amount'].'" target="_blank">Edit</a>
/
<a href="Payment-Logs.php?do=DeleteLog&log_id='.$buffer['payment_log_id'].'&paid_to='.$buffer['Username'].'&plan='.$buffer['payment_plan_id'].'&prog='.$buffer['program_id'].'&payer='.$buffer['payer_username'].'&amount='.$buffer['amount'].'" target="_blank">Flush</a>
 
N/A
</td>
-->
';
echo $payment_text . "</tr>";

			++$nr;
		}	
echo '</table>';

} // END SUBMIT IS TRUE

include './../Inc/Footer.inc.php';
?>