<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('FIND_MEMBER') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

$pageName = 'User Stats';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
include './../Inc/Header.inc.php';

 /*
// LOCKING PAGE FOR DEVELOPER USE ONLY!!
if ((!isset($_GET['dev']) || $_GET['dev'] === '') && (!isset($_SESSION['dev']) || $_SESSION['dev'] === '')) { 
	//include_once './header.php';
	echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
	//include_once './footer.php';
	exit;
} else {
	$_SESSION['dev'] = true;
}
//$GLOBALS['debug'] = true; 
 */
 
$live = 1; // Set to 1 to execute the query, 0 for a dry run 

$program_id = isset($_GET['prog']) ? intval($_GET['prog']) : null;
$ID = isset($_GET['id']) ? intval($_GET['id']) : null;

if (empty($program_id) || empty($ID)) {
	echo 'Missing prog and or id';
    exit;
}

$selectFields = 'program_name, giveaway_file';
$mainTable = 'program';
$where = [
	'AND' => [
		'program_id' => ['=', $program_id]
	]
];
$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

$program_name = $buffer[0]['program_name'];

if ($buffer[0]['giveaway_file'] == 'Mat.give.php') $program_is_matrix = true;
else $program_is_matrix = false;

if ($program_is_matrix == true) { 
	//echo 'prog is mat'; exit;
	// PROGRAM IS MATRIX - NOW WE GET ALL CUSTOM MATRIX SETTINGS
	$usrid = $ID;
	include ''.$_SERVER['DOCUMENT_ROOT'].'/Ipn/Give/Mat.config.inc.php';
}

// FIND OUT IF THEY ARE ACTIVE IN ANY OTHER PROGRAMS!
$selectFields = 'ID';
$mainTable = 'user_program';
$where = [
	'ID' => ['=', $_GET['id']], 
	'program_id' => ['!=', $_GET['prog']],
	'user_status' => ['=', 'Active']
];
$bufferA = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

if (isset($bufferA[0]['ID'])) $active_in_other_program = true;
else $active_in_other_program = false;

$datetime = date("Y-m-d H:i:s");

//echo '<strong>User Information:</strong> <br>';

// GET MEMBERS TABLE STATS
$selectFields = ['*'];
$mainTable = 'members';
$where = [
	'AND' => [
		'ID' => ['=', $ID]
	]
];
$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

echo '<h2>'.$buffer[0]['First_Name'].' '.$buffer[0]['Last_Name']; 
echo ' (<a href="Finduser.php?username='.$buffer[0]['Username'].'">'.$buffer[0]['Username'].'</a>)</h2>';
echo 'member status: '.$buffer[0]['Status'].'<br>';

$username = $buffer[0]['Username'];

//$debug = true;

if (isset($_GET['status'])) { 

	// UPDATE UPROG TO NEW STATUS!
	$updateData = [
		'user_status' => $_GET['status']
	];
	$where = ['ID' => ['=', $_GET['id']], 'program_id' => ['=', $_GET['prog']]];
	update('user_program', $updateData, [], $where, $live, 1, 1);
	
	// WE UPDATE CANCELLED TIME BELOW!

	if (isset($_GET['status']) && ($_GET['status'] == 'Active' || $_GET['status'] == 'Comped')) {
		
		$updateData = ['end_program' => 'N'];
		update('user_program', $updateData, [], $where, $live, 1, 1);
		
		// MAKE THEM ACTIVE IN MATRIX ALSO (ONLY IF THEY ARE ALREADY THERE)!
		$data = [
			'active' => 'Y'
		];
		$where = [
			'usrid' => ['=', $_GET['id']],
			'matlevel' => ['=', $_GET['prog']]
		];
		update('matrix', $data, [], $where, $live, 1, 1);

		$status = 'paid';
	
	} else if (isset($_GET['status']) && $_GET['status'] == 'Unpaid') {
		
		// RESET UPROG RECORD
		$updateData = ['sign_id' => 0, 'user_qualify' => 0, 'user_qualify_perm' => 0, 'started' => 0, 'expire' => null, 'payment_period' => 0];
		$where = ['ID' => ['=', $_GET['id']], 'program_id' => ['=', $_GET['prog']]];		
		update('user_program', $updateData, [], $where, $live, 1, 1);

		// DELETE ALL COMMS THEY GENERATED FOR THEIR UPLINES		
		$table = 'transactions_log';
		$where = [
			'description' => ['LIKE', '%' . $username]
		];
		
		if ($program_is_matrix == true) {
			// THIS IS NEEDED TO RESTRICT DELETIONS TO ONLY THE ONE PROGRAM!
			// SUPPORTING NON MATRIX PROGRAMS ALSO, BY EXCLUDING THIS COND, WHEN NOT APPROPRIATE
			$where['transactions_log.description'] = ['LIKE', '%' . $GLOBALS['mat_config'] . '%'];
		}	
		
		$limit = 0; // DELETING ALL LOGS BY PROGRAM
		$show_debug = 1;

		// Execute the delete query
		delete($table, [], $where, null, $live, $limit, $show_debug);
		
		// DELETE ALL PAYMENTS THEY MADE TO BUY INTO THIS PROGRAM
		//$debug = TRUE;
		//$live = 0;
		$where = [
			'usrid' => ['=', $_GET['id']]
		];		
		$where['transactions_log.description'] = ['LIKE', 'Payment for ' . $program_name];
		
		// Execute the delete query
		delete($table, [], $where, null, $live, $limit, $show_debug);	
		
		$where = [
			'usrid' => ['=', $_GET['id']],
			'matlevel' => ['=', $_GET['prog']] 
		];
		delete('matrix', [], $where, null, $live, 1, 1);
		
		// FIND OUT IF THEY ARE ACTIVE IN ANY OTHER PROGRAMS!
		$selectFields = 'user_program_id';
		$mainTable = 'user_program';
		$where = [
			'ID' => ['=', $_GET['id']], 
			'program_id' => ['=', $_GET['prog']]
		];
		$bufferB = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

		$user_program_id = $bufferB[0]['user_program_id'] ?? 0;		

		if (true) {
			// DOING CLEAN UP OF PLANS
			// FLUSH ALL PRIOR TEMP UPPs, WITH ASSOCIATED PPs NEVER PAID
			// DOES NOT TOUCH HISTORY UPPs, STARTED PLANS OR ANY PAID PAYMENT PLANS (SINCE valid_plan IS 'N')!!
			// GET UPP MASTER PAY PLAN!
			$selectFields = 'master.user_payment_plan_id, master.valid_plan';
			$mainTable = ['table' => 'user_payment_plan', 'as' => 'master'];
			$joinConditions = []; // Assuming no joins needed as per original code
			$where = [
					'master.user_program_id' => ['=', $user_program_id] // GET ONLY THIS USER, IN THIS PROGRAM
			];

			$orderBy = 'master.valid_plan ASC';
			$limit = 100;
			$resultmp = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, $limit, 1);

			foreach ($resultmp as $buffermp) {
				$whereDelete = ['user_payment_plan_id' => ['=', $buffermp['user_payment_plan_id']]]; 	
				delete('payment_plan', [], $whereDelete, null, 1, 0, 1);
				delete('user_payment_plan', [], $whereDelete, null, 1, 1, 1);
			}
		} // END CLEAN UP		
		
		// delete payment log
		$whereDelete = [
			'payer_username' => ['=', $username],
			'program_id' => ['=', $_GET['prog']]
			]; 			
		delete('payment_log', [], $whereDelete, null, 1, 0, 1);
		
		$status = 'unpaid';
	
	} else if (isset($_GET['status']) && ($_GET['status'] == 'Cancelled')) {
		
		$updateData = ['date_cancelled' => $datetime, 'cancelled_by' => 'admin'];
		$where = ['ID' => ['=', $_GET['id']], 'program_id' => ['=', $_GET['prog']]];
		update('user_program', $updateData, [], $where, $live, 1, 1);		
		
		// CANCEL THEM IN MATRIX ALSO!
		$data = [
			'active' => 'N'
		];
		$where = [
			'usrid' => ['=', $_GET['id']],
			'matlevel' => ['=', $_GET['prog']]
		];
		update('matrix', $data, [], $where, $live, 1, 1);
		
		$status = $_GET['status'];
			
	}
 
	// SET MEMBERS TABLE STATUS ALSO!
	$updateData = [
		'Status' => $status
	];
	if ($status == 'Unpaid' && $active_in_other_program == false) $updateData['user_credits'] = ['=', 0];	
	
	$where = ['ID' => ['=', $_GET['id']]];
	
	if ($status == 'unpaid' && $active_in_other_program == true) {
		// THIS MEMBER SHOULD HAVE PAID STATUS - FOR THE OTHER PAID PROGRAM!
		// THEY SHOULD ALREADY HAVE IT, BUT KEEPING THIS HERE, AS SAFE GUARD ANYWAY
		$updateData = [
			'Status' => 'paid'
		];		
		update('members', $updateData, [], $where, $live, 1, 1);
		
	} else if ($status == 'unpaid' && $active_in_other_program == false) {
		$updateData = [
			'Status' => 'unpaid'
		];
		$updateData['user_credits'] = ['=', 0];
		update('members', $updateData, [], $where, $live, 1, 1);
		
	} else if ($status == 'Cancelled' && $active_in_other_program == false) {
		$updateData = [
			'Status' => 'Cancelled'
		];			
		update('members', $updateData, [], $where, $live, 1, 1);	
	
	} else if ($status == 'paid') {
		$updateData = [
			'Status' => 'paid'
		];			
		update('members', $updateData, [], $where, $live, 1, 1);		
	} // END MEMBERS TABLE STATUS UPDATES!
	echo '<h2>is now '.$_GET['status'].' in program '.$_GET['prog'].'!</h2>';
	
	//include './../Inc/Footer.inc.php';
	//exit;
} // END UPDATES!

// GET UPROG STATS
$selectFields = ['ID', 'user_program_id', 'program_id', 'user_status', 'sponsorid', 'started', 'expire', 'payment_period', 'date_suspended', 'date_cancelled', 'suspended_by', 'cancelled_by'];
$mainTable = 'user_program';
$where = [
	'AND' => [
		'program_id' => ['=', $program_id],
		'ID' => ['=', $ID]
	]
];
$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

//print_r($buffer[0]);
if (isset($buffer[0]) && is_array($buffer[0])) {
    foreach ($buffer[0] as $key => $value) {
		//if ($key === 'date_suspended' || $key === 'date_cancelled') continue;
		if ($buffer[0]['user_status'] != 'Suspended' && $key === 'date_suspended') continue;
		if ($buffer[0]['user_status'] != 'Cancelled' && $key === 'date_cancelled') continue;

		if ($key === 'suspended_by' && $value == '') continue;
		if ($buffer[0]['user_status'] != 'Suspended' && $buffer[0]['user_status'] != 'Cancelled' && $key === 'date_suspended') continue;
		
		if ($key === 'cancelled_by' && $value == '') continue;
		if ($buffer[0]['user_status'] != 'Cancelled' && $key === 'date_cancelled') continue;
		
        if (($key === 'started' || $key === 'expire') && !empty($value)) {
            // Assuming $value is a Unix timestamp
            if ($value != '00-00-00 00:00:00') echo htmlspecialchars($key) . ': ' . date('Y-m-d H:i:s', $value) . '<br>';
        } else {
            echo htmlspecialchars($key) . ': ' . htmlspecialchars($value) . '<br>';
        }
    }
} else {
    echo 'No uprog data found!<br>';
}

// FOR TESTING ONLY
//$buffer[0]['user_status'] = 'Cancelled';

if ($buffer[0]['user_status'] == 'Suspended') $susp_or_canc = 'Suspended on '.$buffer[0]['date_suspended'];
if ($buffer[0]['user_status'] == 'Cancelled') $susp_or_canc = 'Cancelled on '.$buffer[0]['date_cancelled'];

if (isset($susp_or_canc)) echo $susp_or_canc;
echo '<hr>';

if ($program_is_matrix == true) $mat_desc = 'matrix';
else $mat_desc = '';
?>
<h3>
If you need to create payment logs and commissions,<br>you should mark the user paid.</h3>
<a href="/admin/Sub/memberlogin.php?id=1&prd=apay/pay.php?uname=<?php echo $username; ?>&program=<?php echo $_GET['prog']; ?>" class="btn btn-success btn-lg"><span class="fa fa-money"></span> Mark The User Paid</a>

<br><br>
<h3>If you need to re-instate a user, use Make User Active, below.</h3>

<a href="User_stats.php?id=<?php echo $_GET['id']; ?>&prog=<?php echo $_GET['prog']; ?>&status=Active" class="btn btn-lg btn-success">Make User Active</a>

<a href="User_stats.php?id=<?php echo $_GET['id']; ?>&prog=<?php echo $_GET['prog']; ?>&status=Comped" class="btn btn-lg btn-warning">Make User Comped</a>

<a href="User_stats.php?id=<?php echo $_GET['id']; ?>&prog=<?php echo $_GET['prog']; ?>&status=Cancelled" class="btn btn-lg btn-danger">Make User Cancelled</a>

<a href="User_stats.php?id=<?php echo $_GET['id']; ?>&prog=<?php echo $_GET['prog']; ?>&status=Unpaid" onclick="return confirm('////////////////////////////////////////////////////////////////////////////\n\nATTENTION!!!\n\nIf you reset this user to unpaid, this will delete all commissions they have generated in this program, for ALL their <?php echo $mat_desc; ?> uplines.')" class="btn btn-lg btn-danger">Make User Unpaid (Reset)</a>


<br><br>
* NOTE - To reset a user will delete them from this <?php echo $mat_desc; ?> program, and remove all comms they generated for their uplines (in all programs), from the beginning of time.
<br><br>
* NOTE If you reset a user who has paid ref's in the <?php echo $mat_desc; ?> program, they will become orphaned with no upline!</br>
So in such cases, all those users will need to be reset as well.
<hr>
<?php
$user_program_id = $buffer[0]['user_program_id'];

// SELECT THE USER PAYMENT PLAN ///////////////////////////////////////////////////////////////////
// Prepare select fields, conditions, and order by parameters
$selectFields = ['user_payment_plan_id', 'valid_plan', 'real_sponsorid'];
$mainTable = 'user_payment_plan';
$where = [
    'user_program_id' => ['=', $user_program_id],
];
//$orderBy = 'valid_plan ASC, user_payment_plan_id DESC';
// THIS WORKS, BUT NOT ORDER WE WANT
//$orderBy = "FIELD(valid_plan, 'Y', 'S', 'H', 'N'), user_payment_plan_id DESC";
$orderBy = "user_payment_plan_id DESC"; // NO GOING WITH MOST RECENT FIRST!
$limit = 5;

// Use PHPCPR's select function
$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
$buffer = isset($result[0]) ? $result[0] : null;

echo '<h3>User Payment Plan</h3>';

if (isset($buffer) && is_array($buffer)) {
    foreach ($buffer as $key => $value) {
        if (($key === 'first_paid_date' || $key === 'last_paid_date') && !empty($value)) {
            // Assuming $value is a Unix timestamp
            echo htmlspecialchars($key) . ': ' . date('Y-m-d H:i:s', $value) . '<br>';
        } else {
            echo htmlspecialchars($key) . ': ' . htmlspecialchars($value) . '<br>';
        }
    }
} else {
    echo 'No upp data found.<br>';
}

$user_paymentplan_id = $buffer['user_payment_plan_id'];

// SELECT ALL THE PAYMENT PLANS ////////////////////////////////////////////////////////////////
// Prepare select fields, join conditions, and order by parameters
$selectFields = 'pp.*, m.payment_collected_by';
$mainTable = ['table' => 'payment_plan', 'as' => 'pp'];
$joinConditions = [
    [
        'table' => 'members',
        'as' => 'm',
        'condition' => 'pp.username = m.Username'
    ]
];
$where = [
    'pp.user_payment_plan_id' => ['=', $user_paymentplan_id]
];
$orderBy = "pp.payment_plan_id DESC";

// Use PHPCPR's select function
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, 1);

foreach ($result as $buffer) {
	echo '<h3>Payment Plan</h3>';

	if (isset($buffer) && is_array($buffer)) {
		foreach ($buffer as $key => $value) {
			if (($key === 'started' || $key === 'expire') && !empty($value)) {
				// Assuming $value is a Unix timestamp
				echo htmlspecialchars($key) . ': ' . date('Y-m-d H:i:s', $value) . '<br>';
			} else {
				echo htmlspecialchars($key) . ': ' . htmlspecialchars($value) . '<br>';
			}
		}
	} else {
		echo 'No pp data found.<br>';
	}
	echo '<hr>';
}

// SELECT ALL THE PAYMENT LOGS ////////////////////////////////////////////////////////////////
// Prepare select fields, join conditions, and order by parameters
$selectFields = 'log.*';
$mainTable = ['table' => 'payment_log', 'as' => 'log'];
$joinConditions = [];
$where = [
    'log.payer_username' => ['=', $username],
	'log.program_id' => ['=', $_GET['prog']]
];
$orderBy = "log.payment_log_id DESC";

// Use PHPCPR's select function
$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, 1);

echo '<h3>Payment Logs</h3>';

if (!empty($result) && is_array($result)) {
    foreach ($result as $row) { // Iterate over each row in the result
        if (is_array($row)) {
            foreach ($row as $key => $value) { // Iterate over each key-value pair in the row
                if (($key === 'timestamp') && !empty($value)) {
                    // Assuming $value is a Unix timestamp
                    echo htmlspecialchars($key) . ': ' . date('Y-m-d H:i:s', $value) . '<br>';
                } else {
                    echo htmlspecialchars($key) . ': ' . htmlspecialchars($value) . '<br>';
                }
            }
            echo '<br>'; // Optionally add a break after each row for better readability
        }
    }
} else {
    echo 'No payment log data found.<br>';
}

?>


<?php 
include './../Inc/Footer.inc.php';
?>
