<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('FIND_MEMBER') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
}

//error_reporting(-1);
//$_SESSION['debug'] = true;
$error_msg = '';

//$datetime = date("Y-m-d H:i:s");
$submit='Submit';
$downline_builder_id = ''; 
if (isset($_REQUEST['downline_builder_id'])) $downline_builder_id = $_REQUEST['downline_builder_id'];  

/*
CREATE TABLE IF NOT EXISTS `downline_builder` (
  `downline_builder_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` VARCHAR(100) NOT NULL,
  `program_id` INT(11), 
  `url` varchar(50) NOT NULL,
  `notes` text(2000) NOT NULL,
  `priority` INT(11) NOT NULL,
PRIMARY KEY (`downline_builder_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1

CREATE TABLE IF NOT EXISTS `downline_builder_member` (
  `idx` int(11) NOT NULL AUTO_INCREMENT,
  `downline_builder_id` int(11) NOT NULL,
  `ID` int(11) NOT NULL,   
  `affid` varchar(50) NOT NULL,
PRIMARY KEY (`idx`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1

CLICK MAGICK PIXEL TRACING CODES RESIDE IN (P2P SITE):
The pixels now fire on these pages inside html areas, where they need to be:
/index.php (end of page) -> lead action 'e'
/Members/index.php (end of page) -> join action 'a'
These 2 actions above rely on the URL string trigger_pixel=Y which is only set prior to a lead sign up and a join. If the user should refresh the page, it may trigger more than once, other than that, it will only trigger as needed.
/apay/processmember.php -> conversion action 's' -> This one only triggers when a sponsor marks their downline paid.
*/

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//$_SESSION['UserID'] = 81; // FOR TESTING ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */

$insert = false;
$update = false;

if ($downline_builder_id != '') {
	
if (isset($_GET['del']) && $_GET['del'] == 'Y' && isset($_GET['confirmed']) && $_GET['confirmed'] == 'Y') {
		$deleteConditions = ['downline_builder_id' => $downline_builder_id];
		$result = delete('downline_builder', [], $deleteConditions, 1, 1);
		
		
		//echo 'The record has been deleted! <a href="downline-builder.php">Click here to refresh now.</a>';
		$error_msg = 'Success! The record has been deleted!';
	} else if (isset($_GET['del']) && $_GET['del'] == 'Y' && (!isset($_GET['confirmed']) || $_GET['confirmed'] != 'Y')) {
		echo '<h1 style="text-align:center">Are you sure? <a href="downline_builder.php?downline_builder_id='.$downline_builder_id.'&del=Y&confirmed=Y">Yes delete it!</a>';
		echo '<br/><a href="downline_builder.php">Cancel this action</a></h1>';
		exit;	
	}

	$selectFields = '*';
	$mainTable = 'downline_builder';
	$where = ['downline_builder_id' => $downline_builder_id];

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	
	$buffer = !empty($result) ? $result[0] : null;	

	if (empty($result)) {
		//$error_msg = 'No record found!';
		$insert=true;
	} else {
		$insert=false;
	}
} else {
	$insert=true;
}	


if (!empty($_POST['action'])) {
	
	$name = $_POST['name'];
	$selectFields = '*';
	$mainTable = 'downline_builder';
	$where = ['name' => $name];

	$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);
	$buffer2 = !empty($result2) ? $result2[0] : null;

	if (empty($_POST['name'])) {
		$error_msg = 'Please fill out the name.';
	} else if ($_POST['name'] != (preg_replace("/[^A-Za-z0-9]/", '', $_POST['name']))) {
		$error_msg = 'Please choose a valid name.  Only alphanumeric (letters and numbers) are allowed.';
	}
	// ALLOWING DUPLICATE NAMES (ONLY FOR CLICK MAGICK, WHICH HAS AFF LINKS, AND ALSO TRACKING IDS)
	// SO ALL OTHER CASES WILL REQUIRE A UNIQUE NAME, TO AVOID CONFUSION
	else if ($insert == true && $_POST['name'] == $buffer2['name'] && $_POST['name'] != 'ClickMagick') {
		$error_msg = 'This name already exists!';
	}	
	if ($_POST['description'] == 'My Tracking ID' && $_POST['url'] != '') { 
		$error_msg = 'You cannot have a URL with a "My Tracking ID" listing.';
	}	
		
	if ($_POST['description'] == 'My Custom Link' && $_POST['url'] != '') {
		$error_msg = 'You cannot have a URL with a "My Custom Link" listing.<br/>Add the URL to your admin profile for this listing instead.';
	}	

	if (is_numeric($_POST['program_id'])) {
	} else {
		$error_msg .= 'Please input a valid program id number.<br />';
	}
	if (is_numeric($_POST['priority'])) {
	} else {
		$error_msg .= 'Please input a valid priority (any number).<br />';
	}	
	
	if (empty($error_msg)) {

		if ($insert!=true) {
			
			$update = true;

			$data = [
				'name' => $_POST['name'],
				'description' => $_POST['description'],
				'url' => $_POST['url'],
				'notes' => $_POST['notes'],
				'program_id' => $_POST['program_id'],
				'priority' => $_POST['priority']
			];

			$where = ['downline_builder_id' => $downline_builder_id];

			$result = update('downline_builder', $data, [], $where, 1, 1, 1);

		//$error_msg = 'The record has been updated! <a href="downline_builder.php">Click here to refresh now.</a>';
		$error_msg = 'Success! The record has been updated!';
		
		} else {

			$insertData = [
				'name' => $_POST['name'],
				'description' => $_POST['description'],
				'url' => $_POST['url'],
				'notes' => $_POST['notes'],
				'program_id' => $_POST['program_id'],
				'priority' => $_POST['priority']
			];

			insert('downline_builder', $insertData, 1, 1);
			$error_msg = 'Success! The new record has been created!';

			$selectFields = '*';
			$mainTable = 'downline_builder';
			$where = ['name' => $_POST['name']];
			$orderBy = 'downline_builder_id DESC';
			$limit = 1;

			$result3 = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, 1);
			//$buffer3 = $result3[0] ?? null; // 8.2
			$buffer3 = !empty($result3) ? $result3[0] : null; // 5.6
			$downline_builder_id = $buffer3 ? $buffer3['downline_builder_id'] : null;

		
		}
	}
	//echo $error_msg;	
} // END POST UPDATE
//else { // WE ARE NOT POSTING AN UPDATE - SHOW THE FIELDS!

if (isset($buffer)) {
	if (!isset($_REQUEST['downline_builder_id']) || $_REQUEST['downline_builder_id'] == '') {
		$_REQUEST['downline_builder_id'] = $buffer['downline_builder_id'];
		$downline_builder_id = $buffer['downline_builder_id'];
	}
	if (!isset($_REQUEST['name']) || $_REQUEST['name'] == '') {
		$_REQUEST['name'] = $buffer['name'];
	}
	if (!isset($_REQUEST['description']) || $_REQUEST['description'] == '') {
		$_REQUEST['description'] = $buffer['description'];
	}
	if (!isset($_REQUEST['url']) || $_REQUEST['url'] == '') {
		$_REQUEST['url'] = $buffer['url'];
	}
	if (!isset($_REQUEST['notes']) || $_REQUEST['notes'] == '') {
		$_REQUEST['notes'] = $buffer['notes'];
	}
	if (!isset($_REQUEST['program_id']) || $_REQUEST['program_id'] == '') {
		$_REQUEST['program_id'] = $buffer['program_id'];
	}
	if (!isset($_REQUEST['program_id']) || $_REQUEST['program_id'] == '') {
		$_POST['program_id'] = 0;
	}
	if (!isset($_REQUEST['priority']) || $_REQUEST['priority'] == '') {
		$_REQUEST['priority'] = $buffer['priority'];
	}
}	
	
// DONE WITH $buffer - MAY INCLUDE HEADER NOW!	
include './../Inc/Header.inc.php';
echo '<h1>Downline Builder Manager</h1>';
echo '<H2>'.$error_msg.'</h2>';	
/*
	echo $buffer['downline_builder_id'];
	echo $buffer['
	url'];
	echo $buffer['name'];
	echo $buffer['notes'];
	
	echo $buffer['downline_builder_id'];
	echo $buffer['url'];
	echo $_POST['name'];
	echo $buffer['notes'];
*/
//} // END WE ARE NOT POSTING AN UPDATE

//if ($_GET['del']!='Y') {
?>



<div style="text-align:center">

<p>

</p>

<form method="post" action="downline_builder.php" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

<input type="hidden" name="action" value="save">
<input type="hidden" name="downline_builder_id" value="<?php echo $downline_builder_id;?>">

<table style="width: 600px; margin: auto;" cellpadding="5" cellspacing="10" >

<tr>
	<td style="vertical-align:middle; width: 50%; margin: right;">

					Name (required - no spaces!):</td>

					<td style="width: 50%; margin: left;">

				<input class="form-control" onMouseover="this.focus()" size="25" name="name" value="<?php if(isset($_REQUEST['name'])) : echo $_REQUEST['name']; else : echo ''; endif; ?>" placeholder="Name">
	</td>
</tr>

<tr>
	<td style="vertical-align:middle; width: 50%; margin: right;">

					Description (required):</td>

					<td style="width: 50%; margin: left;">
<!-- FORM FIELD IDEA - MORE FLEXIBLE, BUT REQUIRES MORE WORK / CONFUSION FOR ADMINS, SO AXING THIS IDEA IN FAVOR OF DROP DOWN LIST
				<input class="form-control" onMouseover="this.focus()" size="25" name="description" value="<?php if(isset($_REQUEST['description'])) : echo $_REQUEST['description']; else : echo ''; endif; ?>" placeholder="My Affiliate ID or My Username or My Tracking ID">
-->				
			<select onMouseover="this.focus()" size="" name="description" class="form-control">

				<option value="My Affiliate ID" <?php if ($_POST['description'] == 'My Affiliate ID') echo "selected"; ?>>My Affiliate ID</option>	

				<option value="My Affiliate Username" <?php if ($_POST['description'] == 'My Affiliate Username') echo "selected"; ?>>My Affiliate Username</option>

				<option value="My Tracking ID" <?php if ($_POST['description'] == 'My Tracking ID') echo "selected"; ?>>My Tracking ID</option>
				
				<option value="My Custom Link" <?php if ($_POST['description'] == 'My Custom Link') echo "selected"; ?>>My Custom Link</option>				

			</select>	
				
	</td>
</tr>


<tr>
	<td style="vertical-align:middle; width: 50%; margin: right;">

					URL (optional): </td>

					<td style="width: 50%; margin: left;">

				<input class="form-control" onMouseover="this.focus()" size="25" name="url" value="<?php if(isset($_REQUEST['url'])) : echo $_REQUEST['url']; else : echo ''; endif; ?>" placeholder="URL Address">
	</td>
</tr>

<tr>
	<td style="vertical-align:middle; width: 50%; margin: right;">

					Notes (optional):</td>

					<td style="width: 50%; margin: left;">
				
<textarea class="form-control" onMouseover="this.focus()" name="notes" placeholder="Enter upsell text here" rows="10" cols="50"><?php echo isset($_REQUEST['notes']) ? $_REQUEST['notes'] : ''; ?></textarea>
				
	</td>
</tr>

<tr>
	<td style="vertical-align:middle; width: 50%; margin: right;">

					Required Program ID (optional):</td>

					<td style="width: 50%; margin: left;">

				<input class="form-control" onMouseover="this.focus()" size="25" name="program_id" value="<?php if(isset($_REQUEST['program_id'])) : echo $_REQUEST['program_id']; else : echo ''; endif; ?>" placeholder="If none, leave empty">
	</td>
</tr>

<tr>
	<td style="vertical-align:middle; width: 50%; margin: right;">

					Priority (optional):</td>

					<td style="width: 50%; margin: left;">

				<input class="form-control" onMouseover="this.focus()" size="25" name="priority" value="<?php if(isset($_REQUEST['priority'])) : echo $_REQUEST['priority']; else : echo ''; endif; ?>" placeholder="Enter a number here">
	</td>
</tr>

<tr>

<td colspan="2">
<div style="text-align:center">

				<input class="btn btn-success" type="submit" value="<?php echo $submit; ?>" name="submit" id="submit">
</div>
</td>
</tr>
</table>
</div>
<p>&nbsp;</p>
</form>

<?php
//} // NOT DELETING 
//} // END ACTION IS NOT "SAVE"
//if ($error_msg != '') echo $error_msg;

$selectFields = '*';
$mainTable = 'downline_builder';

if (($insert == true || $update == true) && $downline_builder_id != '') {
	$where = ['downline_builder_id' => $downline_builder_id]; // Add your conditions here
} else {
	$where = ['1'];
}	
$orderBy = 'priority DESC, downline_builder_id DESC';

$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, 0, 1);

if (count($result) < 1) {
	//echo '<h2>No records</h2>';		
} else {	
	echo '<h2>Downline Builder Records:</h2><br/>';
	 foreach ($result as $buffer) {
	?>
	
	<table style="width: 600px; margin: auto;" cellpadding="5" cellspacing="10" >
	<tr><td style="text-align:center">
	<a href="downline_builder.php?downline_builder_id=<?php echo $buffer['downline_builder_id'];?>" target="_self"><?php echo $buffer['name']; ?></a> | 

	
	Notes:  <?php echo $buffer['notes'].' <a href="downline_builder.php?del=Y&downline_builder_id='.$buffer['downline_builder_id'].'" target="_self">Delete</a><br/>&nbsp;';
	?>
	<br/><b>LINKS</b> (open new windows)
	<form><input class="form-control" onMouseover="this.focus(); this.select();" size="25" name="linkname" value="<?php echo $Global['webpage_url'].'Members/profile-downline-builder.php?name='.$buffer['name']; ?>"></form>
<br/>
	<a href="<?php echo $Global['webpage_url'].'Members/profile-downline-builder.php?name='.$buffer['name']; ?>" target="_blank"><?php echo $Global['webpage_url'].'Members/profile-downline-builder.php?name='.$buffer['name']; ?></a>
	<br/><br/>
	<a href="memberlogin.php?id=2&rd=profile-downline-builder.php?name=<?php echo $buffer['name']; ?>" target="_blank">Login as member</a> | 
	<a href="memberlogin.php?id=1&rd=profile-downline-builder.php?name=<?php echo $buffer['name']; ?>" target="_blank">Login as admin</a> 
	</td></tr></table>
	<hr>
<?php	
	} 
}
//if ($sql != '1') 
	echo '<a href="downline_builder.php" class="btn btn-info">Show All Programs</a>';

//} // END ACTION IS NOT "SAVE"
?>
<br/>
<h1>
How to use:</h1> In the name field, list the name of the third party affiliate program you wish to promote. Use alphanumeric (number letters only, no spaces), as this will also serve as a way to link to this information.
<br/><br/>
Let's say your username in this program is "cashflow". Your URL might look something like this:
https://domain.com/?id=cashflow or perhaps this: http://cashflow.domain.com.
<br/><br/>
So when you add your URL above, simply replace your username with this tag [AFFID]. So for example, the above links would become https://domain.com/?id=[AFFID] or http://[AFFID].domain.com.

<br/>

<!--
<br/><mark>
If adding a supported tracking system, such as "ClickMagick", leave the URL empty, and set Description to "My Tracking ID". Do not edit these Name or Description values (for ClickMagick - they are used in the tracking codes)!
</mark>
-->

 
<br/>All other names and descriptions may be changed anytime. But remember, if you have linked to it already by name, you will need to update your links!

<br/><br/>
When creating a custom link, (using Description "My Custom Link", the Notes should be something like: "You may enter any link you wish here. It will be shown to your direct team members.", without the quotes.

<br/><br/><mark>
When Description is set to "My Tracking ID" or to "My Custom Link", is the ONLY time the URL should be empty!</mark><br/><br/>
<mark>
Custom links should be named something like "RecommendedProgram", "RecommendedProgram2", etc. DO NOT use "YourSponsorsRecommendation" as this needs to change, when the user adds their own custom link.
</mark>

<br/><br/>
<mark>
The notes section is what will show up to your members to upsell them on this program, so be creative, to get them to take action. Notes supports 50,000 characters.
</mark>

<br/><br/>

If members should be required to be in a chosen program, to update their downline builder program, then list that program ID as the "Required Program ID". Otherwise, leave this set to "0".

<br/><br/>
Higher numbered priorities will be shown first. This allows you to easily re-order the downline programs anytime. Numbers do not need to be sequential.
<br/><br/>
You may add as many programs as you like, but remember once you add any program here, you must then ALSO <a href="memberlogin.php?id=1&rd=profile-downline-builder.php" target="_blank">login as admin</a> to add your affiliate ID or username for that same program, to the admin profile's downline builder.
<br/>This is vital so your members will join these programs user you, if their sponsor is not in the program.
<br/><br/>
To edit any program above, simply click on the program name, make desired changes, then click "Submit".


<?php
include './../Inc/Footer.inc.php';
?>