<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include_once '../../Sub/Config.inc.php';
include_once '../../phpcpr.php';

$user = $_GET['user'];

// SHOW DATE, IP WHEN REGISTERED
$selectFields = 'First_Name, Last_Name, Signdate, ip';
$mainTable = 'members';
$where = [
    'Username' => ['=', $user]
];
$limit = 1; // Assuming you're fetching a single record based on Username
$show_debug = 1;

// Execute the query using the PHPCPR select function
$buffer = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);

if (!empty($buffer)) {
    $buffer = $buffer[0]; // Get the first (and expectedly, only) row
} else {
    die('Error or no results found.');
}


echo '<h2>'.$buffer['First_Name'].' '.$buffer['Last_Name']. ' (Username: '.$user.') Registered On '.$buffer['Signdate'].' From IP Address: '.$buffer['ip'].' </h2><hr>';

if ($_GET['cross_ref'] == '') echo '<h2><a href="login-logs.php?user='.$user.'&cross_ref=admin_logs">Cross reference Login IPs with Admin Login Logs</a> (may be time consuming) </h2><hr>';

if ($_GET['cross_ref'] == 'admin_logs') {
	$selectFields = '*';
	$mainTable = 'member_log'; 
	$where = [
		'log_login_username' => ['=', $user]
	];
	$orderBy = 'member_log_id DESC';
	$limit = 100;
	$show_debug = 1;

	// Execute the query using the PHPCPR select function
	$result = select($selectFields, $mainTable, [], $where, null, null, $orderBy, $limit, $show_debug);
	$count = 0;
	$match_found = false;
	foreach ($result as $buffer) {

		$count++;
		$ip = '';
		$ip = $buffer['log_ip'];
		$selectFields = '*';
		$mainTable = 'admin_log';
		$where = [
			'log_ip' => ['=', $ip]
		];
		$limit = 1; // Assuming you want to fetch only one record, similar to mysql_fetch_assoc
		$show_debug = 1;

		$result = select($selectFields, $mainTable, [], $where, null, null, null, $limit, $show_debug);
		$buffer2 = isset($result[0]) ? $result[0] : null;

		
		if ($buffer2['admin_log_id'] != '') {
			//echo "We have a match! '.$buffer['log_ip'].' from '.$buffer['log_login_username'].' exists in admin logs!&nbsp;";
			if ($buffer2['log_login_success'] == 1) {
				echo '<h1>SUCCESSFUL LOGIN!</h1>';
				print_r($buffer2);
				echo '<br><br>';
			} else {
				echo '<h2>UNSUCCESSFUL LOGIN</h2>';
			}
			$match_found = true;
		}
	}
	echo '<h2>'.$count.' member logins</h2>';
	if ($match_found == false) echo '<h2>No matches found in admin logs</h2>'; 	
	echo '<hr>';
}
// SHOW ALL LOGIN ATTEMPTS		
$selectFields = 'log.*, m.First_Name, m.Last_Name';
$mainTable = ['table' => 'member_log', 'as' => 'log'];
$joinConditions = [
    ['table' => 'members', 'as' => 'm', 'condition' => 'log.log_login_username = m.Username']
];
$where = [
    'm.Username' => ['=', $user]
];
$orderBy = 'log.log_time DESC';
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, null, null, $orderBy, 0, $show_debug);
$rows = is_array($result) ? count($result) : 0;

if ($rows != 0) { 
    foreach ($result as $buffer) {
		
		if ($buffer['log_login_success'] == 0) $login = '<span style="color:red; font-weight:bold">NO</span>';
		else $login = '<span style="color:green; font-weight:bold">YES</span>';	
		
		$row++; 
		if ($row < 2) {	
			echo '<h2>Login Attempts for '.$buffer['First_Name'].' '.$buffer['Last_Name']. ' (Username: '.$user.')</h2>';
		}
		echo 'Date: '.$buffer['log_time'].'<br/>';
		echo 'Successful Login: '.$login.'<br/>';	
		echo 'IP Address: <span style="font-weight:bold">'.$buffer['log_ip'].'</span><br/>';
		echo 'DNS: '.$buffer['log_dns'].'<br/>';
		echo 'User Agent: '.$buffer['log_user_agent'].'<br/>';
			
		//echo '<a href="Viewplan.php?id='.$buffer['ID'].'&prog='.$buffer['program_id'].'" target="_blank">'.$buffer['ID'].'</a><br />';
		//echo '<a href="Finduser.php?username='.$buffer['Username'].'" target="_blank">'.$buffer['ID'].'</a><br />';
		echo '<hr>';
	}
} else {
	echo '<h2>No login records exist for user: '.$user.'</h2>';
}	
//echo '<br/><br/>';

?>