<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
session_start();
set_time_limit(0); //Make sure it will not expire before its complete
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';
if ($loggedUser->checkPermisson('PAYMENT') === false) {
    $errorMessage = 'You are not allowed to access this page.';
    require_once('./../Inc/error.php');
    exit();   
}

//$debug = false;
//$debug = true;
 /* // COMMENT WHEN TESTING IS DONE!!!
if ($_GET['dev'] == '' && $_SESSION['dev'] == '') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
include './../Inc/Header.inc.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
include './../Inc/Footer.inc.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */

// QQQ
// ALLOWS ADMIN TO RESET ALL WITHDRAWAL REQUESTS BACK TO PENDING FOR EASY TESTING!
//$test_mode = true;
$test_mode = false;


// DOES COMPANY ALLOW PAYOUTS VIA THESE METHODS? // NOW SET IN CONFIG FILE!
// INITITALIZE VARS
$use_check = false;
$use_stp = false;
$use_paypal = false;
$use_bitcoin = false;
$use_bitcoin = true; // QQQ OVERRIDE FOR MTP!! - SHUT OFF IN PROFILE, BUT STILL HAVE PENDING TO DO HERE!
$use_bank_account = false;
$use_cashapp = false;
$use_zelle = false;

$tax_id_value = '';
$cashapp_value = '';
$zelle_value = '';
$tax_id_header = '';
$cashapp_header = '';
$zelle_header = '';

$_SESSION['cutoff_date'] = date("Y-m-d H:i:s");

if (in_array("check", $Global['withdrawal_options_array'])) {
	$use_check = true;
}
if (in_array("bank", $Global['withdrawal_options_array'])) {
	$use_bank_account = true;
}
if (in_array("stp", $Global['withdrawal_options_array'])) {
	$use_stp = true;
}
if (in_array("paypal", $Global['withdrawal_options_array'])) {
	$use_paypal = true;
}
if (in_array("bitcoin", $Global['withdrawal_options_array'])) {
	$use_bitcoin = true;
}
if (in_array("cashapp", $Global['withdrawal_options_array'])) {
	$use_cashapp = true;
}
if (in_array("zelle", $Global['withdrawal_options_array'])) {
	$use_zelle = true;
}
/*if ($use_cashapp == true) {
	$db_field_to_copy = 'cashapp';
	$members_field_to_update = 'paymentprocessor5';

	$qry = "SELECT * FROM downline_builder_member AS dbm JOIN downline_builder as db
	WHERE db.name='{$db_field_to_copy}' AND dbm.downline_builder_id = db.downline_builder_id AND dbm.affid != ''";
	$result = mysql_query($qry) or die($qry.' '.mysql_error());
	//echo $qry."<br/>";
	while ($buffer = mysql_fetch_assoc($result)) {
		//echo '<pre>';
		//print_r($buffer);
		//echo '<pre>';
		$affid = '';
		$ID = '';
		$affid = $buffer['affid'];
		$ID = $buffer['ID'];
		$qryu = "UPDATE members SET {$members_field_to_update}='{$affid}' WHERE ID='{$ID}'";
		$resultu = mysql_query($qryu) or die($qryu.' '.mysql_error());
	}
}
if ($use_zelle == true) {
	$db_field_to_copy = 'Zelle';
	$members_field_to_update = 'paymentprocessor6';

	$qry = "SELECT * FROM downline_builder_member AS dbm JOIN downline_builder as db
	WHERE db.name='{$db_field_to_copy}' AND dbm.downline_builder_id = db.downline_builder_id AND dbm.affid != ''";
	$result = mysql_query($qry) or die($qry.' '.mysql_error());
	//echo $qry."<br/>";
	while ($buffer = mysql_fetch_assoc($result)) {
		//echo '<pre>';
		//print_r($buffer);
		//echo '<pre>';
		$affid = '';
		$ID = '';
		$affid = $buffer['affid'];
		$ID = $buffer['ID'];
		$qryu = "UPDATE members SET {$members_field_to_update}='{$affid}' WHERE ID='{$ID}'";
		$resultu = mysql_query($qryu) or die($qryu.' '.mysql_error());
	}
}*/
/*
masspay - only works if member uses admin collects, user has SS# if US, user paid for activated their debit card (entered last 4 digits) - all this is forced thru Members/bank.php, before they can make withdrawal requests, so we do not need to add those security checks here!!

separate mass pay files for domestic and international - debit card or stp
*** You can send us SSN for US residents. masked, only exposing the last 4 digits. The order on the info being passed over will work fine. 
you can use AxCrypt with a shared password to secure the CSV file for uploading. 

member's first and last name, email address, and load amount, tax_id (if US), last 4 digits of debit card.

//////////////////////////////////////////// MASSPAY FORMAT ISSUES!!!!!!!! ////////////////////////////////////////////////////
when you save CSV files, the formatting should be correct. if you find instances where it is not - i.e. data is shooting into columns it should not be, it likely means the user this is happening to has put commas, spaces or other weird characters into their profile, or put 2 names into the first and or last name field.

this is easily corrected by logging in as the user and removing the symbols, and replacing any spaces with underlines instead, if needed between any 2 names in the names fields.

Session Cut Off Date - what this does, is to "stop the clock" so all records will be pulled from the time you land on the page, and the session is created. you can click a link to renew the session to the current time, if need be.

this was created to safeguard against saving the data, and in the time in between you save and mark paid, someone creates a new withdrawal log. they would be marked paid but not be paid. i wanted to close this loop hole. this is now foolproof so long as you do not refresh the session between the time you save the CSV data, and the time you mark the same data as paid.
*/

if (!isset($_GET['tax'])) $_GET['tax'] = '';
if (!isset($_GET['m'])) $_GET['m'] = '';
if (!isset($_GET['run'])) $_GET['run'] = '';
if (!isset($_GET['process'])) $_GET['process'] = '';
if (!isset($_GET['reset'])) $_GET['reset'] = '';
if (!isset($_GET['reward_user'])) $_GET['reward_user'] = '';
if (!isset($_GET['verify'])) $_GET['verify'] = '';


if ($_GET['tax'] == 'show' || $_GET['m'] == '1099') {
	$_SESSION['tax_id_display'] = true;
} else if ($_GET['tax'] == 'hide' || $_GET['tax'] == '') {
	$_SESSION['tax_id_display'] = false;	
}



if ($_SESSION['tax_id_display'] == true) {
	$pageName = '1099 Tax Data';
} else {
	$pageName = 'Mass Pay Administration';
}
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
/**
 * Decrypts a given string with mcrypt using algorythm from
 * the config
 *
 * @global array $Global		The configuration array
 * @param string $input			The string we want to decrypt
 * @return string						The decrypted string
 */
function decrypt($input) {
    // Check if the input is null or an empty string
    if ($input === null || $input === '') {
        return $input;
    }

    global $GLOBALS;
    $key = $GLOBALS['member_taxid_algorythm_key'];    
    $method = 'AES-256-CBC';
    $data = base64_decode($input);
    $ivLength = openssl_cipher_iv_length($method);
    $iv = substr($data, 0, $ivLength);
    $encryptedData = substr($data, $ivLength);
    return openssl_decrypt($encryptedData, $method, $key, OPENSSL_RAW_DATA, $iv);
}	

include './../Inc/Header.inc.php';

$title = 'All Pending Withdrawals - Includes Those Without Required Payout Data';

if (isset($where)) unset($where);
$where = []; // Initialize the where condition array

// RESTRICT PAYOUTS BY PAY METHOD MEMBER ACCEPTS
if ($_GET['m'] == 'check') {
$where['AND']['memb.payout_method'] = ['=', 'check'];
$title = 'Pending Withdrawals By Check Only';

} else if ($_GET['m'] == 'bank') {
$where['AND']['memb.payout_method'] = ['=', 'bank'];
$title = 'Pending Withdrawals By Bank Only';

} else if ($_GET['m'] == 'paypal') {
$where['AND']['memb.payout_method'] = ['=', 'paypal'];
$title = 'Pending Withdrawals By Paypal Only';

} else if ($_GET['m'] == 'bitcoin') {
$where['AND']['memb.payout_method'] = ['=', 'bitcoin'];
$title = 'Pending Withdrawals By Bitcoin Only';

} else if ($_GET['m'] == 'cashapp') {
$where['AND']['memb.payout_method'] = ['=', 'cashapp'];
$title = 'Pending Withdrawals By Cashapp Only';

} else if ($_GET['m'] == 'zelle') {
$where['AND']['memb.payout_method'] = ['=', 'zelle'];
$title = 'Pending Withdrawals By Zelle Only';
} else if ($_GET['m'] == '1099') {
	
	$year = date("Y");
	//echo $year;
	$last_year = $year - 1;
	//echo '<br/>'.$last_year;
		
	$method = " "; // LEAVE TRAILING SPACE!
	$title = '1099 Data - Showing Users Paid Out $600 or more in '.$last_year;
} else {
$method = '';
}

echo '<h1>'.$title.'</h1>';

if ($test_mode === true && isset($_GET['reset_test']) && $_GET['reset_test'] != 'yes') {
	echo '<h3><a href="pay_commissions.php?reset_test=yes" style="color:red">RESET ALL PAID WITHDRAWAL RECORDS BACK TO PENDING - FOR TESTING ONLY<br/>DISABLE THIS FEATURE BEFORE GOING LIVE!!</a></h3><br/>';
} if ($test_mode === true && isset($_GET['reset_test']) && $_GET['reset_test'] == 'yes') {
	echo '<h3><a href="pay_commissions.php" style="color:green">RESET SUCCESSFUL! CLICK HERE TO SHOW ALL RECORDS.</a></h3><br/>';
}

if ($_GET['m'] != '1099') {
	//echo '<a href="pay_commissions.php?location=us&m=card">Show US Users - Debit Card Only</a> | ';
	//echo '<a href="pay_commissions.php?location=intl&m=card">Show International Users - Debit Card Only</a> | ';
	if ($use_check === true) echo '<a href="pay_commissions.php?m=check">Show By Check Only</a> | ';
	if ($use_bank_account === true) echo '<a href="pay_commissions.php?m=bank">Show By Bank Account Only</a> | ';	
	if ($use_stp === true) echo '<a href="pay_commissions.php?m=stp">Show STP Only</a> | ';
	//echo '<a href="pay_commissions.php?m=neteller">Show Neteller Only</a> | ';
	if ($use_paypal === true) echo '<a href="pay_commissions.php?m=paypal">Show Paypal Only</a> | ';
	if ($use_bitcoin === true) echo '<a href="pay_commissions.php?m=bitcoin">Show Bitcoin Only</a> | ';
	if ($use_cashapp === true) echo '<a href="pay_commissions.php?m=cashapp">Show CashApp Only</a> | ';
	if ($use_zelle === true) echo '<a href="pay_commissions.php?m=zelle">Show Zelle Only</a> | ';
	echo '<a href="pay_commissions.php">Show All Records </a> | ';
	
	if ($_SESSION['tax_id_display'] == true) echo '<a href="pay_commissions.php?tax=hide">Hide Tax ID </a> | ';
	if ($_SESSION['tax_id_display'] == false && $Global['member_taxid'] == true) echo '<a href="pay_commissions.php?tax=show">Show Tax ID </a> | ';	
}

if ($_GET['run'] == 'yes' && $_GET['m'] != '') {
	echo "<h2>Are you sure? <a href=\"pay_commissions.php?m=".$_GET['m']."&process=yes&verify=".$_GET['verify']."\">Yes, Mark These Withdrawal Requests Paid!</a></h2>";
	include './../Inc/Footer.inc.php';
	exit;
} else if ($_GET['run'] == 'yes' && $_GET['m'] == '') {
	echo 'NO METHOD SELECTED!';
	include './../Inc/Footer.inc.php';
	exit;
}

if ($_GET['m'] != '1099') {
	if ($_GET['process'] != 'yes') {
		echo "DISPLAY MODE ONLY - NO WITHDRAWALS MARKED PAID!<br /><br/>";
	} else {
		if ($_GET['verify'] != '') {
			$bnkv = 'BANK VERIFICATION ';
			$where['AND']['log.description'] = ['=', 'BANK DEPOSIT VERIFICATION'];
		} else { 
			$bnkv = '';
		}	
		echo "<h3>{$bnkv}WITHDRAWALS SUCCESSFULLY MARKED PAID!</h3><br /><br/>";
	//echo '<a href="pay_commissions.php">Return To Masspay</a>';
	//include './../Inc/Footer.inc.php';
	//exit;
	}
}

/* CREATE TABLE IF NOT EXISTS `transactions_log` ( // HERE AS REFERENCE ONLY!!!
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usrid` int(11) NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `description` text NOT NULL,
  `transtype` varchar(10) NOT NULL,
  `logdate` datetime NOT NULL,
  `payout_date` date NOT NULL,
  `pay_status` varchar(10) NOT NULL COMMENT 'PENDING, PAID, CANCELLED',
  `paiddate` datetime NOT NULL,
  `status_explanation` text NOT NULL,
*/
$today = date("Y-m-d");
$date = date("Y-m-d H:i:s");
if ($_SESSION['cutoff_date'] == '' || $_GET['reset'] == 'yes') $_SESSION['cutoff_date'] = date("Y-m-d H:i:s");
$where['AND']['log.logdate'] = ['<', $_SESSION['cutoff_date']]; // RESTRICT PAYOUTS TO WITHDRAWALS EARLIER THAN SESSION CUT OFF DATE, TO SAVEGAURD AGAINST MARKING SOMEONE PAID WHO CREATES A WITHDRAWAL DURING MASSPAY

if ($_GET['m'] != '1099') {
	echo 'Session Cut Off Date: '.$_SESSION['cutoff_date'];
	echo "<br/><a href=\"pay_commissions.php?m=".$_GET['m']."&reset=yes\">Reset Session Cut Off Date</a><br/><br/>";
}
// 3/10/15 REMOVED AND memb.payment_collected_by='admin' FROM BOTH QUERIES, FOR CASES WHERE MEMBER NOW HAS THEIR OWN E4, BUT STILL HAS PENDING COMMISSIONS FROM WHEN THEY HAD ADMIN COLLECT!

// PAYOUT ALL PENDING WITHDRAWALS - 7 DAY HOLD BACK ALREADY DONE BY CC CRON!!

$verify = '';
if ($_GET['m'] == 'bank') {
	echo 'Session Cut Off Date: '.$_SESSION['cutoff_date'];
	echo "<br/><a href=\"pay_commissions.php?&m=".$_GET['m']."&verify=yes\" class='btn btn-success'>SHOW ONLY BANK DEPOSIT VERIFICATIONS</a><br/><br/>";
}

$payout_method = $_GET['m'];

if ($_GET['reward_user'] != '') {
	$ruser = $_GET['reward_user'];
	$selectFields = "log.amount as amount";
	$where['AND']['memb.Username'] = ['=', $ruser];
	$groupBy = "log.id"; // MUST BE BLANK TO ALLOW INDIVIDUAL WITHDRAWAL REQUESTS TO SHOW UP
	$title = ' Single Member Withdrawal Request <br/><h2 style="color:red">Please click the "Process" link to mark withdrawal paid for user '.$_GET['reward_user'].'</h2><br/>';
} else {
	$selectFields = "sum(log.amount) as amount";
	$groupBy = "memb.Username";
}


if ($_GET['m'] == '1099') {
	$where['AND']['log.logdate'] = ['>=', '{$last_year}-01-01 00:00:00'];
	$where['AND']['log.logdate'] = ['<', '{$year}-01-01 00:00:00'];
	$where['AND']['log.pay_status'] = ['=', 'paid'];
	$groupBy = "log.usrid ";
	$orderBy = "amount ASC";
} else {
	$where['AND']['log.pay_status'] = ['=', 'pending'];
	$where['AND']['memb.Status'] = ['!=', 'Cancelled'];
	$orderBy = "log.payout_date ASC";
}	

$where['AND']['memb.Username'] = ['!=', 'admin'];
$where['AND']['log.transtype'] = ['=', 'WITHDRAWAL'];

$selectFields = $selectFields.", log.id as tid, log.payout_date, log.description, log.status_explanation, log.payment_log_id, memb.ID, memb.First_Name, memb.Last_Name, memb.email, memb.Username, ml.address, ml.address2, ml.city, ml.state, memb.province, ml.country, ml.tax_id, memb.debitcard, memb.paypalaccount, memb.bitcoin, memb.payout_method, memb.bank_account, memb.bank_routing, memb.paymentprocessor5, memb.paymentprocessor6";

$mainTable = ['table' => 'members', 'as' => 'memb'];
$joinConditions = [
    ['table' => 'member_link', 'as' => 'ml', 'condition' => 'memb.ID = ml.ID'],
    ['table' => 'transactions_log', 'as' => 'log', 'condition' => 'log.usrid = memb.ID']
]; 

//print_r($where);
	
$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, null, $orderBy, 0, 1);
$buffer = isset($result[0]) ? $result[0] : '';
$records = is_array($result) ? count($result) : 0;	

$log_status = 'Due';
if ($_GET['m'] == '1099') $log_status = 'Paid';

if (isset($_GET['m']) && $_GET['m'] === '1099') {
    if (is_array($buffer) && isset($buffer['amount']) && is_numeric($buffer['amount'])) {
        echo 'Total '.$log_status.': $'.number_format(abs($buffer['amount']), 2).'&nbsp;';
        echo '(includes amounts under $600 - worldwide)';
        echo '<br/><br/>';
    } else {
        echo 'No records found.';
        echo '<br/><br/>';		
    }
}


/*if ($_GET['m'] == '1099') {
// sum(0-amount) IS REQUIRED, SINCE WITHDRAWALS ARE NEGATIVE!!
	$main_qry = "SELECT temp.totamt, memb.ID, memb.First_Name, memb.Last_Name, memb.email, memb.Username, ml.address, ml.address2, ml.city, ml.state, ml.zip, ml.country, ml.tax_id, memb.debitcard, memb.stp_username, memb.neteller_username, memb.payout_method FROM members as memb JOIN member_link as ml JOIN (SELECT sum(0-amount) as totamt, usrid from transactions_log WHERE transtype = 'WITHDRAWAL' AND pay_status='PAID' AND logdate >= '{$last_year}-01-01 00:00:00' AND logdate < '{$year}-01-01 00:00:00' GROUP BY usrid) as temp 
	WHERE memb.ID=ml.ID AND memb.ID=temp.usrid AND memb.Username!='DELETED' AND memb.Username!='admin' AND ml.country='US' AND temp.totamt>=600 ORDER BY temp.totamt DESC";	
		// PAYOUT ALL PENDING WITHDRAWALS - SAME AS ABOVE WITH GROUP BY USERNAME ADDED	
		$sql_qry = "{$main_qry}";
} else {
		//$group_by = " GROUP BY log.id ";
		// PAYOUT ALL PENDING WITHDRAWALS - SAME AS ABOVE WITH GROUP BY USERNAME ADDED	
		$sql_qry = "SELECT {$sqlamount}, {$main_qry} {$payout} {$group_by} {$order_by}";
}
		//echo $sql_qry.'<br/><br/>'; // SHOW PREVIEW
		$sql_result = mysql_query($sql_qry) or die(mysql_error());		
		$records = mysql_num_rows($sql_result);
*/		
		echo 'Total Records: '.$records.'&nbsp;';
		if ($_GET['m'] == '1099') echo '($600 and up - United States Only)';
		echo '<br/><br/>';


if (($records > 0) && $_GET['m'] != '' && $_GET['m'] != 'QQQbitcoin' && $_GET['process'] != 'yes') {
	
if ($_GET['m'] == 'paypal') echo '<h2><a href="https://www.paypal.com/us/cgi-bin/webscr?cmd=_masspay-learn-more" target="_blank"><u>How To Use Masspay For Paypal</u></a></h2><br/>';	

echo "<span style=\"color: green; font-weight:bold;\">Step (1)</span> Copy Speadsheet Data below, save it in a new .txt file. Close file.<br>Rename the file to .csv. Now open it (using comma as the separator) to verify spreadsheet. <br/><br/>
<span style=\"color: green; font-weight:bold;\">";

	if ($_GET['m'] != '1099') echo "Step (2)</span> <a href=\"pay_commissions.php?m=".$_GET['m']."&run=yes&verify=".$_GET['verify']."\"><u>Mark These Withdrawal Requests Paid!</u></a><br/><br/>";
	else echo "Step 2)</span> Use speadsheet data to populate 1099's with Uncle Sam<br/><br/>";

}

$separator = ",";
				if ($_GET['process'] != 'yes' && $_GET['m'] != '' && $_GET['reward_user'] == '') {
				//echo '<textarea style="background: none;" id="due" name="due" rows="20" cols="100">';
				// CREATING HEADER FOR CSV!!	
					//member's first and last name, email address, and load amount, tax_id (if US), last 4 digits of debit card.
					if ($_GET['m'] == 'card') { // GLOBAL PAYOUT CARD CSV HEADER // OR SHOW ALL USERS
					echo "Username First_Name Last_Name Email Amount Tax_ID Debit_Card"."<br />";
					
					} else if ($_GET['m'] == 'stp') { // SOLID TRUST PAY CSV HEADER //name1@email.com   10.00  earnings username
					echo "STP_Email_OR_Username Amount Earnings Username"."<br />";
					
					} else if ($_GET['m'] == 'bitcoin') { // SOLID TRUST PAY CSV HEADER //name1@email.com   10.00  earnings username
					echo "Bitcoin Amount Username"."<br />";

					} else if ($_GET['m'] == 'cashapp') { 
					echo "Cashapp Amount Username"."<br />";

					} else if ($_GET['m'] == 'zelle') { 
					echo "Zelle Amount Username"."<br />";

					} else if ($_GET['m'] == 'paypal') {  // PAYPAL CSV HEADER // name1@email.com   10.00   USD   masspay_001   Thanks for your business! 
					echo 'Paypal_Email'.$separator.'Amount'.$separator.'Currency'.$separator.'Date'.$separator.'Comments'."<br />";					

					//BY CHECK - member's first and last name, ADDRESS, email address, and load amount.
					} else if ($_GET['m'] == 'check') { // BY CHECKS
					
						if ($_SESSION['tax_id_display'] == true) {
							echo "Username; First_Name; Last_Name; address; address2; city; state; zip; province; country; Email; Amount; TAX_ID;"."<br />";
						} else if ($_SESSION['tax_id_display'] == false) {
							echo "Username; First_Name; Last_Name; address; address2; city; state; zip; province; country; Email; Amount;"."<br />";
						}
					//1099 REPORT FOR PRIOR YEAR member's first and last name, ADDRESS, email address, and TOTAL amount, TAX ID.

					} else if ($_GET['m'] == 'bank') { // BY BANK
					
						if ($_SESSION['tax_id_display'] == true) {
							echo "Username; First_Name; Last_Name; address; address2; city; state; zip; province; country; Email; Amount; Bank_Account; Bank_Routing; TAX_ID;"."<br />";
						} else if ($_SESSION['tax_id_display'] == false) {
							echo "Username; First_Name; Last_Name; address; address2; city; state; zip; province; country; Email; Amount; Bank_Account; Bank_Routing;"."<br />";
						}				
					
					} else if ($_GET['m'] == '1099') {
					echo "Username; email; First_Name; Last_Name; address; address2; city; state; zip; country; Amount; TAX_ID"."<br />";					
					
					} else if ($_GET['m'] != 'bitcoin') { // SHOW ALL USERS - COUNTRY - PAYOUT METHOD
					echo "Username First_Name Last_Name Email Amount Tax_ID Debit_Card country Payout_Method STP_Username Cashapp Zelle"."<br />";
					}
				}	
	$nr = 1;
	$color[0] = 'FFFFFF';
	$color[1] = 'A3FFA3';
	$payment_text = '';
	$total_amount = 0;
	$_SESSION['amount_result'] = 0;

foreach ($result as $buffer) { // GET PAYOUT DATA FOR CSV FILES!

	if ($_GET['m'] == '1099') $buffer['amount'] = $buffer['totamt'];
	
	$ID = $buffer['ID']; 
	
	if (isset($buffer['bank_account']) && isset($buffer['bank_routing'])) {
	
	$bank_account = $buffer['bank_account'];
	$bank_routing = $buffer['bank_routing'];
	
	$selectFields = 'verified';
	$mainTable = 'bank_account';
	$whereb = [
		'ID' => ['=', $ID],
		'bank_account' => ['=', $bank_account],
		'bank_routing' => ['=', $bank_routing]
	];

	$resultb = select($selectFields, $mainTable, [], $whereb, null, null, null, 0, 1);
		$bufferb = $resultb[0] ?? null;
	}	
	
	if (isset($bufferb['verified']) && $bufferb['verified'] == 'Y' && $bank_account != '' && $bank_routing != '') {
		$bankstatus = '<button class="btn btn-xs btn-success">VERIFIED</button>';
		$bankv = 'Y';
	} else if (isset($bufferb['verified']) && $bufferb['verified'] == 'N') { 
		$bankstatus = '<button class="btn btn-xs btn-warning">PENDING</button>';
		$bankv = 'N';
	} else {
		$bankstatus = '<a href="bankpay.php?reward_user='.$buffer['Username'].'&type=withdrawal&type=bank_verification"><button class="btn btn-xs btn-danger">VERIFY</button></a>';
		$bankv = '';
	}
	if ($buffer['payout_method'] != 'bank') $bankstatus = '';

	// THIS WAS CREATED DUE TO 2 ADMIN FEE PROGRAMS IN QUERY DOUBLED THE TOTAL DUE AMOUNT - SAFER LOGIC ANYWAY	
	$_SESSION['amount_result'] = $buffer['amount'] + $_SESSION['amount_result'];

 
		$tax_id = '';
		$tax_id  = decrypt($buffer['tax_id']);
		if ($tax_id == '' && $buffer['country'] == 'US') $tax_id = '<strong><span style="color: red;">NO_TAX_ID</span></strong>';
		if ($Global['member_taxid'] == false) $tax_id = 'N/A';		
		if ($_SESSION['tax_id_display'] == false) $tax_id = '';

		if ($buffer['payout_method'] == 'card' && $buffer['debitcard'] == '') $buffer['debitcard'] = '<strong><span style="color: red;">NO_CARD</span></strong>';
		if ($buffer['payout_method'] == 'bitcoin' && $buffer['bitcoin'] == '') $buffer['bitcoin'] = '<strong><span style="color: red;">NO_BITCOIN</span></strong>';
		if ($buffer['payout_method'] == 'cashapp' && $buffer['paymentprocessor5'] == '') $buffer['paymentprocessor5'] = '<strong><span style="color: red;">NO_CASHAPP</span></strong>';
		if ($buffer['payout_method'] == 'zelle' && $buffer['paymentprocessor6'] == '') $buffer['paymentprocessor6'] = '<strong><span style="color: red;">NO_ZELLE</span></strong>';

		if ($buffer['payout_method'] == '') $buffer['payout_method'] = '<strong><span style="color: red;">NO_PAYOUT_METHOD</span></strong>'; 
		
		// WHEN UPDATING PAYOUT OPTIONS HERE, REMEMBER TO ALSO UPDATE bankpay.php (FOR SINGLE PAYOUTS)
		$payout_info = '';
		if ($buffer['payout_method'] == 'card') $payout_info = $buffer['debitcard'] ?? '';
		if ($buffer['payout_method'] == 'paypal') $payout_info = $buffer['paypal'] ?? '';
		if ($buffer['payout_method'] == 'bitcoin') $payout_info = $buffer['bitcoin'] ?? '';
		if ($buffer['payout_method'] == 'cashapp') $payout_info = $buffer['paymentprocessor5'] ?? ''; 
		if ($buffer['payout_method'] == 'zelle') $payout_info = $buffer['paymentprocessor6'] ?? '';	
		
	if ($_GET['m'] != '' && $_GET['reward_user'] == '') {	
	if ($_GET['m'] == 'card') { // GLOBAL PAYOUT
	echo $buffer['Username']." ".$buffer['First_Name']." ".$buffer['Last_Name']." ".$buffer['email']." ".abs($buffer['amount'])." ".$tax_id." ".$buffer['debitcard']."<br/>";
	
	} else if ($_GET['m'] == 'stp') { // SOLID TRUST PAY
	echo $buffer['stp_username']." ".abs($buffer['amount'])." Earnings ".$buffer['Username']."<br/>";
	
	} else if ($_GET['m'] == 'bitcoin') { // BITCOIN
	echo $buffer['bitcoin']." ".abs($buffer['amount'])." ".$buffer['Username']."<br/>";	
	
	} else if ($_GET['m'] == 'cashapp') { 
	echo $buffer['paymentprocessor5']." ".abs($buffer['amount'])." ".$buffer['Username']."<br/>";	

	} else if ($_GET['m'] == 'zelle') { // BITCOIN
	echo $buffer['paymentprocessor6']." ".abs($buffer['amount'])." ".$buffer['Username']."<br/>";		
	
	} else if ($_GET['m'] == 'neteller') { // NETELLER QQQ - COPIED SOLID TRUST PAY FOR NOW - LIKELY NEEDS UPDATING!!!!!
	echo $buffer['neteller_username']." ".abs($buffer['amount'])." Earnings ".$buffer['Username']."<br/>";	

		} else if ($_GET['m'] == 'paypal') { // PAYPAL
		echo $buffer['paypalaccount'].$separator.abs($buffer['amount']).$separator."USD".$separator.$today.$separator."Thank you for your business!<br/>";	

	} else if ($_GET['m'] == 'check') { // BY CHECK
	echo $buffer['Username']."; ".$buffer['First_Name']."; ".$buffer['Last_Name']."; ".$buffer['address']."; ".$buffer['address2']."; ".$buffer['city']."; ".$buffer['state']."; ".$buffer['zip']."; ".$buffer['province']."; ".$buffer['country']."; ".$buffer['email']."; ".abs($buffer['amount'])."; ".$tax_id."<br/>";
	
	} else if ($_GET['m'] == 'bank') { // BANK ACCOUNT
	echo $buffer['Username']."; ".$buffer['First_Name']."; ".$buffer['Last_Name']."; ".$buffer['address']."; ".$buffer['address2']."; ".$buffer['city']."; ".$buffer['state']."; ".$buffer['zip']."; ".$buffer['province']."; ".$buffer['country']."; ".$buffer['email']."; ".abs($buffer['amount'])."; ".base64_decode($buffer['bank_account'])."; ".base64_decode($buffer['bank_routing'])."; ".$tax_id."<br/>";	
	
	} else if ($_GET['m'] == '1099') { // 1099
	echo $buffer['Username']."; ".$buffer['email']."; ".$buffer['First_Name']."; ".$buffer['Last_Name']."; ".$buffer['address']."; ".$buffer['address2']."; ".$buffer['city']."; ".$buffer['state']."; ".$buffer['zip']."; ".$buffer['country']."; ".abs($buffer['amount'])."; ".$tax_id."<br/>";

		} else if ($_GET['m'] != 'bitcoin') { // SHOW ALL USERS - ALL PAY METHODS
	echo $buffer['Username']." ".$buffer['First_Name']." ".$buffer['Last_Name']." ".$buffer['email']." ".abs($buffer['amount'])." ".$tax_id." ".$buffer['debitcard']." ".$buffer['country']." ".$buffer['payout_method']." ".$buffer['stp_username']." ".$buffer['neteller_username']." ".$buffer['paymentprocessor5']." ".$buffer['paymentprocessor6']."<br />";
	}
	}

	$user_payout_info = $payout_method .' '.$payout_info;
	
	// SET UPDATE VARIABLE ONLY!
	$table = 'transactions_log';
	$data = [
		'pay_status' => 'PAID',
		'paiddate' => $date,
		'payout_method' => $user_payout_info,
	];

	unset($where);
	$where = [
		'transtype' => ['=', 'WITHDRAWAL'],
		'pay_status' => ['=', 'PENDING'],
		'usrid' => ['=', $buffer['ID']]
	];
	
	$where['logdate'] = ['<', $_SESSION['cutoff_date']];	
	if ($_GET['verify'] != '') {
		$where['description'] = ['=', 'BANK DEPOSIT VERIFICATION'];
	} 		

	// REMOVED  AND log.id = '{$buffer['tid']}' ON 1/20/16. DUE TO THE GROUP BY IN QUERY, THIS CAUSED MASSPAY TO NOT MARK ALL RECORDS, WHEN A USER HAD MULTIPLE PENDING WITHDRAWAL REQUESTS AT ONCE
	


	//echo $upd_result; // SHOW PREVIEW
	if ($_GET['process'] == 'yes') {
		//$debug = true;
			update($table, $data, [], $where, 1, 0, 1); // updates all matching records. // MARK WITHDRAWALS PAID!!
	
		if ($_GET['verify'] != '') {
			// NOW WE DELETE ANY RELATED ALERTS, SO THEY GET ALERTED RIGHT AWAY!
			unset($where);
			$where = [
				'ID' => ['=', "{$buffer['ID']}"],
				'name' => ['=', 'find_bank_to_verify']
			];
			delete('alert_member', [], $where, null, 1, 1, 1);

			unset($where);
			$where = [
				'ID' => ['=', "{$buffer['ID']}"],
				'name' => ['=', 'bank_was_verified']
			];
			delete('alert_member', [], $where, null, 1, 1, 1);
		}
	} // END DB UPDATE!!
		
	// RESET BACK TO PENDING - FOR TESTING ONLY!!!!
	if (isset($_GET['reset_test']) && $_GET['reset_test'] == 'yes' && $test_mode === true) {
		$table = 'transactions_log';
		$data = [
			'pay_status' => 'PENDING',
			'paiddate' => '0000-00-00 00:00:00', // Assuming this is the default or reset value for the paiddate column
			'payout_method' => '' // Resetting payout_method to an empty string
		];
		unset($where);
		$where = [
			"transtype = 'WITHDRAWAL'" // Direct condition as a string, assuming your update method parses it correctly
		];

		// Assuming the update function doesn't need join conditions for this operation
		// and you want to update all rows matching the condition without a limit
		update($table, $data, [], $where, 1, 0, 1);
		
	} // END DB UPDATE!!
			
			
if (isset($_GET['status']) && $_GET['status'] == 'bad') {	
$onclick = 'confirmAction();';
$status = 'bad';
} else {
$onclick = '#';
$status = 'ok';
}	
//$onclick = '';

if ($_GET['reward_user'] != '' && $buffer['description'] == 'CHARGEBACKW') {
$target = "_blank";
$link = '<a href="Payment-Logs.php?log_id='.$buffer['payment_log_id'].'&status='.$status.'". target="'.$target.'". onclick="'.$onclick.'">';
$name = "Chargeback";

} else if ($_GET['reward_user'] != '') {
$target = "_self";
$link = '<a href="bankpay.php?reward_user='.$buffer['Username'].'&amount='.$buffer['amount'].'&type=withdrawal&status='.$status.'". target="'.$target.'". onclick="'.$onclick.'">';
$name = "Process";

} else {
$target = "_blank";
$link = '<a href="pay_commissions.php?reward_user='.$buffer['Username'].'&amount='.$buffer['amount'].'&type=withdrawal&status='.$status.'". target="'.$target.'". onclick="'.$onclick.'">';
$name = "Select";
}	


if ($_GET['m'] == '1099') { 
$link = '<a href="search-bank-logs.php?username='.$buffer['Username'].'&transtype=W&status=P" target="_blank">Bank Logs</a>';
$name = '';
}	

if ($Global['member_taxid'] == true && $_SESSION['tax_id_display'] == true) $tax_id_value = '<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$tax_id.'</td>';

if ($use_paypal == true && ($_GET['m'] == '' || $_GET['m'] == 'paypal')) $paypal_value = '<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['paypalaccount'].'</td>';

if ($use_bitcoin == true && ($_GET['m'] == '' || $_GET['m'] == 'bitcoin')) $bitcoin_value = '<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['bitcoin'].'</td>';

if ($use_cashapp == true && ($_GET['m'] == '' || $_GET['m'] == 'cashapp')) $cashapp_value = '<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['paymentprocessor5'].'</td>';

if ($use_zelle == true && ($_GET['m'] == '' || $_GET['m'] == 'zelle')) $zelle_value = '<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['paymentprocessor6'].'</td>';

$link_color = '';
if ($buffer['description'] == 'CHARGEBACKW') {
	$amount = number_format(-($buffer['amount']), 2);
	$link_color = 'red';
} else {
	$amount = number_format(abs($buffer['amount']), 2);
}
			
$payment_text .= '<tr bgcolor="'.(($nr % 2 == 0)?$color[0]:$color[1]).'">
<td align="left" style="padding-left: 5px; border-right: 1px solid #000">'.$buffer['payout_date'].'</td>
<td align="left" style="padding-left: 5px; border-right: 1px solid #000">
<a href="Finduser.php?username='.$buffer['Username'].'" target="_blank">
'.$buffer['Username'].'
</a>
</td>
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['First_Name'].'</td><td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['Last_Name'].'</td>
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['country'].'</td>
'.$tax_id_value.'
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['payout_method'].' '.$bankstatus.'</td>

'.$paypal_value.'

'.$bitcoin_value.'

'.$cashapp_value.'

'.$zelle_value.'

<!--
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">'.$buffer['debitcard'].'</td>
-->
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">
<!--
<a href="Payment-Logs.php?username='.$buffer['Username'].'&searchway=username_who_got_paid&cc_pending=N" target="_blank">
-->
<a href="search-bank-logs.php?username='.$buffer['Username'].'&searchway=username_who_got_paid&cc_pending=N" target="_blank" style="color:'.$link_color.'">
$'.$amount.'
</a>
</td>
<td align="left" style="border-right: 1px solid #000; padding-left: 5px;">

'.$link.'
'.$name.'
</a>
</td>

<!--
<td align="center">'.((empty($buffer['sub_use']) || $buffer['sub_use'] == 'N')?'&nbsp':'<a href="Dopayment.php?id='.$buffer['ID'].'&processor='.$_GET['processor'].'">Pay</a>').'*/
</td>
-->
</tr>';
			++$nr;
} // END WHILE LOOP

		if ($_GET['m'] != '1099') {
			echo '<br/>Total '.$log_status.': $'.number_format(abs($_SESSION['amount_result']), 2).'&nbsp;<br/>';
		}

//exit;
//echo '</textarea>';
if ($_GET['m'] != '' && $_GET['m'] != 'bitcoin' && $_GET['reward_user'] == '') echo '<br/><hr>';
echo '<br/>';
			if ($_GET['process'] == 'yes' && $records > 0) {
			echo '<p></p>Withdrawals Marked Paid For '.$title. ' SAVE THIS DATA AS A TEXT FILE, AND RENAME IT TO CSV.<br/><br/>';	
echo "<h2><a href=\"pay_commissions.php?m=".$_GET['m']."\">CLICK HERE TO REFRESH PAGE</a></h2><p></p>";
			}

if ($_GET['m'] != '1099') { 
$process = 'Process'; // SHOW PROCESS LINK FOR PAYOUTS
} else {
$process = 'Withdrawals'; // SHOW NOTES FOR THOSE ALREADY PAID OUT
}	

if ($Global['member_taxid'] == true && $_SESSION['tax_id_display'] == true) $tax_id_header = '<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Tax ID</td>';

if ($use_paypal == true && ($_GET['m'] == '' || $_GET['m'] == 'paypal')) $paypal_header = '<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Paypal</td>';

if ($use_bitcoin == true && ($_GET['m'] == '' || $_GET['m'] == 'bitcoin')) $bitcoin_header = '<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Bitcoin</td>';

if ($use_cashapp == true && ($_GET['m'] == '' || $_GET['m'] == 'cashapp')) $cashapp_header = '<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Cashapp</td>';

if ($use_zelle == true && ($_GET['m'] == '' || $_GET['m'] == 'zelle')) $zelle_header = '<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Zelle</td>';
	
echo <<<EOD
<table width="965px" align="center" cellpadding="0" cellspacing="0" style="border: 1px solid #000">
<tr>
<td align="left" width="20" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Date</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Username</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">First Name</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Last Name</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Country</td>

{$tax_id_header}

<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Payout Method</td>


{$paypal_header}

{$bitcoin_header}

{$cashapp_header}

{$zelle_header}

<!--
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Debit Card</td>
<td align="left" width="150px" style="font-weight: bold; padding-left: 5px; border-right: 1px solid #000; border-bottom: 1px solid #000;">Other</td>
-->
<td align="left" width="100px" style="font-weight: bold; border-right: 1px solid #000; padding-left: 5px; border-bottom: 1px solid #000;">{$log_status}</td>
<td align="left" width="100px" style="font-weight: bold; border-right: 1px solid #000; padding-left: 5px; border-bottom: 1px solid #000;">Action</td>

</tr>
{$payment_text}
</table>
EOD;

if ($_GET['m'] == '') echo '<br/><b><span style="color: red;">NOTE:</span></b> Items bolded in red (if any) indicate missing required fields. These records cannot be paid out, until the required info is added to the user\'s profile.<br/>Amounts in red indicate a debit is present.';

if ($_GET['m'] != '1099') {
/*	
	echo '<br/><br/><b><span style="color: red;">NOTE:</span></b> If you see ** after a person\'s first name, this indicates they are Active or Comped in both Admin Fee Programs.<br/>You may wish to review, and if they are Active in both, you should let them know they only need to pay for one admin fee.'; 	
*/	
	echo '<br/><br/><b><span style="color: red;">MISSING A RECORD?</span></b> <a href="pay_commissions.php?m='.$_GET['m'].'&reset=yes">Reset Session Cut Off Date</a>. Withdrawal requests created after your active "Session Cut Off Date" will NOT appear here.'; 
	echo '<br/>The Session Cut Off Date was created to safegaurd against accidentally marking withdrawal requests paid, that are created after you first accessed this page, and before you mass mark withdrawal requests paid.'; 
}
include './../Inc/Footer.inc.php';
?>