<?php
session_start();
//---------------------------------------------------------------
// Copyright Jim Symonds, AutomaticWebSoftware.com 
//  ADD CAPTCHA!
//---------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}
	
$pageName = 'Purge Email';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
include './../Inc/Header.inc.php';

//$GLOBALS['debug'] = true;


$email = $_REQUEST['email'];
$email = htmlspecialchars($email, ENT_QUOTES, 'UTF-8');

if ($_POST != '') {
	//echo $email;
	//exit;
}
//$datetime = date("Y-m-d H:i:s");
//if ($_SESSION['purge_date'] == '') $_SESSION['purge_date'] = $datetime;

$done = false;
$error = '';
$success = '';
$success2 = '';

if ($_POST['verify'] == 'Y') {
	
	if ($_REQUEST['email'] == '') {
		
		$error = 'Please enter an email to purge.';
		
	} else if ($_REQUEST['purge_option'] == '') {
		
		$error = 'Please choose a purge option.';
		
	} else { // WE ARE GOOD TO PURGE - LET'S GO!
		
		if ($_REQUEST['purge_option'] == 'leads' || $_REQUEST['purge_option'] == 'both') {
			
			// SEE IF EMAIL EXISTS			
			$emailSanitized = sanitize($email, 'ar_leads_email'); 

			$selectFields = 'ar_leads_id, ar_leads_phone, cellphone';
			$mainTable = 'ar_leads';
			$where = ['ar_leads_email' => $emailSanitized];
			$show_debug = 1; 

			$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);

			if ($buffer['ar_leads_id'] == '') {
				$success = 'Email was not in leads table.';
			} else {
				$success = 'Email was deleted from leads table.';
			}	
			
			if ($buffer['ar_leads_phone'] == '' && $buffer['cellphone'] == '') {
				// NO OTHER WAY TO CONTACT -- DELETE FROM AR LEADS TABLE
				$where = ['ar_leads_email' => $emailSanitized];
				$show_debug = 1; // To show debug information as per your preference
				$live = 1; // Execute the query
				
				// Use the delete function from your PHPCPR CRUD system
				delete('ar_leads', [], $where, null, $live, 0, $show_debug);
				
			} else {
				// WE HAVE A PHONE NUMBER -- SO JUST DELETE THEIR EMAIL
				$data = ['ar_leads_email' => '']; // Prepare data for update, clearing the email
				$where = ['ar_leads_email' => $emailSanitized];
				$show_debug = 1; // To show debug information as per your preference
				$live = 1; // Execute the query
				$limit = 1; // Assuming you want to limit to 1 record, adjust as necessary
				
				// Use the update function from your PHPCPR CRUD system
				update('ar_leads', $data, [], $where, $live, $limit, $show_debug);
				
				$success .= ' Lead\'s phone, other details preserved.';
			}			
		}
				
		if ($_REQUEST['purge_option'] == 'members' || $_REQUEST['purge_option'] == 'both') {
			
			// SEE IF EMAIL EXISTS
			$selectFields = 'ID';
			$mainTable = 'members';
			$where = ['email' => $emailSanitized];
			$show_debug = 1; // To enable debug output
			$buffer = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);

			if (empty($buffer['ID'])) {
				$success2 .= ' Email was not in members table.';
			} else {
				$success2 .= ' Email was deleted from members table.';
			}	
			// EMAILS CURRENTLY SHOW ON DOWNLINE PAGE ALSO. THIS WILL REMOVE THEM THERE!
			$dataForBounced = ['bounced_email' => $emailSanitized];
			$where = ['email' => $emailSanitized];
			update('members', $dataForBounced, [], $where, 1, 0, $show_debug); // Assuming unlimited updates are allowed

			$dataForEmail = ['email' => ''];
			update('members', $dataForEmail, [], $where, 1, 0, $show_debug); // Clear the email field
		}
		
		$done = true;
	}	// END PURGE
}
?>	

	<div class="col-md-3 col-xs-1">
	&nbsp;
	</div>

	<div class="col-md-6 col-xs-12" style="text-align:center; margin: 0 auto;">
	
<?php if (!empty($success)) { ?>
<div style="color:green;"><h3>Process Complete</h3>
<br/>
<h4><?php echo $success; ?></h4>&nbsp;</div>	
<?php } ?>	

<?php if (!empty($success2)) { ?>
<div style="color:green;"><h4><?php echo $success2; ?></h4><br />&nbsp;</div>	
<?php } ?>	
	
	
	<?php if ($done != true) { ?>
	<h1>Email Purge Form</h1>
		
	
<?php if (!empty($error)) { ?>
<div style="color:red;"><h4><?php echo $error; ?></h4><br />&nbsp;</div>	

<?php } ?>
	
	This function may delete the email from the leads table (ALL autoresponders).<br/>
	If lead has a phone number, their record will be preserved without an email.
	<br/>	<br/>
	This function may ALSO delete JUST the email from the members table.<br/>
	The member's account will not be affected otherwise.
	<br/>	<br/>
	Choosing both means the email will be purged completely.
	<br/>	<br/>
	<form method="post" name="myForm" onsubmit="document.getElementById('submit').disabled=true; document.getElementById('submit').value='Submitting, please wait...';">

	<input class="form-control" style="margin: 0 auto;" onMouseover="this.focus()" size="10" name="email" value="<?php if(isset($_REQUEST['email'])) : echo $_REQUEST['email']; else : echo ''; endif; ?>" placeholder="Enter Email To Purge">

	<br/><br/>	

<!-- ADD 3 CHECKBOXES HERE -- LEAD, MEMBERS, BOTH -->	
<h4>Choose Purge Option</h4>

<input type="radio" name="purge_option" value="leads" <?php if ($_POST['purge_option'] == 'leads') echo 'checked'; ?>> 
Leads
&nbsp;
<input type="radio" name="purge_option" value="members" <?php if ($_POST['purge_option'] == 'members') echo 'checked'; ?>> 
Members
&nbsp;
<input type="radio" name="purge_option" value="both" <?php if ($_POST['purge_option'] == 'both') echo 'checked'; ?>> 
Both


	<br/><br/>
	
	<input type="hidden" name="verify" value="Y">
	
	<input type="submit" name="Purge Email" class="btn btn-info btn-default" OnClick="return confirm('Are You Sure?');">
	</form>
	<?php } ?>
	
	
		<br>
	<a href="purge_email.php" class="btn btn-sm btn-primary" style="background-color:;">Reset</a>
	</div>
	
	<!---->
	<div class="col-md-3 col-xs-1">
	&nbsp;
	</div>	
	
	
	<div class="clearfix"></div>	
	
<?php 
include './../Inc/Footer.inc.php';
?>
