<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../../Sub/Config.inc.php';
include './../../phpcpr.php';
include './../Inc/Login.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}

$use_sendgrid = false;

//error_reporting(-1);
//$_SESSION['debug'] = true;

// COMMENT WHEN TESTING IS DONE!!!
//$_SESSION['dev'] = '';
 /*
if ($_GET['dev'] == '' && $_SESSION['dev'] == '' && $_SESSION['loggedin'] != 'testwalkthru') { // LOCKING PAGE FOR DEVELOPER USE ONLY!!
//include_once './header.php';
echo 'We\'re sorry. This area is temporarily down for maintenance. Please check back soon!';
//include_once './footer.php';
exit;
} else {
$_SESSION['dev'] = true;
}
 */
$datetimenow = date("Y-m-d H:i:s");
	
$pageName = 'Tax Form Rejection';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';

include './../Inc/Header.inc.php';

function createTicketId($ticket_id = 0) {// CREATE SIMPLE RANDOM ID NUMBERS FOR SUPPORT TICKETS
	$ticket_id = rand(11111111,99999999);
	return $ticket_id;
	$selectFields = 'ticket_id';
	$mainTable = 'support_tickets';
	$where = [
		'ticket_id' => ['=', $ticket_id]
	];
	$show_debug = 1;

	$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
	$buffer = isset($result[0]) ? $result[0] : null;
	$records = is_array($result) ? count($result) : 0;
	
	if ($records > 0) {
		return createTicketId(0);
	} else {
		return $ticket_id;
	}
}

$sitename = $Global['webpage_name'];


// QQQ SET EMAILS FORM SHOULD COME FROM, AND GO TO HERE!!
$salesemail = $Global['admin_email'];
//$salesemail = 'tech@automaticwebsoftware.com';
$fromemail = $Global['admin_email'];

$username = $_REQUEST['uname'];

$selectFields = '*'; // ALL
$mainTable = 'members'; // IF ONLY ONE TABLE, WITH NO JOIN CONDITION
$where = [
    'Username' => ['=', $username]
];
$show_debug = 1;
$result = select($selectFields, $mainTable, [], $where, null, null, null, 0, $show_debug);
$buffer = isset($result[0]) ? $result[0] : null;

	$email = $buffer['email'];	
	$SponsorID = $buffer['sponsorid'];
	$ID = $buffer['ID'];

// PHP Code to handle form submission and send email

if ($_SERVER["REQUEST_METHOD"] == "POST") {
	
	$datetime = date("Y-m-d H:i:s");
	
	$subject = htmlspecialchars(trim($_POST['subject']));
	$message = htmlspecialchars(trim($_POST['customMessage']));
	
	$ticket_id = createTicketId(0);
	$loggedin_username = $_SESSION['admin_username'];
	
	$HTTP_USER_AGENT = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize($_SERVER['HTTP_USER_AGENT']) : '';
	$HTTP_REFERER = isset($_SERVER['HTTP_REFERER']) ? sanitize($_SERVER['HTTP_REFERER']) : '';
	$REMOTE_HOST = isset($_SERVER['REMOTE_HOST']) ? sanitize($_SERVER['REMOTE_HOST']) : '';
	$REMOTE_ADDR = isset($_SERVER['REMOTE_ADDR']) ? sanitize($_SERVER['REMOTE_ADDR']) : '';

	// Data array for DB INSERT
	$data = [
		'ticket_id' => $ticket_id,
		'status' => 'pending',
		'name' => 'Admin Reply',
		'username' => $username,
		'loggedin' => $loggedin_username,
		'email' => $email,
		'sent_to' => $email,
		'subject' => $subject,
		'message' => $message,
		'interest' => '',
		'datetime' => $datetime,
		'sponsor' => $SponsorID,
		'priority' => 'High',
		'ip' => $REMOTE_ADDR,
		'HTTP_USER_AGENT' => $HTTP_USER_AGENT,
		'HTTP_REFERER' => $HTTP_REFERER,
		'REMOTE_HOST' => $REMOTE_HOST
	];

	$show_debug = 1;
	$live = 1;

	// insert function from PHPCPR
	$result = insert('support_tickets', $data, $live, $show_debug);
	
	if ($use_sendgrid == true) {
		sendgrid_email($salesemail,$subject_text,$message_text);
	} else {
		mail($email,$subject,$message,"From: {$sitename} <{$salesemail}>\r\n","-f{$fromemail}");
	}
	
	echo '<h2 style="color:green">Ticket created and sent to user!</h2>';
	echo '<h2 style="color:red">Tax form deleted.</h2>';
	?>
	<a href="members_tax_forms.php" class="btn btn-danger">Return To Tax Forms</a>
	<?php 
	include './../Inc/Footer.inc.php';

	// DELETE ALL PDF FILES FOR THIS USER NOW!
	// Upload path
	$upload_path = $_SERVER['DOCUMENT_ROOT'] . '/Members/pdf/';	

	// DELETE ALL OLD W8, W9 FILES FOR THIS USER WHEN THEY UPLOAD A NEW ONE!
	foreach (glob($upload_path . 'fw9_'.$ID.'.*') as $file) {
		unlink($file);
	}
	foreach (glob($upload_path . 'fw8ben_'.$ID.'.*') as $file) {
		unlink($file);
	}		

	$table = 'pdf_files';
	$where = [
		'ID' => ['=', $ID]
	];
	$show_debug = 1;
	$live = 1;

	$result = delete($table, [], $where, null, $live, 1, $show_debug);
	exit;
} // END POST
?>
<script>
function prependToTextarea() {
  const selectedMessage = document.getElementById('message').value;
  const textarea = document.getElementById('customMessage');
  const closingMessage = `
  
Please make the necessary changes to your tax form, and save it.
Then submit your completed form here:

<?php echo $Global['webpage_url_ssl']; ?>Members/tax_man.php,

so we may approve it.		  
		  
Thank you.

Regards,
<?php echo $Global['webpage_name_short']; ?> Support Team
  `;
  textarea.value = selectedMessage + closingMessage;
}
</script>

<h2>Deny Tax Form For: <?php echo $buffer['First_Name'].' '.$buffer['Last_Name'].' Username: '.$username; ?></h2>
<!-- HTML Form -->
<div class="container">
  <div class="row">
    <div class="col-md-6 col-md-offset-3">
      <form method="post" action="tax_form_deny.php">
	  <input type="hidden" name="uname" value="<?php echo $username; ?>">

        <div class="form-group">
          <label for="subject">Subject:</label>
          <input type="text" id="subject" name="subject" class="form-control form-control-lg" value="There was an issue with your Tax Form, action required" readonly>
        </div>

        <div class="form-group">
          <label for="message">Message:</label>
          <select id="message" name="message" class="form-control form-control-lg" onchange="prependToTextarea()">
            <option value="">--Select Answer--</option>
            <option value="Your W9 or W8 form must be completely filled out, including all required information and signatures, for approval.">W9 or W8 form incomplete</option>
            <option value="Your tax form is missing SSN.">No SSN</option>
            <option value="Your tax form is missing TIN.">No TIN</option>			
            <option value="Your tax form is missing signature.">No Signature</option>
            <option value="Your tax form is empty.">Ya was a complete dumbazz</option>			
            <option value="Make sure you are using up-to-date forms (you may download them from our site <?php echo $Global['webpage_url_ssl']; ?>Members/tax_man.php).">Use up-to-date forms</option>
          </select>
        </div>

        <div class="form-group">
          <textarea id="customMessage" name="customMessage" class="form-control form-control-lg" rows="15">

 
		  
		  </textarea>
        </div>

        <input type="submit" value="Submit" class="btn btn-danger btn-lg">
      </form>
    </div>
  </div>
</div>



<?php 
include './../Inc/Footer.inc.php';
?>
