<?php
/**
* Access Control Module 
* 
* Allows admin to create users and assign different access rights to them
* 
* @author Kailash Badu - Kaizen Web-Productions (http://www.kaizen-web.com)   
* @copyright Copyright(C), Kaizen Web-Productions, 2004-2008, All Rights Reserved.
*/

require_once('./../../Sub/Config.inc.php');
include './../../phpcpr.php'; // JIM SYMONDS UPDATES
require_once('./../Inc/Login.inc.php');  
if ($loggedUser->checkPermisson('MANAGE_USERS') === false){
$errorMessage = 'You are not allowed to access this page.';
require_once('./../Inc/error.php');
exit();   
}

$pageName = 'Admin User Management';
$pageDesc = '';
$pageIcon = '';
$pageAlign = 'center';
$pageClass = '';
 
//do we also need to delete a user
if(isset($_GET['action']) && $_GET['action'] == 'delete' && isset($_GET['id'])){  
	$id = (string) $_GET['id'];
	if(ctype_digit($id)){
		// Delete the access entry using PHPCPR
		$table = 'user_permission';
		$where = [
		'user_id' => $id
		];

	   // Execute delete using PHPCPR
		delete($table, [], $where, 1, 1);
	  
	  //We do not delete the user from the records
			
	  //In keeping with the PRG(http://en.wikipedia.org/wiki/Post/Redirect/Get), redirect after delete
	  $_SESSION['message']['useradd'] = "User access was deleted successfully";
	  header('Location: userManage.php');
	  exit();    
	}
} elseif (isset($_POST['action']) && $_POST['action'] == 'addMember') {
	$username = isset($_POST['member']) ? trim($_POST['member']) : '';
	if (strlen($username) > 0) {
	// Select query using PHPCPR
	$selectFields = 'ID';
	$mainTable = 'members';
	$where = [
	"Username" => $username // Ensure proper sanitization
	];

    // Execute select query using PHPCPR
    $result = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

    if (!empty($result)) {
        $row = $result[0];
        header('Location: editAdminUser.php?id=' . $row['ID']);
        exit();
    } else {
        $_SESSION['message']['useradd'] = "The member '$username' does not exist.";
    }       
  }
}     

require_once('./../Inc/Header.inc.php');

// KEEP THIS CODE BELOW HEADER!!
$selectFields = ['ID', 'Username', 'First_name', 'Last_name'];
$mainTable = 'members';
$joinConditions = [
    [
        'table' => 'user_permission',
        'as' => 'u',
        'condition' => 'members.ID = u.user_id'
    ]
];
$where = ['1'];
$groupBy = 'u.user_id';
$having = null;
$orderBy = null;
$limit = 0;
$show_debug = 1;

$result = select($selectFields, $mainTable, $joinConditions, $where, $groupBy, $having, $orderBy, $limit, $show_debug);

?>
   	<div class="col-md-4 col-md-offset-4" style="text-align:center">   
   <h1>Admin User Management</h1>
   <?php
   		if (isset($_SESSION['message']['useradd'])){
			  print $_SESSION['message']['useradd'] . '<br />';
			
			  unset($_SESSION['message']['useradd']);   
   		  }
		
    ?>
   <script type="text/javascript" src="../Js/user.js"></script>

<!--   <a href="addNewUser.php">Add New Admin User</a><br /><br />-->
   <form action="userManage.php" method="post" >
   
         <div class="form-group input-group">
            <span class="input-group-addon"><i class="fa fa-user"></i></span>
            <input class="form-control" type="text" placeholder="Enter Username" name="member" size="17" value="" onMouseover="this.focus()" required />          
          </div>   
    <input type="hidden" name="action" value="addMember" />
	<input type="submit" class="btn btn-info" name="addMember" value="Add Member" />
   </form>
   
   <div class="table-responsive">
   <table id="UserTable" class="col-md-4 table">
   	<tr>
   		<th>Username</th>
		<th>Name</th>
		<?php if (false && $loggedUser->checkPermisson('ADMINISTRATORS_STORES') === true) {?>
		<th>Stores</th>
		<?php }?>
		<th>Edit</th>
		<th>Delete</th>
    </tr>
	<?php foreach ($result as $row) { ?>
	<tr>
		<td><?php echo $row['Username'];?></td>
		<td><?php echo $row['First_name'] . ' ' . $row['Last_name'];?></td>
		<?php if (false && $loggedUser->checkPermisson('ADMINISTRATORS_STORES') === true) {?>
		<td><a class="btn btn-success btn-xs" href="editAdministratorsStores.php?id=<?php echo $row['ID'];?>">Stores</a></td>
		<?php }?>
		<td><a class="btn btn-info btn-xs" href="editAdminUser.php?id=<?php echo $row['ID'];?>">Edit</a></td>
		<td><a class="btn btn-danger btn-xs" href="userManage.php?action=delete&id=<?php print $row['ID']?>">Delete</a></td>	
	</tr>
	<?php } ?>
   </table>
   </div>   
   </div>
   
<div class="clearfix"></div>   

<?php
//print_r($row);
require_once('./../Inc/Footer.inc.php');
?>
