<?php
//-----------------------------------------------------------------
// Software: Automatic Web Software (AWS) built with PHPCPR
// Firm: DirectSalesMLM.com / AutomaticWebSoftware.com / PHPCPR.com
// Author: Jim Symonds Email: jim@directsalesmlm.com
// Copyright 2006 - 2024 Jim Symonds All Rights Reserved.
//-----------------------------------------------------------------
include './../Sub/Config.inc.php';
include './../phpcpr.php';
include './Inc/Login.inc.php';

if ($loggedUser->checkPermisson('ADD_PROGRAM') === false){
  $errorMessage = 'You are not allowed to access this page.';
  require_once('./../Inc/error.php');
  exit();   
}
include 'Lib/Pagination.function.php';
include './Inc/Header.inc.php';

//$GLOBALS['debug'] = true;
$live = 1;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   // print_r($_POST);
   // exit;
}


if (!empty($_POST['user_delete'])) {
    foreach ($_POST['user_delete'] as $user_delete) {
        // Sanitize each username
        $user_delete_sanitized = sanitize($user_delete, 'username');

		$whereConditions = [
			'ID' => ['>', 3],
			'status' => ['=', 'unpaid'],
			'Username' => $user_delete_sanitized
		];

		$selectFields = ['ID', 'Username', 'email'];
		$mainTable = 'members';
		$result = select($selectFields, $mainTable, [], $whereConditions, null, null, null, 0, 1);

		foreach ($result as $buffer) {
			
			$ID = $buffer['ID'];
			$user = $buffer['Username'];
			$email = $buffer['email'];	
				
			//echo 'Got inside loop!';	
			//echo '<pre>';
			//echo $buffer['Username'];
			//echo '</pre>';
					
			// Deleting records from various tables using the PHPCPR delete function
			delete('status_log', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
			// Uncomment the next line to perform deletion on `payment_log` table
			// delete('payment_log', [], ['payer_username' => ['=', $user]], null, $live, 1, 1);
			delete('member_link', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
			delete('member_log', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
			delete('members_change_log', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
			delete('support_tickets', [], ['username' => ['=', $user]], null, $live, 1, 1);
			delete('transactions_log', [], ['usrid' => ['=', $ID]], null, $live, 1, 1);
			delete('leaderboard_earnings', [], ['Username' => ['=', $user]], null, $live, 1, 1);
			delete('leaderboard', [], ['Username' => ['=', $user]], null, $live, 1, 1);
			delete('user_program', [], ['ID' => ['=', $ID]], null, $live, 1, 1);
			delete('e4_arb', [], ['id_paying' => ['=', $ID]], null, $live, 1, 1);
			delete('e4_history', [], ['id_paying' => ['=', $ID]], null, $live, 1, 1);
			delete('e4_log', [], ['id_paying' => ['=', $ID]], null, $live, 1, 1);

			// Selecting records from the `payment_plan` table
			$selectFields = ['user_payment_plan_id', 'payment_plan_id'];
			$mainTable = 'payment_plan';
			$where = ['payer_username' => ['=', $user]];
			$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

			// Assuming $result2 is fetched as an associative array
			foreach ($result2 as $buffer2) {
				$upp = $buffer2['user_payment_plan_id'];
				$pp = $buffer2['payment_plan_id'];
				
				// Deleting records from `payment_plan`, `user_custom_plan`, and `user_payment_plan` tables
				delete('payment_plan', [], ['payment_plan_id' => ['=', $pp]], null, $live, 1, 1);
				delete('user_custom_plan', [], ['payment_plan_id' => ['=', $pp]], null, $live, 1, 1);
				delete('user_payment_plan', [], ['user_payment_plan_id' => ['=', $upp]], null, $live, 1, 1);
			}
					

			// Selecting records from the `ar_member_master` table
			$selectFields = ['ar_member_master_id'];
			$mainTable = 'ar_member_master';
			$where = ['ID' => ['=', $ID]];
			$result2 = select($selectFields, $mainTable, [], $where, null, null, null, 0, 1);

			foreach ($result2 as $buffer2) {
				$ar_member_master_id = $buffer2['ar_member_master_id'];
				
				delete('ar_member_email', [], ['ar_member_master_id' => ['=', $ar_member_master_id]], null, $live, 1, 1);
				delete('ar_member_master', [], ['ar_member_master_id' => ['=', $ar_member_master_id]], null, $live, 1, 1);
			}

			// Deleting records from `ar_leads` and `members` tables
			delete('ar_leads', [], ['ar_leads_email' => ['=', $email]], null, $live, 1, 1);
			delete('members', [], ['ID' => ['=', $ID]], null, $live, 1, 1);

			
		} // END DELETE LOOP!	
    }
    // Redirect or display a success message
}



/*$where = [
    'first_name' => ['REGEXP', '[a-zA-Z]*(.)\\1{2,}[a-zA-Z]*'], // Pattern matching repeated characters in first name
];*/

//$where = ['1'];

$where = ['status' => ['=', 'unpaid']];

if (isset($_GET['ip']) && $_GET['ip'] != '') {
	$where['ip'] = ['=', $_GET['ip']];
	$ip = $_GET['ip'];
} else {
	$ip = '';
}
	
if (isset($_GET['sponsor']) && $_GET['sponsor'] != '') {
	$where['sponsorid'] = ['=', $_GET['sponsor']];
	$sponsor = $_GET['sponsor'];
} else {
	$sponsor = '';
}	

// USE FOR MANUAL SPECIAL CASES!
//$where = ['Username' => ['LIKE', '%%']];

// Fetching data from the database
$selectFields = 'ID, Username, First_Name, Last_Name, email, sponsorid, ip, Signdate';
$mainTable = 'members';

$result = select($selectFields, $mainTable, [], $where, null, null, 'Signdate DESC', 0, 1);

$rows = ($result && count($result) > 0) ? count($result) : 0;

//the styling of the results table
$nr = 1;
$color[0] = 'FFFFFF';
$color[1] = 'F0F0F0';
$color[2] = '#abf5bc'; // PAID

//paging params
$thisPage = basename($_SERVER['PHP_SELF']);
$thisPage = htmlspecialchars($thisPage, ENT_QUOTES, 'UTF-8'); 
$results_per_page = 25;
$total_pages = ceil($rows/$results_per_page);
$page = (isset($_GET['page']) && ctype_digit((string)$_GET['page']) ? $_GET['page']:1);
if ($page > $total_pages && $total_pages > 0) {
	$page = $total_pages;
} elseif ($page < 1) {
	$page = 1;
}

$offset = ($page - 1) * $results_per_page;

// Using limit as an array
$limit= ['count' => $results_per_page, 'offset' => $offset]; 

$result = select($selectFields, $mainTable, [], $where, null, null, 'Signdate DESC', $limit, 1);

echo '<h2>Total Unpaid Results: '.$rows.'</h2>';

echo '<form action="" method="post">';
echo '<table class="table" style="width:90%; margin: auto; text-align: left">';
echo '<thead class="thead-light">';
echo '<tr>';
echo '<th>ID</th>';
echo '<th>Username</th>';
echo '<th>First Name</th>';
echo '<th>Last Name</th>';
echo '<th>Email</th>';
echo '<th>Sponsor</th>';
echo '<th>IP Address</th>';
echo '<th>Signdate</th>';
echo '<th>Select</th>';
echo '</tr>';
echo '</thead>';
echo '<tbody>';
//$nr = 0;
foreach ($result as $index => $row) {
	
    $//zebra = $index % 2 == 0 ? 'table-light' : '';
	
	$bg_color = ($nr % 2 == 0) ? $color[0] : $color[1]; 

    if ($buffer['Status'] == 'paid') {
        $bg_color = $color[2]; // Change background color for paid members
    }
	echo "<tr style='bgcolor: {$bg_color}'>";	
    //echo "<tr class='{$zebra}'>";
	echo "<td>{$row['ID']}</td>";	
    echo "<td>{$row['email']}</td>";
    echo "<td>{$row['First_Name']}</td>";
    echo "<td>{$row['Last_Name']}</td>";
	echo '<td><a href="/admin/Sub/Finduser.php?username=' . htmlentities($row['Username']) . '" target="_blank">' . htmlentities($row['Username']) . '</a></td>';
    //echo "<td>{$row['sponsorid']}</td>";
	echo '<td><a href="delete_users.php?page=1&sponsor=' . htmlspecialchars($row['sponsorid']) . '" target="_blank">' . htmlspecialchars($row['sponsorid']) . '</a></td>';
	
    //echo "<td>{$row['ip']}</td>";	
	//echo '<td><a href="delete_users.php?page=1&ip=' . htmlspecialchars($row['ip']) . '" target="_blank">' . htmlspecialchars($row['ip']) . '</a></td>';
	
	echo '<td><a href="delete_users.php?page=1&ip=' . htmlspecialchars($row['ip']) . '" target="_blank">' . htmlspecialchars($row['ip']) . '</a> <a href="#" onclick="copyToClipboard(\'' . htmlspecialchars($row['ip']) . '\');return false;">Copy</a></td>';
	
	
    echo "<td>{$row['Signdate']}</td>";	
    //echo '<td><input type="checkbox" name="user_delete[]" value="' . htmlspecialchars($row['Username']) . '"></td>';
	//echo '<td><input type="checkbox" name="user_delete[]" value="' . htmlspecialchars($row['Username']) . '" onmouseover="this.checked=true;"></td>';
	//echo '<td><input type="checkbox" name="user_delete[]" value="' . htmlspecialchars($row['Username']) . '" onmouseover="this.checked=true;" style="transform: scale(2);"></td>';
	echo '<td><input type="checkbox" name="user_delete[]" value="' . htmlspecialchars($row['Username']) . '" onmouseover="toggleCheckbox(this);" style="transform: scale(2);"></td>';
	

    echo '</tr>';
	$nr++;
}
?>

<tr>
	<td colspan="5" align="right"><?php echo pagination_links($page, $total_pages, 6, $thisPage.'?ip='.$ip.'&sponsor='.$sponsor.'&', array('page' => 'Page', 'first' => 'first', 'last' => 'last')); ?></td>
	
	
	
	
	<td></td>
	<td colspan="3">
	<a href="#" onclick="event.preventDefault(); toggleAllCheckboxes();" style="text-decoration: none; padding: 10px; background-color: blue; color: white; border-radius: 5px; cursor: pointer;">Check / Uncheck All</a>

	</td>
</tr>

<?php
echo '</tbody>';
echo '</table>';
echo '<button type="submit" class="btn btn-danger">Delete Selected</button>';
echo '</form>';
?>

<!--
<script>
document.querySelector('form').onsubmit = function(e) {
    var checked = document.querySelectorAll('input[type="checkbox"]:checked').length;
    if (!checked) {
        alert('Please select at least one user to delete.');
        e.preventDefault();
    } else {
        var confirmDeletion = confirm('Are you sure you want to delete selected users?');
        if (!confirmDeletion) {
            e.preventDefault();
        }
    }
};
</script>
-->

<script>
function toggleCheckbox(element) {
    element.checked = !element.checked;
}
</script>

<script>
var checkState = false; // False means the next click will check all boxes, true means uncheck.

function toggleAllCheckboxes() {
    var checkboxes = document.querySelectorAll('input[name="user_delete[]"]');
    checkboxes.forEach(function(checkbox) {
        checkbox.checked = !checkState;
    });
    checkState = !checkState; // Invert the checkState for the next action
}
</script>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Copying to clipboard was successful!');
    }, function(err) {
        alert('Could not copy text: ', err);
    });
}
</script>


<?php
include './Inc/Footer.inc.php';
?>
